
/*
 * This is an auto-generated file.
 * Do not edit! All changes made to it will be lost.
 */


#ifndef AKONADI_ENTITIES_H
#define AKONADI_ENTITIES_H
#include "storage/entity.h"

#include <private/tristate_p.h>

#include <QtCore/QDebug>
#include <QtCore/QSharedDataPointer>
#include <QtCore/QString>
#include <QtCore/QVariant>
#include <QtCore/QStringList>
template <typename T> class QList;

class QSqlQuery;

namespace Akonadi {
namespace Server {

// forward declaration for table classes

class SchemaVersion;

class Resource;

class Collection;

class MimeType;

class PimItem;

class Flag;

class PartType;

class Part;

class CollectionAttribute;

class TagType;

class Tag;

class TagAttribute;

class TagRemoteIdResourceRelation;


// forward declaration for relation classes

class PimItemFlagRelation;

class PimItemTagRelation;

class CollectionMimeTypeRelation;

class CollectionPimItemRelation;


/**
  Representation of a record in the SchemaVersion table.
  
  <br>
  Contains the schema version of the database.
  This class is implicitly shared.
*/
class SchemaVersion : private Entity
{
    friend class DataStore;

public:
    /// List of SchemaVersion records.
    typedef QList<SchemaVersion> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    

    // constructor
    SchemaVersion();
    explicit SchemaVersion(
    int version, int generation );
    SchemaVersion(const SchemaVersion &other);

    // destructor
    ~SchemaVersion();

    /// assignment operator
    SchemaVersion &operator=(const SchemaVersion &other);

    /// comparison operator, compares ids, not content
    bool operator==(const SchemaVersion &other) const;

    // accessor methods
    
    /**
      Returns the value of the version column of this record.
      
    */
    int version() const;
    /**
      Sets the value of the version column of this record.
      
    */
    void 
setVersion(int version)
;
    
    /**
      Returns the value of the generation column of this record.
      
    */
    int generation() const;
    /**
      Sets the value of the generation column of this record.
      
    */
    void 
setGeneration(int generation)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString versionColumn();
    static QString versionFullColumnName();
    
    static QString generationColumn();
    static QString generationFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static SchemaVersion extractEntity(const QSqlQuery &query);
    static SchemaVersion extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of SchemaVersion records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<SchemaVersion> extractResult(QSqlQuery &query);
    static QList<SchemaVersion> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    

    // data retrieval
    

    /** Retrieve all records from this table. */
    static SchemaVersion::List retrieveAll();
    static SchemaVersion::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static SchemaVersion::List retrieveFiltered(const QString &key, const QVariant &value);
    static SchemaVersion::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    

    // data retrieval for n:m relations
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};


/**
  Representation of a record in the Resource table.
  
  This class is implicitly shared.
*/
class Resource : private Entity
{
    friend class DataStore;

public:
    /// List of Resource records.
    typedef QList<Resource> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    

    // constructor
    Resource();
    explicit Resource(
    const QString &name, bool isVirtual );
    
    explicit Resource(
    qint64 id, const QString &name, bool isVirtual );
    Resource(const Resource &other);

    // destructor
    ~Resource();

    /// assignment operator
    Resource &operator=(const Resource &other);

    /// comparison operator, compares ids, not content
    bool operator==(const Resource &other) const;

    // accessor methods
    
    /**
      Returns the value of the name column of this record.
      
    */
    QString name() const;
    /**
      Sets the value of the name column of this record.
      
    */
    void 
setName(const QString &name)
;
    
    /**
      Returns the value of the isVirtual column of this record.
      
    */
    bool isVirtual() const;
    /**
      Sets the value of the isVirtual column of this record.
      
    */
    void 
setIsVirtual(bool isVirtual)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString idColumn();
    static QString idFullColumnName();
    
    static QString nameColumn();
    static QString nameFullColumnName();
    
    static QString isVirtualColumn();
    static QString isVirtualFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static Resource extractEntity(const QSqlQuery &query);
    static Resource extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of Resource records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<Resource> extractResult(QSqlQuery &query);
    static QList<Resource> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    
    /** Checks if a record with id @p id exists. */
    static bool exists(qint64 id);
    static bool exists(DataStore *store, qint64 id);
    
    /** Checks if a record with name @name exists. */
    static bool exists(const QString &name);
    static bool exists(DataStore *store, const QString &name);
    

    // data retrieval
    
    /** Returns the record with id @p id. */
    static Resource retrieveById(qint64 id);
    static Resource retrieveById(DataStore *store, qint64 id);
    
    /** Returns the record with name @p name. */
    static Resource retrieveByName(const QString &name);
    static Resource retrieveByName(DataStore *store, const QString &name);

    /** Returns the record with name @p name. If such record does not exist,
        it will be created. This method is thread-safe, so if multiple callers
        call it on non-existent name, only one will create the new record, others
        will wait and read it from the cache. */
    static Resource retrieveByNameOrCreate(const QString &name);
    static Resource retrieveByNameOrCreate(DataStore *store, const QString &name);
    

    /** Retrieve all records from this table. */
    static Resource::List retrieveAll();
    static Resource::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static Resource::List retrieveFiltered(const QString &key, const QVariant &value);
    static Resource::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    
    /**
      Retrieve a list of all Collection records referring to this record
      in their column resourceId.
    */
    QList<Collection> collections() const;
    QList<Collection> collections(DataStore *store) const;
    

    // data retrieval for n:m relations
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    
    /** Deletes this record. */
    bool remove();
    bool remove(DataStore *store);

    /** Deletes the record with the given id. */
    static bool remove(qint64 id);
    static bool remove(DataStore *store, qint64 id);
    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};


/**
  Representation of a record in the Collection table.
  
  This class is implicitly shared.
*/
class Collection : private Entity
{
    friend class DataStore;

public:
    /// List of Collection records.
    typedef QList<Collection> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    
    enum Tristate {
      False,
      True,
      Undefined,
      
    };
    

    // constructor
    Collection();
    explicit Collection(
    const QString &remoteId, const QString &remoteRevision, const QString &name, qint64 parentId, qint64 resourceId, bool enabled, Collection::Tristate syncPref, Collection::Tristate displayPref, Collection::Tristate indexPref, bool cachePolicyInherit, int cachePolicyCheckInterval, int cachePolicyCacheTimeout, bool cachePolicySyncOnDemand, const QString &cachePolicyLocalParts, const QString &queryString, const QString &queryAttributes, const QString &queryCollections, bool isVirtual );
    
    explicit Collection(
    qint64 id, const QString &remoteId, const QString &remoteRevision, const QString &name, qint64 parentId, qint64 resourceId, bool enabled, Collection::Tristate syncPref, Collection::Tristate displayPref, Collection::Tristate indexPref, bool cachePolicyInherit, int cachePolicyCheckInterval, int cachePolicyCacheTimeout, bool cachePolicySyncOnDemand, const QString &cachePolicyLocalParts, const QString &queryString, const QString &queryAttributes, const QString &queryCollections, bool isVirtual );
    Collection(const Collection &other);

    // destructor
    ~Collection();

    /// assignment operator
    Collection &operator=(const Collection &other);

    /// comparison operator, compares ids, not content
    bool operator==(const Collection &other) const;

    // accessor methods
    
    /**
      Returns the value of the remoteId column of this record.
      
    */
    QString remoteId() const;
    /**
      Sets the value of the remoteId column of this record.
      
    */
    void 
setRemoteId(const QString &remoteId)
;
    
    /**
      Returns the value of the remoteRevision column of this record.
      
    */
    QString remoteRevision() const;
    /**
      Sets the value of the remoteRevision column of this record.
      
    */
    void 
setRemoteRevision(const QString &remoteRevision)
;
    
    /**
      Returns the value of the name column of this record.
      
    */
    QString name() const;
    /**
      Sets the value of the name column of this record.
      
    */
    void 
setName(const QString &name)
;
    
    /**
      Returns the value of the parentId column of this record.
      
    */
    qint64 parentId() const;
    /**
      Sets the value of the parentId column of this record.
      
    */
    void 
setParentId(qint64 parentId)
;
    
    /**
      Returns the value of the resourceId column of this record.
      
    */
    qint64 resourceId() const;
    /**
      Sets the value of the resourceId column of this record.
      
    */
    void 
setResourceId(qint64 resourceId)
;
    
    /**
      Returns the value of the enabled column of this record.
      
    */
    bool enabled() const;
    /**
      Sets the value of the enabled column of this record.
      
    */
    void 
setEnabled(bool enabled)
;
    
    /**
      Returns the value of the syncPref column of this record.
      
    */
    Collection::Tristate syncPref() const;
    /**
      Sets the value of the syncPref column of this record.
      
    */
    void 
setSyncPref(Collection::Tristate syncPref)
;
    
    /**
      Returns the value of the displayPref column of this record.
      
    */
    Collection::Tristate displayPref() const;
    /**
      Sets the value of the displayPref column of this record.
      
    */
    void 
setDisplayPref(Collection::Tristate displayPref)
;
    
    /**
      Returns the value of the indexPref column of this record.
      
    */
    Collection::Tristate indexPref() const;
    /**
      Sets the value of the indexPref column of this record.
      
    */
    void 
setIndexPref(Collection::Tristate indexPref)
;
    
    /**
      Returns the value of the cachePolicyInherit column of this record.
      
    */
    bool cachePolicyInherit() const;
    /**
      Sets the value of the cachePolicyInherit column of this record.
      
    */
    void 
setCachePolicyInherit(bool cachePolicyInherit)
;
    
    /**
      Returns the value of the cachePolicyCheckInterval column of this record.
      
    */
    int cachePolicyCheckInterval() const;
    /**
      Sets the value of the cachePolicyCheckInterval column of this record.
      
    */
    void 
setCachePolicyCheckInterval(int cachePolicyCheckInterval)
;
    
    /**
      Returns the value of the cachePolicyCacheTimeout column of this record.
      
    */
    int cachePolicyCacheTimeout() const;
    /**
      Sets the value of the cachePolicyCacheTimeout column of this record.
      
    */
    void 
setCachePolicyCacheTimeout(int cachePolicyCacheTimeout)
;
    
    /**
      Returns the value of the cachePolicySyncOnDemand column of this record.
      
    */
    bool cachePolicySyncOnDemand() const;
    /**
      Sets the value of the cachePolicySyncOnDemand column of this record.
      
    */
    void 
setCachePolicySyncOnDemand(bool cachePolicySyncOnDemand)
;
    
    /**
      Returns the value of the cachePolicyLocalParts column of this record.
      
    */
    QString cachePolicyLocalParts() const;
    /**
      Sets the value of the cachePolicyLocalParts column of this record.
      
    */
    void 
setCachePolicyLocalParts(const QString &cachePolicyLocalParts)
;
    
    /**
      Returns the value of the queryString column of this record.
      
    */
    QString queryString() const;
    /**
      Sets the value of the queryString column of this record.
      
    */
    void 
setQueryString(const QString &queryString)
;
    
    /**
      Returns the value of the queryAttributes column of this record.
      
    */
    QString queryAttributes() const;
    /**
      Sets the value of the queryAttributes column of this record.
      
    */
    void 
setQueryAttributes(const QString &queryAttributes)
;
    
    /**
      Returns the value of the queryCollections column of this record.
      
    */
    QString queryCollections() const;
    /**
      Sets the value of the queryCollections column of this record.
      
    */
    void 
setQueryCollections(const QString &queryCollections)
;
    
    /**
      Returns the value of the isVirtual column of this record.
      
    */
    bool isVirtual() const;
    /**
      Sets the value of the isVirtual column of this record.
      
    */
    void 
setIsVirtual(bool isVirtual)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString idColumn();
    static QString idFullColumnName();
    
    static QString remoteIdColumn();
    static QString remoteIdFullColumnName();
    
    static QString remoteRevisionColumn();
    static QString remoteRevisionFullColumnName();
    
    static QString nameColumn();
    static QString nameFullColumnName();
    
    static QString parentIdColumn();
    static QString parentIdFullColumnName();
    
    static QString resourceIdColumn();
    static QString resourceIdFullColumnName();
    
    static QString enabledColumn();
    static QString enabledFullColumnName();
    
    static QString syncPrefColumn();
    static QString syncPrefFullColumnName();
    
    static QString displayPrefColumn();
    static QString displayPrefFullColumnName();
    
    static QString indexPrefColumn();
    static QString indexPrefFullColumnName();
    
    static QString cachePolicyInheritColumn();
    static QString cachePolicyInheritFullColumnName();
    
    static QString cachePolicyCheckIntervalColumn();
    static QString cachePolicyCheckIntervalFullColumnName();
    
    static QString cachePolicyCacheTimeoutColumn();
    static QString cachePolicyCacheTimeoutFullColumnName();
    
    static QString cachePolicySyncOnDemandColumn();
    static QString cachePolicySyncOnDemandFullColumnName();
    
    static QString cachePolicyLocalPartsColumn();
    static QString cachePolicyLocalPartsFullColumnName();
    
    static QString queryStringColumn();
    static QString queryStringFullColumnName();
    
    static QString queryAttributesColumn();
    static QString queryAttributesFullColumnName();
    
    static QString queryCollectionsColumn();
    static QString queryCollectionsFullColumnName();
    
    static QString isVirtualColumn();
    static QString isVirtualFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static Collection extractEntity(const QSqlQuery &query);
    static Collection extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of Collection records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<Collection> extractResult(QSqlQuery &query);
    static QList<Collection> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    
    /** Checks if a record with id @p id exists. */
    static bool exists(qint64 id);
    static bool exists(DataStore *store, qint64 id);
    
    /** Checks if a record with name @name exists. */
    static bool exists(const QString &name);
    static bool exists(DataStore *store, const QString &name);
    

    // data retrieval
    
    /** Returns the record with id @p id. */
    static Collection retrieveById(qint64 id);
    static Collection retrieveById(DataStore *store, qint64 id);
    
    /** Returns the record with name @p name. */
    static Collection retrieveByName(const QString &name);
    static Collection retrieveByName(DataStore *store, const QString &name);

    /** Returns the record with name @p name. If such record does not exist,
        it will be created. This method is thread-safe, so if multiple callers
        call it on non-existent name, only one will create the new record, others
        will wait and read it from the cache. */
    static Collection retrieveByNameOrCreate(const QString &name);
    static Collection retrieveByNameOrCreate(DataStore *store, const QString &name);
    

    /** Retrieve all records from this table. */
    static Collection::List retrieveAll();
    static Collection::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static Collection::List retrieveFiltered(const QString &key, const QVariant &value);
    static Collection::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    
    /**
      Retrieve the Collection record referred to by the
      parentId column of this record.
    */
    Collection parent() const;
    Collection parent(DataStore *store) const;

    /**
      Set the  Collection record referred to by the
      parentId column of this record.
    */
    void setParent
      (const Collection &value);
    
    /**
      Retrieve the Resource record referred to by the
      resourceId column of this record.
    */
    Resource resource() const;
    Resource resource(DataStore *store) const;

    /**
      Set the  Resource record referred to by the
      resourceId column of this record.
    */
    void setResource
      (const Resource &value);
    
    /**
      Retrieve a list of all Collection records referring to this record
      in their column parentId.
    */
    QList<Collection> children() const;
    QList<Collection> children(DataStore *store) const;
    
    /**
      Retrieve a list of all PimItem records referring to this record
      in their column collectionId.
    */
    QList<PimItem> items() const;
    QList<PimItem> items(DataStore *store) const;
    
    /**
      Retrieve a list of all CollectionAttribute records referring to this record
      in their column collectionId.
    */
    QList<CollectionAttribute> attributes() const;
    QList<CollectionAttribute> attributes(DataStore *store) const;
    

    // data retrieval for n:m relations
    
      QList<MimeType> mimeTypes() const;
      QList<MimeType> mimeTypes(DataStore *store) const;
    
      QList<PimItem> pimItems() const;
      QList<PimItem> pimItems(DataStore *store) const;
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    
    /** Deletes this record. */
    bool remove();
    bool remove(DataStore *store);

    /** Deletes the record with the given id. */
    static bool remove(qint64 id);
    static bool remove(DataStore *store, qint64 id);
    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    
    /**
      Checks whether this record is in a n:m relation with the MimeType @p value.
    */
    bool relatesToMimeType(const MimeType &value) const;
    bool relatesToMimeType(DataStore *store, const MimeType &value) const;
    static bool relatesToMimeType(qint64 leftId, qint64 rightId);
    static bool relatesToMimeType(DataStore *store, qint64 leftId, qint64 rightId);

    /**
      Adds a n:m relation between this record and the MimeType @p value.
    */
    bool addMimeType(const MimeType &value) const;
    bool addMimeType(DataStore *store, const MimeType &value) const;
    static bool addMimeType(qint64 leftId, qint64 rightId);
    static bool addMimeType(DataStore *store, qint64 leftId, qint64 rightId);

    /**
      Removes a n:m relation between this record and the MimeType @p value.
    */
    bool removeMimeType(const MimeType &value) const;
    bool removeMimeType(DataStore *store, const MimeType &value) const;
    static bool removeMimeType(qint64 leftId, qint64 rightId);
    static bool removeMimeType(DataStore *store, qint64 leftId, qint64 rightId);

    /**
      Removes all relations between this record and any MimeType.
    */
    bool clearMimeTypes() const;
    bool clearMimeTypes(DataStore *store) const;
    static bool clearMimeTypes(qint64 id);
    static bool clearMimeTypes(DataStore *store, qint64 id);
    
    /**
      Checks whether this record is in a n:m relation with the PimItem @p value.
    */
    bool relatesToPimItem(const PimItem &value) const;
    bool relatesToPimItem(DataStore *store, const PimItem &value) const;
    static bool relatesToPimItem(qint64 leftId, qint64 rightId);
    static bool relatesToPimItem(DataStore *store, qint64 leftId, qint64 rightId);

    /**
      Adds a n:m relation between this record and the PimItem @p value.
    */
    bool addPimItem(const PimItem &value) const;
    bool addPimItem(DataStore *store, const PimItem &value) const;
    static bool addPimItem(qint64 leftId, qint64 rightId);
    static bool addPimItem(DataStore *store, qint64 leftId, qint64 rightId);

    /**
      Removes a n:m relation between this record and the PimItem @p value.
    */
    bool removePimItem(const PimItem &value) const;
    bool removePimItem(DataStore *store, const PimItem &value) const;
    static bool removePimItem(qint64 leftId, qint64 rightId);
    static bool removePimItem(DataStore *store, qint64 leftId, qint64 rightId);

    /**
      Removes all relations between this record and any PimItem.
    */
    bool clearPimItems() const;
    bool clearPimItems(DataStore *store) const;
    static bool clearPimItems(qint64 id);
    static bool clearPimItems(DataStore *store, qint64 id);
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};


/**
  Representation of a record in the MimeType table.
  
  <br>
  This meta data is stored inside akonadi to provide fast access.
  This class is implicitly shared.
*/
class MimeType : private Entity
{
    friend class DataStore;

public:
    /// List of MimeType records.
    typedef QList<MimeType> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    

    // constructor
    MimeType();
    explicit MimeType(
    const QString &name );
    
    explicit MimeType(
    qint64 id, const QString &name );
    MimeType(const MimeType &other);

    // destructor
    ~MimeType();

    /// assignment operator
    MimeType &operator=(const MimeType &other);

    /// comparison operator, compares ids, not content
    bool operator==(const MimeType &other) const;

    // accessor methods
    
    /**
      Returns the value of the name column of this record.
      
    */
    QString name() const;
    /**
      Sets the value of the name column of this record.
      
    */
    void 
setName(const QString &name)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString idColumn();
    static QString idFullColumnName();
    
    static QString nameColumn();
    static QString nameFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static MimeType extractEntity(const QSqlQuery &query);
    static MimeType extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of MimeType records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<MimeType> extractResult(QSqlQuery &query);
    static QList<MimeType> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    
    /** Checks if a record with id @p id exists. */
    static bool exists(qint64 id);
    static bool exists(DataStore *store, qint64 id);
    
    /** Checks if a record with name @name exists. */
    static bool exists(const QString &name);
    static bool exists(DataStore *store, const QString &name);
    

    // data retrieval
    
    /** Returns the record with id @p id. */
    static MimeType retrieveById(qint64 id);
    static MimeType retrieveById(DataStore *store, qint64 id);
    
    /** Returns the record with name @p name. */
    static MimeType retrieveByName(const QString &name);
    static MimeType retrieveByName(DataStore *store, const QString &name);

    /** Returns the record with name @p name. If such record does not exist,
        it will be created. This method is thread-safe, so if multiple callers
        call it on non-existent name, only one will create the new record, others
        will wait and read it from the cache. */
    static MimeType retrieveByNameOrCreate(const QString &name);
    static MimeType retrieveByNameOrCreate(DataStore *store, const QString &name);
    

    /** Retrieve all records from this table. */
    static MimeType::List retrieveAll();
    static MimeType::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static MimeType::List retrieveFiltered(const QString &key, const QVariant &value);
    static MimeType::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    

    // data retrieval for n:m relations
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    
    /** Deletes this record. */
    bool remove();
    bool remove(DataStore *store);

    /** Deletes the record with the given id. */
    static bool remove(qint64 id);
    static bool remove(DataStore *store, qint64 id);
    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};


/**
  Representation of a record in the PimItem table.
  
  This class is implicitly shared.
*/
class PimItem : private Entity
{
    friend class DataStore;

public:
    /// List of PimItem records.
    typedef QList<PimItem> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    

    // constructor
    PimItem();
    explicit PimItem(
    int rev, const QString &remoteId, const QString &remoteRevision, const QString &gid, qint64 collectionId, qint64 mimeTypeId, const QDateTime &datetime, const QDateTime &atime, bool dirty, qint64 size );
    
    explicit PimItem(
    qint64 id, int rev, const QString &remoteId, const QString &remoteRevision, const QString &gid, qint64 collectionId, qint64 mimeTypeId, const QDateTime &datetime, const QDateTime &atime, bool dirty, qint64 size );
    PimItem(const PimItem &other);

    // destructor
    ~PimItem();

    /// assignment operator
    PimItem &operator=(const PimItem &other);

    /// comparison operator, compares ids, not content
    bool operator==(const PimItem &other) const;

    // accessor methods
    
    /**
      Returns the value of the rev column of this record.
      
    */
    int rev() const;
    /**
      Sets the value of the rev column of this record.
      
    */
    void 
setRev(int rev)
;
    
    /**
      Returns the value of the remoteId column of this record.
      
    */
    QString remoteId() const;
    /**
      Sets the value of the remoteId column of this record.
      
    */
    void 
setRemoteId(const QString &remoteId)
;
    
    /**
      Returns the value of the remoteRevision column of this record.
      
    */
    QString remoteRevision() const;
    /**
      Sets the value of the remoteRevision column of this record.
      
    */
    void 
setRemoteRevision(const QString &remoteRevision)
;
    
    /**
      Returns the value of the gid column of this record.
      
    */
    QString gid() const;
    /**
      Sets the value of the gid column of this record.
      
    */
    void 
setGid(const QString &gid)
;
    
    /**
      Returns the value of the collectionId column of this record.
      
    */
    qint64 collectionId() const;
    /**
      Sets the value of the collectionId column of this record.
      
    */
    void 
setCollectionId(qint64 collectionId)
;
    
    /**
      Returns the value of the mimeTypeId column of this record.
      
    */
    qint64 mimeTypeId() const;
    /**
      Sets the value of the mimeTypeId column of this record.
      
    */
    void 
setMimeTypeId(qint64 mimeTypeId)
;
    
    /**
      Returns the value of the datetime column of this record.
      create/modified time
    */
    QDateTime datetime() const;
    /**
      Sets the value of the datetime column of this record.
      create/modified time
    */
    void 
setDatetime(const QDateTime &datetime)
;
    
    /**
      Returns the value of the atime column of this record.
      read access time
    */
    QDateTime atime() const;
    /**
      Sets the value of the atime column of this record.
      read access time
    */
    void 
setAtime(const QDateTime &atime)
;
    
    /**
      Returns the value of the dirty column of this record.
      Indicates that this item has unsaved changes.
    */
    bool dirty() const;
    /**
      Sets the value of the dirty column of this record.
      Indicates that this item has unsaved changes.
    */
    void 
setDirty(bool dirty)
;
    
    /**
      Returns the value of the size column of this record.
      
    */
    qint64 size() const;
    /**
      Sets the value of the size column of this record.
      
    */
    void 
setSize(qint64 size)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString idColumn();
    static QString idFullColumnName();
    
    static QString revColumn();
    static QString revFullColumnName();
    
    static QString remoteIdColumn();
    static QString remoteIdFullColumnName();
    
    static QString remoteRevisionColumn();
    static QString remoteRevisionFullColumnName();
    
    static QString gidColumn();
    static QString gidFullColumnName();
    
    static QString collectionIdColumn();
    static QString collectionIdFullColumnName();
    
    static QString mimeTypeIdColumn();
    static QString mimeTypeIdFullColumnName();
    
    static QString datetimeColumn();
    static QString datetimeFullColumnName();
    
    static QString atimeColumn();
    static QString atimeFullColumnName();
    
    static QString dirtyColumn();
    static QString dirtyFullColumnName();
    
    static QString sizeColumn();
    static QString sizeFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static PimItem extractEntity(const QSqlQuery &query);
    static PimItem extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of PimItem records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<PimItem> extractResult(QSqlQuery &query);
    static QList<PimItem> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    
    /** Checks if a record with id @p id exists. */
    static bool exists(qint64 id);
    static bool exists(DataStore *store, qint64 id);
    

    // data retrieval
    
    /** Returns the record with id @p id. */
    static PimItem retrieveById(qint64 id);
    static PimItem retrieveById(DataStore *store, qint64 id);
    

    /** Retrieve all records from this table. */
    static PimItem::List retrieveAll();
    static PimItem::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static PimItem::List retrieveFiltered(const QString &key, const QVariant &value);
    static PimItem::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    
    /**
      Retrieve the Collection record referred to by the
      collectionId column of this record.
    */
    Collection collection() const;
    Collection collection(DataStore *store) const;

    /**
      Set the  Collection record referred to by the
      collectionId column of this record.
    */
    void setCollection
      (const Collection &value);
    
    /**
      Retrieve the MimeType record referred to by the
      mimeTypeId column of this record.
    */
    MimeType mimeType() const;
    MimeType mimeType(DataStore *store) const;

    /**
      Set the  MimeType record referred to by the
      mimeTypeId column of this record.
    */
    void setMimeType
      (const MimeType &value);
    
    /**
      Retrieve a list of all Part records referring to this record
      in their column pimItemId.
    */
    QList<Part> parts() const;
    QList<Part> parts(DataStore *store) const;
    

    // data retrieval for n:m relations
    
      QList<Flag> flags() const;
      QList<Flag> flags(DataStore *store) const;
    
      QList<Tag> tags() const;
      QList<Tag> tags(DataStore *store) const;
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    
    /** Deletes this record. */
    bool remove();
    bool remove(DataStore *store);

    /** Deletes the record with the given id. */
    static bool remove(qint64 id);
    static bool remove(DataStore *store, qint64 id);
    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    
    /**
      Checks whether this record is in a n:m relation with the Flag @p value.
    */
    bool relatesToFlag(const Flag &value) const;
    bool relatesToFlag(DataStore *store, const Flag &value) const;
    static bool relatesToFlag(qint64 leftId, qint64 rightId);
    static bool relatesToFlag(DataStore *store, qint64 leftId, qint64 rightId);

    /**
      Adds a n:m relation between this record and the Flag @p value.
    */
    bool addFlag(const Flag &value) const;
    bool addFlag(DataStore *store, const Flag &value) const;
    static bool addFlag(qint64 leftId, qint64 rightId);
    static bool addFlag(DataStore *store, qint64 leftId, qint64 rightId);

    /**
      Removes a n:m relation between this record and the Flag @p value.
    */
    bool removeFlag(const Flag &value) const;
    bool removeFlag(DataStore *store, const Flag &value) const;
    static bool removeFlag(qint64 leftId, qint64 rightId);
    static bool removeFlag(DataStore *store, qint64 leftId, qint64 rightId);

    /**
      Removes all relations between this record and any Flag.
    */
    bool clearFlags() const;
    bool clearFlags(DataStore *store) const;
    static bool clearFlags(qint64 id);
    static bool clearFlags(DataStore *store, qint64 id);
    
    /**
      Checks whether this record is in a n:m relation with the Tag @p value.
    */
    bool relatesToTag(const Tag &value) const;
    bool relatesToTag(DataStore *store, const Tag &value) const;
    static bool relatesToTag(qint64 leftId, qint64 rightId);
    static bool relatesToTag(DataStore *store, qint64 leftId, qint64 rightId);

    /**
      Adds a n:m relation between this record and the Tag @p value.
    */
    bool addTag(const Tag &value) const;
    bool addTag(DataStore *store, const Tag &value) const;
    static bool addTag(qint64 leftId, qint64 rightId);
    static bool addTag(DataStore *store, qint64 leftId, qint64 rightId);

    /**
      Removes a n:m relation between this record and the Tag @p value.
    */
    bool removeTag(const Tag &value) const;
    bool removeTag(DataStore *store, const Tag &value) const;
    static bool removeTag(qint64 leftId, qint64 rightId);
    static bool removeTag(DataStore *store, qint64 leftId, qint64 rightId);

    /**
      Removes all relations between this record and any Tag.
    */
    bool clearTags() const;
    bool clearTags(DataStore *store) const;
    static bool clearTags(qint64 id);
    static bool clearTags(DataStore *store, qint64 id);
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};


/**
  Representation of a record in the Flag table.
  
  <br>
  This meta data is stored inside akonadi to provide fast access.
  This class is implicitly shared.
*/
class Flag : private Entity
{
    friend class DataStore;

public:
    /// List of Flag records.
    typedef QList<Flag> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    

    // constructor
    Flag();
    explicit Flag(
    const QString &name );
    
    explicit Flag(
    qint64 id, const QString &name );
    Flag(const Flag &other);

    // destructor
    ~Flag();

    /// assignment operator
    Flag &operator=(const Flag &other);

    /// comparison operator, compares ids, not content
    bool operator==(const Flag &other) const;

    // accessor methods
    
    /**
      Returns the value of the name column of this record.
      
    */
    QString name() const;
    /**
      Sets the value of the name column of this record.
      
    */
    void 
setName(const QString &name)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString idColumn();
    static QString idFullColumnName();
    
    static QString nameColumn();
    static QString nameFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static Flag extractEntity(const QSqlQuery &query);
    static Flag extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of Flag records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<Flag> extractResult(QSqlQuery &query);
    static QList<Flag> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    
    /** Checks if a record with id @p id exists. */
    static bool exists(qint64 id);
    static bool exists(DataStore *store, qint64 id);
    
    /** Checks if a record with name @name exists. */
    static bool exists(const QString &name);
    static bool exists(DataStore *store, const QString &name);
    

    // data retrieval
    
    /** Returns the record with id @p id. */
    static Flag retrieveById(qint64 id);
    static Flag retrieveById(DataStore *store, qint64 id);
    
    /** Returns the record with name @p name. */
    static Flag retrieveByName(const QString &name);
    static Flag retrieveByName(DataStore *store, const QString &name);

    /** Returns the record with name @p name. If such record does not exist,
        it will be created. This method is thread-safe, so if multiple callers
        call it on non-existent name, only one will create the new record, others
        will wait and read it from the cache. */
    static Flag retrieveByNameOrCreate(const QString &name);
    static Flag retrieveByNameOrCreate(DataStore *store, const QString &name);
    

    /** Retrieve all records from this table. */
    static Flag::List retrieveAll();
    static Flag::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static Flag::List retrieveFiltered(const QString &key, const QVariant &value);
    static Flag::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    

    // data retrieval for n:m relations
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    
    /** Deletes this record. */
    bool remove();
    bool remove(DataStore *store);

    /** Deletes the record with the given id. */
    static bool remove(qint64 id);
    static bool remove(DataStore *store, qint64 id);
    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};


/**
  Representation of a record in the PartType table.
  
  <br>
  Table containing item part types.
  This class is implicitly shared.
*/
class PartType : private Entity
{
    friend class DataStore;

public:
    /// List of PartType records.
    typedef QList<PartType> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    

    // constructor
    PartType();
    explicit PartType(
    const QString &name, const QString &ns );
    
    explicit PartType(
    qint64 id, const QString &name, const QString &ns );
    PartType(const PartType &other);

    // destructor
    ~PartType();

    /// assignment operator
    PartType &operator=(const PartType &other);

    /// comparison operator, compares ids, not content
    bool operator==(const PartType &other) const;

    // accessor methods
    
    /**
      Returns the value of the name column of this record.
      Part name, without namespace.
    */
    QString name() const;
    /**
      Sets the value of the name column of this record.
      Part name, without namespace.
    */
    void 
setName(const QString &name)
;
    
    /**
      Returns the value of the ns column of this record.
      Part namespace.
    */
    QString ns() const;
    /**
      Sets the value of the ns column of this record.
      Part namespace.
    */
    void 
setNs(const QString &ns)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString idColumn();
    static QString idFullColumnName();
    
    static QString nameColumn();
    static QString nameFullColumnName();
    
    static QString nsColumn();
    static QString nsFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static PartType extractEntity(const QSqlQuery &query);
    static PartType extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of PartType records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<PartType> extractResult(QSqlQuery &query);
    static QList<PartType> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    
    /** Checks if a record with id @p id exists. */
    static bool exists(qint64 id);
    static bool exists(DataStore *store, qint64 id);
    
    /** Checks if a record with name @name exists. */
    static bool exists(const QString &name);
    static bool exists(DataStore *store, const QString &name);
    

    // data retrieval
    
    /** Returns the record with id @p id. */
    static PartType retrieveById(qint64 id);
    static PartType retrieveById(DataStore *store, qint64 id);
    static PartType retrieveByFQName(const QString &ns, const QString &name);static PartType retrieveByFQName(DataStore *store, const QString &ns, const QString &name);static PartType retrieveByFQNameOrCreate(const QString &ns, const QString &name);static PartType retrieveByFQNameOrCreate(DataStore *store, const QString &ns, const QString &name);

    /** Retrieve all records from this table. */
    static PartType::List retrieveAll();
    static PartType::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static PartType::List retrieveFiltered(const QString &key, const QVariant &value);
    static PartType::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    

    // data retrieval for n:m relations
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    
    /** Deletes this record. */
    bool remove();
    bool remove(DataStore *store);

    /** Deletes the record with the given id. */
    static bool remove(qint64 id);
    static bool remove(DataStore *store, qint64 id);
    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};


/**
  Representation of a record in the Part table.
  
  This class is implicitly shared.
*/
class Part : private Entity
{
    friend class DataStore;

public:
    /// List of Part records.
    typedef QList<Part> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    
    enum Storage {
      Internal,
      External,
      Foreign,
      
    };
    

    // constructor
    Part();
    explicit Part(
    qint64 pimItemId, qint64 partTypeId, const QByteArray &data, qint64 datasize, int version, Part::Storage storage );
    
    explicit Part(
    qint64 id, qint64 pimItemId, qint64 partTypeId, const QByteArray &data, qint64 datasize, int version, Part::Storage storage );
    Part(const Part &other);

    // destructor
    ~Part();

    /// assignment operator
    Part &operator=(const Part &other);

    /// comparison operator, compares ids, not content
    bool operator==(const Part &other) const;

    // accessor methods
    
    /**
      Returns the value of the pimItemId column of this record.
      
    */
    qint64 pimItemId() const;
    /**
      Sets the value of the pimItemId column of this record.
      
    */
    void 
setPimItemId(qint64 pimItemId)
;
    
    /**
      Returns the value of the partTypeId column of this record.
      
    */
    qint64 partTypeId() const;
    /**
      Sets the value of the partTypeId column of this record.
      
    */
    void 
setPartTypeId(qint64 partTypeId)
;
    
    /**
      Returns the value of the data column of this record.
      
    */
    QByteArray data() const;
    /**
      Sets the value of the data column of this record.
      
    */
    void 
setData(const QByteArray &data)
;
    
    /**
      Returns the value of the datasize column of this record.
      
    */
    qint64 datasize() const;
    /**
      Sets the value of the datasize column of this record.
      
    */
    void 
setDatasize(qint64 datasize)
;
    
    /**
      Returns the value of the version column of this record.
      
    */
    int version() const;
    /**
      Sets the value of the version column of this record.
      
    */
    void 
setVersion(int version)
;
    
    /**
      Returns the value of the storage column of this record.
      
    */
    Part::Storage storage() const;
    /**
      Sets the value of the storage column of this record.
      
    */
    void 
setStorage(Part::Storage storage)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString idColumn();
    static QString idFullColumnName();
    
    static QString pimItemIdColumn();
    static QString pimItemIdFullColumnName();
    
    static QString partTypeIdColumn();
    static QString partTypeIdFullColumnName();
    
    static QString dataColumn();
    static QString dataFullColumnName();
    
    static QString datasizeColumn();
    static QString datasizeFullColumnName();
    
    static QString versionColumn();
    static QString versionFullColumnName();
    
    static QString storageColumn();
    static QString storageFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static Part extractEntity(const QSqlQuery &query);
    static Part extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of Part records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<Part> extractResult(QSqlQuery &query);
    static QList<Part> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    
    /** Checks if a record with id @p id exists. */
    static bool exists(qint64 id);
    static bool exists(DataStore *store, qint64 id);
    

    // data retrieval
    
    /** Returns the record with id @p id. */
    static Part retrieveById(qint64 id);
    static Part retrieveById(DataStore *store, qint64 id);
    

    /** Retrieve all records from this table. */
    static Part::List retrieveAll();
    static Part::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static Part::List retrieveFiltered(const QString &key, const QVariant &value);
    static Part::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    
    /**
      Retrieve the PimItem record referred to by the
      pimItemId column of this record.
    */
    PimItem pimItem() const;
    PimItem pimItem(DataStore *store) const;

    /**
      Set the  PimItem record referred to by the
      pimItemId column of this record.
    */
    void setPimItem
      (const PimItem &value);
    
    /**
      Retrieve the PartType record referred to by the
      partTypeId column of this record.
    */
    PartType partType() const;
    PartType partType(DataStore *store) const;

    /**
      Set the  PartType record referred to by the
      partTypeId column of this record.
    */
    void setPartType
      (const PartType &value);
    

    // data retrieval for n:m relations
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    
    /** Deletes this record. */
    bool remove();
    bool remove(DataStore *store);

    /** Deletes the record with the given id. */
    static bool remove(qint64 id);
    static bool remove(DataStore *store, qint64 id);
    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};


/**
  Representation of a record in the CollectionAttribute table.
  
  This class is implicitly shared.
*/
class CollectionAttribute : private Entity
{
    friend class DataStore;

public:
    /// List of CollectionAttribute records.
    typedef QList<CollectionAttribute> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    

    // constructor
    CollectionAttribute();
    explicit CollectionAttribute(
    qint64 collectionId, const QByteArray &type, const QByteArray &value );
    
    explicit CollectionAttribute(
    qint64 id, qint64 collectionId, const QByteArray &type, const QByteArray &value );
    CollectionAttribute(const CollectionAttribute &other);

    // destructor
    ~CollectionAttribute();

    /// assignment operator
    CollectionAttribute &operator=(const CollectionAttribute &other);

    /// comparison operator, compares ids, not content
    bool operator==(const CollectionAttribute &other) const;

    // accessor methods
    
    /**
      Returns the value of the collectionId column of this record.
      
    */
    qint64 collectionId() const;
    /**
      Sets the value of the collectionId column of this record.
      
    */
    void 
setCollectionId(qint64 collectionId)
;
    
    /**
      Returns the value of the type column of this record.
      
    */
    QByteArray type() const;
    /**
      Sets the value of the type column of this record.
      
    */
    void 
setType(const QByteArray &type)
;
    
    /**
      Returns the value of the value column of this record.
      
    */
    QByteArray value() const;
    /**
      Sets the value of the value column of this record.
      
    */
    void 
setValue(const QByteArray &value)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString idColumn();
    static QString idFullColumnName();
    
    static QString collectionIdColumn();
    static QString collectionIdFullColumnName();
    
    static QString typeColumn();
    static QString typeFullColumnName();
    
    static QString valueColumn();
    static QString valueFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static CollectionAttribute extractEntity(const QSqlQuery &query);
    static CollectionAttribute extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of CollectionAttribute records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<CollectionAttribute> extractResult(QSqlQuery &query);
    static QList<CollectionAttribute> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    
    /** Checks if a record with id @p id exists. */
    static bool exists(qint64 id);
    static bool exists(DataStore *store, qint64 id);
    

    // data retrieval
    
    /** Returns the record with id @p id. */
    static CollectionAttribute retrieveById(qint64 id);
    static CollectionAttribute retrieveById(DataStore *store, qint64 id);
    

    /** Retrieve all records from this table. */
    static CollectionAttribute::List retrieveAll();
    static CollectionAttribute::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static CollectionAttribute::List retrieveFiltered(const QString &key, const QVariant &value);
    static CollectionAttribute::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    
    /**
      Retrieve the Collection record referred to by the
      collectionId column of this record.
    */
    Collection collection() const;
    Collection collection(DataStore *store) const;

    /**
      Set the  Collection record referred to by the
      collectionId column of this record.
    */
    void setCollection
      (const Collection &value);
    

    // data retrieval for n:m relations
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    
    /** Deletes this record. */
    bool remove();
    bool remove(DataStore *store);

    /** Deletes the record with the given id. */
    static bool remove(qint64 id);
    static bool remove(DataStore *store, qint64 id);
    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};


/**
  Representation of a record in the TagType table.
  
  This class is implicitly shared.
*/
class TagType : private Entity
{
    friend class DataStore;

public:
    /// List of TagType records.
    typedef QList<TagType> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    

    // constructor
    TagType();
    explicit TagType(
    const QString &name );
    
    explicit TagType(
    qint64 id, const QString &name );
    TagType(const TagType &other);

    // destructor
    ~TagType();

    /// assignment operator
    TagType &operator=(const TagType &other);

    /// comparison operator, compares ids, not content
    bool operator==(const TagType &other) const;

    // accessor methods
    
    /**
      Returns the value of the name column of this record.
      
    */
    QString name() const;
    /**
      Sets the value of the name column of this record.
      
    */
    void 
setName(const QString &name)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString idColumn();
    static QString idFullColumnName();
    
    static QString nameColumn();
    static QString nameFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static TagType extractEntity(const QSqlQuery &query);
    static TagType extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of TagType records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<TagType> extractResult(QSqlQuery &query);
    static QList<TagType> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    
    /** Checks if a record with id @p id exists. */
    static bool exists(qint64 id);
    static bool exists(DataStore *store, qint64 id);
    
    /** Checks if a record with name @name exists. */
    static bool exists(const QString &name);
    static bool exists(DataStore *store, const QString &name);
    

    // data retrieval
    
    /** Returns the record with id @p id. */
    static TagType retrieveById(qint64 id);
    static TagType retrieveById(DataStore *store, qint64 id);
    
    /** Returns the record with name @p name. */
    static TagType retrieveByName(const QString &name);
    static TagType retrieveByName(DataStore *store, const QString &name);

    /** Returns the record with name @p name. If such record does not exist,
        it will be created. This method is thread-safe, so if multiple callers
        call it on non-existent name, only one will create the new record, others
        will wait and read it from the cache. */
    static TagType retrieveByNameOrCreate(const QString &name);
    static TagType retrieveByNameOrCreate(DataStore *store, const QString &name);
    

    /** Retrieve all records from this table. */
    static TagType::List retrieveAll();
    static TagType::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static TagType::List retrieveFiltered(const QString &key, const QVariant &value);
    static TagType::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    

    // data retrieval for n:m relations
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    
    /** Deletes this record. */
    bool remove();
    bool remove(DataStore *store);

    /** Deletes the record with the given id. */
    static bool remove(qint64 id);
    static bool remove(DataStore *store, qint64 id);
    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};


/**
  Representation of a record in the Tag table.
  
  This class is implicitly shared.
*/
class Tag : private Entity
{
    friend class DataStore;

public:
    /// List of Tag records.
    typedef QList<Tag> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    

    // constructor
    Tag();
    explicit Tag(
    const QString &gid, qint64 parentId, qint64 typeId );
    
    explicit Tag(
    qint64 id, const QString &gid, qint64 parentId, qint64 typeId );
    Tag(const Tag &other);

    // destructor
    ~Tag();

    /// assignment operator
    Tag &operator=(const Tag &other);

    /// comparison operator, compares ids, not content
    bool operator==(const Tag &other) const;

    // accessor methods
    
    /**
      Returns the value of the gid column of this record.
      
    */
    QString gid() const;
    /**
      Sets the value of the gid column of this record.
      
    */
    void 
setGid(const QString &gid)
;
    
    /**
      Returns the value of the parentId column of this record.
      
    */
    qint64 parentId() const;
    /**
      Sets the value of the parentId column of this record.
      
    */
    void 
setParentId(qint64 parentId)
;
    
    /**
      Returns the value of the typeId column of this record.
      
    */
    qint64 typeId() const;
    /**
      Sets the value of the typeId column of this record.
      
    */
    void 
setTypeId(qint64 typeId)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString idColumn();
    static QString idFullColumnName();
    
    static QString gidColumn();
    static QString gidFullColumnName();
    
    static QString parentIdColumn();
    static QString parentIdFullColumnName();
    
    static QString typeIdColumn();
    static QString typeIdFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static Tag extractEntity(const QSqlQuery &query);
    static Tag extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of Tag records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<Tag> extractResult(QSqlQuery &query);
    static QList<Tag> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    
    /** Checks if a record with id @p id exists. */
    static bool exists(qint64 id);
    static bool exists(DataStore *store, qint64 id);
    

    // data retrieval
    
    /** Returns the record with id @p id. */
    static Tag retrieveById(qint64 id);
    static Tag retrieveById(DataStore *store, qint64 id);
    

    /** Retrieve all records from this table. */
    static Tag::List retrieveAll();
    static Tag::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static Tag::List retrieveFiltered(const QString &key, const QVariant &value);
    static Tag::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    
    /**
      Retrieve the Tag record referred to by the
      parentId column of this record.
    */
    Tag parent() const;
    Tag parent(DataStore *store) const;

    /**
      Set the  Tag record referred to by the
      parentId column of this record.
    */
    void setParent
      (const Tag &value);
    
    /**
      Retrieve the TagType record referred to by the
      typeId column of this record.
    */
    TagType tagType() const;
    TagType tagType(DataStore *store) const;

    /**
      Set the  TagType record referred to by the
      typeId column of this record.
    */
    void setTagType
      (const TagType &value);
    

    // data retrieval for n:m relations
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    
    /** Deletes this record. */
    bool remove();
    bool remove(DataStore *store);

    /** Deletes the record with the given id. */
    static bool remove(qint64 id);
    static bool remove(DataStore *store, qint64 id);
    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};


/**
  Representation of a record in the TagAttribute table.
  
  This class is implicitly shared.
*/
class TagAttribute : private Entity
{
    friend class DataStore;

public:
    /// List of TagAttribute records.
    typedef QList<TagAttribute> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    

    // constructor
    TagAttribute();
    explicit TagAttribute(
    qint64 tagId, const QByteArray &type, const QByteArray &value );
    
    explicit TagAttribute(
    qint64 id, qint64 tagId, const QByteArray &type, const QByteArray &value );
    TagAttribute(const TagAttribute &other);

    // destructor
    ~TagAttribute();

    /// assignment operator
    TagAttribute &operator=(const TagAttribute &other);

    /// comparison operator, compares ids, not content
    bool operator==(const TagAttribute &other) const;

    // accessor methods
    
    /**
      Returns the value of the tagId column of this record.
      
    */
    qint64 tagId() const;
    /**
      Sets the value of the tagId column of this record.
      
    */
    void 
setTagId(qint64 tagId)
;
    
    /**
      Returns the value of the type column of this record.
      
    */
    QByteArray type() const;
    /**
      Sets the value of the type column of this record.
      
    */
    void 
setType(const QByteArray &type)
;
    
    /**
      Returns the value of the value column of this record.
      
    */
    QByteArray value() const;
    /**
      Sets the value of the value column of this record.
      
    */
    void 
setValue(const QByteArray &value)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString idColumn();
    static QString idFullColumnName();
    
    static QString tagIdColumn();
    static QString tagIdFullColumnName();
    
    static QString typeColumn();
    static QString typeFullColumnName();
    
    static QString valueColumn();
    static QString valueFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static TagAttribute extractEntity(const QSqlQuery &query);
    static TagAttribute extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of TagAttribute records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<TagAttribute> extractResult(QSqlQuery &query);
    static QList<TagAttribute> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    
    /** Checks if a record with id @p id exists. */
    static bool exists(qint64 id);
    static bool exists(DataStore *store, qint64 id);
    

    // data retrieval
    
    /** Returns the record with id @p id. */
    static TagAttribute retrieveById(qint64 id);
    static TagAttribute retrieveById(DataStore *store, qint64 id);
    

    /** Retrieve all records from this table. */
    static TagAttribute::List retrieveAll();
    static TagAttribute::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static TagAttribute::List retrieveFiltered(const QString &key, const QVariant &value);
    static TagAttribute::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    
    /**
      Retrieve the Tag record referred to by the
      tagId column of this record.
    */
    Tag tag() const;
    Tag tag(DataStore *store) const;

    /**
      Set the  Tag record referred to by the
      tagId column of this record.
    */
    void setTag
      (const Tag &value);
    

    // data retrieval for n:m relations
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    
    /** Deletes this record. */
    bool remove();
    bool remove(DataStore *store);

    /** Deletes the record with the given id. */
    static bool remove(qint64 id);
    static bool remove(DataStore *store, qint64 id);
    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};


/**
  Representation of a record in the TagRemoteIdResourceRelation table.
  
  This class is implicitly shared.
*/
class TagRemoteIdResourceRelation : private Entity
{
    friend class DataStore;

public:
    /// List of TagRemoteIdResourceRelation records.
    typedef QList<TagRemoteIdResourceRelation> List;

    // make some stuff accessible from Entity:
    using Entity::Id;
    using Entity::id;
    using Entity::setId;
    using Entity::isValid;
    using Entity::joinByName;
    using Entity::addToRelation;
    using Entity::removeFromRelation;

    

    // constructor
    TagRemoteIdResourceRelation();
    explicit TagRemoteIdResourceRelation(
    qint64 tagId, qint64 resourceId, const QString &remoteId );
    TagRemoteIdResourceRelation(const TagRemoteIdResourceRelation &other);

    // destructor
    ~TagRemoteIdResourceRelation();

    /// assignment operator
    TagRemoteIdResourceRelation &operator=(const TagRemoteIdResourceRelation &other);

    /// comparison operator, compares ids, not content
    bool operator==(const TagRemoteIdResourceRelation &other) const;

    // accessor methods
    
    /**
      Returns the value of the tagId column of this record.
      
    */
    qint64 tagId() const;
    /**
      Sets the value of the tagId column of this record.
      
    */
    void 
setTagId(qint64 tagId)
;
    
    /**
      Returns the value of the resourceId column of this record.
      
    */
    qint64 resourceId() const;
    /**
      Sets the value of the resourceId column of this record.
      
    */
    void 
setResourceId(qint64 resourceId)
;
    
    /**
      Returns the value of the remoteId column of this record.
      
    */
    QString remoteId() const;
    /**
      Sets the value of the remoteId column of this record.
      
    */
    void 
setRemoteId(const QString &remoteId)
;
    

    /** Returns the name of the SQL table. */
    static QString tableName();

    /**
      Returns a list of all SQL column names. The names are in the correct
      order for usage with extractResult().
    */
    static QStringList columnNames();

    /**
      Returns a list of all SQL column names prefixed with their tables names.
      The names are in the correct order for usage with extractResult().
    */
    static QStringList fullColumnNames();

    
    static QString tagIdColumn();
    static QString tagIdFullColumnName();
    
    static QString resourceIdColumn();
    static QString resourceIdFullColumnName();
    
    static QString remoteIdColumn();
    static QString remoteIdFullColumnName();
    

    /**
      Extracts single entity from the current query result.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static TagRemoteIdResourceRelation extractEntity(const QSqlQuery &query);
    static TagRemoteIdResourceRelation extractEntity(DataStore *dataStore, const QSqlQuery &query);

    /**
      Extracts the query result.
      @param query A executed query containing a list of TagRemoteIdResourceRelation records.
      Note that the fields need to be in the correct order (same as in the constructor)!
    */
    static QList<TagRemoteIdResourceRelation> extractResult(QSqlQuery &query);
    static QList<TagRemoteIdResourceRelation> extractResult(DataStore *dataStore, QSqlQuery &query);

    /** Count records with value @p value in column @p column. */
    static int count(const QString &column, const QVariant &value);
    static int count(DataStore *store, const QString &column, const QVariant &value);

    // check existence
    

    // data retrieval
    

    /** Retrieve all records from this table. */
    static TagRemoteIdResourceRelation::List retrieveAll();
    static TagRemoteIdResourceRelation::List retrieveAll(DataStore *store);
    /** Retrieve all records with value @p value in column @p key. */
    static TagRemoteIdResourceRelation::List retrieveFiltered(const QString &key, const QVariant &value);
    static TagRemoteIdResourceRelation::List retrieveFiltered(DataStore *store, const QString &key, const QVariant &value);

    
    /**
      Retrieve the Tag record referred to by the
      tagId column of this record.
    */
    Tag tag() const;
    Tag tag(DataStore *store) const;

    /**
      Set the  Tag record referred to by the
      tagId column of this record.
    */
    void setTag
      (const Tag &value);
    
    /**
      Retrieve the Resource record referred to by the
      resourceId column of this record.
    */
    Resource resource() const;
    Resource resource(DataStore *store) const;

    /**
      Set the  Resource record referred to by the
      resourceId column of this record.
    */
    void setResource
      (const Resource &value);
    

    // data retrieval for n:m relations
    

    /**
      Inserts this record into the DataStore.
      @param insertId pointer to an int, filled with the identifier of this record on success.
    */
    bool insert(qint64 *insertId = nullptr);
    bool insert(DataStore *store, qint64 *insertId = nullptr);

    /**
      Returns @c true if this record has any pending changes.
    */
    bool hasPendingChanges() const;

    /**
      Stores all changes made to this record into the database.
      Note that this method assumes the existence of an 'id' column to identify
      the record to update. If that column does not exist, all records will be
      changed.
      @returns true on success, false otherwise.
    */
    bool update();
    bool update(DataStore *store);

    

    /**
      Invalidates the cache entry for this record.
      This method has no effect if caching is not enabled for this table.
    */
    void invalidateCache() const;

    /**
      Invalidates all cache entries for this table.
      This method has no effect if caching is not enabled for this table.
    */
    static void invalidateCompleteCache();

    /**
      Enable/disable caching for this table.
      This method is not thread-safe, call before activating multi-threading.
    */
    static void enableCache(bool enable);

    // manipulate n:m relations
    

    // delete records
    static bool remove(const QString &column, const QVariant &value);
    static bool remove(DataStore *store, const QString &column, const QVariant &value);

private:
    class Private;
    QSharedDataPointer<Private> d;
};

class PimItemFlagRelation
{
  public:
    // SQL table information
    static QString tableName();
    static QString leftColumn();
    static QString leftFullColumnName();
    static QString rightColumn();
    static QString rightFullColumnName();
};

class PimItemTagRelation
{
  public:
    // SQL table information
    static QString tableName();
    static QString leftColumn();
    static QString leftFullColumnName();
    static QString rightColumn();
    static QString rightFullColumnName();
};

/**
  Specifies allowed MimeType for a Collection
*/

class CollectionMimeTypeRelation
{
  public:
    // SQL table information
    static QString tableName();
    static QString leftColumn();
    static QString leftFullColumnName();
    static QString rightColumn();
    static QString rightFullColumnName();
};

/**
  Used to associate items with search folders.
*/

class CollectionPimItemRelation
{
  public:
    // SQL table information
    static QString tableName();
    static QString leftColumn();
    static QString leftFullColumnName();
    static QString rightColumn();
    static QString rightFullColumnName();
};


/** Returns a list of all table names. */
QList<QString> allDatabaseTables();

} // namespace Server
} // namespace Akonadi



#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::SchemaVersion &entity);
#endif


#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::Resource &entity);
#endif


#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::Collection &entity);
#endif


#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::MimeType &entity);
#endif


#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::PimItem &entity);
#endif


#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::Flag &entity);
#endif


#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::PartType &entity);
#endif


#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::Part &entity);
#endif


#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::CollectionAttribute &entity);
#endif


#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::TagType &entity);
#endif


#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::Tag &entity);
#endif


#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::TagAttribute &entity);
#endif


#ifndef QT_NO_DEBUG_STREAM
// debug stream operator
QDebug &operator<<(QDebug &d, const Akonadi::Server::TagRemoteIdResourceRelation &entity);
#endif

Q_DECLARE_TYPEINFO(Akonadi::Server::SchemaVersion, Q_RELOCATABLE_TYPE);

Q_DECLARE_TYPEINFO(Akonadi::Server::Resource, Q_RELOCATABLE_TYPE);

Q_DECLARE_TYPEINFO(Akonadi::Server::Collection, Q_RELOCATABLE_TYPE);

Q_DECLARE_TYPEINFO(Akonadi::Server::MimeType, Q_RELOCATABLE_TYPE);

Q_DECLARE_TYPEINFO(Akonadi::Server::PimItem, Q_RELOCATABLE_TYPE);

Q_DECLARE_TYPEINFO(Akonadi::Server::Flag, Q_RELOCATABLE_TYPE);

Q_DECLARE_TYPEINFO(Akonadi::Server::PartType, Q_RELOCATABLE_TYPE);

Q_DECLARE_TYPEINFO(Akonadi::Server::Part, Q_RELOCATABLE_TYPE);

Q_DECLARE_TYPEINFO(Akonadi::Server::CollectionAttribute, Q_RELOCATABLE_TYPE);

Q_DECLARE_TYPEINFO(Akonadi::Server::TagType, Q_RELOCATABLE_TYPE);

Q_DECLARE_TYPEINFO(Akonadi::Server::Tag, Q_RELOCATABLE_TYPE);

Q_DECLARE_TYPEINFO(Akonadi::Server::TagAttribute, Q_RELOCATABLE_TYPE);

Q_DECLARE_TYPEINFO(Akonadi::Server::TagRemoteIdResourceRelation, Q_RELOCATABLE_TYPE);

#endif

