// This file is generated by kconfig_compiler_kf6 from ark.kcfg.
// All changes you do to this file will be lost.
#ifndef ARKSETTINGS_H
#define ARKSETTINGS_H

#include "kerfuffle_export.h"

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class KERFUFFLE_EXPORT ArkSettings : public KConfigSkeleton
{
  Q_OBJECT
  public:
    class EnumDefaultOpenAction
    {
      public:
      enum type { Preview, Open, COUNT };
    };

    static ArkSettings *self();
    ~ArkSettings() override;

    /**
      Set Whether to show a warning when creating zip archives with AES encryption.
    */
    static
    void setShowEncryptionWarning( bool v )
    {
      if (v != self()->mShowEncryptionWarning && !self()->isShowEncryptionWarningImmutable()) {
        self()->mShowEncryptionWarning = v;
        Q_EMIT self()->showEncryptionWarningChanged();
      }
    }

    Q_PROPERTY(bool showEncryptionWarning READ showEncryptionWarning WRITE setShowEncryptionWarning NOTIFY showEncryptionWarningChanged)
    Q_PROPERTY(bool isShowEncryptionWarningImmutable READ isShowEncryptionWarningImmutable CONSTANT)
    /**
      Get Whether to show a warning when creating zip archives with AES encryption.
    */
    static
    bool showEncryptionWarning()
    {
      return self()->mShowEncryptionWarning;
    }

    /**
      Is Whether to show a warning when creating zip archives with AES encryption. Immutable
    */
    static
    bool isShowEncryptionWarningImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showEncryptionWarning" ) );
    }

    /**
      Set Default action when opening archive entries.
    */
    static
    void setDefaultOpenAction( int v )
    {
      if (v != self()->mDefaultOpenAction && !self()->isDefaultOpenActionImmutable()) {
        self()->mDefaultOpenAction = v;
        Q_EMIT self()->defaultOpenActionChanged();
      }
    }

    Q_PROPERTY(int defaultOpenAction READ defaultOpenAction WRITE setDefaultOpenAction NOTIFY defaultOpenActionChanged)
    Q_PROPERTY(bool isDefaultOpenActionImmutable READ isDefaultOpenActionImmutable CONSTANT)
    /**
      Get Default action when opening archive entries.
    */
    static
    int defaultOpenAction()
    {
      return self()->mDefaultOpenAction;
    }

    /**
      Is Default action when opening archive entries. Immutable
    */
    static
    bool isDefaultOpenActionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "defaultOpenAction" ) );
    }

    /**
      Set Open destination folder after extraction.
    */
    static
    void setOpenDestinationFolderAfterExtraction( bool v )
    {
      if (v != self()->mOpenDestinationFolderAfterExtraction && !self()->isOpenDestinationFolderAfterExtractionImmutable()) {
        self()->mOpenDestinationFolderAfterExtraction = v;
        Q_EMIT self()->openDestinationFolderAfterExtractionChanged();
      }
    }

    Q_PROPERTY(bool openDestinationFolderAfterExtraction READ openDestinationFolderAfterExtraction WRITE setOpenDestinationFolderAfterExtraction NOTIFY openDestinationFolderAfterExtractionChanged)
    Q_PROPERTY(bool isOpenDestinationFolderAfterExtractionImmutable READ isOpenDestinationFolderAfterExtractionImmutable CONSTANT)
    /**
      Get Open destination folder after extraction.
    */
    static
    bool openDestinationFolderAfterExtraction()
    {
      return self()->mOpenDestinationFolderAfterExtraction;
    }

    /**
      Is Open destination folder after extraction. Immutable
    */
    static
    bool isOpenDestinationFolderAfterExtractionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "openDestinationFolderAfterExtraction" ) );
    }

    /**
      Set Close Ark after extraction.
    */
    static
    void setCloseAfterExtraction( bool v )
    {
      if (v != self()->mCloseAfterExtraction && !self()->isCloseAfterExtractionImmutable()) {
        self()->mCloseAfterExtraction = v;
        Q_EMIT self()->closeAfterExtractionChanged();
      }
    }

    Q_PROPERTY(bool closeAfterExtraction READ closeAfterExtraction WRITE setCloseAfterExtraction NOTIFY closeAfterExtractionChanged)
    Q_PROPERTY(bool isCloseAfterExtractionImmutable READ isCloseAfterExtractionImmutable CONSTANT)
    /**
      Get Close Ark after extraction.
    */
    static
    bool closeAfterExtraction()
    {
      return self()->mCloseAfterExtraction;
    }

    /**
      Is Close Ark after extraction. Immutable
    */
    static
    bool isCloseAfterExtractionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "closeAfterExtraction" ) );
    }

    /**
      Set Preserve paths when extracting.
    */
    static
    void setPreservePaths( bool v )
    {
      if (v != self()->mPreservePaths && !self()->isPreservePathsImmutable()) {
        self()->mPreservePaths = v;
        Q_EMIT self()->preservePathsChanged();
      }
    }

    Q_PROPERTY(bool preservePaths READ preservePaths WRITE setPreservePaths NOTIFY preservePathsChanged)
    Q_PROPERTY(bool isPreservePathsImmutable READ isPreservePathsImmutable CONSTANT)
    /**
      Get Preserve paths when extracting.
    */
    static
    bool preservePaths()
    {
      return self()->mPreservePaths;
    }

    /**
      Is Preserve paths when extracting. Immutable
    */
    static
    bool isPreservePathsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "preservePaths" ) );
    }

    /**
      Set Extract to a subfolder if the archive has more than one top-level entry.
    */
    static
    void setExtractToSubfolder( bool v )
    {
      if (v != self()->mExtractToSubfolder && !self()->isExtractToSubfolderImmutable()) {
        self()->mExtractToSubfolder = v;
        Q_EMIT self()->extractToSubfolderChanged();
      }
    }

    Q_PROPERTY(bool extractToSubfolder READ extractToSubfolder WRITE setExtractToSubfolder NOTIFY extractToSubfolderChanged)
    Q_PROPERTY(bool isExtractToSubfolderImmutable READ isExtractToSubfolderImmutable CONSTANT)
    /**
      Get Extract to a subfolder if the archive has more than one top-level entry.
    */
    static
    bool extractToSubfolder()
    {
      return self()->mExtractToSubfolder;
    }

    /**
      Is Extract to a subfolder if the archive has more than one top-level entry. Immutable
    */
    static
    bool isExtractToSubfolderImmutable()
    {
      return self()->isImmutable( QStringLiteral( "extractToSubfolder" ) );
    }

    /**
      Set How the main window is divided.
    */
    static
    void setSplitterSizes( const QList<int> & v )
    {
      if (v != self()->mSplitterSizes && !self()->isSplitterSizesImmutable()) {
        self()->mSplitterSizes = v;
        Q_EMIT self()->splitterSizesChanged();
      }
    }

    Q_PROPERTY(QList<int> splitterSizes READ splitterSizes WRITE setSplitterSizes NOTIFY splitterSizesChanged)
    Q_PROPERTY(bool isSplitterSizesImmutable READ isSplitterSizesImmutable CONSTANT)
    /**
      Get How the main window is divided.
    */
    static
    QList<int> splitterSizes()
    {
      return self()->mSplitterSizes;
    }

    /**
      Is How the main window is divided. Immutable
    */
    static
    bool isSplitterSizesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "splitterSizes" ) );
    }

    /**
      Set Whether to show the information panel.
    */
    static
    void setShowInfoPanel( bool v )
    {
      if (v != self()->mShowInfoPanel && !self()->isShowInfoPanelImmutable()) {
        self()->mShowInfoPanel = v;
        Q_EMIT self()->showInfoPanelChanged();
      }
    }

    Q_PROPERTY(bool showInfoPanel READ showInfoPanel WRITE setShowInfoPanel NOTIFY showInfoPanelChanged)
    Q_PROPERTY(bool isShowInfoPanelImmutable READ isShowInfoPanelImmutable CONSTANT)
    /**
      Get Whether to show the information panel.
    */
    static
    bool showInfoPanel()
    {
      return self()->mShowInfoPanel;
    }

    /**
      Is Whether to show the information panel. Immutable
    */
    static
    bool isShowInfoPanelImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showInfoPanel" ) );
    }

    /**
      Set disabledPlugins
    */
    static
    void setDisabledPlugins( const QStringList & v )
    {
      if (v != self()->mDisabledPlugins && !self()->isDisabledPluginsImmutable()) {
        self()->mDisabledPlugins = v;
        Q_EMIT self()->disabledPluginsChanged();
      }
    }

    Q_PROPERTY(QStringList disabledPlugins READ disabledPlugins WRITE setDisabledPlugins NOTIFY disabledPluginsChanged)
    Q_PROPERTY(bool isDisabledPluginsImmutable READ isDisabledPluginsImmutable CONSTANT)
    /**
      Get disabledPlugins
    */
    static
    QStringList disabledPlugins()
    {
      return self()->mDisabledPlugins;
    }

    /**
      Is disabledPlugins Immutable
    */
    static
    bool isDisabledPluginsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "disabledPlugins" ) );
    }

    /**
      Set Whether to limit the preview according to file size.
    */
    static
    void setLimitPreviewFileSize( bool v )
    {
      if (v != self()->mLimitPreviewFileSize && !self()->isLimitPreviewFileSizeImmutable()) {
        self()->mLimitPreviewFileSize = v;
        Q_EMIT self()->limitPreviewFileSizeChanged();
      }
    }

    Q_PROPERTY(bool limitPreviewFileSize READ limitPreviewFileSize WRITE setLimitPreviewFileSize NOTIFY limitPreviewFileSizeChanged)
    Q_PROPERTY(bool isLimitPreviewFileSizeImmutable READ isLimitPreviewFileSizeImmutable CONSTANT)
    /**
      Get Whether to limit the preview according to file size.
    */
    static
    bool limitPreviewFileSize()
    {
      return self()->mLimitPreviewFileSize;
    }

    /**
      Is Whether to limit the preview according to file size. Immutable
    */
    static
    bool isLimitPreviewFileSizeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "limitPreviewFileSize" ) );
    }

    /**
      Set Preview file size limit in megabytes.
    */
    static
    void setPreviewFileSizeLimit( int v )
    {
      if (v != self()->mPreviewFileSizeLimit && !self()->isPreviewFileSizeLimitImmutable()) {
        self()->mPreviewFileSizeLimit = v;
        Q_EMIT self()->previewFileSizeLimitChanged();
      }
    }

    Q_PROPERTY(int previewFileSizeLimit READ previewFileSizeLimit WRITE setPreviewFileSizeLimit NOTIFY previewFileSizeLimitChanged)
    Q_PROPERTY(bool isPreviewFileSizeLimitImmutable READ isPreviewFileSizeLimitImmutable CONSTANT)
    /**
      Get Preview file size limit in megabytes.
    */
    static
    int previewFileSizeLimit()
    {
      return self()->mPreviewFileSizeLimit;
    }

    /**
      Is Preview file size limit in megabytes. Immutable
    */
    static
    bool isPreviewFileSizeLimitImmutable()
    {
      return self()->isImmutable( QStringLiteral( "previewFileSizeLimit" ) );
    }


    enum {
      signalShowEncryptionWarningChanged = 1,
      signalDefaultOpenActionChanged = 2,
      signalOpenDestinationFolderAfterExtractionChanged = 3,
      signalCloseAfterExtractionChanged = 4,
      signalPreservePathsChanged = 5,
      signalExtractToSubfolderChanged = 6,
      signalSplitterSizesChanged = 7,
      signalShowInfoPanelChanged = 8,
      signalDisabledPluginsChanged = 9,
      signalLimitPreviewFileSizeChanged = 10,
      signalPreviewFileSizeLimitChanged = 11
    };

  Q_SIGNALS:
    void showEncryptionWarningChanged();

    void defaultOpenActionChanged();

    void openDestinationFolderAfterExtractionChanged();

    void closeAfterExtractionChanged();

    void preservePathsChanged();

    void extractToSubfolderChanged();

    void splitterSizesChanged();

    void showInfoPanelChanged();

    void disabledPluginsChanged();

    void limitPreviewFileSizeChanged();

    void previewFileSizeLimitChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    ArkSettings();
    friend class ArkSettingsHelper;


    // General
    bool mShowEncryptionWarning;
    int mDefaultOpenAction;

    // Extraction
    bool mOpenDestinationFolderAfterExtraction;
    bool mCloseAfterExtraction;
    bool mPreservePaths;
    bool mExtractToSubfolder;

    // MainWindow
    QList<int> mSplitterSizes;
    bool mShowInfoPanel;

    // Plugins
    QStringList mDisabledPlugins;

    // Preview
    bool mLimitPreviewFileSize;
    int mPreviewFileSizeLimit;
};

#endif

