/* RecentBackupRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RecentBackupRow.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "deja.h"
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_RECENT_BACKUP_ROW (recent_backup_row_get_type ())
#define RECENT_BACKUP_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RECENT_BACKUP_ROW, RecentBackupRow))
#define RECENT_BACKUP_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RECENT_BACKUP_ROW, RecentBackupRowClass))
#define IS_RECENT_BACKUP_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RECENT_BACKUP_ROW))
#define IS_RECENT_BACKUP_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RECENT_BACKUP_ROW))
#define RECENT_BACKUP_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RECENT_BACKUP_ROW, RecentBackupRowClass))

typedef struct _RecentBackupRow RecentBackupRow;
typedef struct _RecentBackupRowClass RecentBackupRowClass;
typedef struct _RecentBackupRowPrivate RecentBackupRowPrivate;
enum  {
	RECENT_BACKUP_ROW_0_PROPERTY,
	RECENT_BACKUP_ROW_NUM_PROPERTIES
};
static GParamSpec* recent_backup_row_properties[RECENT_BACKUP_ROW_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RecentBackupRow {
	AdwActionRow parent_instance;
	RecentBackupRowPrivate * priv;
};

struct _RecentBackupRowClass {
	AdwActionRowClass parent_class;
};

struct _RecentBackupRowPrivate {
	guint timeout_id;
};

static gint RecentBackupRow_private_offset;
static gpointer recent_backup_row_parent_class = NULL;

VALA_EXTERN GType recent_backup_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RecentBackupRow, g_object_unref)
static gboolean recent_backup_row_is_same_day (RecentBackupRow* self,
                                        GDateTime* one,
                                        GDateTime* two);
static gchar* recent_backup_row_pretty_last_name (RecentBackupRow* self,
                                           GDateTime* date);
static gboolean recent_backup_row_update_label_timer (RecentBackupRow* self);
static void recent_backup_row_update_label (RecentBackupRow* self);
VALA_EXTERN RecentBackupRow* recent_backup_row_new (void);
VALA_EXTERN RecentBackupRow* recent_backup_row_construct (GType object_type);
static GObject * recent_backup_row_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _recent_backup_row_update_label_deja_dup_backend_watcher_new_backup (DejaDupBackendWatcher* _sender,
                                                                          gpointer self);
static gboolean _recent_backup_row_update_label_timer_gsource_func (gpointer self);
static void recent_backup_row_finalize (GObject * obj);
static GType recent_backup_row_get_type_once (void);

static inline gpointer
recent_backup_row_get_instance_private (RecentBackupRow* self)
{
	return G_STRUCT_MEMBER_P (self, RecentBackupRow_private_offset);
}

static gboolean
recent_backup_row_is_same_day (RecentBackupRow* self,
                               GDateTime* one,
                               GDateTime* two)
{
	GDateTime* one_local = NULL;
	GDateTime* _tmp0_;
	GDateTime* two_local = NULL;
	GDateTime* _tmp1_;
	gint ny = 0;
	gint nm = 0;
	gint nd = 0;
	gint dy = 0;
	gint dm = 0;
	gint dd = 0;
	GDateTime* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GDateTime* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (one != NULL, FALSE);
	g_return_val_if_fail (two != NULL, FALSE);
	_tmp0_ = g_date_time_to_local (one);
	one_local = _tmp0_;
	_tmp1_ = g_date_time_to_local (two);
	two_local = _tmp1_;
	_tmp2_ = one_local;
	g_date_time_get_ymd (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	ny = _tmp3_;
	nm = _tmp4_;
	nd = _tmp5_;
	_tmp6_ = two_local;
	g_date_time_get_ymd (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
	dy = _tmp7_;
	dm = _tmp8_;
	dd = _tmp9_;
	if (ny == dy) {
		_tmp11_ = nm == dm;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		_tmp10_ = nd == dd;
	} else {
		_tmp10_ = FALSE;
	}
	result = _tmp10_;
	_g_date_time_unref0 (two_local);
	_g_date_time_unref0 (one_local);
	return result;
}

static gchar*
recent_backup_row_pretty_last_name (RecentBackupRow* self,
                                    GDateTime* date)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (date != NULL, NULL);
	_tmp0_ = deja_dup_now ();
	now = _tmp0_;
	_tmp1_ = now;
	if (g_date_time_compare (_tmp1_, date) < 0) {
		GDateTime* _tmp2_;
		_tmp2_ = now;
		date = _tmp2_;
	}
	_tmp3_ = now;
	if (recent_backup_row_is_same_day (self, date, _tmp3_)) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (_ ("Today"));
		result = _tmp4_;
		_g_date_time_unref0 (now);
		return result;
	} else {
		GDateTime* _tmp5_;
		GDateTime* _tmp6_;
		GDateTime* _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = now;
		_tmp6_ = g_date_time_add_days (_tmp5_, -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = recent_backup_row_is_same_day (self, date, _tmp7_);
		_g_date_time_unref0 (_tmp7_);
		if (_tmp8_) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup (_ ("Yesterday"));
			result = _tmp9_;
			_g_date_time_unref0 (now);
			return result;
		} else {
			GDateTime* _tmp10_;
			GDateTime* _tmp11_;
			GDateTime* _tmp12_;
			GDateTime* _tmp13_;
			gint diff = 0;
			GDateTime* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = now;
			_tmp11_ = now;
			_tmp12_ = now;
			_tmp13_ = g_date_time_new_utc (g_date_time_get_year (_tmp10_), g_date_time_get_month (_tmp11_), g_date_time_get_day_of_month (_tmp12_), 0, 0, 0.0);
			_g_date_time_unref0 (now);
			now = _tmp13_;
			_tmp14_ = now;
			diff = (gint) ((g_date_time_difference (_tmp14_, date) / G_TIME_SPAN_DAY) + 1);
			_tmp15_ = g_strdup_printf (g_dngettext (GETTEXT_PACKAGE, "%d day ago", "%d days ago", (gulong) diff), diff);
			result = _tmp15_;
			_g_date_time_unref0 (now);
			return result;
		}
	}
}

static gboolean
recent_backup_row_update_label_timer (RecentBackupRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	recent_backup_row_update_label (self);
	result = G_SOURCE_CONTINUE;
	return result;
}

static void
recent_backup_row_update_label (RecentBackupRow* self)
{
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gchar* last = NULL;
	DejaDupFilteredSettings* _tmp1_;
	gchar* _tmp2_;
	GDateTime* last_time = NULL;
	const gchar* _tmp3_;
	GTimeZone* _tmp4_;
	GTimeZone* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_LAST_BACKUP_KEY);
	last = _tmp2_;
	_tmp3_ = last;
	_tmp4_ = g_time_zone_new_utc ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_date_time_new_from_iso8601 (_tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_time_zone_unref0 (_tmp5_);
	last_time = _tmp7_;
	_tmp8_ = last_time;
	if (_tmp8_ == NULL) {
		adw_action_row_set_subtitle ((AdwActionRow*) self, C_ ("backups", "None"));
	} else {
		GDateTime* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = last_time;
		_tmp10_ = recent_backup_row_pretty_last_name (self, _tmp9_);
		_tmp11_ = _tmp10_;
		adw_action_row_set_subtitle ((AdwActionRow*) self, _tmp11_);
		_g_free0 (_tmp11_);
	}
	_g_date_time_unref0 (last_time);
	_g_free0 (last);
	_g_object_unref0 (settings);
}

RecentBackupRow*
recent_backup_row_construct (GType object_type)
{
	RecentBackupRow * self = NULL;
	self = (RecentBackupRow*) g_object_new (object_type, NULL);
	return self;
}

RecentBackupRow*
recent_backup_row_new (void)
{
	return recent_backup_row_construct (TYPE_RECENT_BACKUP_ROW);
}

static void
_recent_backup_row_update_label_deja_dup_backend_watcher_new_backup (DejaDupBackendWatcher* _sender,
                                                                     gpointer self)
{
	recent_backup_row_update_label ((RecentBackupRow*) self);
}

static gboolean
_recent_backup_row_update_label_timer_gsource_func (gpointer self)
{
	gboolean result;
	result = recent_backup_row_update_label_timer ((RecentBackupRow*) self);
	return result;
}

static GObject *
recent_backup_row_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	RecentBackupRow * self;
	DejaDupBackendWatcher* watcher = NULL;
	DejaDupBackendWatcher* _tmp0_;
	DejaDupBackendWatcher* _tmp1_;
	parent_class = G_OBJECT_CLASS (recent_backup_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RECENT_BACKUP_ROW, RecentBackupRow);
	_tmp0_ = deja_dup_backend_watcher_get_instance ();
	watcher = _tmp0_;
	_tmp1_ = watcher;
	g_signal_connect_object (_tmp1_, "new-backup", (GCallback) _recent_backup_row_update_label_deja_dup_backend_watcher_new_backup, self, 0);
	recent_backup_row_update_label (self);
	self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) (60 * 60), _recent_backup_row_update_label_timer_gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (watcher);
	return obj;
}

static void
recent_backup_row_class_init (RecentBackupRowClass * klass,
                              gpointer klass_data)
{
	recent_backup_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RecentBackupRow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = recent_backup_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = recent_backup_row_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/DejaDup/RecentBackupRow.ui");
}

static void
recent_backup_row_instance_init (RecentBackupRow * self,
                                 gpointer klass)
{
	self->priv = recent_backup_row_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
recent_backup_row_finalize (GObject * obj)
{
	RecentBackupRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RECENT_BACKUP_ROW, RecentBackupRow);
	g_source_remove (self->priv->timeout_id);
	G_OBJECT_CLASS (recent_backup_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
recent_backup_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RecentBackupRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) recent_backup_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RecentBackupRow), 0, (GInstanceInitFunc) recent_backup_row_instance_init, NULL };
	GType recent_backup_row_type_id;
	recent_backup_row_type_id = g_type_register_static (adw_action_row_get_type (), "RecentBackupRow", &g_define_type_info, 0);
	RecentBackupRow_private_offset = g_type_add_instance_private (recent_backup_row_type_id, sizeof (RecentBackupRowPrivate));
	return recent_backup_row_type_id;
}

GType
recent_backup_row_get_type (void)
{
	static gsize recent_backup_row_type_id__once = 0;
	if (g_once_init_enter (&recent_backup_row_type_id__once)) {
		GType recent_backup_row_type_id;
		recent_backup_row_type_id = recent_backup_row_get_type_once ();
		g_once_init_leave (&recent_backup_row_type_id__once, recent_backup_row_type_id);
	}
	return recent_backup_row_type_id__once;
}

