#include "sysconfig.h"
#include "sysdeps.h"
#include "options.h"
#include "uae/memory.h"
#include "custom.h"
#include "events.h"
#include "newcpu.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#define CPUFUNC(x) x##_ff
#define SET_CFLG_ALWAYS(x) SET_CFLG(x)
#define SET_NFLG_ALWAYS(x) SET_NFLG(x)
#ifdef NOFLAGS
#include "noflags.h"
#endif

#ifdef CPUEMU_21

#pragma GCC diagnostic ignored "-Wunused-variable"
#if !defined __clang_analyzer__

#if !defined(PART_1) && !defined(PART_2) && !defined(PART_3) && !defined(PART_4) && !defined(PART_5) && !defined(PART_6) && !defined(PART_7) && !defined(PART_8)
#define PART_1 1
#define PART_2 1
#define PART_3 1
#define PART_4 1
#define PART_5 1
#define PART_6 1
#define PART_7 1
#define PART_8 1
#endif

#ifdef PART_1
/* OR.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0000_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
}

/* OR.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0010_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0018_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0020_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0028_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0030_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}}return;
}

/* OR.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0038_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0039_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* ORSR.B #<data>.W */
void REGPARAM2 CPUFUNC(op_003c_21)(uae_u32 opcode)
{
{	MakeSR ();
{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	src &= 0xFF;
	regs.sr |= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
return;
}

/* OR.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0040_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
}

/* OR.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0050_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0058_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0060_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0068_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0070_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}}return;
}

/* OR.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0078_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0079_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* ORSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_007c_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210018; }
{	MakeSR ();
{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	regs.sr |= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210018: ;
return;
}

/* OR.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0080_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4+2=6,T:0,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
}

/* OR.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0090_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:0,C:3 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0098_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:1,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_00a0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* OR.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_00a8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* OR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_00b0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}}return;
}

/* OR.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_00b8_21)(uae_u32 opcode)
{
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* OR.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_00b9_21)(uae_u32 opcode)
{
{	/* ea H:5,T:0,C:3 fiea */
	if (regs.ce020memcycles > 5 * cpucycleunit)
		regs.ce020memcycles = 5 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (10);
return;
}

/* CHK2.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00d0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210027; }
}
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210027: ;
return;
}

#endif
/* CHK2.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00e8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210028; }
}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210028: ;
return;
}

#endif
/* CHK2.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00f0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210029; }
}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210029: ;
return;
}

#endif
/* CHK2.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00f8_21)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210030; }
}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210030: ;
return;
}

#endif
/* CHK2.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00f9_21)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210031; }
}
	regs.irc = get_word_ce020_prefetch (8);
}}}	m68k_incpci (8);
l_210031: ;
return;
}

#endif
/* CHK2.B #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210032; }
}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210032: ;
return;
}

#endif
/* CHK2.B #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_00fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce020 (tmppc, 0);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte (dsta); upper = (uae_s32)(uae_s8)x_get_byte (dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210033; }
}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210033: ;
return;
}

#endif
/* BTST.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_0100_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:4,T:0,C:0 */
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (2);
return;
}

/* MVPMR.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_0108_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr memp = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	/* OP zero */
	uae_u16 val = ((x_get_byte (memp) & 0xff) << 8) + (x_get_byte (memp + 2) & 0xff);
	regs.irc = get_word_ce020_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}	m68k_incpci (4);
return;
}

/* BTST.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_0110_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (2);
return;
}

/* BTST.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_0118_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (2);
return;
}

/* BTST.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_0120_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (2);
return;
}

/* BTST.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_0128_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (4);
return;
}

/* BTST.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0130_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}}return;
}

/* BTST.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_0138_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (4);
return;
}

/* BTST.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_0139_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (6);
return;
}

/* BTST.B Dn,(d16,PC) */
void REGPARAM2 CPUFUNC(op_013a_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 2;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_getpci () + 2;
	dsta += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (4);
return;
}

/* BTST.B Dn,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_013b_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 3;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce020 (tmppc, 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}}return;
}

/* BTST.B Dn,#<data>.B */
void REGPARAM2 CPUFUNC(op_013c_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = (uae_u8)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (4);
return;
}

/* BCHG.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_0140_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:6,T:0,C:0 */
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (2);
return;
}

/* MVPMR.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_0148_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr memp = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	/* OP zero */
	uae_u32 val = ((x_get_byte (memp) & 0xff) << 24) + ((x_get_byte (memp + 2) & 0xff) << 16)
              + ((x_get_byte (memp + 4) & 0xff) << 8) + (x_get_byte (memp + 6) & 0xff);
	regs.irc = get_word_ce020_prefetch (4);
	m68k_dreg (regs, dstreg) = (val);
}}	m68k_incpci (4);
return;
}

/* BCHG.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_0150_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BCHG.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_0158_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BCHG.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_0160_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BCHG.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_0168_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCHG.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0170_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}}return;
}

/* BCHG.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_0178_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCHG.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_0179_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BCLR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_0180_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:6,T:0,C:0 */
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (2);
return;
}

/* MVPRM.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_0188_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* OP zero */
	uaecptr memp = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	x_put_byte (memp, src >> 8);
	x_put_byte (memp + 2, src);
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
return;
}

/* BCLR.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_0190_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BCLR.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_0198_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BCLR.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_01a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BCLR.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_01a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCLR.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_01b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}}return;
}

/* BCLR.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_01b8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCLR.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_01b9_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BSET.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_01c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:6,T:0,C:0 */
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (2);
return;
}

/* MVPRM.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_01c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* OP zero */
	uaecptr memp = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	x_put_byte (memp, src >> 24);
	x_put_byte (memp + 2, src >> 16);
	x_put_byte (memp + 4, src >> 8);
	x_put_byte (memp + 6, src);
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
return;
}

/* BSET.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_01d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BSET.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_01d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BSET.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_01e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (2);
return;
}

/* BSET.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_01e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BSET.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_01f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}}return;
}

/* BSET.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_01f8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BSET.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_01f9_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
{	uae_s8 dst = x_get_byte (dsta);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* AND.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0200_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
}

/* AND.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0210_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* AND.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0218_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* AND.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0220_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* AND.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0228_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0230_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}}return;
}

/* AND.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0238_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0239_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* ANDSR.B #<data>.W */
void REGPARAM2 CPUFUNC(op_023c_21)(uae_u32 opcode)
{
{	MakeSR ();
{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	src |= 0xFF00;
	regs.sr &= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
return;
}

/* AND.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0240_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
}

/* AND.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0250_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* AND.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0258_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* AND.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0260_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* AND.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0268_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0270_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}}return;
}

/* AND.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0278_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0279_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* ANDSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_027c_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210090; }
{	MakeSR ();
{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	regs.sr &= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210090: ;
return;
}

/* AND.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0280_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4+2=6,T:0,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
}

/* AND.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0290_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:0,C:3 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0298_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:1,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_02a0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* AND.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_02a8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* AND.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_02b0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}}return;
}

/* AND.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_02b8_21)(uae_u32 opcode)
{
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* AND.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_02b9_21)(uae_u32 opcode)
{
{	/* ea H:5,T:0,C:3 fiea */
	if (regs.ce020memcycles > 5 * cpucycleunit)
		regs.ce020memcycles = 5 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (10);
return;
}

/* CHK2.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02d0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210099; }
}
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210099: ;
return;
}

#endif
/* CHK2.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02e8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210100; }
}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210100: ;
return;
}

#endif
/* CHK2.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02f0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210101; }
}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210101: ;
return;
}

#endif
/* CHK2.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02f8_21)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210102; }
}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210102: ;
return;
}

#endif
/* CHK2.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02f9_21)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210103; }
}
	regs.irc = get_word_ce020_prefetch (8);
}}}	m68k_incpci (8);
l_210103: ;
return;
}

#endif
/* CHK2.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210104; }
}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210104: ;
return;
}

#endif
/* CHK2.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_02fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce020 (tmppc, 0);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word (dsta); upper = (uae_s32)(uae_s16)x_get_word (dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210105; }
}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210105: ;
return;
}

#endif
/* SUB.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0400_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0410_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0418_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0420_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0428_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0430_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}}return;
}

/* SUB.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0438_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0439_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* SUB.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0440_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0450_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0458_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0460_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0468_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0470_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}}return;
}

/* SUB.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0478_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0479_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* SUB.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0480_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4+2=6,T:0,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (6);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return;
}

/* SUB.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0490_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:0,C:3 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0498_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:1,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_04a0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_04a8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* SUB.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_04b0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}}return;
}

/* SUB.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_04b8_21)(uae_u32 opcode)
{
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* SUB.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_04b9_21)(uae_u32 opcode)
{
{	/* ea H:5,T:0,C:3 fiea */
	if (regs.ce020memcycles > 5 * cpucycleunit)
		regs.ce020memcycles = 5 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (10);
return;
}

/* CHK2.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04d0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210130; }
}
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210130: ;
return;
}

#endif
/* CHK2.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04e8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210131; }
}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210131: ;
return;
}

#endif
/* CHK2.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04f0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210132; }
}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210132: ;
return;
}

#endif
/* CHK2.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04f8_21)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210133; }
}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210133: ;
return;
}

#endif
/* CHK2.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04f9_21)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210134; }
}
	regs.irc = get_word_ce020_prefetch (8);
}}}	m68k_incpci (8);
l_210134: ;
return;
}

#endif
/* CHK2.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210135; }
}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210135: ;
return;
}

#endif
/* CHK2.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_04fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce020 (tmppc, 0);
	/* OP zero */
	{uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long (dsta); upper = x_get_long (dsta + 4);
	SET_ZFLG (upper == reg || lower == reg);
	SET_CFLG_ALWAYS (lower <= upper ? reg < lower || reg > upper : reg > upper || reg < lower);
	if ((extra & 0x800) && GET_CFLG ()) { Exception (6); goto l_210136; }
}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210136: ;
return;
}

#endif
/* ADD.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0600_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return;
}

/* ADD.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0610_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADD.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0618_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADD.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0620_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADD.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0628_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0630_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}}return;
}

/* ADD.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0638_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0639_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* ADD.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0640_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return;
}

/* ADD.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0650_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADD.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0658_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADD.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0660_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADD.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0668_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0670_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}}return;
}

/* ADD.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0678_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0679_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* ADD.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0680_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4+2=6,T:0,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (6);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return;
}

/* ADD.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0690_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:0,C:3 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0698_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:1,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_06a0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADD.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_06a8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* ADD.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_06b0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}}return;
}

/* ADD.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_06b8_21)(uae_u32 opcode)
{
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (8);
return;
}

/* ADD.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_06b9_21)(uae_u32 opcode)
{
{	/* ea H:5,T:0,C:3 fiea */
	if (regs.ce020memcycles > 5 * cpucycleunit)
		regs.ce020memcycles = 5 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (10);
return;
}

/* RTM.L Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* RTM.L An */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06f8_21)(uae_u32 opcode)
{
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06f9_21)(uae_u32 opcode)
{
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06fa_21)(uae_u32 opcode)
{
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* CALLM.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_06fb_21)(uae_u32 opcode)
{
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* BTST.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0800_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:4,T:0,C:0 */
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (4);
return;
}

/* BTST.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0810_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (4);
return;
}

/* BTST.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0818_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (4);
return;
}

/* BTST.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0820_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (4);
return;
}

/* BTST.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0828_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (6);
return;
}

/* BTST.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0830_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}}return;
}

/* BTST.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0838_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (6);
return;
}

/* BTST.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0839_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (8);
return;
}

/* BTST.B #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_083a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}	m68k_incpci (6);
return;
}

/* BTST.B #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_083b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	do_cycles_ce020_internal (2);
}}}}}return;
}

/* BCHG.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0840_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:6,T:0,C:0 */
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (4);
return;
}

/* BCHG.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0850_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCHG.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0858_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCHG.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0860_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCHG.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0868_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BCHG.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0870_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}}return;
}

/* BCHG.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0878_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BCHG.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0879_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (8);
return;
}

/* BCLR.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0880_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:6,T:0,C:0 */
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (4);
return;
}

/* BCLR.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0890_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCLR.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0898_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCLR.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_08a0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BCLR.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_08a8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BCLR.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_08b0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}}return;
}

/* BCLR.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_08b8_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BCLR.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_08b9_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (8);
return;
}

/* BSET.L #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_08c0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:6,T:0,C:0 */
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (4);
return;
}

/* BSET.B #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_08d0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BSET.B #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_08d8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BSET.B #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_08e0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (4);
return;
}

/* BSET.B #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_08e8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BSET.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_08f0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}}return;
}

/* BSET.B #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_08f8_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (6);
return;
}

/* BSET.B #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_08f9_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, dst);
}}}}	m68k_incpci (8);
return;
}

/* EOR.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0a00_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
}

/* EOR.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0a10_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0a18_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0a20_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0a28_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0a30_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}}return;
}

/* EOR.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0a38_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0a39_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* EORSR.B #<data>.W */
void REGPARAM2 CPUFUNC(op_0a3c_21)(uae_u32 opcode)
{
{	MakeSR ();
{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	src &= 0xFF;
	regs.sr ^= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
return;
}

/* EOR.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0a40_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
}

/* EOR.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0a50_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0a58_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0a60_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0a68_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0a70_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}}return;
}

/* EOR.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0a78_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0a79_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* EORSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_0a7c_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210221; }
{	MakeSR ();
{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	regs.sr ^= src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210221: ;
return;
}

/* EOR.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0a80_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4+2=6,T:0,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
}

/* EOR.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0a90_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:0,C:3 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0a98_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:1,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_0aa0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_0aa8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* EOR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0ab0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}}return;
}

/* EOR.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_0ab8_21)(uae_u32 opcode)
{
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (8);
return;
}

/* EOR.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_0ab9_21)(uae_u32 opcode)
{
{	/* ea H:5,T:0,C:3 fiea */
	if (regs.ce020memcycles > 5 * cpucycleunit)
		regs.ce020memcycles = 5 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (10);
return;
}

/* CAS.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ad0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (4);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ad8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (4);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ae0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (4);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ae8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (6);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}	m68k_incpci (6);
return;
}

#endif
#endif

#ifdef PART_2
/* CAS.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0af0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (0);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (0);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}}return;
}

#endif
/* CAS.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0af8_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (6);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CAS.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0af9_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s8)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(m68k_dreg (regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (8);
	x_put_byte (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (8);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
}}}}}}}}	m68k_incpci (8);
return;
}

#endif
/* CMP.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_0c00_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (4);
}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_0c10_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_0c18_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_0c20_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_0c28_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0c30_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_0c38_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_0c39_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (8);
return;
}

/* CMP.B #<data>.B,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0c3a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CMP.B #<data>.B,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0c3b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 dst = x_get_byte (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

#endif
/* CMP.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_0c40_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2+2=4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (4);
}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_0c50_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_0c58_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:1,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_0c60_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_0c68_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0c70_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_0c78_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_0c79_21)(uae_u32 opcode)
{
{	/* ea H:3,T:0,C:3 fiea */
	if (regs.ce020memcycles > 3 * cpucycleunit)
		regs.ce020memcycles = 3 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (8);
return;
}

/* CMP.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0c7a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CMP.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0c7b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 dst = x_get_word (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

#endif
/* CMP.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_0c80_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4+2=6,T:0,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2-,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (6);
}}}}}}	m68k_incpci (6);
return;
}

/* CMP.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_0c90_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:0,C:3 fiea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_0c98_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:1,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_0ca0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:0,C:2 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_0ca8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (8);
return;
}

/* CMP.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_0cb0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_0cb8_21)(uae_u32 opcode)
{
{	/* ea H:6,T:2,C:0 fiea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (8);
return;
}

/* CMP.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_0cb9_21)(uae_u32 opcode)
{
{	/* ea H:5,T:0,C:3 fiea */
	if (regs.ce020memcycles > 5 * cpucycleunit)
		regs.ce020memcycles = 5 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (10);
return;
}

/* CMP.L #<data>.L,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	/* ea H:4,T:0,C:2 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	do_cycles_ce020_internal (2);
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_getpci () + 6;
	dsta += (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (8);
return;
}

#endif
/* CMP.L #<data>.L,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cbb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	/* ea H:8,T:2,C:0 fiea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (6);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 dst = x_get_long (dsta);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

#endif
/* CAS.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cd0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (4);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cd8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (4);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ce0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (4);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ce8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (6);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CAS.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cf0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s16 dst = x_get_word (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (0);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (0);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}}return;
}

#endif
/* CAS.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cf8_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (6);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CAS.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cf9_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s16 dst = x_get_word (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (8);
	x_put_word (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (8);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
}}}}}}}}	m68k_incpci (8);
return;
}

#endif
/* CAS2.W #<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0cfc_21)(uae_u32 opcode)
{
{{	uae_s32 extra;
	extra = get_long_ce020_prefetch (2);
	/* OP zero */
	uae_u32 rn1 = regs.regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 15];
	uae_u16 dst1 = x_get_word (rn1), dst2 = x_get_word (rn2);
{uae_u32 newv = ((uae_u16)(dst1)) - ((uae_u16)(m68k_dreg (regs, (extra >> 16) & 7)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s16)(dst1)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, (extra >> 16) & 7))) > ((uae_u16)(dst1)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
{uae_u32 newv = ((uae_u16)(dst2)) - ((uae_u16)(m68k_dreg (regs, extra & 7)));
{	int flgs = ((uae_s16)(m68k_dreg (regs, extra & 7))) < 0;
	int flgo = ((uae_s16)(dst2)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(m68k_dreg (regs, extra & 7))) > ((uae_u16)(dst2)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
	x_put_word (rn1, m68k_dreg (regs, (extra >> 22) & 7));
	x_put_word (rn2, m68k_dreg (regs, (extra >> 6) & 7));
	}}
}}}}	if (! GET_ZFLG ()) {
	m68k_dreg (regs, (extra >> 0) & 7) = (m68k_dreg (regs, (extra >> 6) & 7) & ~0xffff) | (dst2 & 0xffff);
	m68k_dreg (regs, (extra >> 16) & 7) = (m68k_dreg (regs, (extra >> 22) & 7) & ~0xffff) | (dst1 & 0xffff);
	}
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
return;
}

#endif
/* MOVES.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e10_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210275; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* OP zero */
	x_put_byte (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
{	uae_s8 src = x_get_byte (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210275: ;
return;
}

#endif
/* MOVES.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e18_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210276; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	/* OP zero */
	x_put_byte (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210276: ;
return;
}

#endif
/* MOVES.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e20_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210277; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	/* OP zero */
	x_put_byte (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, dstreg) = srca;
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210277: ;
return;
}

#endif
/* MOVES.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e28_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210278; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	x_put_byte (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210278: ;
return;
}

#endif
/* MOVES.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e30_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210279; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	/* OP zero */
	x_put_byte (dsta, src);
}}}else{{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 1);
{	uae_s8 src = x_get_byte (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}}	regs.irc = get_word_ce020_prefetch (0);
}}}l_210279: ;
return;
}

#endif
/* MOVES.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e38_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210280; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	x_put_byte (dsta, src);
}}else{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210280: ;
return;
}

#endif
/* MOVES.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e39_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210281; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	/* OP zero */
	x_put_byte (dsta, src);
}}else{{	uaecptr srca;
	srca = get_long_ce020_prefetch (4);
{	uae_s8 src = x_get_byte (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
	}
}}}	regs.irc = get_word_ce020_prefetch (8);
}}}	m68k_incpci (8);
l_210281: ;
return;
}

#endif
/* MOVES.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e50_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210282; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* OP zero */
	x_put_word (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210282: ;
return;
}

#endif
/* MOVES.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e58_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210283; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	/* OP zero */
	x_put_word (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, dstreg) += 2;
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210283: ;
return;
}

#endif
/* MOVES.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e60_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210284; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	/* OP zero */
	x_put_word (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, dstreg) = srca;
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210284: ;
return;
}

#endif
/* MOVES.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e68_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210285; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	x_put_word (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210285: ;
return;
}

#endif
/* MOVES.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e70_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210286; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	/* OP zero */
	x_put_word (dsta, src);
}}}else{{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 1);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}}	regs.irc = get_word_ce020_prefetch (0);
}}}l_210286: ;
return;
}

#endif
/* MOVES.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e78_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210287; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	x_put_word (dsta, src);
}}else{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210287: ;
return;
}

#endif
/* MOVES.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e79_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210288; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	/* OP zero */
	x_put_word (dsta, src);
}}else{{	uaecptr srca;
	srca = get_long_ce020_prefetch (4);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (m68k_dreg (regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
	}
}}}	regs.irc = get_word_ce020_prefetch (8);
}}}	m68k_incpci (8);
l_210288: ;
return;
}

#endif
/* MOVES.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e90_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210289; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* OP zero */
	x_put_long (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210289: ;
return;
}

#endif
/* MOVES.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0e98_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210290; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	/* OP zero */
	x_put_long (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, dstreg) += 4;
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210290: ;
return;
}

#endif
/* MOVES.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ea0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210291; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	/* OP zero */
	x_put_long (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, dstreg) = srca;
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
l_210291: ;
return;
}

#endif
/* MOVES.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ea8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210292; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	x_put_long (dsta, src);
}}else{{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210292: ;
return;
}

#endif
/* MOVES.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0eb0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{if (!regs.s) { Exception (8); goto l_210293; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	/* OP zero */
	x_put_long (dsta, src);
}}}else{{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 1);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}}	regs.irc = get_word_ce020_prefetch (0);
}}}l_210293: ;
return;
}

#endif
/* MOVES.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0eb8_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210294; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	/* OP zero */
	x_put_long (dsta, src);
}}else{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
l_210294: ;
return;
}

#endif
/* MOVES.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0eb9_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210295; }
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* OP zero */
	if (extra & 0x800)
{	uae_u32 src = regs.regs[(extra >> 12) & 15];
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	/* OP zero */
	x_put_long (dsta, src);
}}else{{	uaecptr srca;
	srca = get_long_ce020_prefetch (4);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
	if (extra & 0x8000) {
	m68k_areg (regs, (extra >> 12) & 7) = src;
	} else {
	m68k_dreg (regs, (extra >> 12) & 7) = (src);
	}
}}}	regs.irc = get_word_ce020_prefetch (8);
}}}	m68k_incpci (8);
l_210295: ;
return;
}

#endif
/* CAS.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ed0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (4);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (4);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ed8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (4);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (4);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ee0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (4);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (4);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}	m68k_incpci (4);
return;
}

#endif
/* CAS.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ee8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (6);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (6);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CAS.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ef0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (0);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (0);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}}return;
}

#endif
/* CAS.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ef8_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (6);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (6);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}	m68k_incpci (6);
return;
}

#endif
/* CAS.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0ef9_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* OP zero */
{	int ru = (src >> 6) & 7;
	int rc = src & 7;
{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg (regs, rc)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
		regs.irc = get_word_ce020_prefetch (8);
	x_put_long (dsta, (m68k_dreg (regs, ru)));
	}else{
	regs.irc = get_word_ce020_prefetch (8);
		m68k_dreg(regs, rc) = dst;
}}}}}}}}	m68k_incpci (8);
return;
}

#endif
/* CAS2.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_0efc_21)(uae_u32 opcode)
{
{{	uae_s32 extra;
	extra = get_long_ce020_prefetch (2);
	/* OP zero */
	uae_u32 rn1 = regs.regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 15];
	uae_u32 dst1 = x_get_long (rn1), dst2 = x_get_long (rn2);
{uae_u32 newv = ((uae_u32)(dst1)) - ((uae_u32)(m68k_dreg (regs, (extra >> 16) & 7)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s32)(dst1)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, (extra >> 16) & 7))) > ((uae_u32)(dst1)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
{uae_u32 newv = ((uae_u32)(dst2)) - ((uae_u32)(m68k_dreg (regs, extra & 7)));
{	int flgs = ((uae_s32)(m68k_dreg (regs, extra & 7))) < 0;
	int flgo = ((uae_s32)(dst2)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(m68k_dreg (regs, extra & 7))) > ((uae_u32)(dst2)));
	SET_NFLG (flgn != 0);
	if (GET_ZFLG ()) {
	x_put_long (rn1, m68k_dreg (regs, (extra >> 22) & 7));
	x_put_long (rn2, m68k_dreg (regs, (extra >> 6) & 7));
	}}
}}}}	if (! GET_ZFLG ()) {
	m68k_dreg (regs, (extra >> 0) & 7) = dst2;
	m68k_dreg (regs, (extra >> 16) & 7) = dst1;
	}
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
return;
}

#endif
/* MOVE.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_1000_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
}}}return;
}

/* MOVE.B (An),Dn */
void REGPARAM2 CPUFUNC(op_1010_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_1018_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_1020_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_1028_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_1030_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return;
}

/* MOVE.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_1038_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_1039_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_103a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_103b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return;
}

/* MOVE.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_103c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
}}}return;
}

/* MOVE.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_1080_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.B (An),(An) */
void REGPARAM2 CPUFUNC(op_1090_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (An)+,(An) */
void REGPARAM2 CPUFUNC(op_1098_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B -(An),(An) */
void REGPARAM2 CPUFUNC(op_10a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (d16,An),(An) */
void REGPARAM2 CPUFUNC(op_10a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,An,Xn),(An) */
void REGPARAM2 CPUFUNC(op_10b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (xxx).W,(An) */
void REGPARAM2 CPUFUNC(op_10b8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (xxx).L,(An) */
void REGPARAM2 CPUFUNC(op_10b9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d16,PC),(An) */
void REGPARAM2 CPUFUNC(op_10ba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),(An) */
void REGPARAM2 CPUFUNC(op_10bb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B #<data>.B,(An) */
void REGPARAM2 CPUFUNC(op_10bc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_10c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.B (An),(An)+ */
void REGPARAM2 CPUFUNC(op_10d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_10d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B -(An),(An)+ */
void REGPARAM2 CPUFUNC(op_10e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (d16,An),(An)+ */
void REGPARAM2 CPUFUNC(op_10e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,An,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_10f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (xxx).W,(An)+ */
void REGPARAM2 CPUFUNC(op_10f8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (xxx).L,(An)+ */
void REGPARAM2 CPUFUNC(op_10f9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d16,PC),(An)+ */
void REGPARAM2 CPUFUNC(op_10fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_10fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B #<data>.B,(An)+ */
void REGPARAM2 CPUFUNC(op_10fc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_1100_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	/* op H:0,T:2,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.B (An),-(An) */
void REGPARAM2 CPUFUNC(op_1110_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (An)+,-(An) */
void REGPARAM2 CPUFUNC(op_1118_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_1120_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.B (d16,An),-(An) */
void REGPARAM2 CPUFUNC(op_1128_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,An,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_1130_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (xxx).W,-(An) */
void REGPARAM2 CPUFUNC(op_1138_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (xxx).L,-(An) */
void REGPARAM2 CPUFUNC(op_1139_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d16,PC),-(An) */
void REGPARAM2 CPUFUNC(op_113a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_113b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B #<data>.B,-(An) */
void REGPARAM2 CPUFUNC(op_113c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_1140_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.B (An),(d16,An) */
void REGPARAM2 CPUFUNC(op_1150_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (An)+,(d16,An) */
void REGPARAM2 CPUFUNC(op_1158_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B -(An),(d16,An) */
void REGPARAM2 CPUFUNC(op_1160_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d16,An),(d16,An) */
void REGPARAM2 CPUFUNC(op_1168_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d8,An,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_1170_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.B (xxx).W,(d16,An) */
void REGPARAM2 CPUFUNC(op_1178_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (xxx).L,(d16,An) */
void REGPARAM2 CPUFUNC(op_1179_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
	regs.irc = get_word_ce020_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.B (d16,PC),(d16,An) */
void REGPARAM2 CPUFUNC(op_117a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_117b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.B #<data>.B,(d16,An) */
void REGPARAM2 CPUFUNC(op_117c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_1180_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}return;
}

/* MOVE.B (An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_1190_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (An)+,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_1198_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B -(An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (d16,An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 1);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}}return;
}

/* MOVE.B (xxx).W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11b8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (xxx).L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11b9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (d16,PC),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11ba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}return;
}

/* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11bb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 1);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}}}return;
}

/* MOVE.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_11bc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
}}}}return;
}

/* MOVE.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_11c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.B (An),(xxx).W */
void REGPARAM2 CPUFUNC(op_11d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (An)+,(xxx).W */
void REGPARAM2 CPUFUNC(op_11d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B -(An),(xxx).W */
void REGPARAM2 CPUFUNC(op_11e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.B (d16,An),(xxx).W */
void REGPARAM2 CPUFUNC(op_11e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d8,An,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_11f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.B (xxx).W,(xxx).W */
void REGPARAM2 CPUFUNC(op_11f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (xxx).L,(xxx).W */
void REGPARAM2 CPUFUNC(op_11f9_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
	regs.irc = get_word_ce020_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.B (d16,PC),(xxx).W */
void REGPARAM2 CPUFUNC(op_11fa_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_11fb_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.B #<data>.B,(xxx).W */
void REGPARAM2 CPUFUNC(op_11fc_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_13c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.B (An),(xxx).L */
void REGPARAM2 CPUFUNC(op_13d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (An)+,(xxx).L */
void REGPARAM2 CPUFUNC(op_13d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B -(An),(xxx).L */
void REGPARAM2 CPUFUNC(op_13e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.B (d16,An),(xxx).L */
void REGPARAM2 CPUFUNC(op_13e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.B (d8,An,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_13f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}}return;
}

/* MOVE.B (xxx).W,(xxx).L */
void REGPARAM2 CPUFUNC(op_13f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.B (xxx).L,(xxx).L */
void REGPARAM2 CPUFUNC(op_13f9_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (6);
	regs.irc = get_word_ce020_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (10);
}}}}return;
}

/* MOVE.B (d16,PC),(xxx).L */
void REGPARAM2 CPUFUNC(op_13fa_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.B (d8,PC,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_13fb_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (4);
}}}}}return;
}

/* MOVE.B #<data>.B,(xxx).L */
void REGPARAM2 CPUFUNC(op_13fc_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_byte (dsta, src);
	m68k_incpci (8);
}}}return;
}

/* MOVE.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_2000_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L An,Dn */
void REGPARAM2 CPUFUNC(op_2008_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L (An),Dn */
void REGPARAM2 CPUFUNC(op_2010_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_2018_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_2020_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_2028_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_2030_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return;
}

/* MOVE.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_2038_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_2039_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_203a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_203b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return;
}

/* MOVE.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_203c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (6);
}}}return;
}

/* MOVEA.L Dn,An */
void REGPARAM2 CPUFUNC(op_2040_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	regs.irc = get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}return;
}

/* MOVEA.L An,An */
void REGPARAM2 CPUFUNC(op_2048_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	regs.irc = get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}return;
}

/* MOVEA.L (An),An */
void REGPARAM2 CPUFUNC(op_2050_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}}return;
}

/* MOVEA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_2058_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}}return;
}

/* MOVEA.L -(An),An */
void REGPARAM2 CPUFUNC(op_2060_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}}return;
}

/* MOVEA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_2068_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
}}}}return;
}

/* MOVEA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_2070_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
}}}}}return;
}

/* MOVEA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_2078_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
}}}}return;
}

/* MOVEA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_2079_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (6);
}}}}return;
}

/* MOVEA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_207a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
}}}}return;
}

/* MOVEA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_207b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
}}}}}return;
}

/* MOVEA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_207c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_2080_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L An,(An) */
void REGPARAM2 CPUFUNC(op_2088_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L (An),(An) */
void REGPARAM2 CPUFUNC(op_2090_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (An)+,(An) */
void REGPARAM2 CPUFUNC(op_2098_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L -(An),(An) */
void REGPARAM2 CPUFUNC(op_20a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (d16,An),(An) */
void REGPARAM2 CPUFUNC(op_20a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,An,Xn),(An) */
void REGPARAM2 CPUFUNC(op_20b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (xxx).W,(An) */
void REGPARAM2 CPUFUNC(op_20b8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (xxx).L,(An) */
void REGPARAM2 CPUFUNC(op_20b9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d16,PC),(An) */
void REGPARAM2 CPUFUNC(op_20ba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),(An) */
void REGPARAM2 CPUFUNC(op_20bb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L #<data>.L,(An) */
void REGPARAM2 CPUFUNC(op_20bc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_20c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L An,(An)+ */
void REGPARAM2 CPUFUNC(op_20c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L (An),(An)+ */
void REGPARAM2 CPUFUNC(op_20d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_20d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L -(An),(An)+ */
void REGPARAM2 CPUFUNC(op_20e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (d16,An),(An)+ */
void REGPARAM2 CPUFUNC(op_20e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,An,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_20f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (xxx).W,(An)+ */
void REGPARAM2 CPUFUNC(op_20f8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (xxx).L,(An)+ */
void REGPARAM2 CPUFUNC(op_20f9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d16,PC),(An)+ */
void REGPARAM2 CPUFUNC(op_20fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_20fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L #<data>.L,(An)+ */
void REGPARAM2 CPUFUNC(op_20fc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 4;
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_2100_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	/* op H:0,T:2,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L An,-(An) */
void REGPARAM2 CPUFUNC(op_2108_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	/* op H:0,T:2,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.L (An),-(An) */
void REGPARAM2 CPUFUNC(op_2110_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (An)+,-(An) */
void REGPARAM2 CPUFUNC(op_2118_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L -(An),-(An) */
void REGPARAM2 CPUFUNC(op_2120_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.L (d16,An),-(An) */
void REGPARAM2 CPUFUNC(op_2128_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,An,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_2130_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (xxx).W,-(An) */
void REGPARAM2 CPUFUNC(op_2138_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (xxx).L,-(An) */
void REGPARAM2 CPUFUNC(op_2139_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d16,PC),-(An) */
void REGPARAM2 CPUFUNC(op_213a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_213b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L #<data>.L,-(An) */
void REGPARAM2 CPUFUNC(op_213c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_2140_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.L An,(d16,An) */
void REGPARAM2 CPUFUNC(op_2148_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.L (An),(d16,An) */
void REGPARAM2 CPUFUNC(op_2150_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (An)+,(d16,An) */
void REGPARAM2 CPUFUNC(op_2158_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L -(An),(d16,An) */
void REGPARAM2 CPUFUNC(op_2160_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d16,An),(d16,An) */
void REGPARAM2 CPUFUNC(op_2168_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d8,An,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_2170_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.L (xxx).W,(d16,An) */
void REGPARAM2 CPUFUNC(op_2178_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (xxx).L,(d16,An) */
void REGPARAM2 CPUFUNC(op_2179_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
	regs.irc = get_word_ce020_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.L (d16,PC),(d16,An) */
void REGPARAM2 CPUFUNC(op_217a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_217b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.L #<data>.L,(d16,An) */
void REGPARAM2 CPUFUNC(op_217c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
	regs.irc = get_word_ce020_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}return;
}

/* MOVE.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2180_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}return;
}

/* MOVE.L An,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2188_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}return;
}

/* MOVE.L (An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2190_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (An)+,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_2198_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

#endif

#ifdef PART_3
/* MOVE.L -(An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (d16,An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 1);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}}return;
}

/* MOVE.L (xxx).W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21b8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (xxx).L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21b9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (d16,PC),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21ba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}return;
}

/* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21bb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 1);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}}}return;
}

/* MOVE.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_21bc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
}}}}return;
}

/* MOVE.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_21c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.L An,(xxx).W */
void REGPARAM2 CPUFUNC(op_21c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.L (An),(xxx).W */
void REGPARAM2 CPUFUNC(op_21d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (An)+,(xxx).W */
void REGPARAM2 CPUFUNC(op_21d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L -(An),(xxx).W */
void REGPARAM2 CPUFUNC(op_21e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.L (d16,An),(xxx).W */
void REGPARAM2 CPUFUNC(op_21e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d8,An,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_21f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.L (xxx).W,(xxx).W */
void REGPARAM2 CPUFUNC(op_21f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (xxx).L,(xxx).W */
void REGPARAM2 CPUFUNC(op_21f9_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
	regs.irc = get_word_ce020_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.L (d16,PC),(xxx).W */
void REGPARAM2 CPUFUNC(op_21fa_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_21fb_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.L #<data>.L,(xxx).W */
void REGPARAM2 CPUFUNC(op_21fc_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
	regs.irc = get_word_ce020_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}return;
}

/* MOVE.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_23c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.L An,(xxx).L */
void REGPARAM2 CPUFUNC(op_23c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.L (An),(xxx).L */
void REGPARAM2 CPUFUNC(op_23d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (An)+,(xxx).L */
void REGPARAM2 CPUFUNC(op_23d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L -(An),(xxx).L */
void REGPARAM2 CPUFUNC(op_23e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.L (d16,An),(xxx).L */
void REGPARAM2 CPUFUNC(op_23e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.L (d8,An,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_23f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}}return;
}

/* MOVE.L (xxx).W,(xxx).L */
void REGPARAM2 CPUFUNC(op_23f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.L (xxx).L,(xxx).L */
void REGPARAM2 CPUFUNC(op_23f9_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (6);
	regs.irc = get_word_ce020_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (10);
}}}}return;
}

/* MOVE.L (d16,PC),(xxx).L */
void REGPARAM2 CPUFUNC(op_23fa_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.L (d8,PC,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_23fb_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (4);
}}}}}return;
}

/* MOVE.L #<data>.L,(xxx).L */
void REGPARAM2 CPUFUNC(op_23fc_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 fiea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (6);
	regs.irc = get_word_ce020_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_long (dsta, src);
	m68k_incpci (10);
}}}return;
}

/* MOVE.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_3000_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W An,Dn */
void REGPARAM2 CPUFUNC(op_3008_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W (An),Dn */
void REGPARAM2 CPUFUNC(op_3010_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_3018_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_3020_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_3028_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_3030_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return;
}

/* MOVE.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_3038_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_3039_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_303a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_303b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return;
}

/* MOVE.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_303c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
}}}return;
}

/* MOVEA.W Dn,An */
void REGPARAM2 CPUFUNC(op_3040_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
}}}return;
}

/* MOVEA.W An,An */
void REGPARAM2 CPUFUNC(op_3048_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	/* op H:2,T:0,C:0 */
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
}}}return;
}

/* MOVEA.W (An),An */
void REGPARAM2 CPUFUNC(op_3050_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
}}}}return;
}

/* MOVEA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_3058_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
}}}}return;
}

/* MOVEA.W -(An),An */
void REGPARAM2 CPUFUNC(op_3060_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
}}}}return;
}

/* MOVEA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_3068_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
}}}}return;
}

/* MOVEA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_3070_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
}}}}}return;
}

/* MOVEA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_3078_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
}}}}return;
}

/* MOVEA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_3079_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (6);
}}}}return;
}

/* MOVEA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_307a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
}}}}return;
}

/* MOVEA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_307b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
}}}}}return;
}

/* MOVEA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_307c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_3080_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W An,(An) */
void REGPARAM2 CPUFUNC(op_3088_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W (An),(An) */
void REGPARAM2 CPUFUNC(op_3090_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (An)+,(An) */
void REGPARAM2 CPUFUNC(op_3098_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W -(An),(An) */
void REGPARAM2 CPUFUNC(op_30a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (d16,An),(An) */
void REGPARAM2 CPUFUNC(op_30a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,An,Xn),(An) */
void REGPARAM2 CPUFUNC(op_30b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (xxx).W,(An) */
void REGPARAM2 CPUFUNC(op_30b8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (xxx).L,(An) */
void REGPARAM2 CPUFUNC(op_30b9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d16,PC),(An) */
void REGPARAM2 CPUFUNC(op_30ba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),(An) */
void REGPARAM2 CPUFUNC(op_30bb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_30bc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_30c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W An,(An)+ */
void REGPARAM2 CPUFUNC(op_30c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W (An),(An)+ */
void REGPARAM2 CPUFUNC(op_30d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_30d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W -(An),(An)+ */
void REGPARAM2 CPUFUNC(op_30e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (d16,An),(An)+ */
void REGPARAM2 CPUFUNC(op_30e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,An,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_30f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (xxx).W,(An)+ */
void REGPARAM2 CPUFUNC(op_30f8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (xxx).L,(An)+ */
void REGPARAM2 CPUFUNC(op_30f9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d16,PC),(An)+ */
void REGPARAM2 CPUFUNC(op_30fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),(An)+ */
void REGPARAM2 CPUFUNC(op_30fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_30fc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += 2;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_3100_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	/* op H:0,T:2,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W An,-(An) */
void REGPARAM2 CPUFUNC(op_3108_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	/* op H:0,T:2,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}return;
}

/* MOVE.W (An),-(An) */
void REGPARAM2 CPUFUNC(op_3110_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (An)+,-(An) */
void REGPARAM2 CPUFUNC(op_3118_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W -(An),-(An) */
void REGPARAM2 CPUFUNC(op_3120_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}return;
}

/* MOVE.W (d16,An),-(An) */
void REGPARAM2 CPUFUNC(op_3128_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,An,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_3130_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (xxx).W,-(An) */
void REGPARAM2 CPUFUNC(op_3138_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (xxx).L,-(An) */
void REGPARAM2 CPUFUNC(op_3139_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d16,PC),-(An) */
void REGPARAM2 CPUFUNC(op_313a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),-(An) */
void REGPARAM2 CPUFUNC(op_313b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_313c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	m68k_areg (regs, dstreg) = dsta;
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_3140_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W An,(d16,An) */
void REGPARAM2 CPUFUNC(op_3148_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W (An),(d16,An) */
void REGPARAM2 CPUFUNC(op_3150_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (An)+,(d16,An) */
void REGPARAM2 CPUFUNC(op_3158_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W -(An),(d16,An) */
void REGPARAM2 CPUFUNC(op_3160_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d16,An),(d16,An) */
void REGPARAM2 CPUFUNC(op_3168_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d8,An,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_3170_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.W (xxx).W,(d16,An) */
void REGPARAM2 CPUFUNC(op_3178_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (xxx).L,(d16,An) */
void REGPARAM2 CPUFUNC(op_3179_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
	regs.irc = get_word_ce020_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.W (d16,PC),(d16,An) */
void REGPARAM2 CPUFUNC(op_317a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),(d16,An) */
void REGPARAM2 CPUFUNC(op_317b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_317c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3180_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}return;
}

/* MOVE.W An,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3188_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}return;
}

/* MOVE.W (An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3190_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (An)+,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_3198_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W -(An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (d16,An),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 1);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}}return;
}

/* MOVE.W (xxx).W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31b8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (xxx).L,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31b9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	m68k_incpci (6);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (d16,PC),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31ba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}return;
}

/* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31bb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 1);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}}}return;
}

/* MOVE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_31bc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
}}}}return;
}

/* MOVE.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_31c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W An,(xxx).W */
void REGPARAM2 CPUFUNC(op_31c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}return;
}

/* MOVE.W (An),(xxx).W */
void REGPARAM2 CPUFUNC(op_31d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (An)+,(xxx).W */
void REGPARAM2 CPUFUNC(op_31d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W -(An),(xxx).W */
void REGPARAM2 CPUFUNC(op_31e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}return;
}

/* MOVE.W (d16,An),(xxx).W */
void REGPARAM2 CPUFUNC(op_31e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d8,An,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_31f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.W (xxx).W,(xxx).W */
void REGPARAM2 CPUFUNC(op_31f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (xxx).L,(xxx).W */
void REGPARAM2 CPUFUNC(op_31f9_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (6);
	regs.irc = get_word_ce020_prefetch (8);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.W (d16,PC),(xxx).W */
void REGPARAM2 CPUFUNC(op_31fa_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),(xxx).W */
void REGPARAM2 CPUFUNC(op_31fb_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (2);
}}}}}return;
}

/* MOVE.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_31fc_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (2);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_33c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.W An,(xxx).L */
void REGPARAM2 CPUFUNC(op_33c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}return;
}

/* MOVE.W (An),(xxx).L */
void REGPARAM2 CPUFUNC(op_33d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (An)+,(xxx).L */
void REGPARAM2 CPUFUNC(op_33d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W -(An),(xxx).L */
void REGPARAM2 CPUFUNC(op_33e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (6);
}}}}return;
}

/* MOVE.W (d16,An),(xxx).L */
void REGPARAM2 CPUFUNC(op_33e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.W (d8,An,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_33f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}}return;
}

/* MOVE.W (xxx).W,(xxx).L */
void REGPARAM2 CPUFUNC(op_33f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.W (xxx).L,(xxx).L */
void REGPARAM2 CPUFUNC(op_33f9_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (6);
	regs.irc = get_word_ce020_prefetch (10);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (10);
}}}}return;
}

/* MOVE.W (d16,PC),(xxx).L */
void REGPARAM2 CPUFUNC(op_33fa_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (8);
}}}}return;
}

/* MOVE.W (d8,PC,Xn),(xxx).L */
void REGPARAM2 CPUFUNC(op_33fb_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (0);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (4);
}}}}}return;
}

/* MOVE.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_33fc_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 fiea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
	regs.irc = get_word_ce020_prefetch (8);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:6 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (4);
	x_put_word (dsta, src);
	m68k_incpci (8);
}}}return;
}

/* NEGX.B Dn */
void REGPARAM2 CPUFUNC(op_4000_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* NEGX.B (An) */
void REGPARAM2 CPUFUNC(op_4010_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.B (An)+ */
void REGPARAM2 CPUFUNC(op_4018_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.B -(An) */
void REGPARAM2 CPUFUNC(op_4020_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4028_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (4);
return;
}

/* NEGX.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4030_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}}return;
}

/* NEGX.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4038_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (4);
return;
}

/* NEGX.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4039_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, newv);
}}}}}	m68k_incpci (6);
return;
}

/* NEGX.W Dn */
void REGPARAM2 CPUFUNC(op_4040_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* NEGX.W (An) */
void REGPARAM2 CPUFUNC(op_4050_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.W (An)+ */
void REGPARAM2 CPUFUNC(op_4058_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.W -(An) */
void REGPARAM2 CPUFUNC(op_4060_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4068_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}	m68k_incpci (4);
return;
}

/* NEGX.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4070_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}}return;
}

/* NEGX.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4078_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}	m68k_incpci (4);
return;
}

/* NEGX.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4079_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, newv);
}}}}}	m68k_incpci (6);
return;
}

/* NEGX.L Dn */
void REGPARAM2 CPUFUNC(op_4080_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* NEGX.L (An) */
void REGPARAM2 CPUFUNC(op_4090_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.L (An)+ */
void REGPARAM2 CPUFUNC(op_4098_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.L -(An) */
void REGPARAM2 CPUFUNC(op_40a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}	m68k_incpci (2);
return;
}

/* NEGX.L (d16,An) */
void REGPARAM2 CPUFUNC(op_40a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}	m68k_incpci (4);
return;
}

/* NEGX.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_40b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}}return;
}

/* NEGX.L (xxx).W */
void REGPARAM2 CPUFUNC(op_40b8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}	m68k_incpci (4);
return;
}

/* NEGX.L (xxx).L */
void REGPARAM2 CPUFUNC(op_40b9_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, newv);
}}}}}	m68k_incpci (6);
return;
}

/* MVSR2.W Dn */
void REGPARAM2 CPUFUNC(op_40c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210632; }
{{	/* op H:2,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((regs.sr) & 0xffff);
}}}	m68k_incpci (2);
l_210632: ;
return;
}

/* MVSR2.W (An) */
void REGPARAM2 CPUFUNC(op_40d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210633; }
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}	m68k_incpci (2);
l_210633: ;
return;
}

/* MVSR2.W (An)+ */
void REGPARAM2 CPUFUNC(op_40d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210634; }
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	MakeSR ();
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}	m68k_incpci (2);
l_210634: ;
return;
}

/* MVSR2.W -(An) */
void REGPARAM2 CPUFUNC(op_40e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210635; }
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}	m68k_incpci (2);
l_210635: ;
return;
}

/* MVSR2.W (d16,An) */
void REGPARAM2 CPUFUNC(op_40e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210636; }
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}	m68k_incpci (4);
l_210636: ;
return;
}

/* MVSR2.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_40f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210637; }
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}}l_210637: ;
return;
}

/* MVSR2.W (xxx).W */
void REGPARAM2 CPUFUNC(op_40f8_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210638; }
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}	m68k_incpci (4);
l_210638: ;
return;
}

/* MVSR2.W (xxx).L */
void REGPARAM2 CPUFUNC(op_40f9_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210639; }
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (6);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr);
}}}	m68k_incpci (6);
l_210639: ;
return;
}

/* CHK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4100_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210640;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210640;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}l_210640: ;
return;
}

#endif
/* CHK.L (An),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4110_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210641;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210641;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210641: ;
return;
}

#endif
/* CHK.L (An)+,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4118_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210642;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210642;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210642: ;
return;
}

#endif
/* CHK.L -(An),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4120_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210643;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210643;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210643: ;
return;
}

#endif
/* CHK.L (d16,An),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4128_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210644;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210644;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210644: ;
return;
}

#endif
/* CHK.L (d8,An,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4130_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210645;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210645;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}}l_210645: ;
return;
}

#endif
/* CHK.L (xxx).W,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4138_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210646;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210646;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210646: ;
return;
}

#endif
/* CHK.L (xxx).L,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4139_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (6);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210647;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210647;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210647: ;
return;
}

#endif
/* CHK.L (d16,PC),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_413a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210648;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210648;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210648: ;
return;
}

#endif
/* CHK.L (d8,PC,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_413b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210649;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210649;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}}l_210649: ;
return;
}

#endif
/* CHK.L #<data>.L,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_413c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (6);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210650;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210650;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}l_210650: ;
return;
}

#endif
/* CHK.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_4180_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210651;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210651;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}l_210651: ;
return;
}

/* CHK.W (An),Dn */
void REGPARAM2 CPUFUNC(op_4190_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210652;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210652;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210652: ;
return;
}

/* CHK.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_4198_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210653;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210653;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210653: ;
return;
}

/* CHK.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_41a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210654;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210654;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210654: ;
return;
}

/* CHK.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_41a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210655;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210655;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210655: ;
return;
}

/* CHK.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_41b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210656;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210656;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}}l_210656: ;
return;
}

/* CHK.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_41b8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210657;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210657;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210657: ;
return;
}

/* CHK.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_41b9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (6);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210658;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210658;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210658: ;
return;
}

/* CHK.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_41ba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210659;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210659;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}l_210659: ;
return;
}

/* CHK.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_41bb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210660;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210660;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}}l_210660: ;
return;
}

/* CHK.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_41bc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* OP zero */
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_210661;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_210661;
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}l_210661: ;
return;
}

/* LEA.L (An),An */
void REGPARAM2 CPUFUNC(op_41d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (2);
return;
}

/* LEA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_41e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce020_prefetch (4);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return;
}

/* LEA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_41f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce020_prefetch (0);
	m68k_areg (regs, dstreg) = (srca);
}}}}return;
}

/* LEA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_41f8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce020_prefetch (4);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return;
}

/* LEA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_41f9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce020_prefetch (6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (6);
return;
}

/* LEA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_41fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce020_prefetch (4);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return;
}

/* LEA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_41fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	/* op H:2-,T:0,C:0 */
	regs.irc = get_word_ce020_prefetch (0);
	m68k_areg (regs, dstreg) = (srca);
}}}}return;
}

/* CLR.B Dn */
void REGPARAM2 CPUFUNC(op_4200_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((0) & 0xff);
}}	m68k_incpci (2);
return;
}

/* CLR.B (An) */
void REGPARAM2 CPUFUNC(op_4210_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.B (An)+ */
void REGPARAM2 CPUFUNC(op_4218_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.B -(An) */
void REGPARAM2 CPUFUNC(op_4220_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4228_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}	m68k_incpci (4);
return;
}

/* CLR.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4230_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}}return;
}

/* CLR.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4238_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}	m68k_incpci (4);
return;
}

/* CLR.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4239_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, 0);
}}	m68k_incpci (6);
return;
}

/* CLR.W Dn */
void REGPARAM2 CPUFUNC(op_4240_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((0) & 0xffff);
}}	m68k_incpci (2);
return;
}

/* CLR.W (An) */
void REGPARAM2 CPUFUNC(op_4250_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.W (An)+ */
void REGPARAM2 CPUFUNC(op_4258_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.W -(An) */
void REGPARAM2 CPUFUNC(op_4260_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4268_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}	m68k_incpci (4);
return;
}

/* CLR.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4270_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}}return;
}

/* CLR.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4278_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}	m68k_incpci (4);
return;
}

/* CLR.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4279_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, 0);
}}	m68k_incpci (6);
return;
}

/* CLR.L Dn */
void REGPARAM2 CPUFUNC(op_4280_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:2,T:0,C:0 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (0);
}}	m68k_incpci (2);
return;
}

/* CLR.L (An) */
void REGPARAM2 CPUFUNC(op_4290_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.L (An)+ */
void REGPARAM2 CPUFUNC(op_4298_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += 4;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.L -(An) */
void REGPARAM2 CPUFUNC(op_42a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}	m68k_incpci (2);
return;
}

/* CLR.L (d16,An) */
void REGPARAM2 CPUFUNC(op_42a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}	m68k_incpci (4);
return;
}

/* CLR.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_42b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}}return;
}

/* CLR.L (xxx).W */
void REGPARAM2 CPUFUNC(op_42b8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}	m68k_incpci (4);
return;
}

/* CLR.L (xxx).L */
void REGPARAM2 CPUFUNC(op_42b9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, 0);
}}	m68k_incpci (6);
return;
}

/* MVSR2.B Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:2,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((regs.sr & 0xff) & 0xffff);
}}	m68k_incpci (2);
return;
}

#endif
/* MVSR2.B (An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}	m68k_incpci (2);
return;
}

#endif
/* MVSR2.B (An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:2 */
	MakeSR ();
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}	m68k_incpci (2);
return;
}

#endif
/* MVSR2.B -(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	m68k_areg (regs, srcreg) = srca;
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}	m68k_incpci (2);
return;
}

#endif
/* MVSR2.B (d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}	m68k_incpci (4);
return;
}

#endif
/* MVSR2.B (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}}return;
}

#endif
/* MVSR2.B (xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42f8_21)(uae_u32 opcode)
{
{	/* ea H:2+2=4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}	m68k_incpci (4);
return;
}

#endif
/* MVSR2.B (xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_42f9_21)(uae_u32 opcode)
{
{	/* ea H:4+2=6,T:0,C:0 cea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	/* op H:2-,T:0,C:2 */
	MakeSR ();
	regs.irc = get_word_ce020_prefetch (6);
	do_cycles_ce020_internal (2);
	x_put_word (srca, regs.sr & 0xff);
}}	m68k_incpci (6);
return;
}

#endif
/* NEG.B Dn */
void REGPARAM2 CPUFUNC(op_4400_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}}}	m68k_incpci (2);
return;
}

#endif

#ifdef PART_4
/* NEG.B (An) */
void REGPARAM2 CPUFUNC(op_4410_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.B (An)+ */
void REGPARAM2 CPUFUNC(op_4418_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.B -(An) */
void REGPARAM2 CPUFUNC(op_4420_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4428_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (4);
return;
}

/* NEG.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4430_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}}return;
}

/* NEG.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4438_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (4);
return;
}

/* NEG.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4439_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}}	m68k_incpci (6);
return;
}

/* NEG.W Dn */
void REGPARAM2 CPUFUNC(op_4440_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}}}	m68k_incpci (2);
return;
}

/* NEG.W (An) */
void REGPARAM2 CPUFUNC(op_4450_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.W (An)+ */
void REGPARAM2 CPUFUNC(op_4458_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.W -(An) */
void REGPARAM2 CPUFUNC(op_4460_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4468_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}	m68k_incpci (4);
return;
}

/* NEG.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4470_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}}return;
}

/* NEG.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4478_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}	m68k_incpci (4);
return;
}

/* NEG.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4479_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}}	m68k_incpci (6);
return;
}

/* NEG.L Dn */
void REGPARAM2 CPUFUNC(op_4480_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (dst);
}}}}}	m68k_incpci (2);
return;
}

/* NEG.L (An) */
void REGPARAM2 CPUFUNC(op_4490_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.L (An)+ */
void REGPARAM2 CPUFUNC(op_4498_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.L -(An) */
void REGPARAM2 CPUFUNC(op_44a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}	m68k_incpci (2);
return;
}

/* NEG.L (d16,An) */
void REGPARAM2 CPUFUNC(op_44a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}	m68k_incpci (4);
return;
}

/* NEG.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_44b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}}return;
}

/* NEG.L (xxx).W */
void REGPARAM2 CPUFUNC(op_44b8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}	m68k_incpci (4);
return;
}

/* NEG.L (xxx).L */
void REGPARAM2 CPUFUNC(op_44b9_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}}	m68k_incpci (6);
return;
}

/* MV2SR.B Dn */
void REGPARAM2 CPUFUNC(op_44c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* op H:4,T:0,C:0 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
}}	m68k_incpci (2);
return;
}

/* MV2SR.B (An) */
void REGPARAM2 CPUFUNC(op_44d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (2);
return;
}

/* MV2SR.B (An)+ */
void REGPARAM2 CPUFUNC(op_44d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (2);
return;
}

/* MV2SR.B -(An) */
void REGPARAM2 CPUFUNC(op_44e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (2);
return;
}

/* MV2SR.B (d16,An) */
void REGPARAM2 CPUFUNC(op_44e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (4);
return;
}

/* MV2SR.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_44f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}}return;
}

/* MV2SR.B (xxx).W */
void REGPARAM2 CPUFUNC(op_44f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (4);
return;
}

/* MV2SR.B (xxx).L */
void REGPARAM2 CPUFUNC(op_44f9_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (6);
return;
}

/* MV2SR.B (d16,PC) */
void REGPARAM2 CPUFUNC(op_44fa_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (4);
return;
}

/* MV2SR.B (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_44fb_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}}}return;
}

/* MV2SR.B #<data>.B */
void REGPARAM2 CPUFUNC(op_44fc_21)(uae_u32 opcode)
{
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (2);
}}	m68k_incpci (4);
return;
}

/* NOT.B Dn */
void REGPARAM2 CPUFUNC(op_4600_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}	m68k_incpci (2);
return;
}

/* NOT.B (An) */
void REGPARAM2 CPUFUNC(op_4610_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.B (An)+ */
void REGPARAM2 CPUFUNC(op_4618_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.B -(An) */
void REGPARAM2 CPUFUNC(op_4620_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4628_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}	m68k_incpci (4);
return;
}

/* NOT.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4630_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}}return;
}

/* NOT.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4638_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}	m68k_incpci (4);
return;
}

/* NOT.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4639_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (srca, dst);
}}}}	m68k_incpci (6);
return;
}

/* NOT.W Dn */
void REGPARAM2 CPUFUNC(op_4640_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}	m68k_incpci (2);
return;
}

/* NOT.W (An) */
void REGPARAM2 CPUFUNC(op_4650_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.W (An)+ */
void REGPARAM2 CPUFUNC(op_4658_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.W -(An) */
void REGPARAM2 CPUFUNC(op_4660_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4668_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}	m68k_incpci (4);
return;
}

/* NOT.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4670_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}}return;
}

/* NOT.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4678_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}	m68k_incpci (4);
return;
}

/* NOT.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4679_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (srca, dst);
}}}}	m68k_incpci (6);
return;
}

/* NOT.L Dn */
void REGPARAM2 CPUFUNC(op_4680_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return;
}

/* NOT.L (An) */
void REGPARAM2 CPUFUNC(op_4690_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.L (An)+ */
void REGPARAM2 CPUFUNC(op_4698_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.L -(An) */
void REGPARAM2 CPUFUNC(op_46a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}	m68k_incpci (2);
return;
}

/* NOT.L (d16,An) */
void REGPARAM2 CPUFUNC(op_46a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}	m68k_incpci (4);
return;
}

/* NOT.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_46b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}}return;
}

/* NOT.L (xxx).W */
void REGPARAM2 CPUFUNC(op_46b8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}	m68k_incpci (4);
return;
}

/* NOT.L (xxx).L */
void REGPARAM2 CPUFUNC(op_46b9_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (srca, dst);
}}}}	m68k_incpci (6);
return;
}

/* MV2SR.W Dn */
void REGPARAM2 CPUFUNC(op_46c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210760; }
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}	m68k_incpci (2);
l_210760: ;
return;
}

/* MV2SR.W (An) */
void REGPARAM2 CPUFUNC(op_46d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210761; }
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (2);
l_210761: ;
return;
}

/* MV2SR.W (An)+ */
void REGPARAM2 CPUFUNC(op_46d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210762; }
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (2);
l_210762: ;
return;
}

/* MV2SR.W -(An) */
void REGPARAM2 CPUFUNC(op_46e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210763; }
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (2);
l_210763: ;
return;
}

/* MV2SR.W (d16,An) */
void REGPARAM2 CPUFUNC(op_46e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210764; }
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (4);
l_210764: ;
return;
}

/* MV2SR.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_46f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210765; }
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}}l_210765: ;
return;
}

/* MV2SR.W (xxx).W */
void REGPARAM2 CPUFUNC(op_46f8_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210766; }
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (4);
l_210766: ;
return;
}

/* MV2SR.W (xxx).L */
void REGPARAM2 CPUFUNC(op_46f9_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210767; }
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (6);
l_210767: ;
return;
}

/* MV2SR.W (d16,PC) */
void REGPARAM2 CPUFUNC(op_46fa_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210768; }
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}	m68k_incpci (4);
l_210768: ;
return;
}

/* MV2SR.W (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_46fb_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210769; }
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}}}l_210769: ;
return;
}

/* MV2SR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_46fc_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210770; }
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	do_cycles_ce020_internal (6);
}}}	m68k_incpci (4);
l_210770: ;
return;
}

/* NBCD.B Dn */
void REGPARAM2 CPUFUNC(op_4800_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (4);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}	m68k_incpci (2);
return;
}

/* LINK.L An,#<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4808_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* op H:2,T:0,C:4 */
{	uaecptr olda;
	olda = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = olda;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 offs;
	offs = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	do_cycles_ce020_internal (4);
	x_put_long (olda, src);
	m68k_areg (regs, srcreg) = (m68k_areg (regs, 7));
	m68k_areg (regs, 7) += offs;
}}}}	m68k_incpci (6);
return;
}

#endif
/* NBCD.B (An) */
void REGPARAM2 CPUFUNC(op_4810_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}	m68k_incpci (2);
return;
}

/* NBCD.B (An)+ */
void REGPARAM2 CPUFUNC(op_4818_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}	m68k_incpci (2);
return;
}

/* NBCD.B -(An) */
void REGPARAM2 CPUFUNC(op_4820_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}	m68k_incpci (2);
return;
}

/* NBCD.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4828_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}	m68k_incpci (4);
return;
}

/* NBCD.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4830_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}}return;
}

/* NBCD.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4838_21)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}	m68k_incpci (4);
return;
}

/* NBCD.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4839_21)(uae_u32 opcode)
{
{{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	/* op H:0,T:0,C:6 */
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce020_prefetch (6);
	do_cycles_ce020_internal (4);
	x_put_byte (srca, newv);
}}}}	m68k_incpci (6);
return;
}

/* SWAP.W Dn */
void REGPARAM2 CPUFUNC(op_4840_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:4,T:0,C:0 */
{	uae_u32 dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return;
}

/* BKPTQ.L #<data> */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4848_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	m68k_incpci (2);
	op_illg (opcode);
}return;
}

#endif
/* PEA.L (An) */
void REGPARAM2 CPUFUNC(op_4850_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}	m68k_incpci (2);
return;
}

/* PEA.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4868_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}	m68k_incpci (4);
return;
}

/* PEA.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4870_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}}return;
}

/* PEA.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4878_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}	m68k_incpci (4);
return;
}

/* PEA.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4879_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}	m68k_incpci (6);
return;
}

/* PEA.L (d16,PC) */
void REGPARAM2 CPUFUNC(op_487a_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}	m68k_incpci (4);
return;
}

/* PEA.L (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_487b_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:2,C:2 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = dsta;
	do_cycles_ce020_internal (2);
	x_put_long (dsta, srca);
}}}}return;
}

/* EXT.W Dn */
void REGPARAM2 CPUFUNC(op_4880_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:4,T:0,C:0 */
{	uae_u16 dst = (uae_s16)(uae_s8)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}	m68k_incpci (2);
return;
}

/* MVMLE.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_4890_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { x_put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMLE.W #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_48a0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 0;
	do_cycles_ce020_internal (2);
{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	int type = get_cpu_model () >= 68020;
	while (amask) {
		srca -= 2;
		if (!type || movem_index2[amask] != dstreg)
			x_put_word (srca, m68k_areg (regs, movem_index2[amask]));
		else
			x_put_word (srca, m68k_areg (regs, movem_index2[amask]) - 2);
		amask = movem_next[amask];
	}
	while (dmask) { srca -= 2; x_put_word (srca, m68k_dreg (regs, movem_index2[dmask])); dmask = movem_next[dmask]; }
	m68k_areg (regs, dstreg) = srca;
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMLE.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_48a8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { x_put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMLE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_48b0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { x_put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs.irc = get_word_ce020_prefetch (0);
}}}}return;
}

/* MVMLE.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_48b8_21)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce020_prefetch (2);
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { x_put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMLE.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_48b9_21)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce020_prefetch (2);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (4);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_word (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 2; dmask = movem_next[dmask]; }
	while (amask) { x_put_word (srca, m68k_areg (regs, movem_index1[amask])); srca += 2; amask = movem_next[amask]; }
	regs.irc = get_word_ce020_prefetch (8);
}}}	m68k_incpci (8);
return;
}

/* EXT.L Dn */
void REGPARAM2 CPUFUNC(op_48c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:4,T:0,C:0 */
{	uae_u32 dst = (uae_s32)(uae_s16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return;
}

/* MVMLE.L #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_48d0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { x_put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMLE.L #<data>.W,-(An) */
void REGPARAM2 CPUFUNC(op_48e0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 0;
	do_cycles_ce020_internal (2);
{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	int type = get_cpu_model () >= 68020;
	while (amask) {
		srca -= 4;
		if (!type || movem_index2[amask] != dstreg)
			x_put_long (srca, m68k_areg (regs, movem_index2[amask]));
		else
			x_put_long (srca, m68k_areg (regs, movem_index2[amask]) - 4);
		amask = movem_next[amask];
	}
	while (dmask) { srca -= 4; x_put_long (srca, m68k_dreg (regs, movem_index2[dmask])); dmask = movem_next[dmask]; }
	m68k_areg (regs, dstreg) = srca;
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMLE.L #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_48e8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { x_put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMLE.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_48f0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { x_put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs.irc = get_word_ce020_prefetch (0);
}}}}return;
}

/* MVMLE.L #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_48f8_21)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce020_prefetch (2);
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { x_put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMLE.L #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_48f9_21)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce020_prefetch (2);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (4);
	do_cycles_ce020_internal (2);
{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) { x_put_long (srca, m68k_dreg (regs, movem_index1[dmask])); srca += 4; dmask = movem_next[dmask]; }
	while (amask) { x_put_long (srca, m68k_areg (regs, movem_index1[amask])); srca += 4; amask = movem_next[amask]; }
	regs.irc = get_word_ce020_prefetch (8);
}}}	m68k_incpci (8);
return;
}

/* EXT.B Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_49c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:4,T:0,C:0 */
{	uae_u32 dst = (uae_s32)(uae_s8)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return;
}

#endif
/* TST.B Dn */
void REGPARAM2 CPUFUNC(op_4a00_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
}}	m68k_incpci (2);
return;
}

/* TST.B (An) */
void REGPARAM2 CPUFUNC(op_4a10_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.B (An)+ */
void REGPARAM2 CPUFUNC(op_4a18_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.B -(An) */
void REGPARAM2 CPUFUNC(op_4a20_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4a28_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

/* TST.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4a30_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}}return;
}

/* TST.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4a38_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

/* TST.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4a39_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (6);
return;
}

/* TST.B (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a3a_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

#endif
/* TST.B (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a3b_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}}return;
}

#endif
/* TST.B #<data>.B */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a3c_21)(uae_u32 opcode)
{
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}	m68k_incpci (4);
return;
}

#endif
/* TST.W Dn */
void REGPARAM2 CPUFUNC(op_4a40_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
}}	m68k_incpci (2);
return;
}

/* TST.W An */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a48_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}	m68k_incpci (2);
return;
}

#endif
/* TST.W (An) */
void REGPARAM2 CPUFUNC(op_4a50_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.W (An)+ */
void REGPARAM2 CPUFUNC(op_4a58_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.W -(An) */
void REGPARAM2 CPUFUNC(op_4a60_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.W (d16,An) */
void REGPARAM2 CPUFUNC(op_4a68_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

/* TST.W (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4a70_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}return;
}

/* TST.W (xxx).W */
void REGPARAM2 CPUFUNC(op_4a78_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

/* TST.W (xxx).L */
void REGPARAM2 CPUFUNC(op_4a79_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (6);
return;
}

/* TST.W (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a7a_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

#endif
/* TST.W (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a7b_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}return;
}

#endif
/* TST.W #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a7c_21)(uae_u32 opcode)
{
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}	m68k_incpci (4);
return;
}

#endif
/* TST.L Dn */
void REGPARAM2 CPUFUNC(op_4a80_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
}}	m68k_incpci (2);
return;
}

/* TST.L An */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4a88_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}	m68k_incpci (2);
return;
}

#endif
/* TST.L (An) */
void REGPARAM2 CPUFUNC(op_4a90_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.L (An)+ */
void REGPARAM2 CPUFUNC(op_4a98_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.L -(An) */
void REGPARAM2 CPUFUNC(op_4aa0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (2);
return;
}

/* TST.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4aa8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

/* TST.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4ab0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}return;
}

/* TST.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4ab8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

/* TST.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4ab9_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (6);
return;
}

/* TST.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4aba_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}	m68k_incpci (4);
return;
}

#endif
/* TST.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4abb_21)(uae_u32 opcode)
{
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}return;
}

#endif
/* TST.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4abc_21)(uae_u32 opcode)
{
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}	m68k_incpci (6);
return;
}

#endif
/* TAS.B Dn */
void REGPARAM2 CPUFUNC(op_4ac0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((src) & 0xff);
}}	m68k_incpci (2);
return;
}

/* TAS.B (An) */
void REGPARAM2 CPUFUNC(op_4ad0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}	m68k_incpci (2);
return;
}

/* TAS.B (An)+ */
void REGPARAM2 CPUFUNC(op_4ad8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}	m68k_incpci (2);
return;
}

/* TAS.B -(An) */
void REGPARAM2 CPUFUNC(op_4ae0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}	m68k_incpci (2);
return;
}

/* TAS.B (d16,An) */
void REGPARAM2 CPUFUNC(op_4ae8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}	m68k_incpci (4);
return;
}

/* TAS.B (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4af0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}}return;
}

/* TAS.B (xxx).W */
void REGPARAM2 CPUFUNC(op_4af8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}	m68k_incpci (4);
return;
}

/* TAS.B (xxx).L */
void REGPARAM2 CPUFUNC(op_4af9_21)(uae_u32 opcode)
{
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte (srca, src);
}}}	m68k_incpci (6);
return;
}

/* MULL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c00_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:28 */
	m68k_incpci (4);
	if (!m68k_mull(opcode, dst, extra)) goto l_210847;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (28);
}}}l_210847: ;
return;
}

#endif
/* MULL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c10_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci (4);
	if (!m68k_mull(opcode, dst, extra)) goto l_210848;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_210848: ;
return;
}

#endif
/* MULL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c18_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	/* op H:2,T:0,C:28 */
	m68k_incpci (4);
	if (!m68k_mull(opcode, dst, extra)) goto l_210849;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_210849: ;
return;
}

#endif
/* MULL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c20_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:2,T:0,C:28 */
	m68k_incpci (4);
	if (!m68k_mull(opcode, dst, extra)) goto l_210850;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_210850: ;
return;
}

#endif
/* MULL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c28_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci (6);
	if (!m68k_mull(opcode, dst, extra)) goto l_210851;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_210851: ;
return;
}

#endif
/* MULL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c30_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	if (!m68k_mull(opcode, dst, extra)) goto l_210852;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}}l_210852: ;
return;
}

#endif
/* MULL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c38_21)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci (6);
	if (!m68k_mull(opcode, dst, extra)) goto l_210853;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_210853: ;
return;
}

#endif
/* MULL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c39_21)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci (8);
	if (!m68k_mull(opcode, dst, extra)) goto l_210854;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_210854: ;
return;
}

#endif
/* MULL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c3a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci (6);
	if (!m68k_mull(opcode, dst, extra)) goto l_210855;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}l_210855: ;
return;
}

#endif
/* MULL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c3b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:2,T:0,C:28 */
	if (!m68k_mull(opcode, dst, extra)) goto l_210856;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (28);
}}}}}l_210856: ;
return;
}

#endif
/* MULL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c3c_21)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:28 */
{	uae_s32 dst;
	dst = get_long_ce020_prefetch (4);
	/* op H:2,T:0,C:28 */
	m68k_incpci (8);
	if (!m68k_mull(opcode, dst, extra)) goto l_210857;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (28);
}}}l_210857: ;
return;
}

#endif
/* DIVL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c40_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:0,T:0,C:50 */
	m68k_incpci (4);
	if (!m68k_divl(opcode, dst, extra)) goto l_210858;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (48);
}}}l_210858: ;
return;
}

#endif
/* DIVL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c50_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci (4);
	if (!m68k_divl(opcode, dst, extra)) goto l_210859;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_210859: ;
return;
}

#endif
/* DIVL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c58_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	/* op H:0,T:0,C:50 */
	m68k_incpci (4);
	if (!m68k_divl(opcode, dst, extra)) goto l_210860;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_210860: ;
return;
}

#endif
/* DIVL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c60_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:0,T:0,C:50 */
	m68k_incpci (4);
	if (!m68k_divl(opcode, dst, extra)) goto l_210861;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_210861: ;
return;
}

#endif
/* DIVL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c68_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci (6);
	if (!m68k_divl(opcode, dst, extra)) goto l_210862;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_210862: ;
return;
}

#endif
/* DIVL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c70_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	m68k_incpci (4);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	if (!m68k_divl(opcode, dst, extra)) goto l_210863;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}}l_210863: ;
return;
}

#endif
/* DIVL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c78_21)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci (6);
	if (!m68k_divl(opcode, dst, extra)) goto l_210864;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_210864: ;
return;
}

#endif
/* DIVL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c79_21)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci (8);
	if (!m68k_divl(opcode, dst, extra)) goto l_210865;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_210865: ;
return;
}

#endif
/* DIVL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c7a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci (6);
	if (!m68k_divl(opcode, dst, extra)) goto l_210866;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}l_210866: ;
return;
}

#endif
/* DIVL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c7b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uaecptr tmppc;
	uaecptr dsta;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	dsta = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 dst = x_get_long (dsta);
	/* op H:0,T:0,C:50 */
	if (!m68k_divl(opcode, dst, extra)) goto l_210867;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (48);
}}}}}l_210867: ;
return;
}

#endif
/* DIVL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4c7c_21)(uae_u32 opcode)
{
{{	uae_s16 extra = get_word_ce020_prefetch (2);
	/* op H:0,T:0,C:50 */
{	uae_s32 dst;
	dst = get_long_ce020_prefetch (4);
	/* op H:0,T:0,C:50 */
	m68k_incpci (8);
	if (!m68k_divl(opcode, dst, extra)) goto l_210868;
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (48);
}}}l_210868: ;
return;
}

#endif
/* MVMEL.W #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_4c90_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMEL.W #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_4c98_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	m68k_areg (regs, dstreg) = srca;
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMEL.W #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_4ca8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMEL.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4cb0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}return;
}

/* MVMEL.W #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_4cb8_21)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMEL.W #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_4cb9_21)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (8);
}}}	m68k_incpci (8);
return;
}

/* MVMEL.W #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_4cba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_getpci () + 4;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMEL.W #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4cbb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word (srca); srca += 2; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}return;
}

/* MVMEL.L #<data>.W,(An) */
void REGPARAM2 CPUFUNC(op_4cd0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMEL.L #<data>.W,(An)+ */
void REGPARAM2 CPUFUNC(op_4cd8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	m68k_areg (regs, dstreg) = srca;
	regs.irc = get_word_ce020_prefetch (4);
}}}	m68k_incpci (4);
return;
}

/* MVMEL.L #<data>.W,(d16,An) */
void REGPARAM2 CPUFUNC(op_4ce8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMEL.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4cf0_21)(uae_u32 opcode)
{
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	m68k_incpci (4);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}return;
}

/* MVMEL.L #<data>.W,(xxx).W */
void REGPARAM2 CPUFUNC(op_4cf8_21)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMEL.L #<data>.W,(xxx).L */
void REGPARAM2 CPUFUNC(op_4cf9_21)(uae_u32 opcode)
{
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (8);
}}}	m68k_incpci (8);
return;
}

/* MVMEL.L #<data>.W,(d16,PC) */
void REGPARAM2 CPUFUNC(op_4cfa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr srca;
	srca = m68k_getpci () + 4;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (6);
}}}	m68k_incpci (6);
return;
}

/* MVMEL.L #<data>.W,(d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4cfb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_word_ce020_prefetch (2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (4);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
	do_cycles_ce020_internal (6);
{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = x_get_long (srca); srca += 4; dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = x_get_long (srca); srca += 4; amask = movem_next[amask];
	}
	regs.irc = get_word_ce020_prefetch (0);
}}}}return;
}

/* TRAPQ.L #<data> */
void REGPARAM2 CPUFUNC(op_4e40_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 15);
{{	uae_u32 src = srcreg;
	/* OP zero */
	m68k_incpci (2);
	Exception (src + 32);
}}return;
}

/* LINK.W An,#<data>.W */
void REGPARAM2 CPUFUNC(op_4e50_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* op H:0,T:0,C:4 */
{	uaecptr olda;
	olda = m68k_areg (regs, 7) - 4;
	m68k_areg (regs, 7) = olda;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (2);
	x_put_long (olda, src);
	m68k_areg (regs, srcreg) = (m68k_areg (regs, 7));
	m68k_areg (regs, 7) += offs;
}}}}	m68k_incpci (4);
return;
}

/* UNLK.L An */
void REGPARAM2 CPUFUNC(op_4e58_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
	/* op H:0,T:0,C:5 */
	m68k_areg (regs, 7) = src;
{	uaecptr olda;
	olda = m68k_areg (regs, 7);
{	uae_s32 old = x_get_long (olda);
	m68k_areg (regs, 7) += 4;
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (3);
	m68k_areg (regs, srcreg) = (old);
}}}}	m68k_incpci (2);
return;
}

/* MVR2USP.L An */
void REGPARAM2 CPUFUNC(op_4e60_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210888; }
{{	uae_s32 src = m68k_areg (regs, srcreg);
	/* op H:4,T:0,C:0 */
	regs.usp = src;
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
}}}	m68k_incpci (2);
l_210888: ;
return;
}

/* MVUSP2R.L An */
void REGPARAM2 CPUFUNC(op_4e68_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_210889; }
{{	/* op H:4,T:0,C:0 */
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_areg (regs, srcreg) = (regs.usp);
}}}	m68k_incpci (2);
l_210889: ;
return;
}

/* RESET.L  */
void REGPARAM2 CPUFUNC(op_4e70_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210890; }
{	cpureset ();
	m68k_incpci (2);
	regs.irc = get_word_ce020_prefetch (0);
}}l_210890: ;
return;
}

/* NOP.L  */
void REGPARAM2 CPUFUNC(op_4e71_21)(uae_u32 opcode)
{
{	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
return;
}

/* STOP.L #<data>.W */
void REGPARAM2 CPUFUNC(op_4e72_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210892; }
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* op H:0,T:0,C:8 */
	regs.sr = src;
	MakeFromSR();
	regs.ipl_pin = intlev ();
	m68k_setstopped ();
	m68k_incpci (4);
	do_cycles_ce020_internal (6);
}}}l_210892: ;
return;
}

/* RTE.L  */
void REGPARAM2 CPUFUNC(op_4e73_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210893; }
{	/* op H:1,T:9,C:8 */
	uae_u16 newsr; uae_u32 newpc;
	for (;;) {
		uaecptr a = m68k_areg (regs, 7);
		uae_u16 sr = x_get_word (a);
		uae_u32 pc = x_get_long (a + 2);
		uae_u16 format = x_get_word (a + 2 + 4);
		int frame = format >> 12;
		int offset = 8;
		newsr = sr; newpc = pc;
	do_cycles_ce020_internal (6);
		if (frame == 0x0) { m68k_areg (regs, 7) += offset; break; }
		else if (frame == 0x1) { m68k_areg (regs, 7) += offset; }
		else if (frame == 0x2) { m68k_areg (regs, 7) += offset + 4; break; }
		else if (frame == 0x4) { m68k_areg (regs, 7) += offset + 8; break; }
		else if (frame == 0x8) { m68k_areg (regs, 7) += offset + 50; break; }
		else if (frame == 0x7) { m68k_areg (regs, 7) += offset + 52; break; }
		else if (frame == 0x9) { m68k_areg (regs, 7) += offset + 12; break; }
		else if (frame == 0xa) { m68k_areg (regs, 7) += offset + 24; break; }
		else if (frame == 0xb) { m68k_areg (regs, 7) += offset + 84; break; }
		else { m68k_areg (regs, 7) += offset; Exception (14); goto l_210893; }
		regs.sr = newsr;
	MakeFromSR();
	regs.ipl_pin = intlev ();
}
	regs.sr = newsr;
	do_cycles_ce020_internal (4);
	MakeFromSR();
	regs.ipl_pin = intlev ();
	if (newpc & 1) {
		exception3i (0x4E73, newpc);
		goto l_210893;
	}
	m68k_setpci (newpc);
	ipl_fetch ();
	fill_prefetch_020 ();
}}l_210893: ;
return;
}

/* RTD.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4e74_21)(uae_u32 opcode)
{
{	/* op H:2,T:0,C:8 */
{	uaecptr pca;
	pca = m68k_areg (regs, 7);
{	uae_s32 pc = x_get_long (pca);
	m68k_areg (regs, 7) += 4;
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:8 */
	m68k_areg (regs, 7) += offs;
	if (pc & 1) {
		exception3i (0x4E74, pc);
		goto l_210894;
	}
	m68k_setpci (pc);
	fill_prefetch_020 ();
}}}}l_210894: ;
return;
}

#endif
/* RTS.L  */
void REGPARAM2 CPUFUNC(op_4e75_21)(uae_u32 opcode)
{
{	/* op H:1,T:0,C:8 */
	uaecptr pc = m68k_getpci ();
	m68k_do_rts_ce020 ();
	if (m68k_getpci () & 1) {
		uaecptr faultpc = m68k_getpci ();
	m68k_setpci (pc);
		exception3i (0x4E75, faultpc);
		goto l_210895;
	}
	do_cycles_ce020_internal (3);
	fill_prefetch_020 ();
}l_210895: ;
return;
}

/* TRAPV.L  */
void REGPARAM2 CPUFUNC(op_4e76_21)(uae_u32 opcode)
{
{	m68k_incpci (2);
	if (GET_VFLG ()) {
		Exception (7);
		goto l_210896;
	}
	regs.irc = get_word_ce020_prefetch (0);
}l_210896: ;
return;
}

/* RTR.L  */
void REGPARAM2 CPUFUNC(op_4e77_21)(uae_u32 opcode)
{
{	uaecptr oldpc = m68k_getpci ();
	MakeSR ();
{	uaecptr sra;
	sra = m68k_areg (regs, 7);
{	uae_s16 sr = x_get_word (sra);
	m68k_areg (regs, 7) += 2;
{	uaecptr pca;
	pca = m68k_areg (regs, 7);
{	uae_s32 pc = x_get_long (pca);
	m68k_areg (regs, 7) += 4;
	regs.sr &= 0xFF00; sr &= 0xFF;
	regs.sr |= sr;
	m68k_setpci (pc);
	MakeFromSR();
	regs.ipl_pin = intlev ();
	if (m68k_getpci () & 1) {
		uaecptr faultpc = m68k_getpci ();
	m68k_setpci (oldpc);
		exception3i (0x4E77, faultpc);
		goto l_210897;
	}
	fill_prefetch_020 ();
}}}}}l_210897: ;
return;
}

/* MOVEC2.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4e7a_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210898; }
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* op H:6,T:0,C:0 */
{	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (! m68k_movec2(src & 0xFFF, regp)) goto l_210898;
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (4);
}}}}	m68k_incpci (4);
l_210898: ;
return;
}

#endif
/* MOVE2C.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_4e7b_21)(uae_u32 opcode)
{
{if (!regs.s) { Exception (8); goto l_210899; }
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* op H:6,T:0,C:0 */
{	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (! m68k_move2c(src & 0xFFF, regp)) goto l_210899;
	regs.irc = get_word_ce020_prefetch (4);
	do_cycles_ce020_internal (4);
}}}}	m68k_incpci (4);
l_210899: ;
return;
}

#endif
/* JSR.L (An) */
void REGPARAM2 CPUFUNC(op_4e90_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 jea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 2;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210900;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_020 ();
}}}l_210900: ;
return;
}

/* JSR.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4ea8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 jea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 4;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210901;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_020 ();
}}}l_210901: ;
return;
}

/* JSR.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4eb0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 jea */
	regs.ce020memcycles = 0;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 0;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210902;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_020 ();
}}}}l_210902: ;
return;
}

/* JSR.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4eb8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 jea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 4;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210903;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_020 ();
}}}l_210903: ;
return;
}

/* JSR.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4eb9_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 jea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 6;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210904;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_020 ();
}}}l_210904: ;
return;
}

/* JSR.L (d16,PC) */
void REGPARAM2 CPUFUNC(op_4eba_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 jea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 4;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210905;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_020 ();
}}}l_210905: ;
return;
}

/* JSR.L (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4ebb_21)(uae_u32 opcode)
{
{	/* ea H:0,T:0,C:0 jea */
	regs.ce020memcycles = 0;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uaecptr oldpc = m68k_getpci () + 0;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210906;
	}
	m68k_setpci (srca);
	m68k_areg (regs, 7) -= 4;
	x_put_long (m68k_areg (regs, 7), oldpc);
	fill_prefetch_020 ();
}}}}l_210906: ;
return;
}

/* JMP.L (An) */
void REGPARAM2 CPUFUNC(op_4ed0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2+4=6,T:0,C:0 jea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	/* op H:4-,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210907;
	}
	m68k_setpci (srca);
	fill_prefetch_020 ();
}}l_210907: ;
return;
}

/* JMP.L (d16,An) */
void REGPARAM2 CPUFUNC(op_4ee8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4+4=8,T:0,C:0 jea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	/* op H:4-,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210908;
	}
	m68k_setpci (srca);
	fill_prefetch_020 ();
}}l_210908: ;
return;
}

/* JMP.L (d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_4ef0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:0 jea */
	regs.ce020memcycles = 0;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210909;
	}
	m68k_setpci (srca);
	fill_prefetch_020 ();
}}}l_210909: ;
return;
}

/* JMP.L (xxx).W */
void REGPARAM2 CPUFUNC(op_4ef8_21)(uae_u32 opcode)
{
{	/* ea H:2+4=6,T:0,C:0 jea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	/* op H:4-,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210910;
	}
	m68k_setpci (srca);
	fill_prefetch_020 ();
}}l_210910: ;
return;
}

/* JMP.L (xxx).L */
void REGPARAM2 CPUFUNC(op_4ef9_21)(uae_u32 opcode)
{
{	/* ea H:2+4=6,T:0,C:0 jea */
	if (regs.ce020memcycles > 6 * cpucycleunit)
		regs.ce020memcycles = 6 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	/* op H:4-,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210911;
	}
	m68k_setpci (srca);
	fill_prefetch_020 ();
}}l_210911: ;
return;
}

/* JMP.L (d16,PC) */
void REGPARAM2 CPUFUNC(op_4efa_21)(uae_u32 opcode)
{
{	/* ea H:4+4=8,T:0,C:0 jea */
	if (regs.ce020memcycles > 8 * cpucycleunit)
		regs.ce020memcycles = 8 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	/* op H:4-,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210912;
	}
	m68k_setpci (srca);
	fill_prefetch_020 ();
}}l_210912: ;
return;
}

/* JMP.L (d8,PC,Xn) */
void REGPARAM2 CPUFUNC(op_4efb_21)(uae_u32 opcode)
{
{	/* ea H:0,T:0,C:0 jea */
	regs.ce020memcycles = 0;
{	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
	/* op H:4,T:0,C:0 */
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_210913;
	}
	m68k_setpci (srca);
	fill_prefetch_020 ();
}}}l_210913: ;
return;
}

/* ADDQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5000_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.B #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5010_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.B #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5018_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.B #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5020_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.B #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5028_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADDQ.B #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5030_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}}return;
}

/* ADDQ.B #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5038_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADDQ.B #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5039_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADDQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5040_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
}

/* ADDAQ.W #<data>,An */
void REGPARAM2 CPUFUNC(op_5048_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst + src;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* ADDQ.W #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5050_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.W #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5058_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.W #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5060_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.W #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5068_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADDQ.W #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5070_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}}return;
}

/* ADDQ.W #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5078_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADDQ.W #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5079_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* ADDQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5080_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
}

/* ADDAQ.L #<data>,An */
void REGPARAM2 CPUFUNC(op_5088_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst + src;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* ADDQ.L #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5090_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.L #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5098_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* ADDQ.L #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_50a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

#endif

#ifdef PART_5
/* ADDQ.L #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_50a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADDQ.L #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_50b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}}return;
}

/* ADDQ.L #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_50b8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* ADDQ.L #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_50b9_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* Scc.B Dn (T) */
void REGPARAM2 CPUFUNC(op_50c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (T) */
void REGPARAM2 CPUFUNC(op_50c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (0)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_210941;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_210941: ;
return;
}

/* Scc.B (An) (T) */
void REGPARAM2 CPUFUNC(op_50d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (T) */
void REGPARAM2 CPUFUNC(op_50d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (T) */
void REGPARAM2 CPUFUNC(op_50e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (T) */
void REGPARAM2 CPUFUNC(op_50e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (T) */
void REGPARAM2 CPUFUNC(op_50f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (T) */
void REGPARAM2 CPUFUNC(op_50f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (T) */
void REGPARAM2 CPUFUNC(op_50f9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (0) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (T) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_50fa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (0)) { Exception (7); goto l_210949; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_210949: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (T) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_50fb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (0)) { Exception (7); goto l_210950; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_210950: ;
return;
}

#endif
/* TRAPcc.L  (T) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_50fc_21)(uae_u32 opcode)
{
{	if (cctrue (0)) { Exception (7); goto l_210951; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_210951: ;
return;
}

#endif
/* SUBQ.B #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5100_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.B #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5110_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.B #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5118_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.B #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5120_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.B #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5128_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUBQ.B #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5130_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}}return;
}

/* SUBQ.B #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5138_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUBQ.B #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5139_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUBQ.W #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5140_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
}

/* SUBAQ.W #<data>,An */
void REGPARAM2 CPUFUNC(op_5148_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* SUBQ.W #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5150_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.W #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5158_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.W #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_5160_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.W #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_5168_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUBQ.W #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_5170_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}}return;
}

/* SUBQ.W #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_5178_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUBQ.W #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_5179_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUBQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_5180_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
}

/* SUBAQ.L #<data>,An */
void REGPARAM2 CPUFUNC(op_5188_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* SUBQ.L #<data>,(An) */
void REGPARAM2 CPUFUNC(op_5190_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.L #<data>,(An)+ */
void REGPARAM2 CPUFUNC(op_5198_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.L #<data>,-(An) */
void REGPARAM2 CPUFUNC(op_51a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUBQ.L #<data>,(d16,An) */
void REGPARAM2 CPUFUNC(op_51a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUBQ.L #<data>,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_51b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}}return;
}

/* SUBQ.L #<data>,(xxx).W */
void REGPARAM2 CPUFUNC(op_51b8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUBQ.L #<data>,(xxx).L */
void REGPARAM2 CPUFUNC(op_51b9_21)(uae_u32 opcode)
{
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* Scc.B Dn (F) */
void REGPARAM2 CPUFUNC(op_51c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (F) */
void REGPARAM2 CPUFUNC(op_51c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (1)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_210979;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_210979: ;
return;
}

/* Scc.B (An) (F) */
void REGPARAM2 CPUFUNC(op_51d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (F) */
void REGPARAM2 CPUFUNC(op_51d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (F) */
void REGPARAM2 CPUFUNC(op_51e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (F) */
void REGPARAM2 CPUFUNC(op_51e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (F) */
void REGPARAM2 CPUFUNC(op_51f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (F) */
void REGPARAM2 CPUFUNC(op_51f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (F) */
void REGPARAM2 CPUFUNC(op_51f9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (1) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (F) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_51fa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (1)) { Exception (7); goto l_210987; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_210987: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (F) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_51fb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (1)) { Exception (7); goto l_210988; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_210988: ;
return;
}

#endif
/* TRAPcc.L  (F) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_51fc_21)(uae_u32 opcode)
{
{	if (cctrue (1)) { Exception (7); goto l_210989; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_210989: ;
return;
}

#endif
/* Scc.B Dn (HI) */
void REGPARAM2 CPUFUNC(op_52c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (HI) */
void REGPARAM2 CPUFUNC(op_52c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (2)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_210991;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_210991: ;
return;
}

/* Scc.B (An) (HI) */
void REGPARAM2 CPUFUNC(op_52d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (HI) */
void REGPARAM2 CPUFUNC(op_52d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (HI) */
void REGPARAM2 CPUFUNC(op_52e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (HI) */
void REGPARAM2 CPUFUNC(op_52e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (HI) */
void REGPARAM2 CPUFUNC(op_52f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (HI) */
void REGPARAM2 CPUFUNC(op_52f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (HI) */
void REGPARAM2 CPUFUNC(op_52f9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (2) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (HI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_52fa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (2)) { Exception (7); goto l_210999; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_210999: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (HI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_52fb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (2)) { Exception (7); goto l_211000; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211000: ;
return;
}

#endif
/* TRAPcc.L  (HI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_52fc_21)(uae_u32 opcode)
{
{	if (cctrue (2)) { Exception (7); goto l_211001; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211001: ;
return;
}

#endif
/* Scc.B Dn (LS) */
void REGPARAM2 CPUFUNC(op_53c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (LS) */
void REGPARAM2 CPUFUNC(op_53c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (3)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211003;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211003: ;
return;
}

/* Scc.B (An) (LS) */
void REGPARAM2 CPUFUNC(op_53d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (LS) */
void REGPARAM2 CPUFUNC(op_53d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (LS) */
void REGPARAM2 CPUFUNC(op_53e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (LS) */
void REGPARAM2 CPUFUNC(op_53e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (LS) */
void REGPARAM2 CPUFUNC(op_53f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (LS) */
void REGPARAM2 CPUFUNC(op_53f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (LS) */
void REGPARAM2 CPUFUNC(op_53f9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (3) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (LS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_53fa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (3)) { Exception (7); goto l_211011; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211011: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (LS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_53fb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (3)) { Exception (7); goto l_211012; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211012: ;
return;
}

#endif
/* TRAPcc.L  (LS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_53fc_21)(uae_u32 opcode)
{
{	if (cctrue (3)) { Exception (7); goto l_211013; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211013: ;
return;
}

#endif
/* Scc.B Dn (CC) */
void REGPARAM2 CPUFUNC(op_54c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (CC) */
void REGPARAM2 CPUFUNC(op_54c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (4)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211015;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211015: ;
return;
}

/* Scc.B (An) (CC) */
void REGPARAM2 CPUFUNC(op_54d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (CC) */
void REGPARAM2 CPUFUNC(op_54d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (CC) */
void REGPARAM2 CPUFUNC(op_54e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (CC) */
void REGPARAM2 CPUFUNC(op_54e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (CC) */
void REGPARAM2 CPUFUNC(op_54f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (CC) */
void REGPARAM2 CPUFUNC(op_54f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (CC) */
void REGPARAM2 CPUFUNC(op_54f9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (4) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (CC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_54fa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (4)) { Exception (7); goto l_211023; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211023: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (CC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_54fb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (4)) { Exception (7); goto l_211024; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211024: ;
return;
}

#endif
/* TRAPcc.L  (CC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_54fc_21)(uae_u32 opcode)
{
{	if (cctrue (4)) { Exception (7); goto l_211025; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211025: ;
return;
}

#endif
/* Scc.B Dn (CS) */
void REGPARAM2 CPUFUNC(op_55c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (CS) */
void REGPARAM2 CPUFUNC(op_55c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (5)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211027;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211027: ;
return;
}

/* Scc.B (An) (CS) */
void REGPARAM2 CPUFUNC(op_55d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (CS) */
void REGPARAM2 CPUFUNC(op_55d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (CS) */
void REGPARAM2 CPUFUNC(op_55e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (CS) */
void REGPARAM2 CPUFUNC(op_55e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (CS) */
void REGPARAM2 CPUFUNC(op_55f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (CS) */
void REGPARAM2 CPUFUNC(op_55f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (CS) */
void REGPARAM2 CPUFUNC(op_55f9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (5) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (CS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_55fa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (5)) { Exception (7); goto l_211035; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211035: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (CS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_55fb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (5)) { Exception (7); goto l_211036; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211036: ;
return;
}

#endif
/* TRAPcc.L  (CS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_55fc_21)(uae_u32 opcode)
{
{	if (cctrue (5)) { Exception (7); goto l_211037; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211037: ;
return;
}

#endif
/* Scc.B Dn (NE) */
void REGPARAM2 CPUFUNC(op_56c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (NE) */
void REGPARAM2 CPUFUNC(op_56c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (6)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211039;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211039: ;
return;
}

/* Scc.B (An) (NE) */
void REGPARAM2 CPUFUNC(op_56d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (NE) */
void REGPARAM2 CPUFUNC(op_56d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (NE) */
void REGPARAM2 CPUFUNC(op_56e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (NE) */
void REGPARAM2 CPUFUNC(op_56e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (NE) */
void REGPARAM2 CPUFUNC(op_56f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (NE) */
void REGPARAM2 CPUFUNC(op_56f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (NE) */
void REGPARAM2 CPUFUNC(op_56f9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (6) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (NE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_56fa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (6)) { Exception (7); goto l_211047; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211047: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (NE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_56fb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (6)) { Exception (7); goto l_211048; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211048: ;
return;
}

#endif
/* TRAPcc.L  (NE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_56fc_21)(uae_u32 opcode)
{
{	if (cctrue (6)) { Exception (7); goto l_211049; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211049: ;
return;
}

#endif
/* Scc.B Dn (EQ) */
void REGPARAM2 CPUFUNC(op_57c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (EQ) */
void REGPARAM2 CPUFUNC(op_57c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (7)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211051;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211051: ;
return;
}

/* Scc.B (An) (EQ) */
void REGPARAM2 CPUFUNC(op_57d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (EQ) */
void REGPARAM2 CPUFUNC(op_57d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (EQ) */
void REGPARAM2 CPUFUNC(op_57e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (EQ) */
void REGPARAM2 CPUFUNC(op_57e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (EQ) */
void REGPARAM2 CPUFUNC(op_57f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (EQ) */
void REGPARAM2 CPUFUNC(op_57f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (EQ) */
void REGPARAM2 CPUFUNC(op_57f9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (7) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (EQ) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_57fa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (7)) { Exception (7); goto l_211059; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211059: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (EQ) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_57fb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (7)) { Exception (7); goto l_211060; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211060: ;
return;
}

#endif
/* TRAPcc.L  (EQ) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_57fc_21)(uae_u32 opcode)
{
{	if (cctrue (7)) { Exception (7); goto l_211061; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211061: ;
return;
}

#endif
/* Scc.B Dn (VC) */
void REGPARAM2 CPUFUNC(op_58c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (VC) */
void REGPARAM2 CPUFUNC(op_58c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (8)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211063;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211063: ;
return;
}

/* Scc.B (An) (VC) */
void REGPARAM2 CPUFUNC(op_58d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (VC) */
void REGPARAM2 CPUFUNC(op_58d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (VC) */
void REGPARAM2 CPUFUNC(op_58e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (VC) */
void REGPARAM2 CPUFUNC(op_58e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (VC) */
void REGPARAM2 CPUFUNC(op_58f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (VC) */
void REGPARAM2 CPUFUNC(op_58f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (VC) */
void REGPARAM2 CPUFUNC(op_58f9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (8) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (VC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_58fa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (8)) { Exception (7); goto l_211071; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211071: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (VC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_58fb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (8)) { Exception (7); goto l_211072; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211072: ;
return;
}

#endif
/* TRAPcc.L  (VC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_58fc_21)(uae_u32 opcode)
{
{	if (cctrue (8)) { Exception (7); goto l_211073; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211073: ;
return;
}

#endif
/* Scc.B Dn (VS) */
void REGPARAM2 CPUFUNC(op_59c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (VS) */
void REGPARAM2 CPUFUNC(op_59c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (9)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211075;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211075: ;
return;
}

/* Scc.B (An) (VS) */
void REGPARAM2 CPUFUNC(op_59d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (VS) */
void REGPARAM2 CPUFUNC(op_59d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (VS) */
void REGPARAM2 CPUFUNC(op_59e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (VS) */
void REGPARAM2 CPUFUNC(op_59e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (VS) */
void REGPARAM2 CPUFUNC(op_59f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (VS) */
void REGPARAM2 CPUFUNC(op_59f8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (VS) */
void REGPARAM2 CPUFUNC(op_59f9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (9) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (VS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_59fa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (9)) { Exception (7); goto l_211083; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211083: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (VS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_59fb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (9)) { Exception (7); goto l_211084; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211084: ;
return;
}

#endif
/* TRAPcc.L  (VS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_59fc_21)(uae_u32 opcode)
{
{	if (cctrue (9)) { Exception (7); goto l_211085; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211085: ;
return;
}

#endif
/* Scc.B Dn (PL) */
void REGPARAM2 CPUFUNC(op_5ac0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (PL) */
void REGPARAM2 CPUFUNC(op_5ac8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (10)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211087;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211087: ;
return;
}

/* Scc.B (An) (PL) */
void REGPARAM2 CPUFUNC(op_5ad0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (PL) */
void REGPARAM2 CPUFUNC(op_5ad8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (PL) */
void REGPARAM2 CPUFUNC(op_5ae0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (PL) */
void REGPARAM2 CPUFUNC(op_5ae8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (PL) */
void REGPARAM2 CPUFUNC(op_5af0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (PL) */
void REGPARAM2 CPUFUNC(op_5af8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (PL) */
void REGPARAM2 CPUFUNC(op_5af9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (10) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (PL) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5afa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (10)) { Exception (7); goto l_211095; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211095: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (PL) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5afb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (10)) { Exception (7); goto l_211096; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211096: ;
return;
}

#endif
/* TRAPcc.L  (PL) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5afc_21)(uae_u32 opcode)
{
{	if (cctrue (10)) { Exception (7); goto l_211097; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211097: ;
return;
}

#endif
/* Scc.B Dn (MI) */
void REGPARAM2 CPUFUNC(op_5bc0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (MI) */
void REGPARAM2 CPUFUNC(op_5bc8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (11)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211099;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211099: ;
return;
}

/* Scc.B (An) (MI) */
void REGPARAM2 CPUFUNC(op_5bd0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (MI) */
void REGPARAM2 CPUFUNC(op_5bd8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (MI) */
void REGPARAM2 CPUFUNC(op_5be0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (MI) */
void REGPARAM2 CPUFUNC(op_5be8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (MI) */
void REGPARAM2 CPUFUNC(op_5bf0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (MI) */
void REGPARAM2 CPUFUNC(op_5bf8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (MI) */
void REGPARAM2 CPUFUNC(op_5bf9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (11) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (MI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5bfa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (11)) { Exception (7); goto l_211107; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211107: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (MI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5bfb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (11)) { Exception (7); goto l_211108; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211108: ;
return;
}

#endif
/* TRAPcc.L  (MI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5bfc_21)(uae_u32 opcode)
{
{	if (cctrue (11)) { Exception (7); goto l_211109; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211109: ;
return;
}

#endif
/* Scc.B Dn (GE) */
void REGPARAM2 CPUFUNC(op_5cc0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (GE) */
void REGPARAM2 CPUFUNC(op_5cc8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (12)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211111;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211111: ;
return;
}

/* Scc.B (An) (GE) */
void REGPARAM2 CPUFUNC(op_5cd0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (GE) */
void REGPARAM2 CPUFUNC(op_5cd8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (GE) */
void REGPARAM2 CPUFUNC(op_5ce0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (GE) */
void REGPARAM2 CPUFUNC(op_5ce8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (GE) */
void REGPARAM2 CPUFUNC(op_5cf0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (GE) */
void REGPARAM2 CPUFUNC(op_5cf8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (GE) */
void REGPARAM2 CPUFUNC(op_5cf9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (12) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (GE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5cfa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (12)) { Exception (7); goto l_211119; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211119: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (GE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5cfb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (12)) { Exception (7); goto l_211120; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211120: ;
return;
}

#endif
/* TRAPcc.L  (GE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5cfc_21)(uae_u32 opcode)
{
{	if (cctrue (12)) { Exception (7); goto l_211121; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211121: ;
return;
}

#endif
/* Scc.B Dn (LT) */
void REGPARAM2 CPUFUNC(op_5dc0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (LT) */
void REGPARAM2 CPUFUNC(op_5dc8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (13)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211123;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211123: ;
return;
}

/* Scc.B (An) (LT) */
void REGPARAM2 CPUFUNC(op_5dd0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (LT) */
void REGPARAM2 CPUFUNC(op_5dd8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (LT) */
void REGPARAM2 CPUFUNC(op_5de0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (LT) */
void REGPARAM2 CPUFUNC(op_5de8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (LT) */
void REGPARAM2 CPUFUNC(op_5df0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (LT) */
void REGPARAM2 CPUFUNC(op_5df8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (LT) */
void REGPARAM2 CPUFUNC(op_5df9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (13) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (LT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5dfa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (13)) { Exception (7); goto l_211131; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211131: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (LT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5dfb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (13)) { Exception (7); goto l_211132; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211132: ;
return;
}

#endif
/* TRAPcc.L  (LT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5dfc_21)(uae_u32 opcode)
{
{	if (cctrue (13)) { Exception (7); goto l_211133; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211133: ;
return;
}

#endif
/* Scc.B Dn (GT) */
void REGPARAM2 CPUFUNC(op_5ec0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (GT) */
void REGPARAM2 CPUFUNC(op_5ec8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (14)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211135;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211135: ;
return;
}

/* Scc.B (An) (GT) */
void REGPARAM2 CPUFUNC(op_5ed0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (GT) */
void REGPARAM2 CPUFUNC(op_5ed8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (GT) */
void REGPARAM2 CPUFUNC(op_5ee0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (GT) */
void REGPARAM2 CPUFUNC(op_5ee8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (GT) */
void REGPARAM2 CPUFUNC(op_5ef0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (GT) */
void REGPARAM2 CPUFUNC(op_5ef8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (GT) */
void REGPARAM2 CPUFUNC(op_5ef9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (14) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (GT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5efa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (14)) { Exception (7); goto l_211143; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211143: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (GT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5efb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (14)) { Exception (7); goto l_211144; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211144: ;
return;
}

#endif
/* TRAPcc.L  (GT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5efc_21)(uae_u32 opcode)
{
{	if (cctrue (14)) { Exception (7); goto l_211145; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211145: ;
return;
}

#endif
/* Scc.B Dn (LE) */
void REGPARAM2 CPUFUNC(op_5fc0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{{	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* DBcc.W Dn,#<data>.W (LE) */
void REGPARAM2 CPUFUNC(op_5fc8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = get_word_ce020_prefetch (2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (15)) {
	m68k_incpci ((uae_s32)offs + 2);
			m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_211147;
			}
	fill_prefetch_020 ();
			return;
		}
	} else {
	}
	m68k_setpci (oldpc + 4);
	continue_ce020_prefetch();
}}}l_211147: ;
return;
}

/* Scc.B (An) (LE) */
void REGPARAM2 CPUFUNC(op_5fd0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (An)+ (LE) */
void REGPARAM2 CPUFUNC(op_5fd8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:0,T:0,C:2 cea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B -(An) (LE) */
void REGPARAM2 CPUFUNC(op_5fe0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (2);
return;
}

/* Scc.B (d16,An) (LE) */
void REGPARAM2 CPUFUNC(op_5fe8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (d8,An,Xn) (LE) */
void REGPARAM2 CPUFUNC(op_5ff0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}}return;
}

/* Scc.B (xxx).W (LE) */
void REGPARAM2 CPUFUNC(op_5ff8_21)(uae_u32 opcode)
{
{	/* ea H:2,T:0,C:0 cea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (4);
return;
}

/* Scc.B (xxx).L (LE) */
void REGPARAM2 CPUFUNC(op_5ff9_21)(uae_u32 opcode)
{
{	/* ea H:4,T:0,C:0 cea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{	int val = cctrue (15) ? 0xff : 0;
	x_put_byte (srca, val);
}}}}	m68k_incpci (6);
return;
}

/* TRAPcc.L #<data>.W (LE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5ffa_21)(uae_u32 opcode)
{
{{	uae_s16 dummy = get_word_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (15)) { Exception (7); goto l_211155; }
	regs.irc = get_word_ce020_prefetch (4);
}}	m68k_incpci (4);
l_211155: ;
return;
}

#endif
/* TRAPcc.L #<data>.L (LE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5ffb_21)(uae_u32 opcode)
{
{{	uae_s32 dummy;
	dummy = get_long_ce020_prefetch (2);
	/* OP zero */
	if (cctrue (15)) { Exception (7); goto l_211156; }
	regs.irc = get_word_ce020_prefetch (6);
}}	m68k_incpci (6);
l_211156: ;
return;
}

#endif
/* TRAPcc.L  (LE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_5ffc_21)(uae_u32 opcode)
{
{	if (cctrue (15)) { Exception (7); goto l_211157; }
	regs.irc = get_word_ce020_prefetch (2);
}	m68k_incpci (2);
l_211157: ;
return;
}

#endif
/* Bcc.W #<data>.W (T) */
void REGPARAM2 CPUFUNC(op_6000_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211158;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211158: ;
return;
}

/* BccQ.B #<data> (T) */
void REGPARAM2 CPUFUNC(op_6001_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211159;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211159: ;
return;
}

/* Bcc.L #<data>.L (T) */
void REGPARAM2 CPUFUNC(op_60ff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211160;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211160: ;
return;
}

/* BSR.W #<data>.W */
void REGPARAM2 CPUFUNC(op_6100_21)(uae_u32 opcode)
{
{	uae_s32 s;
{	uae_s16 src = get_word_ce020_prefetch (2);
	/* op H:2,T:0,C:4 */
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3b (opcode, m68k_getpci () + s, 0, 1, m68k_getpci () + s);
		goto l_211161;
	}
	m68k_do_bsr_ce020 (m68k_getpci () + 4, s);
	fill_prefetch_020 ();
}}l_211161: ;
return;
}

/* BSRQ.B #<data> */
void REGPARAM2 CPUFUNC(op_6101_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{	uae_s32 s;
{	uae_u32 src = srcreg;
	/* op H:2,T:0,C:4 */
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3b (opcode, m68k_getpci () + s, 0, 1, m68k_getpci () + s);
		goto l_211162;
	}
	m68k_do_bsr_ce020 (m68k_getpci () + 2, s);
	fill_prefetch_020 ();
}}l_211162: ;
return;
}

/* BSR.L #<data>.L */
void REGPARAM2 CPUFUNC(op_61ff_21)(uae_u32 opcode)
{
{	uae_s32 s;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* op H:2,T:0,C:4 */
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3b (opcode, m68k_getpci () + s, 0, 1, m68k_getpci () + s);
		goto l_211163;
	}
	m68k_do_bsr_ce020 (m68k_getpci () + 6, s);
	fill_prefetch_020 ();
}}l_211163: ;
return;
}

/* Bcc.W #<data>.W (HI) */
void REGPARAM2 CPUFUNC(op_6200_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211164;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211164: ;
return;
}

/* BccQ.B #<data> (HI) */
void REGPARAM2 CPUFUNC(op_6201_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211165;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211165: ;
return;
}

/* Bcc.L #<data>.L (HI) */
void REGPARAM2 CPUFUNC(op_62ff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211166;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211166: ;
return;
}

/* Bcc.W #<data>.W (LS) */
void REGPARAM2 CPUFUNC(op_6300_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211167;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211167: ;
return;
}

/* BccQ.B #<data> (LS) */
void REGPARAM2 CPUFUNC(op_6301_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211168;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211168: ;
return;
}

#endif

#ifdef PART_6
/* Bcc.L #<data>.L (LS) */
void REGPARAM2 CPUFUNC(op_63ff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211169;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211169: ;
return;
}

/* Bcc.W #<data>.W (CC) */
void REGPARAM2 CPUFUNC(op_6400_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211170;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211170: ;
return;
}

/* BccQ.B #<data> (CC) */
void REGPARAM2 CPUFUNC(op_6401_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211171;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211171: ;
return;
}

/* Bcc.L #<data>.L (CC) */
void REGPARAM2 CPUFUNC(op_64ff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211172;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211172: ;
return;
}

/* Bcc.W #<data>.W (CS) */
void REGPARAM2 CPUFUNC(op_6500_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211173;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211173: ;
return;
}

/* BccQ.B #<data> (CS) */
void REGPARAM2 CPUFUNC(op_6501_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211174;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211174: ;
return;
}

/* Bcc.L #<data>.L (CS) */
void REGPARAM2 CPUFUNC(op_65ff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211175;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211175: ;
return;
}

/* Bcc.W #<data>.W (NE) */
void REGPARAM2 CPUFUNC(op_6600_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211176;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211176: ;
return;
}

/* BccQ.B #<data> (NE) */
void REGPARAM2 CPUFUNC(op_6601_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211177;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211177: ;
return;
}

/* Bcc.L #<data>.L (NE) */
void REGPARAM2 CPUFUNC(op_66ff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211178;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211178: ;
return;
}

/* Bcc.W #<data>.W (EQ) */
void REGPARAM2 CPUFUNC(op_6700_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211179;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211179: ;
return;
}

/* BccQ.B #<data> (EQ) */
void REGPARAM2 CPUFUNC(op_6701_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211180;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211180: ;
return;
}

/* Bcc.L #<data>.L (EQ) */
void REGPARAM2 CPUFUNC(op_67ff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211181;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211181: ;
return;
}

/* Bcc.W #<data>.W (VC) */
void REGPARAM2 CPUFUNC(op_6800_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211182;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211182: ;
return;
}

/* BccQ.B #<data> (VC) */
void REGPARAM2 CPUFUNC(op_6801_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211183;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211183: ;
return;
}

/* Bcc.L #<data>.L (VC) */
void REGPARAM2 CPUFUNC(op_68ff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211184;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211184: ;
return;
}

/* Bcc.W #<data>.W (VS) */
void REGPARAM2 CPUFUNC(op_6900_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211185;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211185: ;
return;
}

/* BccQ.B #<data> (VS) */
void REGPARAM2 CPUFUNC(op_6901_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211186;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211186: ;
return;
}

/* Bcc.L #<data>.L (VS) */
void REGPARAM2 CPUFUNC(op_69ff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211187;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211187: ;
return;
}

/* Bcc.W #<data>.W (PL) */
void REGPARAM2 CPUFUNC(op_6a00_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211188;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211188: ;
return;
}

/* BccQ.B #<data> (PL) */
void REGPARAM2 CPUFUNC(op_6a01_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211189;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211189: ;
return;
}

/* Bcc.L #<data>.L (PL) */
void REGPARAM2 CPUFUNC(op_6aff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211190;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211190: ;
return;
}

/* Bcc.W #<data>.W (MI) */
void REGPARAM2 CPUFUNC(op_6b00_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211191;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211191: ;
return;
}

/* BccQ.B #<data> (MI) */
void REGPARAM2 CPUFUNC(op_6b01_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211192;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211192: ;
return;
}

/* Bcc.L #<data>.L (MI) */
void REGPARAM2 CPUFUNC(op_6bff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211193;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211193: ;
return;
}

/* Bcc.W #<data>.W (GE) */
void REGPARAM2 CPUFUNC(op_6c00_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211194;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211194: ;
return;
}

/* BccQ.B #<data> (GE) */
void REGPARAM2 CPUFUNC(op_6c01_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211195;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211195: ;
return;
}

/* Bcc.L #<data>.L (GE) */
void REGPARAM2 CPUFUNC(op_6cff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211196;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211196: ;
return;
}

/* Bcc.W #<data>.W (LT) */
void REGPARAM2 CPUFUNC(op_6d00_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211197;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211197: ;
return;
}

/* BccQ.B #<data> (LT) */
void REGPARAM2 CPUFUNC(op_6d01_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211198;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211198: ;
return;
}

/* Bcc.L #<data>.L (LT) */
void REGPARAM2 CPUFUNC(op_6dff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211199;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211199: ;
return;
}

/* Bcc.W #<data>.W (GT) */
void REGPARAM2 CPUFUNC(op_6e00_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211200;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211200: ;
return;
}

/* BccQ.B #<data> (GT) */
void REGPARAM2 CPUFUNC(op_6e01_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211201;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211201: ;
return;
}

/* Bcc.L #<data>.L (GT) */
void REGPARAM2 CPUFUNC(op_6eff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211202;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211202: ;
return;
}

/* Bcc.W #<data>.W (LE) */
void REGPARAM2 CPUFUNC(op_6f00_21)(uae_u32 opcode)
{
{{	uae_s16 src = get_word_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211203;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (4);
	continue_ce020_prefetch();
}}l_211203: ;
return;
}

/* BccQ.B #<data> (LE) */
void REGPARAM2 CPUFUNC(op_6f01_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	/* OP zero */
	if (!cctrue (15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211204;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (2);
	continue_ce020_prefetch();
}}l_211204: ;
return;
}

/* Bcc.L #<data>.L (LE) */
void REGPARAM2 CPUFUNC(op_6fff_21)(uae_u32 opcode)
{
{{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
	/* OP zero */
	if (!cctrue (15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_211205;
	}
	m68k_incpci ((uae_s32)src + 2);
	fill_prefetch_020 ();
	return;
didnt_jump:;
	m68k_incpci (6);
	continue_ce020_prefetch();
}}l_211205: ;
return;
}

/* MOVEQ.L #<data>,Dn */
void REGPARAM2 CPUFUNC(op_7000_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_u32 src = srcreg;
{	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
}}}return;
}

/* OR.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_8000_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (2);
return;
}

/* OR.B (An),Dn */
void REGPARAM2 CPUFUNC(op_8010_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* OR.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_8018_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* OR.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_8020_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* OR.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_8028_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
}

/* OR.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_8030_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return;
}

/* OR.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_8038_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
}

/* OR.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_8039_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (6);
return;
}

/* OR.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_803a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
}

/* OR.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_803b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return;
}

/* OR.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_803c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
}

/* OR.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_8040_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (2);
return;
}

/* OR.W (An),Dn */
void REGPARAM2 CPUFUNC(op_8050_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* OR.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_8058_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* OR.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_8060_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* OR.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_8068_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (4);
return;
}

/* OR.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_8070_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return;
}

/* OR.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_8078_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (4);
return;
}

/* OR.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_8079_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (6);
return;
}

/* OR.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_807a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (4);
return;
}

/* OR.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_807b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return;
}

/* OR.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_807c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
}

/* OR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_8080_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return;
}

/* OR.L (An),Dn */
void REGPARAM2 CPUFUNC(op_8090_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (2);
return;
}

/* OR.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_8098_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (2);
return;
}

/* OR.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_80a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (2);
return;
}

/* OR.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_80a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (4);
return;
}

/* OR.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return;
}

/* OR.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_80b8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (4);
return;
}

/* OR.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_80b9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (6);
return;
}

/* OR.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_80ba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (4);
return;
}

/* OR.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80bb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return;
}

/* OR.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_80bc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
}

/* DIVU.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_80c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:52 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_211240;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (52);
}}}l_211240: ;
return;
}

/* DIVU.W (An),Dn */
void REGPARAM2 CPUFUNC(op_80d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_211241;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
	do_cycles_ce020_internal (52);
}}}}l_211241: ;
return;
}

/* DIVU.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_80d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_211242;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
	do_cycles_ce020_internal (52);
}}}}l_211242: ;
return;
}

/* DIVU.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_80e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_211243;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
	do_cycles_ce020_internal (52);
}}}}l_211243: ;
return;
}

/* DIVU.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_80e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_211244;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
	do_cycles_ce020_internal (52);
}}}}l_211244: ;
return;
}

/* DIVU.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (0);
		Exception (5);
		goto l_211245;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	do_cycles_ce020_internal (52);
}}}}}l_211245: ;
return;
}

/* DIVU.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_80f8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_211246;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
	do_cycles_ce020_internal (52);
}}}}l_211246: ;
return;
}

/* DIVU.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_80f9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (6);
		Exception (5);
		goto l_211247;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (6);
	}
	do_cycles_ce020_internal (52);
}}}}l_211247: ;
return;
}

/* DIVU.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_80fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_211248;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
	do_cycles_ce020_internal (52);
}}}}l_211248: ;
return;
}

/* DIVU.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_80fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (0);
		Exception (5);
		goto l_211249;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	do_cycles_ce020_internal (52);
}}}}}l_211249: ;
return;
}

/* DIVU.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_80fc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	CLEAR_CZNV ();
	if (src == 0) {
		divbyzero_special (0, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_211250;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
	do_cycles_ce020_internal (52);
}}}l_211250: ;
return;
}

/* SBCD.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_8100_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:0,T:0,C:4 */
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG () ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG ((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG () ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* SBCD.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_8108_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	/* op H:2,T:1,C:10 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:2,T:1,C:10 */
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG () ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG ((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG () ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (11);
	x_put_byte (dsta, newv);
}}}}}}	m68k_incpci (2);
return;
}

/* OR.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_8110_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_8118_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_8120_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_8128_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_8130_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}}return;
}

/* OR.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_8138_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_8139_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* PACK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_8140_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uae_u16 val = m68k_dreg (regs, srcreg) + get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & 0xffffff00) | ((val >> 4) & 0xf0) | (val & 0xf);
	regs.irc = get_word_ce020_prefetch (4);
}	m68k_incpci (4);
return;
}

#endif
/* PACK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_8148_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uae_u16 val;
	m68k_areg (regs, srcreg) -= areg_byteinc[srcreg];
	val = (uae_u16)(x_get_byte (m68k_areg (regs, srcreg)) & 0xff);
	m68k_areg (regs, srcreg) -= areg_byteinc[srcreg];
	val = (val | ((uae_u16)(x_get_byte (m68k_areg (regs, srcreg)) & 0xff) << 8)) + get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) -= areg_byteinc[dstreg];
	x_put_byte (m68k_areg (regs, dstreg),((val >> 4) & 0xf0) | (val & 0xf));
	regs.irc = get_word_ce020_prefetch (4);
}	m68k_incpci (4);
return;
}

#endif
/* OR.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_8150_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_8158_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_8160_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_8168_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_8170_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}}return;
}

/* OR.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_8178_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_8179_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* UNPK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_8180_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uae_u16 val = m68k_dreg (regs, srcreg);
	val = (((val << 4) & 0xf00) | (val & 0xf)) + get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & 0xffff0000) | (val & 0xffff);
	regs.irc = get_word_ce020_prefetch (4);
}	m68k_incpci (4);
return;
}

#endif
/* UNPK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 CPUFUNC(op_8188_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uae_u16 val;
	m68k_areg (regs, srcreg) -= areg_byteinc[srcreg];
	val = (uae_u16)(x_get_byte (m68k_areg (regs, srcreg)) & 0xff);
	val = (((val << 4) & 0xf00) | (val & 0xf)) + get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) -= 2 * areg_byteinc[dstreg];
	x_put_byte (m68k_areg (regs, dstreg) + areg_byteinc[dstreg], val);
	x_put_byte (m68k_areg (regs, dstreg), val >> 8);
	regs.irc = get_word_ce020_prefetch (4);
}	m68k_incpci (4);
return;
}

#endif
/* OR.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_8190_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_8198_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_81a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* OR.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_81a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_81b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}}return;
}

/* OR.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_81b8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* OR.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_81b9_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* DIVS.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_81c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:52 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_211278;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
	regs.irc = get_word_ce020_prefetch (0);
	do_cycles_ce020_internal (52);
}}}l_211278: ;
return;
}

/* DIVS.W (An),Dn */
void REGPARAM2 CPUFUNC(op_81d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_211279;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
	do_cycles_ce020_internal (52);
}}}}l_211279: ;
return;
}

/* DIVS.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_81d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_211280;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
	do_cycles_ce020_internal (52);
}}}}l_211280: ;
return;
}

/* DIVS.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_81e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (2);
		Exception (5);
		goto l_211281;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
	do_cycles_ce020_internal (52);
}}}}l_211281: ;
return;
}

/* DIVS.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_81e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_211282;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
	do_cycles_ce020_internal (52);
}}}}l_211282: ;
return;
}

/* DIVS.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_81f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (0);
		Exception (5);
		goto l_211283;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	do_cycles_ce020_internal (52);
}}}}}l_211283: ;
return;
}

/* DIVS.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_81f8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_211284;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
	do_cycles_ce020_internal (52);
}}}}l_211284: ;
return;
}

/* DIVS.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_81f9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (6);
		Exception (5);
		goto l_211285;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (6);
	do_cycles_ce020_internal (52);
}}}}l_211285: ;
return;
}

/* DIVS.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_81fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_211286;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
	do_cycles_ce020_internal (52);
}}}}l_211286: ;
return;
}

/* DIVS.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_81fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (0);
		Exception (5);
		goto l_211287;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	do_cycles_ce020_internal (52);
}}}}}l_211287: ;
return;
}

/* DIVS.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_81fc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:54 */
	if (src == 0) {
		divbyzero_special (1, dst);
	m68k_incpci (4);
		Exception (5);
		goto l_211288;
	}
	CLEAR_CZNV ();
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
	do_cycles_ce020_internal (52);
}}}l_211288: ;
return;
}

/* SUB.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_9000_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B (An),Dn */
void REGPARAM2 CPUFUNC(op_9010_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_9018_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_9020_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_9028_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_9030_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}}return;
}

/* SUB.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_9038_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_9039_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_903a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_903b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}}return;
}

/* SUB.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_903c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_9040_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W An,Dn */
void REGPARAM2 CPUFUNC(op_9048_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W (An),Dn */
void REGPARAM2 CPUFUNC(op_9050_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_9058_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_9060_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_9068_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_9070_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}return;
}

/* SUB.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_9078_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_9079_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_907a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_907b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}return;
}

/* SUB.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_907c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return;
}

/* SUB.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_9080_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L An,Dn */
void REGPARAM2 CPUFUNC(op_9088_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L (An),Dn */
void REGPARAM2 CPUFUNC(op_9090_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_9098_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_90a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_90a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_90b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}return;
}

/* SUB.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_90b8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_90b9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUB.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_90ba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_90bb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}return;
}

/* SUB.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_90bc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return;
}

/* SUBA.W Dn,An */
void REGPARAM2 CPUFUNC(op_90c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:4,T:0,C:0 */
{	uae_u32 newv = dst - src;
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* SUBA.W An,An */
void REGPARAM2 CPUFUNC(op_90c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:4,T:0,C:0 */
{	uae_u32 newv = dst - src;
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* SUBA.W (An),An */
void REGPARAM2 CPUFUNC(op_90d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_90d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBA.W -(An),An */
void REGPARAM2 CPUFUNC(op_90e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_90e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (4);
return;
}

/* SUBA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_90f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return;
}

/* SUBA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_90f8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (4);
return;
}

/* SUBA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_90f9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (6);
return;
}

/* SUBA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_90fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (4);
return;
}

/* SUBA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_90fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return;
}

/* SUBA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_90fc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{	uae_u32 newv = dst - src;
	do_cycles_ce020_internal (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (4);
return;
}

/* SUBX.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_9100_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}	m68k_incpci (2);
return;
}

/* SUBX.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_9108_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	/* op H:2,T:1,C:6 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:2,T:1,C:6 */
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (7);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_9110_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_9118_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_9120_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_9128_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_9130_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}}return;
}

/* SUB.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_9138_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_9139_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUBX.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_9140_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}	m68k_incpci (2);
return;
}

/* SUBX.W -(An),-(An) */
void REGPARAM2 CPUFUNC(op_9148_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
	/* op H:2,T:1,C:6 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:2,T:1,C:6 */
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (7);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_9150_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_9158_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_9160_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_9168_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_9170_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}}return;
}

/* SUB.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_9178_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_9179_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUBX.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_9180_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	/* op H:2,T:0,C:0 */
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBX.L -(An),-(An) */
void REGPARAM2 CPUFUNC(op_9188_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
	/* op H:2,T:1,C:6 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:2,T:1,C:6 */
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (7);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_9190_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_9198_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_91a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (2);
return;
}

/* SUB.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_91a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_91b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}}return;
}

/* SUB.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_91b8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (4);
return;
}

/* SUB.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_91b9_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, newv);
}}}}}}}	m68k_incpci (6);
return;
}

/* SUBA.L Dn,An */
void REGPARAM2 CPUFUNC(op_91c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* SUBA.L An,An */
void REGPARAM2 CPUFUNC(op_91c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{	uae_u32 newv = dst - src;
	regs.irc = get_word_ce020_prefetch (2);
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return;
}

/* SUBA.L (An),An */
void REGPARAM2 CPUFUNC(op_91d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_91d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBA.L -(An),An */
void REGPARAM2 CPUFUNC(op_91e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return;
}

/* SUBA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_91e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (4);
return;
}

/* SUBA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_91f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return;
}

/* SUBA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_91f8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (4);
return;
}

/* SUBA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_91f9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (6);
return;
}

/* SUBA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_91fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (4);
return;
}

/* SUBA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_91fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}return;
}

/* SUBA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_91fc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (6);
return;
}

/* CMP.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_b000_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMP.B (An),Dn */
void REGPARAM2 CPUFUNC(op_b010_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_b018_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_b020_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_b028_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b030_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_b038_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_b039_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_b03a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b03b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_b03c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_b040_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMP.W An,Dn */
void REGPARAM2 CPUFUNC(op_b048_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMP.W (An),Dn */
void REGPARAM2 CPUFUNC(op_b050_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_b058_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_b060_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_b068_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b070_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_b078_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_b079_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_b07a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b07b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_b07c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return;
}

/* CMP.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_b080_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMP.L An,Dn */
void REGPARAM2 CPUFUNC(op_b088_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMP.L (An),Dn */
void REGPARAM2 CPUFUNC(op_b090_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_b098_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMP.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_b0a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return;
}

#endif

#ifdef PART_7
/* CMP.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_b0a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b0b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_b0b8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_b0b9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMP.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_b0ba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMP.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_b0bb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}return;
}

/* CMP.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_b0bc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:2 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (6);
return;
}

/* CMPA.W Dn,An */
void REGPARAM2 CPUFUNC(op_b0c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:4,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.W An,An */
void REGPARAM2 CPUFUNC(op_b0c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:4,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.W (An),An */
void REGPARAM2 CPUFUNC(op_b0d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.W (An)+,An */
void REGPARAM2 CPUFUNC(op_b0d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.W -(An),An */
void REGPARAM2 CPUFUNC(op_b0e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.W (d16,An),An */
void REGPARAM2 CPUFUNC(op_b0e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMPA.W (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_b0f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}}return;
}

/* CMPA.W (xxx).W,An */
void REGPARAM2 CPUFUNC(op_b0f8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMPA.W (xxx).L,An */
void REGPARAM2 CPUFUNC(op_b0f9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMPA.W (d16,PC),An */
void REGPARAM2 CPUFUNC(op_b0fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMPA.W (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_b0fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}}return;
}

/* CMPA.W #<data>.W,An */
void REGPARAM2 CPUFUNC(op_b0fc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}	m68k_incpci (4);
return;
}

/* EOR.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_b100_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (2);
return;
}

/* CMPM.B (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_b108_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	/* op H:0,T:0,C:8 */
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (6);
}}}}}}}}	m68k_incpci (2);
return;
}

/* EOR.B Dn,(An) */
void REGPARAM2 CPUFUNC(op_b110_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.B Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_b118_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.B Dn,-(An) */
void REGPARAM2 CPUFUNC(op_b120_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.B Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_b128_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.B Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_b130_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}}return;
}

/* EOR.B Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_b138_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.B Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_b139_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s8 dst = x_get_byte (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_byte (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_b140_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (2);
return;
}

/* CMPM.W (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_b148_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	/* op H:0,T:0,C:8 */
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (6);
}}}}}}}}	m68k_incpci (2);
return;
}

/* EOR.W Dn,(An) */
void REGPARAM2 CPUFUNC(op_b150_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.W Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_b158_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.W Dn,-(An) */
void REGPARAM2 CPUFUNC(op_b160_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.W Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_b168_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.W Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_b170_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}}return;
}

/* EOR.W Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_b178_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.W Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_b179_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s16 dst = x_get_word (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_word (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* EOR.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_b180_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	/* op H:2,T:0,C:0 */
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.irc = get_word_ce020_prefetch (2);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return;
}

/* CMPM.L (An)+,(An)+ */
void REGPARAM2 CPUFUNC(op_b188_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	/* op H:0,T:0,C:8 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (6);
}}}}}}}}	m68k_incpci (2);
return;
}

/* EOR.L Dn,(An) */
void REGPARAM2 CPUFUNC(op_b190_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.L Dn,(An)+ */
void REGPARAM2 CPUFUNC(op_b198_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.L Dn,-(An) */
void REGPARAM2 CPUFUNC(op_b1a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (2);
return;
}

/* EOR.L Dn,(d16,An) */
void REGPARAM2 CPUFUNC(op_b1a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.L Dn,(d8,An,Xn) */
void REGPARAM2 CPUFUNC(op_b1b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	m68k_incpci (2);
{	dsta = x_get_disp_ea_ce020 (m68k_areg (regs, dstreg), 0);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}}return;
}

/* EOR.L Dn,(xxx).W */
void REGPARAM2 CPUFUNC(op_b1b8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (4);
return;
}

/* EOR.L Dn,(xxx).L */
void REGPARAM2 CPUFUNC(op_b1b9_21)(uae_u32 opcode)
{
	uae_u32 srcreg = ((opcode >> 9) & 7);
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_long_ce020_prefetch (2);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
{	uae_s32 dst = x_get_long (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	x_put_long (dsta, src);
}}}}	m68k_incpci (6);
return;
}

/* CMPA.L Dn,An */
void REGPARAM2 CPUFUNC(op_b1c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:4,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.L An,An */
void REGPARAM2 CPUFUNC(op_b1c8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* No EA */
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	/* op H:4,T:0,C:0 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.L (An),An */
void REGPARAM2 CPUFUNC(op_b1d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.L (An)+,An */
void REGPARAM2 CPUFUNC(op_b1d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.L -(An),An */
void REGPARAM2 CPUFUNC(op_b1e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (2);
return;
}

/* CMPA.L (d16,An),An */
void REGPARAM2 CPUFUNC(op_b1e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMPA.L (d8,An,Xn),An */
void REGPARAM2 CPUFUNC(op_b1f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}}return;
}

/* CMPA.L (xxx).W,An */
void REGPARAM2 CPUFUNC(op_b1f8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMPA.L (xxx).L,An */
void REGPARAM2 CPUFUNC(op_b1f9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (6);
return;
}

/* CMPA.L (d16,PC),An */
void REGPARAM2 CPUFUNC(op_b1fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}	m68k_incpci (4);
return;
}

/* CMPA.L (d8,PC,Xn),An */
void REGPARAM2 CPUFUNC(op_b1fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}}}return;
}

/* CMPA.L #<data>.L,An */
void REGPARAM2 CPUFUNC(op_b1fc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:0,C:4 */
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
	do_cycles_ce020_internal (2);
}}}}}}	m68k_incpci (6);
return;
}

/* AND.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_c000_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:0 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (2);
return;
}

/* AND.B (An),Dn */
void REGPARAM2 CPUFUNC(op_c010_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* AND.B (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c018_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* AND.B -(An),Dn */
void REGPARAM2 CPUFUNC(op_c020_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* AND.B (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c028_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
}

/* AND.B (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c030_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return;
}

/* AND.B (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c038_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
}

/* AND.B (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c039_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (6);
return;
}

/* AND.B (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c03a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return;
}

/* AND.B (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c03b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s8 src = x_get_byte (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}}return;
}

/* AND.B #<data>.B,Dn */
void REGPARAM2 CPUFUNC(op_c03c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s8 src = (uae_u8)get_word_ce020_prefetch (2);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return;
}

/* AND.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_c040_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:0 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (2);
return;
}

/* AND.W (An),Dn */
void REGPARAM2 CPUFUNC(op_c050_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* AND.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c058_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* AND.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_c060_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (2);
return;
}

/* AND.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c068_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (4);
return;
}

/* AND.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c070_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return;
}

/* AND.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c078_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (4);
return;
}

/* AND.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c079_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (6);
return;
}

/* AND.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c07a_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}	m68k_incpci (4);
return;
}

/* AND.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c07b_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}return;
}

/* AND.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_c07c_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return;
}

/* AND.L Dn,Dn */
void REGPARAM2 CPUFUNC(op_c080_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:0 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return;
}

/* AND.L (An),Dn */
void REGPARAM2 CPUFUNC(op_c090_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (2);
return;
}

/* AND.L (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c098_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (2);
return;
}

/* AND.L -(An),Dn */
void REGPARAM2 CPUFUNC(op_c0a0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
{	uae_s32 src = x_get_long (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (2);
return;
}

/* AND.L (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c0a8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (4);
return;
}

/* AND.L (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0b0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return;
}

/* AND.L (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c0b8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (4);
return;
}

/* AND.L (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c0b9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (6);
return;
}

/* AND.L (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c0ba_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}	m68k_incpci (4);
return;
}

/* AND.L (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0bb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s32 src = x_get_long (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}}}return;
}

/* AND.L #<data>.L,Dn */
void REGPARAM2 CPUFUNC(op_c0bc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s32 src;
	src = get_long_ce020_prefetch (2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	regs.ce020memcycles = 0;
	/* op H:0,T:1,C:2 */
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	do_cycles_ce020_internal (1);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return;
}

/* MULU.W Dn,Dn */
void REGPARAM2 CPUFUNC(op_c0c0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}return;
}

/* MULU.W (An),Dn */
void REGPARAM2 CPUFUNC(op_c0d0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:1,C:1 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (1);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}}return;
}

/* MULU.W (An)+,Dn */
void REGPARAM2 CPUFUNC(op_c0d8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:1,C:2 fea */
	regs.ce020memcycles = 0;
	do_cycles_ce020_internal (2);
{	do_cycles_ce020_internal (1);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}}return;
}

/* MULU.W -(An),Dn */
void REGPARAM2 CPUFUNC(op_c0e0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	do_cycles_ce020_internal (2);
	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
{	uae_s16 src = x_get_word (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (2);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}}return;
}

/* MULU.W (d16,An),Dn */
void REGPARAM2 CPUFUNC(op_c0e8_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}return;
}

/* MULU.W (d8,An,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0f0_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr srca;
	m68k_incpci (2);
{	srca = x_get_disp_ea_ce020 (m68k_areg (regs, srcreg), 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}return;
}

/* MULU.W (xxx).W,Dn */
void REGPARAM2 CPUFUNC(op_c0f8_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}return;
}

/* MULU.W (xxx).L,Dn */
void REGPARAM2 CPUFUNC(op_c0f9_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:1,T:0,C:3 fea */
	if (regs.ce020memcycles > 1 * cpucycleunit)
		regs.ce020memcycles = 1 * cpucycleunit;
	do_cycles_ce020_internal (3);
{	uaecptr srca;
	srca = get_long_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (6);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (6);
}}}}}return;
}

/* MULU.W (d16,PC),Dn */
void REGPARAM2 CPUFUNC(op_c0fa_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:2,T:2,C:0 fea */
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_ce020_prefetch (2);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}return;
}

/* MULU.W (d8,PC,Xn),Dn */
void REGPARAM2 CPUFUNC(op_c0fb_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:4,T:2,C:0 fea */
	if (regs.ce020memcycles > 4 * cpucycleunit)
		regs.ce020memcycles = 4 * cpucycleunit;
{	do_cycles_ce020_internal (4);
	uaecptr tmppc;
	uaecptr srca;
	m68k_incpci (2);
{	tmppc = m68k_getpci ();
	srca = x_get_disp_ea_ce020 (tmppc, 0);
{	uae_s16 src = x_get_word (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (0);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}return;
}

/* MULU.W #<data>.W,Dn */
void REGPARAM2 CPUFUNC(op_c0fc_21)(uae_u32 opcode)
{
	uae_u32 dstreg = (opcode >> 9) & 7;
{	/* ea H:0,T:0,C:0 fea */
	regs.ce020memcycles = 0;
{	uae_s16 src = get_word_ce020_prefetch (2);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.irc = get_word_ce020_prefetch (4);
	if (regs.ce020memcycles > 2 * cpucycleunit)
		regs.ce020memcycles = 2 * cpucycleunit;
	/* op H:2,T:0,C:23 */
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	do_cycles_ce020_internal (23);
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}return;
}

/* ABCD.B Dn,Dn */
void REGPARAM2 CPUFUNC(op_c100_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	/* op H:0,T:0,C:4 */
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	/* op H:0,T:0,C:4 */
{	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;	if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) == 0 && (newv & 0x80) != 0);
	regs.irc = get_word_ce020_prefetch (2);
	do_cycles_ce020_internal (2);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpci (2);
return;
}

/* ABCD.B -(An),-(An) */
void REGPARAM2 CPUFUNC(op_c108_21)(uae_u32 opcode)
{
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = x_get_byte (srca);
	m68k_areg (regs, srcreg) = srca;
	/* op H:2,T:1,C:10 */
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = x_get_byte (dsta);
	m68k_areg (regs, dstreg) = dsta;
	/* op H:2,T:1,C:10 *