{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An opaque struct representing a simple animation.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkPixbuf.Objects.PixbufSimpleAnim
    ( 

-- * Exported types
    PixbufSimpleAnim(..)                    ,
    IsPixbufSimpleAnim                      ,
    toPixbufSimpleAnim                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addFrame]("GI.GdkPixbuf.Objects.PixbufSimpleAnim#g:method:addFrame"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isStaticImage]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:isStaticImage"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getHeight]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:getHeight"), [getIter]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:getIter"), [getLoop]("GI.GdkPixbuf.Objects.PixbufSimpleAnim#g:method:getLoop"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStaticImage]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:getStaticImage"), [getWidth]("GI.GdkPixbuf.Objects.PixbufAnimation#g:method:getWidth").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setLoop]("GI.GdkPixbuf.Objects.PixbufSimpleAnim#g:method:setLoop"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolvePixbufSimpleAnimMethod           ,
#endif

-- ** addFrame #method:addFrame#

#if defined(ENABLE_OVERLOADING)
    PixbufSimpleAnimAddFrameMethodInfo      ,
#endif
    pixbufSimpleAnimAddFrame                ,


-- ** getLoop #method:getLoop#

#if defined(ENABLE_OVERLOADING)
    PixbufSimpleAnimGetLoopMethodInfo       ,
#endif
    pixbufSimpleAnimGetLoop                 ,


-- ** new #method:new#

    pixbufSimpleAnimNew                     ,


-- ** setLoop #method:setLoop#

#if defined(ENABLE_OVERLOADING)
    PixbufSimpleAnimSetLoopMethodInfo       ,
#endif
    pixbufSimpleAnimSetLoop                 ,




 -- * Properties


-- ** loop #attr:loop#
-- | Whether the animation should loop when it reaches the end.
-- 
-- /Since: 2.18/

#if defined(ENABLE_OVERLOADING)
    PixbufSimpleAnimLoopPropertyInfo        ,
#endif
    constructPixbufSimpleAnimLoop           ,
    getPixbufSimpleAnimLoop                 ,
#if defined(ENABLE_OVERLOADING)
    pixbufSimpleAnimLoop                    ,
#endif
    setPixbufSimpleAnimLoop                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GdkPixbuf.Callbacks as GdkPixbuf.Callbacks
import {-# SOURCE #-} qualified GI.GdkPixbuf.Enums as GdkPixbuf.Enums
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimation as GdkPixbuf.PixbufAnimation
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimationIter as GdkPixbuf.PixbufAnimationIter
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufFormat as GdkPixbuf.PixbufFormat
import {-# SOURCE #-} qualified GI.GdkPixbuf.Structs.PixbufModulePattern as GdkPixbuf.PixbufModulePattern
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import {-# SOURCE #-} qualified GI.GdkPixbuf.Objects.PixbufAnimation as GdkPixbuf.PixbufAnimation

#endif

-- | Memory-managed wrapper type.
newtype PixbufSimpleAnim = PixbufSimpleAnim (SP.ManagedPtr PixbufSimpleAnim)
    deriving (Eq)

instance SP.ManagedPtrNewtype PixbufSimpleAnim where
    toManagedPtr (PixbufSimpleAnim p) = p

foreign import ccall "gdk_pixbuf_simple_anim_get_type"
    c_gdk_pixbuf_simple_anim_get_type :: IO B.Types.GType

instance B.Types.TypedObject PixbufSimpleAnim where
    glibType = c_gdk_pixbuf_simple_anim_get_type

instance B.Types.GObject PixbufSimpleAnim

-- | Type class for types which can be safely cast to t'PixbufSimpleAnim', for instance with `toPixbufSimpleAnim`.
class (SP.GObject o, O.IsDescendantOf PixbufSimpleAnim o) => IsPixbufSimpleAnim o
instance (SP.GObject o, O.IsDescendantOf PixbufSimpleAnim o) => IsPixbufSimpleAnim o

instance O.HasParentTypes PixbufSimpleAnim
type instance O.ParentTypes PixbufSimpleAnim = '[GdkPixbuf.PixbufAnimation.PixbufAnimation, GObject.Object.Object]

-- | Cast to t'PixbufSimpleAnim', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toPixbufSimpleAnim :: (MIO.MonadIO m, IsPixbufSimpleAnim o) => o -> m PixbufSimpleAnim
toPixbufSimpleAnim = MIO.liftIO . B.ManagedPtr.unsafeCastTo PixbufSimpleAnim

-- | Convert t'PixbufSimpleAnim' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PixbufSimpleAnim) where
    gvalueGType_ = c_gdk_pixbuf_simple_anim_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PixbufSimpleAnim)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PixbufSimpleAnim)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PixbufSimpleAnim ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePixbufSimpleAnimMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePixbufSimpleAnimMethod "addFrame" o = PixbufSimpleAnimAddFrameMethodInfo
    ResolvePixbufSimpleAnimMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePixbufSimpleAnimMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePixbufSimpleAnimMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePixbufSimpleAnimMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePixbufSimpleAnimMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePixbufSimpleAnimMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePixbufSimpleAnimMethod "isStaticImage" o = GdkPixbuf.PixbufAnimation.PixbufAnimationIsStaticImageMethodInfo
    ResolvePixbufSimpleAnimMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePixbufSimpleAnimMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePixbufSimpleAnimMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePixbufSimpleAnimMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePixbufSimpleAnimMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePixbufSimpleAnimMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePixbufSimpleAnimMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePixbufSimpleAnimMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePixbufSimpleAnimMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePixbufSimpleAnimMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePixbufSimpleAnimMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePixbufSimpleAnimMethod "getHeight" o = GdkPixbuf.PixbufAnimation.PixbufAnimationGetHeightMethodInfo
    ResolvePixbufSimpleAnimMethod "getIter" o = GdkPixbuf.PixbufAnimation.PixbufAnimationGetIterMethodInfo
    ResolvePixbufSimpleAnimMethod "getLoop" o = PixbufSimpleAnimGetLoopMethodInfo
    ResolvePixbufSimpleAnimMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePixbufSimpleAnimMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePixbufSimpleAnimMethod "getStaticImage" o = GdkPixbuf.PixbufAnimation.PixbufAnimationGetStaticImageMethodInfo
    ResolvePixbufSimpleAnimMethod "getWidth" o = GdkPixbuf.PixbufAnimation.PixbufAnimationGetWidthMethodInfo
    ResolvePixbufSimpleAnimMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePixbufSimpleAnimMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePixbufSimpleAnimMethod "setLoop" o = PixbufSimpleAnimSetLoopMethodInfo
    ResolvePixbufSimpleAnimMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePixbufSimpleAnimMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePixbufSimpleAnimMethod t PixbufSimpleAnim, O.OverloadedMethod info PixbufSimpleAnim p) => OL.IsLabel t (PixbufSimpleAnim -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePixbufSimpleAnimMethod t PixbufSimpleAnim, O.OverloadedMethod info PixbufSimpleAnim p, R.HasField t PixbufSimpleAnim p) => R.HasField t PixbufSimpleAnim p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePixbufSimpleAnimMethod t PixbufSimpleAnim, O.OverloadedMethodInfo info PixbufSimpleAnim) => OL.IsLabel t (O.MethodProxy info PixbufSimpleAnim) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "loop"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@loop@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' pixbufSimpleAnim #loop
-- @
getPixbufSimpleAnimLoop :: (MonadIO m, IsPixbufSimpleAnim o) => o -> m Bool
getPixbufSimpleAnimLoop obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "loop"

-- | Set the value of the “@loop@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' pixbufSimpleAnim [ #loop 'Data.GI.Base.Attributes.:=' value ]
-- @
setPixbufSimpleAnimLoop :: (MonadIO m, IsPixbufSimpleAnim o) => o -> Bool -> m ()
setPixbufSimpleAnimLoop obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "loop" val

-- | Construct a t'GValueConstruct' with valid value for the “@loop@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPixbufSimpleAnimLoop :: (IsPixbufSimpleAnim o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPixbufSimpleAnimLoop val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "loop" val

#if defined(ENABLE_OVERLOADING)
data PixbufSimpleAnimLoopPropertyInfo
instance AttrInfo PixbufSimpleAnimLoopPropertyInfo where
    type AttrAllowedOps PixbufSimpleAnimLoopPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PixbufSimpleAnimLoopPropertyInfo = IsPixbufSimpleAnim
    type AttrSetTypeConstraint PixbufSimpleAnimLoopPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PixbufSimpleAnimLoopPropertyInfo = (~) Bool
    type AttrTransferType PixbufSimpleAnimLoopPropertyInfo = Bool
    type AttrGetType PixbufSimpleAnimLoopPropertyInfo = Bool
    type AttrLabel PixbufSimpleAnimLoopPropertyInfo = "loop"
    type AttrOrigin PixbufSimpleAnimLoopPropertyInfo = PixbufSimpleAnim
    attrGet = getPixbufSimpleAnimLoop
    attrSet = setPixbufSimpleAnimLoop
    attrTransfer _ v = do
        return v
    attrConstruct = constructPixbufSimpleAnimLoop
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Objects.PixbufSimpleAnim.loop"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Objects-PixbufSimpleAnim.html#g:attr:loop"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PixbufSimpleAnim
type instance O.AttributeList PixbufSimpleAnim = PixbufSimpleAnimAttributeList
type PixbufSimpleAnimAttributeList = ('[ '("loop", PixbufSimpleAnimLoopPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
pixbufSimpleAnimLoop :: AttrLabelProxy "loop"
pixbufSimpleAnimLoop = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PixbufSimpleAnim = PixbufSimpleAnimSignalList
type PixbufSimpleAnimSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method PixbufSimpleAnim::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the width of the animation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the height of the animation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rate"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the speed of the animation, in frames per second"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "GdkPixbuf" , name = "PixbufSimpleAnim" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_simple_anim_new" gdk_pixbuf_simple_anim_new :: 
    Int32 ->                                -- width : TBasicType TInt
    Int32 ->                                -- height : TBasicType TInt
    CFloat ->                               -- rate : TBasicType TFloat
    IO (Ptr PixbufSimpleAnim)

-- | Creates a new, empty animation.
-- 
-- /Since: 2.8/
pixbufSimpleAnimNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@width@/: the width of the animation
    -> Int32
    -- ^ /@height@/: the height of the animation
    -> Float
    -- ^ /@rate@/: the speed of the animation, in frames per second
    -> m PixbufSimpleAnim
    -- ^ __Returns:__ a newly allocated t'GI.GdkPixbuf.Objects.PixbufSimpleAnim.PixbufSimpleAnim'
pixbufSimpleAnimNew width height rate = liftIO $ do
    let rate' = realToFrac rate
    result <- gdk_pixbuf_simple_anim_new width height rate'
    checkUnexpectedReturnNULL "pixbufSimpleAnimNew" result
    result' <- (wrapObject PixbufSimpleAnim) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method PixbufSimpleAnim::add_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "animation"
--           , argType =
--               TInterface
--                 Name { namespace = "GdkPixbuf" , name = "PixbufSimpleAnim" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkPixbufSimpleAnim"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixbuf"
--           , argType =
--               TInterface Name { namespace = "GdkPixbuf" , name = "Pixbuf" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the pixbuf to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_simple_anim_add_frame" gdk_pixbuf_simple_anim_add_frame :: 
    Ptr PixbufSimpleAnim ->                 -- animation : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufSimpleAnim"})
    Ptr GdkPixbuf.Pixbuf.Pixbuf ->          -- pixbuf : TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
    IO ()

-- | Adds a new frame to /@animation@/. The /@pixbuf@/ must
-- have the dimensions specified when the animation
-- was constructed.
-- 
-- /Since: 2.8/
pixbufSimpleAnimAddFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsPixbufSimpleAnim a, GdkPixbuf.Pixbuf.IsPixbuf b) =>
    a
    -- ^ /@animation@/: a t'GI.GdkPixbuf.Objects.PixbufSimpleAnim.PixbufSimpleAnim'
    -> b
    -- ^ /@pixbuf@/: the pixbuf to add
    -> m ()
pixbufSimpleAnimAddFrame animation pixbuf = liftIO $ do
    animation' <- unsafeManagedPtrCastPtr animation
    pixbuf' <- unsafeManagedPtrCastPtr pixbuf
    gdk_pixbuf_simple_anim_add_frame animation' pixbuf'
    touchManagedPtr animation
    touchManagedPtr pixbuf
    return ()

#if defined(ENABLE_OVERLOADING)
data PixbufSimpleAnimAddFrameMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsPixbufSimpleAnim a, GdkPixbuf.Pixbuf.IsPixbuf b) => O.OverloadedMethod PixbufSimpleAnimAddFrameMethodInfo a signature where
    overloadedMethod = pixbufSimpleAnimAddFrame

instance O.OverloadedMethodInfo PixbufSimpleAnimAddFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Objects.PixbufSimpleAnim.pixbufSimpleAnimAddFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Objects-PixbufSimpleAnim.html#v:pixbufSimpleAnimAddFrame"
        })


#endif

-- method PixbufSimpleAnim::get_loop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "animation"
--           , argType =
--               TInterface
--                 Name { namespace = "GdkPixbuf" , name = "PixbufSimpleAnim" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkPixbufSimpleAnim"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_simple_anim_get_loop" gdk_pixbuf_simple_anim_get_loop :: 
    Ptr PixbufSimpleAnim ->                 -- animation : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufSimpleAnim"})
    IO CInt

-- | Gets whether /@animation@/ should loop indefinitely when it reaches the end.
-- 
-- /Since: 2.18/
pixbufSimpleAnimGetLoop ::
    (B.CallStack.HasCallStack, MonadIO m, IsPixbufSimpleAnim a) =>
    a
    -- ^ /@animation@/: a t'GI.GdkPixbuf.Objects.PixbufSimpleAnim.PixbufSimpleAnim'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the animation loops forever, 'P.False' otherwise
pixbufSimpleAnimGetLoop animation = liftIO $ do
    animation' <- unsafeManagedPtrCastPtr animation
    result <- gdk_pixbuf_simple_anim_get_loop animation'
    let result' = (/= 0) result
    touchManagedPtr animation
    return result'

#if defined(ENABLE_OVERLOADING)
data PixbufSimpleAnimGetLoopMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPixbufSimpleAnim a) => O.OverloadedMethod PixbufSimpleAnimGetLoopMethodInfo a signature where
    overloadedMethod = pixbufSimpleAnimGetLoop

instance O.OverloadedMethodInfo PixbufSimpleAnimGetLoopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Objects.PixbufSimpleAnim.pixbufSimpleAnimGetLoop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Objects-PixbufSimpleAnim.html#v:pixbufSimpleAnimGetLoop"
        })


#endif

-- method PixbufSimpleAnim::set_loop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "animation"
--           , argType =
--               TInterface
--                 Name { namespace = "GdkPixbuf" , name = "PixbufSimpleAnim" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkPixbufSimpleAnim"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "loop"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to loop the animation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_pixbuf_simple_anim_set_loop" gdk_pixbuf_simple_anim_set_loop :: 
    Ptr PixbufSimpleAnim ->                 -- animation : TInterface (Name {namespace = "GdkPixbuf", name = "PixbufSimpleAnim"})
    CInt ->                                 -- loop : TBasicType TBoolean
    IO ()

-- | Sets whether /@animation@/ should loop indefinitely when it reaches the end.
-- 
-- /Since: 2.18/
pixbufSimpleAnimSetLoop ::
    (B.CallStack.HasCallStack, MonadIO m, IsPixbufSimpleAnim a) =>
    a
    -- ^ /@animation@/: a t'GI.GdkPixbuf.Objects.PixbufSimpleAnim.PixbufSimpleAnim'
    -> Bool
    -- ^ /@loop@/: whether to loop the animation
    -> m ()
pixbufSimpleAnimSetLoop animation loop = liftIO $ do
    animation' <- unsafeManagedPtrCastPtr animation
    let loop' = (P.fromIntegral . P.fromEnum) loop
    gdk_pixbuf_simple_anim_set_loop animation' loop'
    touchManagedPtr animation
    return ()

#if defined(ENABLE_OVERLOADING)
data PixbufSimpleAnimSetLoopMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPixbufSimpleAnim a) => O.OverloadedMethod PixbufSimpleAnimSetLoopMethodInfo a signature where
    overloadedMethod = pixbufSimpleAnimSetLoop

instance O.OverloadedMethodInfo PixbufSimpleAnimSetLoopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GdkPixbuf.Objects.PixbufSimpleAnim.pixbufSimpleAnimSetLoop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdkpixbuf-2.0.32/docs/GI-GdkPixbuf-Objects-PixbufSimpleAnim.html#v:pixbufSimpleAnimSetLoop"
        })


#endif


