{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GSocketAddress@ is the equivalent of
-- <http://developer.gnome.org/gio/stable/man:sockaddr(3type `struct sockaddr`>) and its subtypes in the BSD sockets
-- API. This is an abstract class; use t'GI.Gio.Objects.InetSocketAddress.InetSocketAddress' for
-- internet sockets, or t'GI.Gio.Objects.UnixSocketAddress.UnixSocketAddress' for UNIX domain sockets.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SocketAddress
    ( 

-- * Exported types
    SocketAddress(..)                       ,
    IsSocketAddress                         ,
    toSocketAddress                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [enumerate]("GI.Gio.Interfaces.SocketConnectable#g:method:enumerate"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [proxyEnumerate]("GI.Gio.Interfaces.SocketConnectable#g:method:proxyEnumerate"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toNative]("GI.Gio.Objects.SocketAddress#g:method:toNative"), [toString]("GI.Gio.Interfaces.SocketConnectable#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFamily]("GI.Gio.Objects.SocketAddress#g:method:getFamily"), [getNativeSize]("GI.Gio.Objects.SocketAddress#g:method:getNativeSize"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSocketAddressMethod              ,
#endif

-- ** getFamily #method:getFamily#

#if defined(ENABLE_OVERLOADING)
    SocketAddressGetFamilyMethodInfo        ,
#endif
    socketAddressGetFamily                  ,


-- ** getNativeSize #method:getNativeSize#

#if defined(ENABLE_OVERLOADING)
    SocketAddressGetNativeSizeMethodInfo    ,
#endif
    socketAddressGetNativeSize              ,


-- ** newFromNative #method:newFromNative#

    socketAddressNewFromNative              ,


-- ** toNative #method:toNative#

#if defined(ENABLE_OVERLOADING)
    SocketAddressToNativeMethodInfo         ,
#endif
    socketAddressToNative                   ,




 -- * Properties


-- ** family #attr:family#
-- | The family of the socket address.
-- 
-- /Since: 2.22/

#if defined(ENABLE_OVERLOADING)
    SocketAddressFamilyPropertyInfo         ,
#endif
    getSocketAddressFamily                  ,
#if defined(ENABLE_OVERLOADING)
    socketAddressFamily                     ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable

#endif

-- | Memory-managed wrapper type.
newtype SocketAddress = SocketAddress (SP.ManagedPtr SocketAddress)
    deriving (Eq)

instance SP.ManagedPtrNewtype SocketAddress where
    toManagedPtr (SocketAddress p) = p

foreign import ccall "g_socket_address_get_type"
    c_g_socket_address_get_type :: IO B.Types.GType

instance B.Types.TypedObject SocketAddress where
    glibType = c_g_socket_address_get_type

instance B.Types.GObject SocketAddress

-- | Type class for types which can be safely cast to t'SocketAddress', for instance with `toSocketAddress`.
class (SP.GObject o, O.IsDescendantOf SocketAddress o) => IsSocketAddress o
instance (SP.GObject o, O.IsDescendantOf SocketAddress o) => IsSocketAddress o

instance O.HasParentTypes SocketAddress
type instance O.ParentTypes SocketAddress = '[GObject.Object.Object, Gio.SocketConnectable.SocketConnectable]

-- | Cast to t'SocketAddress', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSocketAddress :: (MIO.MonadIO m, IsSocketAddress o) => o -> m SocketAddress
toSocketAddress = MIO.liftIO . B.ManagedPtr.unsafeCastTo SocketAddress

-- | Convert t'SocketAddress' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SocketAddress) where
    gvalueGType_ = c_g_socket_address_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SocketAddress)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SocketAddress)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SocketAddress ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSocketAddressMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSocketAddressMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSocketAddressMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSocketAddressMethod "enumerate" o = Gio.SocketConnectable.SocketConnectableEnumerateMethodInfo
    ResolveSocketAddressMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSocketAddressMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSocketAddressMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSocketAddressMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSocketAddressMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSocketAddressMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSocketAddressMethod "proxyEnumerate" o = Gio.SocketConnectable.SocketConnectableProxyEnumerateMethodInfo
    ResolveSocketAddressMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSocketAddressMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSocketAddressMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSocketAddressMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSocketAddressMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSocketAddressMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSocketAddressMethod "toNative" o = SocketAddressToNativeMethodInfo
    ResolveSocketAddressMethod "toString" o = Gio.SocketConnectable.SocketConnectableToStringMethodInfo
    ResolveSocketAddressMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSocketAddressMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSocketAddressMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSocketAddressMethod "getFamily" o = SocketAddressGetFamilyMethodInfo
    ResolveSocketAddressMethod "getNativeSize" o = SocketAddressGetNativeSizeMethodInfo
    ResolveSocketAddressMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSocketAddressMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSocketAddressMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSocketAddressMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSocketAddressMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSocketAddressMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSocketAddressMethod t SocketAddress, O.OverloadedMethod info SocketAddress p) => OL.IsLabel t (SocketAddress -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSocketAddressMethod t SocketAddress, O.OverloadedMethod info SocketAddress p, R.HasField t SocketAddress p) => R.HasField t SocketAddress p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSocketAddressMethod t SocketAddress, O.OverloadedMethodInfo info SocketAddress) => OL.IsLabel t (O.MethodProxy info SocketAddress) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "family"
   -- Type: TInterface (Name {namespace = "Gio", name = "SocketFamily"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@family@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' socketAddress #family
-- @
getSocketAddressFamily :: (MonadIO m, IsSocketAddress o) => o -> m Gio.Enums.SocketFamily
getSocketAddressFamily obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "family"

#if defined(ENABLE_OVERLOADING)
data SocketAddressFamilyPropertyInfo
instance AttrInfo SocketAddressFamilyPropertyInfo where
    type AttrAllowedOps SocketAddressFamilyPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint SocketAddressFamilyPropertyInfo = IsSocketAddress
    type AttrSetTypeConstraint SocketAddressFamilyPropertyInfo = (~) ()
    type AttrTransferTypeConstraint SocketAddressFamilyPropertyInfo = (~) ()
    type AttrTransferType SocketAddressFamilyPropertyInfo = ()
    type AttrGetType SocketAddressFamilyPropertyInfo = Gio.Enums.SocketFamily
    type AttrLabel SocketAddressFamilyPropertyInfo = "family"
    type AttrOrigin SocketAddressFamilyPropertyInfo = SocketAddress
    attrGet = getSocketAddressFamily
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketAddress.family"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SocketAddress.html#g:attr:family"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SocketAddress
type instance O.AttributeList SocketAddress = SocketAddressAttributeList
type SocketAddressAttributeList = ('[ '("family", SocketAddressFamilyPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
socketAddressFamily :: AttrLabelProxy "family"
socketAddressFamily = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SocketAddress = SocketAddressSignalList
type SocketAddressSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SocketAddress::new_from_native
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "native"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer to a struct sockaddr"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the size of the memory location pointed to by @native"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_address_new_from_native" g_socket_address_new_from_native :: 
    Ptr () ->                               -- native : TBasicType TPtr
    FCT.CSize ->                            -- len : TBasicType TSize
    IO (Ptr SocketAddress)

-- | Creates a t'GI.Gio.Objects.SocketAddress.SocketAddress' subclass corresponding to the native
-- struct sockaddr /@native@/.
-- 
-- /Since: 2.22/
socketAddressNewFromNative ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Ptr ()
    -- ^ /@native@/: a pointer to a struct sockaddr
    -> FCT.CSize
    -- ^ /@len@/: the size of the memory location pointed to by /@native@/
    -> m SocketAddress
    -- ^ __Returns:__ a new t'GI.Gio.Objects.SocketAddress.SocketAddress' if /@native@/ could successfully
    --     be converted, otherwise 'P.Nothing'
socketAddressNewFromNative native len = liftIO $ do
    result <- g_socket_address_new_from_native native len
    checkUnexpectedReturnNULL "socketAddressNewFromNative" result
    result' <- (wrapObject SocketAddress) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SocketAddress::get_family
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SocketFamily" })
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_address_get_family" g_socket_address_get_family :: 
    Ptr SocketAddress ->                    -- address : TInterface (Name {namespace = "Gio", name = "SocketAddress"})
    IO CUInt

-- | Gets the socket family type of /@address@/.
-- 
-- /Since: 2.22/
socketAddressGetFamily ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.SocketAddress.SocketAddress'
    -> m Gio.Enums.SocketFamily
    -- ^ __Returns:__ the socket family type of /@address@/
socketAddressGetFamily address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_socket_address_get_family address'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr address
    return result'

#if defined(ENABLE_OVERLOADING)
data SocketAddressGetFamilyMethodInfo
instance (signature ~ (m Gio.Enums.SocketFamily), MonadIO m, IsSocketAddress a) => O.OverloadedMethod SocketAddressGetFamilyMethodInfo a signature where
    overloadedMethod = socketAddressGetFamily

instance O.OverloadedMethodInfo SocketAddressGetFamilyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketAddress.socketAddressGetFamily",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SocketAddress.html#v:socketAddressGetFamily"
        })


#endif

-- method SocketAddress::get_native_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSSize)
-- throws : False
-- Skip return : False

foreign import ccall "g_socket_address_get_native_size" g_socket_address_get_native_size :: 
    Ptr SocketAddress ->                    -- address : TInterface (Name {namespace = "Gio", name = "SocketAddress"})
    IO DI.Int64

-- | Gets the size of /@address@/\'s native struct sockaddr.
-- You can use this to allocate memory to pass to
-- 'GI.Gio.Objects.SocketAddress.socketAddressToNative'.
-- 
-- /Since: 2.22/
socketAddressGetNativeSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.SocketAddress.SocketAddress'
    -> m DI.Int64
    -- ^ __Returns:__ the size of the native struct sockaddr that
    --     /@address@/ represents, or @-1@ if /@address@/
    --     is not valid
socketAddressGetNativeSize address = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    result <- g_socket_address_get_native_size address'
    touchManagedPtr address
    return result

#if defined(ENABLE_OVERLOADING)
data SocketAddressGetNativeSizeMethodInfo
instance (signature ~ (m DI.Int64), MonadIO m, IsSocketAddress a) => O.OverloadedMethod SocketAddressGetNativeSizeMethodInfo a signature where
    overloadedMethod = socketAddressGetNativeSize

instance O.OverloadedMethodInfo SocketAddressGetNativeSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketAddress.socketAddressGetNativeSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SocketAddress.html#v:socketAddressGetNativeSize"
        })


#endif

-- method SocketAddress::to_native
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "address"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SocketAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSocketAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pointer to a memory location that will contain the native\nstruct sockaddr"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "destlen"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the size of @dest. Must be at least as large as\n    g_socket_address_get_native_size()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "g_socket_address_to_native" g_socket_address_to_native :: 
    Ptr SocketAddress ->                    -- address : TInterface (Name {namespace = "Gio", name = "SocketAddress"})
    Ptr () ->                               -- dest : TBasicType TPtr
    FCT.CSize ->                            -- destlen : TBasicType TSize
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Converts a t'GI.Gio.Objects.SocketAddress.SocketAddress' to a native struct sockaddr, which can
-- be passed to low-level functions like @/connect()/@ or @/bind()/@.
-- 
-- If not enough space is available, a 'GI.Gio.Enums.IOErrorEnumNoSpace' error
-- is returned. If the address type is not known on the system
-- then a 'GI.Gio.Enums.IOErrorEnumNotSupported' error is returned.
-- 
-- /Since: 2.22/
socketAddressToNative ::
    (B.CallStack.HasCallStack, MonadIO m, IsSocketAddress a) =>
    a
    -- ^ /@address@/: a t'GI.Gio.Objects.SocketAddress.SocketAddress'
    -> Ptr ()
    -- ^ /@dest@/: a pointer to a memory location that will contain the native
    -- struct sockaddr
    -> FCT.CSize
    -- ^ /@destlen@/: the size of /@dest@/. Must be at least as large as
    --     'GI.Gio.Objects.SocketAddress.socketAddressGetNativeSize'
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
socketAddressToNative address dest destlen = liftIO $ do
    address' <- unsafeManagedPtrCastPtr address
    onException (do
        _ <- propagateGError $ g_socket_address_to_native address' dest destlen
        touchManagedPtr address
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data SocketAddressToNativeMethodInfo
instance (signature ~ (Ptr () -> FCT.CSize -> m ()), MonadIO m, IsSocketAddress a) => O.OverloadedMethod SocketAddressToNativeMethodInfo a signature where
    overloadedMethod = socketAddressToNative

instance O.OverloadedMethodInfo SocketAddressToNativeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SocketAddress.socketAddressToNative",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SocketAddress.html#v:socketAddressToNative"
        })


#endif


