{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node controlling the color matrix of its single child node.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.ColorMatrixNode
    ( 

-- * Exported types
    ColorMatrixNode(..)                     ,
    IsColorMatrixNode                       ,
    toColorMatrixNode                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getChild]("GI.Gsk.Objects.ColorMatrixNode#g:method:getChild"), [getColorMatrix]("GI.Gsk.Objects.ColorMatrixNode#g:method:getColorMatrix"), [getColorOffset]("GI.Gsk.Objects.ColorMatrixNode#g:method:getColorOffset"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveColorMatrixNodeMethod            ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    ColorMatrixNodeGetChildMethodInfo       ,
#endif
    colorMatrixNodeGetChild                 ,


-- ** getColorMatrix #method:getColorMatrix#

#if defined(ENABLE_OVERLOADING)
    ColorMatrixNodeGetColorMatrixMethodInfo ,
#endif
    colorMatrixNodeGetColorMatrix           ,


-- ** getColorOffset #method:getColorOffset#

#if defined(ENABLE_OVERLOADING)
    ColorMatrixNodeGetColorOffsetMethodInfo ,
#endif
    colorMatrixNodeGetColorOffset           ,


-- ** new #method:new#

    colorMatrixNodeNew                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype ColorMatrixNode = ColorMatrixNode (SP.ManagedPtr ColorMatrixNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype ColorMatrixNode where
    toManagedPtr (ColorMatrixNode p) = p

foreign import ccall "gsk_color_matrix_node_get_type"
    c_gsk_color_matrix_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject ColorMatrixNode where
    glibType = c_gsk_color_matrix_node_get_type

-- | Type class for types which can be safely cast to t'ColorMatrixNode', for instance with `toColorMatrixNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ColorMatrixNode o) => IsColorMatrixNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ColorMatrixNode o) => IsColorMatrixNode o

instance O.HasParentTypes ColorMatrixNode
type instance O.ParentTypes ColorMatrixNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'ColorMatrixNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toColorMatrixNode :: (MIO.MonadIO m, IsColorMatrixNode o) => o -> m ColorMatrixNode
toColorMatrixNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo ColorMatrixNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveColorMatrixNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveColorMatrixNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveColorMatrixNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveColorMatrixNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveColorMatrixNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveColorMatrixNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveColorMatrixNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveColorMatrixNodeMethod "getChild" o = ColorMatrixNodeGetChildMethodInfo
    ResolveColorMatrixNodeMethod "getColorMatrix" o = ColorMatrixNodeGetColorMatrixMethodInfo
    ResolveColorMatrixNodeMethod "getColorOffset" o = ColorMatrixNodeGetColorOffsetMethodInfo
    ResolveColorMatrixNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveColorMatrixNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveColorMatrixNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveColorMatrixNodeMethod t ColorMatrixNode, O.OverloadedMethod info ColorMatrixNode p) => OL.IsLabel t (ColorMatrixNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveColorMatrixNodeMethod t ColorMatrixNode, O.OverloadedMethod info ColorMatrixNode p, R.HasField t ColorMatrixNode p) => R.HasField t ColorMatrixNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveColorMatrixNodeMethod t ColorMatrixNode, O.OverloadedMethodInfo info ColorMatrixNode) => OL.IsLabel t (O.MethodProxy info ColorMatrixNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr ColorMatrixNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method ColorMatrixNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "child"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The node to draw" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_matrix"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Matrix" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The matrix to apply"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_offset"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec4" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Values to add to the color"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gsk" , name = "ColorMatrixNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_color_matrix_node_new" gsk_color_matrix_node_new :: 
    Ptr Gsk.RenderNode.RenderNode ->        -- child : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    Ptr Graphene.Matrix.Matrix ->           -- color_matrix : TInterface (Name {namespace = "Graphene", name = "Matrix"})
    Ptr Graphene.Vec4.Vec4 ->               -- color_offset : TInterface (Name {namespace = "Graphene", name = "Vec4"})
    IO (Ptr ColorMatrixNode)

-- | Creates a @GskRenderNode@ that will drawn the /@child@/ with
-- /@colorMatrix@/.
-- 
-- In particular, the node will transform colors by applying
-- 
--     pixel = transpose(color_matrix) * pixel + color_offset
-- 
-- for every pixel. The transformation operates on unpremultiplied
-- colors, with color components ordered R, G, B, A.
colorMatrixNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a) =>
    a
    -- ^ /@child@/: The node to draw
    -> Graphene.Matrix.Matrix
    -- ^ /@colorMatrix@/: The matrix to apply
    -> Graphene.Vec4.Vec4
    -- ^ /@colorOffset@/: Values to add to the color
    -> m ColorMatrixNode
    -- ^ __Returns:__ A new @GskRenderNode@
colorMatrixNodeNew child colorMatrix colorOffset = liftIO $ do
    child' <- unsafeManagedPtrCastPtr child
    colorMatrix' <- unsafeManagedPtrGetPtr colorMatrix
    colorOffset' <- unsafeManagedPtrGetPtr colorOffset
    result <- gsk_color_matrix_node_new child' colorMatrix' colorOffset'
    checkUnexpectedReturnNULL "colorMatrixNodeNew" result
    result' <- (wrapPtr ColorMatrixNode) result
    touchManagedPtr child
    touchManagedPtr colorMatrix
    touchManagedPtr colorOffset
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ColorMatrixNode::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ColorMatrixNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a color matrix `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_color_matrix_node_get_child" gsk_color_matrix_node_get_child :: 
    Ptr ColorMatrixNode ->                  -- node : TInterface (Name {namespace = "Gsk", name = "ColorMatrixNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Gets the child node that is getting its colors modified by the given /@node@/.
colorMatrixNodeGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorMatrixNode a) =>
    a
    -- ^ /@node@/: a color matrix @GskRenderNode@
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ The child that is getting its colors modified
colorMatrixNodeGetChild node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_color_matrix_node_get_child node'
    checkUnexpectedReturnNULL "colorMatrixNodeGetChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorMatrixNodeGetChildMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsColorMatrixNode a) => O.OverloadedMethod ColorMatrixNodeGetChildMethodInfo a signature where
    overloadedMethod = colorMatrixNodeGetChild

instance O.OverloadedMethodInfo ColorMatrixNodeGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ColorMatrixNode.colorMatrixNodeGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ColorMatrixNode.html#v:colorMatrixNodeGetChild"
        })


#endif

-- method ColorMatrixNode::get_color_matrix
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ColorMatrixNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a color matrix `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Matrix" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_color_matrix_node_get_color_matrix" gsk_color_matrix_node_get_color_matrix :: 
    Ptr ColorMatrixNode ->                  -- node : TInterface (Name {namespace = "Gsk", name = "ColorMatrixNode"})
    IO (Ptr Graphene.Matrix.Matrix)

-- | Retrieves the color matrix used by the /@node@/.
colorMatrixNodeGetColorMatrix ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorMatrixNode a) =>
    a
    -- ^ /@node@/: a color matrix @GskRenderNode@
    -> m Graphene.Matrix.Matrix
    -- ^ __Returns:__ a 4x4 color matrix
colorMatrixNodeGetColorMatrix node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_color_matrix_node_get_color_matrix node'
    checkUnexpectedReturnNULL "colorMatrixNodeGetColorMatrix" result
    result' <- (newBoxed Graphene.Matrix.Matrix) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorMatrixNodeGetColorMatrixMethodInfo
instance (signature ~ (m Graphene.Matrix.Matrix), MonadIO m, IsColorMatrixNode a) => O.OverloadedMethod ColorMatrixNodeGetColorMatrixMethodInfo a signature where
    overloadedMethod = colorMatrixNodeGetColorMatrix

instance O.OverloadedMethodInfo ColorMatrixNodeGetColorMatrixMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ColorMatrixNode.colorMatrixNodeGetColorMatrix",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ColorMatrixNode.html#v:colorMatrixNodeGetColorMatrix"
        })


#endif

-- method ColorMatrixNode::get_color_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ColorMatrixNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a color matrix `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Vec4" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_color_matrix_node_get_color_offset" gsk_color_matrix_node_get_color_offset :: 
    Ptr ColorMatrixNode ->                  -- node : TInterface (Name {namespace = "Gsk", name = "ColorMatrixNode"})
    IO (Ptr Graphene.Vec4.Vec4)

-- | Retrieves the color offset used by the /@node@/.
colorMatrixNodeGetColorOffset ::
    (B.CallStack.HasCallStack, MonadIO m, IsColorMatrixNode a) =>
    a
    -- ^ /@node@/: a color matrix @GskRenderNode@
    -> m Graphene.Vec4.Vec4
    -- ^ __Returns:__ a color vector
colorMatrixNodeGetColorOffset node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_color_matrix_node_get_color_offset node'
    checkUnexpectedReturnNULL "colorMatrixNodeGetColorOffset" result
    result' <- (newBoxed Graphene.Vec4.Vec4) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorMatrixNodeGetColorOffsetMethodInfo
instance (signature ~ (m Graphene.Vec4.Vec4), MonadIO m, IsColorMatrixNode a) => O.OverloadedMethod ColorMatrixNodeGetColorOffsetMethodInfo a signature where
    overloadedMethod = colorMatrixNodeGetColorOffset

instance O.OverloadedMethodInfo ColorMatrixNodeGetColorOffsetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.ColorMatrixNode.colorMatrixNodeGetColorOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-ColorMatrixNode.html#v:colorMatrixNodeGetColorOffset"
        })


#endif


