{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Describes the filtering to be performed by a t'GI.Gtk.Objects.FilterListModel.FilterListModel'.
-- 
-- The model will use the filter to determine if it should include items
-- or not by calling 'GI.Gtk.Objects.Filter.filterMatch' for each item and only
-- keeping the ones that the function returns true for.
-- 
-- Filters may change what items they match through their lifetime. In that
-- case, they will emit the [Filter::changed]("GI.Gtk.Objects.Filter#g:signal:changed") signal to notify
-- that previous filter results are no longer valid and that items should
-- be checked again via 'GI.Gtk.Objects.Filter.filterMatch'.
-- 
-- GTK provides various pre-made filter implementations for common filtering
-- operations. These filters often include properties that can be linked to
-- various widgets to easily allow searches.
-- 
-- However, in particular for large lists or complex search methods, it is
-- also possible to subclass @GtkFilter@ and provide one\'s own filter.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Filter
    ( 

-- * Exported types
    Filter(..)                              ,
    IsFilter                                ,
    toFilter                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Filter#g:method:changed"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [match]("GI.Gtk.Objects.Filter#g:method:match"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getStrictness]("GI.Gtk.Objects.Filter#g:method:getStrictness").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveFilterMethod                     ,
#endif

-- ** changed #method:changed#

#if defined(ENABLE_OVERLOADING)
    FilterChangedMethodInfo                 ,
#endif
    filterChanged                           ,


-- ** getStrictness #method:getStrictness#

#if defined(ENABLE_OVERLOADING)
    FilterGetStrictnessMethodInfo           ,
#endif
    filterGetStrictness                     ,


-- ** match #method:match#

#if defined(ENABLE_OVERLOADING)
    FilterMatchMethodInfo                   ,
#endif
    filterMatch                             ,




 -- * Signals


-- ** changed #signal:changed#

    FilterChangedCallback                   ,
#if defined(ENABLE_OVERLOADING)
    FilterChangedSignalInfo                 ,
#endif
    afterFilterChanged                      ,
    onFilterChanged                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums

#endif

-- | Memory-managed wrapper type.
newtype Filter = Filter (SP.ManagedPtr Filter)
    deriving (Eq)

instance SP.ManagedPtrNewtype Filter where
    toManagedPtr (Filter p) = p

foreign import ccall "gtk_filter_get_type"
    c_gtk_filter_get_type :: IO B.Types.GType

instance B.Types.TypedObject Filter where
    glibType = c_gtk_filter_get_type

instance B.Types.GObject Filter

-- | Type class for types which can be safely cast to t'Filter', for instance with `toFilter`.
class (SP.GObject o, O.IsDescendantOf Filter o) => IsFilter o
instance (SP.GObject o, O.IsDescendantOf Filter o) => IsFilter o

instance O.HasParentTypes Filter
type instance O.ParentTypes Filter = '[GObject.Object.Object]

-- | Cast to t'Filter', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toFilter :: (MIO.MonadIO m, IsFilter o) => o -> m Filter
toFilter = MIO.liftIO . B.ManagedPtr.unsafeCastTo Filter

-- | Convert t'Filter' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Filter) where
    gvalueGType_ = c_gtk_filter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Filter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Filter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Filter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveFilterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFilterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveFilterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveFilterMethod "changed" o = FilterChangedMethodInfo
    ResolveFilterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveFilterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveFilterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveFilterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveFilterMethod "match" o = FilterMatchMethodInfo
    ResolveFilterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveFilterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveFilterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveFilterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveFilterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveFilterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveFilterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveFilterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveFilterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveFilterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveFilterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveFilterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveFilterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveFilterMethod "getStrictness" o = FilterGetStrictnessMethodInfo
    ResolveFilterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveFilterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveFilterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveFilterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFilterMethod t Filter, O.OverloadedMethod info Filter p) => OL.IsLabel t (Filter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFilterMethod t Filter, O.OverloadedMethod info Filter p, R.HasField t Filter p) => R.HasField t Filter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFilterMethod t Filter, O.OverloadedMethodInfo info Filter) => OL.IsLabel t (O.MethodProxy info Filter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Filter::changed
-- | Emitted whenever the filter changed.
-- 
-- Users of the filter should then check items again via
-- 'GI.Gtk.Objects.Filter.filterMatch'.
-- 
-- @GtkFilterListModel@ handles this signal automatically.
-- 
-- Depending on the /@change@/ parameter, not all items need
-- to be checked, but only some. Refer to the t'GI.Gtk.Enums.FilterChange'
-- documentation for details.
type FilterChangedCallback =
    Gtk.Enums.FilterChange
    -- ^ /@change@/: how the filter changed
    -> IO ()

type C_FilterChangedCallback =
    Ptr Filter ->                           -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_FilterChangedCallback`.
foreign import ccall "wrapper"
    mk_FilterChangedCallback :: C_FilterChangedCallback -> IO (FunPtr C_FilterChangedCallback)

wrap_FilterChangedCallback :: 
    GObject a => (a -> FilterChangedCallback) ->
    C_FilterChangedCallback
wrap_FilterChangedCallback gi'cb gi'selfPtr change _ = do
    let change' = (toEnum . fromIntegral) change
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  change'


-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' filter #changed callback
-- @
-- 
-- 
onFilterChanged :: (IsFilter a, MonadIO m) => a -> ((?self :: a) => FilterChangedCallback) -> m SignalHandlerId
onFilterChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FilterChangedCallback wrapped
    wrapped'' <- mk_FilterChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' filter #changed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterFilterChanged :: (IsFilter a, MonadIO m) => a -> ((?self :: a) => FilterChangedCallback) -> m SignalHandlerId
afterFilterChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_FilterChangedCallback wrapped
    wrapped'' <- mk_FilterChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data FilterChangedSignalInfo
instance SignalInfo FilterChangedSignalInfo where
    type HaskellCallbackType FilterChangedSignalInfo = FilterChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_FilterChangedCallback cb
        cb'' <- mk_FilterChangedCallback cb'
        connectSignalFunPtr obj "changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Filter::changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Filter.html#g:signal:changed"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Filter
type instance O.AttributeList Filter = FilterAttributeList
type FilterAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Filter = FilterSignalList
type FilterSignalList = ('[ '("changed", FilterChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Filter::changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Filter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "change"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "FilterChange" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "how the filter changed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_filter_changed" gtk_filter_changed :: 
    Ptr Filter ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Filter"})
    CUInt ->                                -- change : TInterface (Name {namespace = "Gtk", name = "FilterChange"})
    IO ()

-- | Notifies all users of the filter that it has changed.
-- 
-- This emits the [Filter::changed]("GI.Gtk.Objects.Filter#g:signal:changed") signal. Users
-- of the filter should then check items again via
-- 'GI.Gtk.Objects.Filter.filterMatch'.
-- 
-- Depending on the /@change@/ parameter, not all items need to
-- be changed, but only some. Refer to the t'GI.Gtk.Enums.FilterChange'
-- documentation for details.
-- 
-- This function is intended for implementers of @GtkFilter@
-- subclasses and should not be called from other functions.
filterChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsFilter a) =>
    a
    -- ^ /@self@/: a filter
    -> Gtk.Enums.FilterChange
    -- ^ /@change@/: how the filter changed
    -> m ()
filterChanged self change = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let change' = (fromIntegral . fromEnum) change
    gtk_filter_changed self' change'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data FilterChangedMethodInfo
instance (signature ~ (Gtk.Enums.FilterChange -> m ()), MonadIO m, IsFilter a) => O.OverloadedMethod FilterChangedMethodInfo a signature where
    overloadedMethod = filterChanged

instance O.OverloadedMethodInfo FilterChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Filter.filterChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Filter.html#v:filterChanged"
        })


#endif

-- method Filter::get_strictness
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Filter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "FilterMatch" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_filter_get_strictness" gtk_filter_get_strictness :: 
    Ptr Filter ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Filter"})
    IO CUInt

-- | Gets the known strictness of a filter.
-- 
-- If the strictness is not known, 'GI.Gtk.Enums.FilterMatchSome' is returned.
-- 
-- This value may change after emission of the [Filter::changed]("GI.Gtk.Objects.Filter#g:signal:changed")
-- signal.
-- 
-- This function is meant purely for optimization purposes. Filters can
-- choose to omit implementing it, but @GtkFilterListModel@ uses it.
filterGetStrictness ::
    (B.CallStack.HasCallStack, MonadIO m, IsFilter a) =>
    a
    -- ^ /@self@/: a filter
    -> m Gtk.Enums.FilterMatch
    -- ^ __Returns:__ the strictness of /@self@/
filterGetStrictness self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_filter_get_strictness self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data FilterGetStrictnessMethodInfo
instance (signature ~ (m Gtk.Enums.FilterMatch), MonadIO m, IsFilter a) => O.OverloadedMethod FilterGetStrictnessMethodInfo a signature where
    overloadedMethod = filterGetStrictness

instance O.OverloadedMethodInfo FilterGetStrictnessMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Filter.filterGetStrictness",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Filter.html#v:filterGetStrictness"
        })


#endif

-- method Filter::match
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Filter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a filter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The item to check" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_filter_match" gtk_filter_match :: 
    Ptr Filter ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Filter"})
    Ptr GObject.Object.Object ->            -- item : TInterface (Name {namespace = "GObject", name = "Object"})
    IO CInt

-- | Checks if the given /@item@/ is matched by the filter or not.
filterMatch ::
    (B.CallStack.HasCallStack, MonadIO m, IsFilter a, GObject.Object.IsObject b) =>
    a
    -- ^ /@self@/: a filter
    -> b
    -- ^ /@item@/: The item to check
    -> m Bool
    -- ^ __Returns:__ true if the filter matches the item
filterMatch self item = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    item' <- unsafeManagedPtrCastPtr item
    result <- gtk_filter_match self' item'
    let result' = (/= 0) result
    touchManagedPtr self
    touchManagedPtr item
    return result'

#if defined(ENABLE_OVERLOADING)
data FilterMatchMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsFilter a, GObject.Object.IsObject b) => O.OverloadedMethod FilterMatchMethodInfo a signature where
    overloadedMethod = filterMatch

instance O.OverloadedMethodInfo FilterMatchMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Filter.filterMatch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Filter.html#v:filterMatch"
        })


#endif


