{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Data type to hold math-variant information for a glyph.
-- 
-- /Since: 1.3.3/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.OtMathGlyphVariantT
    ( 

-- * Exported types
    OtMathGlyphVariantT(..)                 ,
    newZeroOtMathGlyphVariantT              ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveOtMathGlyphVariantTMethod        ,
#endif



 -- * Properties


-- ** advance #attr:advance#
-- | The advance width of the variant

    getOtMathGlyphVariantTAdvance           ,
#if defined(ENABLE_OVERLOADING)
    otMathGlyphVariantT_advance             ,
#endif
    setOtMathGlyphVariantTAdvance           ,


-- ** glyph #attr:glyph#
-- | The glyph index of the variant

    getOtMathGlyphVariantTGlyph             ,
#if defined(ENABLE_OVERLOADING)
    otMathGlyphVariantT_glyph               ,
#endif
    setOtMathGlyphVariantTGlyph             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype OtMathGlyphVariantT = OtMathGlyphVariantT (SP.ManagedPtr OtMathGlyphVariantT)
    deriving (Eq)

instance SP.ManagedPtrNewtype OtMathGlyphVariantT where
    toManagedPtr (OtMathGlyphVariantT p) = p

foreign import ccall "hb_gobject_ot_math_glyph_variant_get_type" c_hb_gobject_ot_math_glyph_variant_get_type :: 
    IO GType

type instance O.ParentTypes OtMathGlyphVariantT = '[]
instance O.HasParentTypes OtMathGlyphVariantT

instance B.Types.TypedObject OtMathGlyphVariantT where
    glibType = c_hb_gobject_ot_math_glyph_variant_get_type

instance B.Types.GBoxed OtMathGlyphVariantT

-- | Convert t'OtMathGlyphVariantT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe OtMathGlyphVariantT) where
    gvalueGType_ = c_hb_gobject_ot_math_glyph_variant_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr OtMathGlyphVariantT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr OtMathGlyphVariantT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed OtMathGlyphVariantT ptr
        else return P.Nothing
        
    

-- | Construct a t'OtMathGlyphVariantT' struct initialized to zero.
newZeroOtMathGlyphVariantT :: MonadIO m => m OtMathGlyphVariantT
newZeroOtMathGlyphVariantT = liftIO $ callocBoxedBytes 8 >>= wrapBoxed OtMathGlyphVariantT

instance tag ~ 'AttrSet => Constructible OtMathGlyphVariantT tag where
    new _ attrs = do
        o <- newZeroOtMathGlyphVariantT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@glyph@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otMathGlyphVariantT #glyph
-- @
getOtMathGlyphVariantTGlyph :: MonadIO m => OtMathGlyphVariantT -> m Word32
getOtMathGlyphVariantTGlyph s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@glyph@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otMathGlyphVariantT [ #glyph 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtMathGlyphVariantTGlyph :: MonadIO m => OtMathGlyphVariantT -> Word32 -> m ()
setOtMathGlyphVariantTGlyph s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data OtMathGlyphVariantTGlyphFieldInfo
instance AttrInfo OtMathGlyphVariantTGlyphFieldInfo where
    type AttrBaseTypeConstraint OtMathGlyphVariantTGlyphFieldInfo = (~) OtMathGlyphVariantT
    type AttrAllowedOps OtMathGlyphVariantTGlyphFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtMathGlyphVariantTGlyphFieldInfo = (~) Word32
    type AttrTransferTypeConstraint OtMathGlyphVariantTGlyphFieldInfo = (~)Word32
    type AttrTransferType OtMathGlyphVariantTGlyphFieldInfo = Word32
    type AttrGetType OtMathGlyphVariantTGlyphFieldInfo = Word32
    type AttrLabel OtMathGlyphVariantTGlyphFieldInfo = "glyph"
    type AttrOrigin OtMathGlyphVariantTGlyphFieldInfo = OtMathGlyphVariantT
    attrGet = getOtMathGlyphVariantTGlyph
    attrSet = setOtMathGlyphVariantTGlyph
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtMathGlyphVariantT.glyph"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtMathGlyphVariantT.html#g:attr:glyph"
        })

otMathGlyphVariantT_glyph :: AttrLabelProxy "glyph"
otMathGlyphVariantT_glyph = AttrLabelProxy

#endif


-- | Get the value of the “@advance@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otMathGlyphVariantT #advance
-- @
getOtMathGlyphVariantTAdvance :: MonadIO m => OtMathGlyphVariantT -> m Int32
getOtMathGlyphVariantTAdvance s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@advance@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otMathGlyphVariantT [ #advance 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtMathGlyphVariantTAdvance :: MonadIO m => OtMathGlyphVariantT -> Int32 -> m ()
setOtMathGlyphVariantTAdvance s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data OtMathGlyphVariantTAdvanceFieldInfo
instance AttrInfo OtMathGlyphVariantTAdvanceFieldInfo where
    type AttrBaseTypeConstraint OtMathGlyphVariantTAdvanceFieldInfo = (~) OtMathGlyphVariantT
    type AttrAllowedOps OtMathGlyphVariantTAdvanceFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtMathGlyphVariantTAdvanceFieldInfo = (~) Int32
    type AttrTransferTypeConstraint OtMathGlyphVariantTAdvanceFieldInfo = (~)Int32
    type AttrTransferType OtMathGlyphVariantTAdvanceFieldInfo = Int32
    type AttrGetType OtMathGlyphVariantTAdvanceFieldInfo = Int32
    type AttrLabel OtMathGlyphVariantTAdvanceFieldInfo = "advance"
    type AttrOrigin OtMathGlyphVariantTAdvanceFieldInfo = OtMathGlyphVariantT
    attrGet = getOtMathGlyphVariantTAdvance
    attrSet = setOtMathGlyphVariantTAdvance
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtMathGlyphVariantT.advance"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtMathGlyphVariantT.html#g:attr:advance"
        })

otMathGlyphVariantT_advance :: AttrLabelProxy "advance"
otMathGlyphVariantT_advance = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OtMathGlyphVariantT
type instance O.AttributeList OtMathGlyphVariantT = OtMathGlyphVariantTAttributeList
type OtMathGlyphVariantTAttributeList = ('[ '("glyph", OtMathGlyphVariantTGlyphFieldInfo), '("advance", OtMathGlyphVariantTAdvanceFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveOtMathGlyphVariantTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOtMathGlyphVariantTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOtMathGlyphVariantTMethod t OtMathGlyphVariantT, O.OverloadedMethod info OtMathGlyphVariantT p) => OL.IsLabel t (OtMathGlyphVariantT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOtMathGlyphVariantTMethod t OtMathGlyphVariantT, O.OverloadedMethod info OtMathGlyphVariantT p, R.HasField t OtMathGlyphVariantT p) => R.HasField t OtMathGlyphVariantT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOtMathGlyphVariantTMethod t OtMathGlyphVariantT, O.OverloadedMethodInfo info OtMathGlyphVariantT) => OL.IsLabel t (O.MethodProxy info OtMathGlyphVariantT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


