/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

// HTTPRouteRuleApplyConfiguration represents a declarative configuration of the HTTPRouteRule type for use
// with apply.
type HTTPRouteRuleApplyConfiguration struct {
	Name               *apisv1.SectionName                   `json:"name,omitempty"`
	Matches            []HTTPRouteMatchApplyConfiguration    `json:"matches,omitempty"`
	Filters            []HTTPRouteFilterApplyConfiguration   `json:"filters,omitempty"`
	BackendRefs        []HTTPBackendRefApplyConfiguration    `json:"backendRefs,omitempty"`
	Timeouts           *HTTPRouteTimeoutsApplyConfiguration  `json:"timeouts,omitempty"`
	Retry              *HTTPRouteRetryApplyConfiguration     `json:"retry,omitempty"`
	SessionPersistence *SessionPersistenceApplyConfiguration `json:"sessionPersistence,omitempty"`
}

// HTTPRouteRuleApplyConfiguration constructs a declarative configuration of the HTTPRouteRule type for use with
// apply.
func HTTPRouteRule() *HTTPRouteRuleApplyConfiguration {
	return &HTTPRouteRuleApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *HTTPRouteRuleApplyConfiguration) WithName(value apisv1.SectionName) *HTTPRouteRuleApplyConfiguration {
	b.Name = &value
	return b
}

// WithMatches adds the given value to the Matches field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Matches field.
func (b *HTTPRouteRuleApplyConfiguration) WithMatches(values ...*HTTPRouteMatchApplyConfiguration) *HTTPRouteRuleApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithMatches")
		}
		b.Matches = append(b.Matches, *values[i])
	}
	return b
}

// WithFilters adds the given value to the Filters field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Filters field.
func (b *HTTPRouteRuleApplyConfiguration) WithFilters(values ...*HTTPRouteFilterApplyConfiguration) *HTTPRouteRuleApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithFilters")
		}
		b.Filters = append(b.Filters, *values[i])
	}
	return b
}

// WithBackendRefs adds the given value to the BackendRefs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the BackendRefs field.
func (b *HTTPRouteRuleApplyConfiguration) WithBackendRefs(values ...*HTTPBackendRefApplyConfiguration) *HTTPRouteRuleApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithBackendRefs")
		}
		b.BackendRefs = append(b.BackendRefs, *values[i])
	}
	return b
}

// WithTimeouts sets the Timeouts field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Timeouts field is set to the value of the last call.
func (b *HTTPRouteRuleApplyConfiguration) WithTimeouts(value *HTTPRouteTimeoutsApplyConfiguration) *HTTPRouteRuleApplyConfiguration {
	b.Timeouts = value
	return b
}

// WithRetry sets the Retry field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Retry field is set to the value of the last call.
func (b *HTTPRouteRuleApplyConfiguration) WithRetry(value *HTTPRouteRetryApplyConfiguration) *HTTPRouteRuleApplyConfiguration {
	b.Retry = value
	return b
}

// WithSessionPersistence sets the SessionPersistence field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SessionPersistence field is set to the value of the last call.
func (b *HTTPRouteRuleApplyConfiguration) WithSessionPersistence(value *SessionPersistenceApplyConfiguration) *HTTPRouteRuleApplyConfiguration {
	b.SessionPersistence = value
	return b
}
