/* parsed class NVC86F */

#include "nvtypes.h"
#include "clc86f.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nvc86f_SET_OBJECT {
    uint32_t nvclass;
    uint32_t engine;
};

static inline void
__NVC86F_SET_OBJECT(uint32_t *val_out, struct nv_nvc86f_SET_OBJECT st)
{
    uint32_t val = 0;
    
    assert(st.nvclass < (1ULL << 16));
    val |= st.nvclass << 0;
    
    assert(st.engine < (1ULL << 5));
    val |= st.engine << 16;
    *val_out = val;
}

#define V_NVC86F_SET_OBJECT(val, args...) { \
    UNUSED uint32_t ENGINE_SW = NVC86F_SET_OBJECT_ENGINE_SW; \
    struct nv_nvc86f_SET_OBJECT __data = args; \
    __NVC86F_SET_OBJECT(&val, __data); \
}

#define VA_NVC86F_SET_OBJECT V_NVC86F_SET_OBJECT

#define P_NVC86F_SET_OBJECT(push, args...) do { \
    UNUSED uint32_t ENGINE_SW = NVC86F_SET_OBJECT_ENGINE_SW; \
    uint32_t nvk_p_ret; \
    V_NVC86F_SET_OBJECT(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_SET_OBJECT, nvk_p_ret); \
} while(0)

struct nv_nvc86f_ILLEGAL {
    uint32_t handle;
};

static inline void
__NVC86F_ILLEGAL(uint32_t *val_out, struct nv_nvc86f_ILLEGAL st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVC86F_ILLEGAL(val, args...) { \
    struct nv_nvc86f_ILLEGAL __data = { .handle = (args) }; \
    __NVC86F_ILLEGAL(&val, __data); \
}

#define VA_NVC86F_ILLEGAL V_NVC86F_ILLEGAL

#define P_NVC86F_ILLEGAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_ILLEGAL(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_ILLEGAL, nvk_p_ret); \
} while(0)

struct nv_nvc86f_NOP {
    uint32_t handle;
};

static inline void
__NVC86F_NOP(uint32_t *val_out, struct nv_nvc86f_NOP st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVC86F_NOP(val, args...) { \
    struct nv_nvc86f_NOP __data = { .handle = (args) }; \
    __NVC86F_NOP(&val, __data); \
}

#define VA_NVC86F_NOP V_NVC86F_NOP

#define P_NVC86F_NOP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_NOP(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_NOP, nvk_p_ret); \
} while(0)

struct nv_nvc86f_SEMAPHOREA {
    uint32_t offset_upper;
};

static inline void
__NVC86F_SEMAPHOREA(uint32_t *val_out, struct nv_nvc86f_SEMAPHOREA st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVC86F_SEMAPHOREA(val, args...) { \
    struct nv_nvc86f_SEMAPHOREA __data = { .offset_upper = (args) }; \
    __NVC86F_SEMAPHOREA(&val, __data); \
}

#define VA_NVC86F_SEMAPHOREA V_NVC86F_SEMAPHOREA

#define P_NVC86F_SEMAPHOREA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_SEMAPHOREA(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_SEMAPHOREA, nvk_p_ret); \
} while(0)

struct nv_nvc86f_SEMAPHOREB {
    uint32_t offset_lower;
};

static inline void
__NVC86F_SEMAPHOREB(uint32_t *val_out, struct nv_nvc86f_SEMAPHOREB st)
{
    uint32_t val = 0;
    
    assert(st.offset_lower < (1ULL << 30));
    val |= st.offset_lower << 2;
    *val_out = val;
}

#define V_NVC86F_SEMAPHOREB(val, args...) { \
    struct nv_nvc86f_SEMAPHOREB __data = { .offset_lower = (args) }; \
    __NVC86F_SEMAPHOREB(&val, __data); \
}

#define VA_NVC86F_SEMAPHOREB V_NVC86F_SEMAPHOREB

#define P_NVC86F_SEMAPHOREB(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_SEMAPHOREB(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_SEMAPHOREB, nvk_p_ret); \
} while(0)

struct nv_nvc86f_SEMAPHOREC {
    uint32_t payload;
};

static inline void
__NVC86F_SEMAPHOREC(uint32_t *val_out, struct nv_nvc86f_SEMAPHOREC st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVC86F_SEMAPHOREC(val, args...) { \
    struct nv_nvc86f_SEMAPHOREC __data = { .payload = (args) }; \
    __NVC86F_SEMAPHOREC(&val, __data); \
}

#define VA_NVC86F_SEMAPHOREC V_NVC86F_SEMAPHOREC

#define P_NVC86F_SEMAPHOREC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_SEMAPHOREC(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_SEMAPHOREC, nvk_p_ret); \
} while(0)

struct nv_nvc86f_SEMAPHORED {
    uint32_t operation;
    uint32_t acquire_switch;
    uint32_t release_wfi;
    uint32_t release_size;
    uint32_t reduction;
    uint32_t format;
};

static inline void
__NVC86F_SEMAPHORED(uint32_t *val_out, struct nv_nvc86f_SEMAPHORED st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 5));
    val |= st.operation << 0;
    
    assert(st.acquire_switch < (1ULL << 1));
    val |= st.acquire_switch << 12;
    
    assert(st.release_wfi < (1ULL << 1));
    val |= st.release_wfi << 20;
    
    assert(st.release_size < (1ULL << 1));
    val |= st.release_size << 24;
    
    assert(st.reduction < (1ULL << 4));
    val |= st.reduction << 27;
    
    assert(st.format < (1ULL << 1));
    val |= st.format << 31;
    *val_out = val;
}

#define V_NVC86F_SEMAPHORED(val, args...) { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVC86F_SEMAPHORED_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVC86F_SEMAPHORED_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQ_GEQ = NVC86F_SEMAPHORED_OPERATION_ACQ_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_AND = NVC86F_SEMAPHORED_OPERATION_ACQ_AND; \
    UNUSED uint32_t OPERATION_REDUCTION = NVC86F_SEMAPHORED_OPERATION_REDUCTION; \
    UNUSED uint32_t ACQUIRE_SWITCH_DISABLED = NVC86F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED; \
    UNUSED uint32_t ACQUIRE_SWITCH_ENABLED = NVC86F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED; \
    UNUSED uint32_t RELEASE_WFI_EN = NVC86F_SEMAPHORED_RELEASE_WFI_EN; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVC86F_SEMAPHORED_RELEASE_WFI_DIS; \
    UNUSED uint32_t RELEASE_SIZE_16BYTE = NVC86F_SEMAPHORED_RELEASE_SIZE_16BYTE; \
    UNUSED uint32_t RELEASE_SIZE_4BYTE = NVC86F_SEMAPHORED_RELEASE_SIZE_4BYTE; \
    UNUSED uint32_t REDUCTION_MIN = NVC86F_SEMAPHORED_REDUCTION_MIN; \
    UNUSED uint32_t REDUCTION_MAX = NVC86F_SEMAPHORED_REDUCTION_MAX; \
    UNUSED uint32_t REDUCTION_XOR = NVC86F_SEMAPHORED_REDUCTION_XOR; \
    UNUSED uint32_t REDUCTION_AND = NVC86F_SEMAPHORED_REDUCTION_AND; \
    UNUSED uint32_t REDUCTION_OR = NVC86F_SEMAPHORED_REDUCTION_OR; \
    UNUSED uint32_t REDUCTION_ADD = NVC86F_SEMAPHORED_REDUCTION_ADD; \
    UNUSED uint32_t REDUCTION_INC = NVC86F_SEMAPHORED_REDUCTION_INC; \
    UNUSED uint32_t REDUCTION_DEC = NVC86F_SEMAPHORED_REDUCTION_DEC; \
    UNUSED uint32_t FORMAT_SIGNED = NVC86F_SEMAPHORED_FORMAT_SIGNED; \
    UNUSED uint32_t FORMAT_UNSIGNED = NVC86F_SEMAPHORED_FORMAT_UNSIGNED; \
    struct nv_nvc86f_SEMAPHORED __data = args; \
    __NVC86F_SEMAPHORED(&val, __data); \
}

#define VA_NVC86F_SEMAPHORED V_NVC86F_SEMAPHORED

#define P_NVC86F_SEMAPHORED(push, args...) do { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVC86F_SEMAPHORED_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVC86F_SEMAPHORED_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQ_GEQ = NVC86F_SEMAPHORED_OPERATION_ACQ_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_AND = NVC86F_SEMAPHORED_OPERATION_ACQ_AND; \
    UNUSED uint32_t OPERATION_REDUCTION = NVC86F_SEMAPHORED_OPERATION_REDUCTION; \
    UNUSED uint32_t ACQUIRE_SWITCH_DISABLED = NVC86F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED; \
    UNUSED uint32_t ACQUIRE_SWITCH_ENABLED = NVC86F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED; \
    UNUSED uint32_t RELEASE_WFI_EN = NVC86F_SEMAPHORED_RELEASE_WFI_EN; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVC86F_SEMAPHORED_RELEASE_WFI_DIS; \
    UNUSED uint32_t RELEASE_SIZE_16BYTE = NVC86F_SEMAPHORED_RELEASE_SIZE_16BYTE; \
    UNUSED uint32_t RELEASE_SIZE_4BYTE = NVC86F_SEMAPHORED_RELEASE_SIZE_4BYTE; \
    UNUSED uint32_t REDUCTION_MIN = NVC86F_SEMAPHORED_REDUCTION_MIN; \
    UNUSED uint32_t REDUCTION_MAX = NVC86F_SEMAPHORED_REDUCTION_MAX; \
    UNUSED uint32_t REDUCTION_XOR = NVC86F_SEMAPHORED_REDUCTION_XOR; \
    UNUSED uint32_t REDUCTION_AND = NVC86F_SEMAPHORED_REDUCTION_AND; \
    UNUSED uint32_t REDUCTION_OR = NVC86F_SEMAPHORED_REDUCTION_OR; \
    UNUSED uint32_t REDUCTION_ADD = NVC86F_SEMAPHORED_REDUCTION_ADD; \
    UNUSED uint32_t REDUCTION_INC = NVC86F_SEMAPHORED_REDUCTION_INC; \
    UNUSED uint32_t REDUCTION_DEC = NVC86F_SEMAPHORED_REDUCTION_DEC; \
    UNUSED uint32_t FORMAT_SIGNED = NVC86F_SEMAPHORED_FORMAT_SIGNED; \
    UNUSED uint32_t FORMAT_UNSIGNED = NVC86F_SEMAPHORED_FORMAT_UNSIGNED; \
    uint32_t nvk_p_ret; \
    V_NVC86F_SEMAPHORED(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_SEMAPHORED, nvk_p_ret); \
} while(0)

struct nv_nvc86f_NON_STALL_INTERRUPT {
    uint32_t handle;
};

static inline void
__NVC86F_NON_STALL_INTERRUPT(uint32_t *val_out, struct nv_nvc86f_NON_STALL_INTERRUPT st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVC86F_NON_STALL_INTERRUPT(val, args...) { \
    struct nv_nvc86f_NON_STALL_INTERRUPT __data = { .handle = (args) }; \
    __NVC86F_NON_STALL_INTERRUPT(&val, __data); \
}

#define VA_NVC86F_NON_STALL_INTERRUPT V_NVC86F_NON_STALL_INTERRUPT

#define P_NVC86F_NON_STALL_INTERRUPT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_NON_STALL_INTERRUPT(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_NON_STALL_INTERRUPT, nvk_p_ret); \
} while(0)

struct nv_nvc86f_FB_FLUSH {
    uint32_t handle;
};

static inline void
__NVC86F_FB_FLUSH(uint32_t *val_out, struct nv_nvc86f_FB_FLUSH st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVC86F_FB_FLUSH(val, args...) { \
    struct nv_nvc86f_FB_FLUSH __data = { .handle = (args) }; \
    __NVC86F_FB_FLUSH(&val, __data); \
}

#define VA_NVC86F_FB_FLUSH V_NVC86F_FB_FLUSH

#define P_NVC86F_FB_FLUSH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_FB_FLUSH(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_FB_FLUSH, nvk_p_ret); \
} while(0)

struct nv_nvc86f_MEM_OP_A {
    uint32_t tlb_invalidate_cancel_target_client_unit_id;
    uint32_t tlb_invalidate_invalidation_size;
    uint32_t tlb_invalidate_cancel_target_gpc_id;
    uint32_t tlb_invalidate_inval_scope;
    uint32_t tlb_invalidate_cancel_mmu_engine_id;
    uint32_t tlb_invalidate_sysmembar;
    uint32_t tlb_invalidate_target_addr_lo;
};

static inline void
__NVC86F_MEM_OP_A(uint32_t *val_out, struct nv_nvc86f_MEM_OP_A st)
{
    uint32_t val = 0;
    
    assert(st.tlb_invalidate_cancel_target_client_unit_id < (1ULL << 6));
    val |= st.tlb_invalidate_cancel_target_client_unit_id << 0;
    
    assert(st.tlb_invalidate_invalidation_size < (1ULL << 6));
    val |= st.tlb_invalidate_invalidation_size << 0;
    
    assert(st.tlb_invalidate_cancel_target_gpc_id < (1ULL << 5));
    val |= st.tlb_invalidate_cancel_target_gpc_id << 6;
    
    assert(st.tlb_invalidate_inval_scope < (1ULL << 2));
    val |= st.tlb_invalidate_inval_scope << 6;
    
    assert(st.tlb_invalidate_cancel_mmu_engine_id < (1ULL << 9));
    val |= st.tlb_invalidate_cancel_mmu_engine_id << 0;
    
    assert(st.tlb_invalidate_sysmembar < (1ULL << 1));
    val |= st.tlb_invalidate_sysmembar << 11;
    
    assert(st.tlb_invalidate_target_addr_lo < (1ULL << 20));
    val |= st.tlb_invalidate_target_addr_lo << 12;
    *val_out = val;
}

#define V_NVC86F_MEM_OP_A(val, args...) { \
    UNUSED uint32_t TLB_INVALIDATE_INVAL_SCOPE_ALL_TLBS = NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_ALL_TLBS; \
    UNUSED uint32_t TLB_INVALIDATE_INVAL_SCOPE_LINK_TLBS = NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_LINK_TLBS; \
    UNUSED uint32_t TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS = NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS; \
    UNUSED uint32_t TLB_INVALIDATE_INVAL_SCOPE_RSVRVD = NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_RSVRVD; \
    UNUSED uint32_t TLB_INVALIDATE_SYSMEMBAR_EN = NVC86F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN; \
    UNUSED uint32_t TLB_INVALIDATE_SYSMEMBAR_DIS = NVC86F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS; \
    struct nv_nvc86f_MEM_OP_A __data = args; \
    __NVC86F_MEM_OP_A(&val, __data); \
}

#define VA_NVC86F_MEM_OP_A V_NVC86F_MEM_OP_A

#define P_NVC86F_MEM_OP_A(push, args...) do { \
    UNUSED uint32_t TLB_INVALIDATE_INVAL_SCOPE_ALL_TLBS = NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_ALL_TLBS; \
    UNUSED uint32_t TLB_INVALIDATE_INVAL_SCOPE_LINK_TLBS = NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_LINK_TLBS; \
    UNUSED uint32_t TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS = NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS; \
    UNUSED uint32_t TLB_INVALIDATE_INVAL_SCOPE_RSVRVD = NVC86F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_RSVRVD; \
    UNUSED uint32_t TLB_INVALIDATE_SYSMEMBAR_EN = NVC86F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN; \
    UNUSED uint32_t TLB_INVALIDATE_SYSMEMBAR_DIS = NVC86F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS; \
    uint32_t nvk_p_ret; \
    V_NVC86F_MEM_OP_A(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_MEM_OP_A, nvk_p_ret); \
} while(0)

struct nv_nvc86f_MEM_OP_B {
    uint32_t tlb_invalidate_target_addr_hi;
};

static inline void
__NVC86F_MEM_OP_B(uint32_t *val_out, struct nv_nvc86f_MEM_OP_B st)
{
    uint32_t val = 0;
    
    val |= st.tlb_invalidate_target_addr_hi;
    *val_out = val;
}

#define V_NVC86F_MEM_OP_B(val, args...) { \
    struct nv_nvc86f_MEM_OP_B __data = { .tlb_invalidate_target_addr_hi = (args) }; \
    __NVC86F_MEM_OP_B(&val, __data); \
}

#define VA_NVC86F_MEM_OP_B V_NVC86F_MEM_OP_B

#define P_NVC86F_MEM_OP_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_MEM_OP_B(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_MEM_OP_B, nvk_p_ret); \
} while(0)

struct nv_nvc86f_MEM_OP_C {
    uint32_t membar_type;
    uint32_t tlb_invalidate_pdb;
    uint32_t tlb_invalidate_gpc;
    uint32_t tlb_invalidate_replay;
    uint32_t tlb_invalidate_ack_type;
    uint32_t tlb_invalidate_access_type;
    uint32_t tlb_invalidate_page_table_level;
    uint32_t tlb_invalidate_pdb_aperture;
    uint32_t tlb_invalidate_pdb_addr_lo;
    uint32_t access_counter_clr_targeted_notify_tag;
};

static inline void
__NVC86F_MEM_OP_C(uint32_t *val_out, struct nv_nvc86f_MEM_OP_C st)
{
    uint32_t val = 0;
    
    assert(st.membar_type < (1ULL << 3));
    val |= st.membar_type << 0;
    
    assert(st.tlb_invalidate_pdb < (1ULL << 1));
    val |= st.tlb_invalidate_pdb << 0;
    
    assert(st.tlb_invalidate_gpc < (1ULL << 1));
    val |= st.tlb_invalidate_gpc << 1;
    
    assert(st.tlb_invalidate_replay < (1ULL << 3));
    val |= st.tlb_invalidate_replay << 2;
    
    assert(st.tlb_invalidate_ack_type < (1ULL << 2));
    val |= st.tlb_invalidate_ack_type << 5;
    
    assert(st.tlb_invalidate_access_type < (1ULL << 3));
    val |= st.tlb_invalidate_access_type << 7;
    
    assert(st.tlb_invalidate_page_table_level < (1ULL << 3));
    val |= st.tlb_invalidate_page_table_level << 7;
    
    assert(st.tlb_invalidate_pdb_aperture < (1ULL << 2));
    val |= st.tlb_invalidate_pdb_aperture << 10;
    
    assert(st.tlb_invalidate_pdb_addr_lo < (1ULL << 20));
    val |= st.tlb_invalidate_pdb_addr_lo << 12;
    
    assert(st.access_counter_clr_targeted_notify_tag < (1ULL << 20));
    val |= st.access_counter_clr_targeted_notify_tag << 0;
    *val_out = val;
}

#define V_NVC86F_MEM_OP_C(val, args...) { \
    UNUSED uint32_t MEMBAR_TYPE_SYS_MEMBAR = NVC86F_MEM_OP_C_MEMBAR_TYPE_SYS_MEMBAR; \
    UNUSED uint32_t MEMBAR_TYPE_MEMBAR = NVC86F_MEM_OP_C_MEMBAR_TYPE_MEMBAR; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ONE = NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ALL = NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_ENABLE = NVC86F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_DISABLE = NVC86F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_NONE = NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_NONE; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_START = NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_START_ACK_ALL = NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START_ACK_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_CANCEL_TARGETED = NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_TARGETED; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_CANCEL_GLOBAL = NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_GLOBAL; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_CANCEL_VA_GLOBAL = NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_VA_GLOBAL; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_NONE = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_NONE; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_GLOBALLY = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_GLOBALLY; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_INTRANODE = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_INTRANODE; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_READ = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_READ; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_STRONG = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_STRONG; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_RSVRVD = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_RSVRVD; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_WEAK = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_WEAK; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_ALL = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE_AND_ATOMIC = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE_AND_ATOMIC; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_ALL = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE0 = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE0; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE1 = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE1; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE2 = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE2; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE3 = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE3; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4 = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE5 = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE5; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_VID_MEM = NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_VID_MEM; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT = NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_NONCOHERENT = NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_NONCOHERENT; \
    struct nv_nvc86f_MEM_OP_C __data = args; \
    __NVC86F_MEM_OP_C(&val, __data); \
}

#define VA_NVC86F_MEM_OP_C V_NVC86F_MEM_OP_C

#define P_NVC86F_MEM_OP_C(push, args...) do { \
    UNUSED uint32_t MEMBAR_TYPE_SYS_MEMBAR = NVC86F_MEM_OP_C_MEMBAR_TYPE_SYS_MEMBAR; \
    UNUSED uint32_t MEMBAR_TYPE_MEMBAR = NVC86F_MEM_OP_C_MEMBAR_TYPE_MEMBAR; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ONE = NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_ALL = NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_ENABLE = NVC86F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE; \
    UNUSED uint32_t TLB_INVALIDATE_GPC_DISABLE = NVC86F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_NONE = NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_NONE; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_START = NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_START_ACK_ALL = NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START_ACK_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_CANCEL_TARGETED = NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_TARGETED; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_CANCEL_GLOBAL = NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_GLOBAL; \
    UNUSED uint32_t TLB_INVALIDATE_REPLAY_CANCEL_VA_GLOBAL = NVC86F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_VA_GLOBAL; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_NONE = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_NONE; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_GLOBALLY = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_GLOBALLY; \
    UNUSED uint32_t TLB_INVALIDATE_ACK_TYPE_INTRANODE = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_INTRANODE; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_READ = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_READ; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_STRONG = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_STRONG; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_RSVRVD = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_RSVRVD; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_WEAK = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_WEAK; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_ALL = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE_AND_ATOMIC = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE_AND_ATOMIC; \
    UNUSED uint32_t TLB_INVALIDATE_ACCESS_TYPE_VIRT_ALL = NVC86F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE0 = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE0; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE1 = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE1; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE2 = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE2; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE3 = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE3; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4 = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4; \
    UNUSED uint32_t TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE5 = NVC86F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE5; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_VID_MEM = NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_VID_MEM; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT = NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT; \
    UNUSED uint32_t TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_NONCOHERENT = NVC86F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_NONCOHERENT; \
    uint32_t nvk_p_ret; \
    V_NVC86F_MEM_OP_C(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_MEM_OP_C, nvk_p_ret); \
} while(0)

struct nv_nvc86f_MEM_OP_D {
    uint32_t tlb_invalidate_pdb_addr_hi;
    uint32_t operation;
};

static inline void
__NVC86F_MEM_OP_D(uint32_t *val_out, struct nv_nvc86f_MEM_OP_D st)
{
    uint32_t val = 0;
    
    assert(st.tlb_invalidate_pdb_addr_hi < (1ULL << 27));
    val |= st.tlb_invalidate_pdb_addr_hi << 0;
    
    assert(st.operation < (1ULL << 5));
    val |= st.operation << 27;
    *val_out = val;
}

#define V_NVC86F_MEM_OP_D(val, args...) { \
    UNUSED uint32_t OPERATION_MEMBAR = NVC86F_MEM_OP_D_OPERATION_MEMBAR; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE = NVC86F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE_TARGETED = NVC86F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE_TARGETED; \
    UNUSED uint32_t OPERATION_MMU_OPERATION = NVC86F_MEM_OP_D_OPERATION_MMU_OPERATION; \
    UNUSED uint32_t OPERATION_L2_PEERMEM_INVALIDATE = NVC86F_MEM_OP_D_OPERATION_L2_PEERMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_SYSMEM_INVALIDATE = NVC86F_MEM_OP_D_OPERATION_L2_SYSMEM_INVALIDATE; \
    struct nv_nvc86f_MEM_OP_D __data = args; \
    __NVC86F_MEM_OP_D(&val, __data); \
}

#define VA_NVC86F_MEM_OP_D V_NVC86F_MEM_OP_D

#define P_NVC86F_MEM_OP_D(push, args...) do { \
    UNUSED uint32_t OPERATION_MEMBAR = NVC86F_MEM_OP_D_OPERATION_MEMBAR; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE = NVC86F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE_TARGETED = NVC86F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE_TARGETED; \
    UNUSED uint32_t OPERATION_MMU_OPERATION = NVC86F_MEM_OP_D_OPERATION_MMU_OPERATION; \
    UNUSED uint32_t OPERATION_L2_PEERMEM_INVALIDATE = NVC86F_MEM_OP_D_OPERATION_L2_PEERMEM_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_SYSMEM_INVALIDATE = NVC86F_MEM_OP_D_OPERATION_L2_SYSMEM_INVALIDATE; \
    uint32_t nvk_p_ret; \
    V_NVC86F_MEM_OP_D(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_MEM_OP_D, nvk_p_ret); \
} while(0)

struct nv_nvc86f_SET_REFERENCE {
    uint32_t count;
};

static inline void
__NVC86F_SET_REFERENCE(uint32_t *val_out, struct nv_nvc86f_SET_REFERENCE st)
{
    uint32_t val = 0;
    
    val |= st.count;
    *val_out = val;
}

#define V_NVC86F_SET_REFERENCE(val, args...) { \
    struct nv_nvc86f_SET_REFERENCE __data = { .count = (args) }; \
    __NVC86F_SET_REFERENCE(&val, __data); \
}

#define VA_NVC86F_SET_REFERENCE V_NVC86F_SET_REFERENCE

#define P_NVC86F_SET_REFERENCE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_SET_REFERENCE(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_SET_REFERENCE, nvk_p_ret); \
} while(0)

struct nv_nvc86f_SEM_ADDR_LO {
    uint32_t offset;
};

static inline void
__NVC86F_SEM_ADDR_LO(uint32_t *val_out, struct nv_nvc86f_SEM_ADDR_LO st)
{
    uint32_t val = 0;
    
    assert(st.offset < (1ULL << 30));
    val |= st.offset << 2;
    *val_out = val;
}

#define V_NVC86F_SEM_ADDR_LO(val, args...) { \
    struct nv_nvc86f_SEM_ADDR_LO __data = { .offset = (args) }; \
    __NVC86F_SEM_ADDR_LO(&val, __data); \
}

#define VA_NVC86F_SEM_ADDR_LO V_NVC86F_SEM_ADDR_LO

#define P_NVC86F_SEM_ADDR_LO(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_SEM_ADDR_LO(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_SEM_ADDR_LO, nvk_p_ret); \
} while(0)

struct nv_nvc86f_SEM_ADDR_HI {
    uint32_t offset;
};

static inline void
__NVC86F_SEM_ADDR_HI(uint32_t *val_out, struct nv_nvc86f_SEM_ADDR_HI st)
{
    uint32_t val = 0;
    
    assert(st.offset < (1ULL << 25));
    val |= st.offset << 0;
    *val_out = val;
}

#define V_NVC86F_SEM_ADDR_HI(val, args...) { \
    struct nv_nvc86f_SEM_ADDR_HI __data = { .offset = (args) }; \
    __NVC86F_SEM_ADDR_HI(&val, __data); \
}

#define VA_NVC86F_SEM_ADDR_HI V_NVC86F_SEM_ADDR_HI

#define P_NVC86F_SEM_ADDR_HI(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_SEM_ADDR_HI(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_SEM_ADDR_HI, nvk_p_ret); \
} while(0)

struct nv_nvc86f_SEM_PAYLOAD_LO {
    uint32_t payload;
};

static inline void
__NVC86F_SEM_PAYLOAD_LO(uint32_t *val_out, struct nv_nvc86f_SEM_PAYLOAD_LO st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVC86F_SEM_PAYLOAD_LO(val, args...) { \
    struct nv_nvc86f_SEM_PAYLOAD_LO __data = { .payload = (args) }; \
    __NVC86F_SEM_PAYLOAD_LO(&val, __data); \
}

#define VA_NVC86F_SEM_PAYLOAD_LO V_NVC86F_SEM_PAYLOAD_LO

#define P_NVC86F_SEM_PAYLOAD_LO(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_SEM_PAYLOAD_LO(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_SEM_PAYLOAD_LO, nvk_p_ret); \
} while(0)

struct nv_nvc86f_SEM_PAYLOAD_HI {
    uint32_t payload;
};

static inline void
__NVC86F_SEM_PAYLOAD_HI(uint32_t *val_out, struct nv_nvc86f_SEM_PAYLOAD_HI st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVC86F_SEM_PAYLOAD_HI(val, args...) { \
    struct nv_nvc86f_SEM_PAYLOAD_HI __data = { .payload = (args) }; \
    __NVC86F_SEM_PAYLOAD_HI(&val, __data); \
}

#define VA_NVC86F_SEM_PAYLOAD_HI V_NVC86F_SEM_PAYLOAD_HI

#define P_NVC86F_SEM_PAYLOAD_HI(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC86F_SEM_PAYLOAD_HI(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_SEM_PAYLOAD_HI, nvk_p_ret); \
} while(0)

struct nv_nvc86f_SEM_EXECUTE {
    uint32_t operation;
    uint32_t acquire_switch_tsg;
    uint32_t release_wfi;
    uint32_t payload_size;
    uint32_t release_timestamp;
    uint32_t reduction;
    uint32_t reduction_format;
};

static inline void
__NVC86F_SEM_EXECUTE(uint32_t *val_out, struct nv_nvc86f_SEM_EXECUTE st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 3));
    val |= st.operation << 0;
    
    assert(st.acquire_switch_tsg < (1ULL << 1));
    val |= st.acquire_switch_tsg << 12;
    
    assert(st.release_wfi < (1ULL << 1));
    val |= st.release_wfi << 20;
    
    assert(st.payload_size < (1ULL << 1));
    val |= st.payload_size << 24;
    
    assert(st.release_timestamp < (1ULL << 1));
    val |= st.release_timestamp << 25;
    
    assert(st.reduction < (1ULL << 4));
    val |= st.reduction << 27;
    
    assert(st.reduction_format < (1ULL << 1));
    val |= st.reduction_format << 31;
    *val_out = val;
}

#define V_NVC86F_SEM_EXECUTE(val, args...) { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVC86F_SEM_EXECUTE_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVC86F_SEM_EXECUTE_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQ_STRICT_GEQ = NVC86F_SEM_EXECUTE_OPERATION_ACQ_STRICT_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_CIRC_GEQ = NVC86F_SEM_EXECUTE_OPERATION_ACQ_CIRC_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_AND = NVC86F_SEM_EXECUTE_OPERATION_ACQ_AND; \
    UNUSED uint32_t OPERATION_ACQ_NOR = NVC86F_SEM_EXECUTE_OPERATION_ACQ_NOR; \
    UNUSED uint32_t OPERATION_REDUCTION = NVC86F_SEM_EXECUTE_OPERATION_REDUCTION; \
    UNUSED uint32_t ACQUIRE_SWITCH_TSG_DIS = NVC86F_SEM_EXECUTE_ACQUIRE_SWITCH_TSG_DIS; \
    UNUSED uint32_t ACQUIRE_SWITCH_TSG_EN = NVC86F_SEM_EXECUTE_ACQUIRE_SWITCH_TSG_EN; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVC86F_SEM_EXECUTE_RELEASE_WFI_DIS; \
    UNUSED uint32_t RELEASE_WFI_EN = NVC86F_SEM_EXECUTE_RELEASE_WFI_EN; \
    UNUSED uint32_t PAYLOAD_SIZE_32BIT = NVC86F_SEM_EXECUTE_PAYLOAD_SIZE_32BIT; \
    UNUSED uint32_t PAYLOAD_SIZE_64BIT = NVC86F_SEM_EXECUTE_PAYLOAD_SIZE_64BIT; \
    UNUSED uint32_t RELEASE_TIMESTAMP_DIS = NVC86F_SEM_EXECUTE_RELEASE_TIMESTAMP_DIS; \
    UNUSED uint32_t RELEASE_TIMESTAMP_EN = NVC86F_SEM_EXECUTE_RELEASE_TIMESTAMP_EN; \
    UNUSED uint32_t REDUCTION_IMIN = NVC86F_SEM_EXECUTE_REDUCTION_IMIN; \
    UNUSED uint32_t REDUCTION_IMAX = NVC86F_SEM_EXECUTE_REDUCTION_IMAX; \
    UNUSED uint32_t REDUCTION_IXOR = NVC86F_SEM_EXECUTE_REDUCTION_IXOR; \
    UNUSED uint32_t REDUCTION_IAND = NVC86F_SEM_EXECUTE_REDUCTION_IAND; \
    UNUSED uint32_t REDUCTION_IOR = NVC86F_SEM_EXECUTE_REDUCTION_IOR; \
    UNUSED uint32_t REDUCTION_IADD = NVC86F_SEM_EXECUTE_REDUCTION_IADD; \
    UNUSED uint32_t REDUCTION_INC = NVC86F_SEM_EXECUTE_REDUCTION_INC; \
    UNUSED uint32_t REDUCTION_DEC = NVC86F_SEM_EXECUTE_REDUCTION_DEC; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED = NVC86F_SEM_EXECUTE_REDUCTION_FORMAT_SIGNED; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED = NVC86F_SEM_EXECUTE_REDUCTION_FORMAT_UNSIGNED; \
    struct nv_nvc86f_SEM_EXECUTE __data = args; \
    __NVC86F_SEM_EXECUTE(&val, __data); \
}

#define VA_NVC86F_SEM_EXECUTE V_NVC86F_SEM_EXECUTE

#define P_NVC86F_SEM_EXECUTE(push, args...) do { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVC86F_SEM_EXECUTE_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVC86F_SEM_EXECUTE_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQ_STRICT_GEQ = NVC86F_SEM_EXECUTE_OPERATION_ACQ_STRICT_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_CIRC_GEQ = NVC86F_SEM_EXECUTE_OPERATION_ACQ_CIRC_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_AND = NVC86F_SEM_EXECUTE_OPERATION_ACQ_AND; \
    UNUSED uint32_t OPERATION_ACQ_NOR = NVC86F_SEM_EXECUTE_OPERATION_ACQ_NOR; \
    UNUSED uint32_t OPERATION_REDUCTION = NVC86F_SEM_EXECUTE_OPERATION_REDUCTION; \
    UNUSED uint32_t ACQUIRE_SWITCH_TSG_DIS = NVC86F_SEM_EXECUTE_ACQUIRE_SWITCH_TSG_DIS; \
    UNUSED uint32_t ACQUIRE_SWITCH_TSG_EN = NVC86F_SEM_EXECUTE_ACQUIRE_SWITCH_TSG_EN; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVC86F_SEM_EXECUTE_RELEASE_WFI_DIS; \
    UNUSED uint32_t RELEASE_WFI_EN = NVC86F_SEM_EXECUTE_RELEASE_WFI_EN; \
    UNUSED uint32_t PAYLOAD_SIZE_32BIT = NVC86F_SEM_EXECUTE_PAYLOAD_SIZE_32BIT; \
    UNUSED uint32_t PAYLOAD_SIZE_64BIT = NVC86F_SEM_EXECUTE_PAYLOAD_SIZE_64BIT; \
    UNUSED uint32_t RELEASE_TIMESTAMP_DIS = NVC86F_SEM_EXECUTE_RELEASE_TIMESTAMP_DIS; \
    UNUSED uint32_t RELEASE_TIMESTAMP_EN = NVC86F_SEM_EXECUTE_RELEASE_TIMESTAMP_EN; \
    UNUSED uint32_t REDUCTION_IMIN = NVC86F_SEM_EXECUTE_REDUCTION_IMIN; \
    UNUSED uint32_t REDUCTION_IMAX = NVC86F_SEM_EXECUTE_REDUCTION_IMAX; \
    UNUSED uint32_t REDUCTION_IXOR = NVC86F_SEM_EXECUTE_REDUCTION_IXOR; \
    UNUSED uint32_t REDUCTION_IAND = NVC86F_SEM_EXECUTE_REDUCTION_IAND; \
    UNUSED uint32_t REDUCTION_IOR = NVC86F_SEM_EXECUTE_REDUCTION_IOR; \
    UNUSED uint32_t REDUCTION_IADD = NVC86F_SEM_EXECUTE_REDUCTION_IADD; \
    UNUSED uint32_t REDUCTION_INC = NVC86F_SEM_EXECUTE_REDUCTION_INC; \
    UNUSED uint32_t REDUCTION_DEC = NVC86F_SEM_EXECUTE_REDUCTION_DEC; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED = NVC86F_SEM_EXECUTE_REDUCTION_FORMAT_SIGNED; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED = NVC86F_SEM_EXECUTE_REDUCTION_FORMAT_UNSIGNED; \
    uint32_t nvk_p_ret; \
    V_NVC86F_SEM_EXECUTE(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_SEM_EXECUTE, nvk_p_ret); \
} while(0)

struct nv_nvc86f_WFI {
    uint32_t scope;
};

static inline void
__NVC86F_WFI(uint32_t *val_out, struct nv_nvc86f_WFI st)
{
    uint32_t val = 0;
    
    assert(st.scope < (1ULL << 1));
    val |= st.scope << 0;
    *val_out = val;
}

#define V_NVC86F_WFI(val, args...) { \
    UNUSED uint32_t SCOPE_CURRENT_VEID = NVC86F_WFI_SCOPE_CURRENT_VEID; \
    UNUSED uint32_t SCOPE_ALL = NVC86F_WFI_SCOPE_ALL; \
    struct nv_nvc86f_WFI __data = { .scope = (args) }; \
    __NVC86F_WFI(&val, __data); \
}

#define VA_NVC86F_WFI V_NVC86F_WFI

#define P_NVC86F_WFI(push, args...) do { \
    UNUSED uint32_t SCOPE_CURRENT_VEID = NVC86F_WFI_SCOPE_CURRENT_VEID; \
    UNUSED uint32_t SCOPE_ALL = NVC86F_WFI_SCOPE_ALL; \
    uint32_t nvk_p_ret; \
    V_NVC86F_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_WFI, nvk_p_ret); \
} while(0)

struct nv_nvc86f_YIELD {
    uint32_t op;
};

static inline void
__NVC86F_YIELD(uint32_t *val_out, struct nv_nvc86f_YIELD st)
{
    uint32_t val = 0;
    
    assert(st.op < (1ULL << 2));
    val |= st.op << 0;
    *val_out = val;
}

#define V_NVC86F_YIELD(val, args...) { \
    UNUSED uint32_t OP_NOP = NVC86F_YIELD_OP_NOP; \
    UNUSED uint32_t OP_TSG = NVC86F_YIELD_OP_TSG; \
    struct nv_nvc86f_YIELD __data = { .op = (args) }; \
    __NVC86F_YIELD(&val, __data); \
}

#define VA_NVC86F_YIELD V_NVC86F_YIELD

#define P_NVC86F_YIELD(push, args...) do { \
    UNUSED uint32_t OP_NOP = NVC86F_YIELD_OP_NOP; \
    UNUSED uint32_t OP_TSG = NVC86F_YIELD_OP_TSG; \
    uint32_t nvk_p_ret; \
    V_NVC86F_YIELD(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_YIELD, nvk_p_ret); \
} while(0)

struct nv_nvc86f_CLEAR_FAULTED {
    uint32_t handle;
    uint32_t type;
};

static inline void
__NVC86F_CLEAR_FAULTED(uint32_t *val_out, struct nv_nvc86f_CLEAR_FAULTED st)
{
    uint32_t val = 0;
    
    assert(st.handle < (1ULL << 31));
    val |= st.handle << 0;
    
    assert(st.type < (1ULL << 1));
    val |= st.type << 31;
    *val_out = val;
}

#define V_NVC86F_CLEAR_FAULTED(val, args...) { \
    UNUSED uint32_t TYPE_PBDMA_FAULTED = NVC86F_CLEAR_FAULTED_TYPE_PBDMA_FAULTED; \
    UNUSED uint32_t TYPE_ENG_FAULTED = NVC86F_CLEAR_FAULTED_TYPE_ENG_FAULTED; \
    struct nv_nvc86f_CLEAR_FAULTED __data = args; \
    __NVC86F_CLEAR_FAULTED(&val, __data); \
}

#define VA_NVC86F_CLEAR_FAULTED V_NVC86F_CLEAR_FAULTED

#define P_NVC86F_CLEAR_FAULTED(push, args...) do { \
    UNUSED uint32_t TYPE_PBDMA_FAULTED = NVC86F_CLEAR_FAULTED_TYPE_PBDMA_FAULTED; \
    UNUSED uint32_t TYPE_ENG_FAULTED = NVC86F_CLEAR_FAULTED_TYPE_ENG_FAULTED; \
    uint32_t nvk_p_ret; \
    V_NVC86F_CLEAR_FAULTED(nvk_p_ret, args); \
    nv_push_val(push, NVC86F_CLEAR_FAULTED, nvk_p_ret); \
} while(0)


const char *P_PARSE_NVC86F_MTHD(uint16_t idx);
void P_DUMP_NVC86F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix);
