/* SystemUpdate.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SystemUpdate.vala, do not modify */

/*
 * Copyright 2023 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <packagekit-glib2/packagekit.h>
#include <glib/gi18n-lib.h>

#define SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_NOTIFICATION_ID "system-update"
#define SETTINGS_DAEMON_APPLICATION_ACTION_PREFIX "app."
#define SETTINGS_DAEMON_APPLICATION_SHOW_UPDATES_ACTION "show-updates"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SETTINGS_DAEMON_BACKENDS_TYPE_SYSTEM_UPDATE (settings_daemon_backends_system_update_get_type ())
#define SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SETTINGS_DAEMON_BACKENDS_TYPE_SYSTEM_UPDATE, SettingsDaemonBackendsSystemUpdate))
#define SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SETTINGS_DAEMON_BACKENDS_TYPE_SYSTEM_UPDATE, SettingsDaemonBackendsSystemUpdateClass))
#define SETTINGS_DAEMON_BACKENDS_IS_SYSTEM_UPDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SETTINGS_DAEMON_BACKENDS_TYPE_SYSTEM_UPDATE))
#define SETTINGS_DAEMON_BACKENDS_IS_SYSTEM_UPDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SETTINGS_DAEMON_BACKENDS_TYPE_SYSTEM_UPDATE))
#define SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SETTINGS_DAEMON_BACKENDS_TYPE_SYSTEM_UPDATE, SettingsDaemonBackendsSystemUpdateClass))

typedef struct _SettingsDaemonBackendsSystemUpdate SettingsDaemonBackendsSystemUpdate;
typedef struct _SettingsDaemonBackendsSystemUpdateClass SettingsDaemonBackendsSystemUpdateClass;
typedef struct _SettingsDaemonBackendsSystemUpdatePrivate SettingsDaemonBackendsSystemUpdatePrivate;

#define SETTINGS_DAEMON_PK_UTILS_TYPE_CURRENT_STATE (settings_daemon_pk_utils_current_state_get_type ())
typedef struct _SettingsDaemonPkUtilsCurrentState SettingsDaemonPkUtilsCurrentState;
typedef enum  {
	SETTINGS_DAEMON_PK_UTILS_STATE_UP_TO_DATE,
	SETTINGS_DAEMON_PK_UTILS_STATE_CHECKING,
	SETTINGS_DAEMON_PK_UTILS_STATE_AVAILABLE,
	SETTINGS_DAEMON_PK_UTILS_STATE_DOWNLOADING,
	SETTINGS_DAEMON_PK_UTILS_STATE_RESTART_REQUIRED,
	SETTINGS_DAEMON_PK_UTILS_STATE_ERROR
} SettingsDaemonPkUtilsState;

#define SETTINGS_DAEMON_PK_UTILS_TYPE_STATE (settings_daemon_pk_utils_state_get_type ())

#define SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_TYPE_UPDATE_DETAILS (settings_daemon_backends_system_update_update_details_get_type ())
typedef struct _SettingsDaemonBackendsSystemUpdateUpdateDetails SettingsDaemonBackendsSystemUpdateUpdateDetails;
enum  {
	SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_0_PROPERTY,
	SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_NUM_PROPERTIES
};
static GParamSpec* settings_daemon_backends_system_update_properties[SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _SettingsDaemonBackendsSystemUpdateCheckForUpdatesData SettingsDaemonBackendsSystemUpdateCheckForUpdatesData;
typedef struct _SettingsDaemonBackendsSystemUpdateUpdateData SettingsDaemonBackendsSystemUpdateUpdateData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SettingsDaemonBackendsSystemUpdateGetCurrentStateData SettingsDaemonBackendsSystemUpdateGetCurrentStateData;
typedef struct _SettingsDaemonBackendsSystemUpdateGetUpdateDetailsData SettingsDaemonBackendsSystemUpdateGetUpdateDetailsData;
typedef struct _SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeData SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeData;
enum  {
	SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_STATE_CHANGED_SIGNAL,
	SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_NUM_SIGNALS
};
static guint settings_daemon_backends_system_update_signals[SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_NUM_SIGNALS] = {0};
typedef struct _SettingsDaemonBackendsSystemUpdateCheckForUpdatesReadyData SettingsDaemonBackendsSystemUpdateCheckForUpdatesReadyData;
typedef struct _SettingsDaemonBackendsSystemUpdateUpdateReadyData SettingsDaemonBackendsSystemUpdateUpdateReadyData;
typedef struct _SettingsDaemonBackendsSystemUpdateGetCurrentStateReadyData SettingsDaemonBackendsSystemUpdateGetCurrentStateReadyData;
typedef struct _SettingsDaemonBackendsSystemUpdateGetUpdateDetailsReadyData SettingsDaemonBackendsSystemUpdateGetUpdateDetailsReadyData;
typedef struct _SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeReadyData SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeReadyData;

struct _SettingsDaemonBackendsSystemUpdate {
	GObject parent_instance;
	SettingsDaemonBackendsSystemUpdatePrivate * priv;
};

struct _SettingsDaemonBackendsSystemUpdateClass {
	GObjectClass parent_class;
};

struct _SettingsDaemonPkUtilsCurrentState {
	SettingsDaemonPkUtilsState state;
	gchar* status;
	guint percentage;
	guint64 download_size_remaining;
};

struct _SettingsDaemonBackendsSystemUpdateUpdateDetails {
	gchar** packages;
	gint packages_length1;
	guint64 size;
	PkInfoEnum* info;
	gint info_length1;
};

struct _SettingsDaemonBackendsSystemUpdatePrivate {
	SettingsDaemonPkUtilsCurrentState current_state;
	SettingsDaemonBackendsSystemUpdateUpdateDetails update_details;
	PkTask* task;
	PkPackageSack* available_updates;
	GCancellable* cancellable;
};

struct _SettingsDaemonBackendsSystemUpdateCheckForUpdatesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SettingsDaemonBackendsSystemUpdate* self;
	gboolean force;
	gboolean notify;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SettingsDaemonPkUtilsCurrentState _tmp3_;
	SettingsDaemonPkUtilsCurrentState _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp5__length1;
	gint __tmp5__size_;
	gboolean prepared;
	GError* e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	PkTask* _tmp10_;
	PkResults* _tmp11_;
	PkResults* _tmp12_;
	GError* _vala1_e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	PkResults* _tmp15_;
	PkTask* _tmp16_;
	PkResults* _tmp17_;
	PkPackageSack* _tmp18_;
	GSettings* _tmp19_;
	GDateTime* _tmp20_;
	GDateTime* _tmp21_;
	gboolean _tmp22_;
	PkPackageSack* _tmp23_;
	PkPackageSack* _tmp24_;
	gchar** package_names;
	gchar** _tmp25_;
	gint package_names_length1;
	gint _package_names_size_;
	PkInfoEnum* package_info;
	PkInfoEnum* _tmp26_;
	gint package_info_length1;
	gint _package_info_size_;
	gchar** package_ids;
	gchar** _tmp27_;
	gint package_ids_length1;
	gint _package_ids_size_;
	gboolean security_updates;
	PkPackageSack* _tmp28_;
	GPtrArray* _tmp29_;
	GPtrArray* package_collection;
	guint package_index;
	PkPackage* package;
	PkPackage* _tmp30_;
	PkPackage* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	PkPackage* _tmp34_;
	PkPackage* _tmp35_;
	PkPackage* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	guint64 package_total_size;
	PkResults* results;
	PkTask* _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	PkResults* _tmp41_;
	GPtrArray* details;
	PkResults* _tmp42_;
	GPtrArray* _tmp43_;
	GPtrArray* _tmp44_;
	GPtrArray* detail_collection;
	guint detail_index;
	PkDetails* detail;
	PkDetails* _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	gchar** _tmp47_;
	gint _tmp47__length1;
	PkInfoEnum* _tmp48_;
	gint _tmp48__length1;
	PkInfoEnum* _tmp49_;
	gint _tmp49__length1;
	SettingsDaemonBackendsSystemUpdateUpdateDetails _tmp50_;
	gboolean metered_network;
	GNetworkMonitor* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	gboolean auto_updates;
	GSettings* _tmp54_;
	gboolean _tmp55_;
	gboolean _tmp56_;
	gboolean _tmp57_;
	gboolean _tmp58_;
	GNotification* notification;
	GNotification* _tmp59_;
	GNotification* _tmp60_;
	GNotification* _tmp61_;
	GNotification* _tmp62_;
	GThemedIcon* _tmp63_;
	GThemedIcon* _tmp64_;
	GNotification* _tmp65_;
	GNotification* _tmp66_;
	GNotification* _tmp67_;
	GThemedIcon* _tmp68_;
	GThemedIcon* _tmp69_;
	GApplication* _tmp70_;
	GNotification* _tmp71_;
	GError* _vala2_e;
	GError* _tmp72_;
	const gchar* _tmp73_;
	GError* _inner_error0_;
};

struct _SettingsDaemonBackendsSystemUpdateUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SettingsDaemonBackendsSystemUpdate* self;
	SettingsDaemonPkUtilsCurrentState _tmp0_;
	GCancellable* _tmp1_;
	PkResults* results;
	PkTask* _tmp2_;
	PkPackageSack* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GCancellable* _tmp7_;
	PkResults* _tmp8_;
	PkResults* _tmp9_;
	PkResults* _tmp10_;
	GNotification* notification;
	GNotification* _tmp11_;
	GNotification* _tmp12_;
	GNotification* _tmp13_;
	GThemedIcon* _tmp14_;
	GThemedIcon* _tmp15_;
	GNotification* _tmp16_;
	GApplication* _tmp17_;
	GNotification* _tmp18_;
	GError* e;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError* _inner_error0_;
};

struct _SettingsDaemonBackendsSystemUpdateGetCurrentStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SettingsDaemonBackendsSystemUpdate* self;
	SettingsDaemonPkUtilsCurrentState result;
	SettingsDaemonPkUtilsCurrentState _tmp0_;
	SettingsDaemonPkUtilsCurrentState _tmp1_;
	SettingsDaemonPkUtilsCurrentState _tmp2_;
};

struct _SettingsDaemonBackendsSystemUpdateGetUpdateDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SettingsDaemonBackendsSystemUpdate* self;
	SettingsDaemonBackendsSystemUpdateUpdateDetails result;
	SettingsDaemonBackendsSystemUpdateUpdateDetails _tmp0_;
	SettingsDaemonBackendsSystemUpdateUpdateDetails _tmp1_;
	SettingsDaemonBackendsSystemUpdateUpdateDetails _tmp2_;
};

struct _SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SettingsDaemonBackendsSystemUpdate* self;
	gint64 result;
	GSettings* _tmp0_;
};

struct _SettingsDaemonBackendsSystemUpdateCheckForUpdatesReadyData {
	GDBusMethodInvocation* _invocation_;
	gboolean force;
	gboolean notify;
};

struct _SettingsDaemonBackendsSystemUpdateUpdateReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _SettingsDaemonBackendsSystemUpdateGetCurrentStateReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _SettingsDaemonBackendsSystemUpdateGetUpdateDetailsReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeReadyData {
	GDBusMethodInvocation* _invocation_;
};

static gint SettingsDaemonBackendsSystemUpdate_private_offset;
static gpointer settings_daemon_backends_system_update_parent_class = NULL;
static GSettings* settings_daemon_backends_system_update_settings;
static GSettings* settings_daemon_backends_system_update_settings = NULL;

VALA_EXTERN GType settings_daemon_backends_system_update_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsDaemonBackendsSystemUpdate, g_object_unref)
VALA_EXTERN guint settings_daemon_backends_system_update_register_object (void* object,
                                                              GDBusConnection* connection,
                                                              const gchar* path,
                                                              GError** error);
VALA_EXTERN GType settings_daemon_pk_utils_current_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType settings_daemon_pk_utils_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SettingsDaemonPkUtilsCurrentState* settings_daemon_pk_utils_current_state_dup (const SettingsDaemonPkUtilsCurrentState* self);
VALA_EXTERN void settings_daemon_pk_utils_current_state_free (SettingsDaemonPkUtilsCurrentState* self);
VALA_EXTERN void settings_daemon_pk_utils_current_state_copy (const SettingsDaemonPkUtilsCurrentState* self,
                                                  SettingsDaemonPkUtilsCurrentState* dest);
VALA_EXTERN void settings_daemon_pk_utils_current_state_destroy (SettingsDaemonPkUtilsCurrentState* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SettingsDaemonPkUtilsCurrentState, settings_daemon_pk_utils_current_state_destroy)
VALA_EXTERN GType settings_daemon_backends_system_update_update_details_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SettingsDaemonBackendsSystemUpdateUpdateDetails* settings_daemon_backends_system_update_update_details_dup (const SettingsDaemonBackendsSystemUpdateUpdateDetails* self);
VALA_EXTERN void settings_daemon_backends_system_update_update_details_free (SettingsDaemonBackendsSystemUpdateUpdateDetails* self);
VALA_EXTERN void settings_daemon_backends_system_update_update_details_copy (const SettingsDaemonBackendsSystemUpdateUpdateDetails* self,
                                                                 SettingsDaemonBackendsSystemUpdateUpdateDetails* dest);
VALA_EXTERN void settings_daemon_backends_system_update_update_details_destroy (SettingsDaemonBackendsSystemUpdateUpdateDetails* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (SettingsDaemonBackendsSystemUpdateUpdateDetails, settings_daemon_backends_system_update_update_details_destroy)
static void settings_daemon_backends_system_update_check_for_updates_data_free (gpointer _data);
VALA_EXTERN void settings_daemon_backends_system_update_check_for_updates (SettingsDaemonBackendsSystemUpdate* self,
                                                               gboolean force,
                                                               gboolean notify,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
VALA_EXTERN void settings_daemon_backends_system_update_check_for_updates_finish (SettingsDaemonBackendsSystemUpdate* self,
                                                                      GAsyncResult* _res_,
                                                                      GError** error);
static gboolean settings_daemon_backends_system_update_check_for_updates_co (SettingsDaemonBackendsSystemUpdateCheckForUpdatesData* _data_);
VALA_EXTERN gboolean settings_daemon_utils_is_running_in_demo_mode (void);
static void settings_daemon_backends_system_update_update_state (SettingsDaemonBackendsSystemUpdate* self,
                                                          SettingsDaemonPkUtilsState state,
                                                          const gchar* message,
                                                          guint percentage,
                                                          guint64 download_size_remaining);
static void settings_daemon_backends_system_update_progress_callback (SettingsDaemonBackendsSystemUpdate* self,
                                                               PkProgress* progress,
                                                               PkProgressType progress_type);
static void _settings_daemon_backends_system_update_progress_callback_pk_progress_callback (PkProgress* progress,
                                                                                     PkProgressType type,
                                                                                     gpointer self);
static void settings_daemon_backends_system_update_check_for_updates_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add12 (PkInfoEnum* * array,
                        gint* length,
                        gint* size,
                        PkInfoEnum value);
static void _vala_array_add13 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
static PkInfoEnum* _vala_array_dup6 (PkInfoEnum* self,
                              gssize length);
VALA_EXTERN void settings_daemon_backends_system_update_update (SettingsDaemonBackendsSystemUpdate* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN void settings_daemon_backends_system_update_update_finish (SettingsDaemonBackendsSystemUpdate* self,
                                                           GAsyncResult* _res_,
                                                           GError** error);
static void settings_daemon_backends_system_update_update_data_free (gpointer _data);
static gboolean settings_daemon_backends_system_update_update_co (SettingsDaemonBackendsSystemUpdateUpdateData* _data_);
static void settings_daemon_backends_system_update_update_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void settings_daemon_backends_system_update_send_error (SettingsDaemonBackendsSystemUpdate* self,
                                                        const gchar* message);
VALA_EXTERN void settings_daemon_backends_system_update_cancel (SettingsDaemonBackendsSystemUpdate* self,
                                                    GError** error);
VALA_EXTERN const gchar* settings_daemon_pk_utils_status_to_title (PkStatusEnum status);
static void settings_daemon_backends_system_update_get_current_state_data_free (gpointer _data);
VALA_EXTERN void settings_daemon_backends_system_update_get_current_state (SettingsDaemonBackendsSystemUpdate* self,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
VALA_EXTERN void settings_daemon_backends_system_update_get_current_state_finish (SettingsDaemonBackendsSystemUpdate* self,
                                                                      GAsyncResult* _res_,
                                                                      SettingsDaemonPkUtilsCurrentState* result,
                                                                      GError** error);
static gboolean settings_daemon_backends_system_update_get_current_state_co (SettingsDaemonBackendsSystemUpdateGetCurrentStateData* _data_);
static void settings_daemon_backends_system_update_get_update_details_data_free (gpointer _data);
VALA_EXTERN void settings_daemon_backends_system_update_get_update_details (SettingsDaemonBackendsSystemUpdate* self,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
VALA_EXTERN void settings_daemon_backends_system_update_get_update_details_finish (SettingsDaemonBackendsSystemUpdate* self,
                                                                       GAsyncResult* _res_,
                                                                       SettingsDaemonBackendsSystemUpdateUpdateDetails* result,
                                                                       GError** error);
static gboolean settings_daemon_backends_system_update_get_update_details_co (SettingsDaemonBackendsSystemUpdateGetUpdateDetailsData* _data_);
static void settings_daemon_backends_system_update_get_last_refresh_time_data_free (gpointer _data);
VALA_EXTERN void settings_daemon_backends_system_update_get_last_refresh_time (SettingsDaemonBackendsSystemUpdate* self,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
VALA_EXTERN gint64 settings_daemon_backends_system_update_get_last_refresh_time_finish (SettingsDaemonBackendsSystemUpdate* self,
                                                                            GAsyncResult* _res_,
                                                                            GError** error);
static gboolean settings_daemon_backends_system_update_get_last_refresh_time_co (SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeData* _data_);
VALA_EXTERN SettingsDaemonBackendsSystemUpdate* settings_daemon_backends_system_update_new (void);
VALA_EXTERN SettingsDaemonBackendsSystemUpdate* settings_daemon_backends_system_update_construct (GType object_type);
static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
static PkInfoEnum* _vala_array_dup8 (PkInfoEnum* self,
                              gssize length);
static GObject * settings_daemon_backends_system_update_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties);
static void settings_daemon_backends_system_update_finalize (GObject * obj);
static GType settings_daemon_backends_system_update_get_type_once (void);
static void _dbus_settings_daemon_backends_system_update_check_for_updates (SettingsDaemonBackendsSystemUpdate* self,
                                                                     GVariant* _parameters_,
                                                                     GDBusMethodInvocation* invocation);
static void _dbus_settings_daemon_backends_system_update_check_for_updates_ready (GObject * source_object,
                                                                           GAsyncResult * _res_,
                                                                           gpointer _user_data_);
static void _dbus_settings_daemon_backends_system_update_update (SettingsDaemonBackendsSystemUpdate* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void _dbus_settings_daemon_backends_system_update_update_ready (GObject * source_object,
                                                                GAsyncResult * _res_,
                                                                gpointer _user_data_);
static void _dbus_settings_daemon_backends_system_update_cancel (SettingsDaemonBackendsSystemUpdate* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void _dbus_settings_daemon_backends_system_update_get_current_state (SettingsDaemonBackendsSystemUpdate* self,
                                                                     GVariant* _parameters_,
                                                                     GDBusMethodInvocation* invocation);
static void _dbus_settings_daemon_backends_system_update_get_current_state_ready (GObject * source_object,
                                                                           GAsyncResult * _res_,
                                                                           gpointer _user_data_);
static void _dbus_settings_daemon_backends_system_update_get_update_details (SettingsDaemonBackendsSystemUpdate* self,
                                                                      GVariant* _parameters_,
                                                                      GDBusMethodInvocation* invocation);
static void _dbus_settings_daemon_backends_system_update_get_update_details_ready (GObject * source_object,
                                                                            GAsyncResult * _res_,
                                                                            gpointer _user_data_);
static void _dbus_settings_daemon_backends_system_update_get_last_refresh_time (SettingsDaemonBackendsSystemUpdate* self,
                                                                         GVariant* _parameters_,
                                                                         GDBusMethodInvocation* invocation);
static void _dbus_settings_daemon_backends_system_update_get_last_refresh_time_ready (GObject * source_object,
                                                                               GAsyncResult * _res_,
                                                                               gpointer _user_data_);
static void settings_daemon_backends_system_update_dbus_interface_method_call (GDBusConnection* connection,
                                                                        const gchar* sender,
                                                                        const gchar* object_path,
                                                                        const gchar* interface_name,
                                                                        const gchar* method_name,
                                                                        GVariant* parameters,
                                                                        GDBusMethodInvocation* invocation,
                                                                        gpointer user_data);
static GVariant* settings_daemon_backends_system_update_dbus_interface_get_property (GDBusConnection* connection,
                                                                              const gchar* sender,
                                                                              const gchar* object_path,
                                                                              const gchar* interface_name,
                                                                              const gchar* property_name,
                                                                              GError** error,
                                                                              gpointer user_data);
static gboolean settings_daemon_backends_system_update_dbus_interface_set_property (GDBusConnection* connection,
                                                                             const gchar* sender,
                                                                             const gchar* object_path,
                                                                             const gchar* interface_name,
                                                                             const gchar* property_name,
                                                                             GVariant* value,
                                                                             GError** error,
                                                                             gpointer user_data);
static void _dbus_settings_daemon_backends_system_update_state_changed (GObject* _sender,
                                                                 gpointer* _data);
static void _settings_daemon_backends_system_update_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _settings_daemon_backends_system_update_dbus_arg_info_check_for_updates_force = {-1, "force", "b", NULL};
static const GDBusArgInfo _settings_daemon_backends_system_update_dbus_arg_info_check_for_updates_notify = {-1, "notify", "b", NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_check_for_updates_in[] = {&_settings_daemon_backends_system_update_dbus_arg_info_check_for_updates_force, &_settings_daemon_backends_system_update_dbus_arg_info_check_for_updates_notify, NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_check_for_updates_out[] = {NULL};
static const GDBusMethodInfo _settings_daemon_backends_system_update_dbus_method_info_check_for_updates = {-1, "CheckForUpdates", (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_check_for_updates_in), (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_check_for_updates_out), NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_update_in[] = {NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_update_out[] = {NULL};
static const GDBusMethodInfo _settings_daemon_backends_system_update_dbus_method_info_update = {-1, "Update", (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_update_in), (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_update_out), NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_cancel_in[] = {NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_cancel_out[] = {NULL};
static const GDBusMethodInfo _settings_daemon_backends_system_update_dbus_method_info_cancel = {-1, "Cancel", (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_cancel_in), (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_cancel_out), NULL};
static const GDBusArgInfo _settings_daemon_backends_system_update_dbus_arg_info_get_current_state_result = {-1, "result", "(isut)", NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_get_current_state_in[] = {NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_get_current_state_out[] = {&_settings_daemon_backends_system_update_dbus_arg_info_get_current_state_result, NULL};
static const GDBusMethodInfo _settings_daemon_backends_system_update_dbus_method_info_get_current_state = {-1, "GetCurrentState", (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_get_current_state_in), (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_get_current_state_out), NULL};
static const GDBusArgInfo _settings_daemon_backends_system_update_dbus_arg_info_get_update_details_result = {-1, "result", "(astai)", NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_get_update_details_in[] = {NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_get_update_details_out[] = {&_settings_daemon_backends_system_update_dbus_arg_info_get_update_details_result, NULL};
static const GDBusMethodInfo _settings_daemon_backends_system_update_dbus_method_info_get_update_details = {-1, "GetUpdateDetails", (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_get_update_details_in), (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_get_update_details_out), NULL};
static const GDBusArgInfo _settings_daemon_backends_system_update_dbus_arg_info_get_last_refresh_time_result = {-1, "result", "x", NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_get_last_refresh_time_in[] = {NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_get_last_refresh_time_out[] = {&_settings_daemon_backends_system_update_dbus_arg_info_get_last_refresh_time_result, NULL};
static const GDBusMethodInfo _settings_daemon_backends_system_update_dbus_method_info_get_last_refresh_time = {-1, "GetLastRefreshTime", (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_get_last_refresh_time_in), (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_get_last_refresh_time_out), NULL};
static const GDBusMethodInfo * const _settings_daemon_backends_system_update_dbus_method_info[] = {&_settings_daemon_backends_system_update_dbus_method_info_check_for_updates, &_settings_daemon_backends_system_update_dbus_method_info_update, &_settings_daemon_backends_system_update_dbus_method_info_cancel, &_settings_daemon_backends_system_update_dbus_method_info_get_current_state, &_settings_daemon_backends_system_update_dbus_method_info_get_update_details, &_settings_daemon_backends_system_update_dbus_method_info_get_last_refresh_time, NULL};
static const GDBusArgInfo * const _settings_daemon_backends_system_update_dbus_arg_info_state_changed[] = {NULL};
static const GDBusSignalInfo _settings_daemon_backends_system_update_dbus_signal_info_state_changed = {-1, "StateChanged", (GDBusArgInfo **) (&_settings_daemon_backends_system_update_dbus_arg_info_state_changed), NULL};
static const GDBusSignalInfo * const _settings_daemon_backends_system_update_dbus_signal_info[] = {&_settings_daemon_backends_system_update_dbus_signal_info_state_changed, NULL};
static const GDBusPropertyInfo * const _settings_daemon_backends_system_update_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _settings_daemon_backends_system_update_dbus_interface_info = {-1, "io.elementary.settings_daemon.SystemUpdate", (GDBusMethodInfo **) (&_settings_daemon_backends_system_update_dbus_method_info), (GDBusSignalInfo **) (&_settings_daemon_backends_system_update_dbus_signal_info), (GDBusPropertyInfo **) (&_settings_daemon_backends_system_update_dbus_property_info), NULL};
static const GDBusInterfaceVTable _settings_daemon_backends_system_update_dbus_interface_vtable = {settings_daemon_backends_system_update_dbus_interface_method_call, settings_daemon_backends_system_update_dbus_interface_get_property, settings_daemon_backends_system_update_dbus_interface_set_property};

static inline gpointer
settings_daemon_backends_system_update_get_instance_private (SettingsDaemonBackendsSystemUpdate* self)
{
	return G_STRUCT_MEMBER_P (self, SettingsDaemonBackendsSystemUpdate_private_offset);
}

static void
settings_daemon_backends_system_update_check_for_updates_data_free (gpointer _data)
{
	SettingsDaemonBackendsSystemUpdateCheckForUpdatesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SettingsDaemonBackendsSystemUpdateCheckForUpdatesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
settings_daemon_backends_system_update_check_for_updates (SettingsDaemonBackendsSystemUpdate* self,
                                                          gboolean force,
                                                          gboolean notify,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	SettingsDaemonBackendsSystemUpdateCheckForUpdatesData* _data_;
	SettingsDaemonBackendsSystemUpdate* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SettingsDaemonBackendsSystemUpdateCheckForUpdatesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, settings_daemon_backends_system_update_check_for_updates_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->force = force;
	_data_->notify = notify;
	settings_daemon_backends_system_update_check_for_updates_co (_data_);
}

void
settings_daemon_backends_system_update_check_for_updates_finish (SettingsDaemonBackendsSystemUpdate* self,
                                                                 GAsyncResult* _res_,
                                                                 GError** error)
{
	SettingsDaemonBackendsSystemUpdateCheckForUpdatesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
_settings_daemon_backends_system_update_progress_callback_pk_progress_callback (PkProgress* progress,
                                                                                PkProgressType type,
                                                                                gpointer self)
{
	settings_daemon_backends_system_update_progress_callback ((SettingsDaemonBackendsSystemUpdate*) self, progress, type);
}

static void
settings_daemon_backends_system_update_check_for_updates_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_)
{
	SettingsDaemonBackendsSystemUpdateCheckForUpdatesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	settings_daemon_backends_system_update_check_for_updates_co (_data_);
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add12 (PkInfoEnum* * array,
                   gint* length,
                   gint* size,
                   PkInfoEnum value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (PkInfoEnum, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add13 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static PkInfoEnum*
_vala_array_dup6 (PkInfoEnum* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (PkInfoEnum));
	}
	return NULL;
}

static gboolean
settings_daemon_backends_system_update_check_for_updates_co (SettingsDaemonBackendsSystemUpdateCheckForUpdatesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (settings_daemon_utils_is_running_in_demo_mode ()) {
		_data_->_tmp0_ = !_data_->force;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->current_state;
	if (_data_->_tmp3_.state != SETTINGS_DAEMON_PK_UTILS_STATE_UP_TO_DATE) {
		_data_->_tmp4_ = _data_->self->priv->current_state;
		_data_->_tmp2_ = _data_->_tmp4_.state != SETTINGS_DAEMON_PK_UTILS_STATE_AVAILABLE;
	} else {
		_data_->_tmp2_ = FALSE;
	}
	if (_data_->_tmp2_) {
		_data_->_tmp1_ = !_data_->force;
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (_data_->_tmp1_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	settings_daemon_backends_system_update_update_state (_data_->self, SETTINGS_DAEMON_PK_UTILS_STATE_CHECKING, "", (guint) 0, (guint64) 0);
	{
		_data_->_tmp7_ = _data_->_tmp6_ = pk_offline_get_prepared_ids (&_data_->_inner_error0_);
		_data_->_tmp5_ = _data_->_tmp7_;
		_data_->_tmp5__length1 = _vala_array_length (_data_->_tmp6_);
		_data_->__tmp5__size_ = _data_->_tmp5__length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->prepared = _data_->_tmp5__length1 > 0;
		if (_data_->prepared) {
			settings_daemon_backends_system_update_update_state (_data_->self, SETTINGS_DAEMON_PK_UTILS_STATE_RESTART_REQUIRED, "", (guint) 0, (guint64) 0);
			_data_->_tmp5_ = (_vala_array_free (_data_->_tmp5_, _data_->_tmp5__length1, (GDestroyNotify) g_free), NULL);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp5_ = (_vala_array_free (_data_->_tmp5_, _data_->_tmp5__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning ("SystemUpdate.vala:82: Failed to get offline prepared ids: %s", _data_->_tmp9_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		_data_->_tmp10_ = _data_->self->priv->task;
		_data_->_state_ = 1;
		pk_task_refresh_cache_async (_data_->_tmp10_, _data_->force, NULL, _settings_daemon_backends_system_update_progress_callback_pk_progress_callback, _data_->self, settings_daemon_backends_system_update_check_for_updates_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp11_ = pk_task_generic_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_g_object_unref0 (_data_->_tmp12_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->_vala1_e;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("SystemUpdate.vala:88: Failed to refresh cache: %s", _data_->_tmp14_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		_data_->_tmp16_ = _data_->self->priv->task;
		_data_->_state_ = 2;
		pk_task_get_updates_async (_data_->_tmp16_, (PkBitfield) PK_FILTER_ENUM_NONE, NULL, _settings_daemon_backends_system_update_progress_callback_pk_progress_callback, _data_->self, settings_daemon_backends_system_update_check_for_updates_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp17_ = pk_task_generic_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp15_ = _data_->_tmp17_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_data_->_tmp18_ = pk_results_get_package_sack (_data_->_tmp15_);
		_g_object_unref0 (_data_->self->priv->available_updates);
		_data_->self->priv->available_updates = _data_->_tmp18_;
		_data_->_tmp19_ = settings_daemon_backends_system_update_settings;
		_data_->_tmp20_ = g_date_time_new_now_utc ();
		_data_->_tmp21_ = _data_->_tmp20_;
		g_settings_set_int64 (_data_->_tmp19_, "last-refresh-time", g_date_time_to_unix (_data_->_tmp21_));
		_g_date_time_unref0 (_data_->_tmp21_);
		_data_->_tmp23_ = _data_->self->priv->available_updates;
		if (_data_->_tmp23_ == NULL) {
			_data_->_tmp22_ = TRUE;
		} else {
			_data_->_tmp24_ = _data_->self->priv->available_updates;
			_data_->_tmp22_ = pk_package_sack_get_size (_data_->_tmp24_) == ((guint) 0);
		}
		if (_data_->_tmp22_) {
			settings_daemon_backends_system_update_update_state (_data_->self, SETTINGS_DAEMON_PK_UTILS_STATE_UP_TO_DATE, "", (guint) 0, (guint64) 0);
			_g_object_unref0 (_data_->_tmp15_);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp25_ = g_new0 (gchar*, 0 + 1);
		_data_->package_names = _data_->_tmp25_;
		_data_->package_names_length1 = 0;
		_data_->_package_names_size_ = _data_->package_names_length1;
		_data_->_tmp26_ = g_new0 (PkInfoEnum, 0);
		_data_->package_info = _data_->_tmp26_;
		_data_->package_info_length1 = 0;
		_data_->_package_info_size_ = _data_->package_info_length1;
		_data_->_tmp27_ = g_new0 (gchar*, 0 + 1);
		_data_->package_ids = _data_->_tmp27_;
		_data_->package_ids_length1 = 0;
		_data_->_package_ids_size_ = _data_->package_ids_length1;
		_data_->security_updates = FALSE;
		_data_->_tmp28_ = _data_->self->priv->available_updates;
		_data_->_tmp29_ = pk_package_sack_get_array (_data_->_tmp28_);
		{
			_data_->package_collection = _data_->_tmp29_;
			for (_data_->package_index = 0; _data_->package_index < _data_->package_collection->len; _data_->package_index = _data_->package_index + 1) {
				_data_->package = (PkPackage*) g_ptr_array_index (_data_->package_collection, _data_->package_index);
				{
					_data_->_tmp30_ = _data_->package;
					if (pk_package_get_info (_data_->_tmp30_) == PK_INFO_ENUM_BLOCKED) {
						continue;
					}
					_data_->_tmp31_ = _data_->package;
					_data_->_tmp32_ = pk_package_get_name (_data_->_tmp31_);
					_data_->_tmp33_ = g_strdup (_data_->_tmp32_);
					_vala_array_add11 (&_data_->package_names, &_data_->package_names_length1, &_data_->_package_names_size_, _data_->_tmp33_);
					_data_->_tmp34_ = _data_->package;
					_vala_array_add12 (&_data_->package_info, &_data_->package_info_length1, &_data_->_package_info_size_, pk_package_get_info (_data_->_tmp34_));
					_data_->_tmp35_ = _data_->package;
					if (pk_package_get_info (_data_->_tmp35_) == PK_INFO_ENUM_SECURITY) {
						_data_->security_updates = TRUE;
					}
					_data_->_tmp36_ = _data_->package;
					_data_->_tmp37_ = pk_package_get_id (_data_->_tmp36_);
					_data_->_tmp38_ = g_strdup (_data_->_tmp37_);
					_vala_array_add13 (&_data_->package_ids, &_data_->package_ids_length1, &_data_->_package_ids_size_, _data_->_tmp38_);
				}
			}
			_g_ptr_array_unref0 (_data_->package_collection);
		}
		_data_->package_total_size = (guint64) 0;
		_data_->_tmp39_ = _data_->self->priv->task;
		_data_->_tmp40_ = _data_->package_ids;
		_data_->_tmp40__length1 = _data_->package_ids_length1;
		_data_->_state_ = 3;
		pk_task_get_details_async (_data_->_tmp39_, _data_->_tmp40_, NULL, _settings_daemon_backends_system_update_progress_callback_pk_progress_callback, _data_->self, settings_daemon_backends_system_update_check_for_updates_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp41_ = pk_task_generic_finish (_data_->_tmp39_, _data_->_res_, &_data_->_inner_error0_);
		_data_->results = _data_->_tmp41_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_data_->package_ids = (_vala_array_free (_data_->package_ids, _data_->package_ids_length1, (GDestroyNotify) g_free), NULL);
			_data_->package_info = (g_free (_data_->package_info), NULL);
			_data_->package_names = (_vala_array_free (_data_->package_names, _data_->package_names_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->_tmp15_);
			goto __catch2_g_error;
		}
		_data_->_tmp42_ = _data_->results;
		_data_->_tmp43_ = pk_results_get_details_array (_data_->_tmp42_);
		_data_->details = _data_->_tmp43_;
		_data_->_tmp44_ = _data_->details;
		{
			_data_->detail_collection = _data_->_tmp44_;
			for (_data_->detail_index = 0; _data_->detail_index < _data_->detail_collection->len; _data_->detail_index = _data_->detail_index + 1) {
				_data_->detail = (PkDetails*) g_ptr_array_index (_data_->detail_collection, _data_->detail_index);
				{
					_data_->_tmp45_ = _data_->detail;
					_data_->package_total_size += pk_details_get_size (_data_->_tmp45_);
				}
			}
		}
		_data_->_tmp46_ = _data_->package_names;
		_data_->_tmp46__length1 = _data_->package_names_length1;
		_data_->_tmp47_ = (_data_->_tmp46_ != NULL) ? _vala_array_dup5 (_data_->_tmp46_, _data_->_tmp46__length1) : _data_->_tmp46_;
		_data_->_tmp47__length1 = _data_->_tmp46__length1;
		_data_->_tmp48_ = _data_->package_info;
		_data_->_tmp48__length1 = _data_->package_info_length1;
		_data_->_tmp49_ = (_data_->_tmp48_ != NULL) ? _vala_array_dup6 (_data_->_tmp48_, _data_->_tmp48__length1) : _data_->_tmp48_;
		_data_->_tmp49__length1 = _data_->_tmp48__length1;
		memset (&_data_->_tmp50_, 0, sizeof (SettingsDaemonBackendsSystemUpdateUpdateDetails));
		_data_->_tmp50_.packages = (_vala_array_free (_data_->_tmp50_.packages, _data_->_tmp50_.packages_length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp50_.packages = _data_->_tmp47_;
		_data_->_tmp50_.packages_length1 = _data_->_tmp47__length1;
		_data_->_tmp50_.size = _data_->package_total_size;
		_data_->_tmp50_.info = (g_free (_data_->_tmp50_.info), NULL);
		_data_->_tmp50_.info = _data_->_tmp49_;
		_data_->_tmp50_.info_length1 = _data_->_tmp49__length1;
		settings_daemon_backends_system_update_update_details_destroy (&_data_->self->priv->update_details);
		_data_->self->priv->update_details = _data_->_tmp50_;
		settings_daemon_backends_system_update_update_state (_data_->self, SETTINGS_DAEMON_PK_UTILS_STATE_AVAILABLE, "", (guint) 0, (guint64) 0);
		_data_->_tmp51_ = g_network_monitor_get_default ();
		_data_->_tmp52_ = g_network_monitor_get_network_metered (_data_->_tmp51_);
		_data_->_tmp53_ = _data_->_tmp52_;
		_data_->metered_network = _data_->_tmp53_;
		_data_->_tmp54_ = settings_daemon_backends_system_update_settings;
		_data_->auto_updates = g_settings_get_boolean (_data_->_tmp54_, "automatic-updates");
		if (!_data_->force) {
			_data_->_tmp56_ = !_data_->metered_network;
		} else {
			_data_->_tmp56_ = FALSE;
		}
		if (_data_->_tmp56_) {
			_data_->_tmp55_ = _data_->auto_updates;
		} else {
			_data_->_tmp55_ = FALSE;
		}
		if (_data_->_tmp55_) {
			settings_daemon_backends_system_update_update (_data_->self, NULL, NULL);
			_g_ptr_array_unref0 (_data_->details);
			_g_object_unref0 (_data_->results);
			_data_->package_ids = (_vala_array_free (_data_->package_ids, _data_->package_ids_length1, (GDestroyNotify) g_free), NULL);
			_data_->package_info = (g_free (_data_->package_info), NULL);
			_data_->package_names = (_vala_array_free (_data_->package_names, _data_->package_names_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->_tmp15_);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (_data_->notify) {
			_data_->_tmp57_ = TRUE;
		} else {
			if (_data_->metered_network) {
				_data_->_tmp58_ = _data_->auto_updates;
			} else {
				_data_->_tmp58_ = FALSE;
			}
			_data_->_tmp57_ = _data_->_tmp58_;
		}
		if (_data_->_tmp57_) {
			_data_->_tmp59_ = g_notification_new (_ ("Update available"));
			_data_->notification = _data_->_tmp59_;
			_data_->_tmp60_ = _data_->notification;
			g_notification_set_default_action (_data_->_tmp60_, SETTINGS_DAEMON_APPLICATION_ACTION_PREFIX SETTINGS_DAEMON_APPLICATION_SHOW_UPDATES_ACTION);
			if (_data_->security_updates) {
				_data_->_tmp61_ = _data_->notification;
				g_notification_set_body (_data_->_tmp61_, _ ("A system security update is available"));
				_data_->_tmp62_ = _data_->notification;
				_data_->_tmp63_ = (GThemedIcon*) g_themed_icon_new ("software-update-urgent");
				_data_->_tmp64_ = _data_->_tmp63_;
				g_notification_set_icon (_data_->_tmp62_, (GIcon*) _data_->_tmp64_);
				_g_object_unref0 (_data_->_tmp64_);
				_data_->_tmp65_ = _data_->notification;
				g_notification_set_priority (_data_->_tmp65_, G_NOTIFICATION_PRIORITY_HIGH);
			} else {
				_data_->_tmp66_ = _data_->notification;
				g_notification_set_body (_data_->_tmp66_, _ ("A system update is available"));
				_data_->_tmp67_ = _data_->notification;
				_data_->_tmp68_ = (GThemedIcon*) g_themed_icon_new ("software-update-available");
				_data_->_tmp69_ = _data_->_tmp68_;
				g_notification_set_icon (_data_->_tmp67_, (GIcon*) _data_->_tmp69_);
				_g_object_unref0 (_data_->_tmp69_);
			}
			_data_->_tmp70_ = g_application_get_default ();
			_data_->_tmp71_ = _data_->notification;
			g_application_send_notification (_data_->_tmp70_, SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_NOTIFICATION_ID, _data_->_tmp71_);
			_g_object_unref0 (_data_->notification);
		}
		_g_ptr_array_unref0 (_data_->details);
		_g_object_unref0 (_data_->results);
		_data_->package_ids = (_vala_array_free (_data_->package_ids, _data_->package_ids_length1, (GDestroyNotify) g_free), NULL);
		_data_->package_info = (g_free (_data_->package_info), NULL);
		_data_->package_names = (_vala_array_free (_data_->package_names, _data_->package_names_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->_tmp15_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->_vala2_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp72_ = _data_->_vala2_e;
		_data_->_tmp73_ = _data_->_tmp72_->message;
		g_warning ("SystemUpdate.vala:160: Failed to get available updates: %s", _data_->_tmp73_);
		settings_daemon_backends_system_update_update_state (_data_->self, SETTINGS_DAEMON_PK_UTILS_STATE_UP_TO_DATE, "", (guint) 0, (guint64) 0);
		_g_error_free0 (_data_->_vala2_e);
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
settings_daemon_backends_system_update_update_data_free (gpointer _data)
{
	SettingsDaemonBackendsSystemUpdateUpdateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SettingsDaemonBackendsSystemUpdateUpdateData, _data_);
}

void
settings_daemon_backends_system_update_update (SettingsDaemonBackendsSystemUpdate* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	SettingsDaemonBackendsSystemUpdateUpdateData* _data_;
	SettingsDaemonBackendsSystemUpdate* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SettingsDaemonBackendsSystemUpdateUpdateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, settings_daemon_backends_system_update_update_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	settings_daemon_backends_system_update_update_co (_data_);
}

void
settings_daemon_backends_system_update_update_finish (SettingsDaemonBackendsSystemUpdate* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	SettingsDaemonBackendsSystemUpdateUpdateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
settings_daemon_backends_system_update_update_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	SettingsDaemonBackendsSystemUpdateUpdateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	settings_daemon_backends_system_update_update_co (_data_);
}

static gboolean
settings_daemon_backends_system_update_update_co (SettingsDaemonBackendsSystemUpdateUpdateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->current_state;
	if (_data_->_tmp0_.state != SETTINGS_DAEMON_PK_UTILS_STATE_AVAILABLE) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->cancellable;
	g_cancellable_reset (_data_->_tmp1_);
	settings_daemon_backends_system_update_update_state (_data_->self, SETTINGS_DAEMON_PK_UTILS_STATE_DOWNLOADING, "", (guint) 0, (guint64) 0);
	{
		_data_->_tmp2_ = _data_->self->priv->task;
		_data_->_tmp3_ = _data_->self->priv->available_updates;
		_data_->_tmp5_ = _data_->_tmp4_ = pk_package_sack_get_ids (_data_->_tmp3_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp6__length1 = _vala_array_length (_data_->_tmp4_);
		_data_->_tmp7_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		pk_task_update_packages_async (_data_->_tmp2_, _data_->_tmp6_, _data_->_tmp7_, _settings_daemon_backends_system_update_progress_callback_pk_progress_callback, _data_->self, settings_daemon_backends_system_update_update_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = pk_task_generic_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp6_ = (_vala_array_free (_data_->_tmp6_, _data_->_tmp6__length1, (GDestroyNotify) g_free), NULL);
		_data_->results = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp10_ = _data_->results;
		if (pk_results_get_exit_code (_data_->_tmp10_) == PK_EXIT_ENUM_CANCELLED) {
			g_debug ("SystemUpdate.vala:178: Updates were cancelled");
			settings_daemon_backends_system_update_check_for_updates (_data_->self, TRUE, FALSE, NULL, NULL);
			_g_object_unref0 (_data_->results);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp11_ = g_notification_new (_ ("Restart required"));
		_data_->notification = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->notification;
		g_notification_set_body (_data_->_tmp12_, _ ("Please restart your system to finalize updates"));
		_data_->_tmp13_ = _data_->notification;
		_data_->_tmp14_ = (GThemedIcon*) g_themed_icon_new ("system-reboot");
		_data_->_tmp15_ = _data_->_tmp14_;
		g_notification_set_icon (_data_->_tmp13_, (GIcon*) _data_->_tmp15_);
		_g_object_unref0 (_data_->_tmp15_);
		_data_->_tmp16_ = _data_->notification;
		g_notification_set_default_action (_data_->_tmp16_, SETTINGS_DAEMON_APPLICATION_ACTION_PREFIX SETTINGS_DAEMON_APPLICATION_SHOW_UPDATES_ACTION);
		_data_->_tmp17_ = g_application_get_default ();
		_data_->_tmp18_ = _data_->notification;
		g_application_send_notification (_data_->_tmp17_, SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_NOTIFICATION_ID, _data_->_tmp18_);
		settings_daemon_backends_system_update_update_state (_data_->self, SETTINGS_DAEMON_PK_UTILS_STATE_RESTART_REQUIRED, "", (guint) 0, (guint64) 0);
		_g_object_unref0 (_data_->notification);
		_g_object_unref0 (_data_->results);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp19_ = _data_->e;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_critical ("SystemUpdate.vala:192: Failed to download available updates: %s", _data_->_tmp20_);
		_data_->_tmp21_ = _data_->e;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		settings_daemon_backends_system_update_send_error (_data_->self, _data_->_tmp22_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
settings_daemon_backends_system_update_cancel (SettingsDaemonBackendsSystemUpdate* self,
                                               GError** error)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
}

static void
settings_daemon_backends_system_update_progress_callback (SettingsDaemonBackendsSystemUpdate* self,
                                                          PkProgress* progress,
                                                          PkProgressType progress_type)
{
	SettingsDaemonPkUtilsCurrentState _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	guint64 _tmp6_;
	guint64 _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (progress != NULL);
	_tmp0_ = self->priv->current_state;
	_tmp1_ = pk_progress_get_status (progress);
	_tmp2_ = _tmp1_;
	_tmp3_ = settings_daemon_pk_utils_status_to_title (_tmp2_);
	_tmp4_ = pk_progress_get_percentage (progress);
	_tmp5_ = _tmp4_;
	_tmp6_ = pk_progress_get_download_size_remaining (progress);
	_tmp7_ = _tmp6_;
	settings_daemon_backends_system_update_update_state (self, _tmp0_.state, _tmp3_, (guint) _tmp5_, _tmp7_);
}

static void
settings_daemon_backends_system_update_send_error (SettingsDaemonBackendsSystemUpdate* self,
                                                   const gchar* message)
{
	GNotification* notification = NULL;
	GNotification* _tmp0_;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	GApplication* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = g_notification_new (_ ("System updates couldn't be installed"));
	notification = _tmp0_;
	g_notification_set_body (notification, _ ("An error occurred while trying to update your system"));
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
	_tmp2_ = _tmp1_;
	g_notification_set_icon (notification, (GIcon*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	g_notification_set_default_action (notification, SETTINGS_DAEMON_APPLICATION_ACTION_PREFIX SETTINGS_DAEMON_APPLICATION_SHOW_UPDATES_ACTION);
	_tmp3_ = g_application_get_default ();
	g_application_send_notification (_tmp3_, SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_NOTIFICATION_ID, notification);
	settings_daemon_backends_system_update_update_state (self, SETTINGS_DAEMON_PK_UTILS_STATE_ERROR, message, (guint) 0, (guint64) 0);
	_g_object_unref0 (notification);
}

static void
settings_daemon_backends_system_update_update_state (SettingsDaemonBackendsSystemUpdate* self,
                                                     SettingsDaemonPkUtilsState state,
                                                     const gchar* message,
                                                     guint percentage,
                                                     guint64 download_size_remaining)
{
	gchar* _tmp0_;
	SettingsDaemonPkUtilsCurrentState _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = g_strdup (message);
	_tmp1_.state = state;
	_g_free0 (_tmp1_.status);
	_tmp1_.status = _tmp0_;
	_tmp1_.percentage = percentage;
	_tmp1_.download_size_remaining = download_size_remaining;
	settings_daemon_pk_utils_current_state_destroy (&self->priv->current_state);
	self->priv->current_state = _tmp1_;
	g_signal_emit (self, settings_daemon_backends_system_update_signals[SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_STATE_CHANGED_SIGNAL], 0);
}

static void
settings_daemon_backends_system_update_get_current_state_data_free (gpointer _data)
{
	SettingsDaemonBackendsSystemUpdateGetCurrentStateData* _data_;
	_data_ = _data;
	settings_daemon_pk_utils_current_state_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SettingsDaemonBackendsSystemUpdateGetCurrentStateData, _data_);
}

void
settings_daemon_backends_system_update_get_current_state (SettingsDaemonBackendsSystemUpdate* self,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_)
{
	SettingsDaemonBackendsSystemUpdateGetCurrentStateData* _data_;
	SettingsDaemonBackendsSystemUpdate* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SettingsDaemonBackendsSystemUpdateGetCurrentStateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, settings_daemon_backends_system_update_get_current_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	settings_daemon_backends_system_update_get_current_state_co (_data_);
}

void
settings_daemon_backends_system_update_get_current_state_finish (SettingsDaemonBackendsSystemUpdate* self,
                                                                 GAsyncResult* _res_,
                                                                 SettingsDaemonPkUtilsCurrentState* result,
                                                                 GError** error)
{
	SettingsDaemonBackendsSystemUpdateGetCurrentStateData* _data_;
	SettingsDaemonPkUtilsCurrentState _tmp0_;
	SettingsDaemonPkUtilsCurrentState _tmp1_ = {0};
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	_tmp0_ = _data_->result;
	settings_daemon_pk_utils_current_state_copy (&_tmp0_, &_tmp1_);
	*result = _tmp1_;
}

static gboolean
settings_daemon_backends_system_update_get_current_state_co (SettingsDaemonBackendsSystemUpdateGetCurrentStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->current_state;
	_data_->_tmp1_ = _data_->_tmp0_;
	memset (&_data_->_tmp2_, 0, sizeof (SettingsDaemonPkUtilsCurrentState));
	settings_daemon_pk_utils_current_state_copy (&_data_->_tmp1_, &_data_->_tmp2_);
	_data_->result = _data_->_tmp2_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
settings_daemon_backends_system_update_get_update_details_data_free (gpointer _data)
{
	SettingsDaemonBackendsSystemUpdateGetUpdateDetailsData* _data_;
	_data_ = _data;
	settings_daemon_backends_system_update_update_details_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SettingsDaemonBackendsSystemUpdateGetUpdateDetailsData, _data_);
}

void
settings_daemon_backends_system_update_get_update_details (SettingsDaemonBackendsSystemUpdate* self,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	SettingsDaemonBackendsSystemUpdateGetUpdateDetailsData* _data_;
	SettingsDaemonBackendsSystemUpdate* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SettingsDaemonBackendsSystemUpdateGetUpdateDetailsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, settings_daemon_backends_system_update_get_update_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	settings_daemon_backends_system_update_get_update_details_co (_data_);
}

void
settings_daemon_backends_system_update_get_update_details_finish (SettingsDaemonBackendsSystemUpdate* self,
                                                                  GAsyncResult* _res_,
                                                                  SettingsDaemonBackendsSystemUpdateUpdateDetails* result,
                                                                  GError** error)
{
	SettingsDaemonBackendsSystemUpdateGetUpdateDetailsData* _data_;
	SettingsDaemonBackendsSystemUpdateUpdateDetails _tmp0_;
	SettingsDaemonBackendsSystemUpdateUpdateDetails _tmp1_ = {0};
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	_tmp0_ = _data_->result;
	settings_daemon_backends_system_update_update_details_copy (&_tmp0_, &_tmp1_);
	*result = _tmp1_;
}

static gboolean
settings_daemon_backends_system_update_get_update_details_co (SettingsDaemonBackendsSystemUpdateGetUpdateDetailsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->update_details;
	_data_->_tmp1_ = _data_->_tmp0_;
	memset (&_data_->_tmp2_, 0, sizeof (SettingsDaemonBackendsSystemUpdateUpdateDetails));
	settings_daemon_backends_system_update_update_details_copy (&_data_->_tmp1_, &_data_->_tmp2_);
	_data_->result = _data_->_tmp2_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
settings_daemon_backends_system_update_get_last_refresh_time_data_free (gpointer _data)
{
	SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeData, _data_);
}

void
settings_daemon_backends_system_update_get_last_refresh_time (SettingsDaemonBackendsSystemUpdate* self,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_)
{
	SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeData* _data_;
	SettingsDaemonBackendsSystemUpdate* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, settings_daemon_backends_system_update_get_last_refresh_time_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	settings_daemon_backends_system_update_get_last_refresh_time_co (_data_);
}

gint64
settings_daemon_backends_system_update_get_last_refresh_time_finish (SettingsDaemonBackendsSystemUpdate* self,
                                                                     GAsyncResult* _res_,
                                                                     GError** error)
{
	gint64 result;
	SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gint64 _tmp0_ = 0LL;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gboolean
settings_daemon_backends_system_update_get_last_refresh_time_co (SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = settings_daemon_backends_system_update_settings;
	_data_->result = g_settings_get_int64 (_data_->_tmp0_, "last-refresh-time");
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SettingsDaemonBackendsSystemUpdate*
settings_daemon_backends_system_update_construct (GType object_type)
{
	SettingsDaemonBackendsSystemUpdate * self = NULL;
	self = (SettingsDaemonBackendsSystemUpdate*) g_object_new (object_type, NULL);
	return self;
}

SettingsDaemonBackendsSystemUpdate*
settings_daemon_backends_system_update_new (void)
{
	return settings_daemon_backends_system_update_construct (SETTINGS_DAEMON_BACKENDS_TYPE_SYSTEM_UPDATE);
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static PkInfoEnum*
_vala_array_dup8 (PkInfoEnum* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (PkInfoEnum));
	}
	return NULL;
}

void
settings_daemon_backends_system_update_update_details_copy (const SettingsDaemonBackendsSystemUpdateUpdateDetails* self,
                                                            SettingsDaemonBackendsSystemUpdateUpdateDetails* dest)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	PkInfoEnum* _tmp2_;
	gint _tmp2__length1;
	PkInfoEnum* _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = (*self).packages;
	_tmp0__length1 = (*self).packages_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup7 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).packages = (_vala_array_free ((*dest).packages, (*dest).packages_length1, (GDestroyNotify) g_free), NULL);
	(*dest).packages = _tmp1_;
	(*dest).packages_length1 = _tmp1__length1;
	(*dest).size = (*self).size;
	_tmp2_ = (*self).info;
	_tmp2__length1 = (*self).info_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup8 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	(*dest).info = (g_free ((*dest).info), NULL);
	(*dest).info = _tmp3_;
	(*dest).info_length1 = _tmp3__length1;
}

void
settings_daemon_backends_system_update_update_details_destroy (SettingsDaemonBackendsSystemUpdateUpdateDetails* self)
{
	(*self).packages = (_vala_array_free ((*self).packages, (*self).packages_length1, (GDestroyNotify) g_free), NULL);
	(*self).info = (g_free ((*self).info), NULL);
}

SettingsDaemonBackendsSystemUpdateUpdateDetails*
settings_daemon_backends_system_update_update_details_dup (const SettingsDaemonBackendsSystemUpdateUpdateDetails* self)
{
	SettingsDaemonBackendsSystemUpdateUpdateDetails* dup;
	dup = g_new0 (SettingsDaemonBackendsSystemUpdateUpdateDetails, 1);
	settings_daemon_backends_system_update_update_details_copy (self, dup);
	return dup;
}

void
settings_daemon_backends_system_update_update_details_free (SettingsDaemonBackendsSystemUpdateUpdateDetails* self)
{
	settings_daemon_backends_system_update_update_details_destroy (self);
	g_free (self);
}

static GType
settings_daemon_backends_system_update_update_details_get_type_once (void)
{
	GType settings_daemon_backends_system_update_update_details_type_id;
	settings_daemon_backends_system_update_update_details_type_id = g_boxed_type_register_static ("SettingsDaemonBackendsSystemUpdateUpdateDetails", (GBoxedCopyFunc) settings_daemon_backends_system_update_update_details_dup, (GBoxedFreeFunc) settings_daemon_backends_system_update_update_details_free);
	return settings_daemon_backends_system_update_update_details_type_id;
}

GType
settings_daemon_backends_system_update_update_details_get_type (void)
{
	static volatile gsize settings_daemon_backends_system_update_update_details_type_id__once = 0;
	if (g_once_init_enter (&settings_daemon_backends_system_update_update_details_type_id__once)) {
		GType settings_daemon_backends_system_update_update_details_type_id;
		settings_daemon_backends_system_update_update_details_type_id = settings_daemon_backends_system_update_update_details_get_type_once ();
		g_once_init_leave (&settings_daemon_backends_system_update_update_details_type_id__once, settings_daemon_backends_system_update_update_details_type_id);
	}
	return settings_daemon_backends_system_update_update_details_type_id__once;
}

static GObject *
settings_daemon_backends_system_update_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SettingsDaemonBackendsSystemUpdate * self;
	gchar* _tmp0_;
	SettingsDaemonPkUtilsCurrentState _tmp1_ = {0};
	gchar** _tmp2_;
	PkInfoEnum* _tmp3_;
	SettingsDaemonBackendsSystemUpdateUpdateDetails _tmp4_ = {0};
	PkTask* _tmp5_ = NULL;
	GCancellable* _tmp6_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (settings_daemon_backends_system_update_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SETTINGS_DAEMON_BACKENDS_TYPE_SYSTEM_UPDATE, SettingsDaemonBackendsSystemUpdate);
	_tmp0_ = g_strdup ("");
	_tmp1_.state = SETTINGS_DAEMON_PK_UTILS_STATE_UP_TO_DATE;
	_g_free0 (_tmp1_.status);
	_tmp1_.status = _tmp0_;
	_tmp1_.percentage = (guint) 0;
	_tmp1_.download_size_remaining = (guint64) 0;
	settings_daemon_pk_utils_current_state_destroy (&self->priv->current_state);
	self->priv->current_state = _tmp1_;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	_tmp3_ = g_new0 (PkInfoEnum, 0);
	_tmp4_.packages = (_vala_array_free (_tmp4_.packages, _tmp4_.packages_length1, (GDestroyNotify) g_free), NULL);
	_tmp4_.packages = _tmp2_;
	_tmp4_.packages_length1 = 0;
	_tmp4_.size = (guint64) 0;
	_tmp4_.info = (g_free (_tmp4_.info), NULL);
	_tmp4_.info = _tmp3_;
	_tmp4_.info_length1 = 0;
	settings_daemon_backends_system_update_update_details_destroy (&self->priv->update_details);
	self->priv->update_details = _tmp4_;
	_tmp5_ = pk_task_new ();
	pk_client_set_details_with_deps_size ((PkClient*) _tmp5_, TRUE);
	pk_task_set_only_download (_tmp5_, TRUE);
	_g_object_unref0 (self->priv->task);
	self->priv->task = _tmp5_;
	_tmp6_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp6_;
	{
		PkResults* last_offline_results = NULL;
		PkResults* _tmp7_;
		gboolean _tmp8_ = FALSE;
		PkResults* _tmp9_;
		_tmp7_ = pk_offline_get_results (&_inner_error0_);
		last_offline_results = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = last_offline_results;
		if (pk_results_get_exit_code (_tmp9_) != PK_EXIT_ENUM_SUCCESS) {
			PkResults* _tmp10_;
			PkError* _tmp11_;
			PkError* _tmp12_;
			_tmp10_ = last_offline_results;
			_tmp11_ = pk_results_get_error_code (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp8_ = _tmp12_ != NULL;
			_g_object_unref0 (_tmp12_);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			PkResults* _tmp13_;
			PkError* _tmp14_;
			PkError* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp13_ = last_offline_results;
			_tmp14_ = pk_results_get_error_code (_tmp13_);
			_tmp15_ = _tmp14_;
			g_object_get (_tmp15_, "details", &_tmp16_, NULL);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_;
			settings_daemon_backends_system_update_send_error (self, _tmp18_);
			_g_free0 (_tmp18_);
			_g_object_unref0 (_tmp15_);
		} else {
			GApplication* _tmp19_;
			_tmp19_ = g_application_get_default ();
			g_application_withdraw_notification (_tmp19_, SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_NOTIFICATION_ID);
		}
		_g_object_unref0 (last_offline_results);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("SystemUpdate.vala:59: Couldn't determine last offline results: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
settings_daemon_backends_system_update_class_init (SettingsDaemonBackendsSystemUpdateClass * klass,
                                                   gpointer klass_data)
{
	GSettings* _tmp0_;
	settings_daemon_backends_system_update_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SettingsDaemonBackendsSystemUpdate_private_offset);
	G_OBJECT_CLASS (klass)->constructor = settings_daemon_backends_system_update_constructor;
	G_OBJECT_CLASS (klass)->finalize = settings_daemon_backends_system_update_finalize;
	settings_daemon_backends_system_update_signals[SETTINGS_DAEMON_BACKENDS_SYSTEM_UPDATE_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", SETTINGS_DAEMON_BACKENDS_TYPE_SYSTEM_UPDATE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_settings_new ("io.elementary.settings-daemon.system-update");
	settings_daemon_backends_system_update_settings = _tmp0_;
}

static void
settings_daemon_backends_system_update_instance_init (SettingsDaemonBackendsSystemUpdate * self,
                                                      gpointer klass)
{
	self->priv = settings_daemon_backends_system_update_get_instance_private (self);
	self->priv->available_updates = NULL;
}

static void
settings_daemon_backends_system_update_finalize (GObject * obj)
{
	SettingsDaemonBackendsSystemUpdate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SETTINGS_DAEMON_BACKENDS_TYPE_SYSTEM_UPDATE, SettingsDaemonBackendsSystemUpdate);
	settings_daemon_pk_utils_current_state_destroy (&self->priv->current_state);
	settings_daemon_backends_system_update_update_details_destroy (&self->priv->update_details);
	_g_object_unref0 (self->priv->task);
	_g_object_unref0 (self->priv->available_updates);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (settings_daemon_backends_system_update_parent_class)->finalize (obj);
}

static GType
settings_daemon_backends_system_update_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SettingsDaemonBackendsSystemUpdateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_daemon_backends_system_update_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingsDaemonBackendsSystemUpdate), 0, (GInstanceInitFunc) settings_daemon_backends_system_update_instance_init, NULL };
	GType settings_daemon_backends_system_update_type_id;
	settings_daemon_backends_system_update_type_id = g_type_register_static (G_TYPE_OBJECT, "SettingsDaemonBackendsSystemUpdate", &g_define_type_info, 0);
	g_type_set_qdata (settings_daemon_backends_system_update_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) settings_daemon_backends_system_update_register_object);
	SettingsDaemonBackendsSystemUpdate_private_offset = g_type_add_instance_private (settings_daemon_backends_system_update_type_id, sizeof (SettingsDaemonBackendsSystemUpdatePrivate));
	return settings_daemon_backends_system_update_type_id;
}

GType
settings_daemon_backends_system_update_get_type (void)
{
	static volatile gsize settings_daemon_backends_system_update_type_id__once = 0;
	if (g_once_init_enter (&settings_daemon_backends_system_update_type_id__once)) {
		GType settings_daemon_backends_system_update_type_id;
		settings_daemon_backends_system_update_type_id = settings_daemon_backends_system_update_get_type_once ();
		g_once_init_leave (&settings_daemon_backends_system_update_type_id__once, settings_daemon_backends_system_update_type_id);
	}
	return settings_daemon_backends_system_update_type_id__once;
}

static void
_dbus_settings_daemon_backends_system_update_check_for_updates (SettingsDaemonBackendsSystemUpdate* self,
                                                                GVariant* _parameters_,
                                                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SettingsDaemonBackendsSystemUpdateCheckForUpdatesReadyData* _ready_data;
	GVariant* _tmp99_;
	GVariant* _tmp100_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SettingsDaemonBackendsSystemUpdateCheckForUpdatesReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp99_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->force = g_variant_get_boolean (_tmp99_);
	g_variant_unref (_tmp99_);
	_tmp100_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->notify = g_variant_get_boolean (_tmp100_);
	g_variant_unref (_tmp100_);
	settings_daemon_backends_system_update_check_for_updates (self, _ready_data->force, _ready_data->notify, (GAsyncReadyCallback) _dbus_settings_daemon_backends_system_update_check_for_updates_ready, _ready_data);
}

static void
_dbus_settings_daemon_backends_system_update_check_for_updates_ready (GObject * source_object,
                                                                      GAsyncResult * _res_,
                                                                      gpointer _user_data_)
{
	SettingsDaemonBackendsSystemUpdateCheckForUpdatesReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	settings_daemon_backends_system_update_check_for_updates_finish ((SettingsDaemonBackendsSystemUpdate*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (SettingsDaemonBackendsSystemUpdateCheckForUpdatesReadyData, _ready_data);
}

static void
_dbus_settings_daemon_backends_system_update_update (SettingsDaemonBackendsSystemUpdate* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SettingsDaemonBackendsSystemUpdateUpdateReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SettingsDaemonBackendsSystemUpdateUpdateReadyData);
	_ready_data->_invocation_ = invocation;
	settings_daemon_backends_system_update_update (self, (GAsyncReadyCallback) _dbus_settings_daemon_backends_system_update_update_ready, _ready_data);
}

static void
_dbus_settings_daemon_backends_system_update_update_ready (GObject * source_object,
                                                           GAsyncResult * _res_,
                                                           gpointer _user_data_)
{
	SettingsDaemonBackendsSystemUpdateUpdateReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	settings_daemon_backends_system_update_update_finish ((SettingsDaemonBackendsSystemUpdate*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (SettingsDaemonBackendsSystemUpdateUpdateReadyData, _ready_data);
}

static void
_dbus_settings_daemon_backends_system_update_cancel (SettingsDaemonBackendsSystemUpdate* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	settings_daemon_backends_system_update_cancel (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_settings_daemon_backends_system_update_get_current_state (SettingsDaemonBackendsSystemUpdate* self,
                                                                GVariant* _parameters_,
                                                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SettingsDaemonBackendsSystemUpdateGetCurrentStateReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SettingsDaemonBackendsSystemUpdateGetCurrentStateReadyData);
	_ready_data->_invocation_ = invocation;
	settings_daemon_backends_system_update_get_current_state (self, (GAsyncReadyCallback) _dbus_settings_daemon_backends_system_update_get_current_state_ready, _ready_data);
}

static void
_dbus_settings_daemon_backends_system_update_get_current_state_ready (GObject * source_object,
                                                                      GAsyncResult * _res_,
                                                                      gpointer _user_data_)
{
	SettingsDaemonBackendsSystemUpdateGetCurrentStateReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	SettingsDaemonPkUtilsCurrentState result = {0};
	GVariantBuilder _tmp101_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	settings_daemon_backends_system_update_get_current_state_finish ((SettingsDaemonBackendsSystemUpdate*) source_object, _res_, &result, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp101_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp101_, g_variant_new_int32 (result.state));
	g_variant_builder_add_value (&_tmp101_, g_variant_new_string (result.status));
	g_variant_builder_add_value (&_tmp101_, g_variant_new_uint32 (result.percentage));
	g_variant_builder_add_value (&_tmp101_, g_variant_new_uint64 (result.download_size_remaining));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp101_));
	settings_daemon_pk_utils_current_state_destroy (&result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (SettingsDaemonBackendsSystemUpdateGetCurrentStateReadyData, _ready_data);
}

static void
_dbus_settings_daemon_backends_system_update_get_update_details (SettingsDaemonBackendsSystemUpdate* self,
                                                                 GVariant* _parameters_,
                                                                 GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SettingsDaemonBackendsSystemUpdateGetUpdateDetailsReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SettingsDaemonBackendsSystemUpdateGetUpdateDetailsReadyData);
	_ready_data->_invocation_ = invocation;
	settings_daemon_backends_system_update_get_update_details (self, (GAsyncReadyCallback) _dbus_settings_daemon_backends_system_update_get_update_details_ready, _ready_data);
}

static void
_dbus_settings_daemon_backends_system_update_get_update_details_ready (GObject * source_object,
                                                                       GAsyncResult * _res_,
                                                                       gpointer _user_data_)
{
	SettingsDaemonBackendsSystemUpdateGetUpdateDetailsReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	SettingsDaemonBackendsSystemUpdateUpdateDetails result = {0};
	GVariantBuilder _tmp102_;
	gchar** _tmp103_;
	GVariantBuilder _tmp104_;
	gint _tmp105_;
	PkInfoEnum* _tmp106_;
	GVariantBuilder _tmp107_;
	gint _tmp108_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	settings_daemon_backends_system_update_get_update_details_finish ((SettingsDaemonBackendsSystemUpdate*) source_object, _res_, &result, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp102_, G_VARIANT_TYPE_TUPLE);
	_tmp103_ = result.packages;
	g_variant_builder_init (&_tmp104_, G_VARIANT_TYPE ("as"));
	for (_tmp105_ = 0; _tmp105_ < result.packages_length1; _tmp105_++) {
		g_variant_builder_add_value (&_tmp104_, g_variant_new_string (*_tmp103_));
		_tmp103_++;
	}
	g_variant_builder_add_value (&_tmp102_, g_variant_builder_end (&_tmp104_));
	g_variant_builder_add_value (&_tmp102_, g_variant_new_uint64 (result.size));
	_tmp106_ = result.info;
	g_variant_builder_init (&_tmp107_, G_VARIANT_TYPE ("ai"));
	for (_tmp108_ = 0; _tmp108_ < result.info_length1; _tmp108_++) {
		g_variant_builder_add_value (&_tmp107_, g_variant_new_int32 (*_tmp106_));
		_tmp106_++;
	}
	g_variant_builder_add_value (&_tmp102_, g_variant_builder_end (&_tmp107_));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp102_));
	settings_daemon_backends_system_update_update_details_destroy (&result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (SettingsDaemonBackendsSystemUpdateGetUpdateDetailsReadyData, _ready_data);
}

static void
_dbus_settings_daemon_backends_system_update_get_last_refresh_time (SettingsDaemonBackendsSystemUpdate* self,
                                                                    GVariant* _parameters_,
                                                                    GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeReadyData);
	_ready_data->_invocation_ = invocation;
	settings_daemon_backends_system_update_get_last_refresh_time (self, (GAsyncReadyCallback) _dbus_settings_daemon_backends_system_update_get_last_refresh_time_ready, _ready_data);
}

static void
_dbus_settings_daemon_backends_system_update_get_last_refresh_time_ready (GObject * source_object,
                                                                          GAsyncResult * _res_,
                                                                          gpointer _user_data_)
{
	SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint64 result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = settings_daemon_backends_system_update_get_last_refresh_time_finish ((SettingsDaemonBackendsSystemUpdate*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int64 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (SettingsDaemonBackendsSystemUpdateGetLastRefreshTimeReadyData, _ready_data);
}

static void
settings_daemon_backends_system_update_dbus_interface_method_call (GDBusConnection* connection,
                                                                   const gchar* sender,
                                                                   const gchar* object_path,
                                                                   const gchar* interface_name,
                                                                   const gchar* method_name,
                                                                   GVariant* parameters,
                                                                   GDBusMethodInvocation* invocation,
                                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "CheckForUpdates") == 0) {
		_dbus_settings_daemon_backends_system_update_check_for_updates (object, parameters, invocation);
	} else if (strcmp (method_name, "Update") == 0) {
		_dbus_settings_daemon_backends_system_update_update (object, parameters, invocation);
	} else if (strcmp (method_name, "Cancel") == 0) {
		_dbus_settings_daemon_backends_system_update_cancel (object, parameters, invocation);
	} else if (strcmp (method_name, "GetCurrentState") == 0) {
		_dbus_settings_daemon_backends_system_update_get_current_state (object, parameters, invocation);
	} else if (strcmp (method_name, "GetUpdateDetails") == 0) {
		_dbus_settings_daemon_backends_system_update_get_update_details (object, parameters, invocation);
	} else if (strcmp (method_name, "GetLastRefreshTime") == 0) {
		_dbus_settings_daemon_backends_system_update_get_last_refresh_time (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
settings_daemon_backends_system_update_dbus_interface_get_property (GDBusConnection* connection,
                                                                    const gchar* sender,
                                                                    const gchar* object_path,
                                                                    const gchar* interface_name,
                                                                    const gchar* property_name,
                                                                    GError** error,
                                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
settings_daemon_backends_system_update_dbus_interface_set_property (GDBusConnection* connection,
                                                                    const gchar* sender,
                                                                    const gchar* object_path,
                                                                    const gchar* interface_name,
                                                                    const gchar* property_name,
                                                                    GVariant* value,
                                                                    GError** error,
                                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_settings_daemon_backends_system_update_state_changed (GObject* _sender,
                                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "io.elementary.settings_daemon.SystemUpdate", "StateChanged", _arguments, NULL);
}

guint
settings_daemon_backends_system_update_register_object (gpointer object,
                                                        GDBusConnection* connection,
                                                        const gchar* path,
                                                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_settings_daemon_backends_system_update_dbus_interface_info), &_settings_daemon_backends_system_update_dbus_interface_vtable, data, _settings_daemon_backends_system_update_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "state-changed", (GCallback) _dbus_settings_daemon_backends_system_update_state_changed, data);
	return result;
}

static void
_settings_daemon_backends_system_update_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_settings_daemon_backends_system_update_state_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

