// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <ImagePluginInfo.h>
#include <avtImageFileFormat.h>
#include <avtSTSDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtImageOptions.h>

// ****************************************************************************
//  Method:  ImageCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Image database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
ImageCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STSD;
}

// ****************************************************************************
//  Method: ImageCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a Image database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Image database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
ImageCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    int nTimestep = nList / nBlock;
    avtSTSDFileFormat ***ffl = new avtSTSDFileFormat**[nTimestep];
    for (int i = 0; i < nTimestep; i++)
    {
        ffl[i] = new avtSTSDFileFormat*[nBlock];
        for (int j = 0; j < nBlock; j++)
        {
            ffl[i][j] = new avtImageFileFormat(list[i*nBlock + j], readOptions);
        }
    }
    avtSTSDFileFormatInterface *inter
           = new avtSTSDFileFormatInterface(ffl, nTimestep, nBlock);
    return new avtGenericDatabase(inter);
}

// ****************************************************************************
//  Method: ImageCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
ImageCommonPluginInfo::GetReadOptions() const
{
    return GetImageReadOptions();
}

// ****************************************************************************
//  Method: ImageCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
ImageCommonPluginInfo::GetWriteOptions() const
{
    return GetImageWriteOptions();
}

