// python wrapper for vtkPVMaterialLibrary
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVMaterialLibrary.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVMaterialLibrary(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVMaterialLibrary_ClassNew(); }


static PyObject *
PyvtkPVMaterialLibrary_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVMaterialLibrary::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMaterialLibrary_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMaterialLibrary *op = static_cast<vtkPVMaterialLibrary *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVMaterialLibrary::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMaterialLibrary_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVMaterialLibrary *tempr = vtkPVMaterialLibrary::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMaterialLibrary_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMaterialLibrary *op = static_cast<vtkPVMaterialLibrary *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVMaterialLibrary *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVMaterialLibrary::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMaterialLibrary_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVMaterialLibrary::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMaterialLibrary_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMaterialLibrary *op = static_cast<vtkPVMaterialLibrary *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVMaterialLibrary::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMaterialLibrary_ReadRelativeFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadRelativeFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMaterialLibrary *op = static_cast<vtkPVMaterialLibrary *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->ReadRelativeFile(temp0);
    }
    else
    {
      op->vtkPVMaterialLibrary::ReadRelativeFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMaterialLibrary_GetSearchPaths(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSearchPaths");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMaterialLibrary *op = static_cast<vtkPVMaterialLibrary *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetSearchPaths() :
      op->vtkPVMaterialLibrary::GetSearchPaths());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMaterialLibrary_GetMaterialLibrary(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaterialLibrary");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMaterialLibrary *op = static_cast<vtkPVMaterialLibrary *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkObject *tempr = (ap.IsBound() ?
      op->GetMaterialLibrary() :
      op->vtkPVMaterialLibrary::GetMaterialLibrary());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMaterialLibrary_ReadFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMaterialLibrary *op = static_cast<vtkPVMaterialLibrary *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->ReadFile(temp0) :
      op->vtkPVMaterialLibrary::ReadFile(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMaterialLibrary_WriteBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMaterialLibrary *op = static_cast<vtkPVMaterialLibrary *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->WriteBuffer() :
      op->vtkPVMaterialLibrary::WriteBuffer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVMaterialLibrary_WriteFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMaterialLibrary *op = static_cast<vtkPVMaterialLibrary *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->WriteFile(temp0);
    }
    else
    {
      op->vtkPVMaterialLibrary::WriteFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVMaterialLibrary_ReadBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVMaterialLibrary *op = static_cast<vtkPVMaterialLibrary *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->ReadBuffer(temp0) :
      op->vtkPVMaterialLibrary::ReadBuffer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVMaterialLibrary_Methods[] = {
  {"IsTypeOf", PyvtkPVMaterialLibrary_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVMaterialLibrary_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVMaterialLibrary_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVMaterialLibrary\nC++: static vtkPVMaterialLibrary *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVMaterialLibrary_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVMaterialLibrary\nC++: vtkPVMaterialLibrary *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVMaterialLibrary_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVMaterialLibrary_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ReadRelativeFile", PyvtkPVMaterialLibrary_ReadRelativeFile, METH_VARARGS,
   "ReadRelativeFile(self, FileName:str) -> None\nC++: void ReadRelativeFile(const char *FileName)\n\nUnlike vtkOSPRayMaterial::ReadFile, this searches in a number of\nrelative and environmental paths specified by the SearchPaths\nmember variable.\n"},
  {"GetSearchPaths", PyvtkPVMaterialLibrary_GetSearchPaths, METH_VARARGS,
   "GetSearchPaths(self) -> str\nC++: virtual char *GetSearchPaths()\n\nGet a string of standard search paths (path1;path2;path3) search\npaths are based on PV_PLUGIN_PATH, plugin dir relative to\nexecutable.\n"},
  {"GetMaterialLibrary", PyvtkPVMaterialLibrary_GetMaterialLibrary, METH_VARARGS,
   "GetMaterialLibrary(self) -> vtkObject\nC++: vtkObject *GetMaterialLibrary()\n\nReturns the underlying material library. When compiled withouth\nOSPRAY, will return nullptr\n"},
  {"ReadFile", PyvtkPVMaterialLibrary_ReadFile, METH_VARARGS,
   "ReadFile(self, FileName:str) -> bool\nC++: bool ReadFile(const char *FileName)\n\nDefer to contained MaterialLibrary\n"},
  {"WriteBuffer", PyvtkPVMaterialLibrary_WriteBuffer, METH_VARARGS,
   "WriteBuffer(self) -> str\nC++: const char *WriteBuffer()\n\nDefer to contained MaterialLibrary\n"},
  {"WriteFile", PyvtkPVMaterialLibrary_WriteFile, METH_VARARGS,
   "WriteFile(self, filename:str) -> None\nC++: void WriteFile(const std::string &filename)\n\n"},
  {"ReadBuffer", PyvtkPVMaterialLibrary_ReadBuffer, METH_VARARGS,
   "ReadBuffer(self, __a:str) -> bool\nC++: bool ReadBuffer(const char *)\n\nDefer to contained MaterialLibrary\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVMaterialLibrary_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("search_paths"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVMaterialLibrary_GetSearchPaths(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSearchPaths\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("material_library"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVMaterialLibrary_GetMaterialLibrary(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMaterialLibrary\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVMaterialLibrary_Doc =
  "vtkPVMaterialLibrary - manages visual material definitions\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVMaterialLibrary helps ParaView to load visual material\n"
  "definition files from known, generally process relative, locations on\n"
  "the sever.\n\n"
  "This class does nothing without raytracing (module\n"
  "VTK_MODULE_ENABLE_VTK_RenderingRayTracing disabled)\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVMaterialLibrary_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVMaterialLibrary", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVMaterialLibrary_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVMaterialLibrary_StaticNew()
{
  return vtkPVMaterialLibrary::New();
}

PyObject *PyvtkPVMaterialLibrary_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVMaterialLibrary_Type, PyvtkPVMaterialLibrary_Methods,
    "vtkPVMaterialLibrary",
 &PyvtkPVMaterialLibrary_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVMaterialLibrary_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVMaterialLibrary(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVMaterialLibrary_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVMaterialLibrary", o) != 0)
  {
    Py_DECREF(o);
  }

}

