// python wrapper for vtkSMReaderFactory
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMReaderFactory.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMReaderFactory(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMReaderFactory_ClassNew(); }

#ifndef DECLARED_PyvtkSMObject_ClassNew
extern "C" { PyObject *PyvtkSMObject_ClassNew(); }
#define DECLARED_PyvtkSMObject_ClassNew
#endif

static PyObject *
PyvtkSMReaderFactory_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMReaderFactory::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMReaderFactory::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMReaderFactory *tempr = vtkSMReaderFactory::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMReaderFactory *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMReaderFactory::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMReaderFactory::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMReaderFactory::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkSMReaderFactory::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_RegisterPrototype(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterPrototype");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->RegisterPrototype(temp0, temp1);
    }
    else
    {
      op->vtkSMReaderFactory::RegisterPrototype(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_CanReadFile_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CanReadFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  const char *temp0 = nullptr;
  vtkSMSession *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSession"))
  {
    bool tempr = (ap.IsBound() ?
      op->CanReadFile(temp0, temp1) :
      op->vtkSMReaderFactory::CanReadFile(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMReaderFactory_CanReadFile_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CanReadFile");

  const char *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    bool tempr = vtkSMReaderFactory::CanReadFile(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMReaderFactory_CanReadFile_s3(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CanReadFile");

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  const char *temp2 = nullptr;
  vtkSMSession *temp3 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetVTKObject(temp3, "vtkSMSession"))
  {
    bool tempr = vtkSMReaderFactory::CanReadFile(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMReaderFactory_CanReadFile_Methods[] = {
  {"CanReadFile", PyvtkSMReaderFactory_CanReadFile_s1, METH_VARARGS,
   "@zV *vtkSMSession"},
  {"CanReadFile", PyvtkSMReaderFactory_CanReadFile_s2, METH_VARARGS | METH_STATIC,
   "zV *vtkSMProxy"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMReaderFactory_CanReadFile(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMReaderFactory_CanReadFile_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 4:
      return PyvtkSMReaderFactory_CanReadFile_s3(self, args);
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "CanReadFile");
  return nullptr;
}


static PyObject *
PyvtkSMReaderFactory_GetReaderName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReaderName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetReaderName() :
      op->vtkSMReaderFactory::GetReaderName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_GetReaderGroup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReaderGroup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetReaderGroup() :
      op->vtkSMReaderFactory::GetReaderGroup());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_GetPossibleReaders(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPossibleReaders");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  const char *temp0 = nullptr;
  vtkSMSession *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSession"))
  {
    vtkStringList *tempr = (ap.IsBound() ?
      op->GetPossibleReaders(temp0, temp1) :
      op->vtkSMReaderFactory::GetPossibleReaders(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_GetReaders_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReaders");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  vtkSMSession *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSession"))
  {
    vtkStringList *tempr = (ap.IsBound() ?
      op->GetReaders(temp0) :
      op->vtkSMReaderFactory::GetReaders(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMReaderFactory_GetReaders_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReaders");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  const char *temp0 = nullptr;
  vtkSMSession *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSession"))
  {
    vtkStringList *tempr = (ap.IsBound() ?
      op->GetReaders(temp0, temp1) :
      op->vtkSMReaderFactory::GetReaders(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMReaderFactory_GetReaders(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMReaderFactory_GetReaders_s1(self, args);
    case 2:
      return PyvtkSMReaderFactory_GetReaders_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetReaders");
  return nullptr;
}


static PyObject *
PyvtkSMReaderFactory_TestFileReadability(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "TestFileReadability");

  const char *temp0 = nullptr;
  vtkSMSession *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSession"))
  {
    bool tempr = vtkSMReaderFactory::TestFileReadability(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_GetSupportedFileTypes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSupportedFileTypes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  vtkSMSession *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSession"))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetSupportedFileTypes(temp0) :
      op->vtkSMReaderFactory::GetSupportedFileTypes(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_GetNumberOfRegisteredPrototypes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfRegisteredPrototypes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfRegisteredPrototypes() :
      op->vtkSMReaderFactory::GetNumberOfRegisteredPrototypes());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_UpdateAvailableReaders(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateAvailableReaders");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UpdateAvailableReaders();
    }
    else
    {
      op->vtkSMReaderFactory::UpdateAvailableReaders();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_AddGroup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddGroup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->AddGroup(temp0);
    }
    else
    {
      op->vtkSMReaderFactory::AddGroup(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_RemoveGroup(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveGroup");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->RemoveGroup(temp0);
    }
    else
    {
      op->vtkSMReaderFactory::RemoveGroup(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_GetGroups(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGroups");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMReaderFactory *op = static_cast<vtkSMReaderFactory *>(vp);

  vtkStringList *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkStringList"))
  {
    if (ap.IsBound())
    {
      op->GetGroups(temp0);
    }
    else
    {
      op->vtkSMReaderFactory::GetGroups(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMReaderFactory_AddReaderToWhitelist(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "AddReaderToWhitelist");

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkSMReaderFactory::AddReaderToWhitelist(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMReaderFactory_Methods[] = {
  {"IsTypeOf", PyvtkSMReaderFactory_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMReaderFactory_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMReaderFactory_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMReaderFactory\nC++: static vtkSMReaderFactory *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMReaderFactory_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMReaderFactory\nC++: vtkSMReaderFactory *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMReaderFactory_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMReaderFactory_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Initialize", PyvtkSMReaderFactory_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize()\n\nCleanup all registered prototypes.\n"},
  {"RegisterPrototype", PyvtkSMReaderFactory_RegisterPrototype, METH_VARARGS,
   "RegisterPrototype(self, xmlgroup:str, xmlname:str) -> None\nC++: void RegisterPrototype(const char *xmlgroup,\n    const char *xmlname)\n\nRegister a prototype. If it is already registered this becomes a\nno-op.\n"},
  {"CanReadFile", PyvtkSMReaderFactory_CanReadFile, METH_VARARGS,
   "CanReadFile(self, filename:str, session:vtkSMSession) -> bool\nC++: bool CanReadFile(const char *filename, vtkSMSession *session)\nCanReadFile(filename:str, reader:vtkSMProxy) -> bool\nC++: static bool CanReadFile(const char *filename,\n    vtkSMProxy *reader)\nCanReadFile(filename:str, readerxmlgroup:str, readerxmlname:str,\n    session:vtkSMSession) -> bool\nC++: static bool CanReadFile(const char *filename,\n    const char *readerxmlgroup, const char *readerxmlname,\n    vtkSMSession *session)\n\nReturns true if a reader can be determined that can read the\nfile. When this returns true, one can use GetReaderGroup() and\nGetReaderName() to obtain the xmlgroup and xmlname for the reader\nthat can read the file. When this returns false, use\nGetPossibleReaders() to get the list of readers that can possibly\nread the file.\n"},
  {"GetReaderName", PyvtkSMReaderFactory_GetReaderName, METH_VARARGS,
   "GetReaderName(self) -> str\nC++: virtual char *GetReaderName()\n\nReturns the xml-name for the reader that can read the file\nqueried by the most recent CanReadFile() call. This is valid only\nif CanReadFile() returned true.\n"},
  {"GetReaderGroup", PyvtkSMReaderFactory_GetReaderGroup, METH_VARARGS,
   "GetReaderGroup(self) -> str\nC++: virtual char *GetReaderGroup()\n\nReturns the xml-group for the reader that can read the file\nqueried by the most recent CanReadFile() call. This is valid only\nif CanReadFile() returned true.\n"},
  {"GetPossibleReaders", PyvtkSMReaderFactory_GetPossibleReaders, METH_VARARGS,
   "GetPossibleReaders(self, filename:str, session:vtkSMSession)\n    -> vtkStringList\nC++: vtkStringList *GetPossibleReaders(const char *filename,\n    vtkSMSession *session)\n\nGet the list of readers that can possibly read the file. This is\nused when the factory cannot determine which reader to use for\nreading the file. The user can then choose from the provided\noptions. Returns a list of 3-tuples where the 1st string is the\ngroup, the 2nd string is the reader name and the 3rd string is\nthe reader description Note that the extension test is skipped in\nthis case.\n"},
  {"GetReaders", PyvtkSMReaderFactory_GetReaders, METH_VARARGS,
   "GetReaders(self, session:vtkSMSession) -> vtkStringList\nC++: vtkStringList *GetReaders(vtkSMSession *session)\nGetReaders(self, filename:str, session:vtkSMSession)\n    -> vtkStringList\nC++: vtkStringList *GetReaders(const char *filename,\n    vtkSMSession *session)\n\nReturns a list of 3-tuples where the 1st string is the group, the\n2nd string is the reader name and the 3rd string is the reader\ndescription This returns all the possible readers with a given\nconnection id.\n"},
  {"TestFileReadability", PyvtkSMReaderFactory_TestFileReadability, METH_VARARGS,
   "TestFileReadability(filename:str, session:vtkSMSession) -> bool\nC++: static bool TestFileReadability(const char *filename,\n    vtkSMSession *session)\n\nHelper method to test is a file is readable on the server side.\nThis has nothing to do with the whether the file is readable by a\nreader, just test the file permissions etc. Internally uses the\nServerFileListing proxy.\n"},
  {"GetSupportedFileTypes", PyvtkSMReaderFactory_GetSupportedFileTypes, METH_VARARGS,
   "GetSupportedFileTypes(self, session:vtkSMSession) -> str\nC++: virtual const char *GetSupportedFileTypes(\n    vtkSMSession *session)\n\nReturns a formatted string with all supported file types.cid is\nnot used currently. An example returned string would look like:\n \"Supported Files (*.vtk *.pvd);;PVD Files (*.pvd);;VTK Files (*.vtk)\"\n \n"},
  {"GetNumberOfRegisteredPrototypes", PyvtkSMReaderFactory_GetNumberOfRegisteredPrototypes, METH_VARARGS,
   "GetNumberOfRegisteredPrototypes(self) -> int\nC++: unsigned int GetNumberOfRegisteredPrototypes()\n\nReturns the number of registered prototypes.\n"},
  {"UpdateAvailableReaders", PyvtkSMReaderFactory_UpdateAvailableReaders, METH_VARARGS,
   "UpdateAvailableReaders(self) -> None\nC++: virtual void UpdateAvailableReaders()\n\nEvery time a new proxy definition is added we check to see if it\nis a reader and then we add it to the list of available readers.\n"},
  {"AddGroup", PyvtkSMReaderFactory_AddGroup, METH_VARARGS,
   "AddGroup(self, groupName:str) -> None\nC++: void AddGroup(const char *groupName)\n\nAdd/remove a group name to look for readers in. By default\n\"source\" is included.\n"},
  {"RemoveGroup", PyvtkSMReaderFactory_RemoveGroup, METH_VARARGS,
   "RemoveGroup(self, groupName:str) -> None\nC++: void RemoveGroup(const char *groupName)\n\n"},
  {"GetGroups", PyvtkSMReaderFactory_GetGroups, METH_VARARGS,
   "GetGroups(self, groups:vtkStringList) -> None\nC++: void GetGroups(vtkStringList *groups)\n\n"},
  {"AddReaderToWhitelist", PyvtkSMReaderFactory_AddReaderToWhitelist, METH_VARARGS,
   "AddReaderToWhitelist(readerxmlgroup:str, readerxmlname:str)\n    -> None\nC++: static void AddReaderToWhitelist(const char *readerxmlgroup,\n    const char *readerxmlname)\n\nThis function is for ParaView based applications that only wish\nto expose a subset of the readers.  If this function is never\ncalled, the reader factory will expose all the readers as it has\nin the past.  However, if any readers are specified by passing\ntheir group name and reader name to this function, then only\nthose readers will be available in any reader factories created\nby the application.  This is intended to be called at the\nbeginning of the application's execution before any sessions are\ncreated.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMReaderFactory_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("reader_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMReaderFactory_GetReaderName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetReaderName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("reader_group"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMReaderFactory_GetReaderGroup(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetReaderGroup\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_registered_prototypes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMReaderFactory_GetNumberOfRegisteredPrototypes(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfRegisteredPrototypes\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMReaderFactory_Doc =
  "vtkSMReaderFactory - is a factory for creating a reader proxy based\non the filename/extension.\n\n"
  "Superclass: vtkSMObject\n\n"
  "vtkSMReaderFactory is a factory for creating a reader that reads a\n"
  "particular file. The reader factory needs to be configured to\n"
  "register the reader prototypes supported by the application. This is\n"
  "done automatically when the reader's proxy definition is registered\n"
  "AND if it has the extensions specified in the Hints section of the\n"
  "XML proxy definition. It is done with the following format:\n"
  " <ReaderFactory extensions=\"[list of expected extensions]\"\n"
  "     file_description=\"[description of the file]\" />\n"
  " \n\n"
  "Once the factory has been configured, the API to create readers, get\n"
  "available readers etc. can be used.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMReaderFactory_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMReaderFactory", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMReaderFactory_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMReaderFactory_StaticNew()
{
  return vtkSMReaderFactory::New();
}

PyObject *PyvtkSMReaderFactory_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMReaderFactory_Type, PyvtkSMReaderFactory_Methods,
    "vtkSMReaderFactory",
 &PyvtkSMReaderFactory_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMObject_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMReaderFactory_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMReaderFactory(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMReaderFactory_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMReaderFactory", o) != 0)
  {
    Py_DECREF(o);
  }

}

