/***************************************************************************
**                                                                        **
**  Polyphone, a soundfont editor                                         **
**  Copyright (C) 2013-2024 Davy Triponney                                **
**                                                                        **
**  This program is free software: you can redistribute it and/or modify  **
**  it under the terms of the GNU General Public License as published by  **
**  the Free Software Foundation, either version 3 of the License, or     **
**  (at your option) any later version.                                   **
**                                                                        **
**  This program is distributed in the hope that it will be useful,       **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of        **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          **
**  GNU General Public License for more details.                          **
**                                                                        **
**  You should have received a copy of the GNU General Public License     **
**  along with this program. If not, see http://www.gnu.org/licenses/.    **
**                                                                        **
****************************************************************************
**           Author: Davy Triponney                                       **
**  Website/Contact: https://www.polyphone.io                             **
**             Date: 01.01.2013                                           **
***************************************************************************/

#ifndef TOOLMERGESAMPLES_PARAMETERS_H
#define TOOLMERGESAMPLES_PARAMETERS_H

#include "abstracttoolparameters.h"
#include <QList>
#include <QString>

class ToolMergeSamples_parameters: public AbstractToolParameters
{
public:
    /// Load the configuration from the ini file
    void loadConfiguration() override;

    /// Save the configuration in the ini file
    void saveConfiguration() override;

    QString getPresetName() { return _presetName; }
    void setPresetName(QString presetName) { _presetName = presetName; }
    
    int getDensityType() { return _densityType; }
    void setDensityType(int densityType) { _densityType = densityType; }
    
    bool getStereoSample() { return _stereoSample; }
    void setStereoSample(bool stereoSample) { _stereoSample = stereoSample; }
    
    bool getLoopSample() { return _loopSample; }
    void setLoopSample(bool loopSample) { _loopSample = loopSample; }

    int getSampleSustainDuration() { return _sustainDuration; }
    void setSampleSustainDuration(int sustainDuration) { _sustainDuration = sustainDuration; }

    int getSampleReleaseDuration() { return _releaseDuration; }
    void setSampleReleaseDuration(int releaseDuration) { _releaseDuration = releaseDuration; }
    
private:
    QString _presetName;
    int _densityType;
    bool _stereoSample;
    bool _loopSample;
    int _sustainDuration;
    int _releaseDuration;
};

#endif // TOOLMERGESAMPLES_PARAMETERS_H
