#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

# include "R_API.h"
# include "R_API_eventloop.h"

void rpy2_runHandlers(InputHandler *handlers) {{
    R_runHandlers(handlers, R_checkActivity(0, 1));
  }};
/* R symbol, environment, and arbitrary data */

struct RPY2_sym_env_data {
  SEXP symbol;
  SEXP environment;
  SEXP data;
};


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 43), // DllInfo *()(void)
/*  1 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // InputHandler *()(InputHandler *, int)
/*  3 */ _CFFI_OP(_CFFI_OP_POINTER, 336), // InputHandler *
/*  4 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // InputHandler *()(InputHandler *, int, void(*)(void *), int)
/*  7 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/*  8 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/*  9 */ _CFFI_OP(_CFFI_OP_POINTER, 324), // void(*)(void *)
/* 10 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 91), // Rboolean()(struct SEXPREC *)
/* 13 */ _CFFI_OP(_CFFI_OP_POINTER, 341), // SEXPREC *
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION, 91), // Rboolean()(void(*)(void *), void *)
/* 16 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 17 */ _CFFI_OP(_CFFI_OP_POINTER, 381), // void *
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION, 340), // Rcomplex *()(struct SEXPREC *)
/* 20 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION, 116), // Rcomplex()(struct SEXPREC *, ptrdiff_t)
/* 23 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 24 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27), // ptrdiff_t
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION, 123), // cetype_t()(struct SEXPREC *)
/* 27 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 28 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION, 63), // char const *()(struct SEXPREC *)
/* 30 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 347), // double *()(struct SEXPREC *)
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 34 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION, 131), // double()(struct SEXPREC *, ptrdiff_t)
/* 36 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 37 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION, 187), // int *()(struct SEXPREC *)
/* 40 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(DllInfo *, R_CMethodDef const *, R_CallMethodDef const *, R_CMethodDef const *, R_CallMethodDef const *)
/* 43 */ _CFFI_OP(_CFFI_OP_POINTER, 333), // DllInfo *
/* 44 */ _CFFI_OP(_CFFI_OP_POINTER, 338), // R_CMethodDef const *
/* 45 */ _CFFI_OP(_CFFI_OP_POINTER, 339), // R_CallMethodDef const *
/* 46 */ _CFFI_OP(_CFFI_OP_NOOP, 44),
/* 47 */ _CFFI_OP(_CFFI_OP_NOOP, 45),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 49 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(InputHandler * *, InputHandler *)
/* 50 */ _CFFI_OP(_CFFI_OP_POINTER, 3), // InputHandler * *
/* 51 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(char *)
/* 54 */ _CFFI_OP(_CFFI_OP_POINTER, 346), // char *
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(char *, unsigned char *, int, int)
/* 57 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 58 */ _CFFI_OP(_CFFI_OP_POINTER, 220), // unsigned char *
/* 59 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 60 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(char const *)
/* 63 */ _CFFI_OP(_CFFI_OP_POINTER, 346), // char const *
/* 64 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 65 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(char const *, unsigned char *, int, int)
/* 66 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 58),
/* 68 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 69 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 70 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int, char * *)
/* 72 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 73 */ _CFFI_OP(_CFFI_OP_POINTER, 54), // char * *
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int, char *, int)
/* 76 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 77 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 78 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int, char const * *, char const * *, char const *)
/* 81 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 82 */ _CFFI_OP(_CFFI_OP_POINTER, 63), // char const * *
/* 83 */ _CFFI_OP(_CFFI_OP_NOOP, 82),
/* 84 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(int, char const * *, char const * *, char const *, Rboolean, char const *)
/* 87 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 88 */ _CFFI_OP(_CFFI_OP_NOOP, 82),
/* 89 */ _CFFI_OP(_CFFI_OP_NOOP, 82),
/* 90 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 91 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // Rboolean
/* 92 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 93 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 94 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct SEXPREC *)
/* 95 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct SEXPREC *, nchar_type, Rboolean, Rboolean, char const *)
/* 98 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 99 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // nchar_type
/* 100 */ _CFFI_OP(_CFFI_OP_NOOP, 91),
/* 101 */ _CFFI_OP(_CFFI_OP_NOOP, 91),
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct SEXPREC *, ptrdiff_t)
/* 105 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 106 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 107 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // int()(struct SEXPREC *, struct SEXPREC *)
/* 109 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 112 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // ptrdiff_t()(struct SEXPREC *)
/* 113 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 114 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 115 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(Rcomplex)
/* 116 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // Rcomplex
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(char const *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(char const *, cetype_t)
/* 122 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 123 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // cetype_t
/* 124 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(char const *, int, cetype_t)
/* 126 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 127 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 123),
/* 129 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(double)
/* 131 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(int)
/* 134 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *(*)(void *), void *, struct SEXPREC *(*)(struct SEXPREC *, void *), void *)
/* 137 */ _CFFI_OP(_CFFI_OP_POINTER, 231), // struct SEXPREC *(*)(void *)
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 139 */ _CFFI_OP(_CFFI_OP_POINTER, 215), // struct SEXPREC *(*)(struct SEXPREC *, void *)
/* 140 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 141 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 142 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *(*)(void *), void *, void(*)(void *, Rboolean), void *, struct SEXPREC *)
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 144 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 145 */ _CFFI_OP(_CFFI_OP_POINTER, 327), // void(*)(void *, Rboolean)
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 147 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *)
/* 150 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, Rboolean)
/* 153 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 154 */ _CFFI_OP(_CFFI_OP_NOOP, 91),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 156 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, int)
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 158 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 159 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, int, ParseStatus *, struct SEXPREC *)
/* 161 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 162 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 163 */ _CFFI_OP(_CFFI_OP_POINTER, 337), // ParseStatus *
/* 164 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 165 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 166 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, ptrdiff_t)
/* 167 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 168 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, ptrdiff_t, struct SEXPREC *)
/* 171 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 172 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 173 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 175 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, struct SEXPREC *)
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 177 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 178 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 179 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, struct SEXPREC *, Rboolean)
/* 180 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 181 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 182 */ _CFFI_OP(_CFFI_OP_NOOP, 91),
/* 183 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 184 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, struct SEXPREC *, int *)
/* 185 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 186 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 187 */ _CFFI_OP(_CFFI_OP_POINTER, 4), // int *
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 189 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
/* 190 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 191 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 192 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 194 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
/* 195 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 196 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 197 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 198 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 200 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
/* 201 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 202 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 203 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 204 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 205 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 207 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
/* 208 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 209 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 211 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 212 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 213 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(struct SEXPREC *, void *)
/* 216 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 217 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 218 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(unsigned char)
/* 220 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 221 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 222 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(unsigned int, ptrdiff_t)
/* 223 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 224 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 225 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(void *(*)(void), struct SEXPREC *, struct SEXPREC *)
/* 227 */ _CFFI_OP(_CFFI_OP_POINTER, 244), // void *(*)(void)
/* 228 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 229 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 231 */ _CFFI_OP(_CFFI_OP_FUNCTION, 13), // struct SEXPREC *()(void *)
/* 232 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 233 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 234 */ _CFFI_OP(_CFFI_OP_FUNCTION, 58), // unsigned char *()(struct SEXPREC *)
/* 235 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 236 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 237 */ _CFFI_OP(_CFFI_OP_FUNCTION, 220), // unsigned char()(struct SEXPREC *, ptrdiff_t)
/* 238 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 239 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 241 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // void *()(struct SEXPREC *)
/* 242 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 243 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION, 17), // void *()(void)
/* 245 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 246 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(InputHandler *)
/* 247 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 249 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(SA_TYPE, int, int)
/* 250 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // SA_TYPE
/* 251 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 252 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 253 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 254 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(char *)
/* 255 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 256 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 257 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(char *, int)
/* 258 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 259 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 260 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 261 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(char *, int, int)
/* 262 */ _CFFI_OP(_CFFI_OP_NOOP, 54),
/* 263 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 264 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 266 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(char const *)
/* 267 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 268 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 269 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(char const *, int)
/* 270 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 271 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 272 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 273 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(char const *, int, int)
/* 274 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 275 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 276 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 277 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 278 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(int)
/* 279 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 280 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 281 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(int, char * *)
/* 282 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 283 */ _CFFI_OP(_CFFI_OP_NOOP, 73),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 285 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(struct SEXPREC *)
/* 286 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 287 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 288 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(struct SEXPREC *, int)
/* 289 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 290 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 291 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 292 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(struct SEXPREC *, ptrdiff_t, double)
/* 293 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 294 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 295 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 296 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 297 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(struct SEXPREC *, ptrdiff_t, int)
/* 298 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 299 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 300 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 301 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 302 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(struct SEXPREC *, ptrdiff_t, struct SEXPREC *)
/* 303 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 304 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 305 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 306 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 307 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(struct SEXPREC *, struct SEXPREC *)
/* 308 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 309 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 310 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 311 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
/* 312 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 313 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 314 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 315 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 316 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 317 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(struct SEXPREC *, void(*)(struct SEXPREC *))
/* 318 */ _CFFI_OP(_CFFI_OP_NOOP, 13),
/* 319 */ _CFFI_OP(_CFFI_OP_POINTER, 285), // void(*)(struct SEXPREC *)
/* 320 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 321 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(structRstart *)
/* 322 */ _CFFI_OP(_CFFI_OP_POINTER, 367), // structRstart *
/* 323 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 324 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(void *)
/* 325 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 326 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 327 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(void *, Rboolean)
/* 328 */ _CFFI_OP(_CFFI_OP_NOOP, 17),
/* 329 */ _CFFI_OP(_CFFI_OP_NOOP, 91),
/* 330 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 331 */ _CFFI_OP(_CFFI_OP_FUNCTION, 381), // void()(void)
/* 332 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 333 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // DllInfo
/* 334 */ _CFFI_OP(_CFFI_OP_POINTER, 335), // FILE *
/* 335 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // FILE
/* 336 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // InputHandler
/* 337 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // ParseStatus
/* 338 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // R_CMethodDef
/* 339 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // R_CallMethodDef
/* 340 */ _CFFI_OP(_CFFI_OP_POINTER, 116), // Rcomplex *
/* 341 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // SEXPREC
/* 342 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // SEXPREC_ALIGN
/* 343 */ _CFFI_OP(_CFFI_OP_POINTER, 344), // VECTOR_SEXPREC *
/* 344 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // VECTOR_SEXPREC
/* 345 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 49), // _cffi_double_complex_t
/* 346 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 347 */ _CFFI_OP(_CFFI_OP_POINTER, 131), // double *
/* 348 */ _CFFI_OP(_CFFI_OP_POINTER, 53), // int(*)(char *)
/* 349 */ _CFFI_OP(_CFFI_OP_POINTER, 56), // int(*)(char *, unsigned char *, int, int)
/* 350 */ _CFFI_OP(_CFFI_OP_POINTER, 62), // int(*)(char const *)
/* 351 */ _CFFI_OP(_CFFI_OP_POINTER, 65), // int(*)(char const *, unsigned char *, int, int)
/* 352 */ _CFFI_OP(_CFFI_OP_POINTER, 75), // int(*)(int, char *, int)
/* 353 */ _CFFI_OP(_CFFI_OP_POINTER, 80), // int(*)(int, char const * *, char const * *, char const *)
/* 354 */ _CFFI_OP(_CFFI_OP_POINTER, 86), // int(*)(int, char const * *, char const * *, char const *, Rboolean, char const *)
/* 355 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 356 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct RPY2_sym_env_data
/* 357 */ _CFFI_OP(_CFFI_OP_POINTER, 149), // struct SEXPREC *(*)(struct SEXPREC *)
/* 358 */ _CFFI_OP(_CFFI_OP_POINTER, 194), // struct SEXPREC *(*)(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
/* 359 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // struct closxp_struct
/* 360 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // struct envsxp_struct
/* 361 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // struct listsxp_struct
/* 362 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // struct primsxp_struct
/* 363 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // struct promsxp_struct
/* 364 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // struct sxpinfo_struct
/* 365 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // struct symsxp_struct
/* 366 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // struct vecsxp_struct
/* 367 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // structRstart
/* 368 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 26), // uintptr_t
/* 369 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // union $2
/* 370 */ _CFFI_OP(_CFFI_OP_POINTER, 223), // unsigned int *
/* 371 */ _CFFI_OP(_CFFI_OP_POINTER, 249), // void(*)(SA_TYPE, int, int)
/* 372 */ _CFFI_OP(_CFFI_OP_POINTER, 254), // void(*)(char *)
/* 373 */ _CFFI_OP(_CFFI_OP_POINTER, 257), // void(*)(char *, int)
/* 374 */ _CFFI_OP(_CFFI_OP_POINTER, 261), // void(*)(char *, int, int)
/* 375 */ _CFFI_OP(_CFFI_OP_POINTER, 266), // void(*)(char const *)
/* 376 */ _CFFI_OP(_CFFI_OP_POINTER, 269), // void(*)(char const *, int)
/* 377 */ _CFFI_OP(_CFFI_OP_POINTER, 273), // void(*)(char const *, int, int)
/* 378 */ _CFFI_OP(_CFFI_OP_POINTER, 278), // void(*)(int)
/* 379 */ _CFFI_OP(_CFFI_OP_POINTER, 311), // void(*)(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
/* 380 */ _CFFI_OP(_CFFI_OP_POINTER, 331), // void(*)(void)
/* 381 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_PARSE_NULL(unsigned long long *o)
{
  int n = (PARSE_NULL) <= 0;
  *o = (unsigned long long)((PARSE_NULL) | 0);  /* check that PARSE_NULL is an integer */
  return n;
}

static int _cffi_const_PARSE_OK(unsigned long long *o)
{
  int n = (PARSE_OK) <= 0;
  *o = (unsigned long long)((PARSE_OK) | 0);  /* check that PARSE_OK is an integer */
  return n;
}

static int _cffi_const_PARSE_INCOMPLETE(unsigned long long *o)
{
  int n = (PARSE_INCOMPLETE) <= 0;
  *o = (unsigned long long)((PARSE_INCOMPLETE) | 0);  /* check that PARSE_INCOMPLETE is an integer */
  return n;
}

static int _cffi_const_PARSE_ERROR(unsigned long long *o)
{
  int n = (PARSE_ERROR) <= 0;
  *o = (unsigned long long)((PARSE_ERROR) | 0);  /* check that PARSE_ERROR is an integer */
  return n;
}

static int _cffi_const_PARSE_EOF(unsigned long long *o)
{
  int n = (PARSE_EOF) <= 0;
  *o = (unsigned long long)((PARSE_EOF) | 0);  /* check that PARSE_EOF is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_R_CMethodDef(R_CMethodDef *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { void *(* *tmp)(void) = &p->fun; (void)tmp; }
  (void)((p->numArgs) | 0);  /* check that 'R_CMethodDef.numArgs' is an integer */
  { unsigned int * *tmp = &p->types; (void)tmp; }
}
struct _cffi_align_typedef_R_CMethodDef { char x; R_CMethodDef y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_R_CallMethodDef(R_CallMethodDef *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { void *(* *tmp)(void) = &p->fun; (void)tmp; }
  (void)((p->numArgs) | 0);  /* check that 'R_CallMethodDef.numArgs' is an integer */
}
struct _cffi_align_typedef_R_CallMethodDef { char x; R_CallMethodDef y; };

static int _cffi_const_FALSE(unsigned long long *o)
{
  int n = (FALSE) <= 0;
  *o = (unsigned long long)((FALSE) | 0);  /* check that FALSE is an integer */
  return n;
}

static int _cffi_const_TRUE(unsigned long long *o)
{
  int n = (TRUE) <= 0;
  *o = (unsigned long long)((TRUE) | 0);  /* check that TRUE is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_Rcomplex(Rcomplex *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { double *tmp = &p->r; (void)tmp; }
  { double *tmp = &p->i; (void)tmp; }
  { _cffi_double_complex_t *tmp = &p->private_data_c; (void)tmp; }
}
struct _cffi_align_typedef_Rcomplex { char x; Rcomplex y; };

static int _cffi_const_SA_NORESTORE(unsigned long long *o)
{
  int n = (SA_NORESTORE) <= 0;
  *o = (unsigned long long)((SA_NORESTORE) | 0);  /* check that SA_NORESTORE is an integer */
  return n;
}

static int _cffi_const_SA_RESTORE(unsigned long long *o)
{
  int n = (SA_RESTORE) <= 0;
  *o = (unsigned long long)((SA_RESTORE) | 0);  /* check that SA_RESTORE is an integer */
  return n;
}

static int _cffi_const_SA_DEFAULT(unsigned long long *o)
{
  int n = (SA_DEFAULT) <= 0;
  *o = (unsigned long long)((SA_DEFAULT) | 0);  /* check that SA_DEFAULT is an integer */
  return n;
}

static int _cffi_const_SA_NOSAVE(unsigned long long *o)
{
  int n = (SA_NOSAVE) <= 0;
  *o = (unsigned long long)((SA_NOSAVE) | 0);  /* check that SA_NOSAVE is an integer */
  return n;
}

static int _cffi_const_SA_SAVE(unsigned long long *o)
{
  int n = (SA_SAVE) <= 0;
  *o = (unsigned long long)((SA_SAVE) | 0);  /* check that SA_SAVE is an integer */
  return n;
}

static int _cffi_const_SA_SAVEASK(unsigned long long *o)
{
  int n = (SA_SAVEASK) <= 0;
  *o = (unsigned long long)((SA_SAVEASK) | 0);  /* check that SA_SAVEASK is an integer */
  return n;
}

static int _cffi_const_SA_SUICIDE(unsigned long long *o)
{
  int n = (SA_SUICIDE) <= 0;
  *o = (unsigned long long)((SA_SUICIDE) | 0);  /* check that SA_SUICIDE is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_SEXPREC_ALIGN(SEXPREC_ALIGN *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { VECTOR_SEXPREC *tmp = &p->s; (void)tmp; }
  { double *tmp = &p->align; (void)tmp; }
}
struct _cffi_align_typedef_SEXPREC_ALIGN { char x; SEXPREC_ALIGN y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_VECTOR_SEXPREC(VECTOR_SEXPREC *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct sxpinfo_struct *tmp = &p->sxpinfo; (void)tmp; }
  { SEXPREC * *tmp = &p->attrib; (void)tmp; }
  { SEXPREC * *tmp = &p->gengc_next_node; (void)tmp; }
  { SEXPREC * *tmp = &p->gengc_prev_node; (void)tmp; }
  { struct vecsxp_struct *tmp = &p->vecsxp; (void)tmp; }
}
struct _cffi_align_typedef_VECTOR_SEXPREC { char x; VECTOR_SEXPREC y; };

static int _cffi_const_CE_NATIVE(unsigned long long *o)
{
  int n = (CE_NATIVE) <= 0;
  *o = (unsigned long long)((CE_NATIVE) | 0);  /* check that CE_NATIVE is an integer */
  return n;
}

static int _cffi_const_CE_UTF8(unsigned long long *o)
{
  int n = (CE_UTF8) <= 0;
  *o = (unsigned long long)((CE_UTF8) | 0);  /* check that CE_UTF8 is an integer */
  return n;
}

static int _cffi_const_CE_LATIN1(unsigned long long *o)
{
  int n = (CE_LATIN1) <= 0;
  *o = (unsigned long long)((CE_LATIN1) | 0);  /* check that CE_LATIN1 is an integer */
  return n;
}

static int _cffi_const_CE_BYTES(unsigned long long *o)
{
  int n = (CE_BYTES) <= 0;
  *o = (unsigned long long)((CE_BYTES) | 0);  /* check that CE_BYTES is an integer */
  return n;
}

static int _cffi_const_CE_SYMBOL(unsigned long long *o)
{
  int n = (CE_SYMBOL) <= 0;
  *o = (unsigned long long)((CE_SYMBOL) | 0);  /* check that CE_SYMBOL is an integer */
  return n;
}

static int _cffi_const_CE_ANY(unsigned long long *o)
{
  int n = (CE_ANY) <= 0;
  *o = (unsigned long long)((CE_ANY) | 0);  /* check that CE_ANY is an integer */
  return n;
}

static int _cffi_const_Bytes(unsigned long long *o)
{
  int n = (Bytes) <= 0;
  *o = (unsigned long long)((Bytes) | 0);  /* check that Bytes is an integer */
  return n;
}

static int _cffi_const_Chars(unsigned long long *o)
{
  int n = (Chars) <= 0;
  *o = (unsigned long long)((Chars) | 0);  /* check that Chars is an integer */
  return n;
}

static int _cffi_const_Width(unsigned long long *o)
{
  int n = (Width) <= 0;
  *o = (unsigned long long)((Width) | 0);  /* check that Width is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_structRstart(structRstart *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { Rboolean *tmp = &p->R_Quiet; (void)tmp; }
  { Rboolean *tmp = &p->R_Slave; (void)tmp; }
  { Rboolean *tmp = &p->R_Interactive; (void)tmp; }
  { Rboolean *tmp = &p->R_Verbose; (void)tmp; }
  { Rboolean *tmp = &p->LoadSiteFile; (void)tmp; }
  { Rboolean *tmp = &p->LoadInitFile; (void)tmp; }
  { Rboolean *tmp = &p->DebugInitFile; (void)tmp; }
  { SA_TYPE *tmp = &p->RestoreAction; (void)tmp; }
  { SA_TYPE *tmp = &p->SaveAction; (void)tmp; }
  (void)((p->vsize) | 0);  /* check that 'structRstart.vsize' is an integer */
  (void)((p->nsize) | 0);  /* check that 'structRstart.nsize' is an integer */
  (void)((p->max_vsize) | 0);  /* check that 'structRstart.max_vsize' is an integer */
  (void)((p->max_nsize) | 0);  /* check that 'structRstart.max_nsize' is an integer */
  (void)((p->ppsize) | 0);  /* check that 'structRstart.ppsize' is an integer */
  (void)((p->NoRenviron) | 0);  /* check that 'structRstart.NoRenviron' is an integer */
}
struct _cffi_align_typedef_structRstart { char x; structRstart y; };

static struct _cffi_externpy_s _cffi_externpy___busy =
  { "_rinterface_cffi_api._busy", 0, 0, 0 };

static void _busy(int a0)
{
  char a[8];
  char *p = a;
  *(int *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___busy, p);
}

static struct _cffi_externpy_s _cffi_externpy___callback =
  { "_rinterface_cffi_api._callback", 0, 0, 0 };

static void _callback(void)
{
  char a[8];
  char *p = a;
  _cffi_call_python(&_cffi_externpy___callback, p);
}

static struct _cffi_externpy_s _cffi_externpy___capsule_finalizer =
  { "_rinterface_cffi_api._capsule_finalizer", 0, 0, 0 };

static void _capsule_finalizer(struct SEXPREC * a0)
{
  char a[8];
  char *p = a;
  *(struct SEXPREC * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___capsule_finalizer, p);
}

static struct _cffi_externpy_s _cffi_externpy___choosefile =
  { "_rinterface_cffi_api._choosefile", (int)sizeof(int), 0, 0 };

static int _choosefile(int a0, char * a1, int a2)
{
  char a[24];
  char *p = a;
  *(int *)(p + 0) = a0;
  *(char * *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___choosefile, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___cleanup =
  { "_rinterface_cffi_api._cleanup", 0, 0, 0 };

static void _cleanup(SA_TYPE a0, int a1, int a2)
{
  char a[24];
  char *p = a;
  *(SA_TYPE *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___cleanup, p);
}

static struct _cffi_externpy_s _cffi_externpy___consoleflush =
  { "_rinterface_cffi_api._consoleflush", 0, 0, 0 };

static void _consoleflush(void)
{
  char a[8];
  char *p = a;
  _cffi_call_python(&_cffi_externpy___consoleflush, p);
}

static struct _cffi_externpy_s _cffi_externpy___consoleread =
  { "_rinterface_cffi_api._consoleread", (int)sizeof(int), 0, 0 };

static int _consoleread(char * a0, unsigned char * a1, int a2, int a3)
{
  char a[32];
  char *p = a;
  *(char * *)(p + 0) = a0;
  *(unsigned char * *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(int *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___consoleread, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___consolereset =
  { "_rinterface_cffi_api._consolereset", 0, 0, 0 };

static void _consolereset(void)
{
  char a[8];
  char *p = a;
  _cffi_call_python(&_cffi_externpy___consolereset, p);
}

static struct _cffi_externpy_s _cffi_externpy___consolewrite =
  { "_rinterface_cffi_api._consolewrite", 0, 0, 0 };

static void _consolewrite(char * a0, int a1)
{
  char a[16];
  char *p = a;
  *(char * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___consolewrite, p);
}

static struct _cffi_externpy_s _cffi_externpy___consolewrite_ex =
  { "_rinterface_cffi_api._consolewrite_ex", 0, 0, 0 };

static void _consolewrite_ex(char * a0, int a1, int a2)
{
  char a[24];
  char *p = a;
  *(char * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy___consolewrite_ex, p);
}

static struct _cffi_externpy_s _cffi_externpy___evaluate_in_r =
  { "_rinterface_cffi_api._evaluate_in_r", (int)sizeof(struct SEXPREC *), 0, 0 };

static struct SEXPREC * _evaluate_in_r(struct SEXPREC * a0)
{
  char a[8];
  char *p = a;
  *(struct SEXPREC * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___evaluate_in_r, p);
  return *(struct SEXPREC * *)p;
}

static struct _cffi_externpy_s _cffi_externpy___exec_findvar_in_frame =
  { "_rinterface_cffi_api._exec_findvar_in_frame", 0, 0, 0 };

static void _exec_findvar_in_frame(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___exec_findvar_in_frame, p);
}

static struct _cffi_externpy_s _cffi_externpy___handler_wrap =
  { "_rinterface_cffi_api._handler_wrap", (int)sizeof(struct SEXPREC *), 0, 0 };

static struct SEXPREC * _handler_wrap(struct SEXPREC * a0, void * a1)
{
  char a[16];
  char *p = a;
  *(struct SEXPREC * *)(p + 0) = a0;
  *(void * *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy___handler_wrap, p);
  return *(struct SEXPREC * *)p;
}

static struct _cffi_externpy_s _cffi_externpy___parsevector_wrap =
  { "_rinterface_cffi_api._parsevector_wrap", (int)sizeof(struct SEXPREC *), 0, 0 };

static struct SEXPREC * _parsevector_wrap(void * a0)
{
  char a[8];
  char *p = a;
  *(void * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___parsevector_wrap, p);
  return *(struct SEXPREC * *)p;
}

static struct _cffi_externpy_s _cffi_externpy___processevents =
  { "_rinterface_cffi_api._processevents", 0, 0, 0 };

static void _processevents(void)
{
  char a[8];
  char *p = a;
  _cffi_call_python(&_cffi_externpy___processevents, p);
}

static struct _cffi_externpy_s _cffi_externpy___showfiles =
  { "_rinterface_cffi_api._showfiles", (int)sizeof(int), 0, 0 };

static int _showfiles(int a0, char const * * a1, char const * * a2, char const * a3, Rboolean a4, char const * a5)
{
  char a[48];
  char *p = a;
  *(int *)(p + 0) = a0;
  *(char const * * *)(p + 8) = a1;
  *(char const * * *)(p + 16) = a2;
  *(char const * *)(p + 24) = a3;
  *(Rboolean *)(p + 32) = a4;
  *(char const * *)(p + 40) = a5;
  _cffi_call_python(&_cffi_externpy___showfiles, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy___showmessage =
  { "_rinterface_cffi_api._showmessage", 0, 0, 0 };

static void _showmessage(char * a0)
{
  char a[8];
  char *p = a;
  *(char * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___showmessage, p);
}

static struct _cffi_externpy_s _cffi_externpy___yesnocancel =
  { "_rinterface_cffi_api._yesnocancel", (int)sizeof(int), 0, 0 };

static int _yesnocancel(char * a0)
{
  char a[8];
  char *p = a;
  *(char * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy___yesnocancel, p);
  return *(int *)p;
}

static struct SEXPREC * _cffi_d_ATTRIB(struct SEXPREC * x0)
{
  return ATTRIB(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ATTRIB(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ATTRIB(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ATTRIB _cffi_d_ATTRIB
#endif

static struct SEXPREC * _cffi_d_CAR(struct SEXPREC * x0)
{
  return CAR(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_CAR(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CAR(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_CAR _cffi_d_CAR
#endif

static struct SEXPREC * _cffi_d_CDR(struct SEXPREC * x0)
{
  return CDR(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_CDR(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CDR(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_CDR _cffi_d_CDR
#endif

static struct SEXPREC * _cffi_d_CLOENV(struct SEXPREC * x0)
{
  return CLOENV(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_CLOENV(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = CLOENV(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_CLOENV _cffi_d_CLOENV
#endif

static Rcomplex * _cffi_d_COMPLEX(struct SEXPREC * x0)
{
  return COMPLEX(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_COMPLEX(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Rcomplex * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = COMPLEX(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(340));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_COMPLEX _cffi_d_COMPLEX
#endif

static Rcomplex _cffi_d_COMPLEX_ELT(struct SEXPREC * x0, ptrdiff_t x1)
{
  return COMPLEX_ELT(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_COMPLEX_ELT(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  ptrdiff_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Rcomplex result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "COMPLEX_ELT", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = COMPLEX_ELT(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_struct((char *)&result, _cffi_type(116));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
static void _cffi_f_COMPLEX_ELT(Rcomplex *result, struct SEXPREC * x0, ptrdiff_t x1)
{
  { *result = COMPLEX_ELT(x0, x1); }
}
#endif

static void * _cffi_d_DATAPTR(struct SEXPREC * x0)
{
  return DATAPTR(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_DATAPTR(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = DATAPTR(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_DATAPTR _cffi_d_DATAPTR
#endif

static struct SEXPREC * _cffi_d_ENCLOS(struct SEXPREC * x0)
{
  return ENCLOS(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENCLOS(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENCLOS(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ENCLOS _cffi_d_ENCLOS
#endif

static int _cffi_d_ENVFLAGS(struct SEXPREC * x0)
{
  return ENVFLAGS(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ENVFLAGS(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ENVFLAGS(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ENVFLAGS _cffi_d_ENVFLAGS
#endif

static struct SEXPREC * _cffi_d_FRAME(struct SEXPREC * x0)
{
  return FRAME(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_FRAME(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = FRAME(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_FRAME _cffi_d_FRAME
#endif

static struct SEXPREC * _cffi_d_HASHTAB(struct SEXPREC * x0)
{
  return HASHTAB(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_HASHTAB(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = HASHTAB(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_HASHTAB _cffi_d_HASHTAB
#endif

static int * _cffi_d_INTEGER(struct SEXPREC * x0)
{
  return INTEGER(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_INTEGER(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = INTEGER(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(187));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_INTEGER _cffi_d_INTEGER
#endif

static int _cffi_d_INTEGER_ELT(struct SEXPREC * x0, ptrdiff_t x1)
{
  return INTEGER_ELT(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_INTEGER_ELT(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  ptrdiff_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "INTEGER_ELT", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = INTEGER_ELT(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_INTEGER_ELT _cffi_d_INTEGER_ELT
#endif

static int * _cffi_d_LOGICAL(struct SEXPREC * x0)
{
  return LOGICAL(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_LOGICAL(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = LOGICAL(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(187));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_LOGICAL _cffi_d_LOGICAL
#endif

static int _cffi_d_LOGICAL_ELT(struct SEXPREC * x0, ptrdiff_t x1)
{
  return LOGICAL_ELT(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_LOGICAL_ELT(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  ptrdiff_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "LOGICAL_ELT", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = LOGICAL_ELT(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_LOGICAL_ELT _cffi_d_LOGICAL_ELT
#endif

static struct SEXPREC * _cffi_d_PRINTNAME(struct SEXPREC * x0)
{
  return PRINTNAME(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_PRINTNAME(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = PRINTNAME(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_PRINTNAME _cffi_d_PRINTNAME
#endif

static unsigned char * _cffi_d_RAW(struct SEXPREC * x0)
{
  return RAW(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_RAW(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAW(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(58));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_RAW _cffi_d_RAW
#endif

static unsigned char _cffi_d_RAW_ELT(struct SEXPREC * x0, ptrdiff_t x1)
{
  return RAW_ELT(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_RAW_ELT(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  ptrdiff_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "RAW_ELT", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = RAW_ELT(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_RAW_ELT _cffi_d_RAW_ELT
#endif

static double * _cffi_d_REAL(struct SEXPREC * x0)
{
  return REAL(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_REAL(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  double * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = REAL(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(347));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_REAL _cffi_d_REAL
#endif

static double _cffi_d_REAL_ELT(struct SEXPREC * x0, ptrdiff_t x1)
{
  return REAL_ELT(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_REAL_ELT(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  ptrdiff_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  double result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "REAL_ELT", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = REAL_ELT(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_double(result);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_REAL_ELT _cffi_d_REAL_ELT
#endif

static char const * _cffi_d_R_CHAR(struct SEXPREC * x0)
{
  return R_CHAR(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_CHAR(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_CHAR(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(63));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_CHAR _cffi_d_R_CHAR
#endif

static void _cffi_d_R_CleanTempDir(void)
{
  R_CleanTempDir();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_CleanTempDir(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { R_CleanTempDir(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_R_CleanTempDir _cffi_d_R_CleanTempDir
#endif

static void _cffi_d_R_ClearExternalPtr(struct SEXPREC * x0)
{
  R_ClearExternalPtr(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_ClearExternalPtr(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { R_ClearExternalPtr(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_R_ClearExternalPtr _cffi_d_R_ClearExternalPtr
#endif

static void _cffi_d_R_DefParams(structRstart * x0)
{
  R_DefParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_DefParams(PyObject *self, PyObject *arg0)
{
  structRstart * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(322), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (structRstart *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(322), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { R_DefParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_R_DefParams _cffi_d_R_DefParams
#endif

static Rboolean _cffi_d_R_EnvironmentIsLocked(struct SEXPREC * x0)
{
  return R_EnvironmentIsLocked(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_EnvironmentIsLocked(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Rboolean result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_EnvironmentIsLocked(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(91));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_EnvironmentIsLocked _cffi_d_R_EnvironmentIsLocked
#endif

static void * _cffi_d_R_ExternalPtrAddr(struct SEXPREC * x0)
{
  return R_ExternalPtrAddr(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_ExternalPtrAddr(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_ExternalPtrAddr(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_ExternalPtrAddr _cffi_d_R_ExternalPtrAddr
#endif

static struct SEXPREC * _cffi_d_R_MakeExternalPtr(void *(* x0)(void), struct SEXPREC * x1, struct SEXPREC * x2)
{
  return R_MakeExternalPtr(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_MakeExternalPtr(PyObject *self, PyObject *args)
{
  void *(* x0)(void);
  struct SEXPREC * x1;
  struct SEXPREC * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "R_MakeExternalPtr", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = (void *(*)(void))_cffi_to_c_pointer(arg0, _cffi_type(227));
  if (x0 == (void *(*)(void))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_MakeExternalPtr(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_MakeExternalPtr _cffi_d_R_MakeExternalPtr
#endif

static struct SEXPREC * _cffi_d_R_ParseVector(struct SEXPREC * x0, int x1, ParseStatus * x2, struct SEXPREC * x3)
{
  return R_ParseVector(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_ParseVector(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  int x1;
  ParseStatus * x2;
  struct SEXPREC * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "R_ParseVector", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(163), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ParseStatus *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(163), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_ParseVector(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_ParseVector _cffi_d_R_ParseVector
#endif

static void _cffi_d_R_PreserveObject(struct SEXPREC * x0)
{
  R_PreserveObject(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_PreserveObject(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { R_PreserveObject(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_R_PreserveObject _cffi_d_R_PreserveObject
#endif

static void _cffi_d_R_RegisterCFinalizer(struct SEXPREC * x0, void(* x1)(struct SEXPREC *))
{
  R_RegisterCFinalizer(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_RegisterCFinalizer(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  void(* x1)(struct SEXPREC *);
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "R_RegisterCFinalizer", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (void(*)(struct SEXPREC *))_cffi_to_c_pointer(arg1, _cffi_type(319));
  if (x1 == (void(*)(struct SEXPREC *))NULL && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { R_RegisterCFinalizer(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_R_RegisterCFinalizer _cffi_d_R_RegisterCFinalizer
#endif

static void _cffi_d_R_ReleaseObject(struct SEXPREC * x0)
{
  R_ReleaseObject(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_ReleaseObject(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { R_ReleaseObject(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_R_ReleaseObject _cffi_d_R_ReleaseObject
#endif

static void _cffi_d_R_RunExitFinalizers(void)
{
  R_RunExitFinalizers();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_RunExitFinalizers(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { R_RunExitFinalizers(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_R_RunExitFinalizers _cffi_d_R_RunExitFinalizers
#endif

static void _cffi_d_R_SetParams(structRstart * x0)
{
  R_SetParams(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_SetParams(PyObject *self, PyObject *arg0)
{
  structRstart * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(322), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (structRstart *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(322), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { R_SetParams(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_R_SetParams _cffi_d_R_SetParams
#endif

static Rboolean _cffi_d_R_ToplevelExec(void(* x0)(void *), void * x1)
{
  return R_ToplevelExec(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_ToplevelExec(PyObject *self, PyObject *args)
{
  void(* x0)(void *);
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Rboolean result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "R_ToplevelExec", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = (void(*)(void *))_cffi_to_c_pointer(arg0, _cffi_type(9));
  if (x0 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_ToplevelExec(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(91));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_ToplevelExec _cffi_d_R_ToplevelExec
#endif

static struct SEXPREC * _cffi_d_R_UnwindProtect(struct SEXPREC *(* x0)(void *), void * x1, void(* x2)(void *, Rboolean), void * x3, struct SEXPREC * x4)
{
  return R_UnwindProtect(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_UnwindProtect(PyObject *self, PyObject *args)
{
  struct SEXPREC *(* x0)(void *);
  void * x1;
  void(* x2)(void *, Rboolean);
  void * x3;
  struct SEXPREC * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "R_UnwindProtect", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  x0 = (struct SEXPREC *(*)(void *))_cffi_to_c_pointer(arg0, _cffi_type(137));
  if (x0 == (struct SEXPREC *(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (void(*)(void *, Rboolean))_cffi_to_c_pointer(arg2, _cffi_type(145));
  if (x2 == (void(*)(void *, Rboolean))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_UnwindProtect(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_UnwindProtect _cffi_d_R_UnwindProtect
#endif

static struct SEXPREC * _cffi_d_R_do_slot(struct SEXPREC * x0, struct SEXPREC * x1)
{
  return R_do_slot(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_do_slot(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "R_do_slot", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_do_slot(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_do_slot _cffi_d_R_do_slot
#endif

static struct SEXPREC * _cffi_d_R_do_slot_assign(struct SEXPREC * x0, struct SEXPREC * x1, struct SEXPREC * x2)
{
  return R_do_slot_assign(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_do_slot_assign(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  struct SEXPREC * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "R_do_slot_assign", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_do_slot_assign(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_do_slot_assign _cffi_d_R_do_slot_assign
#endif

static void _cffi_d_R_dot_Last(void)
{
  R_dot_Last();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_dot_Last(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { R_dot_Last(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_R_dot_Last _cffi_d_R_dot_Last
#endif

static void _cffi_d_R_gc(void)
{
  R_gc();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_gc(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { R_gc(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_R_gc _cffi_d_R_gc
#endif

static DllInfo * _cffi_d_R_getEmbeddingDllInfo(void)
{
  return R_getEmbeddingDllInfo();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_getEmbeddingDllInfo(PyObject *self, PyObject *noarg)
{
  DllInfo * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_getEmbeddingDllInfo(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(43));
  return pyresult;
}
#else
#  define _cffi_f_R_getEmbeddingDllInfo _cffi_d_R_getEmbeddingDllInfo
#endif

static int _cffi_d_R_has_slot(struct SEXPREC * x0, struct SEXPREC * x1)
{
  return R_has_slot(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_has_slot(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "R_has_slot", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_has_slot(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_has_slot _cffi_d_R_has_slot
#endif

static struct SEXPREC * _cffi_d_R_lsInternal(struct SEXPREC * x0, Rboolean x1)
{
  return R_lsInternal(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_lsInternal(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  Rboolean x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "R_lsInternal", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(91), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_lsInternal(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_lsInternal _cffi_d_R_lsInternal
#endif

static int _cffi_d_R_nchar(struct SEXPREC * x0, nchar_type x1, Rboolean x2, Rboolean x3, char const * x4)
{
  return R_nchar(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_nchar(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  nchar_type x1;
  Rboolean x2;
  Rboolean x3;
  char const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "R_nchar", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(99), arg1) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(91), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(91), arg3) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_nchar(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_nchar _cffi_d_R_nchar
#endif

static int _cffi_d_R_registerRoutines(DllInfo * x0, R_CMethodDef const * x1, R_CallMethodDef const * x2, R_CMethodDef const * x3, R_CallMethodDef const * x4)
{
  return R_registerRoutines(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_registerRoutines(PyObject *self, PyObject *args)
{
  DllInfo * x0;
  R_CMethodDef const * x1;
  R_CallMethodDef const * x2;
  R_CMethodDef const * x3;
  R_CallMethodDef const * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "R_registerRoutines", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (DllInfo *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(43), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(44), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (R_CMethodDef const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(44), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (R_CallMethodDef const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(44), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (R_CMethodDef const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(44), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(45), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (R_CallMethodDef const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(45), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_registerRoutines(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_registerRoutines _cffi_d_R_registerRoutines
#endif

static void _cffi_d_R_set_command_line_arguments(int x0, char * * x1)
{
  R_set_command_line_arguments(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_set_command_line_arguments(PyObject *self, PyObject *args)
{
  int x0;
  char * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "R_set_command_line_arguments", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(73), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(73), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { R_set_command_line_arguments(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_R_set_command_line_arguments _cffi_d_R_set_command_line_arguments
#endif

static struct SEXPREC * _cffi_d_R_tryCatchError(struct SEXPREC *(* x0)(void *), void * x1, struct SEXPREC *(* x2)(struct SEXPREC *, void *), void * x3)
{
  return R_tryCatchError(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_tryCatchError(PyObject *self, PyObject *args)
{
  struct SEXPREC *(* x0)(void *);
  void * x1;
  struct SEXPREC *(* x2)(struct SEXPREC *, void *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "R_tryCatchError", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = (struct SEXPREC *(*)(void *))_cffi_to_c_pointer(arg0, _cffi_type(137));
  if (x0 == (struct SEXPREC *(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (struct SEXPREC *(*)(struct SEXPREC *, void *))_cffi_to_c_pointer(arg2, _cffi_type(139));
  if (x2 == (struct SEXPREC *(*)(struct SEXPREC *, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(17), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(17), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_tryCatchError(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_tryCatchError _cffi_d_R_tryCatchError
#endif

static struct SEXPREC * _cffi_d_R_tryEval(struct SEXPREC * x0, struct SEXPREC * x1, int * x2)
{
  return R_tryEval(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_tryEval(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "R_tryEval", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(187), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(187), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_tryEval(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_tryEval _cffi_d_R_tryEval
#endif

static void _cffi_d_Rf_KillAllDevices(void)
{
  Rf_KillAllDevices();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_KillAllDevices(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { Rf_KillAllDevices(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_Rf_KillAllDevices _cffi_d_Rf_KillAllDevices
#endif

static struct SEXPREC * _cffi_d_Rf_ScalarComplex(Rcomplex x0)
{
  return Rf_ScalarComplex(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_ScalarComplex(PyObject *self, PyObject *arg0)
{
  Rcomplex x0;
  struct SEXPREC * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(116), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_ScalarComplex(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  return pyresult;
}
#else
static struct SEXPREC * _cffi_f_Rf_ScalarComplex(Rcomplex *x0)
{
  struct SEXPREC * result;
  { result = Rf_ScalarComplex(*x0); }
  return result;
}
#endif

static struct SEXPREC * _cffi_d_Rf_ScalarInteger(int x0)
{
  return Rf_ScalarInteger(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_ScalarInteger(PyObject *self, PyObject *arg0)
{
  int x0;
  struct SEXPREC * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_ScalarInteger(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  return pyresult;
}
#else
#  define _cffi_f_Rf_ScalarInteger _cffi_d_Rf_ScalarInteger
#endif

static struct SEXPREC * _cffi_d_Rf_ScalarLogical(int x0)
{
  return Rf_ScalarLogical(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_ScalarLogical(PyObject *self, PyObject *arg0)
{
  int x0;
  struct SEXPREC * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_ScalarLogical(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  return pyresult;
}
#else
#  define _cffi_f_Rf_ScalarLogical _cffi_d_Rf_ScalarLogical
#endif

static struct SEXPREC * _cffi_d_Rf_ScalarRaw(unsigned char x0)
{
  return Rf_ScalarRaw(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_ScalarRaw(PyObject *self, PyObject *arg0)
{
  unsigned char x0;
  struct SEXPREC * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, unsigned char);
  if (x0 == (unsigned char)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_ScalarRaw(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  return pyresult;
}
#else
#  define _cffi_f_Rf_ScalarRaw _cffi_d_Rf_ScalarRaw
#endif

static struct SEXPREC * _cffi_d_Rf_ScalarReal(double x0)
{
  return Rf_ScalarReal(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_ScalarReal(PyObject *self, PyObject *arg0)
{
  double x0;
  struct SEXPREC * result;
  PyObject *pyresult;

  x0 = (double)_cffi_to_c_double(arg0);
  if (x0 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_ScalarReal(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  return pyresult;
}
#else
#  define _cffi_f_Rf_ScalarReal _cffi_d_Rf_ScalarReal
#endif

static struct SEXPREC * _cffi_d_Rf_ScalarString(struct SEXPREC * x0)
{
  return Rf_ScalarString(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_ScalarString(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_ScalarString(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_ScalarString _cffi_d_Rf_ScalarString
#endif

static struct SEXPREC * _cffi_d_Rf_allocList(int x0)
{
  return Rf_allocList(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_allocList(PyObject *self, PyObject *arg0)
{
  int x0;
  struct SEXPREC * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_allocList(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  return pyresult;
}
#else
#  define _cffi_f_Rf_allocList _cffi_d_Rf_allocList
#endif

static struct SEXPREC * _cffi_d_Rf_allocVector(unsigned int x0, ptrdiff_t x1)
{
  return Rf_allocVector(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_allocVector(PyObject *self, PyObject *args)
{
  unsigned int x0;
  ptrdiff_t x1;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_allocVector", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, unsigned int);
  if (x0 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_allocVector(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  return pyresult;
}
#else
#  define _cffi_f_Rf_allocVector _cffi_d_Rf_allocVector
#endif

static struct SEXPREC * _cffi_d_Rf_asChar(struct SEXPREC * x0)
{
  return Rf_asChar(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_asChar(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_asChar(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_asChar _cffi_d_Rf_asChar
#endif

static struct SEXPREC * _cffi_d_Rf_defineVar(struct SEXPREC * x0, struct SEXPREC * x1, struct SEXPREC * x2)
{
  return Rf_defineVar(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_defineVar(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  struct SEXPREC * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Rf_defineVar", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_defineVar(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_defineVar _cffi_d_Rf_defineVar
#endif

static struct SEXPREC * _cffi_d_Rf_duplicate(struct SEXPREC * x0)
{
  return Rf_duplicate(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_duplicate(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_duplicate(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_duplicate _cffi_d_Rf_duplicate
#endif

static struct SEXPREC * _cffi_d_Rf_elt(struct SEXPREC * x0, int x1)
{
  return Rf_elt(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_elt(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_elt", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_elt(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_elt _cffi_d_Rf_elt
#endif

static void _cffi_d_Rf_endEmbeddedR(int x0)
{
  Rf_endEmbeddedR(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_endEmbeddedR(PyObject *self, PyObject *arg0)
{
  int x0;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { Rf_endEmbeddedR(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_Rf_endEmbeddedR _cffi_d_Rf_endEmbeddedR
#endif

static struct SEXPREC * _cffi_d_Rf_eval(struct SEXPREC * x0, struct SEXPREC * x1)
{
  return Rf_eval(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_eval(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_eval", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_eval(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_eval _cffi_d_Rf_eval
#endif

static struct SEXPREC * _cffi_d_Rf_findFun(struct SEXPREC * x0, struct SEXPREC * x1)
{
  return Rf_findFun(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_findFun(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_findFun", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_findFun(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_findFun _cffi_d_Rf_findFun
#endif

static struct SEXPREC * _cffi_d_Rf_findVar(struct SEXPREC * x0, struct SEXPREC * x1)
{
  return Rf_findVar(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_findVar(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_findVar", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_findVar(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_findVar _cffi_d_Rf_findVar
#endif

static struct SEXPREC * _cffi_d_Rf_findVarInFrame(struct SEXPREC * x0, struct SEXPREC * x1)
{
  return Rf_findVarInFrame(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_findVarInFrame(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_findVarInFrame", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_findVarInFrame(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_findVarInFrame _cffi_d_Rf_findVarInFrame
#endif

static struct SEXPREC * _cffi_d_Rf_findVarInFrame3(struct SEXPREC * x0, struct SEXPREC * x1, Rboolean x2)
{
  return Rf_findVarInFrame3(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_findVarInFrame3(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Rboolean x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Rf_findVarInFrame3", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(91), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_findVarInFrame3(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_findVarInFrame3 _cffi_d_Rf_findVarInFrame3
#endif

static struct SEXPREC * _cffi_d_Rf_getAttrib(struct SEXPREC * x0, struct SEXPREC * x1)
{
  return Rf_getAttrib(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_getAttrib(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_getAttrib", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_getAttrib(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_getAttrib _cffi_d_Rf_getAttrib
#endif

static cetype_t _cffi_d_Rf_getCharCE(struct SEXPREC * x0)
{
  return Rf_getCharCE(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_getCharCE(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  cetype_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_getCharCE(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(123));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_getCharCE _cffi_d_Rf_getCharCE
#endif

static int _cffi_d_Rf_initEmbeddedR(int x0, char * * x1)
{
  return Rf_initEmbeddedR(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_initEmbeddedR(PyObject *self, PyObject *args)
{
  int x0;
  char * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_initEmbeddedR", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(73), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(73), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_initEmbeddedR(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_initEmbeddedR _cffi_d_Rf_initEmbeddedR
#endif

static int _cffi_d_Rf_initialize_R(int x0, char * * x1)
{
  return Rf_initialize_R(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_initialize_R(PyObject *self, PyObject *args)
{
  int x0;
  char * * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_initialize_R", 2, 2, &arg0, &arg1))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(73), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(73), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_initialize_R(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_initialize_R _cffi_d_Rf_initialize_R
#endif

static struct SEXPREC * _cffi_d_Rf_install(char const * x0)
{
  return Rf_install(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_install(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_install(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_install _cffi_d_Rf_install
#endif

static struct SEXPREC * _cffi_d_Rf_installChar(struct SEXPREC * x0)
{
  return Rf_installChar(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_installChar(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_installChar(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_installChar _cffi_d_Rf_installChar
#endif

static Rboolean _cffi_d_Rf_isList(struct SEXPREC * x0)
{
  return Rf_isList(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_isList(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Rboolean result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_isList(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(91));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_isList _cffi_d_Rf_isList
#endif

static Rboolean _cffi_d_Rf_isNull(struct SEXPREC * x0)
{
  return Rf_isNull(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_isNull(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Rboolean result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_isNull(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(91));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_isNull _cffi_d_Rf_isNull
#endif

static Rboolean _cffi_d_Rf_isSymbol(struct SEXPREC * x0)
{
  return Rf_isSymbol(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_isSymbol(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  Rboolean result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_isSymbol(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(91));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_isSymbol _cffi_d_Rf_isSymbol
#endif

static struct SEXPREC * _cffi_d_Rf_lang1(struct SEXPREC * x0)
{
  return Rf_lang1(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_lang1(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_lang1(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_lang1 _cffi_d_Rf_lang1
#endif

static struct SEXPREC * _cffi_d_Rf_lang2(struct SEXPREC * x0, struct SEXPREC * x1)
{
  return Rf_lang2(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_lang2(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_lang2", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_lang2(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_lang2 _cffi_d_Rf_lang2
#endif

static struct SEXPREC * _cffi_d_Rf_lang3(struct SEXPREC * x0, struct SEXPREC * x1, struct SEXPREC * x2)
{
  return Rf_lang3(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_lang3(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  struct SEXPREC * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Rf_lang3", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_lang3(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_lang3 _cffi_d_Rf_lang3
#endif

static struct SEXPREC * _cffi_d_Rf_lang4(struct SEXPREC * x0, struct SEXPREC * x1, struct SEXPREC * x2, struct SEXPREC * x3)
{
  return Rf_lang4(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_lang4(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  struct SEXPREC * x2;
  struct SEXPREC * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "Rf_lang4", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_lang4(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_lang4 _cffi_d_Rf_lang4
#endif

static struct SEXPREC * _cffi_d_Rf_lang5(struct SEXPREC * x0, struct SEXPREC * x1, struct SEXPREC * x2, struct SEXPREC * x3, struct SEXPREC * x4)
{
  return Rf_lang5(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_lang5(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  struct SEXPREC * x2;
  struct SEXPREC * x3;
  struct SEXPREC * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "Rf_lang5", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_lang5(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_lang5 _cffi_d_Rf_lang5
#endif

static struct SEXPREC * _cffi_d_Rf_lang6(struct SEXPREC * x0, struct SEXPREC * x1, struct SEXPREC * x2, struct SEXPREC * x3, struct SEXPREC * x4, struct SEXPREC * x5)
{
  return Rf_lang6(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_lang6(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  struct SEXPREC * x2;
  struct SEXPREC * x3;
  struct SEXPREC * x4;
  struct SEXPREC * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "Rf_lang6", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_lang6(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_lang6 _cffi_d_Rf_lang6
#endif

static int _cffi_d_Rf_length(struct SEXPREC * x0)
{
  return Rf_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_length(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_length _cffi_d_Rf_length
#endif

static void _cffi_d_Rf_mainloop(void)
{
  Rf_mainloop();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_mainloop(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { Rf_mainloop(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_Rf_mainloop _cffi_d_Rf_mainloop
#endif

static struct SEXPREC * _cffi_d_Rf_mkChar(char const * x0)
{
  return Rf_mkChar(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_mkChar(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_mkChar(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_mkChar _cffi_d_Rf_mkChar
#endif

static struct SEXPREC * _cffi_d_Rf_mkCharCE(char const * x0, cetype_t x1)
{
  return Rf_mkCharCE(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_mkCharCE(PyObject *self, PyObject *args)
{
  char const * x0;
  cetype_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_mkCharCE", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(123), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_mkCharCE(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_mkCharCE _cffi_d_Rf_mkCharCE
#endif

static struct SEXPREC * _cffi_d_Rf_mkCharLenCE(char const * x0, int x1, cetype_t x2)
{
  return Rf_mkCharLenCE(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_mkCharLenCE(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  cetype_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Rf_mkCharLenCE", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x2, _cffi_type(123), arg2) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_mkCharLenCE(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_mkCharLenCE _cffi_d_Rf_mkCharLenCE
#endif

static struct SEXPREC * _cffi_d_Rf_mkString(char const * x0)
{
  return Rf_mkString(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_mkString(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_mkString(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_mkString _cffi_d_Rf_mkString
#endif

static struct SEXPREC * _cffi_d_Rf_namesgets(struct SEXPREC * x0, struct SEXPREC * x1)
{
  return Rf_namesgets(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_namesgets(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_namesgets", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_namesgets(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_namesgets _cffi_d_Rf_namesgets
#endif

static struct SEXPREC * _cffi_d_Rf_nthcdr(struct SEXPREC * x0, int x1)
{
  return Rf_nthcdr(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_nthcdr(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "Rf_nthcdr", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_nthcdr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_nthcdr _cffi_d_Rf_nthcdr
#endif

static struct SEXPREC * _cffi_d_Rf_protect(struct SEXPREC * x0)
{
  return Rf_protect(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_protect(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_protect(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_protect _cffi_d_Rf_protect
#endif

static struct SEXPREC * _cffi_d_Rf_setAttrib(struct SEXPREC * x0, struct SEXPREC * x1, struct SEXPREC * x2)
{
  return Rf_setAttrib(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_setAttrib(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  struct SEXPREC * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "Rf_setAttrib", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_setAttrib(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_setAttrib _cffi_d_Rf_setAttrib
#endif

static void _cffi_d_Rf_unprotect(int x0)
{
  Rf_unprotect(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_unprotect(PyObject *self, PyObject *arg0)
{
  int x0;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { Rf_unprotect(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_Rf_unprotect _cffi_d_Rf_unprotect
#endif

static ptrdiff_t _cffi_d_Rf_xlength(struct SEXPREC * x0)
{
  return Rf_xlength(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_Rf_xlength(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ptrdiff_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = Rf_xlength(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, ptrdiff_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_Rf_xlength _cffi_d_Rf_xlength
#endif

static struct SEXPREC * _cffi_d_SETCAR(struct SEXPREC * x0, struct SEXPREC * x1)
{
  return SETCAR(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SETCAR(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SETCAR", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SETCAR(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SETCAR _cffi_d_SETCAR
#endif

static struct SEXPREC * _cffi_d_SETCDR(struct SEXPREC * x0, struct SEXPREC * x1)
{
  return SETCDR(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SETCDR(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SETCDR", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SETCDR(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SETCDR _cffi_d_SETCDR
#endif

static void _cffi_d_SET_ENCLOS(struct SEXPREC * x0, struct SEXPREC * x1)
{
  SET_ENCLOS(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SET_ENCLOS(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SET_ENCLOS", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SET_ENCLOS(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SET_ENCLOS _cffi_d_SET_ENCLOS
#endif

static void _cffi_d_SET_ENVFLAGS(struct SEXPREC * x0, int x1)
{
  SET_ENVFLAGS(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SET_ENVFLAGS(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SET_ENVFLAGS", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SET_ENVFLAGS(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SET_ENVFLAGS _cffi_d_SET_ENVFLAGS
#endif

static void _cffi_d_SET_FRAME(struct SEXPREC * x0, struct SEXPREC * x1)
{
  SET_FRAME(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SET_FRAME(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SET_FRAME", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SET_FRAME(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SET_FRAME _cffi_d_SET_FRAME
#endif

static void _cffi_d_SET_HASHTAB(struct SEXPREC * x0, struct SEXPREC * x1)
{
  SET_HASHTAB(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SET_HASHTAB(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SET_HASHTAB", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SET_HASHTAB(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SET_HASHTAB _cffi_d_SET_HASHTAB
#endif

static void _cffi_d_SET_INTEGER_ELT(struct SEXPREC * x0, ptrdiff_t x1, int x2)
{
  SET_INTEGER_ELT(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SET_INTEGER_ELT(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  ptrdiff_t x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SET_INTEGER_ELT", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SET_INTEGER_ELT(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SET_INTEGER_ELT _cffi_d_SET_INTEGER_ELT
#endif

static void _cffi_d_SET_LOGICAL_ELT(struct SEXPREC * x0, ptrdiff_t x1, int x2)
{
  SET_LOGICAL_ELT(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SET_LOGICAL_ELT(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  ptrdiff_t x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SET_LOGICAL_ELT", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SET_LOGICAL_ELT(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SET_LOGICAL_ELT _cffi_d_SET_LOGICAL_ELT
#endif

static void _cffi_d_SET_REAL_ELT(struct SEXPREC * x0, ptrdiff_t x1, double x2)
{
  SET_REAL_ELT(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SET_REAL_ELT(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  ptrdiff_t x1;
  double x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SET_REAL_ELT", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = (double)_cffi_to_c_double(arg2);
  if (x2 == (double)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SET_REAL_ELT(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SET_REAL_ELT _cffi_d_SET_REAL_ELT
#endif

static void _cffi_d_SET_STRING_ELT(struct SEXPREC * x0, ptrdiff_t x1, struct SEXPREC * x2)
{
  SET_STRING_ELT(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SET_STRING_ELT(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  ptrdiff_t x1;
  struct SEXPREC * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SET_STRING_ELT", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { SET_STRING_ELT(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_SET_STRING_ELT _cffi_d_SET_STRING_ELT
#endif

static struct SEXPREC * _cffi_d_SET_TAG(struct SEXPREC * x0, struct SEXPREC * x1)
{
  return SET_TAG(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SET_TAG(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  struct SEXPREC * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "SET_TAG", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SET_TAG(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SET_TAG _cffi_d_SET_TAG
#endif

static struct SEXPREC * _cffi_d_SET_VECTOR_ELT(struct SEXPREC * x0, ptrdiff_t x1, struct SEXPREC * x2)
{
  return SET_VECTOR_ELT(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_SET_VECTOR_ELT(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  ptrdiff_t x1;
  struct SEXPREC * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "SET_VECTOR_ELT", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = SET_VECTOR_ELT(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_SET_VECTOR_ELT _cffi_d_SET_VECTOR_ELT
#endif

static void * _cffi_d_STDVEC_DATAPTR(struct SEXPREC * x0)
{
  return STDVEC_DATAPTR(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_STDVEC_DATAPTR(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = STDVEC_DATAPTR(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(17));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_STDVEC_DATAPTR _cffi_d_STDVEC_DATAPTR
#endif

static struct SEXPREC * _cffi_d_STRING_ELT(struct SEXPREC * x0, ptrdiff_t x1)
{
  return STRING_ELT(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_STRING_ELT(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  ptrdiff_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "STRING_ELT", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = STRING_ELT(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_STRING_ELT _cffi_d_STRING_ELT
#endif

static struct SEXPREC * _cffi_d_TAG(struct SEXPREC * x0)
{
  return TAG(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_TAG(PyObject *self, PyObject *arg0)
{
  struct SEXPREC * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = TAG(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_TAG _cffi_d_TAG
#endif

static struct SEXPREC * _cffi_d_VECTOR_ELT(struct SEXPREC * x0, ptrdiff_t x1)
{
  return VECTOR_ELT(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_VECTOR_ELT(PyObject *self, PyObject *args)
{
  struct SEXPREC * x0;
  ptrdiff_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "VECTOR_ELT", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(13), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(13), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ptrdiff_t);
  if (x1 == (ptrdiff_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = VECTOR_ELT(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(13));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_VECTOR_ELT _cffi_d_VECTOR_ELT
#endif

static InputHandler * _cffi_d_addInputHandler(InputHandler * x0, int x1, void(* x2)(void *), int x3)
{
  return addInputHandler(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_addInputHandler(PyObject *self, PyObject *args)
{
  InputHandler * x0;
  int x1;
  void(* x2)(void *);
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  InputHandler * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "addInputHandler", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (InputHandler *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = (void(*)(void *))_cffi_to_c_pointer(arg2, _cffi_type(9));
  if (x2 == (void(*)(void *))NULL && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = addInputHandler(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(3));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_addInputHandler _cffi_d_addInputHandler
#endif

static InputHandler * _cffi_d_getInputHandler(InputHandler * x0, int x1)
{
  return getInputHandler(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_getInputHandler(PyObject *self, PyObject *args)
{
  InputHandler * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  InputHandler * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "getInputHandler", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (InputHandler *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = getInputHandler(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(3));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_getInputHandler _cffi_d_getInputHandler
#endif

static int _cffi_d_removeInputHandler(InputHandler * * x0, InputHandler * x1)
{
  return removeInputHandler(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_removeInputHandler(PyObject *self, PyObject *args)
{
  InputHandler * * x0;
  InputHandler * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "removeInputHandler", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(50), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (InputHandler * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(50), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (InputHandler *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = removeInputHandler(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_removeInputHandler _cffi_d_removeInputHandler
#endif

static void _cffi_d_rpy2_runHandlers(InputHandler * x0)
{
  rpy2_runHandlers(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_rpy2_runHandlers(PyObject *self, PyObject *arg0)
{
  InputHandler * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (InputHandler *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { rpy2_runHandlers(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_rpy2_runHandlers _cffi_d_rpy2_runHandlers
#endif

static void _cffi_d_run_Rmainloop(void)
{
  run_Rmainloop();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_run_Rmainloop(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { run_Rmainloop(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_run_Rmainloop _cffi_d_run_Rmainloop
#endif

static void _cffi_d_setup_Rmainloop(void)
{
  setup_Rmainloop();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_setup_Rmainloop(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { setup_Rmainloop(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_setup_Rmainloop _cffi_d_setup_Rmainloop
#endif

static int _cffi_const_ANYSXP(unsigned long long *o)
{
  int n = (ANYSXP) <= 0;
  *o = (unsigned long long)((ANYSXP) | 0);  /* check that ANYSXP is an integer */
  if (!_cffi_check_int(*o, n, 18U))
    n |= 2;
  return n;
}

static int _cffi_const_BCODESXP(unsigned long long *o)
{
  int n = (BCODESXP) <= 0;
  *o = (unsigned long long)((BCODESXP) | 0);  /* check that BCODESXP is an integer */
  if (!_cffi_check_int(*o, n, 21U))
    n |= 2;
  return n;
}

static int _cffi_const_BUILTINSXP(unsigned long long *o)
{
  int n = (BUILTINSXP) <= 0;
  *o = (unsigned long long)((BUILTINSXP) | 0);  /* check that BUILTINSXP is an integer */
  if (!_cffi_check_int(*o, n, 8U))
    n |= 2;
  return n;
}

static int _cffi_const_CHARSXP(unsigned long long *o)
{
  int n = (CHARSXP) <= 0;
  *o = (unsigned long long)((CHARSXP) | 0);  /* check that CHARSXP is an integer */
  if (!_cffi_check_int(*o, n, 9U))
    n |= 2;
  return n;
}

static int _cffi_const_CLOSXP(unsigned long long *o)
{
  int n = (CLOSXP) <= 0;
  *o = (unsigned long long)((CLOSXP) | 0);  /* check that CLOSXP is an integer */
  if (!_cffi_check_int(*o, n, 3U))
    n |= 2;
  return n;
}

static int _cffi_const_CPLXSXP(unsigned long long *o)
{
  int n = (CPLXSXP) <= 0;
  *o = (unsigned long long)((CPLXSXP) | 0);  /* check that CPLXSXP is an integer */
  if (!_cffi_check_int(*o, n, 15U))
    n |= 2;
  return n;
}

static int _cffi_const_DOTSXP(unsigned long long *o)
{
  int n = (DOTSXP) <= 0;
  *o = (unsigned long long)((DOTSXP) | 0);  /* check that DOTSXP is an integer */
  if (!_cffi_check_int(*o, n, 17U))
    n |= 2;
  return n;
}

static int _cffi_const_ENVSXP(unsigned long long *o)
{
  int n = (ENVSXP) <= 0;
  *o = (unsigned long long)((ENVSXP) | 0);  /* check that ENVSXP is an integer */
  if (!_cffi_check_int(*o, n, 4U))
    n |= 2;
  return n;
}

static int _cffi_const_EXPRSXP(unsigned long long *o)
{
  int n = (EXPRSXP) <= 0;
  *o = (unsigned long long)((EXPRSXP) | 0);  /* check that EXPRSXP is an integer */
  if (!_cffi_check_int(*o, n, 20U))
    n |= 2;
  return n;
}

static int _cffi_const_EXTPTRSXP(unsigned long long *o)
{
  int n = (EXTPTRSXP) <= 0;
  *o = (unsigned long long)((EXTPTRSXP) | 0);  /* check that EXTPTRSXP is an integer */
  if (!_cffi_check_int(*o, n, 22U))
    n |= 2;
  return n;
}

static int _cffi_const_FREESXP(unsigned long long *o)
{
  int n = (FREESXP) <= 0;
  *o = (unsigned long long)((FREESXP) | 0);  /* check that FREESXP is an integer */
  if (!_cffi_check_int(*o, n, 31U))
    n |= 2;
  return n;
}

static int _cffi_const_FUNSXP(unsigned long long *o)
{
  int n = (FUNSXP) <= 0;
  *o = (unsigned long long)((FUNSXP) | 0);  /* check that FUNSXP is an integer */
  if (!_cffi_check_int(*o, n, 99U))
    n |= 2;
  return n;
}

static int _cffi_const_INTSXP(unsigned long long *o)
{
  int n = (INTSXP) <= 0;
  *o = (unsigned long long)((INTSXP) | 0);  /* check that INTSXP is an integer */
  if (!_cffi_check_int(*o, n, 13U))
    n |= 2;
  return n;
}

static int _cffi_const_LANGSXP(unsigned long long *o)
{
  int n = (LANGSXP) <= 0;
  *o = (unsigned long long)((LANGSXP) | 0);  /* check that LANGSXP is an integer */
  if (!_cffi_check_int(*o, n, 6U))
    n |= 2;
  return n;
}

static int _cffi_const_LGLSXP(unsigned long long *o)
{
  int n = (LGLSXP) <= 0;
  *o = (unsigned long long)((LGLSXP) | 0);  /* check that LGLSXP is an integer */
  if (!_cffi_check_int(*o, n, 10U))
    n |= 2;
  return n;
}

static int _cffi_const_LISTSXP(unsigned long long *o)
{
  int n = (LISTSXP) <= 0;
  *o = (unsigned long long)((LISTSXP) | 0);  /* check that LISTSXP is an integer */
  if (!_cffi_check_int(*o, n, 2U))
    n |= 2;
  return n;
}

static int _cffi_const_NEWSXP(unsigned long long *o)
{
  int n = (NEWSXP) <= 0;
  *o = (unsigned long long)((NEWSXP) | 0);  /* check that NEWSXP is an integer */
  if (!_cffi_check_int(*o, n, 30U))
    n |= 2;
  return n;
}

static int _cffi_const_NILSXP(unsigned long long *o)
{
  int n = (NILSXP) <= 0;
  *o = (unsigned long long)((NILSXP) | 0);  /* check that NILSXP is an integer */
  if (!_cffi_check_int(*o, n, 0))
    n |= 2;
  return n;
}

static int _cffi_const_PROMSXP(unsigned long long *o)
{
  int n = (PROMSXP) <= 0;
  *o = (unsigned long long)((PROMSXP) | 0);  /* check that PROMSXP is an integer */
  if (!_cffi_check_int(*o, n, 5U))
    n |= 2;
  return n;
}

static int _cffi_const_RAWSXP(unsigned long long *o)
{
  int n = (RAWSXP) <= 0;
  *o = (unsigned long long)((RAWSXP) | 0);  /* check that RAWSXP is an integer */
  if (!_cffi_check_int(*o, n, 24U))
    n |= 2;
  return n;
}

static int _cffi_const_REALSXP(unsigned long long *o)
{
  int n = (REALSXP) <= 0;
  *o = (unsigned long long)((REALSXP) | 0);  /* check that REALSXP is an integer */
  if (!_cffi_check_int(*o, n, 14U))
    n |= 2;
  return n;
}

static int _cffi_const_S4SXP(unsigned long long *o)
{
  int n = (S4SXP) <= 0;
  *o = (unsigned long long)((S4SXP) | 0);  /* check that S4SXP is an integer */
  if (!_cffi_check_int(*o, n, 25U))
    n |= 2;
  return n;
}

static int _cffi_const_SPECIALSXP(unsigned long long *o)
{
  int n = (SPECIALSXP) <= 0;
  *o = (unsigned long long)((SPECIALSXP) | 0);  /* check that SPECIALSXP is an integer */
  if (!_cffi_check_int(*o, n, 7U))
    n |= 2;
  return n;
}

static int _cffi_const_STRSXP(unsigned long long *o)
{
  int n = (STRSXP) <= 0;
  *o = (unsigned long long)((STRSXP) | 0);  /* check that STRSXP is an integer */
  if (!_cffi_check_int(*o, n, 16U))
    n |= 2;
  return n;
}

static int _cffi_const_SYMSXP(unsigned long long *o)
{
  int n = (SYMSXP) <= 0;
  *o = (unsigned long long)((SYMSXP) | 0);  /* check that SYMSXP is an integer */
  if (!_cffi_check_int(*o, n, 1U))
    n |= 2;
  return n;
}

static int _cffi_const_VECSXP(unsigned long long *o)
{
  int n = (VECSXP) <= 0;
  *o = (unsigned long long)((VECSXP) | 0);  /* check that VECSXP is an integer */
  if (!_cffi_check_int(*o, n, 19U))
    n |= 2;
  return n;
}

static int _cffi_const_WEAKREFSXP(unsigned long long *o)
{
  int n = (WEAKREFSXP) <= 0;
  *o = (unsigned long long)((WEAKREFSXP) | 0);  /* check that WEAKREFSXP is an integer */
  if (!_cffi_check_int(*o, n, 23U))
    n |= 2;
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_RPY2_sym_env_data(struct RPY2_sym_env_data *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct SEXPREC * *tmp = &p->symbol; (void)tmp; }
  { struct SEXPREC * *tmp = &p->environment; (void)tmp; }
  { struct SEXPREC * *tmp = &p->data; (void)tmp; }
}
struct _cffi_align_struct_RPY2_sym_env_data { char x; struct RPY2_sym_env_data y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__SEXPREC(SEXPREC *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct sxpinfo_struct *tmp = &p->sxpinfo; (void)tmp; }
  { SEXPREC * *tmp = &p->attrib; (void)tmp; }
  { SEXPREC * *tmp = &p->gengc_next_node; (void)tmp; }
  { SEXPREC * *tmp = &p->gengc_prev_node; (void)tmp; }
  /* cannot generate 'union $2' in field 'u': unknown type name */
}
struct _cffi_align__SEXPREC { char x; SEXPREC y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld__InputHandler(InputHandler *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->activity) | 0);  /* check that 'InputHandler.activity' is an integer */
  (void)((p->fileDescriptor) | 0);  /* check that 'InputHandler.fileDescriptor' is an integer */
  { void(* *tmp)(void *) = &p->handler; (void)tmp; }
  { InputHandler * *tmp = &p->next; (void)tmp; }
  (void)((p->active) | 0);  /* check that 'InputHandler.active' is an integer */
  { void * *tmp = &p->userData; (void)tmp; }
}
struct _cffi_align__InputHandler { char x; InputHandler y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_closxp_struct(struct closxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct SEXPREC * *tmp = &p->formals; (void)tmp; }
  { struct SEXPREC * *tmp = &p->body; (void)tmp; }
  { struct SEXPREC * *tmp = &p->env; (void)tmp; }
}
struct _cffi_align_struct_closxp_struct { char x; struct closxp_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_envsxp_struct(struct envsxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct SEXPREC * *tmp = &p->frame; (void)tmp; }
  { struct SEXPREC * *tmp = &p->enclos; (void)tmp; }
  { struct SEXPREC * *tmp = &p->hashtab; (void)tmp; }
}
struct _cffi_align_struct_envsxp_struct { char x; struct envsxp_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_listsxp_struct(struct listsxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct SEXPREC * *tmp = &p->carval; (void)tmp; }
  { struct SEXPREC * *tmp = &p->cdrval; (void)tmp; }
  { struct SEXPREC * *tmp = &p->tagval; (void)tmp; }
}
struct _cffi_align_struct_listsxp_struct { char x; struct listsxp_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_primsxp_struct(struct primsxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->offset) | 0);  /* check that 'struct primsxp_struct.offset' is an integer */
}
struct _cffi_align_struct_primsxp_struct { char x; struct primsxp_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_promsxp_struct(struct promsxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct SEXPREC * *tmp = &p->value; (void)tmp; }
  { struct SEXPREC * *tmp = &p->expr; (void)tmp; }
  { struct SEXPREC * *tmp = &p->env; (void)tmp; }
}
struct _cffi_align_struct_promsxp_struct { char x; struct promsxp_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_sxpinfo_struct(struct sxpinfo_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->type) | 0);  /* check that 'struct sxpinfo_struct.type' is an integer */
  (void)((p->scalar) | 0);  /* check that 'struct sxpinfo_struct.scalar' is an integer */
  (void)((p->alt) | 0);  /* check that 'struct sxpinfo_struct.alt' is an integer */
  (void)((p->obj) | 0);  /* check that 'struct sxpinfo_struct.obj' is an integer */
  (void)((p->gp) | 0);  /* check that 'struct sxpinfo_struct.gp' is an integer */
  (void)((p->mark) | 0);  /* check that 'struct sxpinfo_struct.mark' is an integer */
  (void)((p->debug) | 0);  /* check that 'struct sxpinfo_struct.debug' is an integer */
  (void)((p->trace) | 0);  /* check that 'struct sxpinfo_struct.trace' is an integer */
  (void)((p->spare) | 0);  /* check that 'struct sxpinfo_struct.spare' is an integer */
  (void)((p->gcgen) | 0);  /* check that 'struct sxpinfo_struct.gcgen' is an integer */
  (void)((p->gccls) | 0);  /* check that 'struct sxpinfo_struct.gccls' is an integer */
  (void)((p->named) | 0);  /* check that 'struct sxpinfo_struct.named' is an integer */
  (void)((p->extra) | 0);  /* check that 'struct sxpinfo_struct.extra' is an integer */
}
struct _cffi_align_struct_sxpinfo_struct { char x; struct sxpinfo_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_symsxp_struct(struct symsxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct SEXPREC * *tmp = &p->pname; (void)tmp; }
  { struct SEXPREC * *tmp = &p->value; (void)tmp; }
  { struct SEXPREC * *tmp = &p->internal; (void)tmp; }
}
struct _cffi_align_struct_symsxp_struct { char x; struct symsxp_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_vecsxp_struct(struct vecsxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->length) | 0);  /* check that 'struct vecsxp_struct.length' is an integer */
  (void)((p->truelength) | 0);  /* check that 'struct vecsxp_struct.truelength' is an integer */
}
struct _cffi_align_struct_vecsxp_struct { char x; struct vecsxp_struct y; };

static struct SEXPREC * *_cffi_var_R_BaseEnv(void)
{
  return &(R_BaseEnv);
}

static struct SEXPREC * *_cffi_var_R_BaseNamespace(void)
{
  return &(R_BaseNamespace);
}

static struct SEXPREC * *_cffi_var_R_BlankScalarString(void)
{
  return &(R_BlankScalarString);
}

static struct SEXPREC * *_cffi_var_R_BlankString(void)
{
  return &(R_BlankString);
}

static uintptr_t *_cffi_var_R_CStackLimit(void)
{
  return &(R_CStackLimit);
}

static uintptr_t *_cffi_var_R_CStackStart(void)
{
  return &(R_CStackStart);
}

static struct SEXPREC * *_cffi_var_R_ClassSymbol(void)
{
  return &(R_ClassSymbol);
}

static FILE * *_cffi_var_R_Consolefile(void)
{
  return &(R_Consolefile);
}

static struct SEXPREC * *_cffi_var_R_DimSymbol(void)
{
  return &(R_DimSymbol);
}

static struct SEXPREC * *_cffi_var_R_EmptyEnv(void)
{
  return &(R_EmptyEnv);
}

static void * *_cffi_var_R_GlobalContext(void)
{
  return &(R_GlobalContext);
}

static struct SEXPREC * *_cffi_var_R_GlobalEnv(void)
{
  return &(R_GlobalEnv);
}

static InputHandler * *_cffi_var_R_InputHandlers(void)
{
  return &(R_InputHandlers);
}

static Rboolean *_cffi_var_R_Interactive(void)
{
  return &(R_Interactive);
}

static struct SEXPREC * *_cffi_var_R_MissingArg(void)
{
  return &(R_MissingArg);
}

static int *_cffi_var_R_NaInt(void)
{
  return &(R_NaInt);
}

static double *_cffi_var_R_NaN(void)
{
  return &(R_NaN);
}

static double *_cffi_var_R_NaReal(void)
{
  return &(R_NaReal);
}

static struct SEXPREC * *_cffi_var_R_NaString(void)
{
  return &(R_NaString);
}

static struct SEXPREC * *_cffi_var_R_NameSymbol(void)
{
  return &(R_NameSymbol);
}

static double *_cffi_var_R_NegInf(void)
{
  return &(R_NegInf);
}

static struct SEXPREC * *_cffi_var_R_NilValue(void)
{
  return &(R_NilValue);
}

static FILE * *_cffi_var_R_Outputfile(void)
{
  return &(R_Outputfile);
}

static void(* *_cffi_var_R_PolledEvents(void))(void)
{
  return &(R_PolledEvents);
}

static double *_cffi_var_R_PosInf(void)
{
  return &(R_PosInf);
}

static int *_cffi_var_R_SignalHandlers(void)
{
  return &(R_SignalHandlers);
}

static struct SEXPREC * *_cffi_var_R_UnboundValue(void)
{
  return &(R_UnboundValue);
}

static int *_cffi_var_R_interrupts_pending(void)
{
  return &(R_interrupts_pending);
}

static int *_cffi_var_R_wait_usec(void)
{
  return &(R_wait_usec);
}

static void(* *_cffi_var_ptr_R_Busy(void))(int)
{
  return &(ptr_R_Busy);
}

static int(* *_cffi_var_ptr_R_ChooseFile(void))(int, char *, int)
{
  return &(ptr_R_ChooseFile);
}

static void(* *_cffi_var_ptr_R_CleanUp(void))(SA_TYPE, int, int)
{
  return &(ptr_R_CleanUp);
}

static void(* *_cffi_var_ptr_R_ClearerrConsole(void))(void)
{
  return &(ptr_R_ClearerrConsole);
}

static int(* *_cffi_var_ptr_R_EditFile(void))(char const *)
{
  return &(ptr_R_EditFile);
}

static int(* *_cffi_var_ptr_R_EditFiles(void))(int, char const * *, char const * *, char const *)
{
  return &(ptr_R_EditFiles);
}

static void(* *_cffi_var_ptr_R_FlushConsole(void))(void)
{
  return &(ptr_R_FlushConsole);
}

static void(* *_cffi_var_ptr_R_ProcessEvents(void))(void)
{
  return &(ptr_R_ProcessEvents);
}

static int(* *_cffi_var_ptr_R_ReadConsole(void))(char const *, unsigned char *, int, int)
{
  return &(ptr_R_ReadConsole);
}

static void(* *_cffi_var_ptr_R_ResetConsole(void))(void)
{
  return &(ptr_R_ResetConsole);
}

static int(* *_cffi_var_ptr_R_ShowFiles(void))(int, char const * *, char const * *, char const *, Rboolean, char const *)
{
  return &(ptr_R_ShowFiles);
}

static void(* *_cffi_var_ptr_R_ShowMessage(void))(char const *)
{
  return &(ptr_R_ShowMessage);
}

static void(* *_cffi_var_ptr_R_Suicide(void))(char const *)
{
  return &(ptr_R_Suicide);
}

static void(* *_cffi_var_ptr_R_WriteConsole(void))(char const *, int)
{
  return &(ptr_R_WriteConsole);
}

static void(* *_cffi_var_ptr_R_WriteConsoleEx(void))(char const *, int, int)
{
  return &(ptr_R_WriteConsoleEx);
}

static void(* *_cffi_var_ptr_R_addhistory(void))(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
{
  return &(ptr_R_addhistory);
}

static void(* *_cffi_var_ptr_R_loadhistory(void))(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
{
  return &(ptr_R_loadhistory);
}

static void(* *_cffi_var_ptr_R_savehistory(void))(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
{
  return &(ptr_R_savehistory);
}

static struct SEXPREC *(* *_cffi_var_ptr_do_dataentry(void))(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
{
  return &(ptr_do_dataentry);
}

static struct SEXPREC *(* *_cffi_var_ptr_do_dataviewer(void))(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
{
  return &(ptr_do_dataviewer);
}

static struct SEXPREC *(* *_cffi_var_ptr_do_selectlist(void))(struct SEXPREC *, struct SEXPREC *, struct SEXPREC *, struct SEXPREC *)
{
  return &(ptr_do_selectlist);
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "ANYSXP", (void *)_cffi_const_ANYSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ATTRIB", (void *)_cffi_f_ATTRIB, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_ATTRIB },
  { "BCODESXP", (void *)_cffi_const_BCODESXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUILTINSXP", (void *)_cffi_const_BUILTINSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Bytes", (void *)_cffi_const_Bytes, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CAR", (void *)_cffi_f_CAR, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_CAR },
  { "CDR", (void *)_cffi_f_CDR, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_CDR },
  { "CE_ANY", (void *)_cffi_const_CE_ANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CE_BYTES", (void *)_cffi_const_CE_BYTES, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CE_LATIN1", (void *)_cffi_const_CE_LATIN1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CE_NATIVE", (void *)_cffi_const_CE_NATIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CE_SYMBOL", (void *)_cffi_const_CE_SYMBOL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CE_UTF8", (void *)_cffi_const_CE_UTF8, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CHARSXP", (void *)_cffi_const_CHARSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CLOENV", (void *)_cffi_f_CLOENV, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_CLOENV },
  { "CLOSXP", (void *)_cffi_const_CLOSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "COMPLEX", (void *)_cffi_f_COMPLEX, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 19), (void *)_cffi_d_COMPLEX },
  { "COMPLEX_ELT", (void *)_cffi_f_COMPLEX_ELT, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 22), (void *)_cffi_d_COMPLEX_ELT },
  { "CPLXSXP", (void *)_cffi_const_CPLXSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Chars", (void *)_cffi_const_Chars, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "DATAPTR", (void *)_cffi_f_DATAPTR, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 241), (void *)_cffi_d_DATAPTR },
  { "DOTSXP", (void *)_cffi_const_DOTSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ENCLOS", (void *)_cffi_f_ENCLOS, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_ENCLOS },
  { "ENVFLAGS", (void *)_cffi_f_ENVFLAGS, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 94), (void *)_cffi_d_ENVFLAGS },
  { "ENVSXP", (void *)_cffi_const_ENVSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EXPRSXP", (void *)_cffi_const_EXPRSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EXTPTRSXP", (void *)_cffi_const_EXTPTRSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "FALSE", (void *)_cffi_const_FALSE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "FRAME", (void *)_cffi_f_FRAME, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_FRAME },
  { "FREESXP", (void *)_cffi_const_FREESXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "FUNSXP", (void *)_cffi_const_FUNSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "HASHTAB", (void *)_cffi_f_HASHTAB, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_HASHTAB },
  { "INTEGER", (void *)_cffi_f_INTEGER, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 39), (void *)_cffi_d_INTEGER },
  { "INTEGER_ELT", (void *)_cffi_f_INTEGER_ELT, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 104), (void *)_cffi_d_INTEGER_ELT },
  { "INTSXP", (void *)_cffi_const_INTSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LANGSXP", (void *)_cffi_const_LANGSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LGLSXP", (void *)_cffi_const_LGLSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LISTSXP", (void *)_cffi_const_LISTSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LOGICAL", (void *)_cffi_f_LOGICAL, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 39), (void *)_cffi_d_LOGICAL },
  { "LOGICAL_ELT", (void *)_cffi_f_LOGICAL_ELT, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 104), (void *)_cffi_d_LOGICAL_ELT },
  { "NEWSXP", (void *)_cffi_const_NEWSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "NILSXP", (void *)_cffi_const_NILSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PARSE_EOF", (void *)_cffi_const_PARSE_EOF, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PARSE_ERROR", (void *)_cffi_const_PARSE_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PARSE_INCOMPLETE", (void *)_cffi_const_PARSE_INCOMPLETE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PARSE_NULL", (void *)_cffi_const_PARSE_NULL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PARSE_OK", (void *)_cffi_const_PARSE_OK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PRINTNAME", (void *)_cffi_f_PRINTNAME, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_PRINTNAME },
  { "PROMSXP", (void *)_cffi_const_PROMSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "RAW", (void *)_cffi_f_RAW, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 234), (void *)_cffi_d_RAW },
  { "RAWSXP", (void *)_cffi_const_RAWSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "RAW_ELT", (void *)_cffi_f_RAW_ELT, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 237), (void *)_cffi_d_RAW_ELT },
  { "REAL", (void *)_cffi_f_REAL, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 32), (void *)_cffi_d_REAL },
  { "REALSXP", (void *)_cffi_const_REALSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "REAL_ELT", (void *)_cffi_f_REAL_ELT, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 35), (void *)_cffi_d_REAL_ELT },
  { "R_BaseEnv", (void *)_cffi_var_R_BaseEnv, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_BaseNamespace", (void *)_cffi_var_R_BaseNamespace, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_BlankScalarString", (void *)_cffi_var_R_BlankScalarString, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_BlankString", (void *)_cffi_var_R_BlankString, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_CHAR", (void *)_cffi_f_R_CHAR, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 29), (void *)_cffi_d_R_CHAR },
  { "R_CStackLimit", (void *)_cffi_var_R_CStackLimit, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 368), (void *)0 },
  { "R_CStackStart", (void *)_cffi_var_R_CStackStart, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 368), (void *)0 },
  { "R_ClassSymbol", (void *)_cffi_var_R_ClassSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_CleanTempDir", (void *)_cffi_f_R_CleanTempDir, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 331), (void *)_cffi_d_R_CleanTempDir },
  { "R_ClearExternalPtr", (void *)_cffi_f_R_ClearExternalPtr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 285), (void *)_cffi_d_R_ClearExternalPtr },
  { "R_Consolefile", (void *)_cffi_var_R_Consolefile, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 334), (void *)0 },
  { "R_DefParams", (void *)_cffi_f_R_DefParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 321), (void *)_cffi_d_R_DefParams },
  { "R_DimSymbol", (void *)_cffi_var_R_DimSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_EmptyEnv", (void *)_cffi_var_R_EmptyEnv, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_EnvironmentIsLocked", (void *)_cffi_f_R_EnvironmentIsLocked, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 12), (void *)_cffi_d_R_EnvironmentIsLocked },
  { "R_ExternalPtrAddr", (void *)_cffi_f_R_ExternalPtrAddr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 241), (void *)_cffi_d_R_ExternalPtrAddr },
  { "R_GlobalContext", (void *)_cffi_var_R_GlobalContext, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 17), (void *)0 },
  { "R_GlobalEnv", (void *)_cffi_var_R_GlobalEnv, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_InputHandlers", (void *)_cffi_var_R_InputHandlers, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_Interactive", (void *)_cffi_var_R_Interactive, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 91), (void *)0 },
  { "R_MakeExternalPtr", (void *)_cffi_f_R_MakeExternalPtr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 226), (void *)_cffi_d_R_MakeExternalPtr },
  { "R_MissingArg", (void *)_cffi_var_R_MissingArg, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_NaInt", (void *)_cffi_var_R_NaInt, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 4), (void *)0 },
  { "R_NaN", (void *)_cffi_var_R_NaN, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 131), (void *)0 },
  { "R_NaReal", (void *)_cffi_var_R_NaReal, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 131), (void *)0 },
  { "R_NaString", (void *)_cffi_var_R_NaString, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_NameSymbol", (void *)_cffi_var_R_NameSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_NegInf", (void *)_cffi_var_R_NegInf, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 131), (void *)0 },
  { "R_NilValue", (void *)_cffi_var_R_NilValue, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_Outputfile", (void *)_cffi_var_R_Outputfile, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 334), (void *)0 },
  { "R_ParseVector", (void *)_cffi_f_R_ParseVector, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 160), (void *)_cffi_d_R_ParseVector },
  { "R_PolledEvents", (void *)_cffi_var_R_PolledEvents, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 380), (void *)0 },
  { "R_PosInf", (void *)_cffi_var_R_PosInf, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 131), (void *)0 },
  { "R_PreserveObject", (void *)_cffi_f_R_PreserveObject, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 285), (void *)_cffi_d_R_PreserveObject },
  { "R_RegisterCFinalizer", (void *)_cffi_f_R_RegisterCFinalizer, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 317), (void *)_cffi_d_R_RegisterCFinalizer },
  { "R_ReleaseObject", (void *)_cffi_f_R_ReleaseObject, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 285), (void *)_cffi_d_R_ReleaseObject },
  { "R_RunExitFinalizers", (void *)_cffi_f_R_RunExitFinalizers, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 331), (void *)_cffi_d_R_RunExitFinalizers },
  { "R_SetParams", (void *)_cffi_f_R_SetParams, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 321), (void *)_cffi_d_R_SetParams },
  { "R_SignalHandlers", (void *)_cffi_var_R_SignalHandlers, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 4), (void *)0 },
  { "R_ToplevelExec", (void *)_cffi_f_R_ToplevelExec, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 15), (void *)_cffi_d_R_ToplevelExec },
  { "R_UnboundValue", (void *)_cffi_var_R_UnboundValue, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 13), (void *)0 },
  { "R_UnwindProtect", (void *)_cffi_f_R_UnwindProtect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 142), (void *)_cffi_d_R_UnwindProtect },
  { "R_do_slot", (void *)_cffi_f_R_do_slot, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_R_do_slot },
  { "R_do_slot_assign", (void *)_cffi_f_R_do_slot_assign, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 189), (void *)_cffi_d_R_do_slot_assign },
  { "R_dot_Last", (void *)_cffi_f_R_dot_Last, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 331), (void *)_cffi_d_R_dot_Last },
  { "R_gc", (void *)_cffi_f_R_gc, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 331), (void *)_cffi_d_R_gc },
  { "R_getEmbeddingDllInfo", (void *)_cffi_f_R_getEmbeddingDllInfo, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 0), (void *)_cffi_d_R_getEmbeddingDllInfo },
  { "R_has_slot", (void *)_cffi_f_R_has_slot, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 108), (void *)_cffi_d_R_has_slot },
  { "R_interrupts_pending", (void *)_cffi_var_R_interrupts_pending, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 4), (void *)0 },
  { "R_lsInternal", (void *)_cffi_f_R_lsInternal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 152), (void *)_cffi_d_R_lsInternal },
  { "R_nchar", (void *)_cffi_f_R_nchar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 97), (void *)_cffi_d_R_nchar },
  { "R_registerRoutines", (void *)_cffi_f_R_registerRoutines, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 42), (void *)_cffi_d_R_registerRoutines },
  { "R_set_command_line_arguments", (void *)_cffi_f_R_set_command_line_arguments, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 281), (void *)_cffi_d_R_set_command_line_arguments },
  { "R_tryCatchError", (void *)_cffi_f_R_tryCatchError, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 136), (void *)_cffi_d_R_tryCatchError },
  { "R_tryEval", (void *)_cffi_f_R_tryEval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 184), (void *)_cffi_d_R_tryEval },
  { "R_wait_usec", (void *)_cffi_var_R_wait_usec, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 4), (void *)0 },
  { "Rf_KillAllDevices", (void *)_cffi_f_Rf_KillAllDevices, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 331), (void *)_cffi_d_Rf_KillAllDevices },
  { "Rf_ScalarComplex", (void *)_cffi_f_Rf_ScalarComplex, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 115), (void *)_cffi_d_Rf_ScalarComplex },
  { "Rf_ScalarInteger", (void *)_cffi_f_Rf_ScalarInteger, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 133), (void *)_cffi_d_Rf_ScalarInteger },
  { "Rf_ScalarLogical", (void *)_cffi_f_Rf_ScalarLogical, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 133), (void *)_cffi_d_Rf_ScalarLogical },
  { "Rf_ScalarRaw", (void *)_cffi_f_Rf_ScalarRaw, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 219), (void *)_cffi_d_Rf_ScalarRaw },
  { "Rf_ScalarReal", (void *)_cffi_f_Rf_ScalarReal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 130), (void *)_cffi_d_Rf_ScalarReal },
  { "Rf_ScalarString", (void *)_cffi_f_Rf_ScalarString, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_Rf_ScalarString },
  { "Rf_allocList", (void *)_cffi_f_Rf_allocList, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 133), (void *)_cffi_d_Rf_allocList },
  { "Rf_allocVector", (void *)_cffi_f_Rf_allocVector, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 222), (void *)_cffi_d_Rf_allocVector },
  { "Rf_asChar", (void *)_cffi_f_Rf_asChar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_Rf_asChar },
  { "Rf_defineVar", (void *)_cffi_f_Rf_defineVar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 189), (void *)_cffi_d_Rf_defineVar },
  { "Rf_duplicate", (void *)_cffi_f_Rf_duplicate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_Rf_duplicate },
  { "Rf_elt", (void *)_cffi_f_Rf_elt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 156), (void *)_cffi_d_Rf_elt },
  { "Rf_endEmbeddedR", (void *)_cffi_f_Rf_endEmbeddedR, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 278), (void *)_cffi_d_Rf_endEmbeddedR },
  { "Rf_eval", (void *)_cffi_f_Rf_eval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_Rf_eval },
  { "Rf_findFun", (void *)_cffi_f_Rf_findFun, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_Rf_findFun },
  { "Rf_findVar", (void *)_cffi_f_Rf_findVar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_Rf_findVar },
  { "Rf_findVarInFrame", (void *)_cffi_f_Rf_findVarInFrame, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_Rf_findVarInFrame },
  { "Rf_findVarInFrame3", (void *)_cffi_f_Rf_findVarInFrame3, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 179), (void *)_cffi_d_Rf_findVarInFrame3 },
  { "Rf_getAttrib", (void *)_cffi_f_Rf_getAttrib, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_Rf_getAttrib },
  { "Rf_getCharCE", (void *)_cffi_f_Rf_getCharCE, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 26), (void *)_cffi_d_Rf_getCharCE },
  { "Rf_initEmbeddedR", (void *)_cffi_f_Rf_initEmbeddedR, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 71), (void *)_cffi_d_Rf_initEmbeddedR },
  { "Rf_initialize_R", (void *)_cffi_f_Rf_initialize_R, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 71), (void *)_cffi_d_Rf_initialize_R },
  { "Rf_install", (void *)_cffi_f_Rf_install, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_Rf_install },
  { "Rf_installChar", (void *)_cffi_f_Rf_installChar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_Rf_installChar },
  { "Rf_isList", (void *)_cffi_f_Rf_isList, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 12), (void *)_cffi_d_Rf_isList },
  { "Rf_isNull", (void *)_cffi_f_Rf_isNull, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 12), (void *)_cffi_d_Rf_isNull },
  { "Rf_isSymbol", (void *)_cffi_f_Rf_isSymbol, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 12), (void *)_cffi_d_Rf_isSymbol },
  { "Rf_lang1", (void *)_cffi_f_Rf_lang1, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_Rf_lang1 },
  { "Rf_lang2", (void *)_cffi_f_Rf_lang2, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_Rf_lang2 },
  { "Rf_lang3", (void *)_cffi_f_Rf_lang3, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 189), (void *)_cffi_d_Rf_lang3 },
  { "Rf_lang4", (void *)_cffi_f_Rf_lang4, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 194), (void *)_cffi_d_Rf_lang4 },
  { "Rf_lang5", (void *)_cffi_f_Rf_lang5, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 200), (void *)_cffi_d_Rf_lang5 },
  { "Rf_lang6", (void *)_cffi_f_Rf_lang6, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 207), (void *)_cffi_d_Rf_lang6 },
  { "Rf_length", (void *)_cffi_f_Rf_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 94), (void *)_cffi_d_Rf_length },
  { "Rf_mainloop", (void *)_cffi_f_Rf_mainloop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 331), (void *)_cffi_d_Rf_mainloop },
  { "Rf_mkChar", (void *)_cffi_f_Rf_mkChar, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_Rf_mkChar },
  { "Rf_mkCharCE", (void *)_cffi_f_Rf_mkCharCE, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 121), (void *)_cffi_d_Rf_mkCharCE },
  { "Rf_mkCharLenCE", (void *)_cffi_f_Rf_mkCharLenCE, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 125), (void *)_cffi_d_Rf_mkCharLenCE },
  { "Rf_mkString", (void *)_cffi_f_Rf_mkString, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_Rf_mkString },
  { "Rf_namesgets", (void *)_cffi_f_Rf_namesgets, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_Rf_namesgets },
  { "Rf_nthcdr", (void *)_cffi_f_Rf_nthcdr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 156), (void *)_cffi_d_Rf_nthcdr },
  { "Rf_protect", (void *)_cffi_f_Rf_protect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_Rf_protect },
  { "Rf_setAttrib", (void *)_cffi_f_Rf_setAttrib, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 189), (void *)_cffi_d_Rf_setAttrib },
  { "Rf_unprotect", (void *)_cffi_f_Rf_unprotect, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 278), (void *)_cffi_d_Rf_unprotect },
  { "Rf_xlength", (void *)_cffi_f_Rf_xlength, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 112), (void *)_cffi_d_Rf_xlength },
  { "S4SXP", (void *)_cffi_const_S4SXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SA_DEFAULT", (void *)_cffi_const_SA_DEFAULT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "SA_NORESTORE", (void *)_cffi_const_SA_NORESTORE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "SA_NOSAVE", (void *)_cffi_const_SA_NOSAVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "SA_RESTORE", (void *)_cffi_const_SA_RESTORE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "SA_SAVE", (void *)_cffi_const_SA_SAVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "SA_SAVEASK", (void *)_cffi_const_SA_SAVEASK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "SA_SUICIDE", (void *)_cffi_const_SA_SUICIDE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "SETCAR", (void *)_cffi_f_SETCAR, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_SETCAR },
  { "SETCDR", (void *)_cffi_f_SETCDR, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_SETCDR },
  { "SET_ENCLOS", (void *)_cffi_f_SET_ENCLOS, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 307), (void *)_cffi_d_SET_ENCLOS },
  { "SET_ENVFLAGS", (void *)_cffi_f_SET_ENVFLAGS, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 288), (void *)_cffi_d_SET_ENVFLAGS },
  { "SET_FRAME", (void *)_cffi_f_SET_FRAME, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 307), (void *)_cffi_d_SET_FRAME },
  { "SET_HASHTAB", (void *)_cffi_f_SET_HASHTAB, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 307), (void *)_cffi_d_SET_HASHTAB },
  { "SET_INTEGER_ELT", (void *)_cffi_f_SET_INTEGER_ELT, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 297), (void *)_cffi_d_SET_INTEGER_ELT },
  { "SET_LOGICAL_ELT", (void *)_cffi_f_SET_LOGICAL_ELT, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 297), (void *)_cffi_d_SET_LOGICAL_ELT },
  { "SET_REAL_ELT", (void *)_cffi_f_SET_REAL_ELT, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 292), (void *)_cffi_d_SET_REAL_ELT },
  { "SET_STRING_ELT", (void *)_cffi_f_SET_STRING_ELT, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 302), (void *)_cffi_d_SET_STRING_ELT },
  { "SET_TAG", (void *)_cffi_f_SET_TAG, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 175), (void *)_cffi_d_SET_TAG },
  { "SET_VECTOR_ELT", (void *)_cffi_f_SET_VECTOR_ELT, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 170), (void *)_cffi_d_SET_VECTOR_ELT },
  { "SPECIALSXP", (void *)_cffi_const_SPECIALSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "STDVEC_DATAPTR", (void *)_cffi_f_STDVEC_DATAPTR, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 241), (void *)_cffi_d_STDVEC_DATAPTR },
  { "STRING_ELT", (void *)_cffi_f_STRING_ELT, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 166), (void *)_cffi_d_STRING_ELT },
  { "STRSXP", (void *)_cffi_const_STRSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SYMSXP", (void *)_cffi_const_SYMSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TAG", (void *)_cffi_f_TAG, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 149), (void *)_cffi_d_TAG },
  { "TRUE", (void *)_cffi_const_TRUE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "VECSXP", (void *)_cffi_const_VECSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "VECTOR_ELT", (void *)_cffi_f_VECTOR_ELT, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 166), (void *)_cffi_d_VECTOR_ELT },
  { "WEAKREFSXP", (void *)_cffi_const_WEAKREFSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Width", (void *)_cffi_const_Width, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "_busy", (void *)&_cffi_externpy___busy, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 378), (void *)_busy },
  { "_callback", (void *)&_cffi_externpy___callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 380), (void *)_callback },
  { "_capsule_finalizer", (void *)&_cffi_externpy___capsule_finalizer, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 319), (void *)_capsule_finalizer },
  { "_choosefile", (void *)&_cffi_externpy___choosefile, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 352), (void *)_choosefile },
  { "_cleanup", (void *)&_cffi_externpy___cleanup, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 371), (void *)_cleanup },
  { "_consoleflush", (void *)&_cffi_externpy___consoleflush, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 380), (void *)_consoleflush },
  { "_consoleread", (void *)&_cffi_externpy___consoleread, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 349), (void *)_consoleread },
  { "_consolereset", (void *)&_cffi_externpy___consolereset, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 380), (void *)_consolereset },
  { "_consolewrite", (void *)&_cffi_externpy___consolewrite, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 373), (void *)_consolewrite },
  { "_consolewrite_ex", (void *)&_cffi_externpy___consolewrite_ex, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 374), (void *)_consolewrite_ex },
  { "_evaluate_in_r", (void *)&_cffi_externpy___evaluate_in_r, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 357), (void *)_evaluate_in_r },
  { "_exec_findvar_in_frame", (void *)&_cffi_externpy___exec_findvar_in_frame, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 9), (void *)_exec_findvar_in_frame },
  { "_handler_wrap", (void *)&_cffi_externpy___handler_wrap, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 139), (void *)_handler_wrap },
  { "_parsevector_wrap", (void *)&_cffi_externpy___parsevector_wrap, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 137), (void *)_parsevector_wrap },
  { "_processevents", (void *)&_cffi_externpy___processevents, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 380), (void *)_processevents },
  { "_showfiles", (void *)&_cffi_externpy___showfiles, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 354), (void *)_showfiles },
  { "_showmessage", (void *)&_cffi_externpy___showmessage, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 372), (void *)_showmessage },
  { "_yesnocancel", (void *)&_cffi_externpy___yesnocancel, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 348), (void *)_yesnocancel },
  { "addInputHandler", (void *)_cffi_f_addInputHandler, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 6), (void *)_cffi_d_addInputHandler },
  { "getInputHandler", (void *)_cffi_f_getInputHandler, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 2), (void *)_cffi_d_getInputHandler },
  { "ptr_R_Busy", (void *)_cffi_var_ptr_R_Busy, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 378), (void *)0 },
  { "ptr_R_ChooseFile", (void *)_cffi_var_ptr_R_ChooseFile, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 352), (void *)0 },
  { "ptr_R_CleanUp", (void *)_cffi_var_ptr_R_CleanUp, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 371), (void *)0 },
  { "ptr_R_ClearerrConsole", (void *)_cffi_var_ptr_R_ClearerrConsole, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 380), (void *)0 },
  { "ptr_R_EditFile", (void *)_cffi_var_ptr_R_EditFile, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 350), (void *)0 },
  { "ptr_R_EditFiles", (void *)_cffi_var_ptr_R_EditFiles, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 353), (void *)0 },
  { "ptr_R_FlushConsole", (void *)_cffi_var_ptr_R_FlushConsole, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 380), (void *)0 },
  { "ptr_R_ProcessEvents", (void *)_cffi_var_ptr_R_ProcessEvents, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 380), (void *)0 },
  { "ptr_R_ReadConsole", (void *)_cffi_var_ptr_R_ReadConsole, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 351), (void *)0 },
  { "ptr_R_ResetConsole", (void *)_cffi_var_ptr_R_ResetConsole, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 380), (void *)0 },
  { "ptr_R_ShowFiles", (void *)_cffi_var_ptr_R_ShowFiles, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 354), (void *)0 },
  { "ptr_R_ShowMessage", (void *)_cffi_var_ptr_R_ShowMessage, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 375), (void *)0 },
  { "ptr_R_Suicide", (void *)_cffi_var_ptr_R_Suicide, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 375), (void *)0 },
  { "ptr_R_WriteConsole", (void *)_cffi_var_ptr_R_WriteConsole, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 376), (void *)0 },
  { "ptr_R_WriteConsoleEx", (void *)_cffi_var_ptr_R_WriteConsoleEx, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 377), (void *)0 },
  { "ptr_R_addhistory", (void *)_cffi_var_ptr_R_addhistory, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 379), (void *)0 },
  { "ptr_R_loadhistory", (void *)_cffi_var_ptr_R_loadhistory, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 379), (void *)0 },
  { "ptr_R_savehistory", (void *)_cffi_var_ptr_R_savehistory, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 379), (void *)0 },
  { "ptr_do_dataentry", (void *)_cffi_var_ptr_do_dataentry, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 358), (void *)0 },
  { "ptr_do_dataviewer", (void *)_cffi_var_ptr_do_dataviewer, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 358), (void *)0 },
  { "ptr_do_selectlist", (void *)_cffi_var_ptr_do_selectlist, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 358), (void *)0 },
  { "removeInputHandler", (void *)_cffi_f_removeInputHandler, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 49), (void *)_cffi_d_removeInputHandler },
  { "rpy2_runHandlers", (void *)_cffi_f_rpy2_runHandlers, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 246), (void *)_cffi_d_rpy2_runHandlers },
  { "run_Rmainloop", (void *)_cffi_f_run_Rmainloop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 331), (void *)_cffi_d_run_Rmainloop },
  { "setup_Rmainloop", (void *)_cffi_f_setup_Rmainloop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 331), (void *)_cffi_d_setup_Rmainloop },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "name", offsetof(R_CMethodDef, name),
            sizeof(((R_CMethodDef *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 63) },
  { "fun", offsetof(R_CMethodDef, fun),
           sizeof(((R_CMethodDef *)0)->fun),
           _CFFI_OP(_CFFI_OP_NOOP, 227) },
  { "numArgs", offsetof(R_CMethodDef, numArgs),
               sizeof(((R_CMethodDef *)0)->numArgs),
               _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "types", offsetof(R_CMethodDef, types),
             sizeof(((R_CMethodDef *)0)->types),
             _CFFI_OP(_CFFI_OP_NOOP, 370) },
  { "name", offsetof(R_CallMethodDef, name),
            sizeof(((R_CallMethodDef *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 63) },
  { "fun", offsetof(R_CallMethodDef, fun),
           sizeof(((R_CallMethodDef *)0)->fun),
           _CFFI_OP(_CFFI_OP_NOOP, 227) },
  { "numArgs", offsetof(R_CallMethodDef, numArgs),
               sizeof(((R_CallMethodDef *)0)->numArgs),
               _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "r", offsetof(Rcomplex, r),
         sizeof(((Rcomplex *)0)->r),
         _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "i", offsetof(Rcomplex, i),
         sizeof(((Rcomplex *)0)->i),
         _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "private_data_c", offsetof(Rcomplex, private_data_c),
                      sizeof(((Rcomplex *)0)->private_data_c),
                      _CFFI_OP(_CFFI_OP_NOOP, 345) },
  { "s", offsetof(SEXPREC_ALIGN, s),
         sizeof(((SEXPREC_ALIGN *)0)->s),
         _CFFI_OP(_CFFI_OP_NOOP, 344) },
  { "align", offsetof(SEXPREC_ALIGN, align),
             sizeof(((SEXPREC_ALIGN *)0)->align),
             _CFFI_OP(_CFFI_OP_NOOP, 131) },
  { "sxpinfo", offsetof(VECTOR_SEXPREC, sxpinfo),
               sizeof(((VECTOR_SEXPREC *)0)->sxpinfo),
               _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "attrib", offsetof(VECTOR_SEXPREC, attrib),
              sizeof(((VECTOR_SEXPREC *)0)->attrib),
              _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "gengc_next_node", offsetof(VECTOR_SEXPREC, gengc_next_node),
                       sizeof(((VECTOR_SEXPREC *)0)->gengc_next_node),
                       _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "gengc_prev_node", offsetof(VECTOR_SEXPREC, gengc_prev_node),
                       sizeof(((VECTOR_SEXPREC *)0)->gengc_prev_node),
                       _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "vecsxp", offsetof(VECTOR_SEXPREC, vecsxp),
              sizeof(((VECTOR_SEXPREC *)0)->vecsxp),
              _CFFI_OP(_CFFI_OP_NOOP, 366) },
  { "R_Quiet", offsetof(structRstart, R_Quiet),
               sizeof(((structRstart *)0)->R_Quiet),
               _CFFI_OP(_CFFI_OP_NOOP, 91) },
  { "R_Slave", offsetof(structRstart, R_Slave),
               sizeof(((structRstart *)0)->R_Slave),
               _CFFI_OP(_CFFI_OP_NOOP, 91) },
  { "R_Interactive", offsetof(structRstart, R_Interactive),
                     sizeof(((structRstart *)0)->R_Interactive),
                     _CFFI_OP(_CFFI_OP_NOOP, 91) },
  { "R_Verbose", offsetof(structRstart, R_Verbose),
                 sizeof(((structRstart *)0)->R_Verbose),
                 _CFFI_OP(_CFFI_OP_NOOP, 91) },
  { "LoadSiteFile", offsetof(structRstart, LoadSiteFile),
                    sizeof(((structRstart *)0)->LoadSiteFile),
                    _CFFI_OP(_CFFI_OP_NOOP, 91) },
  { "LoadInitFile", offsetof(structRstart, LoadInitFile),
                    sizeof(((structRstart *)0)->LoadInitFile),
                    _CFFI_OP(_CFFI_OP_NOOP, 91) },
  { "DebugInitFile", offsetof(structRstart, DebugInitFile),
                     sizeof(((structRstart *)0)->DebugInitFile),
                     _CFFI_OP(_CFFI_OP_NOOP, 91) },
  { "RestoreAction", offsetof(structRstart, RestoreAction),
                     sizeof(((structRstart *)0)->RestoreAction),
                     _CFFI_OP(_CFFI_OP_NOOP, 250) },
  { "SaveAction", offsetof(structRstart, SaveAction),
                  sizeof(((structRstart *)0)->SaveAction),
                  _CFFI_OP(_CFFI_OP_NOOP, 250) },
  { "vsize", offsetof(structRstart, vsize),
             sizeof(((structRstart *)0)->vsize),
             _CFFI_OP(_CFFI_OP_NOOP, 355) },
  { "nsize", offsetof(structRstart, nsize),
             sizeof(((structRstart *)0)->nsize),
             _CFFI_OP(_CFFI_OP_NOOP, 355) },
  { "max_vsize", offsetof(structRstart, max_vsize),
                 sizeof(((structRstart *)0)->max_vsize),
                 _CFFI_OP(_CFFI_OP_NOOP, 355) },
  { "max_nsize", offsetof(structRstart, max_nsize),
                 sizeof(((structRstart *)0)->max_nsize),
                 _CFFI_OP(_CFFI_OP_NOOP, 355) },
  { "ppsize", offsetof(structRstart, ppsize),
              sizeof(((structRstart *)0)->ppsize),
              _CFFI_OP(_CFFI_OP_NOOP, 355) },
  { "NoRenviron", offsetof(structRstart, NoRenviron),
                  sizeof(((structRstart *)0)->NoRenviron),
                  _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "symbol", offsetof(struct RPY2_sym_env_data, symbol),
              sizeof(((struct RPY2_sym_env_data *)0)->symbol),
              _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "environment", offsetof(struct RPY2_sym_env_data, environment),
                   sizeof(((struct RPY2_sym_env_data *)0)->environment),
                   _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "data", offsetof(struct RPY2_sym_env_data, data),
            sizeof(((struct RPY2_sym_env_data *)0)->data),
            _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "sxpinfo", offsetof(SEXPREC, sxpinfo),
               sizeof(((SEXPREC *)0)->sxpinfo),
               _CFFI_OP(_CFFI_OP_NOOP, 364) },
  { "attrib", offsetof(SEXPREC, attrib),
              sizeof(((SEXPREC *)0)->attrib),
              _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "gengc_next_node", offsetof(SEXPREC, gengc_next_node),
                       sizeof(((SEXPREC *)0)->gengc_next_node),
                       _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "gengc_prev_node", offsetof(SEXPREC, gengc_prev_node),
                       sizeof(((SEXPREC *)0)->gengc_prev_node),
                       _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "u", offsetof(SEXPREC, u),
         sizeof(((SEXPREC *)0)->u),
         _CFFI_OP(_CFFI_OP_NOOP, 369) },
  { "activity", offsetof(InputHandler, activity),
                sizeof(((InputHandler *)0)->activity),
                _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "fileDescriptor", offsetof(InputHandler, fileDescriptor),
                      sizeof(((InputHandler *)0)->fileDescriptor),
                      _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "handler", offsetof(InputHandler, handler),
               sizeof(((InputHandler *)0)->handler),
               _CFFI_OP(_CFFI_OP_NOOP, 9) },
  { "next", offsetof(InputHandler, next),
            sizeof(((InputHandler *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "active", offsetof(InputHandler, active),
              sizeof(((InputHandler *)0)->active),
              _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "userData", offsetof(InputHandler, userData),
                sizeof(((InputHandler *)0)->userData),
                _CFFI_OP(_CFFI_OP_NOOP, 17) },
  { "formals", offsetof(struct closxp_struct, formals),
               sizeof(((struct closxp_struct *)0)->formals),
               _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "body", offsetof(struct closxp_struct, body),
            sizeof(((struct closxp_struct *)0)->body),
            _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "env", offsetof(struct closxp_struct, env),
           sizeof(((struct closxp_struct *)0)->env),
           _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "frame", offsetof(struct envsxp_struct, frame),
             sizeof(((struct envsxp_struct *)0)->frame),
             _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "enclos", offsetof(struct envsxp_struct, enclos),
              sizeof(((struct envsxp_struct *)0)->enclos),
              _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "hashtab", offsetof(struct envsxp_struct, hashtab),
               sizeof(((struct envsxp_struct *)0)->hashtab),
               _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "carval", offsetof(struct listsxp_struct, carval),
              sizeof(((struct listsxp_struct *)0)->carval),
              _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "cdrval", offsetof(struct listsxp_struct, cdrval),
              sizeof(((struct listsxp_struct *)0)->cdrval),
              _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "tagval", offsetof(struct listsxp_struct, tagval),
              sizeof(((struct listsxp_struct *)0)->tagval),
              _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "offset", offsetof(struct primsxp_struct, offset),
              sizeof(((struct primsxp_struct *)0)->offset),
              _CFFI_OP(_CFFI_OP_NOOP, 4) },
  { "value", offsetof(struct promsxp_struct, value),
             sizeof(((struct promsxp_struct *)0)->value),
             _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "expr", offsetof(struct promsxp_struct, expr),
            sizeof(((struct promsxp_struct *)0)->expr),
            _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "env", offsetof(struct promsxp_struct, env),
           sizeof(((struct promsxp_struct *)0)->env),
           _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "type", (size_t)-1,
            5 /* bits */,
            _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "scalar", (size_t)-1,
              1 /* bits */,
              _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "alt", (size_t)-1,
           1 /* bits */,
           _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "obj", (size_t)-1,
           1 /* bits */,
           _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "gp", (size_t)-1,
          16 /* bits */,
          _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "mark", (size_t)-1,
            1 /* bits */,
            _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "debug", (size_t)-1,
             1 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "trace", (size_t)-1,
             1 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "spare", (size_t)-1,
             1 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "gcgen", (size_t)-1,
             1 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "gccls", (size_t)-1,
             3 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "named", (size_t)-1,
             16 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "extra", (size_t)-1,
             32 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 223) },
  { "pname", offsetof(struct symsxp_struct, pname),
             sizeof(((struct symsxp_struct *)0)->pname),
             _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "value", offsetof(struct symsxp_struct, value),
             sizeof(((struct symsxp_struct *)0)->value),
             _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "internal", offsetof(struct symsxp_struct, internal),
                sizeof(((struct symsxp_struct *)0)->internal),
                _CFFI_OP(_CFFI_OP_NOOP, 13) },
  { "length", offsetof(struct vecsxp_struct, length),
              sizeof(((struct vecsxp_struct *)0)->length),
              _CFFI_OP(_CFFI_OP_NOOP, 24) },
  { "truelength", offsetof(struct vecsxp_struct, truelength),
                  sizeof(((struct vecsxp_struct *)0)->truelength),
                  _CFFI_OP(_CFFI_OP_NOOP, 24) },
  { "primsxp", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 362) },
  { "symsxp", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 365) },
  { "listsxp", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 361) },
  { "envsxp", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 360) },
  { "closxp", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 359) },
  { "promsxp", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 363) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$2", 369, _CFFI_F_UNION|_CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 77, 6 /* unnamed */ },
  { "$R_CMethodDef", 338, _CFFI_F_CHECK_FIELDS,
    sizeof(R_CMethodDef), offsetof(struct _cffi_align_typedef_R_CMethodDef, y), 0, 4 },
  { "$R_CallMethodDef", 339, _CFFI_F_CHECK_FIELDS,
    sizeof(R_CallMethodDef), offsetof(struct _cffi_align_typedef_R_CallMethodDef, y), 4, 3 },
  { "$Rcomplex", 116, _CFFI_F_UNION,
    sizeof(Rcomplex), offsetof(struct _cffi_align_typedef_Rcomplex, y), 7, 3 },
  { "$SEXPREC_ALIGN", 342, _CFFI_F_UNION|_CFFI_F_CHECK_FIELDS,
    sizeof(SEXPREC_ALIGN), offsetof(struct _cffi_align_typedef_SEXPREC_ALIGN, y), 10, 2 },
  { "$VECTOR_SEXPREC", 344, _CFFI_F_CHECK_FIELDS,
    sizeof(VECTOR_SEXPREC), offsetof(struct _cffi_align_typedef_VECTOR_SEXPREC, y), 12, 5 },
  { "$structRstart", 367, _CFFI_F_CHECK_FIELDS,
    sizeof(structRstart), offsetof(struct _cffi_align_typedef_structRstart, y), 17, 15 },
  { "RPY2_sym_env_data", 356, _CFFI_F_CHECK_FIELDS,
    sizeof(struct RPY2_sym_env_data), offsetof(struct _cffi_align_struct_RPY2_sym_env_data, y), 32, 3 },
  { "SEXPREC", 341, _CFFI_F_CHECK_FIELDS,
    sizeof(SEXPREC), offsetof(struct _cffi_align__SEXPREC, y), 35, 5 },
  { "_DllInfo", 333, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_IO_FILE", 335, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "_InputHandler", 336, _CFFI_F_CHECK_FIELDS,
    sizeof(InputHandler), offsetof(struct _cffi_align__InputHandler, y), 40, 6 },
  { "closxp_struct", 359, _CFFI_F_CHECK_FIELDS,
    sizeof(struct closxp_struct), offsetof(struct _cffi_align_struct_closxp_struct, y), 46, 3 },
  { "envsxp_struct", 360, _CFFI_F_CHECK_FIELDS,
    sizeof(struct envsxp_struct), offsetof(struct _cffi_align_struct_envsxp_struct, y), 49, 3 },
  { "listsxp_struct", 361, _CFFI_F_CHECK_FIELDS,
    sizeof(struct listsxp_struct), offsetof(struct _cffi_align_struct_listsxp_struct, y), 52, 3 },
  { "primsxp_struct", 362, _CFFI_F_CHECK_FIELDS,
    sizeof(struct primsxp_struct), offsetof(struct _cffi_align_struct_primsxp_struct, y), 55, 1 },
  { "promsxp_struct", 363, _CFFI_F_CHECK_FIELDS,
    sizeof(struct promsxp_struct), offsetof(struct _cffi_align_struct_promsxp_struct, y), 56, 3 },
  { "sxpinfo_struct", 364, _CFFI_F_CHECK_FIELDS,
    sizeof(struct sxpinfo_struct), offsetof(struct _cffi_align_struct_sxpinfo_struct, y), 59, 13 },
  { "symsxp_struct", 365, _CFFI_F_CHECK_FIELDS,
    sizeof(struct symsxp_struct), offsetof(struct _cffi_align_struct_symsxp_struct, y), 72, 3 },
  { "vecsxp_struct", 366, _CFFI_F_CHECK_FIELDS,
    sizeof(struct vecsxp_struct), offsetof(struct _cffi_align_struct_vecsxp_struct, y), 75, 2 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$ParseStatus", 337, _cffi_prim_int(sizeof(ParseStatus), ((ParseStatus)-1) <= 0),
    "PARSE_NULL,PARSE_OK,PARSE_INCOMPLETE,PARSE_ERROR,PARSE_EOF" },
  { "$Rboolean", 91, _cffi_prim_int(sizeof(Rboolean), ((Rboolean)-1) <= 0),
    "FALSE,TRUE" },
  { "$SA_TYPE", 250, _cffi_prim_int(sizeof(SA_TYPE), ((SA_TYPE)-1) <= 0),
    "SA_NORESTORE,SA_RESTORE,SA_DEFAULT,SA_NOSAVE,SA_SAVE,SA_SAVEASK,SA_SUICIDE" },
  { "$cetype_t", 123, _cffi_prim_int(sizeof(cetype_t), ((cetype_t)-1) <= 0),
    "CE_NATIVE,CE_UTF8,CE_LATIN1,CE_BYTES,CE_SYMBOL,CE_ANY" },
  { "$nchar_type", 99, _cffi_prim_int(sizeof(nchar_type), ((nchar_type)-1) <= 0),
    "Bytes,Chars,Width" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "DL_FUNC", 227 },
  { "DllInfo", 333 },
  { "FILE", 335 },
  { "InputHandler", 336 },
  { "InputHandlerProc", 9 },
  { "ParseStatus", 337 },
  { "R_CFinalizer_t", 319 },
  { "R_CMethodDef", 338 },
  { "R_CallMethodDef", 339 },
  { "R_ExternalMethodDef", 339 },
  { "R_FortranMethodDef", 338 },
  { "R_NativePrimitiveArgType", 223 },
  { "R_len_t", 4 },
  { "R_xlen_t", 24 },
  { "Rboolean", 91 },
  { "Rbyte", 220 },
  { "Rcomplex", 116 },
  { "Rstart", 322 },
  { "SA_TYPE", 250 },
  { "SEXP", 13 },
  { "SEXPREC", 341 },
  { "SEXPREC_ALIGN", 342 },
  { "SEXPTYPE", 223 },
  { "VECSEXP", 343 },
  { "VECTOR_SEXPREC", 344 },
  { "cetype_t", 123 },
  { "nchar_type", 99 },
  { "structRstart", 367 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  233,  /* num_globals */
  20,  /* num_struct_unions */
  5,  /* num_enums */
  28,  /* num_typenames */
  NULL,  /* no includes */
  382,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__rinterface_cffi_api(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__rinterface_cffi_api(void) { return NULL; }
#  else
     init_rinterface_cffi_api(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__rinterface_cffi_api(void)
{
  return _cffi_init("_rinterface_cffi_api", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_rinterface_cffi_api(void)
{
  _cffi_init("_rinterface_cffi_api", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
