// components/variations/variations.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_VARIATIONS_VARIATIONS_MOJOM_SHARED_H_
#define COMPONENTS_VARIATIONS_VARIATIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/variations/variations.mojom-shared-internal.h"







namespace variations {
namespace mojom {
class VariationsHeadersDataView;



}  // namespace mojom
}  // namespace variations

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::variations::mojom::VariationsHeadersDataView> {
  using Data = ::variations::mojom::internal::VariationsHeaders_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace variations {
namespace mojom {


enum class GoogleWebVisibility : int32_t {
  
  ANY = 0,
  
  FIRST_PARTY = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, GoogleWebVisibility value);
inline bool IsKnownEnumValue(GoogleWebVisibility value) {
  return internal::GoogleWebVisibility_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class VariationsHeadersDataView {
 public:
  VariationsHeadersDataView() {}

  VariationsHeadersDataView(
      internal::VariationsHeaders_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetHeadersMapDataView(
      mojo::MapDataView<GoogleWebVisibility, mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeadersMap(UserType* output) {
    
    auto* pointer = data_->headers_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::variations::mojom::GoogleWebVisibility, mojo::StringDataView>>(
        pointer, output, context_);
  }
 private:
  internal::VariationsHeaders_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace variations

namespace std {

template <>
struct hash<::variations::mojom::GoogleWebVisibility>
    : public mojo::internal::EnumHashImpl<::variations::mojom::GoogleWebVisibility> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::variations::mojom::GoogleWebVisibility, ::variations::mojom::GoogleWebVisibility> {
  static ::variations::mojom::GoogleWebVisibility ToMojom(::variations::mojom::GoogleWebVisibility input) { return input; }
  static bool FromMojom(::variations::mojom::GoogleWebVisibility input, ::variations::mojom::GoogleWebVisibility* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::variations::mojom::GoogleWebVisibility, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::variations::mojom::GoogleWebVisibility, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::variations::mojom::GoogleWebVisibility>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::variations::mojom::VariationsHeadersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::variations::mojom::VariationsHeadersDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::variations::mojom::internal::VariationsHeaders_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::headers_map(input)) in_headers_map = Traits::headers_map(input);
    typename decltype((*output)->headers_map)::BaseType::BufferWriter
        headers_map_writer;
    const mojo::internal::ContainerValidateParams headers_map_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::variations::mojom::internal::GoogleWebVisibility_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
    mojo::internal::Serialize<mojo::MapDataView<::variations::mojom::GoogleWebVisibility, mojo::StringDataView>>(
        in_headers_map, buffer, &headers_map_writer, &headers_map_validate_params,
        context);
    (*output)->headers_map.Set(
        headers_map_writer.is_null() ? nullptr : headers_map_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->headers_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers_map in VariationsHeaders struct");
  }

  static bool Deserialize(::variations::mojom::internal::VariationsHeaders_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::variations::mojom::VariationsHeadersDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace variations {
namespace mojom {

inline void VariationsHeadersDataView::GetHeadersMapDataView(
    mojo::MapDataView<GoogleWebVisibility, mojo::StringDataView>* output) {
  auto pointer = data_->headers_map.Get();
  *output = mojo::MapDataView<GoogleWebVisibility, mojo::StringDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace variations

#endif  // COMPONENTS_VARIATIONS_VARIATIONS_MOJOM_SHARED_H_