// content/common/navigation_params.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_NAVIGATION_PARAMS_MOJOM_SHARED_H_
#define CONTENT_COMMON_NAVIGATION_PARAMS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "content/common/navigation_params.mojom-shared-internal.h"
#include "content/common/prefetched_signed_exchange_info.mojom-shared.h"
#include "content/public/common/was_activated_option.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/network/public/mojom/web_client_hints_types.mojom-shared.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace content {
namespace mojom {
using ImpressionDataView = mojo::native::NativeStructDataView;

using NavigationDownloadPolicyDataView = mojo::native::NativeStructDataView;

using PageStateDataView = mojo::native::NativeStructDataView;

class InitiatorCSPInfoDataView;

class BeginNavigationParamsDataView;

class CommonNavigationParamsDataView;

class NavigationTimingDataView;

class OldPageInfoDataView;

class CommitNavigationParamsDataView;



}  // namespace mojom
}  // namespace content

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::InitiatorCSPInfoDataView> {
  using Data = ::content::mojom::internal::InitiatorCSPInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::BeginNavigationParamsDataView> {
  using Data = ::content::mojom::internal::BeginNavigationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CommonNavigationParamsDataView> {
  using Data = ::content::mojom::internal::CommonNavigationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::NavigationTimingDataView> {
  using Data = ::content::mojom::internal::NavigationTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::OldPageInfoDataView> {
  using Data = ::content::mojom::internal::OldPageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CommitNavigationParamsDataView> {
  using Data = ::content::mojom::internal::CommitNavigationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content {
namespace mojom {
using MixedContentContextType = mojo::NativeEnum;
using PageTransition = mojo::NativeEnum;


enum class NavigationType : int32_t {
  
  RELOAD = 0,
  
  RELOAD_BYPASSING_CACHE = 1,
  
  RELOAD_ORIGINAL_REQUEST_URL = 2,
  
  RESTORE = 3,
  
  RESTORE_WITH_POST = 4,
  
  HISTORY_SAME_DOCUMENT = 5,
  
  HISTORY_DIFFERENT_DOCUMENT = 6,
  
  SAME_DOCUMENT = 7,
  
  DIFFERENT_DOCUMENT = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, NavigationType value);
inline bool IsKnownEnumValue(NavigationType value) {
  return internal::NavigationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class InitiatorCSPInfoDataView {
 public:
  InitiatorCSPInfoDataView() {}

  InitiatorCSPInfoDataView(
      internal::InitiatorCSPInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadShouldCheckMainWorldCsp(UserType* output) const {
    auto data_value = data_->should_check_main_world_csp;
    return mojo::internal::Deserialize<::network::mojom::CSPDisposition>(
        data_value, output);
  }

  ::network::mojom::CSPDisposition should_check_main_world_csp() const {
    return static_cast<::network::mojom::CSPDisposition>(data_->should_check_main_world_csp);
  }
  inline void GetInitiatorCspDataView(
      mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInitiatorCsp(UserType* output) {
    
    auto* pointer = data_->initiator_csp.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
        pointer, output, context_);
  }
  inline void GetInitiatorSelfSourceDataView(
      ::network::mojom::CSPSourceDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInitiatorSelfSource(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CSPSourceDataView, UserType>(),
    "Attempting to read the optional `initiator_self_source` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorSelfSource` instead "
    "of `ReadInitiatorSelfSource if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_self_source.Get();
    return mojo::internal::Deserialize<::network::mojom::CSPSourceDataView>(
        pointer, output, context_);
  }
 private:
  internal::InitiatorCSPInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class BeginNavigationParamsDataView {
 public:
  BeginNavigationParamsDataView() {}

  BeginNavigationParamsDataView(
      internal::BeginNavigationParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t initiator_routing_id() const {
    return data_->initiator_routing_id;
  }
  inline void GetHeadersDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  int32_t load_flags() const {
    return data_->load_flags;
  }
  bool skip_service_worker() const {
    return data_->skip_service_worker;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestContextType(UserType* output) const {
    auto data_value = data_->request_context_type;
    return mojo::internal::Deserialize<::blink::mojom::RequestContextType>(
        data_value, output);
  }

  ::blink::mojom::RequestContextType request_context_type() const {
    return static_cast<::blink::mojom::RequestContextType>(data_->request_context_type);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestDestination(UserType* output) const {
    auto data_value = data_->request_destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }

  ::network::mojom::RequestDestination request_destination() const {
    return static_cast<::network::mojom::RequestDestination>(data_->request_destination);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMixedContentContextType(UserType* output) const {
    auto data_value = data_->mixed_content_context_type;
    return mojo::internal::Deserialize<::content::mojom::MixedContentContextType>(
        data_value, output);
  }

  MixedContentContextType mixed_content_context_type() const {
    return static_cast<MixedContentContextType>(data_->mixed_content_context_type);
  }
  bool is_form_submission() const {
    return data_->is_form_submission;
  }
  bool was_initiated_by_link_click() const {
    return data_->was_initiated_by_link_click;
  }
  inline void GetSearchableFormUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSearchableFormUrl(UserType* output) {
    
    auto* pointer = data_->searchable_form_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetSearchableFormEncodingDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSearchableFormEncoding(UserType* output) {
    
    auto* pointer = data_->searchable_form_encoding.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetClientSideRedirectUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadClientSideRedirectUrl(UserType* output) {
    
    auto* pointer = data_->client_side_redirect_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetDevtoolsInitiatorDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDevtoolsInitiator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::DictionaryValueDataView, UserType>(),
    "Attempting to read the optional `devtools_initiator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsInitiator` instead "
    "of `ReadDevtoolsInitiator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_initiator.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, context_);
  }
  bool force_ignore_site_for_cookies() const {
    return data_->force_ignore_site_for_cookies;
  }
  inline void GetTrustTokenParamsDataView(
      ::network::mojom::TrustTokenParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTrustTokenParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TrustTokenParamsDataView, UserType>(),
    "Attempting to read the optional `trust_token_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustTokenParams` instead "
    "of `ReadTrustTokenParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trust_token_params.Get();
    return mojo::internal::Deserialize<::network::mojom::TrustTokenParamsDataView>(
        pointer, output, context_);
  }
  inline void GetImpressionDataView(
      ImpressionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadImpression(UserType* output) {
    
    auto* pointer = data_->impression.Get();
    return mojo::internal::Deserialize<::content::mojom::ImpressionDataView>(
        pointer, output, context_);
  }
  inline void GetBeforeUnloadStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBeforeUnloadStart(UserType* output) {
    
    auto* pointer = data_->before_unload_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetBeforeUnloadEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBeforeUnloadEnd(UserType* output) {
    
    auto* pointer = data_->before_unload_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
 private:
  internal::BeginNavigationParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CommonNavigationParamsDataView {
 public:
  CommonNavigationParamsDataView() {}

  CommonNavigationParamsDataView(
      internal::CommonNavigationParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetInitiatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInitiatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `initiator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorOrigin` instead "
    "of `ReadInitiatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTransition(UserType* output) const {
    auto data_value = data_->transition;
    return mojo::internal::Deserialize<::content::mojom::PageTransition>(
        data_value, output);
  }

  PageTransition transition() const {
    return static_cast<PageTransition>(data_->transition);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNavigationType(UserType* output) const {
    auto data_value = data_->navigation_type;
    return mojo::internal::Deserialize<::content::mojom::NavigationType>(
        data_value, output);
  }

  NavigationType navigation_type() const {
    return static_cast<NavigationType>(data_->navigation_type);
  }
  inline void GetDownloadPolicyDataView(
      NavigationDownloadPolicyDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDownloadPolicy(UserType* output) {
    
    auto* pointer = data_->download_policy.Get();
    return mojo::internal::Deserialize<::content::mojom::NavigationDownloadPolicyDataView>(
        pointer, output, context_);
  }
  bool should_replace_current_entry() const {
    return data_->should_replace_current_entry;
  }
  inline void GetBaseUrlForDataUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBaseUrlForDataUrl(UserType* output) {
    
    auto* pointer = data_->base_url_for_data_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetHistoryUrlForDataUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHistoryUrlForDataUrl(UserType* output) {
    
    auto* pointer = data_->history_url_for_data_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  int32_t previews_state() const {
    return data_->previews_state;
  }
  inline void GetNavigationStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNavigationStart(UserType* output) {
    
    auto* pointer = data_->navigation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetPostDataDataView(
      ::network::mojom::URLRequestBodyDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPostData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLRequestBodyDataView, UserType>(),
    "Attempting to read the optional `post_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPostData` instead "
    "of `ReadPostData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->post_data.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestBodyDataView>(
        pointer, output, context_);
  }
  inline void GetSourceLocationDataView(
      ::network::mojom::SourceLocationDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSourceLocation(UserType* output) {
    
    auto* pointer = data_->source_location.Get();
    return mojo::internal::Deserialize<::network::mojom::SourceLocationDataView>(
        pointer, output, context_);
  }
  bool started_from_context_menu() const {
    return data_->started_from_context_menu;
  }
  bool has_user_gesture() const {
    return data_->has_user_gesture;
  }
  bool text_fragment_token() const {
    return data_->text_fragment_token;
  }
  inline void GetInitiatorCspInfoDataView(
      InitiatorCSPInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInitiatorCspInfo(UserType* output) {
    
    auto* pointer = data_->initiator_csp_info.Get();
    return mojo::internal::Deserialize<::content::mojom::InitiatorCSPInfoDataView>(
        pointer, output, context_);
  }
  inline void GetInitiatorOriginTrialFeaturesDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInitiatorOriginTrialFeatures(UserType* output) {
    
    auto* pointer = data_->initiator_origin_trial_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, context_);
  }
  inline void GetHrefTranslateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHrefTranslate(UserType* output) {
    
    auto* pointer = data_->href_translate.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool is_history_navigation_in_new_child_frame() const {
    return data_->is_history_navigation_in_new_child_frame;
  }
  inline void GetInputStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInputStart(UserType* output) {
    
    auto* pointer = data_->input_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
 private:
  internal::CommonNavigationParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NavigationTimingDataView {
 public:
  NavigationTimingDataView() {}

  NavigationTimingDataView(
      internal::NavigationTiming_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetRedirectStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRedirectStart(UserType* output) {
    
    auto* pointer = data_->redirect_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetRedirectEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRedirectEnd(UserType* output) {
    
    auto* pointer = data_->redirect_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetFetchStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFetchStart(UserType* output) {
    
    auto* pointer = data_->fetch_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
 private:
  internal::NavigationTiming_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class OldPageInfoDataView {
 public:
  OldPageInfoDataView() {}

  OldPageInfoDataView(
      internal::OldPageInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t routing_id_for_old_main_frame() const {
    return data_->routing_id_for_old_main_frame;
  }
  inline void GetNewLifecycleStateForOldPageDataView(
      ::blink::mojom::PageLifecycleStateDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNewLifecycleStateForOldPage(UserType* output) {
    
    auto* pointer = data_->new_lifecycle_state_for_old_page.Get();
    return mojo::internal::Deserialize<::blink::mojom::PageLifecycleStateDataView>(
        pointer, output, context_);
  }
 private:
  internal::OldPageInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CommitNavigationParamsDataView {
 public:
  CommitNavigationParamsDataView() {}

  CommitNavigationParamsDataView(
      internal::CommitNavigationParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOriginToCommitDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOriginToCommit(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `origin_to_commit` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOriginToCommit` instead "
    "of `ReadOriginToCommit if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->origin_to_commit.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  bool is_overriding_user_agent() const {
    return data_->is_overriding_user_agent;
  }
  inline void GetRedirectsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRedirects(UserType* output) {
    
    auto* pointer = data_->redirects.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, context_);
  }
  inline void GetRedirectResponseDataView(
      mojo::ArrayDataView<::network::mojom::URLResponseHeadDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRedirectResponse(UserType* output) {
    
    auto* pointer = data_->redirect_response.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::URLResponseHeadDataView>>(
        pointer, output, context_);
  }
  inline void GetRedirectInfosDataView(
      mojo::ArrayDataView<::network::mojom::URLRequestRedirectInfoDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRedirectInfos(UserType* output) {
    
    auto* pointer = data_->redirect_infos.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::URLRequestRedirectInfoDataView>>(
        pointer, output, context_);
  }
  inline void GetPostContentTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPostContentType(UserType* output) {
    
    auto* pointer = data_->post_content_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetOriginalUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOriginalUrl(UserType* output) {
    
    auto* pointer = data_->original_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetOriginalMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOriginalMethod(UserType* output) {
    
    auto* pointer = data_->original_method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool can_load_local_resources() const {
    return data_->can_load_local_resources;
  }
  inline void GetPageStateDataView(
      PageStateDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPageState(UserType* output) {
    
    auto* pointer = data_->page_state.Get();
    return mojo::internal::Deserialize<::content::mojom::PageStateDataView>(
        pointer, output, context_);
  }
  int32_t nav_entry_id() const {
    return data_->nav_entry_id;
  }
  inline void GetSubframeUniqueNamesDataView(
      mojo::MapDataView<mojo::StringDataView, bool>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubframeUniqueNames(UserType* output) {
    
    auto* pointer = data_->subframe_unique_names.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, bool>>(
        pointer, output, context_);
  }
  bool intended_as_new_entry() const {
    return data_->intended_as_new_entry;
  }
  int32_t pending_history_list_offset() const {
    return data_->pending_history_list_offset;
  }
  int32_t current_history_list_offset() const {
    return data_->current_history_list_offset;
  }
  int32_t current_history_list_length() const {
    return data_->current_history_list_length;
  }
  bool was_discarded() const {
    return data_->was_discarded;
  }
  bool is_view_source() const {
    return data_->is_view_source;
  }
  bool should_clear_history_list() const {
    return data_->should_clear_history_list;
  }
  inline void GetNavigationTimingDataView(
      NavigationTimingDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNavigationTiming(UserType* output) {
    
    auto* pointer = data_->navigation_timing.Get();
    return mojo::internal::Deserialize<::content::mojom::NavigationTimingDataView>(
        pointer, output, context_);
  }
  inline void GetAppcacheHostIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAppcacheHostId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `appcache_host_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAppcacheHostId` instead "
    "of `ReadAppcacheHostId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->appcache_host_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWasActivated(UserType* output) const {
    auto data_value = data_->was_activated;
    return mojo::internal::Deserialize<::content::mojom::WasActivatedOption>(
        data_value, output);
  }

  ::content::mojom::WasActivatedOption was_activated() const {
    return static_cast<::content::mojom::WasActivatedOption>(data_->was_activated);
  }
  inline void GetNavigationTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNavigationToken(UserType* output) {
    
    auto* pointer = data_->navigation_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
  inline void GetPrefetchedSignedExchangesDataView(
      mojo::ArrayDataView<::content::mojom::PrefetchedSignedExchangeInfoDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrefetchedSignedExchanges(UserType* output) {
    
    auto* pointer = data_->prefetched_signed_exchanges.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::content::mojom::PrefetchedSignedExchangeInfoDataView>>(
        pointer, output, context_);
  }
  bool is_browser_initiated() const {
    return data_->is_browser_initiated;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIpAddressSpace(UserType* output) const {
    auto data_value = data_->ip_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }

  ::network::mojom::IPAddressSpace ip_address_space() const {
    return static_cast<::network::mojom::IPAddressSpace>(data_->ip_address_space);
  }
  inline void GetWebBundlePhysicalUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWebBundlePhysicalUrl(UserType* output) {
    
    auto* pointer = data_->web_bundle_physical_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetWebBundleClaimedUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWebBundleClaimedUrl(UserType* output) {
    
    auto* pointer = data_->web_bundle_claimed_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  int64_t document_ukm_source_id() const {
    return data_->document_ukm_source_id;
  }
  inline void GetFramePolicyDataView(
      ::blink::mojom::FramePolicyDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFramePolicy(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FramePolicyDataView, UserType>(),
    "Attempting to read the optional `frame_policy` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFramePolicy` instead "
    "of `ReadFramePolicy if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_policy.Get();
    return mojo::internal::Deserialize<::blink::mojom::FramePolicyDataView>(
        pointer, output, context_);
  }
  inline void GetForceEnabledOriginTrialsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadForceEnabledOriginTrials(UserType* output) {
    
    auto* pointer = data_->force_enabled_origin_trials.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  bool origin_isolated() const {
    return data_->origin_isolated;
  }
  inline void GetEnabledClientHintsDataView(
      mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEnabledClientHints(UserType* output) {
    
    auto* pointer = data_->enabled_client_hints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
        pointer, output, context_);
  }
  bool is_cross_browsing_instance() const {
    return data_->is_cross_browsing_instance;
  }
  inline void GetForcedContentSecurityPoliciesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadForcedContentSecurityPolicies(UserType* output) {
    
    auto* pointer = data_->forced_content_security_policies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetOldPageInfoDataView(
      OldPageInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOldPageInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::OldPageInfoDataView, UserType>(),
    "Attempting to read the optional `old_page_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOldPageInfo` instead "
    "of `ReadOldPageInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->old_page_info.Get();
    return mojo::internal::Deserialize<::content::mojom::OldPageInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::CommitNavigationParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace content

namespace std {

template <>
struct hash<::content::mojom::NavigationType>
    : public mojo::internal::EnumHashImpl<::content::mojom::NavigationType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::content::mojom::NavigationType, ::content::mojom::NavigationType> {
  static ::content::mojom::NavigationType ToMojom(::content::mojom::NavigationType input) { return input; }
  static bool FromMojom(::content::mojom::NavigationType input, ::content::mojom::NavigationType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::NavigationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::NavigationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::content::mojom::NavigationType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::InitiatorCSPInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::InitiatorCSPInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::InitiatorCSPInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::CSPDisposition>(
        Traits::should_check_main_world_csp(input), &(*output)->should_check_main_world_csp);
    decltype(Traits::initiator_csp(input)) in_initiator_csp = Traits::initiator_csp(input);
    typename decltype((*output)->initiator_csp)::BaseType::BufferWriter
        initiator_csp_writer;
    const mojo::internal::ContainerValidateParams initiator_csp_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>>(
        in_initiator_csp, buffer, &initiator_csp_writer, &initiator_csp_validate_params,
        context);
    (*output)->initiator_csp.Set(
        initiator_csp_writer.is_null() ? nullptr : initiator_csp_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->initiator_csp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null initiator_csp in InitiatorCSPInfo struct");
    decltype(Traits::initiator_self_source(input)) in_initiator_self_source = Traits::initiator_self_source(input);
    typename decltype((*output)->initiator_self_source)::BaseType::BufferWriter
        initiator_self_source_writer;
    mojo::internal::Serialize<::network::mojom::CSPSourceDataView>(
        in_initiator_self_source, buffer, &initiator_self_source_writer, context);
    (*output)->initiator_self_source.Set(
        initiator_self_source_writer.is_null() ? nullptr : initiator_self_source_writer.data());
  }

  static bool Deserialize(::content::mojom::internal::InitiatorCSPInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::InitiatorCSPInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::BeginNavigationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::BeginNavigationParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::BeginNavigationParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->initiator_routing_id = Traits::initiator_routing_id(input);
    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    typename decltype((*output)->headers)::BaseType::BufferWriter
        headers_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_headers, buffer, &headers_writer, context);
    (*output)->headers.Set(
        headers_writer.is_null() ? nullptr : headers_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in BeginNavigationParams struct");
    (*output)->load_flags = Traits::load_flags(input);
    (*output)->skip_service_worker = Traits::skip_service_worker(input);
    mojo::internal::Serialize<::blink::mojom::RequestContextType>(
        Traits::request_context_type(input), &(*output)->request_context_type);
    mojo::internal::Serialize<::network::mojom::RequestDestination>(
        Traits::request_destination(input), &(*output)->request_destination);
    mojo::internal::Serialize<::content::mojom::MixedContentContextType>(
        Traits::mixed_content_context_type(input), &(*output)->mixed_content_context_type);
    (*output)->is_form_submission = Traits::is_form_submission(input);
    (*output)->was_initiated_by_link_click = Traits::was_initiated_by_link_click(input);
    decltype(Traits::searchable_form_url(input)) in_searchable_form_url = Traits::searchable_form_url(input);
    typename decltype((*output)->searchable_form_url)::BaseType::BufferWriter
        searchable_form_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_searchable_form_url, buffer, &searchable_form_url_writer, context);
    (*output)->searchable_form_url.Set(
        searchable_form_url_writer.is_null() ? nullptr : searchable_form_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->searchable_form_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null searchable_form_url in BeginNavigationParams struct");
    decltype(Traits::searchable_form_encoding(input)) in_searchable_form_encoding = Traits::searchable_form_encoding(input);
    typename decltype((*output)->searchable_form_encoding)::BaseType::BufferWriter
        searchable_form_encoding_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_searchable_form_encoding, buffer, &searchable_form_encoding_writer, context);
    (*output)->searchable_form_encoding.Set(
        searchable_form_encoding_writer.is_null() ? nullptr : searchable_form_encoding_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->searchable_form_encoding.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null searchable_form_encoding in BeginNavigationParams struct");
    decltype(Traits::client_side_redirect_url(input)) in_client_side_redirect_url = Traits::client_side_redirect_url(input);
    typename decltype((*output)->client_side_redirect_url)::BaseType::BufferWriter
        client_side_redirect_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_client_side_redirect_url, buffer, &client_side_redirect_url_writer, context);
    (*output)->client_side_redirect_url.Set(
        client_side_redirect_url_writer.is_null() ? nullptr : client_side_redirect_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->client_side_redirect_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null client_side_redirect_url in BeginNavigationParams struct");
    decltype(Traits::devtools_initiator(input)) in_devtools_initiator = Traits::devtools_initiator(input);
    typename decltype((*output)->devtools_initiator)::BaseType::BufferWriter
        devtools_initiator_writer;
    mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
        in_devtools_initiator, buffer, &devtools_initiator_writer, context);
    (*output)->devtools_initiator.Set(
        devtools_initiator_writer.is_null() ? nullptr : devtools_initiator_writer.data());
    (*output)->force_ignore_site_for_cookies = Traits::force_ignore_site_for_cookies(input);
    decltype(Traits::trust_token_params(input)) in_trust_token_params = Traits::trust_token_params(input);
    typename decltype((*output)->trust_token_params)::BaseType::BufferWriter
        trust_token_params_writer;
    mojo::internal::Serialize<::network::mojom::TrustTokenParamsDataView>(
        in_trust_token_params, buffer, &trust_token_params_writer, context);
    (*output)->trust_token_params.Set(
        trust_token_params_writer.is_null() ? nullptr : trust_token_params_writer.data());
    decltype(Traits::impression(input)) in_impression = Traits::impression(input);
    typename decltype((*output)->impression)::BaseType::BufferWriter
        impression_writer;
    mojo::internal::Serialize<::content::mojom::ImpressionDataView>(
        in_impression, buffer, &impression_writer, context);
    (*output)->impression.Set(
        impression_writer.is_null() ? nullptr : impression_writer.data());
    decltype(Traits::before_unload_start(input)) in_before_unload_start = Traits::before_unload_start(input);
    typename decltype((*output)->before_unload_start)::BaseType::BufferWriter
        before_unload_start_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_before_unload_start, buffer, &before_unload_start_writer, context);
    (*output)->before_unload_start.Set(
        before_unload_start_writer.is_null() ? nullptr : before_unload_start_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->before_unload_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null before_unload_start in BeginNavigationParams struct");
    decltype(Traits::before_unload_end(input)) in_before_unload_end = Traits::before_unload_end(input);
    typename decltype((*output)->before_unload_end)::BaseType::BufferWriter
        before_unload_end_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_before_unload_end, buffer, &before_unload_end_writer, context);
    (*output)->before_unload_end.Set(
        before_unload_end_writer.is_null() ? nullptr : before_unload_end_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->before_unload_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null before_unload_end in BeginNavigationParams struct");
  }

  static bool Deserialize(::content::mojom::internal::BeginNavigationParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::BeginNavigationParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CommonNavigationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CommonNavigationParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::CommonNavigationParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in CommonNavigationParams struct");
    decltype(Traits::initiator_origin(input)) in_initiator_origin = Traits::initiator_origin(input);
    typename decltype((*output)->initiator_origin)::BaseType::BufferWriter
        initiator_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_initiator_origin, buffer, &initiator_origin_writer, context);
    (*output)->initiator_origin.Set(
        initiator_origin_writer.is_null() ? nullptr : initiator_origin_writer.data());
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    typename decltype((*output)->referrer)::BaseType::BufferWriter
        referrer_writer;
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
        in_referrer, buffer, &referrer_writer, context);
    (*output)->referrer.Set(
        referrer_writer.is_null() ? nullptr : referrer_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->referrer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in CommonNavigationParams struct");
    mojo::internal::Serialize<::content::mojom::PageTransition>(
        Traits::transition(input), &(*output)->transition);
    mojo::internal::Serialize<::content::mojom::NavigationType>(
        Traits::navigation_type(input), &(*output)->navigation_type);
    decltype(Traits::download_policy(input)) in_download_policy = Traits::download_policy(input);
    typename decltype((*output)->download_policy)::BaseType::BufferWriter
        download_policy_writer;
    mojo::internal::Serialize<::content::mojom::NavigationDownloadPolicyDataView>(
        in_download_policy, buffer, &download_policy_writer, context);
    (*output)->download_policy.Set(
        download_policy_writer.is_null() ? nullptr : download_policy_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->download_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null download_policy in CommonNavigationParams struct");
    (*output)->should_replace_current_entry = Traits::should_replace_current_entry(input);
    decltype(Traits::base_url_for_data_url(input)) in_base_url_for_data_url = Traits::base_url_for_data_url(input);
    typename decltype((*output)->base_url_for_data_url)::BaseType::BufferWriter
        base_url_for_data_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_base_url_for_data_url, buffer, &base_url_for_data_url_writer, context);
    (*output)->base_url_for_data_url.Set(
        base_url_for_data_url_writer.is_null() ? nullptr : base_url_for_data_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->base_url_for_data_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null base_url_for_data_url in CommonNavigationParams struct");
    decltype(Traits::history_url_for_data_url(input)) in_history_url_for_data_url = Traits::history_url_for_data_url(input);
    typename decltype((*output)->history_url_for_data_url)::BaseType::BufferWriter
        history_url_for_data_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_history_url_for_data_url, buffer, &history_url_for_data_url_writer, context);
    (*output)->history_url_for_data_url.Set(
        history_url_for_data_url_writer.is_null() ? nullptr : history_url_for_data_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->history_url_for_data_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null history_url_for_data_url in CommonNavigationParams struct");
    (*output)->previews_state = Traits::previews_state(input);
    decltype(Traits::navigation_start(input)) in_navigation_start = Traits::navigation_start(input);
    typename decltype((*output)->navigation_start)::BaseType::BufferWriter
        navigation_start_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_navigation_start, buffer, &navigation_start_writer, context);
    (*output)->navigation_start.Set(
        navigation_start_writer.is_null() ? nullptr : navigation_start_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->navigation_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_start in CommonNavigationParams struct");
    decltype(Traits::method(input)) in_method = Traits::method(input);
    typename decltype((*output)->method)::BaseType::BufferWriter
        method_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_method, buffer, &method_writer, context);
    (*output)->method.Set(
        method_writer.is_null() ? nullptr : method_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->method.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in CommonNavigationParams struct");
    decltype(Traits::post_data(input)) in_post_data = Traits::post_data(input);
    typename decltype((*output)->post_data)::BaseType::BufferWriter
        post_data_writer;
    mojo::internal::Serialize<::network::mojom::URLRequestBodyDataView>(
        in_post_data, buffer, &post_data_writer, context);
    (*output)->post_data.Set(
        post_data_writer.is_null() ? nullptr : post_data_writer.data());
    decltype(Traits::source_location(input)) in_source_location = Traits::source_location(input);
    typename decltype((*output)->source_location)::BaseType::BufferWriter
        source_location_writer;
    mojo::internal::Serialize<::network::mojom::SourceLocationDataView>(
        in_source_location, buffer, &source_location_writer, context);
    (*output)->source_location.Set(
        source_location_writer.is_null() ? nullptr : source_location_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->source_location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_location in CommonNavigationParams struct");
    (*output)->started_from_context_menu = Traits::started_from_context_menu(input);
    (*output)->has_user_gesture = Traits::has_user_gesture(input);
    (*output)->text_fragment_token = Traits::text_fragment_token(input);
    decltype(Traits::initiator_csp_info(input)) in_initiator_csp_info = Traits::initiator_csp_info(input);
    typename decltype((*output)->initiator_csp_info)::BaseType::BufferWriter
        initiator_csp_info_writer;
    mojo::internal::Serialize<::content::mojom::InitiatorCSPInfoDataView>(
        in_initiator_csp_info, buffer, &initiator_csp_info_writer, context);
    (*output)->initiator_csp_info.Set(
        initiator_csp_info_writer.is_null() ? nullptr : initiator_csp_info_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->initiator_csp_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null initiator_csp_info in CommonNavigationParams struct");
    decltype(Traits::initiator_origin_trial_features(input)) in_initiator_origin_trial_features = Traits::initiator_origin_trial_features(input);
    typename decltype((*output)->initiator_origin_trial_features)::BaseType::BufferWriter
        initiator_origin_trial_features_writer;
    const mojo::internal::ContainerValidateParams initiator_origin_trial_features_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
        in_initiator_origin_trial_features, buffer, &initiator_origin_trial_features_writer, &initiator_origin_trial_features_validate_params,
        context);
    (*output)->initiator_origin_trial_features.Set(
        initiator_origin_trial_features_writer.is_null() ? nullptr : initiator_origin_trial_features_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->initiator_origin_trial_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null initiator_origin_trial_features in CommonNavigationParams struct");
    decltype(Traits::href_translate(input)) in_href_translate = Traits::href_translate(input);
    typename decltype((*output)->href_translate)::BaseType::BufferWriter
        href_translate_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_href_translate, buffer, &href_translate_writer, context);
    (*output)->href_translate.Set(
        href_translate_writer.is_null() ? nullptr : href_translate_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->href_translate.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null href_translate in CommonNavigationParams struct");
    (*output)->is_history_navigation_in_new_child_frame = Traits::is_history_navigation_in_new_child_frame(input);
    decltype(Traits::input_start(input)) in_input_start = Traits::input_start(input);
    typename decltype((*output)->input_start)::BaseType::BufferWriter
        input_start_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_input_start, buffer, &input_start_writer, context);
    (*output)->input_start.Set(
        input_start_writer.is_null() ? nullptr : input_start_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->input_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input_start in CommonNavigationParams struct");
  }

  static bool Deserialize(::content::mojom::internal::CommonNavigationParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CommonNavigationParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::NavigationTimingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::NavigationTimingDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::NavigationTiming_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::redirect_start(input)) in_redirect_start = Traits::redirect_start(input);
    typename decltype((*output)->redirect_start)::BaseType::BufferWriter
        redirect_start_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_redirect_start, buffer, &redirect_start_writer, context);
    (*output)->redirect_start.Set(
        redirect_start_writer.is_null() ? nullptr : redirect_start_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->redirect_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirect_start in NavigationTiming struct");
    decltype(Traits::redirect_end(input)) in_redirect_end = Traits::redirect_end(input);
    typename decltype((*output)->redirect_end)::BaseType::BufferWriter
        redirect_end_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_redirect_end, buffer, &redirect_end_writer, context);
    (*output)->redirect_end.Set(
        redirect_end_writer.is_null() ? nullptr : redirect_end_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->redirect_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirect_end in NavigationTiming struct");
    decltype(Traits::fetch_start(input)) in_fetch_start = Traits::fetch_start(input);
    typename decltype((*output)->fetch_start)::BaseType::BufferWriter
        fetch_start_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_fetch_start, buffer, &fetch_start_writer, context);
    (*output)->fetch_start.Set(
        fetch_start_writer.is_null() ? nullptr : fetch_start_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->fetch_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fetch_start in NavigationTiming struct");
  }

  static bool Deserialize(::content::mojom::internal::NavigationTiming_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::NavigationTimingDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::OldPageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::OldPageInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::OldPageInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->routing_id_for_old_main_frame = Traits::routing_id_for_old_main_frame(input);
    decltype(Traits::new_lifecycle_state_for_old_page(input)) in_new_lifecycle_state_for_old_page = Traits::new_lifecycle_state_for_old_page(input);
    typename decltype((*output)->new_lifecycle_state_for_old_page)::BaseType::BufferWriter
        new_lifecycle_state_for_old_page_writer;
    mojo::internal::Serialize<::blink::mojom::PageLifecycleStateDataView>(
        in_new_lifecycle_state_for_old_page, buffer, &new_lifecycle_state_for_old_page_writer, context);
    (*output)->new_lifecycle_state_for_old_page.Set(
        new_lifecycle_state_for_old_page_writer.is_null() ? nullptr : new_lifecycle_state_for_old_page_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->new_lifecycle_state_for_old_page.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null new_lifecycle_state_for_old_page in OldPageInfo struct");
  }

  static bool Deserialize(::content::mojom::internal::OldPageInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::OldPageInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CommitNavigationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CommitNavigationParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::CommitNavigationParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::origin_to_commit(input)) in_origin_to_commit = Traits::origin_to_commit(input);
    typename decltype((*output)->origin_to_commit)::BaseType::BufferWriter
        origin_to_commit_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin_to_commit, buffer, &origin_to_commit_writer, context);
    (*output)->origin_to_commit.Set(
        origin_to_commit_writer.is_null() ? nullptr : origin_to_commit_writer.data());
    (*output)->is_overriding_user_agent = Traits::is_overriding_user_agent(input);
    decltype(Traits::redirects(input)) in_redirects = Traits::redirects(input);
    typename decltype((*output)->redirects)::BaseType::BufferWriter
        redirects_writer;
    const mojo::internal::ContainerValidateParams redirects_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_redirects, buffer, &redirects_writer, &redirects_validate_params,
        context);
    (*output)->redirects.Set(
        redirects_writer.is_null() ? nullptr : redirects_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->redirects.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirects in CommitNavigationParams struct");
    decltype(Traits::redirect_response(input)) in_redirect_response = Traits::redirect_response(input);
    typename decltype((*output)->redirect_response)::BaseType::BufferWriter
        redirect_response_writer;
    const mojo::internal::ContainerValidateParams redirect_response_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::URLResponseHeadDataView>>(
        in_redirect_response, buffer, &redirect_response_writer, &redirect_response_validate_params,
        context);
    (*output)->redirect_response.Set(
        redirect_response_writer.is_null() ? nullptr : redirect_response_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->redirect_response.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirect_response in CommitNavigationParams struct");
    decltype(Traits::redirect_infos(input)) in_redirect_infos = Traits::redirect_infos(input);
    typename decltype((*output)->redirect_infos)::BaseType::BufferWriter
        redirect_infos_writer;
    const mojo::internal::ContainerValidateParams redirect_infos_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::URLRequestRedirectInfoDataView>>(
        in_redirect_infos, buffer, &redirect_infos_writer, &redirect_infos_validate_params,
        context);
    (*output)->redirect_infos.Set(
        redirect_infos_writer.is_null() ? nullptr : redirect_infos_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->redirect_infos.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null redirect_infos in CommitNavigationParams struct");
    decltype(Traits::post_content_type(input)) in_post_content_type = Traits::post_content_type(input);
    typename decltype((*output)->post_content_type)::BaseType::BufferWriter
        post_content_type_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_post_content_type, buffer, &post_content_type_writer, context);
    (*output)->post_content_type.Set(
        post_content_type_writer.is_null() ? nullptr : post_content_type_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->post_content_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null post_content_type in CommitNavigationParams struct");
    decltype(Traits::original_url(input)) in_original_url = Traits::original_url(input);
    typename decltype((*output)->original_url)::BaseType::BufferWriter
        original_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_original_url, buffer, &original_url_writer, context);
    (*output)->original_url.Set(
        original_url_writer.is_null() ? nullptr : original_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->original_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null original_url in CommitNavigationParams struct");
    decltype(Traits::original_method(input)) in_original_method = Traits::original_method(input);
    typename decltype((*output)->original_method)::BaseType::BufferWriter
        original_method_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_original_method, buffer, &original_method_writer, context);
    (*output)->original_method.Set(
        original_method_writer.is_null() ? nullptr : original_method_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->original_method.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null original_method in CommitNavigationParams struct");
    (*output)->can_load_local_resources = Traits::can_load_local_resources(input);
    decltype(Traits::page_state(input)) in_page_state = Traits::page_state(input);
    typename decltype((*output)->page_state)::BaseType::BufferWriter
        page_state_writer;
    mojo::internal::Serialize<::content::mojom::PageStateDataView>(
        in_page_state, buffer, &page_state_writer, context);
    (*output)->page_state.Set(
        page_state_writer.is_null() ? nullptr : page_state_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->page_state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_state in CommitNavigationParams struct");
    (*output)->nav_entry_id = Traits::nav_entry_id(input);
    decltype(Traits::subframe_unique_names(input)) in_subframe_unique_names = Traits::subframe_unique_names(input);
    typename decltype((*output)->subframe_unique_names)::BaseType::BufferWriter
        subframe_unique_names_writer;
    const mojo::internal::ContainerValidateParams subframe_unique_names_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, bool>>(
        in_subframe_unique_names, buffer, &subframe_unique_names_writer, &subframe_unique_names_validate_params,
        context);
    (*output)->subframe_unique_names.Set(
        subframe_unique_names_writer.is_null() ? nullptr : subframe_unique_names_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->subframe_unique_names.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subframe_unique_names in CommitNavigationParams struct");
    (*output)->intended_as_new_entry = Traits::intended_as_new_entry(input);
    (*output)->pending_history_list_offset = Traits::pending_history_list_offset(input);
    (*output)->current_history_list_offset = Traits::current_history_list_offset(input);
    (*output)->current_history_list_length = Traits::current_history_list_length(input);
    (*output)->was_discarded = Traits::was_discarded(input);
    (*output)->is_view_source = Traits::is_view_source(input);
    (*output)->should_clear_history_list = Traits::should_clear_history_list(input);
    decltype(Traits::navigation_timing(input)) in_navigation_timing = Traits::navigation_timing(input);
    typename decltype((*output)->navigation_timing)::BaseType::BufferWriter
        navigation_timing_writer;
    mojo::internal::Serialize<::content::mojom::NavigationTimingDataView>(
        in_navigation_timing, buffer, &navigation_timing_writer, context);
    (*output)->navigation_timing.Set(
        navigation_timing_writer.is_null() ? nullptr : navigation_timing_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->navigation_timing.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_timing in CommitNavigationParams struct");
    decltype(Traits::appcache_host_id(input)) in_appcache_host_id = Traits::appcache_host_id(input);
    typename decltype((*output)->appcache_host_id)::BaseType::BufferWriter
        appcache_host_id_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_appcache_host_id, buffer, &appcache_host_id_writer, context);
    (*output)->appcache_host_id.Set(
        appcache_host_id_writer.is_null() ? nullptr : appcache_host_id_writer.data());
    mojo::internal::Serialize<::content::mojom::WasActivatedOption>(
        Traits::was_activated(input), &(*output)->was_activated);
    decltype(Traits::navigation_token(input)) in_navigation_token = Traits::navigation_token(input);
    typename decltype((*output)->navigation_token)::BaseType::BufferWriter
        navigation_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_navigation_token, buffer, &navigation_token_writer, context);
    (*output)->navigation_token.Set(
        navigation_token_writer.is_null() ? nullptr : navigation_token_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->navigation_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_token in CommitNavigationParams struct");
    decltype(Traits::prefetched_signed_exchanges(input)) in_prefetched_signed_exchanges = Traits::prefetched_signed_exchanges(input);
    typename decltype((*output)->prefetched_signed_exchanges)::BaseType::BufferWriter
        prefetched_signed_exchanges_writer;
    const mojo::internal::ContainerValidateParams prefetched_signed_exchanges_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::content::mojom::PrefetchedSignedExchangeInfoDataView>>(
        in_prefetched_signed_exchanges, buffer, &prefetched_signed_exchanges_writer, &prefetched_signed_exchanges_validate_params,
        context);
    (*output)->prefetched_signed_exchanges.Set(
        prefetched_signed_exchanges_writer.is_null() ? nullptr : prefetched_signed_exchanges_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->prefetched_signed_exchanges.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null prefetched_signed_exchanges in CommitNavigationParams struct");
    (*output)->is_browser_initiated = Traits::is_browser_initiated(input);
    mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::ip_address_space(input), &(*output)->ip_address_space);
    decltype(Traits::web_bundle_physical_url(input)) in_web_bundle_physical_url = Traits::web_bundle_physical_url(input);
    typename decltype((*output)->web_bundle_physical_url)::BaseType::BufferWriter
        web_bundle_physical_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_web_bundle_physical_url, buffer, &web_bundle_physical_url_writer, context);
    (*output)->web_bundle_physical_url.Set(
        web_bundle_physical_url_writer.is_null() ? nullptr : web_bundle_physical_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->web_bundle_physical_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_bundle_physical_url in CommitNavigationParams struct");
    decltype(Traits::web_bundle_claimed_url(input)) in_web_bundle_claimed_url = Traits::web_bundle_claimed_url(input);
    typename decltype((*output)->web_bundle_claimed_url)::BaseType::BufferWriter
        web_bundle_claimed_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_web_bundle_claimed_url, buffer, &web_bundle_claimed_url_writer, context);
    (*output)->web_bundle_claimed_url.Set(
        web_bundle_claimed_url_writer.is_null() ? nullptr : web_bundle_claimed_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->web_bundle_claimed_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_bundle_claimed_url in CommitNavigationParams struct");
    (*output)->document_ukm_source_id = Traits::document_ukm_source_id(input);
    decltype(Traits::frame_policy(input)) in_frame_policy = Traits::frame_policy(input);
    typename decltype((*output)->frame_policy)::BaseType::BufferWriter
        frame_policy_writer;
    mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
        in_frame_policy, buffer, &frame_policy_writer, context);
    (*output)->frame_policy.Set(
        frame_policy_writer.is_null() ? nullptr : frame_policy_writer.data());
    decltype(Traits::force_enabled_origin_trials(input)) in_force_enabled_origin_trials = Traits::force_enabled_origin_trials(input);
    typename decltype((*output)->force_enabled_origin_trials)::BaseType::BufferWriter
        force_enabled_origin_trials_writer;
    const mojo::internal::ContainerValidateParams force_enabled_origin_trials_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_force_enabled_origin_trials, buffer, &force_enabled_origin_trials_writer, &force_enabled_origin_trials_validate_params,
        context);
    (*output)->force_enabled_origin_trials.Set(
        force_enabled_origin_trials_writer.is_null() ? nullptr : force_enabled_origin_trials_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->force_enabled_origin_trials.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null force_enabled_origin_trials in CommitNavigationParams struct");
    (*output)->origin_isolated = Traits::origin_isolated(input);
    decltype(Traits::enabled_client_hints(input)) in_enabled_client_hints = Traits::enabled_client_hints(input);
    typename decltype((*output)->enabled_client_hints)::BaseType::BufferWriter
        enabled_client_hints_writer;
    const mojo::internal::ContainerValidateParams enabled_client_hints_validate_params(
        0, ::network::mojom::internal::WebClientHintsType_Data::Validate);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::WebClientHintsType>>(
        in_enabled_client_hints, buffer, &enabled_client_hints_writer, &enabled_client_hints_validate_params,
        context);
    (*output)->enabled_client_hints.Set(
        enabled_client_hints_writer.is_null() ? nullptr : enabled_client_hints_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->enabled_client_hints.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null enabled_client_hints in CommitNavigationParams struct");
    (*output)->is_cross_browsing_instance = Traits::is_cross_browsing_instance(input);
    decltype(Traits::forced_content_security_policies(input)) in_forced_content_security_policies = Traits::forced_content_security_policies(input);
    typename decltype((*output)->forced_content_security_policies)::BaseType::BufferWriter
        forced_content_security_policies_writer;
    const mojo::internal::ContainerValidateParams forced_content_security_policies_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_forced_content_security_policies, buffer, &forced_content_security_policies_writer, &forced_content_security_policies_validate_params,
        context);
    (*output)->forced_content_security_policies.Set(
        forced_content_security_policies_writer.is_null() ? nullptr : forced_content_security_policies_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->forced_content_security_policies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null forced_content_security_policies in CommitNavigationParams struct");
    decltype(Traits::old_page_info(input)) in_old_page_info = Traits::old_page_info(input);
    typename decltype((*output)->old_page_info)::BaseType::BufferWriter
        old_page_info_writer;
    mojo::internal::Serialize<::content::mojom::OldPageInfoDataView>(
        in_old_page_info, buffer, &old_page_info_writer, context);
    (*output)->old_page_info.Set(
        old_page_info_writer.is_null() ? nullptr : old_page_info_writer.data());
  }

  static bool Deserialize(::content::mojom::internal::CommitNavigationParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CommitNavigationParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content {
namespace mojom {

inline void InitiatorCSPInfoDataView::GetInitiatorCspDataView(
    mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>* output) {
  auto pointer = data_->initiator_csp.Get();
  *output = mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>(pointer, context_);
}
inline void InitiatorCSPInfoDataView::GetInitiatorSelfSourceDataView(
    ::network::mojom::CSPSourceDataView* output) {
  auto pointer = data_->initiator_self_source.Get();
  *output = ::network::mojom::CSPSourceDataView(pointer, context_);
}


inline void BeginNavigationParamsDataView::GetHeadersDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void BeginNavigationParamsDataView::GetSearchableFormUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->searchable_form_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void BeginNavigationParamsDataView::GetSearchableFormEncodingDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->searchable_form_encoding.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void BeginNavigationParamsDataView::GetClientSideRedirectUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->client_side_redirect_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void BeginNavigationParamsDataView::GetDevtoolsInitiatorDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->devtools_initiator.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, context_);
}
inline void BeginNavigationParamsDataView::GetTrustTokenParamsDataView(
    ::network::mojom::TrustTokenParamsDataView* output) {
  auto pointer = data_->trust_token_params.Get();
  *output = ::network::mojom::TrustTokenParamsDataView(pointer, context_);
}
inline void BeginNavigationParamsDataView::GetImpressionDataView(
    ImpressionDataView* output) {
  auto pointer = data_->impression.Get();
  *output = ImpressionDataView(pointer, context_);
}
inline void BeginNavigationParamsDataView::GetBeforeUnloadStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->before_unload_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void BeginNavigationParamsDataView::GetBeforeUnloadEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->before_unload_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}


inline void CommonNavigationParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetInitiatorOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->initiator_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetDownloadPolicyDataView(
    NavigationDownloadPolicyDataView* output) {
  auto pointer = data_->download_policy.Get();
  *output = NavigationDownloadPolicyDataView(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetBaseUrlForDataUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->base_url_for_data_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetHistoryUrlForDataUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->history_url_for_data_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetNavigationStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->navigation_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetPostDataDataView(
    ::network::mojom::URLRequestBodyDataView* output) {
  auto pointer = data_->post_data.Get();
  *output = ::network::mojom::URLRequestBodyDataView(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetSourceLocationDataView(
    ::network::mojom::SourceLocationDataView* output) {
  auto pointer = data_->source_location.Get();
  *output = ::network::mojom::SourceLocationDataView(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetInitiatorCspInfoDataView(
    InitiatorCSPInfoDataView* output) {
  auto pointer = data_->initiator_csp_info.Get();
  *output = InitiatorCSPInfoDataView(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetInitiatorOriginTrialFeaturesDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->initiator_origin_trial_features.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetHrefTranslateDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->href_translate.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CommonNavigationParamsDataView::GetInputStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->input_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}


inline void NavigationTimingDataView::GetRedirectStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->redirect_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void NavigationTimingDataView::GetRedirectEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->redirect_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void NavigationTimingDataView::GetFetchStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->fetch_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}


inline void OldPageInfoDataView::GetNewLifecycleStateForOldPageDataView(
    ::blink::mojom::PageLifecycleStateDataView* output) {
  auto pointer = data_->new_lifecycle_state_for_old_page.Get();
  *output = ::blink::mojom::PageLifecycleStateDataView(pointer, context_);
}


inline void CommitNavigationParamsDataView::GetOriginToCommitDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin_to_commit.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetRedirectsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->redirects.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetRedirectResponseDataView(
    mojo::ArrayDataView<::network::mojom::URLResponseHeadDataView>* output) {
  auto pointer = data_->redirect_response.Get();
  *output = mojo::ArrayDataView<::network::mojom::URLResponseHeadDataView>(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetRedirectInfosDataView(
    mojo::ArrayDataView<::network::mojom::URLRequestRedirectInfoDataView>* output) {
  auto pointer = data_->redirect_infos.Get();
  *output = mojo::ArrayDataView<::network::mojom::URLRequestRedirectInfoDataView>(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetPostContentTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->post_content_type.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetOriginalUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->original_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetOriginalMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->original_method.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetPageStateDataView(
    PageStateDataView* output) {
  auto pointer = data_->page_state.Get();
  *output = PageStateDataView(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetSubframeUniqueNamesDataView(
    mojo::MapDataView<mojo::StringDataView, bool>* output) {
  auto pointer = data_->subframe_unique_names.Get();
  *output = mojo::MapDataView<mojo::StringDataView, bool>(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetNavigationTimingDataView(
    NavigationTimingDataView* output) {
  auto pointer = data_->navigation_timing.Get();
  *output = NavigationTimingDataView(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetAppcacheHostIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->appcache_host_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetNavigationTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->navigation_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetPrefetchedSignedExchangesDataView(
    mojo::ArrayDataView<::content::mojom::PrefetchedSignedExchangeInfoDataView>* output) {
  auto pointer = data_->prefetched_signed_exchanges.Get();
  *output = mojo::ArrayDataView<::content::mojom::PrefetchedSignedExchangeInfoDataView>(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetWebBundlePhysicalUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->web_bundle_physical_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetWebBundleClaimedUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->web_bundle_claimed_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetFramePolicyDataView(
    ::blink::mojom::FramePolicyDataView* output) {
  auto pointer = data_->frame_policy.Get();
  *output = ::blink::mojom::FramePolicyDataView(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetForceEnabledOriginTrialsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->force_enabled_origin_trials.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetEnabledClientHintsDataView(
    mojo::ArrayDataView<::network::mojom::WebClientHintsType>* output) {
  auto pointer = data_->enabled_client_hints.Get();
  *output = mojo::ArrayDataView<::network::mojom::WebClientHintsType>(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetForcedContentSecurityPoliciesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->forced_content_security_policies.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void CommitNavigationParamsDataView::GetOldPageInfoDataView(
    OldPageInfoDataView* output) {
  auto pointer = data_->old_page_info.Get();
  *output = OldPageInfoDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_NAVIGATION_PARAMS_MOJOM_SHARED_H_