// content/common/renderer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDERER_MOJOM_SHARED_H_
#define CONTENT_COMMON_RENDERER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "content/common/renderer.mojom-shared-internal.h"
#include "content/common/agent_scheduling_group.mojom-shared.h"
#include "content/common/native_types.mojom-shared.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace content {
namespace mojom {
class UpdateScrollbarThemeParamsDataView;

class UpdateSystemColorInfoParamsDataView;



}  // namespace mojom
}  // namespace content

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::UpdateScrollbarThemeParamsDataView> {
  using Data = ::content::mojom::internal::UpdateScrollbarThemeParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::UpdateSystemColorInfoParamsDataView> {
  using Data = ::content::mojom::internal::UpdateSystemColorInfoParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace content {
namespace mojom {


enum class RenderProcessBackgroundState : int32_t {
  
  kForegrounded = 0,
  
  kBackgrounded = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, RenderProcessBackgroundState value);
inline bool IsKnownEnumValue(RenderProcessBackgroundState value) {
  return internal::RenderProcessBackgroundState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RenderProcessVisibleState : int32_t {
  
  kVisible = 0,
  
  kHidden = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, RenderProcessVisibleState value);
inline bool IsKnownEnumValue(RenderProcessVisibleState value) {
  return internal::RenderProcessVisibleState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class RendererInterfaceBase {};

using RendererPtrDataView =
    mojo::InterfacePtrDataView<RendererInterfaceBase>;
using RendererRequestDataView =
    mojo::InterfaceRequestDataView<RendererInterfaceBase>;
using RendererAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RendererInterfaceBase>;
using RendererAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RendererInterfaceBase>;


class UpdateScrollbarThemeParamsDataView {
 public:
  UpdateScrollbarThemeParamsDataView() {}

  UpdateScrollbarThemeParamsDataView(
      internal::UpdateScrollbarThemeParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool has_initial_button_delay() const {
    return data_->has_initial_button_delay;
  }
  float initial_button_delay() const {
    return data_->initial_button_delay;
  }
  bool has_autoscroll_button_delay() const {
    return data_->has_autoscroll_button_delay;
  }
  float autoscroll_button_delay() const {
    return data_->autoscroll_button_delay;
  }
  bool jump_on_track_click() const {
    return data_->jump_on_track_click;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPreferredScrollerStyle(UserType* output) const {
    auto data_value = data_->preferred_scroller_style;
    return mojo::internal::Deserialize<::content::mojom::ScrollerStyle>(
        data_value, output);
  }

  ::content::mojom::ScrollerStyle preferred_scroller_style() const {
    return static_cast<::content::mojom::ScrollerStyle>(data_->preferred_scroller_style);
  }
  bool redraw() const {
    return data_->redraw;
  }
  bool scroll_view_rubber_banding() const {
    return data_->scroll_view_rubber_banding;
  }
 private:
  internal::UpdateScrollbarThemeParams_Data* data_ = nullptr;
};



class UpdateSystemColorInfoParamsDataView {
 public:
  UpdateSystemColorInfoParamsDataView() {}

  UpdateSystemColorInfoParamsDataView(
      internal::UpdateSystemColorInfoParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool is_dark_mode() const {
    return data_->is_dark_mode;
  }
  bool is_high_contrast() const {
    return data_->is_high_contrast;
  }
  inline void GetColorsDataView(
      mojo::MapDataView<::content::mojom::SystemThemeColor, uint32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadColors(UserType* output) {
    
    auto* pointer = data_->colors.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::content::mojom::SystemThemeColor, uint32_t>>(
        pointer, output, context_);
  }
 private:
  internal::UpdateSystemColorInfoParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace content

namespace std {

template <>
struct hash<::content::mojom::RenderProcessBackgroundState>
    : public mojo::internal::EnumHashImpl<::content::mojom::RenderProcessBackgroundState> {};

template <>
struct hash<::content::mojom::RenderProcessVisibleState>
    : public mojo::internal::EnumHashImpl<::content::mojom::RenderProcessVisibleState> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::content::mojom::RenderProcessBackgroundState, ::content::mojom::RenderProcessBackgroundState> {
  static ::content::mojom::RenderProcessBackgroundState ToMojom(::content::mojom::RenderProcessBackgroundState input) { return input; }
  static bool FromMojom(::content::mojom::RenderProcessBackgroundState input, ::content::mojom::RenderProcessBackgroundState* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::RenderProcessBackgroundState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::RenderProcessBackgroundState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::content::mojom::RenderProcessBackgroundState>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::content::mojom::RenderProcessVisibleState, ::content::mojom::RenderProcessVisibleState> {
  static ::content::mojom::RenderProcessVisibleState ToMojom(::content::mojom::RenderProcessVisibleState input) { return input; }
  static bool FromMojom(::content::mojom::RenderProcessVisibleState input, ::content::mojom::RenderProcessVisibleState* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::RenderProcessVisibleState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::RenderProcessVisibleState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::content::mojom::RenderProcessVisibleState>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::UpdateScrollbarThemeParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::UpdateScrollbarThemeParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::UpdateScrollbarThemeParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->has_initial_button_delay = Traits::has_initial_button_delay(input);
    (*output)->initial_button_delay = Traits::initial_button_delay(input);
    (*output)->has_autoscroll_button_delay = Traits::has_autoscroll_button_delay(input);
    (*output)->autoscroll_button_delay = Traits::autoscroll_button_delay(input);
    (*output)->jump_on_track_click = Traits::jump_on_track_click(input);
    mojo::internal::Serialize<::content::mojom::ScrollerStyle>(
        Traits::preferred_scroller_style(input), &(*output)->preferred_scroller_style);
    (*output)->redraw = Traits::redraw(input);
    (*output)->scroll_view_rubber_banding = Traits::scroll_view_rubber_banding(input);
  }

  static bool Deserialize(::content::mojom::internal::UpdateScrollbarThemeParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::UpdateScrollbarThemeParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::UpdateSystemColorInfoParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::UpdateSystemColorInfoParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::content::mojom::internal::UpdateSystemColorInfoParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->is_dark_mode = Traits::is_dark_mode(input);
    (*output)->is_high_contrast = Traits::is_high_contrast(input);
    decltype(Traits::colors(input)) in_colors = Traits::colors(input);
    typename decltype((*output)->colors)::BaseType::BufferWriter
        colors_writer;
    const mojo::internal::ContainerValidateParams colors_validate_params(
        new mojo::internal::ContainerValidateParams(0, ::content::mojom::internal::SystemThemeColor_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<::content::mojom::SystemThemeColor, uint32_t>>(
        in_colors, buffer, &colors_writer, &colors_validate_params,
        context);
    (*output)->colors.Set(
        colors_writer.is_null() ? nullptr : colors_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->colors.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null colors in UpdateSystemColorInfoParams struct");
  }

  static bool Deserialize(::content::mojom::internal::UpdateSystemColorInfoParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::UpdateSystemColorInfoParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content {
namespace mojom {



inline void UpdateSystemColorInfoParamsDataView::GetColorsDataView(
    mojo::MapDataView<::content::mojom::SystemThemeColor, uint32_t>* output) {
  auto pointer = data_->colors.Get();
  *output = mojo::MapDataView<::content::mojom::SystemThemeColor, uint32_t>(pointer, context_);
}



}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_RENDERER_MOJOM_SHARED_H_