// media/mojo/mojom/audio_input_stream.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/audio_input_stream.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/audio_input_stream.mojom-params-data.h"
#include "media/mojo/mojom/audio_input_stream.mojom-shared-message-ids.h"

#include "media/mojo/mojom/audio_input_stream.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_AUDIO_INPUT_STREAM_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_AUDIO_INPUT_STREAM_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char AudioInputStream::Name_[] = "media.mojom.AudioInputStream";

AudioInputStreamProxy::AudioInputStreamProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioInputStreamProxy::Record(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::AudioInputStream::Record");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioInputStream_Record_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::AudioInputStream_Record_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioInputStream::Name_);
  message.set_method_name("Record");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioInputStreamProxy::SetVolume(
    double in_volume) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioInputStream::SetVolume", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetDouble("volume", in_volume);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioInputStream_SetVolume_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::AudioInputStream_SetVolume_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->volume = in_volume;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioInputStream::Name_);
  message.set_method_name("SetVolume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AudioInputStreamStubDispatch::Accept(
    AudioInputStream* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kAudioInputStream_Record_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioInputStream::Record",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioInputStream::Record");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioInputStream_Record_Params_Data* params =
          reinterpret_cast<internal::AudioInputStream_Record_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AudioInputStream_Record_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioInputStream::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Record();
      return true;
    }
    case internal::kAudioInputStream_SetVolume_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioInputStream::SetVolume",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioInputStream::SetVolume");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioInputStream_SetVolume_Params_Data* params =
          reinterpret_cast<internal::AudioInputStream_SetVolume_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      double p_volume{};
      AudioInputStream_SetVolume_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_volume = input_data_view.volume();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioInputStream::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVolume(
std::move(p_volume));
      return true;
    }
  }
  return false;
}

// static
bool AudioInputStreamStubDispatch::AcceptWithResponder(
    AudioInputStream* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioInputStream_Record_Name: {
      break;
    }
    case internal::kAudioInputStream_SetVolume_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioInputStreamValidationInfo[] = {
    {internal::kAudioInputStream_Record_Name,
     {&internal::AudioInputStream_Record_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAudioInputStream_SetVolume_Name,
     {&internal::AudioInputStream_SetVolume_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioInputStreamRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::AudioInputStream::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAudioInputStreamValidationInfo);
}

const char AudioInputStreamClient::Name_[] = "media.mojom.AudioInputStreamClient";

AudioInputStreamClientProxy::AudioInputStreamClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioInputStreamClientProxy::OnError(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::AudioInputStreamClient::OnError");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioInputStreamClient_OnError_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::AudioInputStreamClient_OnError_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioInputStreamClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void AudioInputStreamClientProxy::OnMutedStateChanged(
    bool in_is_muted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::AudioInputStreamClient::OnMutedStateChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_muted", in_is_muted);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioInputStreamClient_OnMutedStateChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::AudioInputStreamClient_OnMutedStateChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_muted = in_is_muted;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioInputStreamClient::Name_);
  message.set_method_name("OnMutedStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AudioInputStreamClientStubDispatch::Accept(
    AudioInputStreamClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kAudioInputStreamClient_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioInputStreamClient::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioInputStreamClient::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioInputStreamClient_OnError_Params_Data* params =
          reinterpret_cast<internal::AudioInputStreamClient_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AudioInputStreamClient_OnError_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioInputStreamClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError();
      return true;
    }
    case internal::kAudioInputStreamClient_OnMutedStateChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioInputStreamClient::OnMutedStateChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioInputStreamClient::OnMutedStateChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioInputStreamClient_OnMutedStateChanged_Params_Data* params =
          reinterpret_cast<internal::AudioInputStreamClient_OnMutedStateChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_muted{};
      AudioInputStreamClient_OnMutedStateChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_muted = input_data_view.is_muted();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioInputStreamClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMutedStateChanged(
std::move(p_is_muted));
      return true;
    }
  }
  return false;
}

// static
bool AudioInputStreamClientStubDispatch::AcceptWithResponder(
    AudioInputStreamClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioInputStreamClient_OnError_Name: {
      break;
    }
    case internal::kAudioInputStreamClient_OnMutedStateChanged_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioInputStreamClientValidationInfo[] = {
    {internal::kAudioInputStreamClient_OnError_Name,
     {&internal::AudioInputStreamClient_OnError_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kAudioInputStreamClient_OnMutedStateChanged_Name,
     {&internal::AudioInputStreamClient_OnMutedStateChanged_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioInputStreamClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::AudioInputStreamClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAudioInputStreamClientValidationInfo);
}

const char AudioInputStreamObserver::Name_[] = "media.mojom.AudioInputStreamObserver";

AudioInputStreamObserverProxy::AudioInputStreamObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioInputStreamObserverProxy::DidStartRecording(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::AudioInputStreamObserver::DidStartRecording");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAudioInputStreamObserver_DidStartRecording_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::AudioInputStreamObserver_DidStartRecording_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioInputStreamObserver::Name_);
  message.set_method_name("DidStartRecording");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AudioInputStreamObserverStubDispatch::Accept(
    AudioInputStreamObserver* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kAudioInputStreamObserver_DidStartRecording_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::AudioInputStreamObserver::DidStartRecording",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::AudioInputStreamObserver::DidStartRecording");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AudioInputStreamObserver_DidStartRecording_Params_Data* params =
          reinterpret_cast<internal::AudioInputStreamObserver_DidStartRecording_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      AudioInputStreamObserver_DidStartRecording_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioInputStreamObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStartRecording();
      return true;
    }
  }
  return false;
}

// static
bool AudioInputStreamObserverStubDispatch::AcceptWithResponder(
    AudioInputStreamObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAudioInputStreamObserver_DidStartRecording_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAudioInputStreamObserverValidationInfo[] = {
    {internal::kAudioInputStreamObserver_DidStartRecording_Name,
     {&internal::AudioInputStreamObserver_DidStartRecording_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AudioInputStreamObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::AudioInputStreamObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAudioInputStreamObserverValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif