// services/network/public/mojom/origin_policy_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ORIGIN_POLICY_MANAGER_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ORIGIN_POLICY_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/origin_policy_manager.mojom-shared.h"
#include "services/network/public/mojom/origin_policy_manager.mojom-forward.h"
#include "services/network/public/mojom/isolation_info.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "services/network/public/cpp/network_ipc_param_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {

class OriginPolicyManagerProxy;

template <typename ImplRefTraits>
class OriginPolicyManagerStub;

class OriginPolicyManagerRequestValidator;
class OriginPolicyManagerResponseValidator;


class  OriginPolicyManager
    : public OriginPolicyManagerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = OriginPolicyManagerInterfaceBase;
  using Proxy_ = OriginPolicyManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = OriginPolicyManagerStub<ImplRefTraits>;

  using RequestValidator_ = OriginPolicyManagerRequestValidator;
  using ResponseValidator_ = OriginPolicyManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRetrieveOriginPolicyMinVersion = 0,
    kAddExceptionForMinVersion = 0,
  };
  virtual ~OriginPolicyManager() {}


  using RetrieveOriginPolicyCallback = base::OnceCallback<void(const ::network::OriginPolicy&)>;
  
  virtual void RetrieveOriginPolicy(const ::url::Origin& origin, const ::net::IsolationInfo& isolation_info, const base::Optional<std::string>& header_value, RetrieveOriginPolicyCallback callback) = 0;

  
  virtual void AddExceptionFor(const ::url::Origin& origin) = 0;
};



class  OriginPolicyManagerProxy
    : public OriginPolicyManager {
 public:
  using InterfaceType = OriginPolicyManager;

  explicit OriginPolicyManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RetrieveOriginPolicy(const ::url::Origin& origin, const ::net::IsolationInfo& isolation_info, const base::Optional<std::string>& header_value, RetrieveOriginPolicyCallback callback) final;
  
  void AddExceptionFor(const ::url::Origin& origin) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  OriginPolicyManagerStubDispatch {
 public:
  static bool Accept(OriginPolicyManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OriginPolicyManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OriginPolicyManager>>
class OriginPolicyManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OriginPolicyManagerStub() {}
  ~OriginPolicyManagerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OriginPolicyManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OriginPolicyManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  OriginPolicyManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OriginPolicyManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







}  // namespace mojom
}  // namespace network

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_ORIGIN_POLICY_MANAGER_MOJOM_H_