// services/network/public/mojom/proxy_config_with_annotation.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_WITH_ANNOTATION_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_WITH_ANNOTATION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/proxy_config_with_annotation.mojom-shared.h"
#include "services/network/public/mojom/proxy_config_with_annotation.mojom-blink-forward.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-blink.h"
#include "services/network/public/mojom/proxy_config.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/platform/web_common.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {
namespace blink {

class ProxyConfigClientProxy;

template <typename ImplRefTraits>
class ProxyConfigClientStub;

class ProxyConfigClientRequestValidator;
class ProxyConfigClientResponseValidator;


class BLINK_PLATFORM_EXPORT ProxyConfigClient
    : public ProxyConfigClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ProxyConfigClientInterfaceBase;
  using Proxy_ = ProxyConfigClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProxyConfigClientStub<ImplRefTraits>;

  using RequestValidator_ = ProxyConfigClientRequestValidator;
  using ResponseValidator_ = ProxyConfigClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnProxyConfigUpdatedMinVersion = 0,
    kFlushProxyConfigMinVersion = 0,
  };
  virtual ~ProxyConfigClient() {}

  
  virtual void OnProxyConfigUpdated(ProxyConfigWithAnnotationPtr proxy_config) = 0;


  using FlushProxyConfigCallback = base::OnceCallback<void()>;
  
  virtual void FlushProxyConfig(FlushProxyConfigCallback callback) = 0;
};

class ProxyConfigPollerClientProxy;

template <typename ImplRefTraits>
class ProxyConfigPollerClientStub;

class ProxyConfigPollerClientRequestValidator;


class BLINK_PLATFORM_EXPORT ProxyConfigPollerClient
    : public ProxyConfigPollerClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ProxyConfigPollerClientInterfaceBase;
  using Proxy_ = ProxyConfigPollerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProxyConfigPollerClientStub<ImplRefTraits>;

  using RequestValidator_ = ProxyConfigPollerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnLazyProxyConfigPollMinVersion = 0,
  };
  virtual ~ProxyConfigPollerClient() {}

  
  virtual void OnLazyProxyConfigPoll() = 0;
};

class ProxyErrorClientProxy;

template <typename ImplRefTraits>
class ProxyErrorClientStub;

class ProxyErrorClientRequestValidator;


class BLINK_PLATFORM_EXPORT ProxyErrorClient
    : public ProxyErrorClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ProxyErrorClientInterfaceBase;
  using Proxy_ = ProxyErrorClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProxyErrorClientStub<ImplRefTraits>;

  using RequestValidator_ = ProxyErrorClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnPACScriptErrorMinVersion = 0,
    kOnRequestMaybeFailedDueToProxySettingsMinVersion = 0,
  };
  virtual ~ProxyErrorClient() {}

  
  virtual void OnPACScriptError(int32_t line_number, const WTF::String& details) = 0;

  
  virtual void OnRequestMaybeFailedDueToProxySettings(int32_t net_error) = 0;
};



class BLINK_PLATFORM_EXPORT ProxyConfigClientProxy
    : public ProxyConfigClient {
 public:
  using InterfaceType = ProxyConfigClient;

  explicit ProxyConfigClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnProxyConfigUpdated(ProxyConfigWithAnnotationPtr proxy_config) final;
  
  void FlushProxyConfig(FlushProxyConfigCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT ProxyConfigPollerClientProxy
    : public ProxyConfigPollerClient {
 public:
  using InterfaceType = ProxyConfigPollerClient;

  explicit ProxyConfigPollerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnLazyProxyConfigPoll() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT ProxyErrorClientProxy
    : public ProxyErrorClient {
 public:
  using InterfaceType = ProxyErrorClient;

  explicit ProxyErrorClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPACScriptError(int32_t line_number, const WTF::String& details) final;
  
  void OnRequestMaybeFailedDueToProxySettings(int32_t net_error) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT ProxyConfigClientStubDispatch {
 public:
  static bool Accept(ProxyConfigClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProxyConfigClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProxyConfigClient>>
class ProxyConfigClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProxyConfigClientStub() {}
  ~ProxyConfigClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyConfigClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyConfigClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ProxyConfigPollerClientStubDispatch {
 public:
  static bool Accept(ProxyConfigPollerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProxyConfigPollerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProxyConfigPollerClient>>
class ProxyConfigPollerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProxyConfigPollerClientStub() {}
  ~ProxyConfigPollerClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyConfigPollerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyConfigPollerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ProxyErrorClientStubDispatch {
 public:
  static bool Accept(ProxyErrorClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProxyErrorClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProxyErrorClient>>
class ProxyErrorClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProxyErrorClientStub() {}
  ~ProxyErrorClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyErrorClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyErrorClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ProxyConfigClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT ProxyConfigPollerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT ProxyErrorClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT ProxyConfigClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_PLATFORM_EXPORT ProxyConfigWithAnnotation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyConfigWithAnnotation, T>::value>;
  using DataView = ProxyConfigWithAnnotationDataView;
  using Data_ = internal::ProxyConfigWithAnnotation_Data;

  template <typename... Args>
  static ProxyConfigWithAnnotationPtr New(Args&&... args) {
    return ProxyConfigWithAnnotationPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyConfigWithAnnotationPtr From(const U& u) {
    return mojo::TypeConverter<ProxyConfigWithAnnotationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyConfigWithAnnotation>::Convert(*this);
  }


  ProxyConfigWithAnnotation();

  ProxyConfigWithAnnotation(
      ::network::mojom::blink::ProxyConfigPtr value,
      const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation);

  ~ProxyConfigWithAnnotation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyConfigWithAnnotationPtr>
  ProxyConfigWithAnnotationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyConfigWithAnnotation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyConfigWithAnnotation::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyConfigWithAnnotation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyConfigWithAnnotation_UnserializedMessageContext<
            UserType, ProxyConfigWithAnnotation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ProxyConfigWithAnnotation::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ProxyConfigWithAnnotation::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyConfigWithAnnotation_UnserializedMessageContext<
            UserType, ProxyConfigWithAnnotation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyConfigWithAnnotation::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::network::mojom::blink::ProxyConfigPtr value;
  
  ::net::MutableNetworkTrafficAnnotationTag traffic_annotation;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ProxyConfigWithAnnotation);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyConfigWithAnnotation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyConfigWithAnnotation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyConfigWithAnnotation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyConfigWithAnnotation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ProxyConfigWithAnnotationPtr ProxyConfigWithAnnotation::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(traffic_annotation)
  );
}

template <typename T, ProxyConfigWithAnnotation::EnableIfSame<T>*>
bool ProxyConfigWithAnnotation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->traffic_annotation, other_struct.traffic_annotation))
    return false;
  return true;
}

template <typename T, ProxyConfigWithAnnotation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.value, rhs.value))
    return true;
  if (std::less<>{}(rhs.value, lhs.value))
    return false;
  if (std::less<>{}(lhs.traffic_annotation, rhs.traffic_annotation))
    return true;
  if (std::less<>{}(rhs.traffic_annotation, lhs.traffic_annotation))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ProxyConfigWithAnnotation::DataView,
                                         ::network::mojom::blink::ProxyConfigWithAnnotationPtr> {
  static bool IsNull(const ::network::mojom::blink::ProxyConfigWithAnnotationPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ProxyConfigWithAnnotationPtr* output) { output->reset(); }

  static  decltype(::network::mojom::blink::ProxyConfigWithAnnotation::value)& value(
       ::network::mojom::blink::ProxyConfigWithAnnotationPtr& input) {
    return input->value;
  }

  static const decltype(::network::mojom::blink::ProxyConfigWithAnnotation::traffic_annotation)& traffic_annotation(
      const ::network::mojom::blink::ProxyConfigWithAnnotationPtr& input) {
    return input->traffic_annotation;
  }

  static bool Read(::network::mojom::blink::ProxyConfigWithAnnotation::DataView input, ::network::mojom::blink::ProxyConfigWithAnnotationPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_WITH_ANNOTATION_MOJOM_BLINK_H_