// third_party/blink/public/mojom/service_worker/service_worker_container.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CONTAINER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CONTAINER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_error_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-shared.h"
#include "third_party/blink/public/mojom/web_feature/web_feature.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class ServiceWorkerContainerInfoForClientDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerContainerInfoForClientDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerContainerInfoForClient_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class ControllerServiceWorkerPurpose : int32_t {
  
  FETCH_SUB_RESOURCE = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ControllerServiceWorkerPurpose value);
inline bool IsKnownEnumValue(ControllerServiceWorkerPurpose value) {
  return internal::ControllerServiceWorkerPurpose_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ServiceWorkerContainerHostInterfaceBase {};

using ServiceWorkerContainerHostPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerContainerHostInterfaceBase>;
using ServiceWorkerContainerHostRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerContainerHostInterfaceBase>;
using ServiceWorkerContainerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerContainerHostInterfaceBase>;
using ServiceWorkerContainerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerContainerHostInterfaceBase>;
class ServiceWorkerContainerInterfaceBase {};

using ServiceWorkerContainerPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerContainerInterfaceBase>;
using ServiceWorkerContainerRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerContainerInterfaceBase>;
using ServiceWorkerContainerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerContainerInterfaceBase>;
using ServiceWorkerContainerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerContainerInterfaceBase>;


class ServiceWorkerContainerInfoForClientDataView {
 public:
  ServiceWorkerContainerInfoForClientDataView() {}

  ServiceWorkerContainerInfoForClientDataView(
      internal::ServiceWorkerContainerInfoForClient_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeHostRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::ServiceWorkerContainerHostAssociatedPtrInfoDataView>(
            &data_->host_remote, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::ServiceWorkerContainerAssociatedRequestDataView>(
            &data_->client_receiver, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ServiceWorkerContainerInfoForClient_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::ControllerServiceWorkerPurpose>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ControllerServiceWorkerPurpose> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::ControllerServiceWorkerPurpose, ::blink::mojom::ControllerServiceWorkerPurpose> {
  static ::blink::mojom::ControllerServiceWorkerPurpose ToMojom(::blink::mojom::ControllerServiceWorkerPurpose input) { return input; }
  static bool FromMojom(::blink::mojom::ControllerServiceWorkerPurpose input, ::blink::mojom::ControllerServiceWorkerPurpose* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ControllerServiceWorkerPurpose, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ControllerServiceWorkerPurpose, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::ControllerServiceWorkerPurpose>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerContainerInfoForClientDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerContainerInfoForClientDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ServiceWorkerContainerInfoForClient_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::host_remote(input)) in_host_remote = Traits::host_remote(input);
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerContainerHostAssociatedPtrInfoDataView>(
        in_host_remote, &(*output)->host_remote, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->host_remote),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid host_remote in ServiceWorkerContainerInfoForClient struct");
    decltype(Traits::client_receiver(input)) in_client_receiver = Traits::client_receiver(input);
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerContainerAssociatedRequestDataView>(
        in_client_receiver, &(*output)->client_receiver, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->client_receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid client_receiver in ServiceWorkerContainerInfoForClient struct");
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerContainerInfoForClient_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerContainerInfoForClientDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {




}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_CONTAINER_MOJOM_SHARED_H_