// ui/base/ime/mojom/text_input_state.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_BLINK_H_
#define UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "ui/base/ime/mojom/text_input_state.mojom-shared.h"
#include "ui/base/ime/mojom/text_input_state.mojom-blink-forward.h"
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/text_direction.mojom-blink-forward.h"
#include "ui/base/ime/mojom/ime_types.mojom-blink.h"
#include "ui/base/ime/mojom/virtual_keyboard_types.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/range/mojom/range.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace ui {
namespace mojom {
namespace blink {









class BLINK_PLATFORM_EXPORT ImeTextSpanInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImeTextSpanInfo, T>::value>;
  using DataView = ImeTextSpanInfoDataView;
  using Data_ = internal::ImeTextSpanInfo_Data;

  template <typename... Args>
  static ImeTextSpanInfoPtr New(Args&&... args) {
    return ImeTextSpanInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImeTextSpanInfoPtr From(const U& u) {
    return mojo::TypeConverter<ImeTextSpanInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImeTextSpanInfo>::Convert(*this);
  }


  ImeTextSpanInfo();

  ImeTextSpanInfo(
      const ::ui::ImeTextSpan& span,
      const ::gfx::Rect& bounds);

  ~ImeTextSpanInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImeTextSpanInfoPtr>
  ImeTextSpanInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImeTextSpanInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImeTextSpanInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImeTextSpanInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImeTextSpanInfo_UnserializedMessageContext<
            UserType, ImeTextSpanInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ImeTextSpanInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ImeTextSpanInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImeTextSpanInfo_UnserializedMessageContext<
            UserType, ImeTextSpanInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImeTextSpanInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::ui::ImeTextSpan span;
  
  ::gfx::Rect bounds;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImeTextSpanInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImeTextSpanInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImeTextSpanInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImeTextSpanInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT TextInputState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TextInputState, T>::value>;
  using DataView = TextInputStateDataView;
  using Data_ = internal::TextInputState_Data;

  template <typename... Args>
  static TextInputStatePtr New(Args&&... args) {
    return TextInputStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TextInputStatePtr From(const U& u) {
    return mojo::TypeConverter<TextInputStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TextInputState>::Convert(*this);
  }


  TextInputState();

  TextInputState(
      ::ui::TextInputType type,
      ::ui::TextInputMode mode,
      ::ui::TextInputAction action,
      uint32_t flags,
      const ::WTF::String& value,
      const ::gfx::Range& selection,
      const base::Optional<::gfx::Range>& composition,
      bool can_compose_inline,
      bool show_ime_if_needed,
      bool always_hide_ime,
      bool reply_to_request,
      const base::Optional<::gfx::Rect>& edit_context_control_bounds,
      const base::Optional<::gfx::Rect>& edit_context_selection_bounds,
      ::ui::mojom::blink::VirtualKeyboardPolicy vk_policy,
      ::ui::mojom::blink::VirtualKeyboardVisibilityRequest last_vk_visibility_request,
      WTF::Vector<ImeTextSpanInfoPtr> ime_text_spans_info);

  ~TextInputState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TextInputStatePtr>
  TextInputStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TextInputState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TextInputState::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TextInputState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TextInputState_UnserializedMessageContext<
            UserType, TextInputState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TextInputState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return TextInputState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TextInputState_UnserializedMessageContext<
            UserType, TextInputState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TextInputState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::ui::TextInputType type;
  
  ::ui::TextInputMode mode;
  
  ::ui::TextInputAction action;
  
  uint32_t flags;
  
  ::WTF::String value;
  
  ::gfx::Range selection;
  
  base::Optional<::gfx::Range> composition;
  
  bool can_compose_inline;
  
  bool show_ime_if_needed;
  
  bool always_hide_ime;
  
  bool reply_to_request;
  
  base::Optional<::gfx::Rect> edit_context_control_bounds;
  
  base::Optional<::gfx::Rect> edit_context_selection_bounds;
  
  ::ui::mojom::blink::VirtualKeyboardPolicy vk_policy;
  
  ::ui::mojom::blink::VirtualKeyboardVisibilityRequest last_vk_visibility_request;
  
  WTF::Vector<ImeTextSpanInfoPtr> ime_text_spans_info;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(TextInputState);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TextInputState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TextInputState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TextInputState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TextInputState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ImeTextSpanInfoPtr ImeTextSpanInfo::Clone() const {
  return New(
      mojo::Clone(span),
      mojo::Clone(bounds)
  );
}

template <typename T, ImeTextSpanInfo::EnableIfSame<T>*>
bool ImeTextSpanInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->span, other_struct.span))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  return true;
}

template <typename T, ImeTextSpanInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.span, rhs.span))
    return true;
  if (std::less<>{}(rhs.span, lhs.span))
    return false;
  if (std::less<>{}(lhs.bounds, rhs.bounds))
    return true;
  if (std::less<>{}(rhs.bounds, lhs.bounds))
    return false;
  return false;
}
template <typename StructPtrType>
TextInputStatePtr TextInputState::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(mode),
      mojo::Clone(action),
      mojo::Clone(flags),
      mojo::Clone(value),
      mojo::Clone(selection),
      mojo::Clone(composition),
      mojo::Clone(can_compose_inline),
      mojo::Clone(show_ime_if_needed),
      mojo::Clone(always_hide_ime),
      mojo::Clone(reply_to_request),
      mojo::Clone(edit_context_control_bounds),
      mojo::Clone(edit_context_selection_bounds),
      mojo::Clone(vk_policy),
      mojo::Clone(last_vk_visibility_request),
      mojo::Clone(ime_text_spans_info)
  );
}

template <typename T, TextInputState::EnableIfSame<T>*>
bool TextInputState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->flags, other_struct.flags))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->selection, other_struct.selection))
    return false;
  if (!mojo::Equals(this->composition, other_struct.composition))
    return false;
  if (!mojo::Equals(this->can_compose_inline, other_struct.can_compose_inline))
    return false;
  if (!mojo::Equals(this->show_ime_if_needed, other_struct.show_ime_if_needed))
    return false;
  if (!mojo::Equals(this->always_hide_ime, other_struct.always_hide_ime))
    return false;
  if (!mojo::Equals(this->reply_to_request, other_struct.reply_to_request))
    return false;
  if (!mojo::Equals(this->edit_context_control_bounds, other_struct.edit_context_control_bounds))
    return false;
  if (!mojo::Equals(this->edit_context_selection_bounds, other_struct.edit_context_selection_bounds))
    return false;
  if (!mojo::Equals(this->vk_policy, other_struct.vk_policy))
    return false;
  if (!mojo::Equals(this->last_vk_visibility_request, other_struct.last_vk_visibility_request))
    return false;
  if (!mojo::Equals(this->ime_text_spans_info, other_struct.ime_text_spans_info))
    return false;
  return true;
}

template <typename T, TextInputState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.mode, rhs.mode))
    return true;
  if (std::less<>{}(rhs.mode, lhs.mode))
    return false;
  if (std::less<>{}(lhs.action, rhs.action))
    return true;
  if (std::less<>{}(rhs.action, lhs.action))
    return false;
  if (std::less<>{}(lhs.flags, rhs.flags))
    return true;
  if (std::less<>{}(rhs.flags, lhs.flags))
    return false;
  if (std::less<>{}(lhs.value, rhs.value))
    return true;
  if (std::less<>{}(rhs.value, lhs.value))
    return false;
  if (std::less<>{}(lhs.selection, rhs.selection))
    return true;
  if (std::less<>{}(rhs.selection, lhs.selection))
    return false;
  if (std::less<>{}(lhs.composition, rhs.composition))
    return true;
  if (std::less<>{}(rhs.composition, lhs.composition))
    return false;
  if (std::less<>{}(lhs.can_compose_inline, rhs.can_compose_inline))
    return true;
  if (std::less<>{}(rhs.can_compose_inline, lhs.can_compose_inline))
    return false;
  if (std::less<>{}(lhs.show_ime_if_needed, rhs.show_ime_if_needed))
    return true;
  if (std::less<>{}(rhs.show_ime_if_needed, lhs.show_ime_if_needed))
    return false;
  if (std::less<>{}(lhs.always_hide_ime, rhs.always_hide_ime))
    return true;
  if (std::less<>{}(rhs.always_hide_ime, lhs.always_hide_ime))
    return false;
  if (std::less<>{}(lhs.reply_to_request, rhs.reply_to_request))
    return true;
  if (std::less<>{}(rhs.reply_to_request, lhs.reply_to_request))
    return false;
  if (std::less<>{}(lhs.edit_context_control_bounds, rhs.edit_context_control_bounds))
    return true;
  if (std::less<>{}(rhs.edit_context_control_bounds, lhs.edit_context_control_bounds))
    return false;
  if (std::less<>{}(lhs.edit_context_selection_bounds, rhs.edit_context_selection_bounds))
    return true;
  if (std::less<>{}(rhs.edit_context_selection_bounds, lhs.edit_context_selection_bounds))
    return false;
  if (std::less<>{}(lhs.vk_policy, rhs.vk_policy))
    return true;
  if (std::less<>{}(rhs.vk_policy, lhs.vk_policy))
    return false;
  if (std::less<>{}(lhs.last_vk_visibility_request, rhs.last_vk_visibility_request))
    return true;
  if (std::less<>{}(rhs.last_vk_visibility_request, lhs.last_vk_visibility_request))
    return false;
  if (std::less<>{}(lhs.ime_text_spans_info, rhs.ime_text_spans_info))
    return true;
  if (std::less<>{}(rhs.ime_text_spans_info, lhs.ime_text_spans_info))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace ui

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::ui::mojom::blink::ImeTextSpanInfo::DataView,
                                         ::ui::mojom::blink::ImeTextSpanInfoPtr> {
  static bool IsNull(const ::ui::mojom::blink::ImeTextSpanInfoPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::blink::ImeTextSpanInfoPtr* output) { output->reset(); }

  static const decltype(::ui::mojom::blink::ImeTextSpanInfo::span)& span(
      const ::ui::mojom::blink::ImeTextSpanInfoPtr& input) {
    return input->span;
  }

  static const decltype(::ui::mojom::blink::ImeTextSpanInfo::bounds)& bounds(
      const ::ui::mojom::blink::ImeTextSpanInfoPtr& input) {
    return input->bounds;
  }

  static bool Read(::ui::mojom::blink::ImeTextSpanInfo::DataView input, ::ui::mojom::blink::ImeTextSpanInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::ui::mojom::blink::TextInputState::DataView,
                                         ::ui::mojom::blink::TextInputStatePtr> {
  static bool IsNull(const ::ui::mojom::blink::TextInputStatePtr& input) { return !input; }
  static void SetToNull(::ui::mojom::blink::TextInputStatePtr* output) { output->reset(); }

  static decltype(::ui::mojom::blink::TextInputState::type) type(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->type;
  }

  static decltype(::ui::mojom::blink::TextInputState::mode) mode(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->mode;
  }

  static decltype(::ui::mojom::blink::TextInputState::action) action(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->action;
  }

  static decltype(::ui::mojom::blink::TextInputState::flags) flags(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->flags;
  }

  static const decltype(::ui::mojom::blink::TextInputState::value)& value(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->value;
  }

  static const decltype(::ui::mojom::blink::TextInputState::selection)& selection(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->selection;
  }

  static const decltype(::ui::mojom::blink::TextInputState::composition)& composition(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->composition;
  }

  static decltype(::ui::mojom::blink::TextInputState::can_compose_inline) can_compose_inline(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->can_compose_inline;
  }

  static decltype(::ui::mojom::blink::TextInputState::show_ime_if_needed) show_ime_if_needed(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->show_ime_if_needed;
  }

  static decltype(::ui::mojom::blink::TextInputState::always_hide_ime) always_hide_ime(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->always_hide_ime;
  }

  static decltype(::ui::mojom::blink::TextInputState::reply_to_request) reply_to_request(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->reply_to_request;
  }

  static const decltype(::ui::mojom::blink::TextInputState::edit_context_control_bounds)& edit_context_control_bounds(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->edit_context_control_bounds;
  }

  static const decltype(::ui::mojom::blink::TextInputState::edit_context_selection_bounds)& edit_context_selection_bounds(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->edit_context_selection_bounds;
  }

  static decltype(::ui::mojom::blink::TextInputState::vk_policy) vk_policy(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->vk_policy;
  }

  static decltype(::ui::mojom::blink::TextInputState::last_vk_visibility_request) last_vk_visibility_request(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->last_vk_visibility_request;
  }

  static const decltype(::ui::mojom::blink::TextInputState::ime_text_spans_info)& ime_text_spans_info(
      const ::ui::mojom::blink::TextInputStatePtr& input) {
    return input->ime_text_spans_info;
  }

  static bool Read(::ui::mojom::blink::TextInputState::DataView input, ::ui::mojom::blink::TextInputStatePtr* output);
};

}  // namespace mojo

#endif  // UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_BLINK_H_