#ifndef GEN_UI_GFX_X_XINERAMA_H_
#define GEN_UI_GFX_X_XINERAMA_H_

#include <array>
#include <cstddef>
#include <cstdint>
#include <cstring>
#include <vector>

#include "base/component_export.h"
#include "base/memory/ref_counted_memory.h"
#include "base/memory/scoped_refptr.h"
#include "base/optional.h"
#include "base/files/scoped_file.h"
#include "ui/gfx/x/xproto_types.h"
#include "xproto.h"

namespace x11 {

class Connection;

class COMPONENT_EXPORT(X11) Xinerama {
  public:
  static constexpr unsigned major_version = 1;
  static constexpr unsigned minor_version = 1;

  Xinerama(Connection* connection,
      const x11::QueryExtensionReply& info);

  uint8_t present() const {
    return info_.present;
  }
  uint8_t major_opcode() const {
    return info_.major_opcode;
  }
  uint8_t first_event() const {
    return info_.first_event;
  }
  uint8_t first_error() const {
    return info_.first_error;
  }

  Connection* connection() const { return connection_; }

  struct ScreenInfo {
    int16_t x_org{};
    int16_t y_org{};
    uint16_t width{};
    uint16_t height{};
  };

  struct QueryVersionRequest {
    uint8_t major{};
    uint8_t minor{};
  };

  struct QueryVersionReply {
    uint16_t sequence{};
    uint16_t major{};
    uint16_t minor{};
  };

  using QueryVersionResponse = Response<QueryVersionReply>;

  Future<QueryVersionReply> QueryVersion(
      const QueryVersionRequest& request);

  struct GetStateRequest {
    Window window{};
  };

  struct GetStateReply {
    uint8_t state{};
    uint16_t sequence{};
    Window window{};
  };

  using GetStateResponse = Response<GetStateReply>;

  Future<GetStateReply> GetState(
      const GetStateRequest& request);

  struct GetScreenCountRequest {
    Window window{};
  };

  struct GetScreenCountReply {
    uint8_t screen_count{};
    uint16_t sequence{};
    Window window{};
  };

  using GetScreenCountResponse = Response<GetScreenCountReply>;

  Future<GetScreenCountReply> GetScreenCount(
      const GetScreenCountRequest& request);

  struct GetScreenSizeRequest {
    Window window{};
    uint32_t screen{};
  };

  struct GetScreenSizeReply {
    uint16_t sequence{};
    uint32_t width{};
    uint32_t height{};
    Window window{};
    uint32_t screen{};
  };

  using GetScreenSizeResponse = Response<GetScreenSizeReply>;

  Future<GetScreenSizeReply> GetScreenSize(
      const GetScreenSizeRequest& request);

  struct IsActiveRequest {
  };

  struct IsActiveReply {
    uint16_t sequence{};
    uint32_t state{};
  };

  using IsActiveResponse = Response<IsActiveReply>;

  Future<IsActiveReply> IsActive(
      const IsActiveRequest& request);

  struct QueryScreensRequest {
  };

  struct QueryScreensReply {
    uint16_t sequence{};
    std::vector<ScreenInfo> screen_info{};
  };

  using QueryScreensResponse = Response<QueryScreensReply>;

  Future<QueryScreensReply> QueryScreens(
      const QueryScreensRequest& request);

  private:
  x11::Connection* const connection_;
  x11::QueryExtensionReply info_{};
};

}  // namespace x11


#endif  // GEN_UI_GFX_X_XINERAMA_H_
