/*  $Id: shape_exp_lookup.hpp 685605 2024-07-26 12:29:33Z thiessen $
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
* Authors:  Evan Bolton, Leonid Zaslavsky, Paul Thiessen
*
* ===========================================================================
*/

#ifndef ALIGN3D_SHAPE_EXP_LOOKUP_HPP
#define ALIGN3D_SHAPE_EXP_LOOKUP_HPP

namespace  Align3D {

        // Generated lookup table using the following code snippet
        //   for ( unsigned  a = 0;  a < 6001;  a++ ) {
        //       double  loc = static_cast< double >( a ) / 500.;
        //       double  val = exp( -loc );
        //       std::cout << "            " << std::scientific << std::setprecision( 6 ) << val
        //                 << ",  // " << std::fixed << std::setprecision( 3 ) << loc << std::endl;
        //   }
        //   std::cout << "            0.0f            // >12.000" << std::endl;
        const unsigned  default_expMinusSize = 5001;
        unsigned  expMinusSize = default_expMinusSize;
        const float  expMinus[] = {
            1.000000e+00f,  // 0.000
            9.980020e-01f,  // 0.002
            9.960080e-01f,  // 0.004
            9.940180e-01f,  // 0.006
            9.920319e-01f,  // 0.008
            9.900498e-01f,  // 0.010
            9.880717e-01f,  // 0.012
            9.860975e-01f,  // 0.014
            9.841273e-01f,  // 0.016
            9.821610e-01f,  // 0.018
            9.801987e-01f,  // 0.020
            9.782402e-01f,  // 0.022
            9.762857e-01f,  // 0.024
            9.743351e-01f,  // 0.026
            9.723884e-01f,  // 0.028
            9.704455e-01f,  // 0.030
            9.685066e-01f,  // 0.032
            9.665715e-01f,  // 0.034
            9.646403e-01f,  // 0.036
            9.627129e-01f,  // 0.038
            9.607894e-01f,  // 0.040
            9.588698e-01f,  // 0.042
            9.569540e-01f,  // 0.044
            9.550420e-01f,  // 0.046
            9.531338e-01f,  // 0.048
            9.512294e-01f,  // 0.050
            9.493289e-01f,  // 0.052
            9.474321e-01f,  // 0.054
            9.455391e-01f,  // 0.056
            9.436499e-01f,  // 0.058
            9.417645e-01f,  // 0.060
            9.398829e-01f,  // 0.062
            9.380050e-01f,  // 0.064
            9.361309e-01f,  // 0.066
            9.342605e-01f,  // 0.068
            9.323938e-01f,  // 0.070
            9.305309e-01f,  // 0.072
            9.286717e-01f,  // 0.074
            9.268162e-01f,  // 0.076
            9.249644e-01f,  // 0.078
            9.231163e-01f,  // 0.080
            9.212720e-01f,  // 0.082
            9.194313e-01f,  // 0.084
            9.175942e-01f,  // 0.086
            9.157609e-01f,  // 0.088
            9.139312e-01f,  // 0.090
            9.121051e-01f,  // 0.092
            9.102828e-01f,  // 0.094
            9.084640e-01f,  // 0.096
            9.066489e-01f,  // 0.098
            9.048374e-01f,  // 0.100
            9.030296e-01f,  // 0.102
            9.012253e-01f,  // 0.104
            8.994246e-01f,  // 0.106
            8.976276e-01f,  // 0.108
            8.958341e-01f,  // 0.110
            8.940443e-01f,  // 0.112
            8.922580e-01f,  // 0.114
            8.904752e-01f,  // 0.116
            8.886961e-01f,  // 0.118
            8.869204e-01f,  // 0.120
            8.851484e-01f,  // 0.122
            8.833798e-01f,  // 0.124
            8.816148e-01f,  // 0.126
            8.798534e-01f,  // 0.128
            8.780954e-01f,  // 0.130
            8.763410e-01f,  // 0.132
            8.745901e-01f,  // 0.134
            8.728426e-01f,  // 0.136
            8.710987e-01f,  // 0.138
            8.693582e-01f,  // 0.140
            8.676213e-01f,  // 0.142
            8.658877e-01f,  // 0.144
            8.641577e-01f,  // 0.146
            8.624311e-01f,  // 0.148
            8.607080e-01f,  // 0.150
            8.589883e-01f,  // 0.152
            8.572720e-01f,  // 0.154
            8.555592e-01f,  // 0.156
            8.538498e-01f,  // 0.158
            8.521438e-01f,  // 0.160
            8.504412e-01f,  // 0.162
            8.487420e-01f,  // 0.164
            8.470462e-01f,  // 0.166
            8.453538e-01f,  // 0.168
            8.436648e-01f,  // 0.170
            8.419792e-01f,  // 0.172
            8.402969e-01f,  // 0.174
            8.386180e-01f,  // 0.176
            8.369424e-01f,  // 0.178
            8.352702e-01f,  // 0.180
            8.336013e-01f,  // 0.182
            8.319358e-01f,  // 0.184
            8.302736e-01f,  // 0.186
            8.286147e-01f,  // 0.188
            8.269591e-01f,  // 0.190
            8.253069e-01f,  // 0.192
            8.236579e-01f,  // 0.194
            8.220122e-01f,  // 0.196
            8.203699e-01f,  // 0.198
            8.187308e-01f,  // 0.200
            8.170949e-01f,  // 0.202
            8.154624e-01f,  // 0.204
            8.138331e-01f,  // 0.206
            8.122070e-01f,  // 0.208
            8.105842e-01f,  // 0.210
            8.089647e-01f,  // 0.212
            8.073484e-01f,  // 0.214
            8.057353e-01f,  // 0.216
            8.041254e-01f,  // 0.218
            8.025188e-01f,  // 0.220
            8.009154e-01f,  // 0.222
            7.993151e-01f,  // 0.224
            7.977181e-01f,  // 0.226
            7.961243e-01f,  // 0.228
            7.945336e-01f,  // 0.230
            7.929461e-01f,  // 0.232
            7.913618e-01f,  // 0.234
            7.897807e-01f,  // 0.236
            7.882027e-01f,  // 0.238
            7.866279e-01f,  // 0.240
            7.850562e-01f,  // 0.242
            7.834876e-01f,  // 0.244
            7.819222e-01f,  // 0.246
            7.803599e-01f,  // 0.248
            7.788008e-01f,  // 0.250
            7.772447e-01f,  // 0.252
            7.756918e-01f,  // 0.254
            7.741420e-01f,  // 0.256
            7.725952e-01f,  // 0.258
            7.710516e-01f,  // 0.260
            7.695110e-01f,  // 0.262
            7.679735e-01f,  // 0.264
            7.664391e-01f,  // 0.266
            7.649078e-01f,  // 0.268
            7.633795e-01f,  // 0.270
            7.618543e-01f,  // 0.272
            7.603321e-01f,  // 0.274
            7.588129e-01f,  // 0.276
            7.572968e-01f,  // 0.278
            7.557837e-01f,  // 0.280
            7.542737e-01f,  // 0.282
            7.527666e-01f,  // 0.284
            7.512626e-01f,  // 0.286
            7.497616e-01f,  // 0.288
            7.482636e-01f,  // 0.290
            7.467685e-01f,  // 0.292
            7.452765e-01f,  // 0.294
            7.437874e-01f,  // 0.296
            7.423013e-01f,  // 0.298
            7.408182e-01f,  // 0.300
            7.393381e-01f,  // 0.302
            7.378609e-01f,  // 0.304
            7.363866e-01f,  // 0.306
            7.349153e-01f,  // 0.308
            7.334470e-01f,  // 0.310
            7.319815e-01f,  // 0.312
            7.305190e-01f,  // 0.314
            7.290595e-01f,  // 0.316
            7.276028e-01f,  // 0.318
            7.261490e-01f,  // 0.320
            7.246982e-01f,  // 0.322
            7.232502e-01f,  // 0.324
            7.218052e-01f,  // 0.326
            7.203630e-01f,  // 0.328
            7.189237e-01f,  // 0.330
            7.174873e-01f,  // 0.332
            7.160538e-01f,  // 0.334
            7.146231e-01f,  // 0.336
            7.131953e-01f,  // 0.338
            7.117703e-01f,  // 0.340
            7.103482e-01f,  // 0.342
            7.089289e-01f,  // 0.344
            7.075125e-01f,  // 0.346
            7.060989e-01f,  // 0.348
            7.046881e-01f,  // 0.350
            7.032801e-01f,  // 0.352
            7.018750e-01f,  // 0.354
            7.004726e-01f,  // 0.356
            6.990731e-01f,  // 0.358
            6.976763e-01f,  // 0.360
            6.962824e-01f,  // 0.362
            6.948912e-01f,  // 0.364
            6.935028e-01f,  // 0.366
            6.921172e-01f,  // 0.368
            6.907343e-01f,  // 0.370
            6.893542e-01f,  // 0.372
            6.879769e-01f,  // 0.374
            6.866023e-01f,  // 0.376
            6.852305e-01f,  // 0.378
            6.838614e-01f,  // 0.380
            6.824951e-01f,  // 0.382
            6.811314e-01f,  // 0.384
            6.797705e-01f,  // 0.386
            6.784123e-01f,  // 0.388
            6.770569e-01f,  // 0.390
            6.757041e-01f,  // 0.392
            6.743541e-01f,  // 0.394
            6.730067e-01f,  // 0.396
            6.716620e-01f,  // 0.398
            6.703200e-01f,  // 0.400
            6.689807e-01f,  // 0.402
            6.676441e-01f,  // 0.404
            6.663102e-01f,  // 0.406
            6.649789e-01f,  // 0.408
            6.636503e-01f,  // 0.410
            6.623243e-01f,  // 0.412
            6.610010e-01f,  // 0.414
            6.596803e-01f,  // 0.416
            6.583622e-01f,  // 0.418
            6.570468e-01f,  // 0.420
            6.557340e-01f,  // 0.422
            6.544239e-01f,  // 0.424
            6.531163e-01f,  // 0.426
            6.518114e-01f,  // 0.428
            6.505091e-01f,  // 0.430
            6.492094e-01f,  // 0.432
            6.479123e-01f,  // 0.434
            6.466177e-01f,  // 0.436
            6.453258e-01f,  // 0.438
            6.440364e-01f,  // 0.440
            6.427496e-01f,  // 0.442
            6.414654e-01f,  // 0.444
            6.401838e-01f,  // 0.446
            6.389047e-01f,  // 0.448
            6.376282e-01f,  // 0.450
            6.363542e-01f,  // 0.452
            6.350827e-01f,  // 0.454
            6.338138e-01f,  // 0.456
            6.325475e-01f,  // 0.458
            6.312836e-01f,  // 0.460
            6.300223e-01f,  // 0.462
            6.287636e-01f,  // 0.464
            6.275073e-01f,  // 0.466
            6.262535e-01f,  // 0.468
            6.250023e-01f,  // 0.470
            6.237535e-01f,  // 0.472
            6.225073e-01f,  // 0.474
            6.212635e-01f,  // 0.476
            6.200222e-01f,  // 0.478
            6.187834e-01f,  // 0.480
            6.175471e-01f,  // 0.482
            6.163132e-01f,  // 0.484
            6.150818e-01f,  // 0.486
            6.138529e-01f,  // 0.488
            6.126264e-01f,  // 0.490
            6.114024e-01f,  // 0.492
            6.101808e-01f,  // 0.494
            6.089616e-01f,  // 0.496
            6.077449e-01f,  // 0.498
            6.065307e-01f,  // 0.500
            6.053188e-01f,  // 0.502
            6.041094e-01f,  // 0.504
            6.029024e-01f,  // 0.506
            6.016978e-01f,  // 0.508
            6.004956e-01f,  // 0.510
            5.992958e-01f,  // 0.512
            5.980984e-01f,  // 0.514
            5.969034e-01f,  // 0.516
            5.957108e-01f,  // 0.518
            5.945205e-01f,  // 0.520
            5.933327e-01f,  // 0.522
            5.921472e-01f,  // 0.524
            5.909641e-01f,  // 0.526
            5.897834e-01f,  // 0.528
            5.886050e-01f,  // 0.530
            5.874289e-01f,  // 0.532
            5.862553e-01f,  // 0.534
            5.850839e-01f,  // 0.536
            5.839149e-01f,  // 0.538
            5.827483e-01f,  // 0.540
            5.815839e-01f,  // 0.542
            5.804219e-01f,  // 0.544
            5.792622e-01f,  // 0.546
            5.781049e-01f,  // 0.548
            5.769498e-01f,  // 0.550
            5.757971e-01f,  // 0.552
            5.746466e-01f,  // 0.554
            5.734985e-01f,  // 0.556
            5.723526e-01f,  // 0.558
            5.712091e-01f,  // 0.560
            5.700678e-01f,  // 0.562
            5.689288e-01f,  // 0.564
            5.677921e-01f,  // 0.566
            5.666576e-01f,  // 0.568
            5.655254e-01f,  // 0.570
            5.643955e-01f,  // 0.572
            5.632679e-01f,  // 0.574
            5.621424e-01f,  // 0.576
            5.610193e-01f,  // 0.578
            5.598984e-01f,  // 0.580
            5.587797e-01f,  // 0.582
            5.576632e-01f,  // 0.584
            5.565490e-01f,  // 0.586
            5.554370e-01f,  // 0.588
            5.543273e-01f,  // 0.590
            5.532197e-01f,  // 0.592
            5.521144e-01f,  // 0.594
            5.510113e-01f,  // 0.596
            5.499104e-01f,  // 0.598
            5.488116e-01f,  // 0.600
            5.477151e-01f,  // 0.602
            5.466208e-01f,  // 0.604
            5.455286e-01f,  // 0.606
            5.444387e-01f,  // 0.608
            5.433509e-01f,  // 0.610
            5.422653e-01f,  // 0.612
            5.411818e-01f,  // 0.614
            5.401005e-01f,  // 0.616
            5.390214e-01f,  // 0.618
            5.379444e-01f,  // 0.620
            5.368696e-01f,  // 0.622
            5.357970e-01f,  // 0.624
            5.347264e-01f,  // 0.626
            5.336581e-01f,  // 0.628
            5.325918e-01f,  // 0.630
            5.315277e-01f,  // 0.632
            5.304657e-01f,  // 0.634
            5.294058e-01f,  // 0.636
            5.283481e-01f,  // 0.638
            5.272924e-01f,  // 0.640
            5.262389e-01f,  // 0.642
            5.251875e-01f,  // 0.644
            5.241381e-01f,  // 0.646
            5.230909e-01f,  // 0.648
            5.220458e-01f,  // 0.650
            5.210027e-01f,  // 0.652
            5.199618e-01f,  // 0.654
            5.189229e-01f,  // 0.656
            5.178861e-01f,  // 0.658
            5.168513e-01f,  // 0.660
            5.158187e-01f,  // 0.662
            5.147881e-01f,  // 0.664
            5.137595e-01f,  // 0.666
            5.127330e-01f,  // 0.668
            5.117086e-01f,  // 0.670
            5.106862e-01f,  // 0.672
            5.096658e-01f,  // 0.674
            5.086475e-01f,  // 0.676
            5.076312e-01f,  // 0.678
            5.066170e-01f,  // 0.680
            5.056048e-01f,  // 0.682
            5.045946e-01f,  // 0.684
            5.035864e-01f,  // 0.686
            5.025802e-01f,  // 0.688
            5.015761e-01f,  // 0.690
            5.005739e-01f,  // 0.692
            4.995738e-01f,  // 0.694
            4.985756e-01f,  // 0.696
            4.975795e-01f,  // 0.698
            4.965853e-01f,  // 0.700
            4.955931e-01f,  // 0.702
            4.946029e-01f,  // 0.704
            4.936147e-01f,  // 0.706
            4.926285e-01f,  // 0.708
            4.916442e-01f,  // 0.710
            4.906619e-01f,  // 0.712
            4.896815e-01f,  // 0.714
            4.887032e-01f,  // 0.716
            4.877267e-01f,  // 0.718
            4.867523e-01f,  // 0.720
            4.857797e-01f,  // 0.722
            4.848091e-01f,  // 0.724
            4.838405e-01f,  // 0.726
            4.828738e-01f,  // 0.728
            4.819090e-01f,  // 0.730
            4.809461e-01f,  // 0.732
            4.799852e-01f,  // 0.734
            4.790262e-01f,  // 0.736
            4.780691e-01f,  // 0.738
            4.771139e-01f,  // 0.740
            4.761606e-01f,  // 0.742
            4.752093e-01f,  // 0.744
            4.742598e-01f,  // 0.746
            4.733122e-01f,  // 0.748
            4.723666e-01f,  // 0.750
            4.714228e-01f,  // 0.752
            4.704809e-01f,  // 0.754
            4.695408e-01f,  // 0.756
            4.686027e-01f,  // 0.758
            4.676664e-01f,  // 0.760
            4.667320e-01f,  // 0.762
            4.657995e-01f,  // 0.764
            4.648688e-01f,  // 0.766
            4.639400e-01f,  // 0.768
            4.630131e-01f,  // 0.770
            4.620880e-01f,  // 0.772
            4.611647e-01f,  // 0.774
            4.602433e-01f,  // 0.776
            4.593237e-01f,  // 0.778
            4.584060e-01f,  // 0.780
            4.574901e-01f,  // 0.782
            4.565760e-01f,  // 0.784
            4.556638e-01f,  // 0.786
            4.547534e-01f,  // 0.788
            4.538448e-01f,  // 0.790
            4.529380e-01f,  // 0.792
            4.520330e-01f,  // 0.794
            4.511299e-01f,  // 0.796
            4.502285e-01f,  // 0.798
            4.493290e-01f,  // 0.800
            4.484312e-01f,  // 0.802
            4.475352e-01f,  // 0.804
            4.466411e-01f,  // 0.806
            4.457487e-01f,  // 0.808
            4.448581e-01f,  // 0.810
            4.439692e-01f,  // 0.812
            4.430822e-01f,  // 0.814
            4.421969e-01f,  // 0.816
            4.413134e-01f,  // 0.818
            4.404317e-01f,  // 0.820
            4.395517e-01f,  // 0.822
            4.386734e-01f,  // 0.824
            4.377970e-01f,  // 0.826
            4.369223e-01f,  // 0.828
            4.360493e-01f,  // 0.830
            4.351781e-01f,  // 0.832
            4.343086e-01f,  // 0.834
            4.334408e-01f,  // 0.836
            4.325748e-01f,  // 0.838
            4.317105e-01f,  // 0.840
            4.308480e-01f,  // 0.842
            4.299871e-01f,  // 0.844
            4.291280e-01f,  // 0.846
            4.282706e-01f,  // 0.848
            4.274149e-01f,  // 0.850
            4.265610e-01f,  // 0.852
            4.257087e-01f,  // 0.854
            4.248581e-01f,  // 0.856
            4.240093e-01f,  // 0.858
            4.231621e-01f,  // 0.860
            4.223166e-01f,  // 0.862
            4.214728e-01f,  // 0.864
            4.206307e-01f,  // 0.866
            4.197903e-01f,  // 0.868
            4.189515e-01f,  // 0.870
            4.181145e-01f,  // 0.872
            4.172791e-01f,  // 0.874
            4.164454e-01f,  // 0.876
            4.156133e-01f,  // 0.878
            4.147829e-01f,  // 0.880
            4.139542e-01f,  // 0.882
            4.131271e-01f,  // 0.884
            4.123017e-01f,  // 0.886
            4.114779e-01f,  // 0.888
            4.106558e-01f,  // 0.890
            4.098353e-01f,  // 0.892
            4.090164e-01f,  // 0.894
            4.081992e-01f,  // 0.896
            4.073836e-01f,  // 0.898
            4.065697e-01f,  // 0.900
            4.057573e-01f,  // 0.902
            4.049466e-01f,  // 0.904
            4.041375e-01f,  // 0.906
            4.033301e-01f,  // 0.908
            4.025242e-01f,  // 0.910
            4.017200e-01f,  // 0.912
            4.009173e-01f,  // 0.914
            4.001163e-01f,  // 0.916
            3.993169e-01f,  // 0.918
            3.985190e-01f,  // 0.920
            3.977228e-01f,  // 0.922
            3.969281e-01f,  // 0.924
            3.961351e-01f,  // 0.926
            3.953436e-01f,  // 0.928
            3.945537e-01f,  // 0.930
            3.937654e-01f,  // 0.932
            3.929786e-01f,  // 0.934
            3.921935e-01f,  // 0.936
            3.914099e-01f,  // 0.938
            3.906278e-01f,  // 0.940
            3.898474e-01f,  // 0.942
            3.890684e-01f,  // 0.944
            3.882911e-01f,  // 0.946
            3.875153e-01f,  // 0.948
            3.867410e-01f,  // 0.950
            3.859683e-01f,  // 0.952
            3.851971e-01f,  // 0.954
            3.844275e-01f,  // 0.956
            3.836594e-01f,  // 0.958
            3.828929e-01f,  // 0.960
            3.821279e-01f,  // 0.962
            3.813644e-01f,  // 0.964
            3.806024e-01f,  // 0.966
            3.798420e-01f,  // 0.968
            3.790830e-01f,  // 0.970
            3.783256e-01f,  // 0.972
            3.775697e-01f,  // 0.974
            3.768153e-01f,  // 0.976
            3.760625e-01f,  // 0.978
            3.753111e-01f,  // 0.980
            3.745612e-01f,  // 0.982
            3.738129e-01f,  // 0.984
            3.730660e-01f,  // 0.986
            3.723206e-01f,  // 0.988
            3.715767e-01f,  // 0.990
            3.708343e-01f,  // 0.992
            3.700934e-01f,  // 0.994
            3.693539e-01f,  // 0.996
            3.686159e-01f,  // 0.998
            3.678794e-01f,  // 1.000
            3.671444e-01f,  // 1.002
            3.664109e-01f,  // 1.004
            3.656788e-01f,  // 1.006
            3.649481e-01f,  // 1.008
            3.642190e-01f,  // 1.010
            3.634913e-01f,  // 1.012
            3.627650e-01f,  // 1.014
            3.620402e-01f,  // 1.016
            3.613169e-01f,  // 1.018
            3.605949e-01f,  // 1.020
            3.598745e-01f,  // 1.022
            3.591554e-01f,  // 1.024
            3.584378e-01f,  // 1.026
            3.577217e-01f,  // 1.028
            3.570070e-01f,  // 1.030
            3.562937e-01f,  // 1.032
            3.555818e-01f,  // 1.034
            3.548713e-01f,  // 1.036
            3.541623e-01f,  // 1.038
            3.534547e-01f,  // 1.040
            3.527485e-01f,  // 1.042
            3.520437e-01f,  // 1.044
            3.513403e-01f,  // 1.046
            3.506383e-01f,  // 1.048
            3.499377e-01f,  // 1.050
            3.492386e-01f,  // 1.052
            3.485408e-01f,  // 1.054
            3.478444e-01f,  // 1.056
            3.471494e-01f,  // 1.058
            3.464558e-01f,  // 1.060
            3.457636e-01f,  // 1.062
            3.450728e-01f,  // 1.064
            3.443833e-01f,  // 1.066
            3.436952e-01f,  // 1.068
            3.430085e-01f,  // 1.070
            3.423232e-01f,  // 1.072
            3.416392e-01f,  // 1.074
            3.409566e-01f,  // 1.076
            3.402754e-01f,  // 1.078
            3.395955e-01f,  // 1.080
            3.389170e-01f,  // 1.082
            3.382399e-01f,  // 1.084
            3.375641e-01f,  // 1.086
            3.368896e-01f,  // 1.088
            3.362165e-01f,  // 1.090
            3.355447e-01f,  // 1.092
            3.348743e-01f,  // 1.094
            3.342052e-01f,  // 1.096
            3.335375e-01f,  // 1.098
            3.328711e-01f,  // 1.100
            3.322060e-01f,  // 1.102
            3.315423e-01f,  // 1.104
            3.308798e-01f,  // 1.106
            3.302187e-01f,  // 1.108
            3.295590e-01f,  // 1.110
            3.289005e-01f,  // 1.112
            3.282434e-01f,  // 1.114
            3.275875e-01f,  // 1.116
            3.269330e-01f,  // 1.118
            3.262798e-01f,  // 1.120
            3.256279e-01f,  // 1.122
            3.249773e-01f,  // 1.124
            3.243280e-01f,  // 1.126
            3.236800e-01f,  // 1.128
            3.230333e-01f,  // 1.130
            3.223878e-01f,  // 1.132
            3.217437e-01f,  // 1.134
            3.211009e-01f,  // 1.136
            3.204593e-01f,  // 1.138
            3.198190e-01f,  // 1.140
            3.191800e-01f,  // 1.142
            3.185423e-01f,  // 1.144
            3.179059e-01f,  // 1.146
            3.172707e-01f,  // 1.148
            3.166368e-01f,  // 1.150
            3.160041e-01f,  // 1.152
            3.153728e-01f,  // 1.154
            3.147426e-01f,  // 1.156
            3.141138e-01f,  // 1.158
            3.134862e-01f,  // 1.160
            3.128598e-01f,  // 1.162
            3.122347e-01f,  // 1.164
            3.116109e-01f,  // 1.166
            3.109883e-01f,  // 1.168
            3.103669e-01f,  // 1.170
            3.097468e-01f,  // 1.172
            3.091280e-01f,  // 1.174
            3.085103e-01f,  // 1.176
            3.078939e-01f,  // 1.178
            3.072787e-01f,  // 1.180
            3.066648e-01f,  // 1.182
            3.060521e-01f,  // 1.184
            3.054406e-01f,  // 1.186
            3.048303e-01f,  // 1.188
            3.042213e-01f,  // 1.190
            3.036134e-01f,  // 1.192
            3.030068e-01f,  // 1.194
            3.024014e-01f,  // 1.196
            3.017972e-01f,  // 1.198
            3.011942e-01f,  // 1.200
            3.005924e-01f,  // 1.202
            2.999918e-01f,  // 1.204
            2.993925e-01f,  // 1.206
            2.987943e-01f,  // 1.208
            2.981973e-01f,  // 1.210
            2.976015e-01f,  // 1.212
            2.970069e-01f,  // 1.214
            2.964135e-01f,  // 1.216
            2.958212e-01f,  // 1.218
            2.952302e-01f,  // 1.220
            2.946403e-01f,  // 1.222
            2.940516e-01f,  // 1.224
            2.934641e-01f,  // 1.226
            2.928777e-01f,  // 1.228
            2.922926e-01f,  // 1.230
            2.917086e-01f,  // 1.232
            2.911257e-01f,  // 1.234
            2.905441e-01f,  // 1.236
            2.899636e-01f,  // 1.238
            2.893842e-01f,  // 1.240
            2.888060e-01f,  // 1.242
            2.882290e-01f,  // 1.244
            2.876531e-01f,  // 1.246
            2.870784e-01f,  // 1.248
            2.865048e-01f,  // 1.250
            2.859324e-01f,  // 1.252
            2.853611e-01f,  // 1.254
            2.847909e-01f,  // 1.256
            2.842219e-01f,  // 1.258
            2.836540e-01f,  // 1.260
            2.830873e-01f,  // 1.262
            2.825217e-01f,  // 1.264
            2.819572e-01f,  // 1.266
            2.813938e-01f,  // 1.268
            2.808316e-01f,  // 1.270
            2.802705e-01f,  // 1.272
            2.797105e-01f,  // 1.274
            2.791517e-01f,  // 1.276
            2.785939e-01f,  // 1.278
            2.780373e-01f,  // 1.280
            2.774818e-01f,  // 1.282
            2.769274e-01f,  // 1.284
            2.763741e-01f,  // 1.286
            2.758219e-01f,  // 1.288
            2.752708e-01f,  // 1.290
            2.747208e-01f,  // 1.292
            2.741719e-01f,  // 1.294
            2.736241e-01f,  // 1.296
            2.730774e-01f,  // 1.298
            2.725318e-01f,  // 1.300
            2.719873e-01f,  // 1.302
            2.714438e-01f,  // 1.304
            2.709015e-01f,  // 1.306
            2.703602e-01f,  // 1.308
            2.698201e-01f,  // 1.310
            2.692810e-01f,  // 1.312
            2.687429e-01f,  // 1.314
            2.682060e-01f,  // 1.316
            2.676701e-01f,  // 1.318
            2.671353e-01f,  // 1.320
            2.666016e-01f,  // 1.322
            2.660689e-01f,  // 1.324
            2.655373e-01f,  // 1.326
            2.650067e-01f,  // 1.328
            2.644773e-01f,  // 1.330
            2.639488e-01f,  // 1.332
            2.634215e-01f,  // 1.334
            2.628951e-01f,  // 1.336
            2.623699e-01f,  // 1.338
            2.618457e-01f,  // 1.340
            2.613225e-01f,  // 1.342
            2.608004e-01f,  // 1.344
            2.602793e-01f,  // 1.346
            2.597593e-01f,  // 1.348
            2.592403e-01f,  // 1.350
            2.587223e-01f,  // 1.352
            2.582054e-01f,  // 1.354
            2.576895e-01f,  // 1.356
            2.571746e-01f,  // 1.358
            2.566608e-01f,  // 1.360
            2.561480e-01f,  // 1.362
            2.556362e-01f,  // 1.364
            2.551254e-01f,  // 1.366
            2.546157e-01f,  // 1.368
            2.541070e-01f,  // 1.370
            2.535993e-01f,  // 1.372
            2.530926e-01f,  // 1.374
            2.525869e-01f,  // 1.376
            2.520822e-01f,  // 1.378
            2.515786e-01f,  // 1.380
            2.510759e-01f,  // 1.382
            2.505742e-01f,  // 1.384
            2.500736e-01f,  // 1.386
            2.495740e-01f,  // 1.388
            2.490753e-01f,  // 1.390
            2.485777e-01f,  // 1.392
            2.480810e-01f,  // 1.394
            2.475853e-01f,  // 1.396
            2.470907e-01f,  // 1.398
            2.465970e-01f,  // 1.400
            2.461043e-01f,  // 1.402
            2.456125e-01f,  // 1.404
            2.451218e-01f,  // 1.406
            2.446321e-01f,  // 1.408
            2.441433e-01f,  // 1.410
            2.436555e-01f,  // 1.412
            2.431687e-01f,  // 1.414
            2.426828e-01f,  // 1.416
            2.421979e-01f,  // 1.418
            2.417140e-01f,  // 1.420
            2.412311e-01f,  // 1.422
            2.407491e-01f,  // 1.424
            2.402681e-01f,  // 1.426
            2.397880e-01f,  // 1.428
            2.393089e-01f,  // 1.430
            2.388308e-01f,  // 1.432
            2.383536e-01f,  // 1.434
            2.378774e-01f,  // 1.436
            2.374021e-01f,  // 1.438
            2.369278e-01f,  // 1.440
            2.364544e-01f,  // 1.442
            2.359819e-01f,  // 1.444
            2.355104e-01f,  // 1.446
            2.350399e-01f,  // 1.448
            2.345703e-01f,  // 1.450
            2.341016e-01f,  // 1.452
            2.336339e-01f,  // 1.454
            2.331671e-01f,  // 1.456
            2.327012e-01f,  // 1.458
            2.322363e-01f,  // 1.460
            2.317723e-01f,  // 1.462
            2.313092e-01f,  // 1.464
            2.308470e-01f,  // 1.466
            2.303858e-01f,  // 1.468
            2.299255e-01f,  // 1.470
            2.294661e-01f,  // 1.472
            2.290076e-01f,  // 1.474
            2.285501e-01f,  // 1.476
            2.280934e-01f,  // 1.478
            2.276377e-01f,  // 1.480
            2.271829e-01f,  // 1.482
            2.267290e-01f,  // 1.484
            2.262760e-01f,  // 1.486
            2.258239e-01f,  // 1.488
            2.253727e-01f,  // 1.490
            2.249224e-01f,  // 1.492
            2.244730e-01f,  // 1.494
            2.240245e-01f,  // 1.496
            2.235769e-01f,  // 1.498
            2.231302e-01f,  // 1.500
            2.226843e-01f,  // 1.502
            2.222394e-01f,  // 1.504
            2.217954e-01f,  // 1.506
            2.213522e-01f,  // 1.508
            2.209100e-01f,  // 1.510
            2.204686e-01f,  // 1.512
            2.200281e-01f,  // 1.514
            2.195885e-01f,  // 1.516
            2.191497e-01f,  // 1.518
            2.187119e-01f,  // 1.520
            2.182749e-01f,  // 1.522
            2.178388e-01f,  // 1.524
            2.174035e-01f,  // 1.526
            2.169692e-01f,  // 1.528
            2.165357e-01f,  // 1.530
            2.161030e-01f,  // 1.532
            2.156713e-01f,  // 1.534
            2.152403e-01f,  // 1.536
            2.148103e-01f,  // 1.538
            2.143811e-01f,  // 1.540
            2.139528e-01f,  // 1.542
            2.135253e-01f,  // 1.544
            2.130987e-01f,  // 1.546
            2.126729e-01f,  // 1.548
            2.122480e-01f,  // 1.550
            2.118239e-01f,  // 1.552
            2.114007e-01f,  // 1.554
            2.109783e-01f,  // 1.556
            2.105568e-01f,  // 1.558
            2.101361e-01f,  // 1.560
            2.097162e-01f,  // 1.562
            2.092972e-01f,  // 1.564
            2.088790e-01f,  // 1.566
            2.084617e-01f,  // 1.568
            2.080452e-01f,  // 1.570
            2.076295e-01f,  // 1.572
            2.072147e-01f,  // 1.574
            2.068006e-01f,  // 1.576
            2.063875e-01f,  // 1.578
            2.059751e-01f,  // 1.580
            2.055636e-01f,  // 1.582
            2.051528e-01f,  // 1.584
            2.047429e-01f,  // 1.586
            2.043339e-01f,  // 1.588
            2.039256e-01f,  // 1.590
            2.035182e-01f,  // 1.592
            2.031115e-01f,  // 1.594
            2.027057e-01f,  // 1.596
            2.023007e-01f,  // 1.598
            2.018965e-01f,  // 1.600
            2.014931e-01f,  // 1.602
            2.010905e-01f,  // 1.604
            2.006888e-01f,  // 1.606
            2.002878e-01f,  // 1.608
            1.998876e-01f,  // 1.610
            1.994882e-01f,  // 1.612
            1.990897e-01f,  // 1.614
            1.986919e-01f,  // 1.616
            1.982949e-01f,  // 1.618
            1.978987e-01f,  // 1.620
            1.975033e-01f,  // 1.622
            1.971087e-01f,  // 1.624
            1.967149e-01f,  // 1.626
            1.963218e-01f,  // 1.628
            1.959296e-01f,  // 1.630
            1.955381e-01f,  // 1.632
            1.951474e-01f,  // 1.634
            1.947575e-01f,  // 1.636
            1.943684e-01f,  // 1.638
            1.939800e-01f,  // 1.640
            1.935925e-01f,  // 1.642
            1.932057e-01f,  // 1.644
            1.928196e-01f,  // 1.646
            1.924344e-01f,  // 1.648
            1.920499e-01f,  // 1.650
            1.916662e-01f,  // 1.652
            1.912832e-01f,  // 1.654
            1.909011e-01f,  // 1.656
            1.905196e-01f,  // 1.658
            1.901390e-01f,  // 1.660
            1.897591e-01f,  // 1.662
            1.893799e-01f,  // 1.664
            1.890016e-01f,  // 1.666
            1.886239e-01f,  // 1.668
            1.882471e-01f,  // 1.670
            1.878709e-01f,  // 1.672
            1.874956e-01f,  // 1.674
            1.871210e-01f,  // 1.676
            1.867471e-01f,  // 1.678
            1.863740e-01f,  // 1.680
            1.860016e-01f,  // 1.682
            1.856300e-01f,  // 1.684
            1.852591e-01f,  // 1.686
            1.848889e-01f,  // 1.688
            1.845195e-01f,  // 1.690
            1.841509e-01f,  // 1.692
            1.837829e-01f,  // 1.694
            1.834157e-01f,  // 1.696
            1.830493e-01f,  // 1.698
            1.826835e-01f,  // 1.700
            1.823185e-01f,  // 1.702
            1.819542e-01f,  // 1.704
            1.815907e-01f,  // 1.706
            1.812279e-01f,  // 1.708
            1.808658e-01f,  // 1.710
            1.805044e-01f,  // 1.712
            1.801438e-01f,  // 1.714
            1.797838e-01f,  // 1.716
            1.794246e-01f,  // 1.718
            1.790661e-01f,  // 1.720
            1.787084e-01f,  // 1.722
            1.783513e-01f,  // 1.724
            1.779950e-01f,  // 1.726
            1.776393e-01f,  // 1.728
            1.772844e-01f,  // 1.730
            1.769302e-01f,  // 1.732
            1.765767e-01f,  // 1.734
            1.762239e-01f,  // 1.736
            1.758718e-01f,  // 1.738
            1.755204e-01f,  // 1.740
            1.751697e-01f,  // 1.742
            1.748197e-01f,  // 1.744
            1.744704e-01f,  // 1.746
            1.741218e-01f,  // 1.748
            1.737739e-01f,  // 1.750
            1.734267e-01f,  // 1.752
            1.730802e-01f,  // 1.754
            1.727344e-01f,  // 1.756
            1.723893e-01f,  // 1.758
            1.720449e-01f,  // 1.760
            1.717011e-01f,  // 1.762
            1.713581e-01f,  // 1.764
            1.710157e-01f,  // 1.766
            1.706740e-01f,  // 1.768
            1.703330e-01f,  // 1.770
            1.699927e-01f,  // 1.772
            1.696530e-01f,  // 1.774
            1.693141e-01f,  // 1.776
            1.689758e-01f,  // 1.778
            1.686381e-01f,  // 1.780
            1.683012e-01f,  // 1.782
            1.679649e-01f,  // 1.784
            1.676293e-01f,  // 1.786
            1.672944e-01f,  // 1.788
            1.669602e-01f,  // 1.790
            1.666266e-01f,  // 1.792
            1.662937e-01f,  // 1.794
            1.659614e-01f,  // 1.796
            1.656298e-01f,  // 1.798
            1.652989e-01f,  // 1.800
            1.649686e-01f,  // 1.802
            1.646390e-01f,  // 1.804
            1.643101e-01f,  // 1.806
            1.639818e-01f,  // 1.808
            1.636541e-01f,  // 1.810
            1.633272e-01f,  // 1.812
            1.630008e-01f,  // 1.814
            1.626752e-01f,  // 1.816
            1.623501e-01f,  // 1.818
            1.620258e-01f,  // 1.820
            1.617020e-01f,  // 1.822
            1.613789e-01f,  // 1.824
            1.610565e-01f,  // 1.826
            1.607347e-01f,  // 1.828
            1.604136e-01f,  // 1.830
            1.600931e-01f,  // 1.832
            1.597732e-01f,  // 1.834
            1.594540e-01f,  // 1.836
            1.591354e-01f,  // 1.838
            1.588174e-01f,  // 1.840
            1.585001e-01f,  // 1.842
            1.581834e-01f,  // 1.844
            1.578674e-01f,  // 1.846
            1.575520e-01f,  // 1.848
            1.572372e-01f,  // 1.850
            1.569230e-01f,  // 1.852
            1.566095e-01f,  // 1.854
            1.562966e-01f,  // 1.856
            1.559843e-01f,  // 1.858
            1.556726e-01f,  // 1.860
            1.553616e-01f,  // 1.862
            1.550512e-01f,  // 1.864
            1.547414e-01f,  // 1.866
            1.544322e-01f,  // 1.868
            1.541237e-01f,  // 1.870
            1.538157e-01f,  // 1.872
            1.535084e-01f,  // 1.874
            1.532017e-01f,  // 1.876
            1.528956e-01f,  // 1.878
            1.525901e-01f,  // 1.880
            1.522852e-01f,  // 1.882
            1.519810e-01f,  // 1.884
            1.516773e-01f,  // 1.886
            1.513743e-01f,  // 1.888
            1.510718e-01f,  // 1.890
            1.507700e-01f,  // 1.892
            1.504687e-01f,  // 1.894
            1.501681e-01f,  // 1.896
            1.498681e-01f,  // 1.898
            1.495686e-01f,  // 1.900
            1.492698e-01f,  // 1.902
            1.489715e-01f,  // 1.904
            1.486739e-01f,  // 1.906
            1.483768e-01f,  // 1.908
            1.480804e-01f,  // 1.910
            1.477845e-01f,  // 1.912
            1.474892e-01f,  // 1.914
            1.471946e-01f,  // 1.916
            1.469005e-01f,  // 1.918
            1.466070e-01f,  // 1.920
            1.463140e-01f,  // 1.922
            1.460217e-01f,  // 1.924
            1.457300e-01f,  // 1.926
            1.454388e-01f,  // 1.928
            1.451482e-01f,  // 1.930
            1.448582e-01f,  // 1.932
            1.445688e-01f,  // 1.934
            1.442799e-01f,  // 1.936
            1.439916e-01f,  // 1.938
            1.437039e-01f,  // 1.940
            1.434168e-01f,  // 1.942
            1.431303e-01f,  // 1.944
            1.428443e-01f,  // 1.946
            1.425589e-01f,  // 1.948
            1.422741e-01f,  // 1.950
            1.419898e-01f,  // 1.952
            1.417061e-01f,  // 1.954
            1.414230e-01f,  // 1.956
            1.411404e-01f,  // 1.958
            1.408584e-01f,  // 1.960
            1.405770e-01f,  // 1.962
            1.402961e-01f,  // 1.964
            1.400158e-01f,  // 1.966
            1.397360e-01f,  // 1.968
            1.394569e-01f,  // 1.970
            1.391782e-01f,  // 1.972
            1.389001e-01f,  // 1.974
            1.386226e-01f,  // 1.976
            1.383457e-01f,  // 1.978
            1.380692e-01f,  // 1.980
            1.377934e-01f,  // 1.982
            1.375181e-01f,  // 1.984
            1.372433e-01f,  // 1.986
            1.369691e-01f,  // 1.988
            1.366954e-01f,  // 1.990
            1.364223e-01f,  // 1.992
            1.361497e-01f,  // 1.994
            1.358777e-01f,  // 1.996
            1.356062e-01f,  // 1.998
            1.353353e-01f,  // 2.000
            1.350649e-01f,  // 2.002
            1.347950e-01f,  // 2.004
            1.345257e-01f,  // 2.006
            1.342569e-01f,  // 2.008
            1.339887e-01f,  // 2.010
            1.337210e-01f,  // 2.012
            1.334538e-01f,  // 2.014
            1.331871e-01f,  // 2.016
            1.329210e-01f,  // 2.018
            1.326555e-01f,  // 2.020
            1.323904e-01f,  // 2.022
            1.321259e-01f,  // 2.024
            1.318619e-01f,  // 2.026
            1.315985e-01f,  // 2.028
            1.313355e-01f,  // 2.030
            1.310731e-01f,  // 2.032
            1.308112e-01f,  // 2.034
            1.305499e-01f,  // 2.036
            1.302890e-01f,  // 2.038
            1.300287e-01f,  // 2.040
            1.297689e-01f,  // 2.042
            1.295096e-01f,  // 2.044
            1.292509e-01f,  // 2.046
            1.289926e-01f,  // 2.048
            1.287349e-01f,  // 2.050
            1.284777e-01f,  // 2.052
            1.282210e-01f,  // 2.054
            1.279648e-01f,  // 2.056
            1.277091e-01f,  // 2.058
            1.274540e-01f,  // 2.060
            1.271993e-01f,  // 2.062
            1.269452e-01f,  // 2.064
            1.266915e-01f,  // 2.066
            1.264384e-01f,  // 2.068
            1.261858e-01f,  // 2.070
            1.259337e-01f,  // 2.072
            1.256820e-01f,  // 2.074
            1.254309e-01f,  // 2.076
            1.251803e-01f,  // 2.078
            1.249302e-01f,  // 2.080
            1.246806e-01f,  // 2.082
            1.244315e-01f,  // 2.084
            1.241829e-01f,  // 2.086
            1.239348e-01f,  // 2.088
            1.236871e-01f,  // 2.090
            1.234400e-01f,  // 2.092
            1.231934e-01f,  // 2.094
            1.229472e-01f,  // 2.096
            1.227016e-01f,  // 2.098
            1.224564e-01f,  // 2.100
            1.222118e-01f,  // 2.102
            1.219676e-01f,  // 2.104
            1.217239e-01f,  // 2.106
            1.214807e-01f,  // 2.108
            1.212380e-01f,  // 2.110
            1.209957e-01f,  // 2.112
            1.207540e-01f,  // 2.114
            1.205127e-01f,  // 2.116
            1.202719e-01f,  // 2.118
            1.200316e-01f,  // 2.120
            1.197918e-01f,  // 2.122
            1.195525e-01f,  // 2.124
            1.193136e-01f,  // 2.126
            1.190752e-01f,  // 2.128
            1.188373e-01f,  // 2.130
            1.185999e-01f,  // 2.132
            1.183629e-01f,  // 2.134
            1.181264e-01f,  // 2.136
            1.178904e-01f,  // 2.138
            1.176548e-01f,  // 2.140
            1.174198e-01f,  // 2.142
            1.171852e-01f,  // 2.144
            1.169510e-01f,  // 2.146
            1.167174e-01f,  // 2.148
            1.164842e-01f,  // 2.150
            1.162514e-01f,  // 2.152
            1.160192e-01f,  // 2.154
            1.157873e-01f,  // 2.156
            1.155560e-01f,  // 2.158
            1.153251e-01f,  // 2.160
            1.150947e-01f,  // 2.162
            1.148647e-01f,  // 2.164
            1.146352e-01f,  // 2.166
            1.144062e-01f,  // 2.168
            1.141776e-01f,  // 2.170
            1.139495e-01f,  // 2.172
            1.137218e-01f,  // 2.174
            1.134946e-01f,  // 2.176
            1.132678e-01f,  // 2.178
            1.130415e-01f,  // 2.180
            1.128157e-01f,  // 2.182
            1.125903e-01f,  // 2.184
            1.123653e-01f,  // 2.186
            1.121408e-01f,  // 2.188
            1.119167e-01f,  // 2.190
            1.116931e-01f,  // 2.192
            1.114700e-01f,  // 2.194
            1.112473e-01f,  // 2.196
            1.110250e-01f,  // 2.198
            1.108032e-01f,  // 2.200
            1.105818e-01f,  // 2.202
            1.103608e-01f,  // 2.204
            1.101403e-01f,  // 2.206
            1.099203e-01f,  // 2.208
            1.097006e-01f,  // 2.210
            1.094815e-01f,  // 2.212
            1.092627e-01f,  // 2.214
            1.090444e-01f,  // 2.216
            1.088265e-01f,  // 2.218
            1.086091e-01f,  // 2.220
            1.083921e-01f,  // 2.222
            1.081755e-01f,  // 2.224
            1.079594e-01f,  // 2.226
            1.077437e-01f,  // 2.228
            1.075284e-01f,  // 2.230
            1.073136e-01f,  // 2.232
            1.070992e-01f,  // 2.234
            1.068852e-01f,  // 2.236
            1.066716e-01f,  // 2.238
            1.064585e-01f,  // 2.240
            1.062458e-01f,  // 2.242
            1.060335e-01f,  // 2.244
            1.058217e-01f,  // 2.246
            1.056102e-01f,  // 2.248
            1.053992e-01f,  // 2.250
            1.051886e-01f,  // 2.252
            1.049785e-01f,  // 2.254
            1.047687e-01f,  // 2.256
            1.045594e-01f,  // 2.258
            1.043505e-01f,  // 2.260
            1.041420e-01f,  // 2.262
            1.039339e-01f,  // 2.264
            1.037263e-01f,  // 2.266
            1.035190e-01f,  // 2.268
            1.033122e-01f,  // 2.270
            1.031058e-01f,  // 2.272
            1.028998e-01f,  // 2.274
            1.026942e-01f,  // 2.276
            1.024890e-01f,  // 2.278
            1.022842e-01f,  // 2.280
            1.020798e-01f,  // 2.282
            1.018759e-01f,  // 2.284
            1.016723e-01f,  // 2.286
            1.014692e-01f,  // 2.288
            1.012665e-01f,  // 2.290
            1.010641e-01f,  // 2.292
            1.008622e-01f,  // 2.294
            1.006607e-01f,  // 2.296
            1.004596e-01f,  // 2.298
            1.002588e-01f,  // 2.300
            1.000585e-01f,  // 2.302
            9.985861e-02f,  // 2.304
            9.965909e-02f,  // 2.306
            9.945997e-02f,  // 2.308
            9.926125e-02f,  // 2.310
            9.906293e-02f,  // 2.312
            9.886500e-02f,  // 2.314
            9.866747e-02f,  // 2.316
            9.847033e-02f,  // 2.318
            9.827359e-02f,  // 2.320
            9.807723e-02f,  // 2.322
            9.788128e-02f,  // 2.324
            9.768571e-02f,  // 2.326
            9.749053e-02f,  // 2.328
            9.729575e-02f,  // 2.330
            9.710135e-02f,  // 2.332
            9.690734e-02f,  // 2.334
            9.671372e-02f,  // 2.336
            9.652049e-02f,  // 2.338
            9.632764e-02f,  // 2.340
            9.613518e-02f,  // 2.342
            9.594310e-02f,  // 2.344
            9.575140e-02f,  // 2.346
            9.556009e-02f,  // 2.348
            9.536916e-02f,  // 2.350
            9.517861e-02f,  // 2.352
            9.498845e-02f,  // 2.354
            9.479866e-02f,  // 2.356
            9.460925e-02f,  // 2.358
            9.442022e-02f,  // 2.360
            9.423157e-02f,  // 2.362
            9.404330e-02f,  // 2.364
            9.385540e-02f,  // 2.366
            9.366787e-02f,  // 2.368
            9.348073e-02f,  // 2.370
            9.329395e-02f,  // 2.372
            9.310755e-02f,  // 2.374
            9.292152e-02f,  // 2.376
            9.273586e-02f,  // 2.378
            9.255058e-02f,  // 2.380
            9.236566e-02f,  // 2.382
            9.218111e-02f,  // 2.384
            9.199694e-02f,  // 2.386
            9.181313e-02f,  // 2.388
            9.162968e-02f,  // 2.390
            9.144661e-02f,  // 2.392
            9.126390e-02f,  // 2.394
            9.108155e-02f,  // 2.396
            9.089957e-02f,  // 2.398
            9.071795e-02f,  // 2.400
            9.053670e-02f,  // 2.402
            9.035581e-02f,  // 2.404
            9.017528e-02f,  // 2.406
            8.999510e-02f,  // 2.408
            8.981529e-02f,  // 2.410
            8.963584e-02f,  // 2.412
            8.945675e-02f,  // 2.414
            8.927802e-02f,  // 2.416
            8.909964e-02f,  // 2.418
            8.892162e-02f,  // 2.420
            8.874395e-02f,  // 2.422
            8.856664e-02f,  // 2.424
            8.838969e-02f,  // 2.426
            8.821308e-02f,  // 2.428
            8.803683e-02f,  // 2.430
            8.786093e-02f,  // 2.432
            8.768539e-02f,  // 2.434
            8.751019e-02f,  // 2.436
            8.733535e-02f,  // 2.438
            8.716085e-02f,  // 2.440
            8.698670e-02f,  // 2.442
            8.681290e-02f,  // 2.444
            8.663945e-02f,  // 2.446
            8.646635e-02f,  // 2.448
            8.629359e-02f,  // 2.450
            8.612117e-02f,  // 2.452
            8.594910e-02f,  // 2.454
            8.577738e-02f,  // 2.456
            8.560599e-02f,  // 2.458
            8.543495e-02f,  // 2.460
            8.526425e-02f,  // 2.462
            8.509389e-02f,  // 2.464
            8.492388e-02f,  // 2.466
            8.475420e-02f,  // 2.468
            8.458486e-02f,  // 2.470
            8.441586e-02f,  // 2.472
            8.424720e-02f,  // 2.474
            8.407887e-02f,  // 2.476
            8.391088e-02f,  // 2.478
            8.374323e-02f,  // 2.480
            8.357591e-02f,  // 2.482
            8.340892e-02f,  // 2.484
            8.324227e-02f,  // 2.486
            8.307595e-02f,  // 2.488
            8.290997e-02f,  // 2.490
            8.274431e-02f,  // 2.492
            8.257899e-02f,  // 2.494
            8.241400e-02f,  // 2.496
            8.224933e-02f,  // 2.498
            8.208500e-02f,  // 2.500
            8.192099e-02f,  // 2.502
            8.175731e-02f,  // 2.504
            8.159396e-02f,  // 2.506
            8.143094e-02f,  // 2.508
            8.126824e-02f,  // 2.510
            8.110587e-02f,  // 2.512
            8.094382e-02f,  // 2.514
            8.078209e-02f,  // 2.516
            8.062069e-02f,  // 2.518
            8.045961e-02f,  // 2.520
            8.029885e-02f,  // 2.522
            8.013841e-02f,  // 2.524
            7.997829e-02f,  // 2.526
            7.981850e-02f,  // 2.528
            7.965902e-02f,  // 2.530
            7.949986e-02f,  // 2.532
            7.934102e-02f,  // 2.534
            7.918250e-02f,  // 2.536
            7.902429e-02f,  // 2.538
            7.886640e-02f,  // 2.540
            7.870882e-02f,  // 2.542
            7.855156e-02f,  // 2.544
            7.839462e-02f,  // 2.546
            7.823799e-02f,  // 2.548
            7.808167e-02f,  // 2.550
            7.792566e-02f,  // 2.552
            7.776996e-02f,  // 2.554
            7.761458e-02f,  // 2.556
            7.745950e-02f,  // 2.558
            7.730474e-02f,  // 2.560
            7.715029e-02f,  // 2.562
            7.699614e-02f,  // 2.564
            7.684230e-02f,  // 2.566
            7.668877e-02f,  // 2.568
            7.653555e-02f,  // 2.570
            7.638263e-02f,  // 2.572
            7.623001e-02f,  // 2.574
            7.607771e-02f,  // 2.576
            7.592570e-02f,  // 2.578
            7.577400e-02f,  // 2.580
            7.562261e-02f,  // 2.582
            7.547151e-02f,  // 2.584
            7.532072e-02f,  // 2.586
            7.517023e-02f,  // 2.588
            7.502004e-02f,  // 2.590
            7.487015e-02f,  // 2.592
            7.472056e-02f,  // 2.594
            7.457127e-02f,  // 2.596
            7.442227e-02f,  // 2.598
            7.427358e-02f,  // 2.600
            7.412518e-02f,  // 2.602
            7.397708e-02f,  // 2.604
            7.382927e-02f,  // 2.606
            7.368176e-02f,  // 2.608
            7.353454e-02f,  // 2.610
            7.338762e-02f,  // 2.612
            7.324099e-02f,  // 2.614
            7.309466e-02f,  // 2.616
            7.294861e-02f,  // 2.618
            7.280286e-02f,  // 2.620
            7.265740e-02f,  // 2.622
            7.251223e-02f,  // 2.624
            7.236735e-02f,  // 2.626
            7.222276e-02f,  // 2.628
            7.207846e-02f,  // 2.630
            7.193445e-02f,  // 2.632
            7.179072e-02f,  // 2.634
            7.164729e-02f,  // 2.636
            7.150413e-02f,  // 2.638
            7.136127e-02f,  // 2.640
            7.121869e-02f,  // 2.642
            7.107639e-02f,  // 2.644
            7.093438e-02f,  // 2.646
            7.079266e-02f,  // 2.648
            7.065121e-02f,  // 2.650
            7.051005e-02f,  // 2.652
            7.036917e-02f,  // 2.654
            7.022857e-02f,  // 2.656
            7.008826e-02f,  // 2.658
            6.994822e-02f,  // 2.660
            6.980847e-02f,  // 2.662
            6.966899e-02f,  // 2.664
            6.952979e-02f,  // 2.666
            6.939087e-02f,  // 2.668
            6.925223e-02f,  // 2.670
            6.911386e-02f,  // 2.672
            6.897577e-02f,  // 2.674
            6.883796e-02f,  // 2.676
            6.870042e-02f,  // 2.678
            6.856315e-02f,  // 2.680
            6.842616e-02f,  // 2.682
            6.828945e-02f,  // 2.684
            6.815301e-02f,  // 2.686
            6.801684e-02f,  // 2.688
            6.788094e-02f,  // 2.690
            6.774531e-02f,  // 2.692
            6.760996e-02f,  // 2.694
            6.747487e-02f,  // 2.696
            6.734006e-02f,  // 2.698
            6.720551e-02f,  // 2.700
            6.707124e-02f,  // 2.702
            6.693723e-02f,  // 2.704
            6.680349e-02f,  // 2.706
            6.667001e-02f,  // 2.708
            6.653681e-02f,  // 2.710
            6.640387e-02f,  // 2.712
            6.627119e-02f,  // 2.714
            6.613878e-02f,  // 2.716
            6.600664e-02f,  // 2.718
            6.587475e-02f,  // 2.720
            6.574314e-02f,  // 2.722
            6.561178e-02f,  // 2.724
            6.548069e-02f,  // 2.726
            6.534986e-02f,  // 2.728
            6.521929e-02f,  // 2.730
            6.508898e-02f,  // 2.732
            6.495893e-02f,  // 2.734
            6.482915e-02f,  // 2.736
            6.469962e-02f,  // 2.738
            6.457035e-02f,  // 2.740
            6.444134e-02f,  // 2.742
            6.431258e-02f,  // 2.744
            6.418408e-02f,  // 2.746
            6.405584e-02f,  // 2.748
            6.392786e-02f,  // 2.750
            6.380013e-02f,  // 2.752
            6.367266e-02f,  // 2.754
            6.354544e-02f,  // 2.756
            6.341848e-02f,  // 2.758
            6.329177e-02f,  // 2.760
            6.316531e-02f,  // 2.762
            6.303911e-02f,  // 2.764
            6.291315e-02f,  // 2.766
            6.278745e-02f,  // 2.768
            6.266200e-02f,  // 2.770
            6.253681e-02f,  // 2.772
            6.241186e-02f,  // 2.774
            6.228716e-02f,  // 2.776
            6.216271e-02f,  // 2.778
            6.203851e-02f,  // 2.780
            6.191455e-02f,  // 2.782
            6.179085e-02f,  // 2.784
            6.166739e-02f,  // 2.786
            6.154418e-02f,  // 2.788
            6.142121e-02f,  // 2.790
            6.129849e-02f,  // 2.792
            6.117602e-02f,  // 2.794
            6.105379e-02f,  // 2.796
            6.093180e-02f,  // 2.798
            6.081006e-02f,  // 2.800
            6.068856e-02f,  // 2.802
            6.056731e-02f,  // 2.804
            6.044629e-02f,  // 2.806
            6.032552e-02f,  // 2.808
            6.020499e-02f,  // 2.810
            6.008470e-02f,  // 2.812
            5.996465e-02f,  // 2.814
            5.984484e-02f,  // 2.816
            5.972527e-02f,  // 2.818
            5.960594e-02f,  // 2.820
            5.948685e-02f,  // 2.822
            5.936800e-02f,  // 2.824
            5.924938e-02f,  // 2.826
            5.913100e-02f,  // 2.828
            5.901285e-02f,  // 2.830
            5.889495e-02f,  // 2.832
            5.877727e-02f,  // 2.834
            5.865984e-02f,  // 2.836
            5.854263e-02f,  // 2.838
            5.842567e-02f,  // 2.840
            5.830893e-02f,  // 2.842
            5.819243e-02f,  // 2.844
            5.807616e-02f,  // 2.846
            5.796013e-02f,  // 2.848
            5.784432e-02f,  // 2.850
            5.772875e-02f,  // 2.852
            5.761341e-02f,  // 2.854
            5.749829e-02f,  // 2.856
            5.738341e-02f,  // 2.858
            5.726876e-02f,  // 2.860
            5.715434e-02f,  // 2.862
            5.704014e-02f,  // 2.864
            5.692618e-02f,  // 2.866
            5.681244e-02f,  // 2.868
            5.669893e-02f,  // 2.870
            5.658564e-02f,  // 2.872
            5.647258e-02f,  // 2.874
            5.635975e-02f,  // 2.876
            5.624714e-02f,  // 2.878
            5.613476e-02f,  // 2.880
            5.602261e-02f,  // 2.882
            5.591067e-02f,  // 2.884
            5.579896e-02f,  // 2.886
            5.568748e-02f,  // 2.888
            5.557621e-02f,  // 2.890
            5.546517e-02f,  // 2.892
            5.535435e-02f,  // 2.894
            5.524375e-02f,  // 2.896
            5.513338e-02f,  // 2.898
            5.502322e-02f,  // 2.900
            5.491328e-02f,  // 2.902
            5.480357e-02f,  // 2.904
            5.469407e-02f,  // 2.906
            5.458479e-02f,  // 2.908
            5.447573e-02f,  // 2.910
            5.436689e-02f,  // 2.912
            5.425826e-02f,  // 2.914
            5.414985e-02f,  // 2.916
            5.404166e-02f,  // 2.918
            5.393369e-02f,  // 2.920
            5.382593e-02f,  // 2.922
            5.371838e-02f,  // 2.924
            5.361105e-02f,  // 2.926
            5.350394e-02f,  // 2.928
            5.339704e-02f,  // 2.930
            5.329035e-02f,  // 2.932
            5.318388e-02f,  // 2.934
            5.307762e-02f,  // 2.936
            5.297157e-02f,  // 2.938
            5.286573e-02f,  // 2.940
            5.276010e-02f,  // 2.942
            5.265469e-02f,  // 2.944
            5.254948e-02f,  // 2.946
            5.244449e-02f,  // 2.948
            5.233971e-02f,  // 2.950
            5.223513e-02f,  // 2.952
            5.213077e-02f,  // 2.954
            5.202661e-02f,  // 2.956
            5.192266e-02f,  // 2.958
            5.181892e-02f,  // 2.960
            5.171538e-02f,  // 2.962
            5.161206e-02f,  // 2.964
            5.150893e-02f,  // 2.966
            5.140602e-02f,  // 2.968
            5.130331e-02f,  // 2.970
            5.120081e-02f,  // 2.972
            5.109851e-02f,  // 2.974
            5.099641e-02f,  // 2.976
            5.089452e-02f,  // 2.978
            5.079283e-02f,  // 2.980
            5.069135e-02f,  // 2.982
            5.059007e-02f,  // 2.984
            5.048899e-02f,  // 2.986
            5.038811e-02f,  // 2.988
            5.028744e-02f,  // 2.990
            5.018696e-02f,  // 2.992
            5.008669e-02f,  // 2.994
            4.998662e-02f,  // 2.996
            4.988674e-02f,  // 2.998
            4.978707e-02f,  // 3.000
            4.968759e-02f,  // 3.002
            4.958832e-02f,  // 3.004
            4.948924e-02f,  // 3.006
            4.939036e-02f,  // 3.008
            4.929168e-02f,  // 3.010
            4.919319e-02f,  // 3.012
            4.909491e-02f,  // 3.014
            4.899681e-02f,  // 3.016
            4.889892e-02f,  // 3.018
            4.880122e-02f,  // 3.020
            4.870371e-02f,  // 3.022
            4.860640e-02f,  // 3.024
            4.850929e-02f,  // 3.026
            4.841237e-02f,  // 3.028
            4.831564e-02f,  // 3.030
            4.821910e-02f,  // 3.032
            4.812276e-02f,  // 3.034
            4.802661e-02f,  // 3.036
            4.793066e-02f,  // 3.038
            4.783489e-02f,  // 3.040
            4.773932e-02f,  // 3.042
            4.764393e-02f,  // 3.044
            4.754874e-02f,  // 3.046
            4.745374e-02f,  // 3.048
            4.735892e-02f,  // 3.050
            4.726430e-02f,  // 3.052
            4.716987e-02f,  // 3.054
            4.707562e-02f,  // 3.056
            4.698156e-02f,  // 3.058
            4.688770e-02f,  // 3.060
            4.679401e-02f,  // 3.062
            4.670052e-02f,  // 3.064
            4.660721e-02f,  // 3.066
            4.651409e-02f,  // 3.068
            4.642115e-02f,  // 3.070
            4.632841e-02f,  // 3.072
            4.623584e-02f,  // 3.074
            4.614346e-02f,  // 3.076
            4.605127e-02f,  // 3.078
            4.595926e-02f,  // 3.080
            4.586743e-02f,  // 3.082
            4.577579e-02f,  // 3.084
            4.568433e-02f,  // 3.086
            4.559305e-02f,  // 3.088
            4.550195e-02f,  // 3.090
            4.541104e-02f,  // 3.092
            4.532031e-02f,  // 3.094
            4.522976e-02f,  // 3.096
            4.513939e-02f,  // 3.098
            4.504920e-02f,  // 3.100
            4.495919e-02f,  // 3.102
            4.486937e-02f,  // 3.104
            4.477972e-02f,  // 3.106
            4.469025e-02f,  // 3.108
            4.460096e-02f,  // 3.110
            4.451184e-02f,  // 3.112
            4.442291e-02f,  // 3.114
            4.433415e-02f,  // 3.116
            4.424557e-02f,  // 3.118
            4.415717e-02f,  // 3.120
            4.406894e-02f,  // 3.122
            4.398089e-02f,  // 3.124
            4.389302e-02f,  // 3.126
            4.380532e-02f,  // 3.128
            4.371780e-02f,  // 3.130
            4.363045e-02f,  // 3.132
            4.354328e-02f,  // 3.134
            4.345628e-02f,  // 3.136
            4.336945e-02f,  // 3.138
            4.328280e-02f,  // 3.140
            4.319632e-02f,  // 3.142
            4.311001e-02f,  // 3.144
            4.302388e-02f,  // 3.146
            4.293792e-02f,  // 3.148
            4.285213e-02f,  // 3.150
            4.276651e-02f,  // 3.152
            4.268106e-02f,  // 3.154
            4.259578e-02f,  // 3.156
            4.251068e-02f,  // 3.158
            4.242574e-02f,  // 3.160
            4.234097e-02f,  // 3.162
            4.225638e-02f,  // 3.164
            4.217195e-02f,  // 3.166
            4.208769e-02f,  // 3.168
            4.200360e-02f,  // 3.170
            4.191967e-02f,  // 3.172
            4.183592e-02f,  // 3.174
            4.175233e-02f,  // 3.176
            4.166891e-02f,  // 3.178
            4.158566e-02f,  // 3.180
            4.150257e-02f,  // 3.182
            4.141964e-02f,  // 3.184
            4.133689e-02f,  // 3.186
            4.125430e-02f,  // 3.188
            4.117187e-02f,  // 3.190
            4.108961e-02f,  // 3.192
            4.100751e-02f,  // 3.194
            4.092558e-02f,  // 3.196
            4.084381e-02f,  // 3.198
            4.076220e-02f,  // 3.200
            4.068076e-02f,  // 3.202
            4.059948e-02f,  // 3.204
            4.051836e-02f,  // 3.206
            4.043741e-02f,  // 3.208
            4.035661e-02f,  // 3.210
            4.027598e-02f,  // 3.212
            4.019551e-02f,  // 3.214
            4.011520e-02f,  // 3.216
            4.003505e-02f,  // 3.218
            3.995506e-02f,  // 3.220
            3.987523e-02f,  // 3.222
            3.979556e-02f,  // 3.224
            3.971605e-02f,  // 3.226
            3.963669e-02f,  // 3.228
            3.955750e-02f,  // 3.230
            3.947846e-02f,  // 3.232
            3.939958e-02f,  // 3.234
            3.932086e-02f,  // 3.236
            3.924230e-02f,  // 3.238
            3.916390e-02f,  // 3.240
            3.908565e-02f,  // 3.242
            3.900755e-02f,  // 3.244
            3.892962e-02f,  // 3.246
            3.885183e-02f,  // 3.248
            3.877421e-02f,  // 3.250
            3.869674e-02f,  // 3.252
            3.861942e-02f,  // 3.254
            3.854226e-02f,  // 3.256
            3.846525e-02f,  // 3.258
            3.838840e-02f,  // 3.260
            3.831170e-02f,  // 3.262
            3.823515e-02f,  // 3.264
            3.815876e-02f,  // 3.266
            3.808252e-02f,  // 3.268
            3.800643e-02f,  // 3.270
            3.793049e-02f,  // 3.272
            3.785471e-02f,  // 3.274
            3.777907e-02f,  // 3.276
            3.770359e-02f,  // 3.278
            3.762826e-02f,  // 3.280
            3.755308e-02f,  // 3.282
            3.747804e-02f,  // 3.284
            3.740316e-02f,  // 3.286
            3.732843e-02f,  // 3.288
            3.725385e-02f,  // 3.290
            3.717942e-02f,  // 3.292
            3.710513e-02f,  // 3.294
            3.703100e-02f,  // 3.296
            3.695701e-02f,  // 3.298
            3.688317e-02f,  // 3.300
            3.680947e-02f,  // 3.302
            3.673593e-02f,  // 3.304
            3.666253e-02f,  // 3.306
            3.658928e-02f,  // 3.308
            3.651617e-02f,  // 3.310
            3.644321e-02f,  // 3.312
            3.637040e-02f,  // 3.314
            3.629773e-02f,  // 3.316
            3.622521e-02f,  // 3.318
            3.615283e-02f,  // 3.320
            3.608060e-02f,  // 3.322
            3.600851e-02f,  // 3.324
            3.593656e-02f,  // 3.326
            3.586476e-02f,  // 3.328
            3.579311e-02f,  // 3.330
            3.572159e-02f,  // 3.332
            3.565022e-02f,  // 3.334
            3.557899e-02f,  // 3.336
            3.550790e-02f,  // 3.338
            3.543696e-02f,  // 3.340
            3.536615e-02f,  // 3.342
            3.529549e-02f,  // 3.344
            3.522497e-02f,  // 3.346
            3.515459e-02f,  // 3.348
            3.508435e-02f,  // 3.350
            3.501426e-02f,  // 3.352
            3.494430e-02f,  // 3.354
            3.487448e-02f,  // 3.356
            3.480480e-02f,  // 3.358
            3.473526e-02f,  // 3.360
            3.466586e-02f,  // 3.362
            3.459660e-02f,  // 3.364
            3.452747e-02f,  // 3.366
            3.445849e-02f,  // 3.368
            3.438964e-02f,  // 3.370
            3.432093e-02f,  // 3.372
            3.425235e-02f,  // 3.374
            3.418392e-02f,  // 3.376
            3.411562e-02f,  // 3.378
            3.404745e-02f,  // 3.380
            3.397943e-02f,  // 3.382
            3.391154e-02f,  // 3.384
            3.384378e-02f,  // 3.386
            3.377616e-02f,  // 3.388
            3.370868e-02f,  // 3.390
            3.364133e-02f,  // 3.392
            3.357411e-02f,  // 3.394
            3.350703e-02f,  // 3.396
            3.344008e-02f,  // 3.398
            3.337327e-02f,  // 3.400
            3.330659e-02f,  // 3.402
            3.324004e-02f,  // 3.404
            3.317363e-02f,  // 3.406
            3.310735e-02f,  // 3.408
            3.304120e-02f,  // 3.410
            3.297518e-02f,  // 3.412
            3.290930e-02f,  // 3.414
            3.284355e-02f,  // 3.416
            3.277793e-02f,  // 3.418
            3.271243e-02f,  // 3.420
            3.264708e-02f,  // 3.422
            3.258185e-02f,  // 3.424
            3.251675e-02f,  // 3.426
            3.245178e-02f,  // 3.428
            3.238694e-02f,  // 3.430
            3.232223e-02f,  // 3.432
            3.225765e-02f,  // 3.434
            3.219320e-02f,  // 3.436
            3.212888e-02f,  // 3.438
            3.206469e-02f,  // 3.440
            3.200062e-02f,  // 3.442
            3.193668e-02f,  // 3.444
            3.187287e-02f,  // 3.446
            3.180919e-02f,  // 3.448
            3.174564e-02f,  // 3.450
            3.168221e-02f,  // 3.452
            3.161891e-02f,  // 3.454
            3.155573e-02f,  // 3.456
            3.149268e-02f,  // 3.458
            3.142976e-02f,  // 3.460
            3.136697e-02f,  // 3.462
            3.130429e-02f,  // 3.464
            3.124175e-02f,  // 3.466
            3.117933e-02f,  // 3.468
            3.111703e-02f,  // 3.470
            3.105486e-02f,  // 3.472
            3.099281e-02f,  // 3.474
            3.093089e-02f,  // 3.476
            3.086909e-02f,  // 3.478
            3.080741e-02f,  // 3.480
            3.074586e-02f,  // 3.482
            3.068443e-02f,  // 3.484
            3.062312e-02f,  // 3.486
            3.056193e-02f,  // 3.488
            3.050087e-02f,  // 3.490
            3.043993e-02f,  // 3.492
            3.037911e-02f,  // 3.494
            3.031841e-02f,  // 3.496
            3.025784e-02f,  // 3.498
            3.019738e-02f,  // 3.500
            3.013705e-02f,  // 3.502
            3.007684e-02f,  // 3.504
            3.001674e-02f,  // 3.506
            2.995677e-02f,  // 3.508
            2.989691e-02f,  // 3.510
            2.983718e-02f,  // 3.512
            2.977757e-02f,  // 3.514
            2.971807e-02f,  // 3.516
            2.965869e-02f,  // 3.518
            2.959944e-02f,  // 3.520
            2.954030e-02f,  // 3.522
            2.948127e-02f,  // 3.524
            2.942237e-02f,  // 3.526
            2.936358e-02f,  // 3.528
            2.930492e-02f,  // 3.530
            2.924636e-02f,  // 3.532
            2.918793e-02f,  // 3.534
            2.912961e-02f,  // 3.536
            2.907141e-02f,  // 3.538
            2.901333e-02f,  // 3.540
            2.895536e-02f,  // 3.542
            2.889751e-02f,  // 3.544
            2.883977e-02f,  // 3.546
            2.878215e-02f,  // 3.548
            2.872464e-02f,  // 3.550
            2.866725e-02f,  // 3.552
            2.860997e-02f,  // 3.554
            2.855281e-02f,  // 3.556
            2.849576e-02f,  // 3.558
            2.843882e-02f,  // 3.560
            2.838200e-02f,  // 3.562
            2.832530e-02f,  // 3.564
            2.826870e-02f,  // 3.566
            2.821222e-02f,  // 3.568
            2.815585e-02f,  // 3.570
            2.809960e-02f,  // 3.572
            2.804346e-02f,  // 3.574
            2.798742e-02f,  // 3.576
            2.793151e-02f,  // 3.578
            2.787570e-02f,  // 3.580
            2.782000e-02f,  // 3.582
            2.776442e-02f,  // 3.584
            2.770894e-02f,  // 3.586
            2.765358e-02f,  // 3.588
            2.759833e-02f,  // 3.590
            2.754319e-02f,  // 3.592
            2.748816e-02f,  // 3.594
            2.743324e-02f,  // 3.596
            2.737842e-02f,  // 3.598
            2.732372e-02f,  // 3.600
            2.726913e-02f,  // 3.602
            2.721465e-02f,  // 3.604
            2.716027e-02f,  // 3.606
            2.710600e-02f,  // 3.608
            2.705185e-02f,  // 3.610
            2.699780e-02f,  // 3.612
            2.694386e-02f,  // 3.614
            2.689002e-02f,  // 3.616
            2.683630e-02f,  // 3.618
            2.678268e-02f,  // 3.620
            2.672916e-02f,  // 3.622
            2.667576e-02f,  // 3.624
            2.662246e-02f,  // 3.626
            2.656927e-02f,  // 3.628
            2.651618e-02f,  // 3.630
            2.646321e-02f,  // 3.632
            2.641033e-02f,  // 3.634
            2.635756e-02f,  // 3.636
            2.630490e-02f,  // 3.638
            2.625234e-02f,  // 3.640
            2.619989e-02f,  // 3.642
            2.614754e-02f,  // 3.644
            2.609530e-02f,  // 3.646
            2.604316e-02f,  // 3.648
            2.599113e-02f,  // 3.650
            2.593920e-02f,  // 3.652
            2.588737e-02f,  // 3.654
            2.583565e-02f,  // 3.656
            2.578403e-02f,  // 3.658
            2.573251e-02f,  // 3.660
            2.568110e-02f,  // 3.662
            2.562979e-02f,  // 3.664
            2.557858e-02f,  // 3.666
            2.552747e-02f,  // 3.668
            2.547647e-02f,  // 3.670
            2.542557e-02f,  // 3.672
            2.537477e-02f,  // 3.674
            2.532407e-02f,  // 3.676
            2.527347e-02f,  // 3.678
            2.522297e-02f,  // 3.680
            2.517258e-02f,  // 3.682
            2.512228e-02f,  // 3.684
            2.507209e-02f,  // 3.686
            2.502200e-02f,  // 3.688
            2.497200e-02f,  // 3.690
            2.492211e-02f,  // 3.692
            2.487231e-02f,  // 3.694
            2.482262e-02f,  // 3.696
            2.477302e-02f,  // 3.698
            2.472353e-02f,  // 3.700
            2.467413e-02f,  // 3.702
            2.462483e-02f,  // 3.704
            2.457563e-02f,  // 3.706
            2.452653e-02f,  // 3.708
            2.447752e-02f,  // 3.710
            2.442862e-02f,  // 3.712
            2.437981e-02f,  // 3.714
            2.433110e-02f,  // 3.716
            2.428248e-02f,  // 3.718
            2.423397e-02f,  // 3.720
            2.418555e-02f,  // 3.722
            2.413723e-02f,  // 3.724
            2.408900e-02f,  // 3.726
            2.404087e-02f,  // 3.728
            2.399284e-02f,  // 3.730
            2.394490e-02f,  // 3.732
            2.389706e-02f,  // 3.734
            2.384931e-02f,  // 3.736
            2.380166e-02f,  // 3.738
            2.375410e-02f,  // 3.740
            2.370664e-02f,  // 3.742
            2.365928e-02f,  // 3.744
            2.361201e-02f,  // 3.746
            2.356483e-02f,  // 3.748
            2.351775e-02f,  // 3.750
            2.347076e-02f,  // 3.752
            2.342386e-02f,  // 3.754
            2.337706e-02f,  // 3.756
            2.333035e-02f,  // 3.758
            2.328374e-02f,  // 3.760
            2.323722e-02f,  // 3.762
            2.319079e-02f,  // 3.764
            2.314446e-02f,  // 3.766
            2.309821e-02f,  // 3.768
            2.305206e-02f,  // 3.770
            2.300601e-02f,  // 3.772
            2.296004e-02f,  // 3.774
            2.291417e-02f,  // 3.776
            2.286838e-02f,  // 3.778
            2.282269e-02f,  // 3.780
            2.277709e-02f,  // 3.782
            2.273158e-02f,  // 3.784
            2.268617e-02f,  // 3.786
            2.264084e-02f,  // 3.788
            2.259560e-02f,  // 3.790
            2.255046e-02f,  // 3.792
            2.250540e-02f,  // 3.794
            2.246043e-02f,  // 3.796
            2.241556e-02f,  // 3.798
            2.237077e-02f,  // 3.800
            2.232608e-02f,  // 3.802
            2.228147e-02f,  // 3.804
            2.223695e-02f,  // 3.806
            2.219252e-02f,  // 3.808
            2.214818e-02f,  // 3.810
            2.210393e-02f,  // 3.812
            2.205976e-02f,  // 3.814
            2.201569e-02f,  // 3.816
            2.197170e-02f,  // 3.818
            2.192780e-02f,  // 3.820
            2.188399e-02f,  // 3.822
            2.184026e-02f,  // 3.824
            2.179663e-02f,  // 3.826
            2.175308e-02f,  // 3.828
            2.170962e-02f,  // 3.830
            2.166624e-02f,  // 3.832
            2.162295e-02f,  // 3.834
            2.157975e-02f,  // 3.836
            2.153663e-02f,  // 3.838
            2.149360e-02f,  // 3.840
            2.145066e-02f,  // 3.842
            2.140780e-02f,  // 3.844
            2.136503e-02f,  // 3.846
            2.132234e-02f,  // 3.848
            2.127974e-02f,  // 3.850
            2.123722e-02f,  // 3.852
            2.119479e-02f,  // 3.854
            2.115244e-02f,  // 3.856
            2.111018e-02f,  // 3.858
            2.106800e-02f,  // 3.860
            2.102591e-02f,  // 3.862
            2.098390e-02f,  // 3.864
            2.094197e-02f,  // 3.866
            2.090013e-02f,  // 3.868
            2.085837e-02f,  // 3.870
            2.081669e-02f,  // 3.872
            2.077510e-02f,  // 3.874
            2.073359e-02f,  // 3.876
            2.069217e-02f,  // 3.878
            2.065083e-02f,  // 3.880
            2.060956e-02f,  // 3.882
            2.056839e-02f,  // 3.884
            2.052729e-02f,  // 3.886
            2.048628e-02f,  // 3.888
            2.044535e-02f,  // 3.890
            2.040450e-02f,  // 3.892
            2.036373e-02f,  // 3.894
            2.032304e-02f,  // 3.896
            2.028244e-02f,  // 3.898
            2.024191e-02f,  // 3.900
            2.020147e-02f,  // 3.902
            2.016111e-02f,  // 3.904
            2.012082e-02f,  // 3.906
            2.008062e-02f,  // 3.908
            2.004050e-02f,  // 3.910
            2.000046e-02f,  // 3.912
            1.996050e-02f,  // 3.914
            1.992062e-02f,  // 3.916
            1.988082e-02f,  // 3.918
            1.984109e-02f,  // 3.920
            1.980145e-02f,  // 3.922
            1.976189e-02f,  // 3.924
            1.972240e-02f,  // 3.926
            1.968300e-02f,  // 3.928
            1.964367e-02f,  // 3.930
            1.960442e-02f,  // 3.932
            1.956525e-02f,  // 3.934
            1.952616e-02f,  // 3.936
            1.948715e-02f,  // 3.938
            1.944821e-02f,  // 3.940
            1.940936e-02f,  // 3.942
            1.937058e-02f,  // 3.944
            1.933187e-02f,  // 3.946
            1.929325e-02f,  // 3.948
            1.925470e-02f,  // 3.950
            1.921623e-02f,  // 3.952
            1.917784e-02f,  // 3.954
            1.913952e-02f,  // 3.956
            1.910128e-02f,  // 3.958
            1.906311e-02f,  // 3.960
            1.902503e-02f,  // 3.962
            1.898701e-02f,  // 3.964
            1.894908e-02f,  // 3.966
            1.891122e-02f,  // 3.968
            1.887343e-02f,  // 3.970
            1.883572e-02f,  // 3.972
            1.879809e-02f,  // 3.974
            1.876053e-02f,  // 3.976
            1.872305e-02f,  // 3.978
            1.868564e-02f,  // 3.980
            1.864831e-02f,  // 3.982
            1.861105e-02f,  // 3.984
            1.857386e-02f,  // 3.986
            1.853675e-02f,  // 3.988
            1.849971e-02f,  // 3.990
            1.846275e-02f,  // 3.992
            1.842586e-02f,  // 3.994
            1.838905e-02f,  // 3.996
            1.835231e-02f,  // 3.998
            1.831564e-02f,  // 4.000
            1.827904e-02f,  // 4.002
            1.824252e-02f,  // 4.004
            1.820607e-02f,  // 4.006
            1.816970e-02f,  // 4.008
            1.813340e-02f,  // 4.010
            1.809716e-02f,  // 4.012
            1.806101e-02f,  // 4.014
            1.802492e-02f,  // 4.016
            1.798891e-02f,  // 4.018
            1.795296e-02f,  // 4.020
            1.791709e-02f,  // 4.022
            1.788130e-02f,  // 4.024
            1.784557e-02f,  // 4.026
            1.780991e-02f,  // 4.028
            1.777433e-02f,  // 4.030
            1.773882e-02f,  // 4.032
            1.770337e-02f,  // 4.034
            1.766800e-02f,  // 4.036
            1.763270e-02f,  // 4.038
            1.759747e-02f,  // 4.040
            1.756231e-02f,  // 4.042
            1.752722e-02f,  // 4.044
            1.749220e-02f,  // 4.046
            1.745725e-02f,  // 4.048
            1.742237e-02f,  // 4.050
            1.738756e-02f,  // 4.052
            1.735282e-02f,  // 4.054
            1.731815e-02f,  // 4.056
            1.728355e-02f,  // 4.058
            1.724902e-02f,  // 4.060
            1.721456e-02f,  // 4.062
            1.718016e-02f,  // 4.064
            1.714583e-02f,  // 4.066
            1.711158e-02f,  // 4.068
            1.707739e-02f,  // 4.070
            1.704327e-02f,  // 4.072
            1.700922e-02f,  // 4.074
            1.697523e-02f,  // 4.076
            1.694131e-02f,  // 4.078
            1.690747e-02f,  // 4.080
            1.687368e-02f,  // 4.082
            1.683997e-02f,  // 4.084
            1.680632e-02f,  // 4.086
            1.677275e-02f,  // 4.088
            1.673923e-02f,  // 4.090
            1.670579e-02f,  // 4.092
            1.667241e-02f,  // 4.094
            1.663910e-02f,  // 4.096
            1.660585e-02f,  // 4.098
            1.657268e-02f,  // 4.100
            1.653956e-02f,  // 4.102
            1.650652e-02f,  // 4.104
            1.647354e-02f,  // 4.106
            1.644062e-02f,  // 4.108
            1.640777e-02f,  // 4.110
            1.637499e-02f,  // 4.112
            1.634227e-02f,  // 4.114
            1.630962e-02f,  // 4.116
            1.627704e-02f,  // 4.118
            1.624451e-02f,  // 4.120
            1.621206e-02f,  // 4.122
            1.617967e-02f,  // 4.124
            1.614734e-02f,  // 4.126
            1.611508e-02f,  // 4.128
            1.608288e-02f,  // 4.130
            1.605075e-02f,  // 4.132
            1.601868e-02f,  // 4.134
            1.598667e-02f,  // 4.136
            1.595473e-02f,  // 4.138
            1.592285e-02f,  // 4.140
            1.589104e-02f,  // 4.142
            1.585929e-02f,  // 4.144
            1.582760e-02f,  // 4.146
            1.579598e-02f,  // 4.148
            1.576442e-02f,  // 4.150
            1.573292e-02f,  // 4.152
            1.570148e-02f,  // 4.154
            1.567011e-02f,  // 4.156
            1.563880e-02f,  // 4.158
            1.560756e-02f,  // 4.160
            1.557637e-02f,  // 4.162
            1.554525e-02f,  // 4.164
            1.551419e-02f,  // 4.166
            1.548320e-02f,  // 4.168
            1.545226e-02f,  // 4.170
            1.542139e-02f,  // 4.172
            1.539057e-02f,  // 4.174
            1.535982e-02f,  // 4.176
            1.532914e-02f,  // 4.178
            1.529851e-02f,  // 4.180
            1.526794e-02f,  // 4.182
            1.523744e-02f,  // 4.184
            1.520699e-02f,  // 4.186
            1.517661e-02f,  // 4.188
            1.514628e-02f,  // 4.190
            1.511602e-02f,  // 4.192
            1.508582e-02f,  // 4.194
            1.505568e-02f,  // 4.196
            1.502560e-02f,  // 4.198
            1.499558e-02f,  // 4.200
            1.496562e-02f,  // 4.202
            1.493571e-02f,  // 4.204
            1.490587e-02f,  // 4.206
            1.487609e-02f,  // 4.208
            1.484637e-02f,  // 4.210
            1.481671e-02f,  // 4.212
            1.478710e-02f,  // 4.214
            1.475756e-02f,  // 4.216
            1.472807e-02f,  // 4.218
            1.469864e-02f,  // 4.220
            1.466928e-02f,  // 4.222
            1.463997e-02f,  // 4.224
            1.461072e-02f,  // 4.226
            1.458152e-02f,  // 4.228
            1.455239e-02f,  // 4.230
            1.452331e-02f,  // 4.232
            1.449430e-02f,  // 4.234
            1.446534e-02f,  // 4.236
            1.443644e-02f,  // 4.238
            1.440759e-02f,  // 4.240
            1.437881e-02f,  // 4.242
            1.435008e-02f,  // 4.244
            1.432141e-02f,  // 4.246
            1.429279e-02f,  // 4.248
            1.426423e-02f,  // 4.250
            1.423573e-02f,  // 4.252
            1.420729e-02f,  // 4.254
            1.417890e-02f,  // 4.256
            1.415058e-02f,  // 4.258
            1.412230e-02f,  // 4.260
            1.409409e-02f,  // 4.262
            1.406593e-02f,  // 4.264
            1.403782e-02f,  // 4.266
            1.400977e-02f,  // 4.268
            1.398178e-02f,  // 4.270
            1.395385e-02f,  // 4.272
            1.392597e-02f,  // 4.274
            1.389814e-02f,  // 4.276
            1.387038e-02f,  // 4.278
            1.384266e-02f,  // 4.280
            1.381500e-02f,  // 4.282
            1.378740e-02f,  // 4.284
            1.375985e-02f,  // 4.286
            1.373236e-02f,  // 4.288
            1.370493e-02f,  // 4.290
            1.367754e-02f,  // 4.292
            1.365022e-02f,  // 4.294
            1.362294e-02f,  // 4.296
            1.359572e-02f,  // 4.298
            1.356856e-02f,  // 4.300
            1.354145e-02f,  // 4.302
            1.351439e-02f,  // 4.304
            1.348739e-02f,  // 4.306
            1.346044e-02f,  // 4.308
            1.343355e-02f,  // 4.310
            1.340671e-02f,  // 4.312
            1.337992e-02f,  // 4.314
            1.335319e-02f,  // 4.316
            1.332651e-02f,  // 4.318
            1.329988e-02f,  // 4.320
            1.327331e-02f,  // 4.322
            1.324679e-02f,  // 4.324
            1.322032e-02f,  // 4.326
            1.319391e-02f,  // 4.328
            1.316755e-02f,  // 4.330
            1.314124e-02f,  // 4.332
            1.311498e-02f,  // 4.334
            1.308878e-02f,  // 4.336
            1.306263e-02f,  // 4.338
            1.303653e-02f,  // 4.340
            1.301048e-02f,  // 4.342
            1.298449e-02f,  // 4.344
            1.295854e-02f,  // 4.346
            1.293265e-02f,  // 4.348
            1.290681e-02f,  // 4.350
            1.288102e-02f,  // 4.352
            1.285529e-02f,  // 4.354
            1.282960e-02f,  // 4.356
            1.280397e-02f,  // 4.358
            1.277839e-02f,  // 4.360
            1.275286e-02f,  // 4.362
            1.272738e-02f,  // 4.364
            1.270195e-02f,  // 4.366
            1.267657e-02f,  // 4.368
            1.265124e-02f,  // 4.370
            1.262596e-02f,  // 4.372
            1.260074e-02f,  // 4.374
            1.257556e-02f,  // 4.376
            1.255043e-02f,  // 4.378
            1.252536e-02f,  // 4.380
            1.250033e-02f,  // 4.382
            1.247536e-02f,  // 4.384
            1.245043e-02f,  // 4.386
            1.242556e-02f,  // 4.388
            1.240073e-02f,  // 4.390
            1.237595e-02f,  // 4.392
            1.235123e-02f,  // 4.394
            1.232655e-02f,  // 4.396
            1.230192e-02f,  // 4.398
            1.227734e-02f,  // 4.400
            1.225281e-02f,  // 4.402
            1.222833e-02f,  // 4.404
            1.220390e-02f,  // 4.406
            1.217951e-02f,  // 4.408
            1.215518e-02f,  // 4.410
            1.213089e-02f,  // 4.412
            1.210665e-02f,  // 4.414
            1.208247e-02f,  // 4.416
            1.205832e-02f,  // 4.418
            1.203423e-02f,  // 4.420
            1.201019e-02f,  // 4.422
            1.198619e-02f,  // 4.424
            1.196224e-02f,  // 4.426
            1.193834e-02f,  // 4.428
            1.191449e-02f,  // 4.430
            1.189068e-02f,  // 4.432
            1.186693e-02f,  // 4.434
            1.184322e-02f,  // 4.436
            1.181955e-02f,  // 4.438
            1.179594e-02f,  // 4.440
            1.177237e-02f,  // 4.442
            1.174885e-02f,  // 4.444
            1.172537e-02f,  // 4.446
            1.170195e-02f,  // 4.448
            1.167857e-02f,  // 4.450
            1.165523e-02f,  // 4.452
            1.163195e-02f,  // 4.454
            1.160871e-02f,  // 4.456
            1.158551e-02f,  // 4.458
            1.156236e-02f,  // 4.460
            1.153926e-02f,  // 4.462
            1.151621e-02f,  // 4.464
            1.149320e-02f,  // 4.466
            1.147023e-02f,  // 4.468
            1.144732e-02f,  // 4.470
            1.142444e-02f,  // 4.472
            1.140162e-02f,  // 4.474
            1.137884e-02f,  // 4.476
            1.135610e-02f,  // 4.478
            1.133341e-02f,  // 4.480
            1.131077e-02f,  // 4.482
            1.128817e-02f,  // 4.484
            1.126562e-02f,  // 4.486
            1.124311e-02f,  // 4.488
            1.122064e-02f,  // 4.490
            1.119822e-02f,  // 4.492
            1.117585e-02f,  // 4.494
            1.115352e-02f,  // 4.496
            1.113124e-02f,  // 4.498
            1.110900e-02f,  // 4.500
            1.108680e-02f,  // 4.502
            1.106465e-02f,  // 4.504
            1.104254e-02f,  // 4.506
            1.102048e-02f,  // 4.508
            1.099846e-02f,  // 4.510
            1.097649e-02f,  // 4.512
            1.095455e-02f,  // 4.514
            1.093267e-02f,  // 4.516
            1.091082e-02f,  // 4.518
            1.088902e-02f,  // 4.520
            1.086727e-02f,  // 4.522
            1.084555e-02f,  // 4.524
            1.082389e-02f,  // 4.526
            1.080226e-02f,  // 4.528
            1.078068e-02f,  // 4.530
            1.075914e-02f,  // 4.532
            1.073764e-02f,  // 4.534
            1.071619e-02f,  // 4.536
            1.069477e-02f,  // 4.538
            1.067341e-02f,  // 4.540
            1.065208e-02f,  // 4.542
            1.063080e-02f,  // 4.544
            1.060956e-02f,  // 4.546
            1.058836e-02f,  // 4.548
            1.056720e-02f,  // 4.550
            1.054609e-02f,  // 4.552
            1.052502e-02f,  // 4.554
            1.050399e-02f,  // 4.556
            1.048300e-02f,  // 4.558
            1.046206e-02f,  // 4.560
            1.044116e-02f,  // 4.562
            1.042029e-02f,  // 4.564
            1.039947e-02f,  // 4.566
            1.037870e-02f,  // 4.568
            1.035796e-02f,  // 4.570
            1.033726e-02f,  // 4.572
            1.031661e-02f,  // 4.574
            1.029600e-02f,  // 4.576
            1.027543e-02f,  // 4.578
            1.025490e-02f,  // 4.580
            1.023441e-02f,  // 4.582
            1.021396e-02f,  // 4.584
            1.019355e-02f,  // 4.586
            1.017318e-02f,  // 4.588
            1.015286e-02f,  // 4.590
            1.013257e-02f,  // 4.592
            1.011233e-02f,  // 4.594
            1.009212e-02f,  // 4.596
            1.007196e-02f,  // 4.598
            1.005184e-02f,  // 4.600
            1.003175e-02f,  // 4.602
            1.001171e-02f,  // 4.604
            9.991705e-03f,  // 4.606
            9.971742e-03f,  // 4.608
            9.951818e-03f,  // 4.610
            9.931935e-03f,  // 4.612
            9.912091e-03f,  // 4.614
            9.892286e-03f,  // 4.616
            9.872521e-03f,  // 4.618
            9.852796e-03f,  // 4.620
            9.833110e-03f,  // 4.622
            9.813464e-03f,  // 4.624
            9.793856e-03f,  // 4.626
            9.774288e-03f,  // 4.628
            9.754759e-03f,  // 4.630
            9.735269e-03f,  // 4.632
            9.715818e-03f,  // 4.634
            9.696406e-03f,  // 4.636
            9.677032e-03f,  // 4.638
            9.657698e-03f,  // 4.640
            9.638402e-03f,  // 4.642
            9.619144e-03f,  // 4.644
            9.599925e-03f,  // 4.646
            9.580744e-03f,  // 4.648
            9.561602e-03f,  // 4.650
            9.542498e-03f,  // 4.652
            9.523432e-03f,  // 4.654
            9.504404e-03f,  // 4.656
            9.485414e-03f,  // 4.658
            9.466462e-03f,  // 4.660
            9.447548e-03f,  // 4.662
            9.428672e-03f,  // 4.664
            9.409834e-03f,  // 4.666
            9.391033e-03f,  // 4.668
            9.372270e-03f,  // 4.670
            9.353544e-03f,  // 4.672
            9.334855e-03f,  // 4.674
            9.316204e-03f,  // 4.676
            9.297590e-03f,  // 4.678
            9.279014e-03f,  // 4.680
            9.260474e-03f,  // 4.682
            9.241972e-03f,  // 4.684
            9.223506e-03f,  // 4.686
            9.205078e-03f,  // 4.688
            9.186686e-03f,  // 4.690
            9.168331e-03f,  // 4.692
            9.150013e-03f,  // 4.694
            9.131731e-03f,  // 4.696
            9.113486e-03f,  // 4.698
            9.095277e-03f,  // 4.700
            9.077105e-03f,  // 4.702
            9.058969e-03f,  // 4.704
            9.040869e-03f,  // 4.706
            9.022805e-03f,  // 4.708
            9.004778e-03f,  // 4.710
            8.986786e-03f,  // 4.712
            8.968830e-03f,  // 4.714
            8.950911e-03f,  // 4.716
            8.933027e-03f,  // 4.718
            8.915179e-03f,  // 4.720
            8.897366e-03f,  // 4.722
            8.879589e-03f,  // 4.724
            8.861848e-03f,  // 4.726
            8.844142e-03f,  // 4.728
            8.826471e-03f,  // 4.730
            8.808836e-03f,  // 4.732
            8.791236e-03f,  // 4.734
            8.773671e-03f,  // 4.736
            8.756141e-03f,  // 4.738
            8.738646e-03f,  // 4.740
            8.721186e-03f,  // 4.742
            8.703761e-03f,  // 4.744
            8.686371e-03f,  // 4.746
            8.669016e-03f,  // 4.748
            8.651695e-03f,  // 4.750
            8.634409e-03f,  // 4.752
            8.617158e-03f,  // 4.754
            8.599940e-03f,  // 4.756
            8.582758e-03f,  // 4.758
            8.565609e-03f,  // 4.760
            8.548495e-03f,  // 4.762
            8.531415e-03f,  // 4.764
            8.514370e-03f,  // 4.766
            8.497358e-03f,  // 4.768
            8.480380e-03f,  // 4.770
            8.463436e-03f,  // 4.772
            8.446526e-03f,  // 4.774
            8.429650e-03f,  // 4.776
            8.412808e-03f,  // 4.778
            8.395999e-03f,  // 4.780
            8.379224e-03f,  // 4.782
            8.362482e-03f,  // 4.784
            8.345774e-03f,  // 4.786
            8.329099e-03f,  // 4.788
            8.312457e-03f,  // 4.790
            8.295849e-03f,  // 4.792
            8.279274e-03f,  // 4.794
            8.262732e-03f,  // 4.796
            8.246223e-03f,  // 4.798
            8.229747e-03f,  // 4.800
            8.213304e-03f,  // 4.802
            8.196894e-03f,  // 4.804
            8.180516e-03f,  // 4.806
            8.164172e-03f,  // 4.808
            8.147860e-03f,  // 4.810
            8.131580e-03f,  // 4.812
            8.115333e-03f,  // 4.814
            8.099119e-03f,  // 4.816
            8.082937e-03f,  // 4.818
            8.066787e-03f,  // 4.820
            8.050670e-03f,  // 4.822
            8.034584e-03f,  // 4.824
            8.018531e-03f,  // 4.826
            8.002510e-03f,  // 4.828
            7.986521e-03f,  // 4.830
            7.970564e-03f,  // 4.832
            7.954639e-03f,  // 4.834
            7.938746e-03f,  // 4.836
            7.922884e-03f,  // 4.838
            7.907054e-03f,  // 4.840
            7.891256e-03f,  // 4.842
            7.875489e-03f,  // 4.844
            7.859754e-03f,  // 4.846
            7.844050e-03f,  // 4.848
            7.828378e-03f,  // 4.850
            7.812736e-03f,  // 4.852
            7.797127e-03f,  // 4.854
            7.781548e-03f,  // 4.856
            7.766000e-03f,  // 4.858
            7.750484e-03f,  // 4.860
            7.734998e-03f,  // 4.862
            7.719544e-03f,  // 4.864
            7.704120e-03f,  // 4.866
            7.688727e-03f,  // 4.868
            7.673365e-03f,  // 4.870
            7.658034e-03f,  // 4.872
            7.642733e-03f,  // 4.874
            7.627463e-03f,  // 4.876
            7.612223e-03f,  // 4.878
            7.597014e-03f,  // 4.880
            7.581835e-03f,  // 4.882
            7.566687e-03f,  // 4.884
            7.551568e-03f,  // 4.886
            7.536480e-03f,  // 4.888
            7.521422e-03f,  // 4.890
            7.506395e-03f,  // 4.892
            7.491397e-03f,  // 4.894
            7.476429e-03f,  // 4.896
            7.461491e-03f,  // 4.898
            7.446583e-03f,  // 4.900
            7.431705e-03f,  // 4.902
            7.416856e-03f,  // 4.904
            7.402037e-03f,  // 4.906
            7.387248e-03f,  // 4.908
            7.372488e-03f,  // 4.910
            7.357758e-03f,  // 4.912
            7.343057e-03f,  // 4.914
            7.328386e-03f,  // 4.916
            7.313744e-03f,  // 4.918
            7.299131e-03f,  // 4.920
            7.284547e-03f,  // 4.922
            7.269993e-03f,  // 4.924
            7.255467e-03f,  // 4.926
            7.240971e-03f,  // 4.928
            7.226503e-03f,  // 4.930
            7.212065e-03f,  // 4.932
            7.197655e-03f,  // 4.934
            7.183274e-03f,  // 4.936
            7.168922e-03f,  // 4.938
            7.154598e-03f,  // 4.940
            7.140303e-03f,  // 4.942
            7.126037e-03f,  // 4.944
            7.111799e-03f,  // 4.946
            7.097590e-03f,  // 4.948
            7.083409e-03f,  // 4.950
            7.069256e-03f,  // 4.952
            7.055132e-03f,  // 4.954
            7.041036e-03f,  // 4.956
            7.026968e-03f,  // 4.958
            7.012928e-03f,  // 4.960
            6.998916e-03f,  // 4.962
            6.984932e-03f,  // 4.964
            6.970976e-03f,  // 4.966
            6.957048e-03f,  // 4.968
            6.943148e-03f,  // 4.970
            6.929276e-03f,  // 4.972
            6.915431e-03f,  // 4.974
            6.901614e-03f,  // 4.976
            6.887824e-03f,  // 4.978
            6.874063e-03f,  // 4.980
            6.860328e-03f,  // 4.982
            6.846621e-03f,  // 4.984
            6.832942e-03f,  // 4.986
            6.819289e-03f,  // 4.988
            6.805664e-03f,  // 4.990
            6.792067e-03f,  // 4.992
            6.778496e-03f,  // 4.994
            6.764953e-03f,  // 4.996
            6.751436e-03f,  // 4.998
            6.737947e-03f,  // 5.000
            6.724485e-03f,  // 5.002
            6.711049e-03f,  // 5.004
            6.697640e-03f,  // 5.006
            6.684258e-03f,  // 5.008
            6.670903e-03f,  // 5.010
            6.657575e-03f,  // 5.012
            6.644273e-03f,  // 5.014
            6.630998e-03f,  // 5.016
            6.617749e-03f,  // 5.018
            6.604527e-03f,  // 5.020
            6.591331e-03f,  // 5.022
            6.578161e-03f,  // 5.024
            6.565018e-03f,  // 5.026
            6.551901e-03f,  // 5.028
            6.538811e-03f,  // 5.030
            6.525746e-03f,  // 5.032
            6.512708e-03f,  // 5.034
            6.499695e-03f,  // 5.036
            6.486709e-03f,  // 5.038
            6.473748e-03f,  // 5.040
            6.460814e-03f,  // 5.042
            6.447905e-03f,  // 5.044
            6.435022e-03f,  // 5.046
            6.422165e-03f,  // 5.048
            6.409333e-03f,  // 5.050
            6.396528e-03f,  // 5.052
            6.383747e-03f,  // 5.054
            6.370993e-03f,  // 5.056
            6.358263e-03f,  // 5.058
            6.345560e-03f,  // 5.060
            6.332881e-03f,  // 5.062
            6.320228e-03f,  // 5.064
            6.307600e-03f,  // 5.066
            6.294998e-03f,  // 5.068
            6.282420e-03f,  // 5.070
            6.269868e-03f,  // 5.072
            6.257341e-03f,  // 5.074
            6.244838e-03f,  // 5.076
            6.232361e-03f,  // 5.078
            6.219909e-03f,  // 5.080
            6.207482e-03f,  // 5.082
            6.195079e-03f,  // 5.084
            6.182701e-03f,  // 5.086
            6.170348e-03f,  // 5.088
            6.158020e-03f,  // 5.090
            6.145716e-03f,  // 5.092
            6.133437e-03f,  // 5.094
            6.121182e-03f,  // 5.096
            6.108952e-03f,  // 5.098
            6.096747e-03f,  // 5.100
            6.084565e-03f,  // 5.102
            6.072408e-03f,  // 5.104
            6.060276e-03f,  // 5.106
            6.048167e-03f,  // 5.108
            6.036083e-03f,  // 5.110
            6.024023e-03f,  // 5.112
            6.011987e-03f,  // 5.114
            5.999975e-03f,  // 5.116
            5.987987e-03f,  // 5.118
            5.976023e-03f,  // 5.120
            5.964083e-03f,  // 5.122
            5.952167e-03f,  // 5.124
            5.940274e-03f,  // 5.126
            5.928405e-03f,  // 5.128
            5.916560e-03f,  // 5.130
            5.904739e-03f,  // 5.132
            5.892942e-03f,  // 5.134
            5.881167e-03f,  // 5.136
            5.869417e-03f,  // 5.138
            5.857690e-03f,  // 5.140
            5.845986e-03f,  // 5.142
            5.834306e-03f,  // 5.144
            5.822649e-03f,  // 5.146
            5.811015e-03f,  // 5.148
            5.799405e-03f,  // 5.150
            5.787818e-03f,  // 5.152
            5.776253e-03f,  // 5.154
            5.764712e-03f,  // 5.156
            5.753195e-03f,  // 5.158
            5.741700e-03f,  // 5.160
            5.730228e-03f,  // 5.162
            5.718779e-03f,  // 5.164
            5.707353e-03f,  // 5.166
            5.695949e-03f,  // 5.168
            5.684569e-03f,  // 5.170
            5.673211e-03f,  // 5.172
            5.661876e-03f,  // 5.174
            5.650564e-03f,  // 5.176
            5.639274e-03f,  // 5.178
            5.628006e-03f,  // 5.180
            5.616762e-03f,  // 5.182
            5.605539e-03f,  // 5.184
            5.594339e-03f,  // 5.186
            5.583162e-03f,  // 5.188
            5.572007e-03f,  // 5.190
            5.560874e-03f,  // 5.192
            5.549763e-03f,  // 5.194
            5.538675e-03f,  // 5.196
            5.527609e-03f,  // 5.198
            5.516564e-03f,  // 5.200
            5.505542e-03f,  // 5.202
            5.494542e-03f,  // 5.204
            5.483564e-03f,  // 5.206
            5.472608e-03f,  // 5.208
            5.461674e-03f,  // 5.210
            5.450761e-03f,  // 5.212
            5.439871e-03f,  // 5.214
            5.429002e-03f,  // 5.216
            5.418155e-03f,  // 5.218
            5.407329e-03f,  // 5.220
            5.396525e-03f,  // 5.222
            5.385743e-03f,  // 5.224
            5.374982e-03f,  // 5.226
            5.364243e-03f,  // 5.228
            5.353525e-03f,  // 5.230
            5.342829e-03f,  // 5.232
            5.332154e-03f,  // 5.234
            5.321500e-03f,  // 5.236
            5.310868e-03f,  // 5.238
            5.300257e-03f,  // 5.240
            5.289667e-03f,  // 5.242
            5.279098e-03f,  // 5.244
            5.268551e-03f,  // 5.246
            5.258024e-03f,  // 5.248
            5.247518e-03f,  // 5.250
            5.237034e-03f,  // 5.252
            5.226570e-03f,  // 5.254
            5.216128e-03f,  // 5.256
            5.205706e-03f,  // 5.258
            5.195305e-03f,  // 5.260
            5.184924e-03f,  // 5.262
            5.174565e-03f,  // 5.264
            5.164226e-03f,  // 5.266
            5.153908e-03f,  // 5.268
            5.143611e-03f,  // 5.270
            5.133334e-03f,  // 5.272
            5.123077e-03f,  // 5.274
            5.112841e-03f,  // 5.276
            5.102626e-03f,  // 5.278
            5.092431e-03f,  // 5.280
            5.082256e-03f,  // 5.282
            5.072102e-03f,  // 5.284
            5.061968e-03f,  // 5.286
            5.051854e-03f,  // 5.288
            5.041760e-03f,  // 5.290
            5.031687e-03f,  // 5.292
            5.021633e-03f,  // 5.294
            5.011600e-03f,  // 5.296
            5.001587e-03f,  // 5.298
            4.991594e-03f,  // 5.300
            4.981621e-03f,  // 5.302
            4.971667e-03f,  // 5.304
            4.961734e-03f,  // 5.306
            4.951820e-03f,  // 5.308
            4.941927e-03f,  // 5.310
            4.932053e-03f,  // 5.312
            4.922198e-03f,  // 5.314
            4.912364e-03f,  // 5.316
            4.902549e-03f,  // 5.318
            4.892754e-03f,  // 5.320
            4.882978e-03f,  // 5.322
            4.873222e-03f,  // 5.324
            4.863485e-03f,  // 5.326
            4.853768e-03f,  // 5.328
            4.844070e-03f,  // 5.330
            4.834392e-03f,  // 5.332
            4.824732e-03f,  // 5.334
            4.815093e-03f,  // 5.336
            4.805472e-03f,  // 5.338
            4.795871e-03f,  // 5.340
            4.786289e-03f,  // 5.342
            4.776726e-03f,  // 5.344
            4.767182e-03f,  // 5.346
            4.757657e-03f,  // 5.348
            4.748151e-03f,  // 5.350
            4.738664e-03f,  // 5.352
            4.729196e-03f,  // 5.354
            4.719747e-03f,  // 5.356
            4.710317e-03f,  // 5.358
            4.700906e-03f,  // 5.360
            4.691514e-03f,  // 5.362
            4.682140e-03f,  // 5.364
            4.672785e-03f,  // 5.366
            4.663449e-03f,  // 5.368
            4.654131e-03f,  // 5.370
            4.644832e-03f,  // 5.372
            4.635552e-03f,  // 5.374
            4.626290e-03f,  // 5.376
            4.617047e-03f,  // 5.378
            4.607822e-03f,  // 5.380
            4.598615e-03f,  // 5.382
            4.589427e-03f,  // 5.384
            4.580258e-03f,  // 5.386
            4.571106e-03f,  // 5.388
            4.561973e-03f,  // 5.390
            4.552859e-03f,  // 5.392
            4.543762e-03f,  // 5.394
            4.534683e-03f,  // 5.396
            4.525623e-03f,  // 5.398
            4.516581e-03f,  // 5.400
            4.507557e-03f,  // 5.402
            4.498551e-03f,  // 5.404
            4.489563e-03f,  // 5.406
            4.480592e-03f,  // 5.408
            4.471640e-03f,  // 5.410
            4.462706e-03f,  // 5.412
            4.453789e-03f,  // 5.414
            4.444891e-03f,  // 5.416
            4.436010e-03f,  // 5.418
            4.427147e-03f,  // 5.420
            4.418301e-03f,  // 5.422
            4.409473e-03f,  // 5.424
            4.400663e-03f,  // 5.426
            4.391871e-03f,  // 5.428
            4.383096e-03f,  // 5.430
            4.374338e-03f,  // 5.432
            4.365598e-03f,  // 5.434
            4.356876e-03f,  // 5.436
            4.348171e-03f,  // 5.438
            4.339483e-03f,  // 5.440
            4.330813e-03f,  // 5.442
            4.322160e-03f,  // 5.444
            4.313524e-03f,  // 5.446
            4.304906e-03f,  // 5.448
            4.296305e-03f,  // 5.450
            4.287721e-03f,  // 5.452
            4.279154e-03f,  // 5.454
            4.270604e-03f,  // 5.456
            4.262071e-03f,  // 5.458
            4.253556e-03f,  // 5.460
            4.245057e-03f,  // 5.462
            4.236576e-03f,  // 5.464
            4.228111e-03f,  // 5.466
            4.219663e-03f,  // 5.468
            4.211232e-03f,  // 5.470
            4.202818e-03f,  // 5.472
            4.194421e-03f,  // 5.474
            4.186040e-03f,  // 5.476
            4.177677e-03f,  // 5.478
            4.169330e-03f,  // 5.480
            4.160999e-03f,  // 5.482
            4.152686e-03f,  // 5.484
            4.144389e-03f,  // 5.486
            4.136108e-03f,  // 5.488
            4.127844e-03f,  // 5.490
            4.119597e-03f,  // 5.492
            4.111366e-03f,  // 5.494
            4.103151e-03f,  // 5.496
            4.094953e-03f,  // 5.498
            4.086771e-03f,  // 5.500
            4.078606e-03f,  // 5.502
            4.070457e-03f,  // 5.504
            4.062324e-03f,  // 5.506
            4.054208e-03f,  // 5.508
            4.046107e-03f,  // 5.510
            4.038023e-03f,  // 5.512
            4.029955e-03f,  // 5.514
            4.021903e-03f,  // 5.516
            4.013868e-03f,  // 5.518
            4.005848e-03f,  // 5.520
            3.997844e-03f,  // 5.522
            3.989857e-03f,  // 5.524
            3.981885e-03f,  // 5.526
            3.973929e-03f,  // 5.528
            3.965989e-03f,  // 5.530
            3.958065e-03f,  // 5.532
            3.950157e-03f,  // 5.534
            3.942264e-03f,  // 5.536
            3.934388e-03f,  // 5.538
            3.926527e-03f,  // 5.540
            3.918682e-03f,  // 5.542
            3.910852e-03f,  // 5.544
            3.903038e-03f,  // 5.546
            3.895240e-03f,  // 5.548
            3.887457e-03f,  // 5.550
            3.879690e-03f,  // 5.552
            3.871938e-03f,  // 5.554
            3.864202e-03f,  // 5.556
            3.856482e-03f,  // 5.558
            3.848776e-03f,  // 5.560
            3.841087e-03f,  // 5.562
            3.833412e-03f,  // 5.564
            3.825753e-03f,  // 5.566
            3.818109e-03f,  // 5.568
            3.810480e-03f,  // 5.570
            3.802867e-03f,  // 5.572
            3.795269e-03f,  // 5.574
            3.787686e-03f,  // 5.576
            3.780118e-03f,  // 5.578
            3.772566e-03f,  // 5.580
            3.765028e-03f,  // 5.582
            3.757505e-03f,  // 5.584
            3.749998e-03f,  // 5.586
            3.742505e-03f,  // 5.588
            3.735028e-03f,  // 5.590
            3.727565e-03f,  // 5.592
            3.720118e-03f,  // 5.594
            3.712685e-03f,  // 5.596
            3.705267e-03f,  // 5.598
            3.697864e-03f,  // 5.600
            3.690475e-03f,  // 5.602
            3.683102e-03f,  // 5.604
            3.675743e-03f,  // 5.606
            3.668399e-03f,  // 5.608
            3.661069e-03f,  // 5.610
            3.653755e-03f,  // 5.612
            3.646454e-03f,  // 5.614
            3.639169e-03f,  // 5.616
            3.631898e-03f,  // 5.618
            3.624641e-03f,  // 5.620
            3.617399e-03f,  // 5.622
            3.610172e-03f,  // 5.624
            3.602958e-03f,  // 5.626
            3.595760e-03f,  // 5.628
            3.588575e-03f,  // 5.630
            3.581405e-03f,  // 5.632
            3.574250e-03f,  // 5.634
            3.567108e-03f,  // 5.636
            3.559981e-03f,  // 5.638
            3.552868e-03f,  // 5.640
            3.545770e-03f,  // 5.642
            3.538685e-03f,  // 5.644
            3.531615e-03f,  // 5.646
            3.524559e-03f,  // 5.648
            3.517517e-03f,  // 5.650
            3.510489e-03f,  // 5.652
            3.503475e-03f,  // 5.654
            3.496475e-03f,  // 5.656
            3.489489e-03f,  // 5.658
            3.482517e-03f,  // 5.660
            3.475559e-03f,  // 5.662
            3.468615e-03f,  // 5.664
            3.461684e-03f,  // 5.666
            3.454768e-03f,  // 5.668
            3.447865e-03f,  // 5.670
            3.440976e-03f,  // 5.672
            3.434101e-03f,  // 5.674
            3.427240e-03f,  // 5.676
            3.420392e-03f,  // 5.678
            3.413558e-03f,  // 5.680
            3.406738e-03f,  // 5.682
            3.399931e-03f,  // 5.684
            3.393138e-03f,  // 5.686
            3.386359e-03f,  // 5.688
            3.379593e-03f,  // 5.690
            3.372841e-03f,  // 5.692
            3.366102e-03f,  // 5.694
            3.359376e-03f,  // 5.696
            3.352664e-03f,  // 5.698
            3.345965e-03f,  // 5.700
            3.339280e-03f,  // 5.702
            3.332608e-03f,  // 5.704
            3.325950e-03f,  // 5.706
            3.319305e-03f,  // 5.708
            3.312673e-03f,  // 5.710
            3.306054e-03f,  // 5.712
            3.299448e-03f,  // 5.714
            3.292856e-03f,  // 5.716
            3.286277e-03f,  // 5.718
            3.279711e-03f,  // 5.720
            3.273158e-03f,  // 5.722
            3.266618e-03f,  // 5.724
            3.260092e-03f,  // 5.726
            3.253578e-03f,  // 5.728
            3.247077e-03f,  // 5.730
            3.240590e-03f,  // 5.732
            3.234115e-03f,  // 5.734
            3.227653e-03f,  // 5.736
            3.221204e-03f,  // 5.738
            3.214768e-03f,  // 5.740
            3.208345e-03f,  // 5.742
            3.201935e-03f,  // 5.744
            3.195537e-03f,  // 5.746
            3.189153e-03f,  // 5.748
            3.182781e-03f,  // 5.750
            3.176422e-03f,  // 5.752
            3.170075e-03f,  // 5.754
            3.163741e-03f,  // 5.756
            3.157420e-03f,  // 5.758
            3.151112e-03f,  // 5.760
            3.144816e-03f,  // 5.762
            3.138532e-03f,  // 5.764
            3.132262e-03f,  // 5.766
            3.126003e-03f,  // 5.768
            3.119758e-03f,  // 5.770
            3.113524e-03f,  // 5.772
            3.107303e-03f,  // 5.774
            3.101095e-03f,  // 5.776
            3.094899e-03f,  // 5.778
            3.088715e-03f,  // 5.780
            3.082544e-03f,  // 5.782
            3.076385e-03f,  // 5.784
            3.070239e-03f,  // 5.786
            3.064104e-03f,  // 5.788
            3.057982e-03f,  // 5.790
            3.051872e-03f,  // 5.792
            3.045775e-03f,  // 5.794
            3.039689e-03f,  // 5.796
            3.033616e-03f,  // 5.798
            3.027555e-03f,  // 5.800
            3.021506e-03f,  // 5.802
            3.015469e-03f,  // 5.804
            3.009444e-03f,  // 5.806
            3.003431e-03f,  // 5.808
            2.997430e-03f,  // 5.810
            2.991441e-03f,  // 5.812
            2.985464e-03f,  // 5.814
            2.979499e-03f,  // 5.816
            2.973546e-03f,  // 5.818
            2.967605e-03f,  // 5.820
            2.961676e-03f,  // 5.822
            2.955758e-03f,  // 5.824
            2.949853e-03f,  // 5.826
            2.943959e-03f,  // 5.828
            2.938077e-03f,  // 5.830
            2.932207e-03f,  // 5.832
            2.926348e-03f,  // 5.834
            2.920501e-03f,  // 5.836
            2.914666e-03f,  // 5.838
            2.908843e-03f,  // 5.840
            2.903031e-03f,  // 5.842
            2.897230e-03f,  // 5.844
            2.891442e-03f,  // 5.846
            2.885665e-03f,  // 5.848
            2.879899e-03f,  // 5.850
            2.874145e-03f,  // 5.852
            2.868403e-03f,  // 5.854
            2.862671e-03f,  // 5.856
            2.856952e-03f,  // 5.858
            2.851244e-03f,  // 5.860
            2.845547e-03f,  // 5.862
            2.839861e-03f,  // 5.864
            2.834187e-03f,  // 5.866
            2.828525e-03f,  // 5.868
            2.822873e-03f,  // 5.870
            2.817233e-03f,  // 5.872
            2.811604e-03f,  // 5.874
            2.805987e-03f,  // 5.876
            2.800380e-03f,  // 5.878
            2.794785e-03f,  // 5.880
            2.789201e-03f,  // 5.882
            2.783628e-03f,  // 5.884
            2.778067e-03f,  // 5.886
            2.772516e-03f,  // 5.888
            2.766977e-03f,  // 5.890
            2.761448e-03f,  // 5.892
            2.755931e-03f,  // 5.894
            2.750425e-03f,  // 5.896
            2.744929e-03f,  // 5.898
            2.739445e-03f,  // 5.900
            2.733971e-03f,  // 5.902
            2.728509e-03f,  // 5.904
            2.723057e-03f,  // 5.906
            2.717617e-03f,  // 5.908
            2.712187e-03f,  // 5.910
            2.706768e-03f,  // 5.912
            2.701360e-03f,  // 5.914
            2.695962e-03f,  // 5.916
            2.690576e-03f,  // 5.918
            2.685200e-03f,  // 5.920
            2.679835e-03f,  // 5.922
            2.674481e-03f,  // 5.924
            2.669137e-03f,  // 5.926
            2.663804e-03f,  // 5.928
            2.658482e-03f,  // 5.930
            2.653170e-03f,  // 5.932
            2.647869e-03f,  // 5.934
            2.642579e-03f,  // 5.936
            2.637299e-03f,  // 5.938
            2.632030e-03f,  // 5.940
            2.626771e-03f,  // 5.942
            2.621523e-03f,  // 5.944
            2.616285e-03f,  // 5.946
            2.611057e-03f,  // 5.948
            2.605841e-03f,  // 5.950
            2.600634e-03f,  // 5.952
            2.595438e-03f,  // 5.954
            2.590252e-03f,  // 5.956
            2.585077e-03f,  // 5.958
            2.579912e-03f,  // 5.960
            2.574757e-03f,  // 5.962
            2.569613e-03f,  // 5.964
            2.564479e-03f,  // 5.966
            2.559355e-03f,  // 5.968
            2.554241e-03f,  // 5.970
            2.549138e-03f,  // 5.972
            2.544045e-03f,  // 5.974
            2.538962e-03f,  // 5.976
            2.533889e-03f,  // 5.978
            2.528826e-03f,  // 5.980
            2.523774e-03f,  // 5.982
            2.518731e-03f,  // 5.984
            2.513699e-03f,  // 5.986
            2.508676e-03f,  // 5.988
            2.503664e-03f,  // 5.990
            2.498662e-03f,  // 5.992
            2.493669e-03f,  // 5.994
            2.488687e-03f,  // 5.996
            2.483715e-03f,  // 5.998
            2.478752e-03f,  // 6.000
            2.473800e-03f,  // 6.002
            2.468857e-03f,  // 6.004
            2.463924e-03f,  // 6.006
            2.459001e-03f,  // 6.008
            2.454088e-03f,  // 6.010
            2.449185e-03f,  // 6.012
            2.444291e-03f,  // 6.014
            2.439408e-03f,  // 6.016
            2.434534e-03f,  // 6.018
            2.429670e-03f,  // 6.020
            2.424815e-03f,  // 6.022
            2.419970e-03f,  // 6.024
            2.415135e-03f,  // 6.026
            2.410310e-03f,  // 6.028
            2.405494e-03f,  // 6.030
            2.400688e-03f,  // 6.032
            2.395891e-03f,  // 6.034
            2.391104e-03f,  // 6.036
            2.386327e-03f,  // 6.038
            2.381559e-03f,  // 6.040
            2.376801e-03f,  // 6.042
            2.372052e-03f,  // 6.044
            2.367312e-03f,  // 6.046
            2.362582e-03f,  // 6.048
            2.357862e-03f,  // 6.050
            2.353151e-03f,  // 6.052
            2.348449e-03f,  // 6.054
            2.343757e-03f,  // 6.056
            2.339074e-03f,  // 6.058
            2.334401e-03f,  // 6.060
            2.329737e-03f,  // 6.062
            2.325082e-03f,  // 6.064
            2.320436e-03f,  // 6.066
            2.315800e-03f,  // 6.068
            2.311173e-03f,  // 6.070
            2.306555e-03f,  // 6.072
            2.301947e-03f,  // 6.074
            2.297348e-03f,  // 6.076
            2.292758e-03f,  // 6.078
            2.288177e-03f,  // 6.080
            2.283605e-03f,  // 6.082
            2.279042e-03f,  // 6.084
            2.274489e-03f,  // 6.086
            2.269944e-03f,  // 6.088
            2.265409e-03f,  // 6.090
            2.260883e-03f,  // 6.092
            2.256365e-03f,  // 6.094
            2.251857e-03f,  // 6.096
            2.247358e-03f,  // 6.098
            2.242868e-03f,  // 6.100
            2.238386e-03f,  // 6.102
            2.233914e-03f,  // 6.104
            2.229451e-03f,  // 6.106
            2.224996e-03f,  // 6.108
            2.220551e-03f,  // 6.110
            2.216114e-03f,  // 6.112
            2.211686e-03f,  // 6.114
            2.207267e-03f,  // 6.116
            2.202857e-03f,  // 6.118
            2.198456e-03f,  // 6.120
            2.194063e-03f,  // 6.122
            2.189680e-03f,  // 6.124
            2.185305e-03f,  // 6.126
            2.180938e-03f,  // 6.128
            2.176581e-03f,  // 6.130
            2.172232e-03f,  // 6.132
            2.167892e-03f,  // 6.134
            2.163561e-03f,  // 6.136
            2.159238e-03f,  // 6.138
            2.154924e-03f,  // 6.140
            2.150618e-03f,  // 6.142
            2.146321e-03f,  // 6.144
            2.142033e-03f,  // 6.146
            2.137753e-03f,  // 6.148
            2.133482e-03f,  // 6.150
            2.129219e-03f,  // 6.152
            2.124965e-03f,  // 6.154
            2.120719e-03f,  // 6.156
            2.116482e-03f,  // 6.158
            2.112253e-03f,  // 6.160
            2.108033e-03f,  // 6.162
            2.103821e-03f,  // 6.164
            2.099618e-03f,  // 6.166
            2.095423e-03f,  // 6.168
            2.091236e-03f,  // 6.170
            2.087058e-03f,  // 6.172
            2.082888e-03f,  // 6.174
            2.078726e-03f,  // 6.176
            2.074573e-03f,  // 6.178
            2.070428e-03f,  // 6.180
            2.066291e-03f,  // 6.182
            2.062163e-03f,  // 6.184
            2.058042e-03f,  // 6.186
            2.053931e-03f,  // 6.188
            2.049827e-03f,  // 6.190
            2.045731e-03f,  // 6.192
            2.041644e-03f,  // 6.194
            2.037565e-03f,  // 6.196
            2.033494e-03f,  // 6.198
            2.029431e-03f,  // 6.200
            2.025376e-03f,  // 6.202
            2.021329e-03f,  // 6.204
            2.017291e-03f,  // 6.206
            2.013260e-03f,  // 6.208
            2.009237e-03f,  // 6.210
            2.005223e-03f,  // 6.212
            2.001217e-03f,  // 6.214
            1.997218e-03f,  // 6.216
            1.993228e-03f,  // 6.218
            1.989245e-03f,  // 6.220
            1.985271e-03f,  // 6.222
            1.981304e-03f,  // 6.224
            1.977345e-03f,  // 6.226
            1.973395e-03f,  // 6.228
            1.969452e-03f,  // 6.230
            1.965517e-03f,  // 6.232
            1.961590e-03f,  // 6.234
            1.957671e-03f,  // 6.236
            1.953759e-03f,  // 6.238
            1.949856e-03f,  // 6.240
            1.945960e-03f,  // 6.242
            1.942072e-03f,  // 6.244
            1.938191e-03f,  // 6.246
            1.934319e-03f,  // 6.248
            1.930454e-03f,  // 6.250
            1.926597e-03f,  // 6.252
            1.922748e-03f,  // 6.254
            1.918906e-03f,  // 6.256
            1.915072e-03f,  // 6.258
            1.911246e-03f,  // 6.260
            1.907427e-03f,  // 6.262
            1.903616e-03f,  // 6.264
            1.899813e-03f,  // 6.266
            1.896017e-03f,  // 6.268
            1.892229e-03f,  // 6.270
            1.888448e-03f,  // 6.272
            1.884675e-03f,  // 6.274
            1.880909e-03f,  // 6.276
            1.877151e-03f,  // 6.278
            1.873401e-03f,  // 6.280
            1.869658e-03f,  // 6.282
            1.865922e-03f,  // 6.284
            1.862194e-03f,  // 6.286
            1.858473e-03f,  // 6.288
            1.854760e-03f,  // 6.290
            1.851054e-03f,  // 6.292
            1.847356e-03f,  // 6.294
            1.843665e-03f,  // 6.296
            1.839981e-03f,  // 6.298
            1.836305e-03f,  // 6.300
            1.832636e-03f,  // 6.302
            1.828974e-03f,  // 6.304
            1.825320e-03f,  // 6.306
            1.821673e-03f,  // 6.308
            1.818033e-03f,  // 6.310
            1.814401e-03f,  // 6.312
            1.810776e-03f,  // 6.314
            1.807158e-03f,  // 6.316
            1.803547e-03f,  // 6.318
            1.799944e-03f,  // 6.320
            1.796347e-03f,  // 6.322
            1.792758e-03f,  // 6.324
            1.789176e-03f,  // 6.326
            1.785601e-03f,  // 6.328
            1.782034e-03f,  // 6.330
            1.778473e-03f,  // 6.332
            1.774920e-03f,  // 6.334
            1.771374e-03f,  // 6.336
            1.767834e-03f,  // 6.338
            1.764302e-03f,  // 6.340
            1.760777e-03f,  // 6.342
            1.757259e-03f,  // 6.344
            1.753748e-03f,  // 6.346
            1.750244e-03f,  // 6.348
            1.746747e-03f,  // 6.350
            1.743257e-03f,  // 6.352
            1.739774e-03f,  // 6.354
            1.736298e-03f,  // 6.356
            1.732829e-03f,  // 6.358
            1.729367e-03f,  // 6.360
            1.725911e-03f,  // 6.362
            1.722463e-03f,  // 6.364
            1.719022e-03f,  // 6.366
            1.715587e-03f,  // 6.368
            1.712159e-03f,  // 6.370
            1.708738e-03f,  // 6.372
            1.705324e-03f,  // 6.374
            1.701917e-03f,  // 6.376
            1.698517e-03f,  // 6.378
            1.695123e-03f,  // 6.380
            1.691736e-03f,  // 6.382
            1.688356e-03f,  // 6.384
            1.684983e-03f,  // 6.386
            1.681616e-03f,  // 6.388
            1.678256e-03f,  // 6.390
            1.674903e-03f,  // 6.392
            1.671557e-03f,  // 6.394
            1.668217e-03f,  // 6.396
            1.664884e-03f,  // 6.398
            1.661557e-03f,  // 6.400
            1.658237e-03f,  // 6.402
            1.654924e-03f,  // 6.404
            1.651618e-03f,  // 6.406
            1.648318e-03f,  // 6.408
            1.645025e-03f,  // 6.410
            1.641738e-03f,  // 6.412
            1.638458e-03f,  // 6.414
            1.635184e-03f,  // 6.416
            1.631917e-03f,  // 6.418
            1.628656e-03f,  // 6.420
            1.625402e-03f,  // 6.422
            1.622155e-03f,  // 6.424
            1.618914e-03f,  // 6.426
            1.615679e-03f,  // 6.428
            1.612451e-03f,  // 6.430
            1.609229e-03f,  // 6.432
            1.606014e-03f,  // 6.434
            1.602805e-03f,  // 6.436
            1.599603e-03f,  // 6.438
            1.596407e-03f,  // 6.440
            1.593217e-03f,  // 6.442
            1.590034e-03f,  // 6.444
            1.586857e-03f,  // 6.446
            1.583686e-03f,  // 6.448
            1.580522e-03f,  // 6.450
            1.577364e-03f,  // 6.452
            1.574213e-03f,  // 6.454
            1.571067e-03f,  // 6.456
            1.567928e-03f,  // 6.458
            1.564796e-03f,  // 6.460
            1.561669e-03f,  // 6.462
            1.558549e-03f,  // 6.464
            1.555435e-03f,  // 6.466
            1.552327e-03f,  // 6.468
            1.549226e-03f,  // 6.470
            1.546130e-03f,  // 6.472
            1.543041e-03f,  // 6.474
            1.539958e-03f,  // 6.476
            1.536881e-03f,  // 6.478
            1.533811e-03f,  // 6.480
            1.530746e-03f,  // 6.482
            1.527688e-03f,  // 6.484
            1.524635e-03f,  // 6.486
            1.521589e-03f,  // 6.488
            1.518549e-03f,  // 6.490
            1.515515e-03f,  // 6.492
            1.512487e-03f,  // 6.494
            1.509465e-03f,  // 6.496
            1.506449e-03f,  // 6.498
            1.503439e-03f,  // 6.500
            1.500435e-03f,  // 6.502
            1.497437e-03f,  // 6.504
            1.494446e-03f,  // 6.506
            1.491460e-03f,  // 6.508
            1.488480e-03f,  // 6.510
            1.485506e-03f,  // 6.512
            1.482538e-03f,  // 6.514
            1.479576e-03f,  // 6.516
            1.476619e-03f,  // 6.518
            1.473669e-03f,  // 6.520
            1.470725e-03f,  // 6.522
            1.467786e-03f,  // 6.524
            1.464854e-03f,  // 6.526
            1.461927e-03f,  // 6.528
            1.459006e-03f,  // 6.530
            1.456091e-03f,  // 6.532
            1.453181e-03f,  // 6.534
            1.450278e-03f,  // 6.536
            1.447380e-03f,  // 6.538
            1.444488e-03f,  // 6.540
            1.441602e-03f,  // 6.542
            1.438722e-03f,  // 6.544
            1.435848e-03f,  // 6.546
            1.432979e-03f,  // 6.548
            1.430116e-03f,  // 6.550
            1.427258e-03f,  // 6.552
            1.424407e-03f,  // 6.554
            1.421561e-03f,  // 6.556
            1.418720e-03f,  // 6.558
            1.415886e-03f,  // 6.560
            1.413057e-03f,  // 6.562
            1.410233e-03f,  // 6.564
            1.407416e-03f,  // 6.566
            1.404604e-03f,  // 6.568
            1.401797e-03f,  // 6.570
            1.398997e-03f,  // 6.572
            1.396201e-03f,  // 6.574
            1.393412e-03f,  // 6.576
            1.390628e-03f,  // 6.578
            1.387849e-03f,  // 6.580
            1.385076e-03f,  // 6.582
            1.382309e-03f,  // 6.584
            1.379547e-03f,  // 6.586
            1.376791e-03f,  // 6.588
            1.374040e-03f,  // 6.590
            1.371295e-03f,  // 6.592
            1.368555e-03f,  // 6.594
            1.365820e-03f,  // 6.596
            1.363091e-03f,  // 6.598
            1.360368e-03f,  // 6.600
            1.357650e-03f,  // 6.602
            1.354937e-03f,  // 6.604
            1.352230e-03f,  // 6.606
            1.349529e-03f,  // 6.608
            1.346832e-03f,  // 6.610
            1.344141e-03f,  // 6.612
            1.341456e-03f,  // 6.614
            1.338775e-03f,  // 6.616
            1.336100e-03f,  // 6.618
            1.333431e-03f,  // 6.620
            1.330767e-03f,  // 6.622
            1.328108e-03f,  // 6.624
            1.325454e-03f,  // 6.626
            1.322806e-03f,  // 6.628
            1.320163e-03f,  // 6.630
            1.317525e-03f,  // 6.632
            1.314893e-03f,  // 6.634
            1.312266e-03f,  // 6.636
            1.309644e-03f,  // 6.638
            1.307027e-03f,  // 6.640
            1.304416e-03f,  // 6.642
            1.301810e-03f,  // 6.644
            1.299209e-03f,  // 6.646
            1.296613e-03f,  // 6.648
            1.294022e-03f,  // 6.650
            1.291437e-03f,  // 6.652
            1.288856e-03f,  // 6.654
            1.286281e-03f,  // 6.656
            1.283711e-03f,  // 6.658
            1.281146e-03f,  // 6.660
            1.278587e-03f,  // 6.662
            1.276032e-03f,  // 6.664
            1.273483e-03f,  // 6.666
            1.270938e-03f,  // 6.668
            1.268399e-03f,  // 6.670
            1.265864e-03f,  // 6.672
            1.263335e-03f,  // 6.674
            1.260811e-03f,  // 6.676
            1.258292e-03f,  // 6.678
            1.255778e-03f,  // 6.680
            1.253269e-03f,  // 6.682
            1.250765e-03f,  // 6.684
            1.248266e-03f,  // 6.686
            1.245772e-03f,  // 6.688
            1.243283e-03f,  // 6.690
            1.240799e-03f,  // 6.692
            1.238320e-03f,  // 6.694
            1.235845e-03f,  // 6.696
            1.233376e-03f,  // 6.698
            1.230912e-03f,  // 6.700
            1.228453e-03f,  // 6.702
            1.225998e-03f,  // 6.704
            1.223549e-03f,  // 6.706
            1.221104e-03f,  // 6.708
            1.218664e-03f,  // 6.710
            1.216229e-03f,  // 6.712
            1.213799e-03f,  // 6.714
            1.211374e-03f,  // 6.716
            1.208954e-03f,  // 6.718
            1.206538e-03f,  // 6.720
            1.204128e-03f,  // 6.722
            1.201722e-03f,  // 6.724
            1.199321e-03f,  // 6.726
            1.196924e-03f,  // 6.728
            1.194533e-03f,  // 6.730
            1.192146e-03f,  // 6.732
            1.189764e-03f,  // 6.734
            1.187387e-03f,  // 6.736
            1.185015e-03f,  // 6.738
            1.182647e-03f,  // 6.740
            1.180284e-03f,  // 6.742
            1.177926e-03f,  // 6.744
            1.175573e-03f,  // 6.746
            1.173224e-03f,  // 6.748
            1.170880e-03f,  // 6.750
            1.168540e-03f,  // 6.752
            1.166205e-03f,  // 6.754
            1.163875e-03f,  // 6.756
            1.161550e-03f,  // 6.758
            1.159229e-03f,  // 6.760
            1.156913e-03f,  // 6.762
            1.154602e-03f,  // 6.764
            1.152295e-03f,  // 6.766
            1.149992e-03f,  // 6.768
            1.147695e-03f,  // 6.770
            1.145402e-03f,  // 6.772
            1.143113e-03f,  // 6.774
            1.140829e-03f,  // 6.776
            1.138550e-03f,  // 6.778
            1.136275e-03f,  // 6.780
            1.134005e-03f,  // 6.782
            1.131739e-03f,  // 6.784
            1.129478e-03f,  // 6.786
            1.127221e-03f,  // 6.788
            1.124969e-03f,  // 6.790
            1.122721e-03f,  // 6.792
            1.120478e-03f,  // 6.794
            1.118239e-03f,  // 6.796
            1.116005e-03f,  // 6.798
            1.113775e-03f,  // 6.800
            1.111550e-03f,  // 6.802
            1.109329e-03f,  // 6.804
            1.107113e-03f,  // 6.806
            1.104900e-03f,  // 6.808
            1.102693e-03f,  // 6.810
            1.100490e-03f,  // 6.812
            1.098291e-03f,  // 6.814
            1.096097e-03f,  // 6.816
            1.093907e-03f,  // 6.818
            1.091721e-03f,  // 6.820
            1.089540e-03f,  // 6.822
            1.087363e-03f,  // 6.824
            1.085190e-03f,  // 6.826
            1.083022e-03f,  // 6.828
            1.080858e-03f,  // 6.830
            1.078699e-03f,  // 6.832
            1.076543e-03f,  // 6.834
            1.074392e-03f,  // 6.836
            1.072246e-03f,  // 6.838
            1.070103e-03f,  // 6.840
            1.067965e-03f,  // 6.842
            1.065832e-03f,  // 6.844
            1.063702e-03f,  // 6.846
            1.061577e-03f,  // 6.848
            1.059456e-03f,  // 6.850
            1.057339e-03f,  // 6.852
            1.055226e-03f,  // 6.854
            1.053118e-03f,  // 6.856
            1.051014e-03f,  // 6.858
            1.048914e-03f,  // 6.860
            1.046818e-03f,  // 6.862
            1.044727e-03f,  // 6.864
            1.042639e-03f,  // 6.866
            1.040556e-03f,  // 6.868
            1.038477e-03f,  // 6.870
            1.036402e-03f,  // 6.872
            1.034331e-03f,  // 6.874
            1.032265e-03f,  // 6.876
            1.030202e-03f,  // 6.878
            1.028144e-03f,  // 6.880
            1.026090e-03f,  // 6.882
            1.024040e-03f,  // 6.884
            1.021994e-03f,  // 6.886
            1.019952e-03f,  // 6.888
            1.017914e-03f,  // 6.890
            1.015880e-03f,  // 6.892
            1.013850e-03f,  // 6.894
            1.011825e-03f,  // 6.896
            1.009803e-03f,  // 6.898
            1.007785e-03f,  // 6.900
            1.005772e-03f,  // 6.902
            1.003762e-03f,  // 6.904
            1.001757e-03f,  // 6.906
            9.997553e-04f,  // 6.908
            9.977578e-04f,  // 6.910
            9.957643e-04f,  // 6.912
            9.937747e-04f,  // 6.914
            9.917892e-04f,  // 6.916
            9.898076e-04f,  // 6.918
            9.878299e-04f,  // 6.920
            9.858563e-04f,  // 6.922
            9.838865e-04f,  // 6.924
            9.819207e-04f,  // 6.926
            9.799588e-04f,  // 6.928
            9.780009e-04f,  // 6.930
            9.760468e-04f,  // 6.932
            9.740967e-04f,  // 6.934
            9.721504e-04f,  // 6.936
            9.702081e-04f,  // 6.938
            9.682696e-04f,  // 6.940
            9.663350e-04f,  // 6.942
            9.644043e-04f,  // 6.944
            9.624774e-04f,  // 6.946
            9.605543e-04f,  // 6.948
            9.586352e-04f,  // 6.950
            9.567198e-04f,  // 6.952
            9.548083e-04f,  // 6.954
            9.529006e-04f,  // 6.956
            9.509967e-04f,  // 6.958
            9.490966e-04f,  // 6.960
            9.472003e-04f,  // 6.962
            9.453078e-04f,  // 6.964
            9.434190e-04f,  // 6.966
            9.415341e-04f,  // 6.968
            9.396529e-04f,  // 6.970
            9.377755e-04f,  // 6.972
            9.359018e-04f,  // 6.974
            9.340319e-04f,  // 6.976
            9.321657e-04f,  // 6.978
            9.303032e-04f,  // 6.980
            9.284445e-04f,  // 6.982
            9.265894e-04f,  // 6.984
            9.247381e-04f,  // 6.986
            9.228905e-04f,  // 6.988
            9.210465e-04f,  // 6.990
            9.192063e-04f,  // 6.992
            9.173697e-04f,  // 6.994
            9.155368e-04f,  // 6.996
            9.137076e-04f,  // 6.998
            9.118820e-04f,  // 7.000
            9.100600e-04f,  // 7.002
            9.082417e-04f,  // 7.004
            9.064271e-04f,  // 7.006
            9.046160e-04f,  // 7.008
            9.028086e-04f,  // 7.010
            9.010048e-04f,  // 7.012
            8.992046e-04f,  // 7.014
            8.974080e-04f,  // 7.016
            8.956149e-04f,  // 7.018
            8.938255e-04f,  // 7.020
            8.920396e-04f,  // 7.022
            8.902573e-04f,  // 7.024
            8.884786e-04f,  // 7.026
            8.867034e-04f,  // 7.028
            8.849318e-04f,  // 7.030
            8.831637e-04f,  // 7.032
            8.813991e-04f,  // 7.034
            8.796381e-04f,  // 7.036
            8.778806e-04f,  // 7.038
            8.761266e-04f,  // 7.040
            8.743761e-04f,  // 7.042
            8.726291e-04f,  // 7.044
            8.708855e-04f,  // 7.046
            8.691455e-04f,  // 7.048
            8.674090e-04f,  // 7.050
            8.656759e-04f,  // 7.052
            8.639463e-04f,  // 7.054
            8.622201e-04f,  // 7.056
            8.604974e-04f,  // 7.058
            8.587781e-04f,  // 7.060
            8.570623e-04f,  // 7.062
            8.553498e-04f,  // 7.064
            8.536409e-04f,  // 7.066
            8.519353e-04f,  // 7.068
            8.502331e-04f,  // 7.070
            8.485343e-04f,  // 7.072
            8.468390e-04f,  // 7.074
            8.451470e-04f,  // 7.076
            8.434584e-04f,  // 7.078
            8.417731e-04f,  // 7.080
            8.400913e-04f,  // 7.082
            8.384128e-04f,  // 7.084
            8.367376e-04f,  // 7.086
            8.350658e-04f,  // 7.088
            8.333974e-04f,  // 7.090
            8.317322e-04f,  // 7.092
            8.300704e-04f,  // 7.094
            8.284120e-04f,  // 7.096
            8.267568e-04f,  // 7.098
            8.251049e-04f,  // 7.100
            8.234564e-04f,  // 7.102
            8.218111e-04f,  // 7.104
            8.201691e-04f,  // 7.106
            8.185304e-04f,  // 7.108
            8.168950e-04f,  // 7.110
            8.152628e-04f,  // 7.112
            8.136339e-04f,  // 7.114
            8.120083e-04f,  // 7.116
            8.103859e-04f,  // 7.118
            8.087668e-04f,  // 7.120
            8.071508e-04f,  // 7.122
            8.055381e-04f,  // 7.124
            8.039287e-04f,  // 7.126
            8.023224e-04f,  // 7.128
            8.007194e-04f,  // 7.130
            7.991195e-04f,  // 7.132
            7.975229e-04f,  // 7.134
            7.959295e-04f,  // 7.136
            7.943392e-04f,  // 7.138
            7.927521e-04f,  // 7.140
            7.911682e-04f,  // 7.142
            7.895874e-04f,  // 7.144
            7.880098e-04f,  // 7.146
            7.864354e-04f,  // 7.148
            7.848641e-04f,  // 7.150
            7.832959e-04f,  // 7.152
            7.817309e-04f,  // 7.154
            7.801690e-04f,  // 7.156
            7.786102e-04f,  // 7.158
            7.770546e-04f,  // 7.160
            7.755020e-04f,  // 7.162
            7.739525e-04f,  // 7.164
            7.724062e-04f,  // 7.166
            7.708629e-04f,  // 7.168
            7.693227e-04f,  // 7.170
            7.677856e-04f,  // 7.172
            7.662516e-04f,  // 7.174
            7.647206e-04f,  // 7.176
            7.631927e-04f,  // 7.178
            7.616678e-04f,  // 7.180
            7.601460e-04f,  // 7.182
            7.586273e-04f,  // 7.184
            7.571115e-04f,  // 7.186
            7.555988e-04f,  // 7.188
            7.540891e-04f,  // 7.190
            7.525824e-04f,  // 7.192
            7.510788e-04f,  // 7.194
            7.495781e-04f,  // 7.196
            7.480805e-04f,  // 7.198
            7.465858e-04f,  // 7.200
            7.450941e-04f,  // 7.202
            7.436054e-04f,  // 7.204
            7.421197e-04f,  // 7.206
            7.406369e-04f,  // 7.208
            7.391572e-04f,  // 7.210
            7.376803e-04f,  // 7.212
            7.362064e-04f,  // 7.214
            7.347355e-04f,  // 7.216
            7.332675e-04f,  // 7.218
            7.318024e-04f,  // 7.220
            7.303403e-04f,  // 7.222
            7.288811e-04f,  // 7.224
            7.274248e-04f,  // 7.226
            7.259714e-04f,  // 7.228
            7.245209e-04f,  // 7.230
            7.230733e-04f,  // 7.232
            7.216286e-04f,  // 7.234
            7.201868e-04f,  // 7.236
            7.187478e-04f,  // 7.238
            7.173118e-04f,  // 7.240
            7.158786e-04f,  // 7.242
            7.144482e-04f,  // 7.244
            7.130208e-04f,  // 7.246
            7.115962e-04f,  // 7.248
            7.101744e-04f,  // 7.250
            7.087555e-04f,  // 7.252
            7.073394e-04f,  // 7.254
            7.059261e-04f,  // 7.256
            7.045157e-04f,  // 7.258
            7.031080e-04f,  // 7.260
            7.017032e-04f,  // 7.262
            7.003012e-04f,  // 7.264
            6.989020e-04f,  // 7.266
            6.975056e-04f,  // 7.268
            6.961120e-04f,  // 7.270
            6.947212e-04f,  // 7.272
            6.933331e-04f,  // 7.274
            6.919478e-04f,  // 7.276
            6.905653e-04f,  // 7.278
            6.891856e-04f,  // 7.280
            6.878086e-04f,  // 7.282
            6.864343e-04f,  // 7.284
            6.850628e-04f,  // 7.286
            6.836941e-04f,  // 7.288
            6.823281e-04f,  // 7.290
            6.809648e-04f,  // 7.292
            6.796042e-04f,  // 7.294
            6.782463e-04f,  // 7.296
            6.768912e-04f,  // 7.298
            6.755388e-04f,  // 7.300
            6.741890e-04f,  // 7.302
            6.728420e-04f,  // 7.304
            6.714977e-04f,  // 7.306
            6.701560e-04f,  // 7.308
            6.688171e-04f,  // 7.310
            6.674808e-04f,  // 7.312
            6.661471e-04f,  // 7.314
            6.648162e-04f,  // 7.316
            6.634879e-04f,  // 7.318
            6.621622e-04f,  // 7.320
            6.608392e-04f,  // 7.322
            6.595189e-04f,  // 7.324
            6.582011e-04f,  // 7.326
            6.568860e-04f,  // 7.328
            6.555736e-04f,  // 7.330
            6.542638e-04f,  // 7.332
            6.529565e-04f,  // 7.334
            6.516519e-04f,  // 7.336
            6.503499e-04f,  // 7.338
            6.490505e-04f,  // 7.340
            6.477537e-04f,  // 7.342
            6.464595e-04f,  // 7.344
            6.451679e-04f,  // 7.346
            6.438788e-04f,  // 7.348
            6.425924e-04f,  // 7.350
            6.413085e-04f,  // 7.352
            6.400271e-04f,  // 7.354
            6.387483e-04f,  // 7.356
            6.374721e-04f,  // 7.358
            6.361985e-04f,  // 7.360
            6.349273e-04f,  // 7.362
            6.336587e-04f,  // 7.364
            6.323927e-04f,  // 7.366
            6.311292e-04f,  // 7.368
            6.298682e-04f,  // 7.370
            6.286097e-04f,  // 7.372
            6.273537e-04f,  // 7.374
            6.261003e-04f,  // 7.376
            6.248493e-04f,  // 7.378
            6.236009e-04f,  // 7.380
            6.223549e-04f,  // 7.382
            6.211115e-04f,  // 7.384
            6.198705e-04f,  // 7.386
            6.186320e-04f,  // 7.388
            6.173960e-04f,  // 7.390
            6.161624e-04f,  // 7.392
            6.149313e-04f,  // 7.394
            6.137027e-04f,  // 7.396
            6.124765e-04f,  // 7.398
            6.112528e-04f,  // 7.400
            6.100315e-04f,  // 7.402
            6.088126e-04f,  // 7.404
            6.075962e-04f,  // 7.406
            6.063822e-04f,  // 7.408
            6.051707e-04f,  // 7.410
            6.039616e-04f,  // 7.412
            6.027548e-04f,  // 7.414
            6.015505e-04f,  // 7.416
            6.003486e-04f,  // 7.418
            5.991491e-04f,  // 7.420
            5.979520e-04f,  // 7.422
            5.967573e-04f,  // 7.424
            5.955650e-04f,  // 7.426
            5.943751e-04f,  // 7.428
            5.931875e-04f,  // 7.430
            5.920023e-04f,  // 7.432
            5.908195e-04f,  // 7.434
            5.896390e-04f,  // 7.436
            5.884609e-04f,  // 7.438
            5.872852e-04f,  // 7.440
            5.861118e-04f,  // 7.442
            5.849407e-04f,  // 7.444
            5.837720e-04f,  // 7.446
            5.826057e-04f,  // 7.448
            5.814416e-04f,  // 7.450
            5.802799e-04f,  // 7.452
            5.791205e-04f,  // 7.454
            5.779634e-04f,  // 7.456
            5.768086e-04f,  // 7.458
            5.756562e-04f,  // 7.460
            5.745060e-04f,  // 7.462
            5.733581e-04f,  // 7.464
            5.722126e-04f,  // 7.466
            5.710693e-04f,  // 7.468
            5.699283e-04f,  // 7.470
            5.687896e-04f,  // 7.472
            5.676531e-04f,  // 7.474
            5.665190e-04f,  // 7.476
            5.653871e-04f,  // 7.478
            5.642574e-04f,  // 7.480
            5.631300e-04f,  // 7.482
            5.620049e-04f,  // 7.484
            5.608820e-04f,  // 7.486
            5.597614e-04f,  // 7.488
            5.586430e-04f,  // 7.490
            5.575268e-04f,  // 7.492
            5.564129e-04f,  // 7.494
            5.553011e-04f,  // 7.496
            5.541916e-04f,  // 7.498
            5.530844e-04f,  // 7.500
            5.519793e-04f,  // 7.502
            5.508765e-04f,  // 7.504
            5.497758e-04f,  // 7.506
            5.486773e-04f,  // 7.508
            5.475811e-04f,  // 7.510
            5.464870e-04f,  // 7.512
            5.453951e-04f,  // 7.514
            5.443054e-04f,  // 7.516
            5.432179e-04f,  // 7.518
            5.421326e-04f,  // 7.520
            5.410494e-04f,  // 7.522
            5.399684e-04f,  // 7.524
            5.388895e-04f,  // 7.526
            5.378128e-04f,  // 7.528
            5.367383e-04f,  // 7.530
            5.356659e-04f,  // 7.532
            5.345956e-04f,  // 7.534
            5.335275e-04f,  // 7.536
            5.324615e-04f,  // 7.538
            5.313976e-04f,  // 7.540
            5.303359e-04f,  // 7.542
            5.292763e-04f,  // 7.544
            5.282188e-04f,  // 7.546
            5.271634e-04f,  // 7.548
            5.261101e-04f,  // 7.550
            5.250590e-04f,  // 7.552
            5.240099e-04f,  // 7.554
            5.229629e-04f,  // 7.556
            5.219180e-04f,  // 7.558
            5.208752e-04f,  // 7.560
            5.198345e-04f,  // 7.562
            5.187959e-04f,  // 7.564
            5.177593e-04f,  // 7.566
            5.167249e-04f,  // 7.568
            5.156924e-04f,  // 7.570
            5.146621e-04f,  // 7.572
            5.136338e-04f,  // 7.574
            5.126076e-04f,  // 7.576
            5.115834e-04f,  // 7.578
            5.105612e-04f,  // 7.580
            5.095411e-04f,  // 7.582
            5.085231e-04f,  // 7.584
            5.075070e-04f,  // 7.586
            5.064930e-04f,  // 7.588
            5.054811e-04f,  // 7.590
            5.044711e-04f,  // 7.592
            5.034632e-04f,  // 7.594
            5.024572e-04f,  // 7.596
            5.014533e-04f,  // 7.598
            5.004514e-04f,  // 7.600
            4.994515e-04f,  // 7.602
            4.984536e-04f,  // 7.604
            4.974577e-04f,  // 7.606
            4.964638e-04f,  // 7.608
            4.954719e-04f,  // 7.610
            4.944819e-04f,  // 7.612
            4.934939e-04f,  // 7.614
            4.925079e-04f,  // 7.616
            4.915239e-04f,  // 7.618
            4.905418e-04f,  // 7.620
            4.895617e-04f,  // 7.622
            4.885836e-04f,  // 7.624
            4.876074e-04f,  // 7.626
            4.866332e-04f,  // 7.628
            4.856609e-04f,  // 7.630
            4.846905e-04f,  // 7.632
            4.837221e-04f,  // 7.634
            4.827556e-04f,  // 7.636
            4.817911e-04f,  // 7.638
            4.808285e-04f,  // 7.640
            4.798678e-04f,  // 7.642
            4.789090e-04f,  // 7.644
            4.779521e-04f,  // 7.646
            4.769972e-04f,  // 7.648
            4.760441e-04f,  // 7.650
            4.750930e-04f,  // 7.652
            4.741438e-04f,  // 7.654
            4.731964e-04f,  // 7.656
            4.722510e-04f,  // 7.658
            4.713074e-04f,  // 7.660
            4.703657e-04f,  // 7.662
            4.694259e-04f,  // 7.664
            4.684880e-04f,  // 7.666
            4.675520e-04f,  // 7.668
            4.666178e-04f,  // 7.670
            4.656855e-04f,  // 7.672
            4.647551e-04f,  // 7.674
            4.638265e-04f,  // 7.676
            4.628998e-04f,  // 7.678
            4.619749e-04f,  // 7.680
            4.610519e-04f,  // 7.682
            4.601307e-04f,  // 7.684
            4.592113e-04f,  // 7.686
            4.582938e-04f,  // 7.688
            4.573782e-04f,  // 7.690
            4.564643e-04f,  // 7.692
            4.555523e-04f,  // 7.694
            4.546421e-04f,  // 7.696
            4.537337e-04f,  // 7.698
            4.528272e-04f,  // 7.700
            4.519224e-04f,  // 7.702
            4.510195e-04f,  // 7.704
            4.501184e-04f,  // 7.706
            4.492190e-04f,  // 7.708
            4.483215e-04f,  // 7.710
            4.474257e-04f,  // 7.712
            4.465318e-04f,  // 7.714
            4.456396e-04f,  // 7.716
            4.447492e-04f,  // 7.718
            4.438606e-04f,  // 7.720
            4.429738e-04f,  // 7.722
            4.420887e-04f,  // 7.724
            4.412054e-04f,  // 7.726
            4.403239e-04f,  // 7.728
            4.394441e-04f,  // 7.730
            4.385661e-04f,  // 7.732
            4.376899e-04f,  // 7.734
            4.368153e-04f,  // 7.736
            4.359426e-04f,  // 7.738
            4.350716e-04f,  // 7.740
            4.342023e-04f,  // 7.742
            4.333348e-04f,  // 7.744
            4.324690e-04f,  // 7.746
            4.316049e-04f,  // 7.748
            4.307425e-04f,  // 7.750
            4.298819e-04f,  // 7.752
            4.290230e-04f,  // 7.754
            4.281658e-04f,  // 7.756
            4.273103e-04f,  // 7.758
            4.264566e-04f,  // 7.760
            4.256045e-04f,  // 7.762
            4.247542e-04f,  // 7.764
            4.239055e-04f,  // 7.766
            4.230585e-04f,  // 7.768
            4.222133e-04f,  // 7.770
            4.213697e-04f,  // 7.772
            4.205278e-04f,  // 7.774
            4.196876e-04f,  // 7.776
            4.188490e-04f,  // 7.778
            4.180122e-04f,  // 7.780
            4.171770e-04f,  // 7.782
            4.163435e-04f,  // 7.784
            4.155116e-04f,  // 7.786
            4.146814e-04f,  // 7.788
            4.138529e-04f,  // 7.790
            4.130260e-04f,  // 7.792
            4.122008e-04f,  // 7.794
            4.113772e-04f,  // 7.796
            4.105553e-04f,  // 7.798
            4.097350e-04f,  // 7.800
            4.089163e-04f,  // 7.802
            4.080993e-04f,  // 7.804
            4.072839e-04f,  // 7.806
            4.064702e-04f,  // 7.808
            4.056580e-04f,  // 7.810
            4.048475e-04f,  // 7.812
            4.040387e-04f,  // 7.814
            4.032314e-04f,  // 7.816
            4.024257e-04f,  // 7.818
            4.016217e-04f,  // 7.820
            4.008192e-04f,  // 7.822
            4.000184e-04f,  // 7.824
            3.992192e-04f,  // 7.826
            3.984215e-04f,  // 7.828
            3.976255e-04f,  // 7.830
            3.968310e-04f,  // 7.832
            3.960382e-04f,  // 7.834
            3.952469e-04f,  // 7.836
            3.944572e-04f,  // 7.838
            3.936690e-04f,  // 7.840
            3.928825e-04f,  // 7.842
            3.920975e-04f,  // 7.844
            3.913141e-04f,  // 7.846
            3.905323e-04f,  // 7.848
            3.897520e-04f,  // 7.850
            3.889732e-04f,  // 7.852
            3.881961e-04f,  // 7.854
            3.874205e-04f,  // 7.856
            3.866464e-04f,  // 7.858
            3.858739e-04f,  // 7.860
            3.851029e-04f,  // 7.862
            3.843335e-04f,  // 7.864
            3.835656e-04f,  // 7.866
            3.827992e-04f,  // 7.868
            3.820344e-04f,  // 7.870
            3.812711e-04f,  // 7.872
            3.805093e-04f,  // 7.874
            3.797490e-04f,  // 7.876
            3.789903e-04f,  // 7.878
            3.782331e-04f,  // 7.880
            3.774773e-04f,  // 7.882
            3.767231e-04f,  // 7.884
            3.759705e-04f,  // 7.886
            3.752193e-04f,  // 7.888
            3.744696e-04f,  // 7.890
            3.737214e-04f,  // 7.892
            3.729747e-04f,  // 7.894
            3.722295e-04f,  // 7.896
            3.714858e-04f,  // 7.898
            3.707435e-04f,  // 7.900
            3.700028e-04f,  // 7.902
            3.692635e-04f,  // 7.904
            3.685257e-04f,  // 7.906
            3.677894e-04f,  // 7.908
            3.670546e-04f,  // 7.910
            3.663212e-04f,  // 7.912
            3.655893e-04f,  // 7.914
            3.648588e-04f,  // 7.916
            3.641299e-04f,  // 7.918
            3.634023e-04f,  // 7.920
            3.626762e-04f,  // 7.922
            3.619516e-04f,  // 7.924
            3.612284e-04f,  // 7.926
            3.605067e-04f,  // 7.928
            3.597864e-04f,  // 7.930
            3.590676e-04f,  // 7.932
            3.583501e-04f,  // 7.934
            3.576342e-04f,  // 7.936
            3.569196e-04f,  // 7.938
            3.562065e-04f,  // 7.940
            3.554948e-04f,  // 7.942
            3.547845e-04f,  // 7.944
            3.540756e-04f,  // 7.946
            3.533682e-04f,  // 7.948
            3.526622e-04f,  // 7.950
            3.519575e-04f,  // 7.952
            3.512543e-04f,  // 7.954
            3.505525e-04f,  // 7.956
            3.498521e-04f,  // 7.958
            3.491531e-04f,  // 7.960
            3.484555e-04f,  // 7.962
            3.477593e-04f,  // 7.964
            3.470645e-04f,  // 7.966
            3.463710e-04f,  // 7.968
            3.456790e-04f,  // 7.970
            3.449883e-04f,  // 7.972
            3.442990e-04f,  // 7.974
            3.436111e-04f,  // 7.976
            3.429246e-04f,  // 7.978
            3.422394e-04f,  // 7.980
            3.415556e-04f,  // 7.982
            3.408732e-04f,  // 7.984
            3.401921e-04f,  // 7.986
            3.395124e-04f,  // 7.988
            3.388341e-04f,  // 7.990
            3.381571e-04f,  // 7.992
            3.374815e-04f,  // 7.994
            3.368072e-04f,  // 7.996
            3.361342e-04f,  // 7.998
            3.354626e-04f,  // 8.000
            3.347924e-04f,  // 8.002
            3.341235e-04f,  // 8.004
            3.334559e-04f,  // 8.006
            3.327896e-04f,  // 8.008
            3.321247e-04f,  // 8.010
            3.314611e-04f,  // 8.012
            3.307989e-04f,  // 8.014
            3.301379e-04f,  // 8.016
            3.294783e-04f,  // 8.018
            3.288200e-04f,  // 8.020
            3.281630e-04f,  // 8.022
            3.275074e-04f,  // 8.024
            3.268530e-04f,  // 8.026
            3.262000e-04f,  // 8.028
            3.255482e-04f,  // 8.030
            3.248978e-04f,  // 8.032
            3.242486e-04f,  // 8.034
            3.236008e-04f,  // 8.036
            3.229542e-04f,  // 8.038
            3.223090e-04f,  // 8.040
            3.216650e-04f,  // 8.042
            3.210223e-04f,  // 8.044
            3.203809e-04f,  // 8.046
            3.197408e-04f,  // 8.048
            3.191019e-04f,  // 8.050
            3.184644e-04f,  // 8.052
            3.178281e-04f,  // 8.054
            3.171930e-04f,  // 8.056
            3.165593e-04f,  // 8.058
            3.159268e-04f,  // 8.060
            3.152956e-04f,  // 8.062
            3.146656e-04f,  // 8.064
            3.140369e-04f,  // 8.066
            3.134095e-04f,  // 8.068
            3.127833e-04f,  // 8.070
            3.121583e-04f,  // 8.072
            3.115346e-04f,  // 8.074
            3.109122e-04f,  // 8.076
            3.102910e-04f,  // 8.078
            3.096710e-04f,  // 8.080
            3.090523e-04f,  // 8.082
            3.084348e-04f,  // 8.084
            3.078186e-04f,  // 8.086
            3.072036e-04f,  // 8.088
            3.065898e-04f,  // 8.090
            3.059772e-04f,  // 8.092
            3.053658e-04f,  // 8.094
            3.047557e-04f,  // 8.096
            3.041468e-04f,  // 8.098
            3.035391e-04f,  // 8.100
            3.029327e-04f,  // 8.102
            3.023274e-04f,  // 8.104
            3.017234e-04f,  // 8.106
            3.011205e-04f,  // 8.108
            3.005189e-04f,  // 8.110
            2.999184e-04f,  // 8.112
            2.993192e-04f,  // 8.114
            2.987212e-04f,  // 8.116
            2.981243e-04f,  // 8.118
            2.975287e-04f,  // 8.120
            2.969342e-04f,  // 8.122
            2.963409e-04f,  // 8.124
            2.957488e-04f,  // 8.126
            2.951579e-04f,  // 8.128
            2.945682e-04f,  // 8.130
            2.939797e-04f,  // 8.132
            2.933923e-04f,  // 8.134
            2.928061e-04f,  // 8.136
            2.922211e-04f,  // 8.138
            2.916372e-04f,  // 8.140
            2.910545e-04f,  // 8.142
            2.904730e-04f,  // 8.144
            2.898926e-04f,  // 8.146
            2.893134e-04f,  // 8.148
            2.887354e-04f,  // 8.150
            2.881585e-04f,  // 8.152
            2.875827e-04f,  // 8.154
            2.870081e-04f,  // 8.156
            2.864347e-04f,  // 8.158
            2.858624e-04f,  // 8.160
            2.852912e-04f,  // 8.162
            2.847212e-04f,  // 8.164
            2.841524e-04f,  // 8.166
            2.835846e-04f,  // 8.168
            2.830180e-04f,  // 8.170
            2.824525e-04f,  // 8.172
            2.818882e-04f,  // 8.174
            2.813250e-04f,  // 8.176
            2.807629e-04f,  // 8.178
            2.802019e-04f,  // 8.180
            2.796421e-04f,  // 8.182
            2.790834e-04f,  // 8.184
            2.785258e-04f,  // 8.186
            2.779693e-04f,  // 8.188
            2.774139e-04f,  // 8.190
            2.768596e-04f,  // 8.192
            2.763064e-04f,  // 8.194
            2.757544e-04f,  // 8.196
            2.752034e-04f,  // 8.198
            2.746536e-04f,  // 8.200
            2.741048e-04f,  // 8.202
            2.735571e-04f,  // 8.204
            2.730106e-04f,  // 8.206
            2.724651e-04f,  // 8.208
            2.719207e-04f,  // 8.210
            2.713774e-04f,  // 8.212
            2.708352e-04f,  // 8.214
            2.702941e-04f,  // 8.216
            2.697540e-04f,  // 8.218
            2.692151e-04f,  // 8.220
            2.686772e-04f,  // 8.222
            2.681404e-04f,  // 8.224
            2.676046e-04f,  // 8.226
            2.670699e-04f,  // 8.228
            2.665363e-04f,  // 8.230
            2.660038e-04f,  // 8.232
            2.654723e-04f,  // 8.234
            2.649419e-04f,  // 8.236
            2.644125e-04f,  // 8.238
            2.638842e-04f,  // 8.240
            2.633570e-04f,  // 8.242
            2.628308e-04f,  // 8.244
            2.623057e-04f,  // 8.246
            2.617816e-04f,  // 8.248
            2.612586e-04f,  // 8.250
            2.607366e-04f,  // 8.252
            2.602156e-04f,  // 8.254
            2.596957e-04f,  // 8.256
            2.591768e-04f,  // 8.258
            2.586590e-04f,  // 8.260
            2.581422e-04f,  // 8.262
            2.576264e-04f,  // 8.264
            2.571117e-04f,  // 8.266
            2.565980e-04f,  // 8.268
            2.560853e-04f,  // 8.270
            2.555736e-04f,  // 8.272
            2.550630e-04f,  // 8.274
            2.545534e-04f,  // 8.276
            2.540448e-04f,  // 8.278
            2.535372e-04f,  // 8.280
            2.530306e-04f,  // 8.282
            2.525251e-04f,  // 8.284
            2.520205e-04f,  // 8.286
            2.515170e-04f,  // 8.288
            2.510145e-04f,  // 8.290
            2.505129e-04f,  // 8.292
            2.500124e-04f,  // 8.294
            2.495129e-04f,  // 8.296
            2.490144e-04f,  // 8.298
            2.485168e-04f,  // 8.300
            2.480203e-04f,  // 8.302
            2.475247e-04f,  // 8.304
            2.470302e-04f,  // 8.306
            2.465366e-04f,  // 8.308
            2.460440e-04f,  // 8.310
            2.455524e-04f,  // 8.312
            2.450618e-04f,  // 8.314
            2.445722e-04f,  // 8.316
            2.440835e-04f,  // 8.318
            2.435959e-04f,  // 8.320
            2.431092e-04f,  // 8.322
            2.426234e-04f,  // 8.324
            2.421387e-04f,  // 8.326
            2.416549e-04f,  // 8.328
            2.411720e-04f,  // 8.330
            2.406902e-04f,  // 8.332
            2.402093e-04f,  // 8.334
            2.397293e-04f,  // 8.336
            2.392504e-04f,  // 8.338
            2.387723e-04f,  // 8.340
            2.382953e-04f,  // 8.342
            2.378192e-04f,  // 8.344
            2.373440e-04f,  // 8.346
            2.368698e-04f,  // 8.348
            2.363965e-04f,  // 8.350
            2.359242e-04f,  // 8.352
            2.354528e-04f,  // 8.354
            2.349824e-04f,  // 8.356
            2.345129e-04f,  // 8.358
            2.340443e-04f,  // 8.360
            2.335767e-04f,  // 8.362
            2.331100e-04f,  // 8.364
            2.326443e-04f,  // 8.366
            2.321794e-04f,  // 8.368
            2.317156e-04f,  // 8.370
            2.312526e-04f,  // 8.372
            2.307905e-04f,  // 8.374
            2.303294e-04f,  // 8.376
            2.298692e-04f,  // 8.378
            2.294099e-04f,  // 8.380
            2.289516e-04f,  // 8.382
            2.284941e-04f,  // 8.384
            2.280376e-04f,  // 8.386
            2.275820e-04f,  // 8.388
            2.271273e-04f,  // 8.390
            2.266735e-04f,  // 8.392
            2.262206e-04f,  // 8.394
            2.257686e-04f,  // 8.396
            2.253175e-04f,  // 8.398
            2.248673e-04f,  // 8.400
            2.244180e-04f,  // 8.402
            2.239697e-04f,  // 8.404
            2.235222e-04f,  // 8.406
            2.230756e-04f,  // 8.408
            2.226299e-04f,  // 8.410
            2.221850e-04f,  // 8.412
            2.217411e-04f,  // 8.414
            2.212981e-04f,  // 8.416
            2.208559e-04f,  // 8.418
            2.204147e-04f,  // 8.420
            2.199743e-04f,  // 8.422
            2.195348e-04f,  // 8.424
            2.190961e-04f,  // 8.426
            2.186584e-04f,  // 8.428
            2.182215e-04f,  // 8.430
            2.177855e-04f,  // 8.432
            2.173503e-04f,  // 8.434
            2.169161e-04f,  // 8.436
            2.164827e-04f,  // 8.438
            2.160502e-04f,  // 8.440
            2.156185e-04f,  // 8.442
            2.151877e-04f,  // 8.444
            2.147577e-04f,  // 8.446
            2.143286e-04f,  // 8.448
            2.139004e-04f,  // 8.450
            2.134730e-04f,  // 8.452
            2.130465e-04f,  // 8.454
            2.126209e-04f,  // 8.456
            2.121960e-04f,  // 8.458
            2.117721e-04f,  // 8.460
            2.113489e-04f,  // 8.462
            2.109267e-04f,  // 8.464
            2.105052e-04f,  // 8.466
            2.100847e-04f,  // 8.468
            2.096649e-04f,  // 8.470
            2.092460e-04f,  // 8.472
            2.088279e-04f,  // 8.474
            2.084107e-04f,  // 8.476
            2.079943e-04f,  // 8.478
            2.075787e-04f,  // 8.480
            2.071640e-04f,  // 8.482
            2.067500e-04f,  // 8.484
            2.063370e-04f,  // 8.486
            2.059247e-04f,  // 8.488
            2.055133e-04f,  // 8.490
            2.051026e-04f,  // 8.492
            2.046928e-04f,  // 8.494
            2.042839e-04f,  // 8.496
            2.038757e-04f,  // 8.498
            2.034684e-04f,  // 8.500
            2.030618e-04f,  // 8.502
            2.026561e-04f,  // 8.504
            2.022512e-04f,  // 8.506
            2.018471e-04f,  // 8.508
            2.014438e-04f,  // 8.510
            2.010413e-04f,  // 8.512
            2.006397e-04f,  // 8.514
            2.002388e-04f,  // 8.516
            1.998387e-04f,  // 8.518
            1.994394e-04f,  // 8.520
            1.990409e-04f,  // 8.522
            1.986433e-04f,  // 8.524
            1.982464e-04f,  // 8.526
            1.978503e-04f,  // 8.528
            1.974550e-04f,  // 8.530
            1.970605e-04f,  // 8.532
            1.966667e-04f,  // 8.534
            1.962738e-04f,  // 8.536
            1.958816e-04f,  // 8.538
            1.954903e-04f,  // 8.540
            1.950997e-04f,  // 8.542
            1.947099e-04f,  // 8.544
            1.943208e-04f,  // 8.546
            1.939326e-04f,  // 8.548
            1.935451e-04f,  // 8.550
            1.931584e-04f,  // 8.552
            1.927725e-04f,  // 8.554
            1.923873e-04f,  // 8.556
            1.920029e-04f,  // 8.558
            1.916193e-04f,  // 8.560
            1.912364e-04f,  // 8.562
            1.908543e-04f,  // 8.564
            1.904730e-04f,  // 8.566
            1.900925e-04f,  // 8.568
            1.897126e-04f,  // 8.570
            1.893336e-04f,  // 8.572
            1.889553e-04f,  // 8.574
            1.885778e-04f,  // 8.576
            1.882010e-04f,  // 8.578
            1.878250e-04f,  // 8.580
            1.874497e-04f,  // 8.582
            1.870752e-04f,  // 8.584
            1.867014e-04f,  // 8.586
            1.863284e-04f,  // 8.588
            1.859561e-04f,  // 8.590
            1.855845e-04f,  // 8.592
            1.852137e-04f,  // 8.594
            1.848437e-04f,  // 8.596
            1.844744e-04f,  // 8.598
            1.841058e-04f,  // 8.600
            1.837380e-04f,  // 8.602
            1.833708e-04f,  // 8.604
            1.830045e-04f,  // 8.606
            1.826388e-04f,  // 8.608
            1.822739e-04f,  // 8.610
            1.819097e-04f,  // 8.612
            1.815463e-04f,  // 8.614
            1.811835e-04f,  // 8.616
            1.808215e-04f,  // 8.618
            1.804603e-04f,  // 8.620
            1.800997e-04f,  // 8.622
            1.797399e-04f,  // 8.624
            1.793807e-04f,  // 8.626
            1.790223e-04f,  // 8.628
            1.786646e-04f,  // 8.630
            1.783077e-04f,  // 8.632
            1.779514e-04f,  // 8.634
            1.775959e-04f,  // 8.636
            1.772410e-04f,  // 8.638
            1.768869e-04f,  // 8.640
            1.765335e-04f,  // 8.642
            1.761808e-04f,  // 8.644
            1.758288e-04f,  // 8.646
            1.754775e-04f,  // 8.648
            1.751268e-04f,  // 8.650
            1.747769e-04f,  // 8.652
            1.744277e-04f,  // 8.654
            1.740792e-04f,  // 8.656
            1.737314e-04f,  // 8.658
            1.733843e-04f,  // 8.660
            1.730379e-04f,  // 8.662
            1.726922e-04f,  // 8.664
            1.723471e-04f,  // 8.666
            1.720028e-04f,  // 8.668
            1.716591e-04f,  // 8.670
            1.713161e-04f,  // 8.672
            1.709738e-04f,  // 8.674
            1.706322e-04f,  // 8.676
            1.702913e-04f,  // 8.678
            1.699511e-04f,  // 8.680
            1.696115e-04f,  // 8.682
            1.692726e-04f,  // 8.684
            1.689344e-04f,  // 8.686
            1.685969e-04f,  // 8.688
            1.682600e-04f,  // 8.690
            1.679238e-04f,  // 8.692
            1.675883e-04f,  // 8.694
            1.672535e-04f,  // 8.696
            1.669193e-04f,  // 8.698
            1.665858e-04f,  // 8.700
            1.662530e-04f,  // 8.702
            1.659208e-04f,  // 8.704
            1.655893e-04f,  // 8.706
            1.652584e-04f,  // 8.708
            1.649283e-04f,  // 8.710
            1.645987e-04f,  // 8.712
            1.642699e-04f,  // 8.714
            1.639416e-04f,  // 8.716
            1.636141e-04f,  // 8.718
            1.632872e-04f,  // 8.720
            1.629609e-04f,  // 8.722
            1.626353e-04f,  // 8.724
            1.623104e-04f,  // 8.726
            1.619861e-04f,  // 8.728
            1.616625e-04f,  // 8.730
            1.613395e-04f,  // 8.732
            1.610171e-04f,  // 8.734
            1.606954e-04f,  // 8.736
            1.603743e-04f,  // 8.738
            1.600539e-04f,  // 8.740
            1.597341e-04f,  // 8.742
            1.594150e-04f,  // 8.744
            1.590964e-04f,  // 8.746
            1.587786e-04f,  // 8.748
            1.584613e-04f,  // 8.750
            1.581447e-04f,  // 8.752
            1.578287e-04f,  // 8.754
            1.575134e-04f,  // 8.756
            1.571987e-04f,  // 8.758
            1.568846e-04f,  // 8.760
            1.565712e-04f,  // 8.762
            1.562583e-04f,  // 8.764
            1.559461e-04f,  // 8.766
            1.556345e-04f,  // 8.768
            1.553236e-04f,  // 8.770
            1.550132e-04f,  // 8.772
            1.547035e-04f,  // 8.774
            1.543944e-04f,  // 8.776
            1.540859e-04f,  // 8.778
            1.537781e-04f,  // 8.780
            1.534708e-04f,  // 8.782
            1.531642e-04f,  // 8.784
            1.528582e-04f,  // 8.786
            1.525528e-04f,  // 8.788
            1.522480e-04f,  // 8.790
            1.519438e-04f,  // 8.792
            1.516402e-04f,  // 8.794
            1.513372e-04f,  // 8.796
            1.510348e-04f,  // 8.798
            1.507331e-04f,  // 8.800
            1.504319e-04f,  // 8.802
            1.501313e-04f,  // 8.804
            1.498314e-04f,  // 8.806
            1.495320e-04f,  // 8.808
            1.492333e-04f,  // 8.810
            1.489351e-04f,  // 8.812
            1.486375e-04f,  // 8.814
            1.483405e-04f,  // 8.816
            1.480442e-04f,  // 8.818
            1.477484e-04f,  // 8.820
            1.474532e-04f,  // 8.822
            1.471585e-04f,  // 8.824
            1.468645e-04f,  // 8.826
            1.465711e-04f,  // 8.828
            1.462782e-04f,  // 8.830
            1.459860e-04f,  // 8.832
            1.456943e-04f,  // 8.834
            1.454032e-04f,  // 8.836
            1.451127e-04f,  // 8.838
            1.448227e-04f,  // 8.840
            1.445334e-04f,  // 8.842
            1.442446e-04f,  // 8.844
            1.439564e-04f,  // 8.846
            1.436688e-04f,  // 8.848
            1.433817e-04f,  // 8.850
            1.430953e-04f,  // 8.852
            1.428094e-04f,  // 8.854
            1.425240e-04f,  // 8.856
            1.422393e-04f,  // 8.858
            1.419551e-04f,  // 8.860
            1.416714e-04f,  // 8.862
            1.413884e-04f,  // 8.864
            1.411059e-04f,  // 8.866
            1.408240e-04f,  // 8.868
            1.405426e-04f,  // 8.870
            1.402618e-04f,  // 8.872
            1.399815e-04f,  // 8.874
            1.397019e-04f,  // 8.876
            1.394227e-04f,  // 8.878
            1.391442e-04f,  // 8.880
            1.388662e-04f,  // 8.882
            1.385887e-04f,  // 8.884
            1.383118e-04f,  // 8.886
            1.380355e-04f,  // 8.888
            1.377597e-04f,  // 8.890
            1.374844e-04f,  // 8.892
            1.372097e-04f,  // 8.894
            1.369356e-04f,  // 8.896
            1.366620e-04f,  // 8.898
            1.363889e-04f,  // 8.900
            1.361164e-04f,  // 8.902
            1.358445e-04f,  // 8.904
            1.355730e-04f,  // 8.906
            1.353022e-04f,  // 8.908
            1.350318e-04f,  // 8.910
            1.347620e-04f,  // 8.912
            1.344928e-04f,  // 8.914
            1.342241e-04f,  // 8.916
            1.339559e-04f,  // 8.918
            1.336882e-04f,  // 8.920
            1.334211e-04f,  // 8.922
            1.331546e-04f,  // 8.924
            1.328885e-04f,  // 8.926
            1.326230e-04f,  // 8.928
            1.323580e-04f,  // 8.930
            1.320936e-04f,  // 8.932
            1.318296e-04f,  // 8.934
            1.315663e-04f,  // 8.936
            1.313034e-04f,  // 8.938
            1.310410e-04f,  // 8.940
            1.307792e-04f,  // 8.942
            1.305179e-04f,  // 8.944
            1.302571e-04f,  // 8.946
            1.299969e-04f,  // 8.948
            1.297372e-04f,  // 8.950
            1.294779e-04f,  // 8.952
            1.292192e-04f,  // 8.954
            1.289611e-04f,  // 8.956
            1.287034e-04f,  // 8.958
            1.284463e-04f,  // 8.960
            1.281896e-04f,  // 8.962
            1.279335e-04f,  // 8.964
            1.276779e-04f,  // 8.966
            1.274228e-04f,  // 8.968
            1.271682e-04f,  // 8.970
            1.269141e-04f,  // 8.972
            1.266605e-04f,  // 8.974
            1.264075e-04f,  // 8.976
            1.261549e-04f,  // 8.978
            1.259028e-04f,  // 8.980
            1.256513e-04f,  // 8.982
            1.254002e-04f,  // 8.984
            1.251497e-04f,  // 8.986
            1.248996e-04f,  // 8.988
            1.246501e-04f,  // 8.990
            1.244010e-04f,  // 8.992
            1.241525e-04f,  // 8.994
            1.239044e-04f,  // 8.996
            1.236569e-04f,  // 8.998
            1.234098e-04f,  // 9.000
            1.231632e-04f,  // 9.002
            1.229172e-04f,  // 9.004
            1.226716e-04f,  // 9.006
            1.224265e-04f,  // 9.008
            1.221819e-04f,  // 9.010
            1.219377e-04f,  // 9.012
            1.216941e-04f,  // 9.014
            1.214510e-04f,  // 9.016
            1.212083e-04f,  // 9.018
            1.209661e-04f,  // 9.020
            1.207244e-04f,  // 9.022
            1.204832e-04f,  // 9.024
            1.202425e-04f,  // 9.026
            1.200023e-04f,  // 9.028
            1.197625e-04f,  // 9.030
            1.195232e-04f,  // 9.032
            1.192844e-04f,  // 9.034
            1.190461e-04f,  // 9.036
            1.188082e-04f,  // 9.038
            1.185708e-04f,  // 9.040
            1.183339e-04f,  // 9.042
            1.180975e-04f,  // 9.044
            1.178615e-04f,  // 9.046
            1.176261e-04f,  // 9.048
            1.173910e-04f,  // 9.050
            1.171565e-04f,  // 9.052
            1.169224e-04f,  // 9.054
            1.166888e-04f,  // 9.056
            1.164557e-04f,  // 9.058
            1.162230e-04f,  // 9.060
            1.159908e-04f,  // 9.062
            1.157590e-04f,  // 9.064
            1.155277e-04f,  // 9.066
            1.152969e-04f,  // 9.068
            1.150665e-04f,  // 9.070
            1.148366e-04f,  // 9.072
            1.146072e-04f,  // 9.074
            1.143782e-04f,  // 9.076
            1.141497e-04f,  // 9.078
            1.139216e-04f,  // 9.080
            1.136940e-04f,  // 9.082
            1.134668e-04f,  // 9.084
            1.132401e-04f,  // 9.086
            1.130139e-04f,  // 9.088
            1.127881e-04f,  // 9.090
            1.125627e-04f,  // 9.092
            1.123378e-04f,  // 9.094
            1.121134e-04f,  // 9.096
            1.118894e-04f,  // 9.098
            1.116658e-04f,  // 9.100
            1.114427e-04f,  // 9.102
            1.112200e-04f,  // 9.104
            1.109978e-04f,  // 9.106
            1.107760e-04f,  // 9.108
            1.105547e-04f,  // 9.110
            1.103338e-04f,  // 9.112
            1.101134e-04f,  // 9.114
            1.098934e-04f,  // 9.116
            1.096738e-04f,  // 9.118
            1.094547e-04f,  // 9.120
            1.092360e-04f,  // 9.122
            1.090177e-04f,  // 9.124
            1.087999e-04f,  // 9.126
            1.085825e-04f,  // 9.128
            1.083656e-04f,  // 9.130
            1.081491e-04f,  // 9.132
            1.079330e-04f,  // 9.134
            1.077173e-04f,  // 9.136
            1.075021e-04f,  // 9.138
            1.072873e-04f,  // 9.140
            1.070730e-04f,  // 9.142
            1.068590e-04f,  // 9.144
            1.066455e-04f,  // 9.146
            1.064325e-04f,  // 9.148
            1.062198e-04f,  // 9.150
            1.060076e-04f,  // 9.152
            1.057958e-04f,  // 9.154
            1.055844e-04f,  // 9.156
            1.053734e-04f,  // 9.158
            1.051629e-04f,  // 9.160
            1.049528e-04f,  // 9.162
            1.047431e-04f,  // 9.164
            1.045338e-04f,  // 9.166
            1.043250e-04f,  // 9.168
            1.041165e-04f,  // 9.170
            1.039085e-04f,  // 9.172
            1.037009e-04f,  // 9.174
            1.034937e-04f,  // 9.176
            1.032869e-04f,  // 9.178
            1.030805e-04f,  // 9.180
            1.028746e-04f,  // 9.182
            1.026690e-04f,  // 9.184
            1.024639e-04f,  // 9.186
            1.022592e-04f,  // 9.188
            1.020549e-04f,  // 9.190
            1.018510e-04f,  // 9.192
            1.016475e-04f,  // 9.194
            1.014444e-04f,  // 9.196
            1.012417e-04f,  // 9.198
            1.010394e-04f,  // 9.200
            1.008375e-04f,  // 9.202
            1.006361e-04f,  // 9.204
            1.004350e-04f,  // 9.206
            1.002343e-04f,  // 9.208
            1.000340e-04f,  // 9.210
            9.983417e-05f,  // 9.212
            9.963471e-05f,  // 9.214
            9.943564e-05f,  // 9.216
            9.923696e-05f,  // 9.218
            9.903869e-05f,  // 9.220
            9.884081e-05f,  // 9.222
            9.864332e-05f,  // 9.224
            9.844623e-05f,  // 9.226
            9.824954e-05f,  // 9.228
            9.805324e-05f,  // 9.230
            9.785733e-05f,  // 9.232
            9.766181e-05f,  // 9.234
            9.746668e-05f,  // 9.236
            9.727194e-05f,  // 9.238
            9.707759e-05f,  // 9.240
            9.688363e-05f,  // 9.242
            9.669006e-05f,  // 9.244
            9.649687e-05f,  // 9.246
            9.630407e-05f,  // 9.248
            9.611165e-05f,  // 9.250
            9.591962e-05f,  // 9.252
            9.572797e-05f,  // 9.254
            9.553671e-05f,  // 9.256
            9.534583e-05f,  // 9.258
            9.515533e-05f,  // 9.260
            9.496520e-05f,  // 9.262
            9.477546e-05f,  // 9.264
            9.458610e-05f,  // 9.266
            9.439712e-05f,  // 9.268
            9.420851e-05f,  // 9.270
            9.402029e-05f,  // 9.272
            9.383243e-05f,  // 9.274
            9.364496e-05f,  // 9.276
            9.345785e-05f,  // 9.278
            9.327112e-05f,  // 9.280
            9.308477e-05f,  // 9.282
            9.289878e-05f,  // 9.284
            9.271317e-05f,  // 9.286
            9.252793e-05f,  // 9.288
            9.234306e-05f,  // 9.290
            9.215856e-05f,  // 9.292
            9.197443e-05f,  // 9.294
            9.179066e-05f,  // 9.296
            9.160726e-05f,  // 9.298
            9.142423e-05f,  // 9.300
            9.124157e-05f,  // 9.302
            9.105926e-05f,  // 9.304
            9.087733e-05f,  // 9.306
            9.069576e-05f,  // 9.308
            9.051455e-05f,  // 9.310
            9.033370e-05f,  // 9.312
            9.015321e-05f,  // 9.314
            8.997308e-05f,  // 9.316
            8.979332e-05f,  // 9.318
            8.961391e-05f,  // 9.320
            8.943486e-05f,  // 9.322
            8.925617e-05f,  // 9.324
            8.907784e-05f,  // 9.326
            8.889986e-05f,  // 9.328
            8.872224e-05f,  // 9.330
            8.854497e-05f,  // 9.332
            8.836806e-05f,  // 9.334
            8.819150e-05f,  // 9.336
            8.801529e-05f,  // 9.338
            8.783944e-05f,  // 9.340
            8.766393e-05f,  // 9.342
            8.748878e-05f,  // 9.344
            8.731398e-05f,  // 9.346
            8.713952e-05f,  // 9.348
            8.696542e-05f,  // 9.350
            8.679166e-05f,  // 9.352
            8.661825e-05f,  // 9.354
            8.644519e-05f,  // 9.356
            8.627247e-05f,  // 9.358
            8.610010e-05f,  // 9.360
            8.592807e-05f,  // 9.362
            8.575639e-05f,  // 9.364
            8.558504e-05f,  // 9.366
            8.541405e-05f,  // 9.368
            8.524339e-05f,  // 9.370
            8.507307e-05f,  // 9.372
            8.490310e-05f,  // 9.374
            8.473346e-05f,  // 9.376
            8.456416e-05f,  // 9.378
            8.439520e-05f,  // 9.380
            8.422658e-05f,  // 9.382
            8.405830e-05f,  // 9.384
            8.389035e-05f,  // 9.386
            8.372273e-05f,  // 9.388
            8.355546e-05f,  // 9.390
            8.338851e-05f,  // 9.392
            8.322190e-05f,  // 9.394
            8.305562e-05f,  // 9.396
            8.288968e-05f,  // 9.398
            8.272407e-05f,  // 9.400
            8.255878e-05f,  // 9.402
            8.239383e-05f,  // 9.404
            8.222921e-05f,  // 9.406
            8.206491e-05f,  // 9.408
            8.190095e-05f,  // 9.410
            8.173731e-05f,  // 9.412
            8.157400e-05f,  // 9.414
            8.141101e-05f,  // 9.416
            8.124835e-05f,  // 9.418
            8.108602e-05f,  // 9.420
            8.092401e-05f,  // 9.422
            8.076232e-05f,  // 9.424
            8.060096e-05f,  // 9.426
            8.043992e-05f,  // 9.428
            8.027920e-05f,  // 9.430
            8.011880e-05f,  // 9.432
            7.995872e-05f,  // 9.434
            7.979897e-05f,  // 9.436
            7.963953e-05f,  // 9.438
            7.948041e-05f,  // 9.440
            7.932161e-05f,  // 9.442
            7.916312e-05f,  // 9.444
            7.900495e-05f,  // 9.446
            7.884710e-05f,  // 9.448
            7.868957e-05f,  // 9.450
            7.853234e-05f,  // 9.452
            7.837544e-05f,  // 9.454
            7.821884e-05f,  // 9.456
            7.806256e-05f,  // 9.458
            7.790659e-05f,  // 9.460
            7.775093e-05f,  // 9.462
            7.759559e-05f,  // 9.464
            7.744055e-05f,  // 9.466
            7.728582e-05f,  // 9.468
            7.713141e-05f,  // 9.470
            7.697730e-05f,  // 9.472
            7.682350e-05f,  // 9.474
            7.667000e-05f,  // 9.476
            7.651682e-05f,  // 9.478
            7.636394e-05f,  // 9.480
            7.621136e-05f,  // 9.482
            7.605909e-05f,  // 9.484
            7.590713e-05f,  // 9.486
            7.575546e-05f,  // 9.488
            7.560410e-05f,  // 9.490
            7.545305e-05f,  // 9.492
            7.530229e-05f,  // 9.494
            7.515184e-05f,  // 9.496
            7.500168e-05f,  // 9.498
            7.485183e-05f,  // 9.500
            7.470228e-05f,  // 9.502
            7.455302e-05f,  // 9.504
            7.440406e-05f,  // 9.506
            7.425540e-05f,  // 9.508
            7.410704e-05f,  // 9.510
            7.395898e-05f,  // 9.512
            7.381121e-05f,  // 9.514
            7.366373e-05f,  // 9.516
            7.351655e-05f,  // 9.518
            7.336966e-05f,  // 9.520
            7.322307e-05f,  // 9.522
            7.307677e-05f,  // 9.524
            7.293076e-05f,  // 9.526
            7.278505e-05f,  // 9.528
            7.263962e-05f,  // 9.530
            7.249449e-05f,  // 9.532
            7.234965e-05f,  // 9.534
            7.220509e-05f,  // 9.536
            7.206083e-05f,  // 9.538
            7.191685e-05f,  // 9.540
            7.177316e-05f,  // 9.542
            7.162975e-05f,  // 9.544
            7.148664e-05f,  // 9.546
            7.134381e-05f,  // 9.548
            7.120126e-05f,  // 9.550
            7.105900e-05f,  // 9.552
            7.091703e-05f,  // 9.554
            7.077533e-05f,  // 9.556
            7.063393e-05f,  // 9.558
            7.049280e-05f,  // 9.560
            7.035195e-05f,  // 9.562
            7.021139e-05f,  // 9.564
            7.007111e-05f,  // 9.566
            6.993111e-05f,  // 9.568
            6.979138e-05f,  // 9.570
            6.965194e-05f,  // 9.572
            6.951278e-05f,  // 9.574
            6.937389e-05f,  // 9.576
            6.923528e-05f,  // 9.578
            6.909695e-05f,  // 9.580
            6.895889e-05f,  // 9.582
            6.882111e-05f,  // 9.584
            6.868361e-05f,  // 9.586
            6.854638e-05f,  // 9.588
            6.840942e-05f,  // 9.590
            6.827274e-05f,  // 9.592
            6.813633e-05f,  // 9.594
            6.800019e-05f,  // 9.596
            6.786433e-05f,  // 9.598
            6.772874e-05f,  // 9.600
            6.759341e-05f,  // 9.602
            6.745836e-05f,  // 9.604
            6.732358e-05f,  // 9.606
            6.718907e-05f,  // 9.608
            6.705482e-05f,  // 9.610
            6.692085e-05f,  // 9.612
            6.678714e-05f,  // 9.614
            6.665370e-05f,  // 9.616
            6.652053e-05f,  // 9.618
            6.638762e-05f,  // 9.620
            6.625498e-05f,  // 9.622
            6.612260e-05f,  // 9.624
            6.599048e-05f,  // 9.626
            6.585864e-05f,  // 9.628
            6.572705e-05f,  // 9.630
            6.559573e-05f,  // 9.632
            6.546467e-05f,  // 9.634
            6.533387e-05f,  // 9.636
            6.520333e-05f,  // 9.638
            6.507305e-05f,  // 9.640
            6.494304e-05f,  // 9.642
            6.481328e-05f,  // 9.644
            6.468379e-05f,  // 9.646
            6.455455e-05f,  // 9.648
            6.442557e-05f,  // 9.650
            6.429684e-05f,  // 9.652
            6.416838e-05f,  // 9.654
            6.404017e-05f,  // 9.656
            6.391222e-05f,  // 9.658
            6.378452e-05f,  // 9.660
            6.365708e-05f,  // 9.662
            6.352989e-05f,  // 9.664
            6.340296e-05f,  // 9.666
            6.327628e-05f,  // 9.668
            6.314986e-05f,  // 9.670
            6.302368e-05f,  // 9.672
            6.289776e-05f,  // 9.674
            6.277209e-05f,  // 9.676
            6.264667e-05f,  // 9.678
            6.252150e-05f,  // 9.680
            6.239659e-05f,  // 9.682
            6.227192e-05f,  // 9.684
            6.214750e-05f,  // 9.686
            6.202333e-05f,  // 9.688
            6.189940e-05f,  // 9.690
            6.177573e-05f,  // 9.692
            6.165230e-05f,  // 9.694
            6.152912e-05f,  // 9.696
            6.140618e-05f,  // 9.698
            6.128350e-05f,  // 9.700
            6.116105e-05f,  // 9.702
            6.103885e-05f,  // 9.704
            6.091689e-05f,  // 9.706
            6.079518e-05f,  // 9.708
            6.067371e-05f,  // 9.710
            6.055249e-05f,  // 9.712
            6.043150e-05f,  // 9.714
            6.031076e-05f,  // 9.716
            6.019026e-05f,  // 9.718
            6.007000e-05f,  // 9.720
            5.994998e-05f,  // 9.722
            5.983020e-05f,  // 9.724
            5.971066e-05f,  // 9.726
            5.959136e-05f,  // 9.728
            5.947229e-05f,  // 9.730
            5.935347e-05f,  // 9.732
            5.923488e-05f,  // 9.734
            5.911653e-05f,  // 9.736
            5.899841e-05f,  // 9.738
            5.888053e-05f,  // 9.740
            5.876289e-05f,  // 9.742
            5.864548e-05f,  // 9.744
            5.852831e-05f,  // 9.746
            5.841137e-05f,  // 9.748
            5.829466e-05f,  // 9.750
            5.817819e-05f,  // 9.752
            5.806195e-05f,  // 9.754
            5.794594e-05f,  // 9.756
            5.783017e-05f,  // 9.758
            5.771462e-05f,  // 9.760
            5.759931e-05f,  // 9.762
            5.748422e-05f,  // 9.764
            5.736937e-05f,  // 9.766
            5.725475e-05f,  // 9.768
            5.714035e-05f,  // 9.770
            5.702619e-05f,  // 9.772
            5.691225e-05f,  // 9.774
            5.679854e-05f,  // 9.776
            5.668505e-05f,  // 9.778
            5.657180e-05f,  // 9.780
            5.645877e-05f,  // 9.782
            5.634596e-05f,  // 9.784
            5.623338e-05f,  // 9.786
            5.612103e-05f,  // 9.788
            5.600890e-05f,  // 9.790
            5.589699e-05f,  // 9.792
            5.578531e-05f,  // 9.794
            5.567385e-05f,  // 9.796
            5.556261e-05f,  // 9.798
            5.545160e-05f,  // 9.800
            5.534081e-05f,  // 9.802
            5.523024e-05f,  // 9.804
            5.511989e-05f,  // 9.806
            5.500976e-05f,  // 9.808
            5.489985e-05f,  // 9.810
            5.479016e-05f,  // 9.812
            5.468069e-05f,  // 9.814
            5.457143e-05f,  // 9.816
            5.446240e-05f,  // 9.818
            5.435358e-05f,  // 9.820
            5.424499e-05f,  // 9.822
            5.413660e-05f,  // 9.824
            5.402844e-05f,  // 9.826
            5.392049e-05f,  // 9.828
            5.381276e-05f,  // 9.830
            5.370524e-05f,  // 9.832
            5.359794e-05f,  // 9.834
            5.349085e-05f,  // 9.836
            5.338397e-05f,  // 9.838
            5.327731e-05f,  // 9.840
            5.317086e-05f,  // 9.842
            5.306463e-05f,  // 9.844
            5.295860e-05f,  // 9.846
            5.285279e-05f,  // 9.848
            5.274719e-05f,  // 9.850
            5.264180e-05f,  // 9.852
            5.253663e-05f,  // 9.854
            5.243166e-05f,  // 9.856
            5.232690e-05f,  // 9.858
            5.222235e-05f,  // 9.860
            5.211801e-05f,  // 9.862
            5.201388e-05f,  // 9.864
            5.190995e-05f,  // 9.866
            5.180624e-05f,  // 9.868
            5.170273e-05f,  // 9.870
            5.159943e-05f,  // 9.872
            5.149633e-05f,  // 9.874
            5.139344e-05f,  // 9.876
            5.129076e-05f,  // 9.878
            5.118828e-05f,  // 9.880
            5.108600e-05f,  // 9.882
            5.098393e-05f,  // 9.884
            5.088207e-05f,  // 9.886
            5.078041e-05f,  // 9.888
            5.067895e-05f,  // 9.890
            5.057769e-05f,  // 9.892
            5.047664e-05f,  // 9.894
            5.037578e-05f,  // 9.896
            5.027513e-05f,  // 9.898
            5.017468e-05f,  // 9.900
            5.007443e-05f,  // 9.902
            4.997438e-05f,  // 9.904
            4.987454e-05f,  // 9.906
            4.977489e-05f,  // 9.908
            4.967544e-05f,  // 9.910
            4.957618e-05f,  // 9.912
            4.947713e-05f,  // 9.914
            4.937828e-05f,  // 9.916
            4.927962e-05f,  // 9.918
            4.918116e-05f,  // 9.920
            4.908289e-05f,  // 9.922
            4.898483e-05f,  // 9.924
            4.888695e-05f,  // 9.926
            4.878928e-05f,  // 9.928
            4.869180e-05f,  // 9.930
            4.859451e-05f,  // 9.932
            4.849742e-05f,  // 9.934
            4.840052e-05f,  // 9.936
            4.830382e-05f,  // 9.938
            4.820730e-05f,  // 9.940
            4.811099e-05f,  // 9.942
            4.801486e-05f,  // 9.944
            4.791893e-05f,  // 9.946
            4.782318e-05f,  // 9.948
            4.772763e-05f,  // 9.950
            4.763227e-05f,  // 9.952
            4.753710e-05f,  // 9.954
            4.744213e-05f,  // 9.956
            4.734734e-05f,  // 9.958
            4.725274e-05f,  // 9.960
            4.715833e-05f,  // 9.962
            4.706410e-05f,  // 9.964
            4.697007e-05f,  // 9.966
            4.687622e-05f,  // 9.968
            4.678256e-05f,  // 9.970
            4.668909e-05f,  // 9.972
            4.659581e-05f,  // 9.974
            4.650271e-05f,  // 9.976
            4.640980e-05f,  // 9.978
            4.631707e-05f,  // 9.980
            4.622453e-05f,  // 9.982
            4.613217e-05f,  // 9.984
            4.604000e-05f,  // 9.986
            4.594801e-05f,  // 9.988
            4.585621e-05f,  // 9.990
            4.576459e-05f,  // 9.992
            4.567315e-05f,  // 9.994
            4.558189e-05f,  // 9.996
            4.549082e-05f,  // 9.998
            4.539993e-05f,  // 10.000
/*
            4.530922e-05f,  // 10.002
            4.521869e-05f,  // 10.004
            4.512835e-05f,  // 10.006
            4.503818e-05f,  // 10.008
            4.494819e-05f,  // 10.010
            4.485839e-05f,  // 10.012
            4.476876e-05f,  // 10.014
            4.467931e-05f,  // 10.016
            4.459004e-05f,  // 10.018
            4.450095e-05f,  // 10.020
            4.441204e-05f,  // 10.022
            4.432330e-05f,  // 10.024
            4.423474e-05f,  // 10.026
            4.414636e-05f,  // 10.028
            4.405816e-05f,  // 10.030
            4.397013e-05f,  // 10.032
            4.388228e-05f,  // 10.034
            4.379460e-05f,  // 10.036
            4.370710e-05f,  // 10.038
            4.361977e-05f,  // 10.040
            4.353262e-05f,  // 10.042
            4.344564e-05f,  // 10.044
            4.335884e-05f,  // 10.046
            4.327221e-05f,  // 10.048
            4.318575e-05f,  // 10.050
            4.309946e-05f,  // 10.052
            4.301335e-05f,  // 10.054
            4.292741e-05f,  // 10.056
            4.284164e-05f,  // 10.058
            4.275604e-05f,  // 10.060
            4.267062e-05f,  // 10.062
            4.258536e-05f,  // 10.064
            4.250028e-05f,  // 10.066
            4.241536e-05f,  // 10.068
            4.233061e-05f,  // 10.070
            4.224604e-05f,  // 10.072
            4.216163e-05f,  // 10.074
            4.207739e-05f,  // 10.076
            4.199332e-05f,  // 10.078
            4.190942e-05f,  // 10.080
            4.182568e-05f,  // 10.082
            4.174211e-05f,  // 10.084
            4.165871e-05f,  // 10.086
            4.157548e-05f,  // 10.088
            4.149241e-05f,  // 10.090
            4.140951e-05f,  // 10.092
            4.132677e-05f,  // 10.094
            4.124420e-05f,  // 10.096
            4.116180e-05f,  // 10.098
            4.107956e-05f,  // 10.100
            4.099748e-05f,  // 10.102
            4.091557e-05f,  // 10.104
            4.083382e-05f,  // 10.106
            4.075223e-05f,  // 10.108
            4.067081e-05f,  // 10.110
            4.058955e-05f,  // 10.112
            4.050845e-05f,  // 10.114
            4.042751e-05f,  // 10.116
            4.034674e-05f,  // 10.118
            4.026613e-05f,  // 10.120
            4.018567e-05f,  // 10.122
            4.010538e-05f,  // 10.124
            4.002525e-05f,  // 10.126
            3.994528e-05f,  // 10.128
            3.986547e-05f,  // 10.130
            3.978582e-05f,  // 10.132
            3.970633e-05f,  // 10.134
            3.962699e-05f,  // 10.136
            3.954782e-05f,  // 10.138
            3.946880e-05f,  // 10.140
            3.938994e-05f,  // 10.142
            3.931124e-05f,  // 10.144
            3.923270e-05f,  // 10.146
            3.915431e-05f,  // 10.148
            3.907608e-05f,  // 10.150
            3.899801e-05f,  // 10.152
            3.892009e-05f,  // 10.154
            3.884233e-05f,  // 10.156
            3.876472e-05f,  // 10.158
            3.868727e-05f,  // 10.160
            3.860997e-05f,  // 10.162
            3.853283e-05f,  // 10.164
            3.845584e-05f,  // 10.166
            3.837900e-05f,  // 10.168
            3.830232e-05f,  // 10.170
            3.822580e-05f,  // 10.172
            3.814942e-05f,  // 10.174
            3.807320e-05f,  // 10.176
            3.799713e-05f,  // 10.178
            3.792121e-05f,  // 10.180
            3.784544e-05f,  // 10.182
            3.776983e-05f,  // 10.184
            3.769436e-05f,  // 10.186
            3.761905e-05f,  // 10.188
            3.754389e-05f,  // 10.190
            3.746887e-05f,  // 10.192
            3.739401e-05f,  // 10.194
            3.731930e-05f,  // 10.196
            3.724473e-05f,  // 10.198
            3.717032e-05f,  // 10.200
            3.709605e-05f,  // 10.202
            3.702193e-05f,  // 10.204
            3.694796e-05f,  // 10.206
            3.687414e-05f,  // 10.208
            3.680047e-05f,  // 10.210
            3.672694e-05f,  // 10.212
            3.665356e-05f,  // 10.214
            3.658033e-05f,  // 10.216
            3.650724e-05f,  // 10.218
            3.643430e-05f,  // 10.220
            3.636150e-05f,  // 10.222
            3.628885e-05f,  // 10.224
            3.621635e-05f,  // 10.226
            3.614399e-05f,  // 10.228
            3.607177e-05f,  // 10.230
            3.599970e-05f,  // 10.232
            3.592777e-05f,  // 10.234
            3.585599e-05f,  // 10.236
            3.578435e-05f,  // 10.238
            3.571285e-05f,  // 10.240
            3.564150e-05f,  // 10.242
            3.557028e-05f,  // 10.244
            3.549921e-05f,  // 10.246
            3.542829e-05f,  // 10.248
            3.535750e-05f,  // 10.250
            3.528686e-05f,  // 10.252
            3.521635e-05f,  // 10.254
            3.514599e-05f,  // 10.256
            3.507577e-05f,  // 10.258
            3.500569e-05f,  // 10.260
            3.493575e-05f,  // 10.262
            3.486594e-05f,  // 10.264
            3.479628e-05f,  // 10.266
            3.472676e-05f,  // 10.268
            3.465738e-05f,  // 10.270
            3.458813e-05f,  // 10.272
            3.451902e-05f,  // 10.274
            3.445005e-05f,  // 10.276
            3.438122e-05f,  // 10.278
            3.431253e-05f,  // 10.280
            3.424397e-05f,  // 10.282
            3.417555e-05f,  // 10.284
            3.410727e-05f,  // 10.286
            3.403912e-05f,  // 10.288
            3.397111e-05f,  // 10.290
            3.390324e-05f,  // 10.292
            3.383550e-05f,  // 10.294
            3.376790e-05f,  // 10.296
            3.370043e-05f,  // 10.298
            3.363310e-05f,  // 10.300
            3.356590e-05f,  // 10.302
            3.349883e-05f,  // 10.304
            3.343190e-05f,  // 10.306
            3.336510e-05f,  // 10.308
            3.329844e-05f,  // 10.310
            3.323191e-05f,  // 10.312
            3.316551e-05f,  // 10.314
            3.309925e-05f,  // 10.316
            3.303312e-05f,  // 10.318
            3.296712e-05f,  // 10.320
            3.290125e-05f,  // 10.322
            3.283551e-05f,  // 10.324
            3.276990e-05f,  // 10.326
            3.270443e-05f,  // 10.328
            3.263909e-05f,  // 10.330
            3.257387e-05f,  // 10.332
            3.250879e-05f,  // 10.334
            3.244384e-05f,  // 10.336
            3.237902e-05f,  // 10.338
            3.231432e-05f,  // 10.340
            3.224976e-05f,  // 10.342
            3.218532e-05f,  // 10.344
            3.212102e-05f,  // 10.346
            3.205684e-05f,  // 10.348
            3.199279e-05f,  // 10.350
            3.192887e-05f,  // 10.352
            3.186507e-05f,  // 10.354
            3.180141e-05f,  // 10.356
            3.173787e-05f,  // 10.358
            3.167446e-05f,  // 10.360
            3.161117e-05f,  // 10.362
            3.154801e-05f,  // 10.364
            3.148498e-05f,  // 10.366
            3.142207e-05f,  // 10.368
            3.135929e-05f,  // 10.370
            3.129663e-05f,  // 10.372
            3.123410e-05f,  // 10.374
            3.117170e-05f,  // 10.376
            3.110942e-05f,  // 10.378
            3.104726e-05f,  // 10.380
            3.098523e-05f,  // 10.382
            3.092332e-05f,  // 10.384
            3.086153e-05f,  // 10.386
            3.079987e-05f,  // 10.388
            3.073833e-05f,  // 10.390
            3.067692e-05f,  // 10.392
            3.061563e-05f,  // 10.394
            3.055446e-05f,  // 10.396
            3.049341e-05f,  // 10.398
            3.043248e-05f,  // 10.400
            3.037168e-05f,  // 10.402
            3.031100e-05f,  // 10.404
            3.025043e-05f,  // 10.406
            3.018999e-05f,  // 10.408
            3.012967e-05f,  // 10.410
            3.006948e-05f,  // 10.412
            3.000940e-05f,  // 10.414
            2.994944e-05f,  // 10.416
            2.988960e-05f,  // 10.418
            2.982988e-05f,  // 10.420
            2.977028e-05f,  // 10.422
            2.971080e-05f,  // 10.424
            2.965144e-05f,  // 10.426
            2.959219e-05f,  // 10.428
            2.953307e-05f,  // 10.430
            2.947406e-05f,  // 10.432
            2.941517e-05f,  // 10.434
            2.935640e-05f,  // 10.436
            2.929775e-05f,  // 10.438
            2.923921e-05f,  // 10.440
            2.918079e-05f,  // 10.442
            2.912249e-05f,  // 10.444
            2.906430e-05f,  // 10.446
            2.900623e-05f,  // 10.448
            2.894827e-05f,  // 10.450
            2.889043e-05f,  // 10.452
            2.883271e-05f,  // 10.454
            2.877510e-05f,  // 10.456
            2.871761e-05f,  // 10.458
            2.866023e-05f,  // 10.460
            2.860297e-05f,  // 10.462
            2.854582e-05f,  // 10.464
            2.848879e-05f,  // 10.466
            2.843187e-05f,  // 10.468
            2.837506e-05f,  // 10.470
            2.831837e-05f,  // 10.472
            2.826179e-05f,  // 10.474
            2.820532e-05f,  // 10.476
            2.814896e-05f,  // 10.478
            2.809272e-05f,  // 10.480
            2.803659e-05f,  // 10.482
            2.798058e-05f,  // 10.484
            2.792467e-05f,  // 10.486
            2.786888e-05f,  // 10.488
            2.781320e-05f,  // 10.490
            2.775762e-05f,  // 10.492
            2.770216e-05f,  // 10.494
            2.764682e-05f,  // 10.496
            2.759158e-05f,  // 10.498
            2.753645e-05f,  // 10.500
            2.748143e-05f,  // 10.502
            2.742652e-05f,  // 10.504
            2.737173e-05f,  // 10.506
            2.731704e-05f,  // 10.508
            2.726246e-05f,  // 10.510
            2.720799e-05f,  // 10.512
            2.715363e-05f,  // 10.514
            2.709937e-05f,  // 10.516
            2.704523e-05f,  // 10.518
            2.699119e-05f,  // 10.520
            2.693726e-05f,  // 10.522
            2.688344e-05f,  // 10.524
            2.682973e-05f,  // 10.526
            2.677612e-05f,  // 10.528
            2.672262e-05f,  // 10.530
            2.666923e-05f,  // 10.532
            2.661595e-05f,  // 10.534
            2.656277e-05f,  // 10.536
            2.650970e-05f,  // 10.538
            2.645673e-05f,  // 10.540
            2.640387e-05f,  // 10.542
            2.635111e-05f,  // 10.544
            2.629846e-05f,  // 10.546
            2.624592e-05f,  // 10.548
            2.619348e-05f,  // 10.550
            2.614115e-05f,  // 10.552
            2.608892e-05f,  // 10.554
            2.603679e-05f,  // 10.556
            2.598477e-05f,  // 10.558
            2.593285e-05f,  // 10.560
            2.588104e-05f,  // 10.562
            2.582933e-05f,  // 10.564
            2.577772e-05f,  // 10.566
            2.572622e-05f,  // 10.568
            2.567482e-05f,  // 10.570
            2.562352e-05f,  // 10.572
            2.557232e-05f,  // 10.574
            2.552123e-05f,  // 10.576
            2.547024e-05f,  // 10.578
            2.541935e-05f,  // 10.580
            2.536856e-05f,  // 10.582
            2.531787e-05f,  // 10.584
            2.526729e-05f,  // 10.586
            2.521680e-05f,  // 10.588
            2.516642e-05f,  // 10.590
            2.511614e-05f,  // 10.592
            2.506596e-05f,  // 10.594
            2.501587e-05f,  // 10.596
            2.496589e-05f,  // 10.598
            2.491601e-05f,  // 10.600
            2.486623e-05f,  // 10.602
            2.481654e-05f,  // 10.604
            2.476696e-05f,  // 10.606
            2.471748e-05f,  // 10.608
            2.466809e-05f,  // 10.610
            2.461880e-05f,  // 10.612
            2.456962e-05f,  // 10.614
            2.452053e-05f,  // 10.616
            2.447153e-05f,  // 10.618
            2.442264e-05f,  // 10.620
            2.437384e-05f,  // 10.622
            2.432514e-05f,  // 10.624
            2.427654e-05f,  // 10.626
            2.422804e-05f,  // 10.628
            2.417963e-05f,  // 10.630
            2.413132e-05f,  // 10.632
            2.408311e-05f,  // 10.634
            2.403499e-05f,  // 10.636
            2.398697e-05f,  // 10.638
            2.393904e-05f,  // 10.640
            2.389121e-05f,  // 10.642
            2.384347e-05f,  // 10.644
            2.379583e-05f,  // 10.646
            2.374829e-05f,  // 10.648
            2.370084e-05f,  // 10.650
            2.365349e-05f,  // 10.652
            2.360623e-05f,  // 10.654
            2.355906e-05f,  // 10.656
            2.351199e-05f,  // 10.658
            2.346501e-05f,  // 10.660
            2.341813e-05f,  // 10.662
            2.337134e-05f,  // 10.664
            2.332465e-05f,  // 10.666
            2.327804e-05f,  // 10.668
            2.323153e-05f,  // 10.670
            2.318512e-05f,  // 10.672
            2.313879e-05f,  // 10.674
            2.309256e-05f,  // 10.676
            2.304642e-05f,  // 10.678
            2.300038e-05f,  // 10.680
            2.295442e-05f,  // 10.682
            2.290856e-05f,  // 10.684
            2.286279e-05f,  // 10.686
            2.281711e-05f,  // 10.688
            2.277152e-05f,  // 10.690
            2.272602e-05f,  // 10.692
            2.268061e-05f,  // 10.694
            2.263530e-05f,  // 10.696
            2.259007e-05f,  // 10.698
            2.254494e-05f,  // 10.700
            2.249989e-05f,  // 10.702
            2.245494e-05f,  // 10.704
            2.241007e-05f,  // 10.706
            2.236530e-05f,  // 10.708
            2.232061e-05f,  // 10.710
            2.227602e-05f,  // 10.712
            2.223151e-05f,  // 10.714
            2.218709e-05f,  // 10.716
            2.214276e-05f,  // 10.718
            2.209852e-05f,  // 10.720
            2.205437e-05f,  // 10.722
            2.201030e-05f,  // 10.724
            2.196632e-05f,  // 10.726
            2.192244e-05f,  // 10.728
            2.187863e-05f,  // 10.730
            2.183492e-05f,  // 10.732
            2.179129e-05f,  // 10.734
            2.174776e-05f,  // 10.736
            2.170430e-05f,  // 10.738
            2.166094e-05f,  // 10.740
            2.161766e-05f,  // 10.742
            2.157447e-05f,  // 10.744
            2.153136e-05f,  // 10.746
            2.148834e-05f,  // 10.748
            2.144541e-05f,  // 10.750
            2.140256e-05f,  // 10.752
            2.135980e-05f,  // 10.754
            2.131712e-05f,  // 10.756
            2.127453e-05f,  // 10.758
            2.123202e-05f,  // 10.760
            2.118960e-05f,  // 10.762
            2.114726e-05f,  // 10.764
            2.110501e-05f,  // 10.766
            2.106284e-05f,  // 10.768
            2.102076e-05f,  // 10.770
            2.097876e-05f,  // 10.772
            2.093685e-05f,  // 10.774
            2.089501e-05f,  // 10.776
            2.085327e-05f,  // 10.778
            2.081160e-05f,  // 10.780
            2.077002e-05f,  // 10.782
            2.072852e-05f,  // 10.784
            2.068710e-05f,  // 10.786
            2.064577e-05f,  // 10.788
            2.060452e-05f,  // 10.790
            2.056335e-05f,  // 10.792
            2.052227e-05f,  // 10.794
            2.048126e-05f,  // 10.796
            2.044034e-05f,  // 10.798
            2.039950e-05f,  // 10.800
            2.035875e-05f,  // 10.802
            2.031807e-05f,  // 10.804
            2.027747e-05f,  // 10.806
            2.023696e-05f,  // 10.808
            2.019652e-05f,  // 10.810
            2.015617e-05f,  // 10.812
            2.011590e-05f,  // 10.814
            2.007571e-05f,  // 10.816
            2.003560e-05f,  // 10.818
            1.999557e-05f,  // 10.820
            1.995562e-05f,  // 10.822
            1.991574e-05f,  // 10.824
            1.987595e-05f,  // 10.826
            1.983624e-05f,  // 10.828
            1.979661e-05f,  // 10.830
            1.975705e-05f,  // 10.832
            1.971758e-05f,  // 10.834
            1.967818e-05f,  // 10.836
            1.963887e-05f,  // 10.838
            1.959963e-05f,  // 10.840
            1.956047e-05f,  // 10.842
            1.952139e-05f,  // 10.844
            1.948238e-05f,  // 10.846
            1.944346e-05f,  // 10.848
            1.940461e-05f,  // 10.850
            1.936584e-05f,  // 10.852
            1.932714e-05f,  // 10.854
            1.928853e-05f,  // 10.856
            1.924999e-05f,  // 10.858
            1.921153e-05f,  // 10.860
            1.917314e-05f,  // 10.862
            1.913484e-05f,  // 10.864
            1.909660e-05f,  // 10.866
            1.905845e-05f,  // 10.868
            1.902037e-05f,  // 10.870
            1.898237e-05f,  // 10.872
            1.894444e-05f,  // 10.874
            1.890659e-05f,  // 10.876
            1.886881e-05f,  // 10.878
            1.883112e-05f,  // 10.880
            1.879349e-05f,  // 10.882
            1.875594e-05f,  // 10.884
            1.871847e-05f,  // 10.886
            1.868107e-05f,  // 10.888
            1.864374e-05f,  // 10.890
            1.860649e-05f,  // 10.892
            1.856932e-05f,  // 10.894
            1.853221e-05f,  // 10.896
            1.849519e-05f,  // 10.898
            1.845823e-05f,  // 10.900
            1.842135e-05f,  // 10.902
            1.838455e-05f,  // 10.904
            1.834782e-05f,  // 10.906
            1.831116e-05f,  // 10.908
            1.827457e-05f,  // 10.910
            1.823806e-05f,  // 10.912
            1.820162e-05f,  // 10.914
            1.816525e-05f,  // 10.916
            1.812896e-05f,  // 10.918
            1.809274e-05f,  // 10.920
            1.805659e-05f,  // 10.922
            1.802051e-05f,  // 10.924
            1.798451e-05f,  // 10.926
            1.794857e-05f,  // 10.928
            1.791271e-05f,  // 10.930
            1.787692e-05f,  // 10.932
            1.784120e-05f,  // 10.934
            1.780556e-05f,  // 10.936
            1.776998e-05f,  // 10.938
            1.773448e-05f,  // 10.940
            1.769904e-05f,  // 10.942
            1.766368e-05f,  // 10.944
            1.762839e-05f,  // 10.946
            1.759317e-05f,  // 10.948
            1.755802e-05f,  // 10.950
            1.752293e-05f,  // 10.952
            1.748792e-05f,  // 10.954
            1.745298e-05f,  // 10.956
            1.741811e-05f,  // 10.958
            1.738331e-05f,  // 10.960
            1.734858e-05f,  // 10.962
            1.731392e-05f,  // 10.964
            1.727932e-05f,  // 10.966
            1.724480e-05f,  // 10.968
            1.721034e-05f,  // 10.970
            1.717596e-05f,  // 10.972
            1.714164e-05f,  // 10.974
            1.710739e-05f,  // 10.976
            1.707321e-05f,  // 10.978
            1.703910e-05f,  // 10.980
            1.700505e-05f,  // 10.982
            1.697108e-05f,  // 10.984
            1.693717e-05f,  // 10.986
            1.690333e-05f,  // 10.988
            1.686956e-05f,  // 10.990
            1.683585e-05f,  // 10.992
            1.680221e-05f,  // 10.994
            1.676864e-05f,  // 10.996
            1.673514e-05f,  // 10.998
            1.670170e-05f,  // 11.000
            1.666833e-05f,  // 11.002
            1.663503e-05f,  // 11.004
            1.660179e-05f,  // 11.006
            1.656862e-05f,  // 11.008
            1.653552e-05f,  // 11.010
            1.650248e-05f,  // 11.012
            1.646951e-05f,  // 11.014
            1.643660e-05f,  // 11.016
            1.640376e-05f,  // 11.018
            1.637098e-05f,  // 11.020
            1.633828e-05f,  // 11.022
            1.630563e-05f,  // 11.024
            1.627305e-05f,  // 11.026
            1.624054e-05f,  // 11.028
            1.620809e-05f,  // 11.030
            1.617571e-05f,  // 11.032
            1.614339e-05f,  // 11.034
            1.611113e-05f,  // 11.036
            1.607894e-05f,  // 11.038
            1.604682e-05f,  // 11.040
            1.601476e-05f,  // 11.042
            1.598276e-05f,  // 11.044
            1.595083e-05f,  // 11.046
            1.591896e-05f,  // 11.048
            1.588715e-05f,  // 11.050
            1.585541e-05f,  // 11.052
            1.582373e-05f,  // 11.054
            1.579211e-05f,  // 11.056
            1.576056e-05f,  // 11.058
            1.572907e-05f,  // 11.060
            1.569764e-05f,  // 11.062
            1.566628e-05f,  // 11.064
            1.563498e-05f,  // 11.066
            1.560374e-05f,  // 11.068
            1.557256e-05f,  // 11.070
            1.554145e-05f,  // 11.072
            1.551040e-05f,  // 11.074
            1.547941e-05f,  // 11.076
            1.544848e-05f,  // 11.078
            1.541761e-05f,  // 11.080
            1.538681e-05f,  // 11.082
            1.535607e-05f,  // 11.084
            1.532538e-05f,  // 11.086
            1.529476e-05f,  // 11.088
            1.526421e-05f,  // 11.090
            1.523371e-05f,  // 11.092
            1.520327e-05f,  // 11.094
            1.517289e-05f,  // 11.096
            1.514258e-05f,  // 11.098
            1.511232e-05f,  // 11.100
            1.508213e-05f,  // 11.102
            1.505200e-05f,  // 11.104
            1.502192e-05f,  // 11.106
            1.499191e-05f,  // 11.108
            1.496195e-05f,  // 11.110
            1.493206e-05f,  // 11.112
            1.490223e-05f,  // 11.114
            1.487245e-05f,  // 11.116
            1.484274e-05f,  // 11.118
            1.481308e-05f,  // 11.120
            1.478348e-05f,  // 11.122
            1.475395e-05f,  // 11.124
            1.472447e-05f,  // 11.126
            1.469505e-05f,  // 11.128
            1.466569e-05f,  // 11.130
            1.463639e-05f,  // 11.132
            1.460714e-05f,  // 11.134
            1.457796e-05f,  // 11.136
            1.454883e-05f,  // 11.138
            1.451976e-05f,  // 11.140
            1.449075e-05f,  // 11.142
            1.446180e-05f,  // 11.144
            1.443290e-05f,  // 11.146
            1.440407e-05f,  // 11.148
            1.437529e-05f,  // 11.150
            1.434657e-05f,  // 11.152
            1.431790e-05f,  // 11.154
            1.428929e-05f,  // 11.156
            1.426074e-05f,  // 11.158
            1.423225e-05f,  // 11.160
            1.420381e-05f,  // 11.162
            1.417544e-05f,  // 11.164
            1.414711e-05f,  // 11.166
            1.411885e-05f,  // 11.168
            1.409064e-05f,  // 11.170
            1.406248e-05f,  // 11.172
            1.403439e-05f,  // 11.174
            1.400635e-05f,  // 11.176
            1.397836e-05f,  // 11.178
            1.395043e-05f,  // 11.180
            1.392256e-05f,  // 11.182
            1.389474e-05f,  // 11.184
            1.386698e-05f,  // 11.186
            1.383927e-05f,  // 11.188
            1.381162e-05f,  // 11.190
            1.378403e-05f,  // 11.192
            1.375649e-05f,  // 11.194
            1.372900e-05f,  // 11.196
            1.370157e-05f,  // 11.198
            1.367420e-05f,  // 11.200
            1.364688e-05f,  // 11.202
            1.361961e-05f,  // 11.204
            1.359240e-05f,  // 11.206
            1.356524e-05f,  // 11.208
            1.353814e-05f,  // 11.210
            1.351109e-05f,  // 11.212
            1.348409e-05f,  // 11.214
            1.345715e-05f,  // 11.216
            1.343026e-05f,  // 11.218
            1.340343e-05f,  // 11.220
            1.337665e-05f,  // 11.222
            1.334992e-05f,  // 11.224
            1.332325e-05f,  // 11.226
            1.329663e-05f,  // 11.228
            1.327006e-05f,  // 11.230
            1.324355e-05f,  // 11.232
            1.321709e-05f,  // 11.234
            1.319068e-05f,  // 11.236
            1.316433e-05f,  // 11.238
            1.313802e-05f,  // 11.240
            1.311177e-05f,  // 11.242
            1.308558e-05f,  // 11.244
            1.305943e-05f,  // 11.246
            1.303334e-05f,  // 11.248
            1.300730e-05f,  // 11.250
            1.298131e-05f,  // 11.252
            1.295537e-05f,  // 11.254
            1.292949e-05f,  // 11.256
            1.290365e-05f,  // 11.258
            1.287787e-05f,  // 11.260
            1.285214e-05f,  // 11.262
            1.282646e-05f,  // 11.264
            1.280084e-05f,  // 11.266
            1.277526e-05f,  // 11.268
            1.274974e-05f,  // 11.270
            1.272426e-05f,  // 11.272
            1.269884e-05f,  // 11.274
            1.267347e-05f,  // 11.276
            1.264814e-05f,  // 11.278
            1.262287e-05f,  // 11.280
            1.259765e-05f,  // 11.282
            1.257248e-05f,  // 11.284
            1.254736e-05f,  // 11.286
            1.252229e-05f,  // 11.288
            1.249727e-05f,  // 11.290
            1.247230e-05f,  // 11.292
            1.244738e-05f,  // 11.294
            1.242252e-05f,  // 11.296
            1.239769e-05f,  // 11.298
            1.237292e-05f,  // 11.300
            1.234820e-05f,  // 11.302
            1.232353e-05f,  // 11.304
            1.229891e-05f,  // 11.306
            1.227434e-05f,  // 11.308
            1.224981e-05f,  // 11.310
            1.222534e-05f,  // 11.312
            1.220091e-05f,  // 11.314
            1.217653e-05f,  // 11.316
            1.215220e-05f,  // 11.318
            1.212792e-05f,  // 11.320
            1.210369e-05f,  // 11.322
            1.207951e-05f,  // 11.324
            1.205537e-05f,  // 11.326
            1.203129e-05f,  // 11.328
            1.200725e-05f,  // 11.330
            1.198326e-05f,  // 11.332
            1.195932e-05f,  // 11.334
            1.193542e-05f,  // 11.336
            1.191157e-05f,  // 11.338
            1.188777e-05f,  // 11.340
            1.186402e-05f,  // 11.342
            1.184032e-05f,  // 11.344
            1.181666e-05f,  // 11.346
            1.179305e-05f,  // 11.348
            1.176949e-05f,  // 11.350
            1.174597e-05f,  // 11.352
            1.172251e-05f,  // 11.354
            1.169908e-05f,  // 11.356
            1.167571e-05f,  // 11.358
            1.165238e-05f,  // 11.360
            1.162910e-05f,  // 11.362
            1.160586e-05f,  // 11.364
            1.158268e-05f,  // 11.366
            1.155953e-05f,  // 11.368
            1.153644e-05f,  // 11.370
            1.151339e-05f,  // 11.372
            1.149038e-05f,  // 11.374
            1.146743e-05f,  // 11.376
            1.144451e-05f,  // 11.378
            1.142165e-05f,  // 11.380
            1.139883e-05f,  // 11.382
            1.137605e-05f,  // 11.384
            1.135332e-05f,  // 11.386
            1.133064e-05f,  // 11.388
            1.130800e-05f,  // 11.390
            1.128541e-05f,  // 11.392
            1.126286e-05f,  // 11.394
            1.124036e-05f,  // 11.396
            1.121790e-05f,  // 11.398
            1.119548e-05f,  // 11.400
            1.117312e-05f,  // 11.402
            1.115079e-05f,  // 11.404
            1.112851e-05f,  // 11.406
            1.110628e-05f,  // 11.408
            1.108409e-05f,  // 11.410
            1.106194e-05f,  // 11.412
            1.103984e-05f,  // 11.414
            1.101778e-05f,  // 11.416
            1.099577e-05f,  // 11.418
            1.097380e-05f,  // 11.420
            1.095187e-05f,  // 11.422
            1.092999e-05f,  // 11.424
            1.090815e-05f,  // 11.426
            1.088636e-05f,  // 11.428
            1.086461e-05f,  // 11.430
            1.084290e-05f,  // 11.432
            1.082124e-05f,  // 11.434
            1.079962e-05f,  // 11.436
            1.077804e-05f,  // 11.438
            1.075650e-05f,  // 11.440
            1.073501e-05f,  // 11.442
            1.071356e-05f,  // 11.444
            1.069216e-05f,  // 11.446
            1.067079e-05f,  // 11.448
            1.064947e-05f,  // 11.450
            1.062820e-05f,  // 11.452
            1.060696e-05f,  // 11.454
            1.058577e-05f,  // 11.456
            1.056462e-05f,  // 11.458
            1.054351e-05f,  // 11.460
            1.052244e-05f,  // 11.462
            1.050142e-05f,  // 11.464
            1.048044e-05f,  // 11.466
            1.045950e-05f,  // 11.468
            1.043860e-05f,  // 11.470
            1.041774e-05f,  // 11.472
            1.039693e-05f,  // 11.474
            1.037616e-05f,  // 11.476
            1.035543e-05f,  // 11.478
            1.033474e-05f,  // 11.480
            1.031409e-05f,  // 11.482
            1.029348e-05f,  // 11.484
            1.027291e-05f,  // 11.486
            1.025239e-05f,  // 11.488
            1.023190e-05f,  // 11.490
            1.021146e-05f,  // 11.492
            1.019106e-05f,  // 11.494
            1.017070e-05f,  // 11.496
            1.015037e-05f,  // 11.498
            1.013009e-05f,  // 11.500
            1.010985e-05f,  // 11.502
            1.008965e-05f,  // 11.504
            1.006950e-05f,  // 11.506
            1.004938e-05f,  // 11.508
            1.002930e-05f,  // 11.510
            1.000926e-05f,  // 11.512
            9.989260e-06f,  // 11.514
            9.969302e-06f,  // 11.516
            9.949383e-06f,  // 11.518
            9.929504e-06f,  // 11.520
            9.909665e-06f,  // 11.522
            9.889866e-06f,  // 11.524
            9.870106e-06f,  // 11.526
            9.850385e-06f,  // 11.528
            9.830704e-06f,  // 11.530
            9.811062e-06f,  // 11.532
            9.791460e-06f,  // 11.534
            9.771896e-06f,  // 11.536
            9.752372e-06f,  // 11.538
            9.732887e-06f,  // 11.540
            9.713441e-06f,  // 11.542
            9.694033e-06f,  // 11.544
            9.674664e-06f,  // 11.546
            9.655334e-06f,  // 11.548
            9.636043e-06f,  // 11.550
            9.616790e-06f,  // 11.552
            9.597576e-06f,  // 11.554
            9.578400e-06f,  // 11.556
            9.559262e-06f,  // 11.558
            9.540163e-06f,  // 11.560
            9.521102e-06f,  // 11.562
            9.502078e-06f,  // 11.564
            9.483093e-06f,  // 11.566
            9.464146e-06f,  // 11.568
            9.445237e-06f,  // 11.570
            9.426365e-06f,  // 11.572
            9.407531e-06f,  // 11.574
            9.388735e-06f,  // 11.576
            9.369976e-06f,  // 11.578
            9.351255e-06f,  // 11.580
            9.332571e-06f,  // 11.582
            9.313925e-06f,  // 11.584
            9.295315e-06f,  // 11.586
            9.276743e-06f,  // 11.588
            9.258208e-06f,  // 11.590
            9.239711e-06f,  // 11.592
            9.221250e-06f,  // 11.594
            9.202826e-06f,  // 11.596
            9.184438e-06f,  // 11.598
            9.166088e-06f,  // 11.600
            9.147774e-06f,  // 11.602
            9.129497e-06f,  // 11.604
            9.111256e-06f,  // 11.606
            9.093052e-06f,  // 11.608
            9.074884e-06f,  // 11.610
            9.056752e-06f,  // 11.612
            9.038657e-06f,  // 11.614
            9.020597e-06f,  // 11.616
            9.002574e-06f,  // 11.618
            8.984587e-06f,  // 11.620
            8.966636e-06f,  // 11.622
            8.948720e-06f,  // 11.624
            8.930841e-06f,  // 11.626
            8.912997e-06f,  // 11.628
            8.895189e-06f,  // 11.630
            8.877416e-06f,  // 11.632
            8.859679e-06f,  // 11.634
            8.841978e-06f,  // 11.636
            8.824311e-06f,  // 11.638
            8.806680e-06f,  // 11.640
            8.789085e-06f,  // 11.642
            8.771524e-06f,  // 11.644
            8.753998e-06f,  // 11.646
            8.736508e-06f,  // 11.648
            8.719052e-06f,  // 11.650
            8.701632e-06f,  // 11.652
            8.684246e-06f,  // 11.654
            8.666895e-06f,  // 11.656
            8.649578e-06f,  // 11.658
            8.632296e-06f,  // 11.660
            8.615049e-06f,  // 11.662
            8.597836e-06f,  // 11.664
            8.580658e-06f,  // 11.666
            8.563513e-06f,  // 11.668
            8.546404e-06f,  // 11.670
            8.529328e-06f,  // 11.672
            8.512286e-06f,  // 11.674
            8.495279e-06f,  // 11.676
            8.478305e-06f,  // 11.678
            8.461365e-06f,  // 11.680
            8.444460e-06f,  // 11.682
            8.427588e-06f,  // 11.684
            8.410749e-06f,  // 11.686
            8.393945e-06f,  // 11.688
            8.377173e-06f,  // 11.690
            8.360436e-06f,  // 11.692
            8.343732e-06f,  // 11.694
            8.327061e-06f,  // 11.696
            8.310423e-06f,  // 11.698
            8.293819e-06f,  // 11.700
            8.277248e-06f,  // 11.702
            8.260710e-06f,  // 11.704
            8.244205e-06f,  // 11.706
            8.227733e-06f,  // 11.708
            8.211294e-06f,  // 11.710
            8.194888e-06f,  // 11.712
            8.178515e-06f,  // 11.714
            8.162174e-06f,  // 11.716
            8.145866e-06f,  // 11.718
            8.129591e-06f,  // 11.720
            8.113348e-06f,  // 11.722
            8.097137e-06f,  // 11.724
            8.080959e-06f,  // 11.726
            8.064813e-06f,  // 11.728
            8.048700e-06f,  // 11.730
            8.032618e-06f,  // 11.732
            8.016569e-06f,  // 11.734
            8.000552e-06f,  // 11.736
            7.984567e-06f,  // 11.738
            7.968614e-06f,  // 11.740
            7.952693e-06f,  // 11.742
            7.936803e-06f,  // 11.744
            7.920945e-06f,  // 11.746
            7.905119e-06f,  // 11.748
            7.889325e-06f,  // 11.750
            7.873562e-06f,  // 11.752
            7.857831e-06f,  // 11.754
            7.842131e-06f,  // 11.756
            7.826462e-06f,  // 11.758
            7.810825e-06f,  // 11.760
            7.795219e-06f,  // 11.762
            7.779644e-06f,  // 11.764
            7.764100e-06f,  // 11.766
            7.748587e-06f,  // 11.768
            7.733106e-06f,  // 11.770
            7.717655e-06f,  // 11.772
            7.702235e-06f,  // 11.774
            7.686846e-06f,  // 11.776
            7.671488e-06f,  // 11.778
            7.656160e-06f,  // 11.780
            7.640863e-06f,  // 11.782
            7.625597e-06f,  // 11.784
            7.610361e-06f,  // 11.786
            7.595155e-06f,  // 11.788
            7.579980e-06f,  // 11.790
            7.564835e-06f,  // 11.792
            7.549721e-06f,  // 11.794
            7.534636e-06f,  // 11.796
            7.519582e-06f,  // 11.798
            7.504558e-06f,  // 11.800
            7.489564e-06f,  // 11.802
            7.474600e-06f,  // 11.804
            7.459665e-06f,  // 11.806
            7.444761e-06f,  // 11.808
            7.429886e-06f,  // 11.810
            7.415041e-06f,  // 11.812
            7.400226e-06f,  // 11.814
            7.385440e-06f,  // 11.816
            7.370684e-06f,  // 11.818
            7.355958e-06f,  // 11.820
            7.341260e-06f,  // 11.822
            7.326593e-06f,  // 11.824
            7.311954e-06f,  // 11.826
            7.297345e-06f,  // 11.828
            7.282765e-06f,  // 11.830
            7.268214e-06f,  // 11.832
            7.253692e-06f,  // 11.834
            7.239199e-06f,  // 11.836
            7.224735e-06f,  // 11.838
            7.210300e-06f,  // 11.840
            7.195894e-06f,  // 11.842
            7.181516e-06f,  // 11.844
            7.167168e-06f,  // 11.846
            7.152848e-06f,  // 11.848
            7.138556e-06f,  // 11.850
            7.124293e-06f,  // 11.852
            7.110059e-06f,  // 11.854
            7.095853e-06f,  // 11.856
            7.081676e-06f,  // 11.858
            7.067526e-06f,  // 11.860
            7.053406e-06f,  // 11.862
            7.039313e-06f,  // 11.864
            7.025248e-06f,  // 11.866
            7.011212e-06f,  // 11.868
            6.997203e-06f,  // 11.870
            6.983223e-06f,  // 11.872
            6.969271e-06f,  // 11.874
            6.955346e-06f,  // 11.876
            6.941449e-06f,  // 11.878
            6.927580e-06f,  // 11.880
            6.913739e-06f,  // 11.882
            6.899925e-06f,  // 11.884
            6.886139e-06f,  // 11.886
            6.872381e-06f,  // 11.888
            6.858650e-06f,  // 11.890
            6.844946e-06f,  // 11.892
            6.831270e-06f,  // 11.894
            6.817621e-06f,  // 11.896
            6.803999e-06f,  // 11.898
            6.790405e-06f,  // 11.900
            6.776838e-06f,  // 11.902
            6.763297e-06f,  // 11.904
            6.749784e-06f,  // 11.906
            6.736298e-06f,  // 11.908
            6.722839e-06f,  // 11.910
            6.709407e-06f,  // 11.912
            6.696002e-06f,  // 11.914
            6.682623e-06f,  // 11.916
            6.669271e-06f,  // 11.918
            6.655946e-06f,  // 11.920
            6.642647e-06f,  // 11.922
            6.629375e-06f,  // 11.924
            6.616130e-06f,  // 11.926
            6.602911e-06f,  // 11.928
            6.589718e-06f,  // 11.930
            6.576552e-06f,  // 11.932
            6.563412e-06f,  // 11.934
            6.550298e-06f,  // 11.936
            6.537211e-06f,  // 11.938
            6.524149e-06f,  // 11.940
            6.511114e-06f,  // 11.942
            6.498105e-06f,  // 11.944
            6.485122e-06f,  // 11.946
            6.472164e-06f,  // 11.948
            6.459233e-06f,  // 11.950
            6.446327e-06f,  // 11.952
            6.433448e-06f,  // 11.954
            6.420593e-06f,  // 11.956
            6.407765e-06f,  // 11.958
            6.394962e-06f,  // 11.960
            6.382185e-06f,  // 11.962
            6.369434e-06f,  // 11.964
            6.356708e-06f,  // 11.966
            6.344007e-06f,  // 11.968
            6.331331e-06f,  // 11.970
            6.318681e-06f,  // 11.972
            6.306057e-06f,  // 11.974
            6.293457e-06f,  // 11.976
            6.280883e-06f,  // 11.978
            6.268334e-06f,  // 11.980
            6.255810e-06f,  // 11.982
            6.243310e-06f,  // 11.984
            6.230836e-06f,  // 11.986
            6.218387e-06f,  // 11.988
            6.205963e-06f,  // 11.990
            6.193563e-06f,  // 11.992
            6.181188e-06f,  // 11.994
            6.168838e-06f,  // 11.996
            6.156513e-06f,  // 11.998
            6.144212e-06f,  // 12.000
*/
            0.0f            // >12.000
        };

}


#endif // ALIGN3D_SHAPE_EXP_LOOKUP_HPP
