/* rygel-cmdline-config.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-cmdline-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2014 Jens Georg <mail@jensge.org>
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *                    <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-core.h"
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <errno.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_CMDLINE_CONFIG_0_PROPERTY,
	RYGEL_CMDLINE_CONFIG_NUM_PROPERTIES
};
static GParamSpec* rygel_cmdline_config_properties[RYGEL_CMDLINE_CONFIG_NUM_PROPERTIES];
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelCmdlineConfigPrivate {
	GVariantDict* options;
};

static gint RygelCmdlineConfig_private_offset;
static gpointer rygel_cmdline_config_parent_class = NULL;
static RygelCmdlineConfig* rygel_cmdline_config_config;
static RygelCmdlineConfig* rygel_cmdline_config_config = NULL;
static RygelConfigurationIface * rygel_cmdline_config_rygel_configuration_parent_iface = NULL;

static gchar* rygel_cmdline_config_real_get_interface (RygelConfiguration* base,
                                                GError** error);
static gchar** rygel_cmdline_config_real_get_interfaces (RygelConfiguration* base,
                                                  GError** error);
static gint rygel_cmdline_config_real_get_port (RygelConfiguration* base,
                                         GError** error);
static gboolean rygel_cmdline_config_real_get_transcoding (RygelConfiguration* base,
                                                    GError** error);
static gboolean rygel_cmdline_config_real_get_allow_upload (RygelConfiguration* base,
                                                     GError** error);
static gboolean rygel_cmdline_config_real_get_allow_deletion (RygelConfiguration* base,
                                                       GError** error);
static gchar* rygel_cmdline_config_real_get_log_levels (RygelConfiguration* base,
                                                 GError** error);
static gchar* rygel_cmdline_config_real_get_plugin_path (RygelConfiguration* base,
                                                  GError** error);
static gchar* rygel_cmdline_config_real_get_engine_path (RygelConfiguration* base,
                                                  GError** error);
static gchar* rygel_cmdline_config_real_get_media_engine (RygelConfiguration* base,
                                                   GError** error);
static gchar** rygel_cmdline_config_get_string_list_from_options (RygelCmdlineConfig* self,
                                                           const gchar* key,
                                                           GError** error);
static gboolean rygel_cmdline_config_real_get_enabled (RygelConfiguration* base,
                                                const gchar* section,
                                                GError** error);
static gchar* rygel_cmdline_config_real_get_title (RygelConfiguration* base,
                                            const gchar* section,
                                            GError** error);
static gchar* rygel_cmdline_config_real_get_video_upload_folder (RygelConfiguration* base,
                                                          GError** error);
static gchar* rygel_cmdline_config_real_get_music_upload_folder (RygelConfiguration* base,
                                                          GError** error);
static gchar* rygel_cmdline_config_real_get_picture_upload_folder (RygelConfiguration* base,
                                                            GError** error);
static gchar* rygel_cmdline_config_real_get_string (RygelConfiguration* base,
                                             const gchar* section,
                                             const gchar* key,
                                             GError** error);
static GeeArrayList* rygel_cmdline_config_real_get_string_list (RygelConfiguration* base,
                                                         const gchar* section,
                                                         const gchar* key,
                                                         GError** error);
static gint rygel_cmdline_config_real_get_int (RygelConfiguration* base,
                                        const gchar* section,
                                        const gchar* key,
                                        gint min,
                                        gint max,
                                        GError** error);
static GeeArrayList* rygel_cmdline_config_real_get_int_list (RygelConfiguration* base,
                                                      const gchar* section,
                                                      const gchar* key,
                                                      GError** error);
static gboolean rygel_cmdline_config_real_get_bool (RygelConfiguration* base,
                                             const gchar* section,
                                             const gchar* key,
                                             GError** error);
static void rygel_cmdline_config_finalize (GObject * obj);
static GType rygel_cmdline_config_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const GOptionEntry RYGEL_CMDLINE_CONFIG_OPTIONS[15] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Display version number"), NULL}, {"network-interface", 'n', (gint) 0, G_OPTION_ARG_STRING_ARRAY, NULL, N_ ("Network Interfaces"), "INTERFACE"}, {"port", 'p', (gint) 0, G_OPTION_ARG_INT, NULL, N_ ("Port"), "PORT"}, {"disable-transcoding", 't', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Disable transcoding"), NULL}, {"disallow-upload", 'U', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Disallow upload"), NULL}, {"disallow-deletion", 'D', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Disallow deletion"), NULL}, {"log-level", 'g', (gint) 0, G_OPTION_ARG_STRING, NULL, N_ ("Comma-separated list of domain:level pairs. See rygel(1) for details")}, {"plugin-path", 'u', (gint) 0, G_OPTION_ARG_STRING, NULL, N_ ("Plugin Path"), "PLUGIN_PATH"}, {"engine-path", 'e', (gint) 0, G_OPTION_ARG_STRING, NULL, N_ ("Engine Path"), "ENGINE_PATH"}, {"disable-plugin", 'd', (gint) 0, G_OPTION_ARG_STRING_ARRAY, NULL, N_ ("Disable plugin"), "PluginName"}, {"title", 'i', (gint) 0, G_OPTION_ARG_STRING_ARRAY, NULL, N_ ("Set plugin titles"), "PluginName:TITLE"}, {"plugin-option", 'o', (gint) 0, G_OPTION_ARG_STRING_ARRAY, NULL, N_ ("Set plugin options"), "PluginName:OPTION:VALUE1[,VALUE2,..]"}, {"config", 'c', (gint) 0, G_OPTION_ARG_FILENAME, NULL, N_ ("Use configuration file instead of user configuration"), "FILE"}, {"shutdown", 's', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Shut down remote Rygel reference"), NULL}, {NULL}};

GQuark
rygel_cmdline_config_error_quark (void)
{
	return g_quark_from_static_string ("rygel-cmdline-config-error-quark");
}

 G_GNUC_NO_INLINE static GType
rygel_cmdline_config_error_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY, "RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY", "version-only"}, {0, NULL, NULL}};
	GType rygel_cmdline_config_error_type_id;
	rygel_cmdline_config_error_type_id = g_enum_register_static ("RygelCmdlineConfigError", values);
	return rygel_cmdline_config_error_type_id;
}

GType
rygel_cmdline_config_error_get_type (void)
{
	static volatile gsize rygel_cmdline_config_error_type_id__once = 0;
	if (g_once_init_enter (&rygel_cmdline_config_error_type_id__once)) {
		GType rygel_cmdline_config_error_type_id;
		rygel_cmdline_config_error_type_id = rygel_cmdline_config_error_get_type_once ();
		g_once_init_leave (&rygel_cmdline_config_error_type_id__once, rygel_cmdline_config_error_type_id);
	}
	return rygel_cmdline_config_error_type_id__once;
}

static inline gpointer
rygel_cmdline_config_get_instance_private (RygelCmdlineConfig* self)
{
	return G_STRUCT_MEMBER_P (self, RygelCmdlineConfig_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RygelCmdlineConfig*
rygel_cmdline_config_get_default (void)
{
	RygelCmdlineConfig* _tmp0_;
	RygelCmdlineConfig* _tmp2_;
	RygelCmdlineConfig* _tmp3_;
	RygelCmdlineConfig* result;
	_tmp0_ = rygel_cmdline_config_config;
	if (_tmp0_ == NULL) {
		RygelCmdlineConfig* _tmp1_;
		_tmp1_ = rygel_cmdline_config_new ();
		_g_object_unref0 (rygel_cmdline_config_config);
		rygel_cmdline_config_config = _tmp1_;
	}
	_tmp2_ = rygel_cmdline_config_config;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gpointer
_g_variant_dict_ref0 (gpointer self)
{
	return self ? g_variant_dict_ref (self) : NULL;
}

void
rygel_cmdline_config_set_options (RygelCmdlineConfig* self,
                                  GVariantDict* args)
{
	GVariantDict* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (args != NULL);
	_tmp0_ = _g_variant_dict_ref0 (args);
	_g_variant_dict_unref0 (self->priv->options);
	self->priv->options = _tmp0_;
}

static gchar*
rygel_cmdline_config_real_get_interface (RygelConfiguration* base,
                                         GError** error)
{
	RygelCmdlineConfig * self;
	gchar** _tmp0_ = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp0__length1;
	gint __tmp0__size_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelCmdlineConfig*) base;
	_tmp2_ = _tmp1_ = rygel_configuration_get_interfaces ((RygelConfiguration*) self, &_inner_error0_);
	_tmp0_ = _tmp2_;
	_tmp0__length1 = _vala_array_length (_tmp1_);
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_[0];
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar**
rygel_cmdline_config_real_get_interfaces (RygelConfiguration* base,
                                          GError** error)
{
	RygelCmdlineConfig * self;
	gchar** ifaces = NULL;
	gint ifaces_length1;
	gint _ifaces_size_;
	GVariantDict* _tmp0_;
	gchar** _tmp1_ = NULL;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar** result;
	self = (RygelCmdlineConfig*) base;
	ifaces = NULL;
	ifaces_length1 = 0;
	_ifaces_size_ = ifaces_length1;
	_tmp0_ = self->priv->options;
	_tmp2_ = g_variant_dict_lookup (_tmp0_, "network-interface", "^as", &_tmp1_, NULL);
	ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
	ifaces = _tmp1_;
	ifaces_length1 = -1;
	_ifaces_size_ = ifaces_length1;
	if (!_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	result = ifaces;
	return result;
}

static gint
rygel_cmdline_config_real_get_port (RygelConfiguration* base,
                                    GError** error)
{
	RygelCmdlineConfig * self;
	gint port = 0;
	GVariantDict* _tmp0_;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (RygelCmdlineConfig*) base;
	port = 0;
	_tmp0_ = self->priv->options;
	_tmp2_ = g_variant_dict_lookup (_tmp0_, "port", "i", &_tmp1_, NULL);
	port = _tmp1_;
	if (!_tmp2_) {
		GError* _tmp3_;
		gint _tmp4_ = -1;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	}
	result = port;
	return result;
}

static gboolean
rygel_cmdline_config_real_get_transcoding (RygelConfiguration* base,
                                           GError** error)
{
	RygelCmdlineConfig * self;
	gboolean val = FALSE;
	GVariantDict* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = self->priv->options;
	_tmp2_ = g_variant_dict_lookup (_tmp0_, "disable-transcoding", "b", &_tmp1_, NULL);
	val = _tmp1_;
	if (!_tmp2_) {
		GError* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	} else {
		result = FALSE;
		return result;
	}
}

static gboolean
rygel_cmdline_config_real_get_allow_upload (RygelConfiguration* base,
                                            GError** error)
{
	RygelCmdlineConfig * self;
	gboolean val = FALSE;
	GVariantDict* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = self->priv->options;
	_tmp2_ = g_variant_dict_lookup (_tmp0_, "disable-transcoding", "b", &_tmp1_, NULL);
	val = _tmp1_;
	if (!_tmp2_) {
		GError* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	} else {
		result = FALSE;
		return result;
	}
}

static gboolean
rygel_cmdline_config_real_get_allow_deletion (RygelConfiguration* base,
                                              GError** error)
{
	RygelCmdlineConfig * self;
	gboolean val = FALSE;
	GVariantDict* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = self->priv->options;
	_tmp2_ = g_variant_dict_lookup (_tmp0_, "disable-transcoding", "b", &_tmp1_, NULL);
	val = _tmp1_;
	if (!_tmp2_) {
		GError* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	} else {
		result = FALSE;
		return result;
	}
}

static gchar*
rygel_cmdline_config_real_get_log_levels (RygelConfiguration* base,
                                          GError** error)
{
	RygelCmdlineConfig * self;
	const gchar* log_levels = NULL;
	GVariantDict* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelCmdlineConfig*) base;
	log_levels = NULL;
	_tmp0_ = self->priv->options;
	_tmp2_ = g_variant_dict_lookup (_tmp0_, "log-level", "&s", &_tmp1_, NULL);
	log_levels = _tmp1_;
	if (!_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = log_levels;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}

static gchar*
rygel_cmdline_config_real_get_plugin_path (RygelConfiguration* base,
                                           GError** error)
{
	RygelCmdlineConfig * self;
	const gchar* plugin_path = NULL;
	GVariantDict* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelCmdlineConfig*) base;
	plugin_path = NULL;
	_tmp0_ = self->priv->options;
	_tmp2_ = g_variant_dict_lookup (_tmp0_, "plugin-path", "&s", &_tmp1_, NULL);
	plugin_path = _tmp1_;
	if (!_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = plugin_path;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}

static gchar*
rygel_cmdline_config_real_get_engine_path (RygelConfiguration* base,
                                           GError** error)
{
	RygelCmdlineConfig * self;
	const gchar* engine_path = NULL;
	GVariantDict* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelCmdlineConfig*) base;
	engine_path = NULL;
	_tmp0_ = self->priv->options;
	_tmp2_ = g_variant_dict_lookup (_tmp0_, "engine-path", "&s", &_tmp1_, NULL);
	engine_path = _tmp1_;
	if (!_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = engine_path;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}

static gchar*
rygel_cmdline_config_real_get_media_engine (RygelConfiguration* base,
                                            GError** error)
{
	RygelCmdlineConfig * self;
	GError* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
	_inner_error0_ = _tmp0_;
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

static gchar**
rygel_cmdline_config_get_string_list_from_options (RygelCmdlineConfig* self,
                                                   const gchar* key,
                                                   GError** error)
{
	gchar** disabled_plugins = NULL;
	gint disabled_plugins_length1;
	gint _disabled_plugins_size_;
	GVariantDict* _tmp0_;
	gchar** _tmp1_ = NULL;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	disabled_plugins = NULL;
	disabled_plugins_length1 = 0;
	_disabled_plugins_size_ = disabled_plugins_length1;
	_tmp0_ = self->priv->options;
	_tmp2_ = g_variant_dict_lookup (_tmp0_, key, "^as", &_tmp1_, NULL);
	disabled_plugins = (_vala_array_free (disabled_plugins, disabled_plugins_length1, (GDestroyNotify) g_free), NULL);
	disabled_plugins = _tmp1_;
	disabled_plugins_length1 = -1;
	_disabled_plugins_size_ = disabled_plugins_length1;
	if (!_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		disabled_plugins = (_vala_array_free (disabled_plugins, disabled_plugins_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	result = disabled_plugins;
	return result;
}

static gboolean
rygel_cmdline_config_real_get_enabled (RygelConfiguration* base,
                                       const gchar* section,
                                       GError** error)
{
	RygelCmdlineConfig * self;
	gchar** _tmp0_ = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp0__length1;
	gint __tmp0__size_;
	GError* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	_tmp2_ = _tmp1_ = rygel_cmdline_config_get_string_list_from_options (self, "disable-plugin", &_inner_error0_);
	_tmp0_ = _tmp2_;
	_tmp0__length1 = _vala_array_length (_tmp1_);
	__tmp0__size_ = _tmp0__length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp3_;
	}
	{
		gchar** plugin_collection = NULL;
		gint plugin_collection_length1 = 0;
		gint _plugin_collection_size_ = 0;
		gint plugin_it = 0;
		plugin_collection = _tmp0_;
		plugin_collection_length1 = _tmp0__length1;
		for (plugin_it = 0; plugin_it < plugin_collection_length1; plugin_it = plugin_it + 1) {
			gchar* _tmp4_;
			gchar* plugin = NULL;
			_tmp4_ = g_strdup (plugin_collection[plugin_it]);
			plugin = _tmp4_;
			{
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = plugin;
				g_print ("Checking %s against %s\n", section, _tmp5_);
				_tmp6_ = plugin;
				if (g_strcmp0 (section, _tmp6_) == 0) {
					result = FALSE;
					_g_free0 (plugin);
					_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (plugin);
			}
		}
	}
	_tmp7_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
	_inner_error0_ = _tmp7_;
	g_propagate_error (error, _inner_error0_);
	_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
	return _tmp8_;
}

static gchar*
rygel_cmdline_config_real_get_title (RygelConfiguration* base,
                                     const gchar* section,
                                     GError** error)
{
	RygelCmdlineConfig * self;
	gchar** plugin_titles = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint plugin_titles_length1;
	gint _plugin_titles_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GError* _tmp18_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	_tmp1_ = _tmp0_ = rygel_cmdline_config_get_string_list_from_options (self, "plugin-title", &_inner_error0_);
	plugin_titles = _tmp1_;
	plugin_titles_length1 = _vala_array_length (_tmp0_);
	_plugin_titles_size_ = plugin_titles_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = plugin_titles;
	_tmp2__length1 = plugin_titles_length1;
	{
		gchar** entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = _tmp2_;
		entry_collection_length1 = _tmp2__length1;
		for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
			gchar* _tmp3_;
			gchar* entry = NULL;
			_tmp3_ = g_strdup (entry_collection[entry_it]);
			entry = _tmp3_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp4_;
				gchar** _tmp5_;
				gchar** _tmp6_;
				gint tokens_length1;
				gint _tokens_size_;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				_tmp4_ = entry;
				_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ":", 2);
				tokens = _tmp6_;
				tokens_length1 = _vala_array_length (_tmp5_);
				_tokens_size_ = tokens_length1;
				_tmp9_ = tokens;
				_tmp9__length1 = tokens_length1;
				_tmp10_ = _tmp9_[0];
				if (_tmp10_ != NULL) {
					gchar** _tmp11_;
					gint _tmp11__length1;
					const gchar* _tmp12_;
					_tmp11_ = tokens;
					_tmp11__length1 = tokens_length1;
					_tmp12_ = _tmp11_[1];
					_tmp8_ = _tmp12_ != NULL;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					_tmp13_ = tokens;
					_tmp13__length1 = tokens_length1;
					_tmp14_ = _tmp13_[0];
					_tmp7_ = g_strcmp0 (_tmp14_, section) == 0;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp15_ = tokens;
					_tmp15__length1 = tokens_length1;
					_tmp16_ = _tmp15_[1];
					_tmp17_ = g_strdup (_tmp16_);
					result = _tmp17_;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (entry);
					plugin_titles = (_vala_array_free (plugin_titles, plugin_titles_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (entry);
			}
		}
	}
	_tmp18_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
	_inner_error0_ = _tmp18_;
	g_propagate_error (error, _inner_error0_);
	plugin_titles = (_vala_array_free (plugin_titles, plugin_titles_length1, (GDestroyNotify) g_free), NULL);
	return NULL;
}

gchar*
rygel_cmdline_config_get_config_file (RygelCmdlineConfig* self,
                                      GError** error)
{
	const gchar* config_file = NULL;
	GVariantDict* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	config_file = NULL;
	_tmp0_ = self->priv->options;
	_tmp2_ = g_variant_dict_lookup (_tmp0_, "config", "^ay", &_tmp1_, NULL);
	config_file = _tmp1_;
	if (!_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = config_file;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	return result;
}

static gchar*
rygel_cmdline_config_real_get_video_upload_folder (RygelConfiguration* base,
                                                   GError** error)
{
	RygelCmdlineConfig * self;
	GError* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
	_inner_error0_ = _tmp0_;
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

static gchar*
rygel_cmdline_config_real_get_music_upload_folder (RygelConfiguration* base,
                                                   GError** error)
{
	RygelCmdlineConfig * self;
	GError* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
	_inner_error0_ = _tmp0_;
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

static gchar*
rygel_cmdline_config_real_get_picture_upload_folder (RygelConfiguration* base,
                                                     GError** error)
{
	RygelCmdlineConfig * self;
	GError* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (RygelCmdlineConfig*) base;
	_tmp0_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
	_inner_error0_ = _tmp0_;
	g_propagate_error (error, _inner_error0_);
	return NULL;
}

static gchar*
rygel_cmdline_config_real_get_string (RygelConfiguration* base,
                                      const gchar* section,
                                      const gchar* key,
                                      GError** error)
{
	RygelCmdlineConfig * self;
	gchar** plugin_options = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint plugin_options_length1;
	gint _plugin_options_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GError* _tmp24_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp1_ = _tmp0_ = rygel_cmdline_config_get_string_list_from_options (self, "plugin-option", &_inner_error0_);
	plugin_options = _tmp1_;
	plugin_options_length1 = _vala_array_length (_tmp0_);
	_plugin_options_size_ = plugin_options_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = plugin_options;
	_tmp2__length1 = plugin_options_length1;
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp2_;
		option_collection_length1 = _tmp2__length1;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			gchar* _tmp3_;
			gchar* option = NULL;
			_tmp3_ = g_strdup (option_collection[option_it]);
			option = _tmp3_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp4_;
				gchar** _tmp5_;
				gchar** _tmp6_;
				gint tokens_length1;
				gint _tokens_size_;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				_tmp4_ = option;
				_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ":", 3);
				tokens = _tmp6_;
				tokens_length1 = _vala_array_length (_tmp5_);
				_tokens_size_ = tokens_length1;
				_tmp11_ = tokens;
				_tmp11__length1 = tokens_length1;
				_tmp12_ = _tmp11_[0];
				if (_tmp12_ != NULL) {
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					_tmp13_ = tokens;
					_tmp13__length1 = tokens_length1;
					_tmp14_ = _tmp13_[1];
					_tmp10_ = _tmp14_ != NULL;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					_tmp15_ = tokens;
					_tmp15__length1 = tokens_length1;
					_tmp16_ = _tmp15_[2];
					_tmp9_ = _tmp16_ != NULL;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					_tmp17_ = tokens;
					_tmp17__length1 = tokens_length1;
					_tmp18_ = _tmp17_[0];
					_tmp8_ = g_strcmp0 (_tmp18_, section) == 0;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					_tmp19_ = tokens;
					_tmp19__length1 = tokens_length1;
					_tmp20_ = _tmp19_[1];
					_tmp7_ = g_strcmp0 (_tmp20_, key) == 0;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp21_ = tokens;
					_tmp21__length1 = tokens_length1;
					_tmp22_ = _tmp21_[2];
					_tmp23_ = g_strdup (_tmp22_);
					result = _tmp23_;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (option);
					plugin_options = (_vala_array_free (plugin_options, plugin_options_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (option);
			}
		}
	}
	_tmp24_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, _ ("No value available"));
	_inner_error0_ = _tmp24_;
	g_propagate_error (error, _inner_error0_);
	plugin_options = (_vala_array_free (plugin_options, plugin_options_length1, (GDestroyNotify) g_free), NULL);
	return NULL;
}

static GeeArrayList*
rygel_cmdline_config_real_get_string_list (RygelConfiguration* base,
                                           const gchar* section,
                                           const gchar* key,
                                           GError** error)
{
	RygelCmdlineConfig * self;
	GeeArrayList* val = NULL;
	GeeArrayList* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	val = _tmp0_;
	_tmp2_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, key, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (val);
		return NULL;
	}
	_tmp4_ = _tmp3_ = g_strsplit (_tmp1_, ",", -1);
	{
		gchar** val_token_collection = NULL;
		gint val_token_collection_length1 = 0;
		gint _val_token_collection_size_ = 0;
		gint val_token_it = 0;
		val_token_collection = _tmp4_;
		val_token_collection_length1 = _vala_array_length (_tmp3_);
		for (val_token_it = 0; val_token_it < val_token_collection_length1; val_token_it = val_token_it + 1) {
			gchar* _tmp5_;
			gchar* val_token = NULL;
			_tmp5_ = g_strdup (val_token_collection[val_token_it]);
			val_token = _tmp5_;
			{
				const gchar* _tmp6_;
				_tmp6_ = val_token;
				gee_abstract_collection_add ((GeeAbstractCollection*) val, _tmp6_);
				_g_free0 (val_token);
			}
		}
		val_token_collection = (_vala_array_free (val_token_collection, val_token_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = val;
	_g_free0 (_tmp1_);
	return result;
}

static gboolean
int_try_parse (const gchar* str,
               gint* _result_,
               const gchar** unparsed,
               guint _base)
{
	gint _vala__result_ = 0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	glong long_result = 0L;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	long_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = long_result;
	if ((((glong) G_MININT) <= _tmp6_) && (_tmp6_ <= ((glong) G_MAXINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (gint) long_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gint
rygel_cmdline_config_real_get_int (RygelConfiguration* base,
                                   const gchar* section,
                                   const gchar* key,
                                   gint min,
                                   gint max,
                                   GError** error)
{
	RygelCmdlineConfig * self;
	gint _result_ = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gint _tmp3_ = 0;
	gboolean _tmp4_;
	gboolean _tmp7_ = FALSE;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, key, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp2_ = -1;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	_tmp4_ = int_try_parse (_tmp0_, &_tmp3_, NULL, (guint) 0);
	_result_ = _tmp3_;
	if (!_tmp4_) {
		GError* _tmp5_;
		gint _tmp6_ = -1;
		_tmp5_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE, _ ("No value available"));
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp0_);
		return _tmp6_;
	}
	if (_result_ < min) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = _result_ > max;
	}
	if (_tmp7_) {
		GError* _tmp8_;
		gint _tmp9_ = -1;
		_tmp8_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE, _ ("No value available"));
		_inner_error0_ = _tmp8_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp0_);
		return _tmp9_;
	}
	result = _result_;
	_g_free0 (_tmp0_);
	return result;
}

static GeeArrayList*
rygel_cmdline_config_real_get_int_list (RygelConfiguration* base,
                                        const gchar* section,
                                        const gchar* key,
                                        GError** error)
{
	RygelCmdlineConfig * self;
	GeeArrayList* val = NULL;
	GeeArrayList* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	val = _tmp0_;
	_tmp2_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, key, &_inner_error0_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (val);
		return NULL;
	}
	_tmp4_ = _tmp3_ = g_strsplit (_tmp1_, ",", -1);
	{
		gchar** val_token_collection = NULL;
		gint val_token_collection_length1 = 0;
		gint _val_token_collection_size_ = 0;
		gint val_token_it = 0;
		val_token_collection = _tmp4_;
		val_token_collection_length1 = _vala_array_length (_tmp3_);
		for (val_token_it = 0; val_token_it < val_token_collection_length1; val_token_it = val_token_it + 1) {
			gchar* _tmp5_;
			gchar* val_token = NULL;
			_tmp5_ = g_strdup (val_token_collection[val_token_it]);
			val_token = _tmp5_;
			{
				gint _result_ = 0;
				const gchar* _tmp6_;
				gint _tmp7_ = 0;
				gboolean _tmp8_;
				GeeArrayList* _tmp10_;
				_tmp6_ = val_token;
				_tmp8_ = int_try_parse (_tmp6_, &_tmp7_, NULL, (guint) 0);
				_result_ = _tmp7_;
				if (!_tmp8_) {
					GError* _tmp9_;
					_tmp9_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE, _ ("No value available"));
					_inner_error0_ = _tmp9_;
					g_propagate_error (error, _inner_error0_);
					_g_free0 (val_token);
					val_token_collection = (_vala_array_free (val_token_collection, val_token_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp1_);
					_g_object_unref0 (val);
					return NULL;
				}
				_tmp10_ = val;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, (gpointer) ((gintptr) _result_));
				_g_free0 (val_token);
			}
		}
		val_token_collection = (_vala_array_free (val_token_collection, val_token_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = val;
	_g_free0 (_tmp1_);
	return result;
}

static gboolean
bool_parse (const gchar* str)
{
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	if (g_strcmp0 (str, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static gboolean
rygel_cmdline_config_real_get_bool (RygelConfiguration* base,
                                    const gchar* section,
                                    const gchar* key,
                                    GError** error)
{
	RygelCmdlineConfig * self;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (RygelCmdlineConfig*) base;
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp1_ = rygel_configuration_get_string ((RygelConfiguration*) self, section, key, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = bool_parse (_tmp0_);
	_g_free0 (_tmp0_);
	return result;
}

RygelCmdlineConfig*
rygel_cmdline_config_construct (GType object_type)
{
	RygelCmdlineConfig * self = NULL;
	self = (RygelCmdlineConfig*) g_object_new (object_type, NULL);
	return self;
}

RygelCmdlineConfig*
rygel_cmdline_config_new (void)
{
	return rygel_cmdline_config_construct (RYGEL_TYPE_CMDLINE_CONFIG);
}

static void
rygel_cmdline_config_class_init (RygelCmdlineConfigClass * klass,
                                 gpointer klass_data)
{
	rygel_cmdline_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelCmdlineConfig_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_cmdline_config_finalize;
}

static void
rygel_cmdline_config_rygel_configuration_interface_init (RygelConfigurationIface * iface,
                                                         gpointer iface_data)
{
	rygel_cmdline_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_interface = (gchar* (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_interface;
	iface->get_interfaces = (gchar** (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_interfaces;
	iface->get_port = (gint (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_port;
	iface->get_transcoding = (gboolean (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_transcoding;
	iface->get_allow_upload = (gboolean (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_allow_upload;
	iface->get_allow_deletion = (gboolean (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_allow_deletion;
	iface->get_log_levels = (gchar* (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_log_levels;
	iface->get_plugin_path = (gchar* (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_plugin_path;
	iface->get_engine_path = (gchar* (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_engine_path;
	iface->get_media_engine = (gchar* (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_media_engine;
	iface->get_enabled = (gboolean (*) (RygelConfiguration*, const gchar*, GError**)) rygel_cmdline_config_real_get_enabled;
	iface->get_title = (gchar* (*) (RygelConfiguration*, const gchar*, GError**)) rygel_cmdline_config_real_get_title;
	iface->get_video_upload_folder = (gchar* (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_video_upload_folder;
	iface->get_music_upload_folder = (gchar* (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_music_upload_folder;
	iface->get_picture_upload_folder = (gchar* (*) (RygelConfiguration*, GError**)) rygel_cmdline_config_real_get_picture_upload_folder;
	iface->get_string = (gchar* (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_cmdline_config_real_get_string;
	iface->get_string_list = (GeeArrayList* (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_cmdline_config_real_get_string_list;
	iface->get_int = (gint (*) (RygelConfiguration*, const gchar*, const gchar*, gint, gint, GError**)) rygel_cmdline_config_real_get_int;
	iface->get_int_list = (GeeArrayList* (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_cmdline_config_real_get_int_list;
	iface->get_bool = (gboolean (*) (RygelConfiguration*, const gchar*, const gchar*, GError**)) rygel_cmdline_config_real_get_bool;
}

static void
rygel_cmdline_config_instance_init (RygelCmdlineConfig * self,
                                    gpointer klass)
{
	self->priv = rygel_cmdline_config_get_instance_private (self);
}

static void
rygel_cmdline_config_finalize (GObject * obj)
{
	RygelCmdlineConfig * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfig);
	_g_variant_dict_unref0 (self->priv->options);
	G_OBJECT_CLASS (rygel_cmdline_config_parent_class)->finalize (obj);
}

/**
 * Manages configuration from Commandline arguments.
 */
 G_GNUC_NO_INLINE static GType
rygel_cmdline_config_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelCmdlineConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_cmdline_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelCmdlineConfig), 0, (GInstanceInitFunc) rygel_cmdline_config_instance_init, NULL };
	static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_cmdline_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_cmdline_config_type_id;
	rygel_cmdline_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelCmdlineConfig", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_cmdline_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
	RygelCmdlineConfig_private_offset = g_type_add_instance_private (rygel_cmdline_config_type_id, sizeof (RygelCmdlineConfigPrivate));
	return rygel_cmdline_config_type_id;
}

GType
rygel_cmdline_config_get_type (void)
{
	static volatile gsize rygel_cmdline_config_type_id__once = 0;
	if (g_once_init_enter (&rygel_cmdline_config_type_id__once)) {
		GType rygel_cmdline_config_type_id;
		rygel_cmdline_config_type_id = rygel_cmdline_config_get_type_once ();
		g_once_init_leave (&rygel_cmdline_config_type_id__once, rygel_cmdline_config_type_id);
	}
	return rygel_cmdline_config_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

