/* BatteryBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BatteryBox.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2024 elementary, Inc. (https://elementary.io)
 */

#include "power.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <granite-7.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POWER_BATTERY_BOX_0_PROPERTY,
	POWER_BATTERY_BOX_NUM_PROPERTIES
};
static GParamSpec* power_battery_box_properties[POWER_BATTERY_BOX_NUM_PROPERTIES];

#define POWER_BATTERY_BOX_TYPE_BATTERY (power_battery_box_battery_get_type ())
#define POWER_BATTERY_BOX_BATTERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POWER_BATTERY_BOX_TYPE_BATTERY, PowerBatteryBoxBattery))
#define POWER_BATTERY_BOX_BATTERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POWER_BATTERY_BOX_TYPE_BATTERY, PowerBatteryBoxBatteryClass))
#define POWER_BATTERY_BOX_IS_BATTERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POWER_BATTERY_BOX_TYPE_BATTERY))
#define POWER_BATTERY_BOX_IS_BATTERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POWER_BATTERY_BOX_TYPE_BATTERY))
#define POWER_BATTERY_BOX_BATTERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POWER_BATTERY_BOX_TYPE_BATTERY, PowerBatteryBoxBatteryClass))

typedef struct _PowerBatteryBoxBattery PowerBatteryBoxBattery;
typedef struct _PowerBatteryBoxBatteryClass PowerBatteryBoxBatteryClass;
typedef struct _PowerBatteryBoxBatteryPrivate PowerBatteryBoxBatteryPrivate;
enum  {
	POWER_BATTERY_BOX_BATTERY_0_PROPERTY,
	POWER_BATTERY_BOX_BATTERY_DEVICE_PROPERTY,
	POWER_BATTERY_BOX_BATTERY_NUM_PROPERTIES
};
static GParamSpec* power_battery_box_battery_properties[POWER_BATTERY_BOX_BATTERY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PowerBatteryBoxBattery {
	GtkGrid parent_instance;
	PowerBatteryBoxBatteryPrivate * priv;
};

struct _PowerBatteryBoxBatteryClass {
	GtkGridClass parent_class;
};

struct _PowerBatteryBoxBatteryPrivate {
	PowerDevice* _device;
	GtkLevelBar* charge_levelbar;
};

static gpointer power_battery_box_parent_class = NULL;
static gint PowerBatteryBoxBattery_private_offset;
static gpointer power_battery_box_battery_parent_class = NULL;

static GType power_battery_box_battery_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PowerBatteryBoxBattery* power_battery_box_battery_new (PowerDevice* device);
static PowerBatteryBoxBattery* power_battery_box_battery_construct (GType object_type,
                                                             PowerDevice* device);
static void power_battery_box_battery_update_levelbar_offsets (PowerBatteryBoxBattery* self);
static PowerDevice* power_battery_box_battery_get_device (PowerBatteryBoxBattery* self);
static void power_battery_box_battery_set_device (PowerBatteryBoxBattery* self,
                                           PowerDevice* value);
static GObject * power_battery_box_battery_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static gboolean _power_battery_box_battery___lambda5_ (PowerBatteryBoxBattery* self,
                                                GBinding* binding,
                                                GValue* srcval,
                                                GValue* targetval);
static gboolean __power_battery_box_battery___lambda5__gbinding_transform_func (GBinding* binding,
                                                                         GValue* from_value,
                                                                         GValue* to_value,
                                                                         gpointer self);
static gboolean _power_battery_box_battery___lambda6_ (PowerBatteryBoxBattery* self,
                                                GBinding* binding,
                                                GValue* srcval,
                                                GValue* targetval);
static gboolean __power_battery_box_battery___lambda6__gbinding_transform_func (GBinding* binding,
                                                                         GValue* from_value,
                                                                         GValue* to_value,
                                                                         gpointer self);
static void _power_battery_box_battery_update_levelbar_offsets_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self);
static void power_battery_box_battery_finalize (GObject * obj);
static GType power_battery_box_battery_get_type_once (void);
static void _vala_power_battery_box_battery_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_power_battery_box_battery_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static GObject * power_battery_box_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static GType power_battery_box_get_type_once (void);

PowerBatteryBox*
power_battery_box_construct (GType object_type)
{
	PowerBatteryBox * self = NULL;
	self = (PowerBatteryBox*) g_object_new (object_type, NULL);
	return self;
}

PowerBatteryBox*
power_battery_box_new (void)
{
	return power_battery_box_construct (POWER_TYPE_BATTERY_BOX);
}

static inline gpointer
power_battery_box_battery_get_instance_private (PowerBatteryBoxBattery* self)
{
	return G_STRUCT_MEMBER_P (self, PowerBatteryBoxBattery_private_offset);
}

static PowerBatteryBoxBattery*
power_battery_box_battery_construct (GType object_type,
                                     PowerDevice* device)
{
	PowerBatteryBoxBattery * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	self = (PowerBatteryBoxBattery*) g_object_new (object_type, "device", device, NULL);
	return self;
}

static PowerBatteryBoxBattery*
power_battery_box_battery_new (PowerDevice* device)
{
	return power_battery_box_battery_construct (POWER_BATTERY_BOX_TYPE_BATTERY, device);
}

static void
power_battery_box_battery_update_levelbar_offsets (PowerBatteryBoxBattery* self)
{
	gboolean _tmp0_ = FALSE;
	PowerDevice* _tmp1_;
	PowerDeviceState _tmp2_;
	PowerDeviceState _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_device;
	_tmp2_ = power_device_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == POWER_DEVICE_STATE_CHARGING) {
		_tmp0_ = TRUE;
	} else {
		PowerDevice* _tmp4_;
		PowerDeviceState _tmp5_;
		PowerDeviceState _tmp6_;
		_tmp4_ = self->priv->_device;
		_tmp5_ = power_device_get_state (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == POWER_DEVICE_STATE_FULLY_CHARGED;
	}
	if (_tmp0_) {
		GtkLevelBar* _tmp7_;
		GtkLevelBar* _tmp8_;
		GtkLevelBar* _tmp9_;
		_tmp7_ = self->priv->charge_levelbar;
		gtk_level_bar_remove_offset_value (_tmp7_, "high");
		_tmp8_ = self->priv->charge_levelbar;
		gtk_level_bar_remove_offset_value (_tmp8_, "middle");
		_tmp9_ = self->priv->charge_levelbar;
		gtk_level_bar_remove_offset_value (_tmp9_, "low");
	} else {
		GtkLevelBar* _tmp10_;
		GtkLevelBar* _tmp11_;
		GtkLevelBar* _tmp12_;
		_tmp10_ = self->priv->charge_levelbar;
		gtk_level_bar_add_offset_value (_tmp10_, "high", (gdouble) 99);
		_tmp11_ = self->priv->charge_levelbar;
		gtk_level_bar_add_offset_value (_tmp11_, "middle", (gdouble) 20);
		_tmp12_ = self->priv->charge_levelbar;
		gtk_level_bar_add_offset_value (_tmp12_, "low", (gdouble) 10);
	}
}

static PowerDevice*
power_battery_box_battery_get_device (PowerBatteryBoxBattery* self)
{
	PowerDevice* result;
	PowerDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
power_battery_box_battery_set_device (PowerBatteryBoxBattery* self,
                                      PowerDevice* value)
{
	PowerDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_battery_box_battery_get_device (self);
	if (old_value != value) {
		PowerDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_battery_box_battery_properties[POWER_BATTERY_BOX_BATTERY_DEVICE_PROPERTY]);
	}
}

static gboolean
_power_battery_box_battery___lambda5_ (PowerBatteryBoxBattery* self,
                                       GBinding* binding,
                                       GValue* srcval,
                                       GValue* targetval)
{
	GValue _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (srcval != NULL, FALSE);
	g_return_val_if_fail (targetval != NULL, FALSE);
	_tmp0_ = *srcval;
	_tmp1_ = g_strdup_printf ("%.0f", g_value_get_double (&_tmp0_));
	_tmp2_ = _tmp1_;
	g_value_set_string (targetval, _tmp2_);
	_g_free0 (_tmp2_);
	result = TRUE;
	return result;
}

static gboolean
__power_battery_box_battery___lambda5__gbinding_transform_func (GBinding* binding,
                                                                GValue* from_value,
                                                                GValue* to_value,
                                                                gpointer self)
{
	gboolean result;
	result = _power_battery_box_battery___lambda5_ ((PowerBatteryBoxBattery*) self, binding, from_value, to_value);
	return result;
}

static gboolean
_power_battery_box_battery___lambda6_ (PowerBatteryBoxBattery* self,
                                       GBinding* binding,
                                       GValue* srcval,
                                       GValue* targetval)
{
	GValue _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (srcval != NULL, FALSE);
	g_return_val_if_fail (targetval != NULL, FALSE);
	_tmp0_ = *srcval;
	_tmp1_ = power_device_state_to_string (g_value_get_enum (&_tmp0_));
	_tmp2_ = _tmp1_;
	g_value_set_string (targetval, _tmp2_);
	_g_free0 (_tmp2_);
	result = TRUE;
	return result;
}

static gboolean
__power_battery_box_battery___lambda6__gbinding_transform_func (GBinding* binding,
                                                                GValue* from_value,
                                                                GValue* to_value,
                                                                gpointer self)
{
	gboolean result;
	result = _power_battery_box_battery___lambda6_ ((PowerBatteryBoxBattery*) self, binding, from_value, to_value);
	return result;
}

static void
_power_battery_box_battery_update_levelbar_offsets_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self)
{
	power_battery_box_battery_update_levelbar_offsets ((PowerBatteryBoxBattery*) self);
}

static GObject *
power_battery_box_battery_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PowerBatteryBoxBattery * self;
	GtkLabel* charge_label = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* cent_label = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_;
	GtkLevelBar* _tmp4_ = NULL;
	GtkLevelBar* _tmp5_;
	GtkLabel* state_label = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLevelBar* _tmp10_;
	GtkLabel* _tmp11_;
	PowerDevice* _tmp12_;
	GtkLevelBar* _tmp13_;
	PowerDevice* _tmp14_;
	GtkLabel* _tmp15_;
	PowerDevice* _tmp16_;
	GtkLabel* _tmp17_;
	PowerDevice* _tmp18_;
	parent_class = G_OBJECT_CLASS (power_battery_box_battery_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_BATTERY_BOX_TYPE_BATTERY, PowerBatteryBoxBattery);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_BASELINE);
	g_object_ref_sink (_tmp0_);
	charge_label = _tmp0_;
	_tmp1_ = charge_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp1_, GRANITE_STYLE_CLASS_H1_LABEL);
	_tmp2_ = (GtkLabel*) gtk_label_new ("%");
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_BASELINE);
	g_object_ref_sink (_tmp2_);
	cent_label = _tmp2_;
	_tmp3_ = cent_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp4_ = (GtkLevelBar*) gtk_level_bar_new_for_interval ((gdouble) 0, (gdouble) 100);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp4_, TRUE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->charge_levelbar);
	self->priv->charge_levelbar = _tmp4_;
	_tmp5_ = self->priv->charge_levelbar;
	gtk_level_bar_add_offset_value (_tmp5_, "full", (gdouble) 100);
	_tmp6_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp6_);
	state_label = _tmp6_;
	_tmp7_ = state_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp7_, GRANITE_STYLE_CLASS_DIM_LABEL);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 6);
	_tmp8_ = charge_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp8_, 0, 0, 1, 1);
	_tmp9_ = cent_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp9_, 1, 0, 1, 1);
	_tmp10_ = self->priv->charge_levelbar;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp10_, 0, 2, 2, 1);
	_tmp11_ = state_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp11_, 0, 3, 2, 1);
	_tmp12_ = self->priv->_device;
	_tmp13_ = self->priv->charge_levelbar;
	g_object_bind_property_with_closures ((GObject*) _tmp12_, "percentage", (GObject*) _tmp13_, "value", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp14_ = self->priv->_device;
	_tmp15_ = charge_label;
	g_object_bind_property_with_closures ((GObject*) _tmp14_, "percentage", (GObject*) _tmp15_, "label", G_BINDING_SYNC_CREATE, (GClosure*) ((__power_battery_box_battery___lambda5__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) __power_battery_box_battery___lambda5__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp16_ = self->priv->_device;
	_tmp17_ = state_label;
	g_object_bind_property_with_closures ((GObject*) _tmp16_, "state", (GObject*) _tmp17_, "label", G_BINDING_SYNC_CREATE, (GClosure*) ((__power_battery_box_battery___lambda6__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) __power_battery_box_battery___lambda6__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	power_battery_box_battery_update_levelbar_offsets (self);
	_tmp18_ = self->priv->_device;
	g_signal_connect_object ((GObject*) _tmp18_, "notify::state", (GCallback) _power_battery_box_battery_update_levelbar_offsets_g_object_notify, self, 0);
	_g_object_unref0 (state_label);
	_g_object_unref0 (cent_label);
	_g_object_unref0 (charge_label);
	return obj;
}

static void
power_battery_box_battery_class_init (PowerBatteryBoxBatteryClass * klass,
                                      gpointer klass_data)
{
	power_battery_box_battery_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerBatteryBoxBattery_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_power_battery_box_battery_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_power_battery_box_battery_set_property;
	G_OBJECT_CLASS (klass)->constructor = power_battery_box_battery_constructor;
	G_OBJECT_CLASS (klass)->finalize = power_battery_box_battery_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_BATTERY_BOX_BATTERY_DEVICE_PROPERTY, power_battery_box_battery_properties[POWER_BATTERY_BOX_BATTERY_DEVICE_PROPERTY] = g_param_spec_object ("device", "device", "device", POWER_TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
power_battery_box_battery_instance_init (PowerBatteryBoxBattery * self,
                                         gpointer klass)
{
	self->priv = power_battery_box_battery_get_instance_private (self);
}

static void
power_battery_box_battery_finalize (GObject * obj)
{
	PowerBatteryBoxBattery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_BATTERY_BOX_TYPE_BATTERY, PowerBatteryBoxBattery);
	_g_object_unref0 (self->priv->_device);
	_g_object_unref0 (self->priv->charge_levelbar);
	G_OBJECT_CLASS (power_battery_box_battery_parent_class)->finalize (obj);
}

static GType
power_battery_box_battery_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerBatteryBoxBatteryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_battery_box_battery_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerBatteryBoxBattery), 0, (GInstanceInitFunc) power_battery_box_battery_instance_init, NULL };
	GType power_battery_box_battery_type_id;
	power_battery_box_battery_type_id = g_type_register_static (gtk_grid_get_type (), "PowerBatteryBoxBattery", &g_define_type_info, 0);
	PowerBatteryBoxBattery_private_offset = g_type_add_instance_private (power_battery_box_battery_type_id, sizeof (PowerBatteryBoxBatteryPrivate));
	return power_battery_box_battery_type_id;
}

static GType
power_battery_box_battery_get_type (void)
{
	static volatile gsize power_battery_box_battery_type_id__once = 0;
	if (g_once_init_enter (&power_battery_box_battery_type_id__once)) {
		GType power_battery_box_battery_type_id;
		power_battery_box_battery_type_id = power_battery_box_battery_get_type_once ();
		g_once_init_leave (&power_battery_box_battery_type_id__once, power_battery_box_battery_type_id);
	}
	return power_battery_box_battery_type_id__once;
}

static void
_vala_power_battery_box_battery_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	PowerBatteryBoxBattery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_BATTERY_BOX_TYPE_BATTERY, PowerBatteryBoxBattery);
	switch (property_id) {
		case POWER_BATTERY_BOX_BATTERY_DEVICE_PROPERTY:
		g_value_set_object (value, power_battery_box_battery_get_device (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_power_battery_box_battery_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	PowerBatteryBoxBattery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_BATTERY_BOX_TYPE_BATTERY, PowerBatteryBoxBattery);
	switch (property_id) {
		case POWER_BATTERY_BOX_BATTERY_DEVICE_PROPERTY:
		power_battery_box_battery_set_device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
power_battery_box_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PowerBatteryBox * self;
	GraniteHeaderLabel* battery_header = NULL;
	GraniteHeaderLabel* _tmp0_;
	GtkBox* devices_box = NULL;
	GtkBox* _tmp1_ = NULL;
	GListStore* batteries = NULL;
	PowerPowerManager* _tmp2_;
	GListStore* _tmp3_;
	GListStore* _tmp4_;
	GListStore* _tmp5_;
	GraniteHeaderLabel* _tmp17_;
	GListStore* _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	GtkSwitch* show_percent_switch = NULL;
	GtkSwitch* _tmp21_ = NULL;
	GraniteHeaderLabel* show_percent_label = NULL;
	GtkSwitch* _tmp22_;
	GtkWidget* _tmp23_;
	GraniteHeaderLabel* _tmp24_ = NULL;
	GSettings* wingpanel_power_settings = NULL;
	GSettings* _tmp25_;
	GSettings* _tmp26_;
	GtkSwitch* _tmp27_;
	GraniteHeaderLabel* _tmp28_;
	GtkBox* _tmp29_;
	GraniteHeaderLabel* _tmp30_;
	GtkSwitch* _tmp31_;
	parent_class = G_OBJECT_CLASS (power_battery_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_TYPE_BATTERY_BOX, PowerBatteryBox);
	_tmp0_ = granite_header_label_new ("");
	g_object_ref_sink (_tmp0_);
	battery_header = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp1_, 6);
	g_object_ref_sink (_tmp1_);
	devices_box = _tmp1_;
	_tmp2_ = power_power_manager_get_default ();
	_tmp3_ = power_power_manager_get_batteries (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	batteries = _tmp5_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GListStore* _tmp8_;
				guint _tmp9_;
				guint _tmp10_;
				GtkBox* _tmp11_;
				GListStore* _tmp12_;
				GObject* _tmp13_;
				PowerDevice* _tmp14_;
				PowerBatteryBoxBattery* _tmp15_;
				PowerBatteryBoxBattery* _tmp16_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = batteries;
				g_object_get (_tmp8_, "n-items", &_tmp9_, NULL);
				_tmp10_ = _tmp9_;
				if (!(((guint) i) < _tmp10_)) {
					break;
				}
				_tmp11_ = devices_box;
				_tmp12_ = batteries;
				_tmp13_ = g_list_model_get_item ((GListModel*) _tmp12_, (guint) i);
				_tmp14_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, POWER_TYPE_DEVICE, PowerDevice);
				_tmp15_ = power_battery_box_battery_new (_tmp14_);
				g_object_ref_sink (_tmp15_);
				_tmp16_ = _tmp15_;
				gtk_box_append (_tmp11_, (GtkWidget*) _tmp16_);
				_g_object_unref0 (_tmp16_);
				_g_object_unref0 (_tmp14_);
			}
		}
	}
	_tmp17_ = battery_header;
	_tmp18_ = batteries;
	g_object_get (_tmp18_, "n-items", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	granite_header_label_set_label (_tmp17_, ngettext (_ ("Battery Level"), _ ("Battery Levels"), (gulong) _tmp20_));
	_tmp21_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp21_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp21_);
	show_percent_switch = _tmp21_;
	_tmp22_ = show_percent_switch;
	_tmp23_ = _g_object_ref0 ((GtkWidget*) _tmp22_);
	_tmp24_ = granite_header_label_new (_ ("Show Percentage In Panel"));
	granite_header_label_set_mnemonic_widget (_tmp24_, _tmp23_);
	_g_object_unref0 (_tmp23_);
	g_object_ref_sink (_tmp24_);
	show_percent_label = _tmp24_;
	_tmp25_ = g_settings_new ("io.elementary.desktop.wingpanel.power");
	wingpanel_power_settings = _tmp25_;
	_tmp26_ = wingpanel_power_settings;
	_tmp27_ = show_percent_switch;
	g_settings_bind (_tmp26_, "show-percentage", (GObject*) _tmp27_, "active", G_SETTINGS_BIND_DEFAULT);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 6);
	_tmp28_ = battery_header;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp28_, 0, 0, 2, 1);
	_tmp29_ = devices_box;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp29_, 0, 1, 2, 1);
	_tmp30_ = show_percent_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp30_, 0, 3, 1, 1);
	_tmp31_ = show_percent_switch;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp31_, 1, 3, 1, 1);
	_g_object_unref0 (wingpanel_power_settings);
	_g_object_unref0 (show_percent_label);
	_g_object_unref0 (show_percent_switch);
	_g_object_unref0 (batteries);
	_g_object_unref0 (devices_box);
	_g_object_unref0 (battery_header);
	return obj;
}

static void
power_battery_box_class_init (PowerBatteryBoxClass * klass,
                              gpointer klass_data)
{
	power_battery_box_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = power_battery_box_constructor;
}

static void
power_battery_box_instance_init (PowerBatteryBox * self,
                                 gpointer klass)
{
}

static GType
power_battery_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerBatteryBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_battery_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerBatteryBox), 0, (GInstanceInitFunc) power_battery_box_instance_init, NULL };
	GType power_battery_box_type_id;
	power_battery_box_type_id = g_type_register_static (gtk_grid_get_type (), "PowerBatteryBox", &g_define_type_info, 0);
	return power_battery_box_type_id;
}

GType
power_battery_box_get_type (void)
{
	static volatile gsize power_battery_box_type_id__once = 0;
	if (g_once_init_enter (&power_battery_box_type_id__once)) {
		GType power_battery_box_type_id;
		power_battery_box_type_id = power_battery_box_get_type_once ();
		g_once_init_leave (&power_battery_box_type_id__once, power_battery_box_type_id);
	}
	return power_battery_box_type_id__once;
}

