/* DisplayWidget.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DisplayWidget.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.1-or-later
 * SPDX-FileCopyrightText: 2015-2025 elementary, Inc. (https://elementary.io)
 */

#include "network.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_WIDGETS_DISPLAY_WIDGET_0_PROPERTY,
	NETWORK_WIDGETS_DISPLAY_WIDGET_NUM_PROPERTIES
};
static GParamSpec* network_widgets_display_widget_properties[NETWORK_WIDGETS_DISPLAY_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _NetworkWidgetsDisplayWidgetPrivate {
	GtkImage* image;
	GtkLabel* extra_info_label;
	GtkRevealer* extra_info_revealer;
	guint wifi_animation_timeout;
	gint wifi_animation_state;
	guint cellular_animation_timeout;
	gint cellular_animation_state;
};

struct _Block1Data {
	int _ref_count_;
	NetworkWidgetsDisplayWidget* self;
	gboolean secure;
};

static gint NetworkWidgetsDisplayWidget_private_offset;
static gpointer network_widgets_display_widget_parent_class = NULL;

static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda4_ (Block1Data* _data1_);
static gboolean ____lambda4__gsource_func (gpointer self);
static gboolean ___lambda5_ (Block1Data* _data1_);
static gboolean ____lambda5__gsource_func (gpointer self);
static GObject * network_widgets_display_widget_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void network_widgets_display_widget_finalize (GObject * obj);
static GType network_widgets_display_widget_get_type_once (void);

static inline gpointer
network_widgets_display_widget_get_instance_private (NetworkWidgetsDisplayWidget* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWidgetsDisplayWidget_private_offset);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		NetworkWidgetsDisplayWidget* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
___lambda4_ (Block1Data* _data1_)
{
	NetworkWidgetsDisplayWidget* self;
	gchar* strength = NULL;
	gchar* _tmp0_;
	const gchar* _tmp5_ = NULL;
	GtkImage* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean result;
	self = _data1_->self;
	self->priv->wifi_animation_state = (self->priv->wifi_animation_state + 1) % 4;
	_tmp0_ = g_strdup ("");
	strength = _tmp0_;
	switch (self->priv->wifi_animation_state) {
		case 0:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("weak");
			_g_free0 (strength);
			strength = _tmp1_;
			break;
		}
		case 1:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("ok");
			_g_free0 (strength);
			strength = _tmp2_;
			break;
		}
		case 2:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("good");
			_g_free0 (strength);
			strength = _tmp3_;
			break;
		}
		case 3:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("excellent");
			_g_free0 (strength);
			strength = _tmp4_;
			break;
		}
		default:
		break;
	}
	if (_data1_->secure) {
		_tmp5_ = "-secure";
	} else {
		_tmp5_ = "";
	}
	_tmp6_ = self->priv->image;
	_tmp7_ = strength;
	_tmp8_ = g_strconcat ("panel-network-wireless-signal-", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, _tmp5_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "-symbolic", NULL);
	_tmp13_ = _tmp12_;
	g_object_set (_tmp6_, "icon-name", _tmp13_, NULL);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	result = TRUE;
	_g_free0 (strength);
	return result;
}

static gboolean
____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda4_ (self);
	return result;
}

static gboolean
___lambda5_ (Block1Data* _data1_)
{
	NetworkWidgetsDisplayWidget* self;
	gchar* strength = NULL;
	gchar* _tmp0_;
	const gchar* _tmp5_ = NULL;
	GtkImage* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean result;
	self = _data1_->self;
	self->priv->cellular_animation_state = (self->priv->cellular_animation_state + 1) % 4;
	_tmp0_ = g_strdup ("");
	strength = _tmp0_;
	switch (self->priv->cellular_animation_state) {
		case 0:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("weak");
			_g_free0 (strength);
			strength = _tmp1_;
			break;
		}
		case 1:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("ok");
			_g_free0 (strength);
			strength = _tmp2_;
			break;
		}
		case 2:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("good");
			_g_free0 (strength);
			strength = _tmp3_;
			break;
		}
		case 3:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("excellent");
			_g_free0 (strength);
			strength = _tmp4_;
			break;
		}
		default:
		break;
	}
	if (_data1_->secure) {
		_tmp5_ = "secure-";
	} else {
		_tmp5_ = "";
	}
	_tmp6_ = self->priv->image;
	_tmp7_ = strength;
	_tmp8_ = g_strconcat ("panel-network-cellular-signal-", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, _tmp5_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "-symbolic", NULL);
	_tmp13_ = _tmp12_;
	g_object_set (_tmp6_, "icon-name", _tmp13_, NULL);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	result = TRUE;
	_g_free0 (strength);
	return result;
}

static gboolean
____lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda5_ (self);
	return result;
}

void
network_widgets_display_widget_update_state (NetworkWidgetsDisplayWidget* self,
                                             NetworkState state,
                                             gboolean secure,
                                             const gchar* extra_info)
{
	Block1Data* _data1_;
	GtkRevealer* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->secure = secure;
	_tmp0_ = self->priv->extra_info_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, extra_info != NULL);
	_tmp1_ = self->priv->extra_info_label;
	gtk_label_set_label (_tmp1_, extra_info);
	if (self->priv->wifi_animation_timeout > ((guint) 0)) {
		g_source_remove (self->priv->wifi_animation_timeout);
		self->priv->wifi_animation_timeout = (guint) 0;
	}
	if (self->priv->cellular_animation_timeout > ((guint) 0)) {
		g_source_remove (self->priv->cellular_animation_timeout);
		self->priv->cellular_animation_timeout = (guint) 0;
	}
	switch (state) {
		case NETWORK_STATE_DISCONNECTED_AIRPLANE_MODE:
		{
			GtkImage* _tmp2_;
			_tmp2_ = self->priv->image;
			g_object_set (_tmp2_, "icon-name", "airplane-mode-symbolic", NULL);
			break;
		}
		case NETWORK_STATE_CONNECTING_WIRED:
		{
			GtkImage* _tmp3_;
			_tmp3_ = self->priv->image;
			g_object_set (_tmp3_, "icon-name", "panel-network-wired-acquiring-symbolic", NULL);
			break;
		}
		case NETWORK_STATE_CONNECTED_WIRED:
		{
			const gchar* _tmp4_ = NULL;
			GtkImage* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			if (_data1_->secure) {
				_tmp4_ = "secure-";
			} else {
				_tmp4_ = "connected-";
			}
			_tmp5_ = self->priv->image;
			_tmp6_ = g_strdup_printf ("panel-network-wired-%ssymbolic", _tmp4_);
			_tmp7_ = _tmp6_;
			g_object_set (_tmp5_, "icon-name", _tmp7_, NULL);
			_g_free0 (_tmp7_);
			break;
		}
		case NETWORK_STATE_CONNECTED_WIFI_WEAK:
		{
			const gchar* _tmp8_ = NULL;
			GtkImage* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			if (_data1_->secure) {
				_tmp8_ = "secure-";
			} else {
				_tmp8_ = "";
			}
			_tmp9_ = self->priv->image;
			_tmp10_ = g_strdup_printf ("panel-network-wireless-signal-weak-%ssymbolic", _tmp8_);
			_tmp11_ = _tmp10_;
			g_object_set (_tmp9_, "icon-name", _tmp11_, NULL);
			_g_free0 (_tmp11_);
			break;
		}
		case NETWORK_STATE_CONNECTED_WIFI_OK:
		{
			const gchar* _tmp12_ = NULL;
			GtkImage* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			if (_data1_->secure) {
				_tmp12_ = "secure-";
			} else {
				_tmp12_ = "";
			}
			_tmp13_ = self->priv->image;
			_tmp14_ = g_strdup_printf ("panel-network-wireless-signal-ok-%ssymbolic", _tmp12_);
			_tmp15_ = _tmp14_;
			g_object_set (_tmp13_, "icon-name", _tmp15_, NULL);
			_g_free0 (_tmp15_);
			break;
		}
		case NETWORK_STATE_CONNECTED_WIFI_GOOD:
		{
			const gchar* _tmp16_ = NULL;
			GtkImage* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			if (_data1_->secure) {
				_tmp16_ = "secure-";
			} else {
				_tmp16_ = "";
			}
			_tmp17_ = self->priv->image;
			_tmp18_ = g_strdup_printf ("panel-network-wireless-signal-good-%ssymbolic", _tmp16_);
			_tmp19_ = _tmp18_;
			g_object_set (_tmp17_, "icon-name", _tmp19_, NULL);
			_g_free0 (_tmp19_);
			break;
		}
		case NETWORK_STATE_CONNECTED_WIFI_EXCELLENT:
		{
			const gchar* _tmp20_ = NULL;
			GtkImage* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			if (_data1_->secure) {
				_tmp20_ = "secure-";
			} else {
				_tmp20_ = "";
			}
			_tmp21_ = self->priv->image;
			_tmp22_ = g_strdup_printf ("panel-network-wireless-signal-excellent-%ssymbolic", _tmp20_);
			_tmp23_ = _tmp22_;
			g_object_set (_tmp21_, "icon-name", _tmp23_, NULL);
			_g_free0 (_tmp23_);
			break;
		}
		case NETWORK_STATE_CONNECTING_WIFI:
		{
			self->priv->wifi_animation_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, ____lambda4__gsource_func, block1_data_ref (_data1_), block1_data_unref);
			break;
		}
		case NETWORK_STATE_CONNECTED_MOBILE_WEAK:
		{
			const gchar* _tmp24_ = NULL;
			GtkImage* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			if (_data1_->secure) {
				_tmp24_ = "secure-";
			} else {
				_tmp24_ = "";
			}
			_tmp25_ = self->priv->image;
			_tmp26_ = g_strdup_printf ("panel-network-cellular-signal-weak-%ssymbolic", _tmp24_);
			_tmp27_ = _tmp26_;
			g_object_set (_tmp25_, "icon-name", _tmp27_, NULL);
			_g_free0 (_tmp27_);
			break;
		}
		case NETWORK_STATE_CONNECTED_MOBILE_OK:
		{
			const gchar* _tmp28_ = NULL;
			GtkImage* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			if (_data1_->secure) {
				_tmp28_ = "secure-";
			} else {
				_tmp28_ = "";
			}
			_tmp29_ = self->priv->image;
			_tmp30_ = g_strdup_printf ("panel-network-cellular-signal-ok-%ssymbolic", _tmp28_);
			_tmp31_ = _tmp30_;
			g_object_set (_tmp29_, "icon-name", _tmp31_, NULL);
			_g_free0 (_tmp31_);
			break;
		}
		case NETWORK_STATE_CONNECTED_MOBILE_GOOD:
		{
			const gchar* _tmp32_ = NULL;
			GtkImage* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			if (_data1_->secure) {
				_tmp32_ = "secure-";
			} else {
				_tmp32_ = "";
			}
			_tmp33_ = self->priv->image;
			_tmp34_ = g_strdup_printf ("panel-network-cellular-signal-good-%ssymbolic", _tmp32_);
			_tmp35_ = _tmp34_;
			g_object_set (_tmp33_, "icon-name", _tmp35_, NULL);
			_g_free0 (_tmp35_);
			break;
		}
		case NETWORK_STATE_CONNECTED_MOBILE_EXCELLENT:
		{
			const gchar* _tmp36_ = NULL;
			GtkImage* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			if (_data1_->secure) {
				_tmp36_ = "secure-";
			} else {
				_tmp36_ = "";
			}
			_tmp37_ = self->priv->image;
			_tmp38_ = g_strdup_printf ("panel-network-cellular-signal-excellent-%ssymbolic", _tmp36_);
			_tmp39_ = _tmp38_;
			g_object_set (_tmp37_, "icon-name", _tmp39_, NULL);
			_g_free0 (_tmp39_);
			break;
		}
		case NETWORK_STATE_CONNECTING_MOBILE:
		{
			self->priv->cellular_animation_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, ____lambda5__gsource_func, block1_data_ref (_data1_), block1_data_unref);
			break;
		}
		case NETWORK_STATE_FAILED_MOBILE:
		{
			GtkImage* _tmp40_;
			_tmp40_ = self->priv->image;
			g_object_set (_tmp40_, "icon-name", "panel-network-cellular-offline-symbolic", NULL);
			break;
		}
		case NETWORK_STATE_FAILED_WIFI:
		case NETWORK_STATE_DISCONNECTED:
		{
			GtkImage* _tmp41_;
			_tmp41_ = self->priv->image;
			g_object_set (_tmp41_, "icon-name", "panel-network-wireless-offline-symbolic", NULL);
			break;
		}
		case NETWORK_STATE_FAILED:
		case NETWORK_STATE_WIRED_UNPLUGGED:
		{
			GtkImage* _tmp42_;
			_tmp42_ = self->priv->image;
			g_object_set (_tmp42_, "icon-name", "panel-network-wired-offline-symbolic", NULL);
			break;
		}
		default:
		{
			GtkImage* _tmp43_;
			GEnumValue* _tmp44_;
			_tmp43_ = self->priv->image;
			g_object_set (_tmp43_, "icon-name", "panel-network-wired-offline-symbolic", NULL);
			_tmp44_ = g_enum_get_value (g_type_class_ref (NETWORK_TYPE_STATE), state);
			g_critical ("DisplayWidget.vala:142: Unknown network state, cannot show the good ic" \
"on: %s", (_tmp44_ != NULL) ? _tmp44_->value_name : NULL);
			break;
		}
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

NetworkWidgetsDisplayWidget*
network_widgets_display_widget_construct (GType object_type)
{
	NetworkWidgetsDisplayWidget * self = NULL;
	self = (NetworkWidgetsDisplayWidget*) g_object_new (object_type, NULL);
	return self;
}

NetworkWidgetsDisplayWidget*
network_widgets_display_widget_new (void)
{
	return network_widgets_display_widget_construct (NETWORK_WIDGETS_TYPE_DISPLAY_WIDGET);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject *
network_widgets_display_widget_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkWidgetsDisplayWidget * self;
	GtkImage* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_;
	GtkWidget* _tmp3_;
	GtkRevealer* _tmp4_ = NULL;
	GtkImage* _tmp5_;
	GtkRevealer* _tmp6_;
	parent_class = G_OBJECT_CLASS (network_widgets_display_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_DISPLAY_WIDGET, NetworkWidgetsDisplayWidget);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("panel-network-wired-connected-symbolic", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_image_set_pixel_size (_tmp0_, 24);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp1_, 4);
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->extra_info_label);
	self->priv->extra_info_label = _tmp1_;
	_tmp2_ = self->priv->extra_info_label;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	_tmp4_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp4_, "child", _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	gtk_revealer_set_transition_type (_tmp4_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->extra_info_revealer);
	self->priv->extra_info_revealer = _tmp4_;
	_tmp5_ = self->priv->image;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->extra_info_revealer;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	return obj;
}

static void
network_widgets_display_widget_class_init (NetworkWidgetsDisplayWidgetClass * klass,
                                           gpointer klass_data)
{
	network_widgets_display_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWidgetsDisplayWidget_private_offset);
	G_OBJECT_CLASS (klass)->constructor = network_widgets_display_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_widgets_display_widget_finalize;
}

static void
network_widgets_display_widget_instance_init (NetworkWidgetsDisplayWidget * self,
                                              gpointer klass)
{
	self->priv = network_widgets_display_widget_get_instance_private (self);
	self->priv->wifi_animation_state = 0;
	self->priv->cellular_animation_state = 0;
}

static void
network_widgets_display_widget_finalize (GObject * obj)
{
	NetworkWidgetsDisplayWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_DISPLAY_WIDGET, NetworkWidgetsDisplayWidget);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->extra_info_label);
	_g_object_unref0 (self->priv->extra_info_revealer);
	G_OBJECT_CLASS (network_widgets_display_widget_parent_class)->finalize (obj);
}

static GType
network_widgets_display_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWidgetsDisplayWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_widgets_display_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWidgetsDisplayWidget), 0, (GInstanceInitFunc) network_widgets_display_widget_instance_init, NULL };
	GType network_widgets_display_widget_type_id;
	network_widgets_display_widget_type_id = g_type_register_static (gtk_box_get_type (), "NetworkWidgetsDisplayWidget", &g_define_type_info, 0);
	NetworkWidgetsDisplayWidget_private_offset = g_type_add_instance_private (network_widgets_display_widget_type_id, sizeof (NetworkWidgetsDisplayWidgetPrivate));
	return network_widgets_display_widget_type_id;
}

GType
network_widgets_display_widget_get_type (void)
{
	static volatile gsize network_widgets_display_widget_type_id__once = 0;
	if (g_once_init_enter (&network_widgets_display_widget_type_id__once)) {
		GType network_widgets_display_widget_type_id;
		network_widgets_display_widget_type_id = network_widgets_display_widget_get_type_once ();
		g_once_init_leave (&network_widgets_display_widget_type_id__once, network_widgets_display_widget_type_id);
	}
	return network_widgets_display_widget_type_id__once;
}

