/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRouterSourceEnum.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(RouterSourceEnum enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("cache"),
        MAKE_STATIC_STRING_IMPL("fetch-event"),
        MAKE_STATIC_STRING_IMPL("network"),
    };
    static_assert(static_cast<size_t>(RouterSourceEnum::Cache) == 0, "RouterSourceEnum::Cache is not 0 as expected");
    static_assert(static_cast<size_t>(RouterSourceEnum::FetchEvent) == 1, "RouterSourceEnum::FetchEvent is not 1 as expected");
    static_assert(static_cast<size_t>(RouterSourceEnum::Network) == 2, "RouterSourceEnum::Network is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, RouterSourceEnum enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<RouterSourceEnum> parseEnumerationFromString<RouterSourceEnum>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, RouterSourceEnum>, 3> mappings {
        std::pair<ComparableASCIILiteral, RouterSourceEnum> { "cache"_s, RouterSourceEnum::Cache },
        std::pair<ComparableASCIILiteral, RouterSourceEnum> { "fetch-event"_s, RouterSourceEnum::FetchEvent },
        std::pair<ComparableASCIILiteral, RouterSourceEnum> { "network"_s, RouterSourceEnum::Network },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<RouterSourceEnum> parseEnumeration<RouterSourceEnum>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<RouterSourceEnum>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<RouterSourceEnum>()
{
    return "\"cache\", \"fetch-event\", \"network\""_s;
}

} // namespace WebCore

