/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGForeignObjectElement.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGAnimatedLength.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGForeignObjectElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGForeignObjectElement_x);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGForeignObjectElement_y);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGForeignObjectElement_width);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGForeignObjectElement_height);

class JSSVGForeignObjectElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGForeignObjectElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGForeignObjectElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGForeignObjectElementPrototype>(vm)) JSSVGForeignObjectElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGForeignObjectElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGForeignObjectElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGForeignObjectElementPrototype, JSSVGForeignObjectElementPrototype::Base);

using JSSVGForeignObjectElementDOMConstructor = JSDOMConstructorNotConstructable<JSSVGForeignObjectElement>;

template<> const ClassInfo JSSVGForeignObjectElementDOMConstructor::s_info = { "SVGForeignObjectElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGForeignObjectElementDOMConstructor) };

template<> JSValue JSSVGForeignObjectElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGGraphicsElement::getConstructor(vm, &globalObject);
}

template<> void JSSVGForeignObjectElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGForeignObjectElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGForeignObjectElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSSVGForeignObjectElementPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGForeignObjectElementConstructor, 0 } },
    HashTableValue { "x"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGForeignObjectElement_x, 0 } },
    HashTableValue { "y"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGForeignObjectElement_y, 0 } },
    HashTableValue { "width"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGForeignObjectElement_width, 0 } },
    HashTableValue { "height"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGForeignObjectElement_height, 0 } },
};

const ClassInfo JSSVGForeignObjectElementPrototype::s_info = { "SVGForeignObjectElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGForeignObjectElementPrototype) };

void JSSVGForeignObjectElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGForeignObjectElement::info(), JSSVGForeignObjectElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGForeignObjectElement::s_info = { "SVGForeignObjectElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGForeignObjectElement) };

JSSVGForeignObjectElement::JSSVGForeignObjectElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGForeignObjectElement>&& impl)
    : JSSVGGraphicsElement(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGForeignObjectElement> JSSVGForeignObjectElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSSVGForeignObjectElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGForeignObjectElementPrototype::createStructure(vm, &globalObject, JSSVGGraphicsElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGForeignObjectElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGForeignObjectElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGForeignObjectElement>(vm, globalObject);
}

JSValue JSSVGForeignObjectElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGForeignObjectElementDOMConstructor, DOMConstructorID::SVGForeignObjectElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGForeignObjectElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGForeignObjectElementPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGForeignObjectElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGForeignObjectElement_xGetter(JSGlobalObject& lexicalGlobalObject, JSSVGForeignObjectElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.xAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGForeignObjectElement_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGForeignObjectElement>::get<jsSVGForeignObjectElement_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGForeignObjectElement_yGetter(JSGlobalObject& lexicalGlobalObject, JSSVGForeignObjectElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.yAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGForeignObjectElement_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGForeignObjectElement>::get<jsSVGForeignObjectElement_yGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGForeignObjectElement_widthGetter(JSGlobalObject& lexicalGlobalObject, JSSVGForeignObjectElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.widthAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGForeignObjectElement_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGForeignObjectElement>::get<jsSVGForeignObjectElement_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGForeignObjectElement_heightGetter(JSGlobalObject& lexicalGlobalObject, JSSVGForeignObjectElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SVGAnimatedLength>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.heightAnimated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGForeignObjectElement_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGForeignObjectElement>::get<jsSVGForeignObjectElement_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGForeignObjectElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGForeignObjectElement, UseCustomHeapCellType::No>(vm, "JSSVGForeignObjectElement"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGForeignObjectElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGForeignObjectElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGForeignObjectElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGForeignObjectElement = std::forward<decltype(space)>(space); }
    );
}

void JSSVGForeignObjectElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGForeignObjectElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
