/* ext-benchmark.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ext-benchmark.vala, do not modify */

/* benchmark.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Seif Lotfy <seif@lotfy.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-engine.h"
#include "zeitgeist-datamodel.h"
#include "zeitgeist-internal.h"
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ZEITGEIST_TYPE_REMOTE_BENCHMARKER (zeitgeist_remote_benchmarker_get_type ())
#define ZEITGEIST_REMOTE_BENCHMARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_BENCHMARKER, ZeitgeistRemoteBenchmarker))
#define ZEITGEIST_IS_REMOTE_BENCHMARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_BENCHMARKER))
#define ZEITGEIST_REMOTE_BENCHMARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_BENCHMARKER, ZeitgeistRemoteBenchmarkerIface))

typedef struct _ZeitgeistRemoteBenchmarker ZeitgeistRemoteBenchmarker;
typedef struct _ZeitgeistRemoteBenchmarkerIface ZeitgeistRemoteBenchmarkerIface;

#define ZEITGEIST_TYPE_REMOTE_BENCHMARKER_PROXY (zeitgeist_remote_benchmarker_proxy_get_type ())
typedef GDBusProxy ZeitgeistRemoteBenchmarkerProxy;
typedef GDBusProxyClass ZeitgeistRemoteBenchmarkerProxyClass;
typedef struct _ZeitgeistRemoteBenchmarkerFindEventsReadyData ZeitgeistRemoteBenchmarkerFindEventsReadyData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define ZEITGEIST_TYPE_BENCHMARKER (zeitgeist_benchmarker_get_type ())
#define ZEITGEIST_BENCHMARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_BENCHMARKER, ZeitgeistBenchmarker))
#define ZEITGEIST_BENCHMARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_BENCHMARKER, ZeitgeistBenchmarkerClass))
#define ZEITGEIST_IS_BENCHMARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_BENCHMARKER))
#define ZEITGEIST_IS_BENCHMARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_BENCHMARKER))
#define ZEITGEIST_BENCHMARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_BENCHMARKER, ZeitgeistBenchmarkerClass))

typedef struct _ZeitgeistBenchmarker ZeitgeistBenchmarker;
typedef struct _ZeitgeistBenchmarkerClass ZeitgeistBenchmarkerClass;
typedef struct _ZeitgeistBenchmarkerPrivate ZeitgeistBenchmarkerPrivate;
enum  {
	ZEITGEIST_BENCHMARKER_0_PROPERTY,
	ZEITGEIST_BENCHMARKER_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_benchmarker_properties[ZEITGEIST_BENCHMARKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistBenchmarkerFindEventsData ZeitgeistBenchmarkerFindEventsData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ZeitgeistRemoteBenchmarkerIface {
	GTypeInterface parent_iface;
	void (*find_events) (ZeitgeistRemoteBenchmarker* self, GVariant* time_range, GVariant* event_templates, guint storage_state, guint num_events, guint result_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*find_events_finish) (ZeitgeistRemoteBenchmarker* self, GAsyncResult* _res_, GError** error);
};

struct _ZeitgeistRemoteBenchmarkerFindEventsReadyData {
	GDBusMethodInvocation* _invocation_;
	GVariant* time_range;
	GVariant* event_templates;
	guint storage_state;
	guint num_events;
	guint result_type;
};

struct _ZeitgeistBenchmarker {
	ZeitgeistExtension parent_instance;
	ZeitgeistBenchmarkerPrivate * priv;
};

struct _ZeitgeistBenchmarkerClass {
	ZeitgeistExtensionClass parent_class;
};

struct _ZeitgeistBenchmarkerPrivate {
	guint registration_id;
};

struct _ZeitgeistBenchmarkerFindEventsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistBenchmarker* self;
	GVariant* time_range;
	GVariant* filter_templates;
	guint storage_state;
	guint num_events;
	guint result_type;
	GHashTable* result;
	GHashTable* data;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GTimer* find_event_ids_timer;
	GTimer* _tmp3_;
	ZeitgeistTimeRange* _tmp4_;
	ZeitgeistTimeRange* _tmp5_;
	GPtrArray* _tmp6_;
	GPtrArray* _tmp7_;
	guint32* ids;
	ZeitgeistEngine* _tmp8_;
	ZeitgeistEngine* _tmp9_;
	gint _tmp10_;
	guint32* _tmp11_;
	gint ids_length1;
	gint _ids_size_;
	gdouble find_event_ids_elapsed;
	GTimer* _tmp12_;
	GTimer* get_events_timer;
	GTimer* _tmp13_;
	GPtrArray* events;
	ZeitgeistEngine* _tmp14_;
	ZeitgeistEngine* _tmp15_;
	guint32* _tmp16_;
	gint _tmp16__length1;
	GPtrArray* _tmp17_;
	gdouble get_events_elapsed;
	GTimer* _tmp18_;
	GTimer* marsh_events_timer;
	GTimer* _tmp19_;
	GVariant* marsh_events;
	GPtrArray* _tmp20_;
	GVariant* _tmp21_;
	gdouble marsh_events_elapsed;
	GTimer* _tmp22_;
	gdouble find_events_elapsed;
	GHashTable* _tmp23_;
	gchar* _tmp24_;
	GVariant* _tmp25_;
	GHashTable* _tmp26_;
	gchar* _tmp27_;
	GVariant* _tmp28_;
	GHashTable* _tmp29_;
	gchar* _tmp30_;
	GVariant* _tmp31_;
	GHashTable* _tmp32_;
	gchar* _tmp33_;
	GVariant* _tmp34_;
	GHashTable* _tmp35_;
	gchar* _tmp36_;
	GVariant* _tmp37_;
	GVariant* _tmp38_;
	GError* _inner_error0_;
};

static GType zeitgeist_remote_benchmarker_type_id = 0;
static gint ZeitgeistBenchmarker_private_offset;
static gpointer zeitgeist_benchmarker_parent_class = NULL;
static ZeitgeistRemoteBenchmarkerIface * zeitgeist_benchmarker_zeitgeist_remote_benchmarker_parent_iface = NULL;
static GType zeitgeist_benchmarker_type_id = 0;

VALA_EXTERN GType zeitgeist_remote_benchmarker_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void zeitgeist_remote_benchmarker_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint zeitgeist_remote_benchmarker_register_object (void* object,
                                                    GDBusConnection* connection,
                                                    const gchar* path,
                                                    GError** error);
GType zeitgeist_remote_benchmarker_register_type (GTypeModule * module);
VALA_EXTERN GType zeitgeist_remote_benchmarker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistRemoteBenchmarker, g_object_unref)
VALA_EXTERN void zeitgeist_remote_benchmarker_find_events (ZeitgeistRemoteBenchmarker* self,
                                               GVariant* time_range,
                                               GVariant* event_templates,
                                               guint storage_state,
                                               guint num_events,
                                               guint result_type,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN GHashTable* zeitgeist_remote_benchmarker_find_events_finish (ZeitgeistRemoteBenchmarker* self,
                                                             GAsyncResult* _res_,
                                                             GError** error);
static void zeitgeist_remote_benchmarker_proxy_g_signal (GDBusProxy* proxy,
                                                  const gchar* sender_name,
                                                  const gchar* signal_name,
                                                  GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void zeitgeist_remote_benchmarker_proxy_find_events_async (ZeitgeistRemoteBenchmarker* self,
                                                           GVariant* time_range,
                                                           GVariant* event_templates,
                                                           guint storage_state,
                                                           guint num_events,
                                                           guint result_type,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static GHashTable* zeitgeist_remote_benchmarker_proxy_find_events_finish (ZeitgeistRemoteBenchmarker* self,
                                                                   GAsyncResult* _res_,
                                                                   GError** error);
static void zeitgeist_remote_benchmarker_proxy_zeitgeist_remote_benchmarker_interface_init (ZeitgeistRemoteBenchmarkerIface* iface);
static void _dbus_zeitgeist_remote_benchmarker_find_events (ZeitgeistRemoteBenchmarker* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_zeitgeist_remote_benchmarker_find_events_ready (GObject * source_object,
                                                           GAsyncResult * _res_,
                                                           gpointer _user_data_);
static void zeitgeist_remote_benchmarker_dbus_interface_method_call (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* method_name,
                                                              GVariant* parameters,
                                                              GDBusMethodInvocation* invocation,
                                                              gpointer user_data);
static GVariant* zeitgeist_remote_benchmarker_dbus_interface_get_property (GDBusConnection* connection,
                                                                    const gchar* sender,
                                                                    const gchar* object_path,
                                                                    const gchar* interface_name,
                                                                    const gchar* property_name,
                                                                    GError** error,
                                                                    gpointer user_data);
static gboolean zeitgeist_remote_benchmarker_dbus_interface_set_property (GDBusConnection* connection,
                                                                   const gchar* sender,
                                                                   const gchar* object_path,
                                                                   const gchar* interface_name,
                                                                   const gchar* property_name,
                                                                   GVariant* value,
                                                                   GError** error,
                                                                   gpointer user_data);
static void _zeitgeist_remote_benchmarker_unregister_object (gpointer user_data);
GType zeitgeist_benchmarker_register_type (GTypeModule * module);
VALA_EXTERN GType zeitgeist_benchmarker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistBenchmarker, g_object_unref)
static ZeitgeistBenchmarker* zeitgeist_benchmarker_new (void);
static ZeitgeistBenchmarker* zeitgeist_benchmarker_construct (GType object_type);
static void zeitgeist_benchmarker_real_find_events_data_free (gpointer _data);
static void zeitgeist_benchmarker_real_find_events (ZeitgeistRemoteBenchmarker* base,
                                             GVariant* time_range,
                                             GVariant* filter_templates,
                                             guint storage_state,
                                             guint num_events,
                                             guint result_type,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean zeitgeist_benchmarker_real_find_events_co (ZeitgeistBenchmarkerFindEventsData* _data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void zeitgeist_benchmarker_real_unload (ZeitgeistExtension* base);
static GObject * zeitgeist_benchmarker_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void zeitgeist_benchmarker_finalize (GObject * obj);
VALA_EXTERN GType zeitgeist_benchmark_init (GTypeModule* module);

static const GDBusArgInfo _zeitgeist_remote_benchmarker_dbus_arg_info_find_events_time_range = {-1, "time_range", "(xx)", NULL};
static const GDBusArgInfo _zeitgeist_remote_benchmarker_dbus_arg_info_find_events_event_templates = {-1, "event_templates", "a(asaasay)", NULL};
static const GDBusArgInfo _zeitgeist_remote_benchmarker_dbus_arg_info_find_events_storage_state = {-1, "storage_state", "u", NULL};
static const GDBusArgInfo _zeitgeist_remote_benchmarker_dbus_arg_info_find_events_num_events = {-1, "num_events", "u", NULL};
static const GDBusArgInfo _zeitgeist_remote_benchmarker_dbus_arg_info_find_events_result_type = {-1, "result_type", "u", NULL};
static const GDBusArgInfo _zeitgeist_remote_benchmarker_dbus_arg_info_find_events_result = {-1, "result", "a{sv}", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_benchmarker_dbus_arg_info_find_events_in[] = {&_zeitgeist_remote_benchmarker_dbus_arg_info_find_events_time_range, &_zeitgeist_remote_benchmarker_dbus_arg_info_find_events_event_templates, &_zeitgeist_remote_benchmarker_dbus_arg_info_find_events_storage_state, &_zeitgeist_remote_benchmarker_dbus_arg_info_find_events_num_events, &_zeitgeist_remote_benchmarker_dbus_arg_info_find_events_result_type, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_benchmarker_dbus_arg_info_find_events_out[] = {&_zeitgeist_remote_benchmarker_dbus_arg_info_find_events_result, NULL};
static const GDBusMethodInfo _zeitgeist_remote_benchmarker_dbus_method_info_find_events = {-1, "FindEvents", (GDBusArgInfo **) (&_zeitgeist_remote_benchmarker_dbus_arg_info_find_events_in), (GDBusArgInfo **) (&_zeitgeist_remote_benchmarker_dbus_arg_info_find_events_out), NULL};
static const GDBusMethodInfo * const _zeitgeist_remote_benchmarker_dbus_method_info[] = {&_zeitgeist_remote_benchmarker_dbus_method_info_find_events, NULL};
static const GDBusSignalInfo * const _zeitgeist_remote_benchmarker_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_benchmarker_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_benchmarker_dbus_interface_info = {-1, "org.gnome.zeitgeist.Benchmark", (GDBusMethodInfo **) (&_zeitgeist_remote_benchmarker_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_benchmarker_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_benchmarker_dbus_property_info), NULL};
static const GDBusInterfaceVTable _zeitgeist_remote_benchmarker_dbus_interface_vtable = {zeitgeist_remote_benchmarker_dbus_interface_method_call, zeitgeist_remote_benchmarker_dbus_interface_get_property, zeitgeist_remote_benchmarker_dbus_interface_set_property};

void
zeitgeist_remote_benchmarker_find_events (ZeitgeistRemoteBenchmarker* self,
                                          GVariant* time_range,
                                          GVariant* event_templates,
                                          guint storage_state,
                                          guint num_events,
                                          guint result_type,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	ZeitgeistRemoteBenchmarkerIface* _iface_;
	_iface_ = ZEITGEIST_REMOTE_BENCHMARKER_GET_INTERFACE (self);
	if (_iface_->find_events) {
		_iface_->find_events (self, time_range, event_templates, storage_state, num_events, result_type, _callback_, _user_data_);
	}
}

GHashTable*
zeitgeist_remote_benchmarker_find_events_finish (ZeitgeistRemoteBenchmarker* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	ZeitgeistRemoteBenchmarkerIface* _iface_;
	_iface_ = ZEITGEIST_REMOTE_BENCHMARKER_GET_INTERFACE (self);
	if (_iface_->find_events_finish) {
		return _iface_->find_events_finish (self, _res_, error);
	}
	return NULL;
}

static void
zeitgeist_remote_benchmarker_default_init (ZeitgeistRemoteBenchmarkerIface * iface,
                                           gpointer iface_data)
{
}

GType
zeitgeist_remote_benchmarker_get_type (void)
{
	return zeitgeist_remote_benchmarker_type_id;
}

GType
zeitgeist_remote_benchmarker_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteBenchmarkerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_remote_benchmarker_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	zeitgeist_remote_benchmarker_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "ZeitgeistRemoteBenchmarker", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_remote_benchmarker_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (zeitgeist_remote_benchmarker_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_benchmarker_proxy_get_type);
	g_type_set_qdata (zeitgeist_remote_benchmarker_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.zeitgeist.Benchmark");
	g_type_set_qdata (zeitgeist_remote_benchmarker_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_zeitgeist_remote_benchmarker_dbus_interface_info));
	g_type_set_qdata (zeitgeist_remote_benchmarker_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_benchmarker_register_object);
	return zeitgeist_remote_benchmarker_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (ZeitgeistRemoteBenchmarkerProxy, zeitgeist_remote_benchmarker_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (ZEITGEIST_TYPE_REMOTE_BENCHMARKER, zeitgeist_remote_benchmarker_proxy_zeitgeist_remote_benchmarker_interface_init) )
static void
zeitgeist_remote_benchmarker_proxy_class_init (ZeitgeistRemoteBenchmarkerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_benchmarker_proxy_g_signal;
}

static void
zeitgeist_remote_benchmarker_proxy_g_signal (GDBusProxy* proxy,
                                             const gchar* sender_name,
                                             const gchar* signal_name,
                                             GVariant* parameters)
{
}

static void
zeitgeist_remote_benchmarker_proxy_class_finalize (ZeitgeistRemoteBenchmarkerProxyClass* klass)
{
}

void
zeitgeist_remote_benchmarker_proxy_register_dynamic_type (GTypeModule* module)
{
	zeitgeist_remote_benchmarker_proxy_register_type (module);
}

static void
zeitgeist_remote_benchmarker_proxy_init (ZeitgeistRemoteBenchmarkerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_zeitgeist_remote_benchmarker_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
zeitgeist_remote_benchmarker_proxy_find_events_async (ZeitgeistRemoteBenchmarker* self,
                                                      GVariant* time_range,
                                                      GVariant* event_templates,
                                                      guint storage_state,
                                                      guint num_events,
                                                      guint result_type,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.Benchmark", "FindEvents");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, time_range);
	g_variant_builder_add_value (&_arguments_builder, event_templates);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (storage_state));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (num_events));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (result_type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static GHashTable*
zeitgeist_remote_benchmarker_proxy_find_events_finish (ZeitgeistRemoteBenchmarker* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GHashTable* _result = NULL;
	GVariant* _tmp0_;
	GHashTable* _tmp1_;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp2_, _tmp0_);
	while (g_variant_iter_loop (&_tmp2_, "{?*}", &_tmp3_, &_tmp4_)) {
		g_hash_table_insert (_tmp1_, g_variant_dup_string (_tmp3_, NULL), g_variant_get_variant (_tmp4_));
	}
	_result = _tmp1_;
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}

static void
zeitgeist_remote_benchmarker_proxy_zeitgeist_remote_benchmarker_interface_init (ZeitgeistRemoteBenchmarkerIface* iface)
{
	iface->find_events = zeitgeist_remote_benchmarker_proxy_find_events_async;
	iface->find_events_finish = zeitgeist_remote_benchmarker_proxy_find_events_finish;
}

static void
_dbus_zeitgeist_remote_benchmarker_find_events (ZeitgeistRemoteBenchmarker* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	ZeitgeistRemoteBenchmarkerFindEventsReadyData* _ready_data;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (ZeitgeistRemoteBenchmarkerFindEventsReadyData);
	_ready_data->_invocation_ = invocation;
	_ready_data->time_range = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->event_templates = g_variant_iter_next_value (&_arguments_iter);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->storage_state = g_variant_get_uint32 (_tmp5_);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->num_events = g_variant_get_uint32 (_tmp6_);
	g_variant_unref (_tmp6_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->result_type = g_variant_get_uint32 (_tmp7_);
	g_variant_unref (_tmp7_);
	zeitgeist_remote_benchmarker_find_events (self, _ready_data->time_range, _ready_data->event_templates, _ready_data->storage_state, _ready_data->num_events, _ready_data->result_type, (GAsyncReadyCallback) _dbus_zeitgeist_remote_benchmarker_find_events_ready, _ready_data);
	_error:
	;
}

static void
_dbus_zeitgeist_remote_benchmarker_find_events_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_)
{
	ZeitgeistRemoteBenchmarkerFindEventsReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable* result;
	GVariantBuilder _tmp8_;
	GHashTableIter _tmp9_;
	gpointer _tmp10_;
	gpointer _tmp11_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = zeitgeist_remote_benchmarker_find_events_finish ((ZeitgeistRemoteBenchmarker*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp9_, result);
	g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp9_, &_tmp10_, &_tmp11_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp10_;
		_value = (GVariant*) _tmp11_;
		g_variant_builder_add (&_tmp8_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp8_));
	_g_hash_table_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_variant_unref0 (_ready_data->time_range);
	_g_variant_unref0 (_ready_data->event_templates);
	g_slice_free (ZeitgeistRemoteBenchmarkerFindEventsReadyData, _ready_data);
}

static void
zeitgeist_remote_benchmarker_dbus_interface_method_call (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* method_name,
                                                         GVariant* parameters,
                                                         GDBusMethodInvocation* invocation,
                                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "FindEvents") == 0) {
		_dbus_zeitgeist_remote_benchmarker_find_events (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
zeitgeist_remote_benchmarker_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
zeitgeist_remote_benchmarker_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
zeitgeist_remote_benchmarker_register_object (gpointer object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_benchmarker_dbus_interface_info), &_zeitgeist_remote_benchmarker_dbus_interface_vtable, data, _zeitgeist_remote_benchmarker_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_zeitgeist_remote_benchmarker_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
zeitgeist_benchmarker_get_instance_private (ZeitgeistBenchmarker* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistBenchmarker_private_offset);
}

static ZeitgeistBenchmarker*
zeitgeist_benchmarker_construct (GType object_type)
{
	ZeitgeistBenchmarker * self = NULL;
	self = (ZeitgeistBenchmarker*) g_object_new (object_type, NULL);
	return self;
}

static ZeitgeistBenchmarker*
zeitgeist_benchmarker_new (void)
{
	return zeitgeist_benchmarker_construct (ZEITGEIST_TYPE_BENCHMARKER);
}

static void
zeitgeist_benchmarker_real_find_events_data_free (gpointer _data)
{
	ZeitgeistBenchmarkerFindEventsData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->filter_templates);
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistBenchmarkerFindEventsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
zeitgeist_benchmarker_real_find_events (ZeitgeistRemoteBenchmarker* base,
                                        GVariant* time_range,
                                        GVariant* filter_templates,
                                        guint storage_state,
                                        guint num_events,
                                        guint result_type,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ZeitgeistBenchmarker * self;
	ZeitgeistBenchmarkerFindEventsData* _data_;
	ZeitgeistBenchmarker* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (filter_templates != NULL);
	self = (ZeitgeistBenchmarker*) base;
	_data_ = g_slice_new0 (ZeitgeistBenchmarkerFindEventsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_benchmarker_real_find_events_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp1_;
	_tmp2_ = _g_variant_ref0 (filter_templates);
	_g_variant_unref0 (_data_->filter_templates);
	_data_->filter_templates = _tmp2_;
	_data_->storage_state = storage_state;
	_data_->num_events = num_events;
	_data_->result_type = result_type;
	zeitgeist_benchmarker_real_find_events_co (_data_);
}

static GHashTable*
zeitgeist_benchmarker_find_events_finish (ZeitgeistRemoteBenchmarker* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GHashTable* result;
	ZeitgeistBenchmarkerFindEventsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static gboolean
zeitgeist_benchmarker_real_find_events_co (ZeitgeistBenchmarkerFindEventsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_str_hash;
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, _g_variant_unref0_);
	_data_->data = _data_->_tmp2_;
	_data_->_tmp3_ = g_timer_new ();
	_data_->find_event_ids_timer = _data_->_tmp3_;
	_data_->_tmp5_ = zeitgeist_time_range_new_from_variant (_data_->time_range, &_data_->_inner_error0_);
	_data_->_tmp4_ = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_timer_destroy0 (_data_->find_event_ids_timer);
		_g_hash_table_unref0 (_data_->data);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = zeitgeist_events_from_variant (_data_->filter_templates, &_data_->_inner_error0_);
	_data_->_tmp6_ = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp4_);
		_g_timer_destroy0 (_data_->find_event_ids_timer);
		_g_hash_table_unref0 (_data_->data);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = zeitgeist_extension_get_engine ((ZeitgeistExtension*) _data_->self);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = 0;
	_data_->_tmp11_ = zeitgeist_db_reader_find_event_ids ((ZeitgeistDbReader*) _data_->_tmp9_, _data_->_tmp4_, _data_->_tmp6_, _data_->storage_state, _data_->num_events, _data_->result_type, NULL, &_data_->_tmp10_, &_data_->_inner_error0_);
	_data_->ids = _data_->_tmp11_;
	_data_->ids_length1 = _data_->_tmp10_;
	_data_->_ids_size_ = _data_->ids_length1;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->_tmp6_);
		_g_object_unref0 (_data_->_tmp4_);
		_g_timer_destroy0 (_data_->find_event_ids_timer);
		_g_hash_table_unref0 (_data_->data);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->find_event_ids_timer;
	_data_->find_event_ids_elapsed = g_timer_elapsed (_data_->_tmp12_, NULL);
	_data_->_tmp13_ = g_timer_new ();
	_data_->get_events_timer = _data_->_tmp13_;
	_data_->_tmp14_ = zeitgeist_extension_get_engine ((ZeitgeistExtension*) _data_->self);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = _data_->ids;
	_data_->_tmp16__length1 = _data_->ids_length1;
	_data_->_tmp17_ = zeitgeist_db_reader_get_events ((ZeitgeistDbReader*) _data_->_tmp15_, _data_->_tmp16_, (gint) _data_->_tmp16__length1, NULL, &_data_->_inner_error0_);
	_data_->events = _data_->_tmp17_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_timer_destroy0 (_data_->get_events_timer);
		_data_->ids = (g_free (_data_->ids), NULL);
		_g_ptr_array_unref0 (_data_->_tmp6_);
		_g_object_unref0 (_data_->_tmp4_);
		_g_timer_destroy0 (_data_->find_event_ids_timer);
		_g_hash_table_unref0 (_data_->data);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->get_events_timer;
	_data_->get_events_elapsed = g_timer_elapsed (_data_->_tmp18_, NULL);
	_data_->_tmp19_ = g_timer_new ();
	_data_->marsh_events_timer = _data_->_tmp19_;
	_data_->_tmp20_ = _data_->events;
	_data_->_tmp21_ = zeitgeist_events_to_variant (_data_->_tmp20_);
	_data_->marsh_events = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->marsh_events_timer;
	_data_->marsh_events_elapsed = g_timer_elapsed (_data_->_tmp22_, NULL);
	_data_->find_events_elapsed = (_data_->get_events_elapsed + _data_->find_event_ids_elapsed) + _data_->marsh_events_elapsed;
	_data_->_tmp23_ = _data_->data;
	_data_->_tmp24_ = g_strdup ("find_event_ids");
	_data_->_tmp25_ = g_variant_new_double (_data_->find_event_ids_elapsed);
	g_variant_ref_sink (_data_->_tmp25_);
	g_hash_table_insert (_data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_);
	_data_->_tmp26_ = _data_->data;
	_data_->_tmp27_ = g_strdup ("get_events");
	_data_->_tmp28_ = g_variant_new_double (_data_->get_events_elapsed);
	g_variant_ref_sink (_data_->_tmp28_);
	g_hash_table_insert (_data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_);
	_data_->_tmp29_ = _data_->data;
	_data_->_tmp30_ = g_strdup ("find_events");
	_data_->_tmp31_ = g_variant_new_double (_data_->find_events_elapsed);
	g_variant_ref_sink (_data_->_tmp31_);
	g_hash_table_insert (_data_->_tmp29_, _data_->_tmp30_, _data_->_tmp31_);
	_data_->_tmp32_ = _data_->data;
	_data_->_tmp33_ = g_strdup ("marsh_events");
	_data_->_tmp34_ = g_variant_new_double (_data_->marsh_events_elapsed);
	g_variant_ref_sink (_data_->_tmp34_);
	g_hash_table_insert (_data_->_tmp32_, _data_->_tmp33_, _data_->_tmp34_);
	_data_->_tmp35_ = _data_->data;
	_data_->_tmp36_ = g_strdup ("events");
	_data_->_tmp37_ = _data_->marsh_events;
	_data_->_tmp38_ = _g_variant_ref0 (_data_->_tmp37_);
	g_hash_table_insert (_data_->_tmp35_, _data_->_tmp36_, _data_->_tmp38_);
	_data_->result = _data_->data;
	_g_variant_unref0 (_data_->marsh_events);
	_g_timer_destroy0 (_data_->marsh_events_timer);
	_g_ptr_array_unref0 (_data_->events);
	_g_timer_destroy0 (_data_->get_events_timer);
	_data_->ids = (g_free (_data_->ids), NULL);
	_g_ptr_array_unref0 (_data_->_tmp6_);
	_g_object_unref0 (_data_->_tmp4_);
	_g_timer_destroy0 (_data_->find_event_ids_timer);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_benchmarker_real_unload (ZeitgeistExtension* base)
{
	ZeitgeistBenchmarker * self;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistBenchmarker*) base;
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp0_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		connection = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (self->priv->registration_id != ((guint) 0)) {
			g_dbus_connection_unregister_object (connection, self->priv->registration_id);
			self->priv->registration_id = (guint) 0;
		}
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _tmp1_->message;
		g_warning ("ext-benchmark.vala:107: %s", _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_debug ("ext-benchmark.vala:110: %s, this.ref_count = %u", "Zeitgeist.Benchmarker.unload", ((GObject*) self)->ref_count);
}

static GObject *
zeitgeist_benchmarker_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistBenchmarker * self;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_benchmarker_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_BENCHMARKER, ZeitgeistBenchmarker);
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp0_;
		guint _tmp1_ = 0U;
		GDBusConnection* _tmp2_;
		guint _tmp3_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		connection = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = connection;
		_tmp3_ = zeitgeist_remote_benchmarker_register_object ((ZeitgeistRemoteBenchmarker*) self, _tmp2_, "/org/gnome/zeitgeist/benchmark", &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (connection);
			goto __catch0_g_error;
		}
		self->priv->registration_id = _tmp1_;
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_warning ("ext-benchmark.vala:53: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
zeitgeist_benchmarker_class_init (ZeitgeistBenchmarkerClass * klass,
                                  gpointer klass_data)
{
	zeitgeist_benchmarker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistBenchmarker_private_offset);
	((ZeitgeistExtensionClass *) klass)->unload = (void (*) (ZeitgeistExtension*)) zeitgeist_benchmarker_real_unload;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_benchmarker_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_benchmarker_finalize;
}

static void
zeitgeist_benchmarker_zeitgeist_remote_benchmarker_interface_init (ZeitgeistRemoteBenchmarkerIface * iface,
                                                                   gpointer iface_data)
{
	zeitgeist_benchmarker_zeitgeist_remote_benchmarker_parent_iface = g_type_interface_peek_parent (iface);
	iface->find_events = (void (*) (ZeitgeistRemoteBenchmarker*, GVariant*, GVariant*, guint, guint, guint, GAsyncReadyCallback, gpointer)) zeitgeist_benchmarker_real_find_events;
	iface->find_events_finish = (GHashTable* (*) (ZeitgeistRemoteBenchmarker*, GAsyncResult*, GError**)) zeitgeist_benchmarker_find_events_finish;
}

static void
zeitgeist_benchmarker_instance_init (ZeitgeistBenchmarker * self,
                                     gpointer klass)
{
	self->priv = zeitgeist_benchmarker_get_instance_private (self);
}

static void
zeitgeist_benchmarker_finalize (GObject * obj)
{
	ZeitgeistBenchmarker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_BENCHMARKER, ZeitgeistBenchmarker);
	G_OBJECT_CLASS (zeitgeist_benchmarker_parent_class)->finalize (obj);
}

GType
zeitgeist_benchmarker_get_type (void)
{
	return zeitgeist_benchmarker_type_id;
}

GType
zeitgeist_benchmarker_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistBenchmarkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_benchmarker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistBenchmarker), 0, (GInstanceInitFunc) zeitgeist_benchmarker_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_benchmarker_info = { (GInterfaceInitFunc) zeitgeist_benchmarker_zeitgeist_remote_benchmarker_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_benchmarker_type_id = g_type_module_register_type (module, ZEITGEIST_TYPE_EXTENSION, "ZeitgeistBenchmarker", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_benchmarker_type_id, ZEITGEIST_TYPE_REMOTE_BENCHMARKER, &zeitgeist_remote_benchmarker_info);
	ZeitgeistBenchmarker_private_offset = sizeof (ZeitgeistBenchmarkerPrivate);
	return zeitgeist_benchmarker_type_id;
}

GType
zeitgeist_benchmark_init (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	zeitgeist_remote_benchmarker_register_type (module);
	zeitgeist_remote_benchmarker_proxy_register_dynamic_type (module);
	zeitgeist_benchmarker_register_type (module);
	result = ZEITGEIST_TYPE_BENCHMARKER;
	return result;
}

