/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkLabelShapeStatisticsImageFilter.h"
#include "itkLabelImageToShapeLabelMapFilter.h"

// Additional include files
#include "itkShapeLabelObject.h"
#include "sitkLabelFunctorUtils.hxx"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
LabelShapeStatisticsImageFilter::LabelShapeStatisticsImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
LabelShapeStatisticsImageFilter::~LabelShapeStatisticsImageFilter(){
  if (this->m_Filter != nullptr)
    {
      m_Filter->UnRegister();
    }
}



//
// Custom Methods
//

bool LabelShapeStatisticsImageFilter::HasLabel(int64_t label )
{
  return std::find(m_Labels.begin(),m_Labels.end(), label) != m_Labels.end();
}

uint64_t LabelShapeStatisticsImageFilter::GetNumberOfLabels( )
{
  return m_Labels.size();
}


//
// ToString
//
std::string LabelShapeStatisticsImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::LabelShapeStatisticsImageFilter\n";
  out << "  BackgroundValue: ";
  this->ToStringHelper(out, this->m_BackgroundValue);
  out << std::endl;
  out << "  ComputeFeretDiameter: ";
  this->ToStringHelper(out, this->m_ComputeFeretDiameter);
  out << std::endl;
  out << "  ComputePerimeter: ";
  this->ToStringHelper(out, this->m_ComputePerimeter);
  out << std::endl;
  out << "  ComputeOrientedBoundingBox: ";
  this->ToStringHelper(out, this->m_ComputeOrientedBoundingBox);
  out << std::endl;
  out << "  Labels: " << this->m_Labels << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
void LabelShapeStatisticsImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
void LabelShapeStatisticsImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType = itk::LabelImageToShapeLabelMapFilter<InputImageType, itk::LabelMap< itk::ShapeLabelObject< int64_t, InputImageType::ImageDimension > > >;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  filter->SetBackgroundValue ( static_cast< typename OutputImageType::PixelType> ( this->m_BackgroundValue ) );
  filter->SetComputeFeretDiameter ( this->m_ComputeFeretDiameter );
  filter->SetComputePerimeter ( this->m_ComputePerimeter );
  filter->SetComputeOrientedBoundingBox ( this->m_ComputeOrientedBoundingBox );



  // release the old filter ( and output data )
  if ( this->m_Filter != nullptr)
    {
      this->m_pfGetBoundingBox = nullptr;
      this->m_pfGetRegion = nullptr;
      this->m_pfGetCentroid = nullptr;
      this->m_pfGetElongation = nullptr;
      this->m_pfGetEquivalentEllipsoidDiameter = nullptr;
      this->m_pfGetEquivalentSphericalPerimeter = nullptr;
      this->m_pfGetEquivalentSphericalRadius = nullptr;
      this->m_pfGetFeretDiameter = nullptr;
      this->m_pfGetFlatness = nullptr;
      this->m_pfGetNumberOfPixels = nullptr;
      this->m_pfGetNumberOfPixelsOnBorder = nullptr;
      this->m_pfGetPerimeter = nullptr;
      this->m_pfGetPerimeterOnBorder = nullptr;
      this->m_pfGetPerimeterOnBorderRatio = nullptr;
      this->m_pfGetPhysicalSize = nullptr;
      this->m_pfGetPrincipalAxes = nullptr;
      this->m_pfGetPrincipalMoments = nullptr;
      this->m_pfGetRoundness = nullptr;
      this->m_pfGetOrientedBoundingBoxSize = nullptr;
      this->m_pfGetOrientedBoundingBoxOrigin = nullptr;
      this->m_pfGetOrientedBoundingBoxDirection = nullptr;
      this->m_pfGetOrientedBoundingBoxVertices = nullptr;
      this->m_pfGetIndexes = nullptr;
      this->m_pfGetRLEIndexes = nullptr;
      this->m_Filter->UnRegister();
      this->m_Filter = nullptr;
    }

  this->m_Filter = filter;
  this->m_Filter->Register();


  this->PreUpdate( filter.GetPointer() );

  this->m_pfGetBoundingBox = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetBoundingBox();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKImageRegionToSTL(value);
  };
  this->m_pfGetRegion = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetRegion();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKImageRegionToSTL(value);
  };
  this->m_pfGetCentroid = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetCentroid();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKVectorToSTL<double>(value);
  };
  this->m_pfGetElongation = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetElongation();
    return value;
  };
  this->m_pfGetEquivalentEllipsoidDiameter = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetEquivalentEllipsoidDiameter();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKVectorToSTL<double>(value);
  };
  this->m_pfGetEquivalentSphericalPerimeter = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetEquivalentSphericalPerimeter();
    return value;
  };
  this->m_pfGetEquivalentSphericalRadius = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetEquivalentSphericalRadius();
    return value;
  };
  this->m_pfGetFeretDiameter = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetFeretDiameter();
    return value;
  };
  this->m_pfGetFlatness = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetFlatness();
    return value;
  };
  this->m_pfGetNumberOfPixels = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetNumberOfPixels();
    return value;
  };
  this->m_pfGetNumberOfPixelsOnBorder = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetNumberOfPixelsOnBorder();
    return value;
  };
  this->m_pfGetPerimeter = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetPerimeter();
    return value;
  };
  this->m_pfGetPerimeterOnBorder = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetPerimeterOnBorder();
    return value;
  };
  this->m_pfGetPerimeterOnBorderRatio = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetPerimeterOnBorderRatio();
    return value;
  };
  this->m_pfGetPhysicalSize = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetPhysicalSize();
    return value;
  };
  this->m_pfGetPrincipalAxes = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetPrincipalAxes();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return std::vector<double>(value[0], value[T::RowDimensions-1]+T::ColumnDimensions);
  };
  this->m_pfGetPrincipalMoments = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetPrincipalMoments();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKVectorToSTL<double>(value);
  };
  this->m_pfGetRoundness = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetRoundness();
    return value;
  };
  this->m_pfGetOrientedBoundingBoxSize = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetOrientedBoundingBoxSize();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKVectorToSTL<double>(value);
  };
  this->m_pfGetOrientedBoundingBoxOrigin = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetOrientedBoundingBoxOrigin();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKVectorToSTL<double>(value);
  };
  this->m_pfGetOrientedBoundingBoxDirection = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetOrientedBoundingBoxDirection();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKDirectionToSTL(value);
  };
  this->m_pfGetOrientedBoundingBoxVertices = [ lm = filter->GetOutput() ](auto && label) {
    const auto & value = lm->GetLabelObject(label)->GetOrientedBoundingBoxVertices();
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkVectorOfITKVectorToSTL<double>(value);
  };
  this->m_pfGetIndexes = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetOutput()->GetLabelObject(label);
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return GetIndexesFromLabelObject(*value);
  };
  this->m_pfGetRLEIndexes = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetOutput()->GetLabelObject(label);
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return GetRLEIndexesFromLabelObject(*value);
  };


  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();

  const std::vector<typename FilterType::OutputImageType::LabelType> tempLabels = filter->GetOutput()->GetLabels();
  this->m_Labels = std::vector<int64_t>(tempLabels.begin(), tempLabels.end());

  return;

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------




}
