/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPURenderPassDepthStencilAttachment.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSGPULoadOp.h"
#include "JSGPUStoreOp.h"
#include "JSGPUTextureView.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPURenderPassDepthStencilAttachment>> convertDictionary<GPURenderPassDepthStencilAttachment>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPURenderPassDepthStencilAttachment result;
    JSValue depthClearValueValue;
    if (isNullOrUndefined)
        depthClearValueValue = jsUndefined();
    else {
        depthClearValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthClearValue"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!depthClearValueValue.isUndefined()) {
        auto depthClearValueConversionResult = convert<IDLFloat>(lexicalGlobalObject, depthClearValueValue);
        if (depthClearValueConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.depthClearValue = depthClearValueConversionResult.releaseReturnValue();
    }
    JSValue depthLoadOpValue;
    if (isNullOrUndefined)
        depthLoadOpValue = jsUndefined();
    else {
        depthLoadOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthLoadOp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!depthLoadOpValue.isUndefined()) {
        auto depthLoadOpConversionResult = convert<IDLEnumeration<GPULoadOp>>(lexicalGlobalObject, depthLoadOpValue);
        if (depthLoadOpConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.depthLoadOp = depthLoadOpConversionResult.releaseReturnValue();
    }
    JSValue depthReadOnlyValue;
    if (isNullOrUndefined)
        depthReadOnlyValue = jsUndefined();
    else {
        depthReadOnlyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthReadOnly"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto depthReadOnlyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, depthReadOnlyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (depthReadOnlyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.depthReadOnly = depthReadOnlyConversionResult.releaseReturnValue();
    JSValue depthStoreOpValue;
    if (isNullOrUndefined)
        depthStoreOpValue = jsUndefined();
    else {
        depthStoreOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "depthStoreOp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!depthStoreOpValue.isUndefined()) {
        auto depthStoreOpConversionResult = convert<IDLEnumeration<GPUStoreOp>>(lexicalGlobalObject, depthStoreOpValue);
        if (depthStoreOpConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.depthStoreOp = depthStoreOpConversionResult.releaseReturnValue();
    }
    JSValue stencilClearValueValue;
    if (isNullOrUndefined)
        stencilClearValueValue = jsUndefined();
    else {
        stencilClearValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilClearValue"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto stencilClearValueConversionResult = convertOptionalWithDefault<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, stencilClearValueValue, [&]() -> ConversionResult<IDLEnforceRangeAdaptor<IDLUnsignedLong>> { return Converter<IDLEnforceRangeAdaptor<IDLUnsignedLong>>::ReturnType { 0 }; });
    if (stencilClearValueConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.stencilClearValue = stencilClearValueConversionResult.releaseReturnValue();
    JSValue stencilLoadOpValue;
    if (isNullOrUndefined)
        stencilLoadOpValue = jsUndefined();
    else {
        stencilLoadOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilLoadOp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!stencilLoadOpValue.isUndefined()) {
        auto stencilLoadOpConversionResult = convert<IDLEnumeration<GPULoadOp>>(lexicalGlobalObject, stencilLoadOpValue);
        if (stencilLoadOpConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.stencilLoadOp = stencilLoadOpConversionResult.releaseReturnValue();
    }
    JSValue stencilReadOnlyValue;
    if (isNullOrUndefined)
        stencilReadOnlyValue = jsUndefined();
    else {
        stencilReadOnlyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilReadOnly"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto stencilReadOnlyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, stencilReadOnlyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (stencilReadOnlyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.stencilReadOnly = stencilReadOnlyConversionResult.releaseReturnValue();
    JSValue stencilStoreOpValue;
    if (isNullOrUndefined)
        stencilStoreOpValue = jsUndefined();
    else {
        stencilStoreOpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stencilStoreOp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!stencilStoreOpValue.isUndefined()) {
        auto stencilStoreOpConversionResult = convert<IDLEnumeration<GPUStoreOp>>(lexicalGlobalObject, stencilStoreOpValue);
        if (stencilStoreOpConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.stencilStoreOp = stencilStoreOpConversionResult.releaseReturnValue();
    }
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (viewValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "view"_s, "GPURenderPassDepthStencilAttachment"_s, "GPUTextureView"_s);
        return ConversionResultException { };
    }
    auto viewConversionResult = convert<IDLInterface<GPUTextureView>>(lexicalGlobalObject, viewValue);
    if (viewConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.view = viewConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

