/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/comm/mailnews/base/public/nsIMsgFolder.idl
 */

#ifndef __gen_nsIMsgFolder_h__
#define __gen_nsIMsgFolder_h__


#include "nsISupports.h"

#include "nsIFolderListener.h"

#include "nsIMsgIncomingServer.h"

#include "nsIMsgCopyServiceListener.h"

#include "nsIMsgDBView.h"

#include "nsIUrlListener.h"

#include "nsIMsgEnumerator.h"

#include "nsTArray.h"

#include "js/GCAnnotations.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIMsgDBHdr; /* forward declaration */

class nsIMsgWindow; /* forward declaration */

class nsIMsgDatabase; /* forward declaration */

class nsIDBFolderInfo; /* forward declaration */

class nsIMsgFilterList; /* forward declaration */

class nsIFile; /* forward declaration */

class nsIOutputStream; /* forward declaration */

class nsIInputStream; /* forward declaration */

class nsIMsgIdentity; /* forward declaration */

class nsIMsgThread; /* forward declaration */

class nsIMsgPluggableStore; /* forward declaration */

class nsIPropertyBag2; /* forward declaration */

typedef int32_t  nsMsgBiffState;

typedef int32_t  nsMsgDispositionState;


/* starting interface:    nsIMsgFolderService */
#define NS_IMSGFOLDERSERVICE_IID_STR "5639c204-48ac-4115-897f-3b16821fe118"

#define NS_IMSGFOLDERSERVICE_IID \
  {0x5639c204, 0x48ac, 0x4115, \
    { 0x89, 0x7f, 0x3b, 0x16, 0x82, 0x1f, 0xe1, 0x18 }}

class NS_NO_VTABLE nsIMsgFolderService : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IMSGFOLDERSERVICE_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIMsgFolderService;

  /* void initializeFolderStrings (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD InitializeFolderStrings(void) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGFOLDERSERVICE \
  NS_IMETHOD InitializeFolderStrings(void) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIMSGFOLDERSERVICE \
  nsresult InitializeFolderStrings(void); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGFOLDERSERVICE(_to) \
  NS_IMETHOD InitializeFolderStrings(void) override { return _to InitializeFolderStrings(); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGFOLDERSERVICE(_to) \
  NS_IMETHOD InitializeFolderStrings(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->InitializeFolderStrings(); } 


/* starting interface:    nsIMsgFolder */
#define NS_IMSGFOLDER_IID_STR "5d253ba2-42aa-43a7-b584-0059855ababf"

#define NS_IMSGFOLDER_IID \
  {0x5d253ba2, 0x42aa, 0x43a7, \
    { 0xb5, 0x84, 0x00, 0x59, 0x85, 0x5a, 0xba, 0xbf }}

class nsIMsgFolder : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IMSGFOLDER_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIMsgFolder;

  enum {
    nsMsgBiffState_NewMail = 0,
    nsMsgBiffState_NoMail = 1,
    nsMsgBiffState_Unknown = 2
  };

  /* readonly attribute unsigned long long id; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetId(uint64_t *aId) = 0;

  /* readonly attribute AUTF8String path; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetPath(nsACString& aPath) = 0;

   inline nsCString GetPath() {
    nsAutoCString path;
    mozilla::DebugOnly<nsresult> rv = GetPath(path);
    MOZ_ASSERT(NS_SUCCEEDED(rv));
    return path;
  }
  /* readonly attribute AUTF8String URI; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetURI(nsACString& aURI) = 0;

  /* attribute AUTF8String name; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetName(nsACString& aName) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetName(const nsACString& aName) = 0;

  /* readonly attribute AString localizedName; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetLocalizedName(nsAString& aLocalizedName) = 0;

  /* readonly attribute AString abbreviatedName; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetAbbreviatedName(nsAString& aAbbreviatedName) = 0;

  /* readonly attribute AUTF8String prettyPath; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetPrettyPath(nsACString& aPrettyPath) = 0;

   /**
   * C++ shortcut to folder URI, for logging and debugging.
   */
  nsCString URI();
  /* attribute nsIMsgFolder parent; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetParent(nsIMsgFolder **aParent) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetParent(nsIMsgFolder *aParent) = 0;

  /* readonly attribute nsIMsgEnumerator messages; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetMessages(nsIMsgEnumerator **aMessages) = 0;

  /* void Init (in AUTF8String uri); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD Init(const nsACString& uri) = 0;

  /* void initWithFolderId (in unsigned long long folderId); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD InitWithFolderId(uint64_t folderId) = 0;

  /* void startFolderLoading (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD StartFolderLoading(void) = 0;

  /* void endFolderLoading (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD EndFolderLoading(void) = 0;

  /* void folderNamesReady (out boolean aReady); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD FolderNamesReady(bool *aReady) = 0;

  /* void updateFolder (in nsIMsgWindow aWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD UpdateFolder(nsIMsgWindow *aWindow) = 0;

  /* readonly attribute nsIMsgIncomingServer server; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetServer(nsIMsgIncomingServer **aServer) = 0;

  /* readonly attribute boolean isServer; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetIsServer(bool *aIsServer) = 0;

  /* readonly attribute boolean canSubscribe; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetCanSubscribe(bool *aCanSubscribe) = 0;

  /* readonly attribute boolean canFileMessages; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetCanFileMessages(bool *aCanFileMessages) = 0;

  /* readonly attribute boolean noSelect; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetNoSelect(bool *aNoSelect) = 0;

  /* readonly attribute boolean imapShared; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetImapShared(bool *aImapShared) = 0;

  /* readonly attribute boolean canDeleteMessages; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetCanDeleteMessages(bool *aCanDeleteMessages) = 0;

  /* readonly attribute boolean canCreateSubfolders; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetCanCreateSubfolders(bool *aCanCreateSubfolders) = 0;

  /* readonly attribute boolean canRename; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetCanRename(bool *aCanRename) = 0;

  /* readonly attribute boolean canCompact; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetCanCompact(bool *aCanCompact) = 0;

  /* readonly attribute nsIMsgFolder rootFolder; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetRootFolder(nsIMsgFolder **aRootFolder) = 0;

  /* nsIMsgFilterList getFilterList (in nsIMsgWindow msgWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetFilterList(nsIMsgWindow *msgWindow, nsIMsgFilterList **_retval) = 0;

  /* void setFilterList (in nsIMsgFilterList filterList); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetFilterList(nsIMsgFilterList *filterList) = 0;

  /* nsIMsgFilterList getEditableFilterList (in nsIMsgWindow aMsgWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetEditableFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval) = 0;

  /* void setEditableFilterList (in nsIMsgFilterList aFilterList); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetEditableFilterList(nsIMsgFilterList *aFilterList) = 0;

  /* void CloseDatabase (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CloseDatabase(void) = 0;

  /* void ForceDBClosed (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ForceDBClosed(void) = 0;

  /* void closeAndBackupFolderDB (in ACString newName); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CloseAndBackupFolderDB(const nsACString& newName) = 0;

  /* [noscript] void deleteStorage (); */
  NS_IMETHOD DeleteStorage(void) = 0;

  /* void deleteSelf (in nsIMsgWindow msgWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD DeleteSelf(nsIMsgWindow *msgWindow) = 0;

  /* void propagateDelete (in nsIMsgFolder folder, in boolean deleteStorage); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD PropagateDelete(nsIMsgFolder *folder, bool deleteStorage) = 0;

  /* [noscript] void recursiveDelete (in boolean deleteStorage); */
  NS_IMETHOD RecursiveDelete(bool deleteStorage) = 0;

  /* void createSubfolder (in AUTF8String folderName, in nsIMsgWindow msgWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CreateSubfolder(const nsACString& folderName, nsIMsgWindow *msgWindow) = 0;

  /* nsIMsgFolder addSubfolder (in AUTF8String aFolderName); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD AddSubfolder(const nsACString& aFolderName, nsIMsgFolder **_retval) = 0;

  /* void createStorageIfMissing (in nsIUrlListener urlListener); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CreateStorageIfMissing(nsIUrlListener *urlListener) = 0;

  /* void compact (in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD Compact(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) = 0;

  /* void compactAll (in nsIUrlListener aListener, in nsIMsgWindow aMsgWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CompactAll(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) = 0;

  /* void emptyTrash (in nsIUrlListener aListener); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD EmptyTrash(nsIUrlListener *aListener) = 0;

  /* void rename (in AUTF8String name, in nsIMsgWindow msgWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD Rename(const nsACString& name, nsIMsgWindow *msgWindow) = 0;

  /* void renameSubFolders (in nsIMsgWindow msgWindow, in nsIMsgFolder oldFolder); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD RenameSubFolders(nsIMsgWindow *msgWindow, nsIMsgFolder *oldFolder) = 0;

  /* AUTF8String generateUniqueSubfolderName (in AUTF8String prefix, in nsIMsgFolder otherFolder); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GenerateUniqueSubfolderName(const nsACString& prefix, nsIMsgFolder *otherFolder, nsACString& _retval) = 0;

  /* void updateSummaryTotals (in boolean force); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD UpdateSummaryTotals(bool force) = 0;

  /* void summaryChanged (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SummaryChanged(void) = 0;

  /* long getNumUnread (in boolean deep); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetNumUnread(bool deep, int32_t *_retval) = 0;

  /* long getTotalMessages (in boolean deep); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetTotalMessages(bool deep, int32_t *_retval) = 0;

  /* readonly attribute long numPendingUnread; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetNumPendingUnread(int32_t *aNumPendingUnread) = 0;

  /* readonly attribute long numPendingTotalMessages; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetNumPendingTotalMessages(int32_t *aNumPendingTotalMessages) = 0;

  /* void changeNumPendingUnread (in long delta); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ChangeNumPendingUnread(int32_t delta) = 0;

  /* void changeNumPendingTotalMessages (in long delta); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ChangeNumPendingTotalMessages(int32_t delta) = 0;

  /* attribute boolean hasNewMessages; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetHasNewMessages(bool *aHasNewMessages) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetHasNewMessages(bool aHasNewMessages) = 0;

  /* readonly attribute boolean hasFolderOrSubfolderNewMessages; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetHasFolderOrSubfolderNewMessages(bool *aHasFolderOrSubfolderNewMessages) = 0;

  /* readonly attribute nsIMsgDBHdr firstNewMessage; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetFirstNewMessage(nsIMsgDBHdr **aFirstNewMessage) = 0;

  /* void clearNewMessages (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ClearNewMessages(void) = 0;

  /* readonly attribute long long expungedBytes; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetExpungedBytes(int64_t *aExpungedBytes) = 0;

  /* readonly attribute boolean deletable; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetDeletable(bool *aDeletable) = 0;

  /* readonly attribute ACString relativePathName; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetRelativePathName(nsACString& aRelativePathName) = 0;

  /* attribute long long sizeOnDisk; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetSizeOnDisk(int64_t *aSizeOnDisk) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetSizeOnDisk(int64_t aSizeOnDisk) = 0;

  /* readonly attribute long long sizeOnDiskWithSubFolders; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetSizeOnDiskWithSubFolders(int64_t *aSizeOnDiskWithSubFolders) = 0;

  /* readonly attribute ACString username; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetUsername(nsACString& aUsername) = 0;

  /* readonly attribute ACString hostname; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetHostname(nsACString& aHostname) = 0;

  /* void setFlag (in unsigned long flag); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetFlag(uint32_t flag) = 0;

  /* void clearFlag (in unsigned long flag); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ClearFlag(uint32_t flag) = 0;

  /* boolean getFlag (in unsigned long flag); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetFlag(uint32_t flag, bool *_retval) = 0;

  /* void toggleFlag (in unsigned long flag); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ToggleFlag(uint32_t flag) = 0;

  /* void onFlagChange (in unsigned long flag); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnFlagChange(uint32_t flag) = 0;

  /* attribute unsigned long flags; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetFlags(uint32_t *aFlags) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetFlags(uint32_t aFlags) = 0;

  /* nsIMsgFolder getFolderWithFlags (in unsigned long flags); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetFolderWithFlags(uint32_t flags, nsIMsgFolder **_retval) = 0;

  /* Array<nsIMsgFolder> getFoldersWithFlags (in unsigned long flags); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetFoldersWithFlags(uint32_t flags, nsTArray<RefPtr<nsIMsgFolder>>& _retval) = 0;

  /* boolean isSpecialFolder (in unsigned long flags, [optional] in boolean checkAncestors); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD IsSpecialFolder(uint32_t flags, bool checkAncestors, bool *_retval) = 0;

  /* AUTF8String getUriForMsg (in nsIMsgDBHdr msgHdr); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetUriForMsg(nsIMsgDBHdr *msgHdr, nsACString& _retval) = 0;

  /* void deleteMessages (in Array<nsIMsgDBHdr> messages, in nsIMsgWindow msgWindow, in boolean deleteStorage, in boolean isMove, in nsIMsgCopyServiceListener listener, in boolean allowUndo); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD DeleteMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsIMsgWindow *msgWindow, bool deleteStorage, bool isMove, nsIMsgCopyServiceListener *listener, bool allowUndo) = 0;

  /* void copyMessages (in nsIMsgFolder srcFolder, in Array<nsIMsgDBHdr> messages, in boolean isMove, in nsIMsgWindow msgWindow, in nsIMsgCopyServiceListener listener, in boolean isFolder, in boolean allowUndo); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CopyMessages(nsIMsgFolder *srcFolder, const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool isMove, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener, bool isFolder, bool allowUndo) = 0;

  /* void copyFolder (in nsIMsgFolder srcFolder, in boolean isMoveFolder, in nsIMsgWindow msgWindow, in nsIMsgCopyServiceListener listener); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CopyFolder(nsIMsgFolder *srcFolder, bool isMoveFolder, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) = 0;

  /* void copyFileMessage (in nsIFile file, in nsIMsgDBHdr msgToReplace, in boolean isDraft, in unsigned long newMsgFlags, in ACString aKeywords, in nsIMsgWindow msgWindow, in nsIMsgCopyServiceListener listener); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CopyFileMessage(nsIFile *file, nsIMsgDBHdr *msgToReplace, bool isDraft, uint32_t newMsgFlags, const nsACString& aKeywords, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) = 0;

  /* void acquireSemaphore (in nsISupports semHolder, in AUTF8String logText); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD AcquireSemaphore(nsISupports *semHolder, const nsACString& logText) = 0;

  /* void releaseSemaphore (in nsISupports semHolder, in AUTF8String logText); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ReleaseSemaphore(nsISupports *semHolder, const nsACString& logText) = 0;

  /* boolean testSemaphore (in nsISupports semHolder); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD TestSemaphore(nsISupports *semHolder, bool *_retval) = 0;

  /* readonly attribute boolean locked; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetLocked(bool *aLocked) = 0;

  /* void getNewMessages (in nsIMsgWindow aWindow, in nsIUrlListener aListener); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetNewMessages(nsIMsgWindow *aWindow, nsIUrlListener *aListener) = 0;

  /* void writeToFolderCache (in nsIMsgFolderCache folderCache, in boolean deep); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache, bool deep) = 0;

  /* attribute unsigned long biffState; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetBiffState(uint32_t *aBiffState) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetBiffState(uint32_t aBiffState) = 0;

  /* long getNumNewMessages (in boolean deep); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetNumNewMessages(bool deep, int32_t *_retval) = 0;

  /* void setNumNewMessages (in long numNewMessages); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetNumNewMessages(int32_t numNewMessages) = 0;

  /* attribute boolean gettingNewMessages; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetGettingNewMessages(bool *aGettingNewMessages) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetGettingNewMessages(bool aGettingNewMessages) = 0;

  /* attribute nsIFile filePath; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetFilePath(nsIFile **aFilePath) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetFilePath(nsIFile *aFilePath) = 0;

  /* readonly attribute nsIFile summaryFile; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetSummaryFile(nsIFile **aSummaryFile) = 0;

  /* readonly attribute AUTF8String baseMessageURI; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetBaseMessageURI(nsACString& aBaseMessageURI) = 0;

  /* AUTF8String generateMessageURI (in nsMsgKey msgKey); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GenerateMessageURI(nsMsgKey msgKey, nsACString& _retval) = 0;

  enum {
    nsMsgDispositionState_None = -1,
    nsMsgDispositionState_Replied = 0,
    nsMsgDispositionState_Forwarded = 1,
    nsMsgDispositionState_Redirected = 2
  };

  /* void addMessageDispositionState (in nsIMsgDBHdr aMessage, in nsMsgDispositionState aDispositionFlag); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD AddMessageDispositionState(nsIMsgDBHdr *aMessage, nsMsgDispositionState aDispositionFlag) = 0;

  /* void markMessagesRead (in Array<nsIMsgDBHdr> messages, in boolean markRead); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD MarkMessagesRead(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool markRead) = 0;

  /* void markAllMessagesRead (in nsIMsgWindow aMsgWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD MarkAllMessagesRead(nsIMsgWindow *aMsgWindow) = 0;

  /* void markMessagesFlagged (in Array<nsIMsgDBHdr> messages, in boolean markFlagged); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD MarkMessagesFlagged(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool markFlagged) = 0;

  /* void markThreadRead (in nsIMsgThread thread); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD MarkThreadRead(nsIMsgThread *thread) = 0;

  /* attribute nsIMsgDatabase msgDatabase; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetMsgDatabase(nsIMsgDatabase **aMsgDatabase) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetMsgDatabase(nsIMsgDatabase *aMsgDatabase) = 0;

  /* readonly attribute boolean databaseOpen; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetDatabaseOpen(bool *aDatabaseOpen) = 0;

  /* nsIMsgDatabase getBackupMsgDatabase (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetBackupMsgDatabase(nsIMsgDatabase **_retval) = 0;

  /* void removeBackupMsgDatabase (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD RemoveBackupMsgDatabase(void) = 0;

  /* void openBackupMsgDatabase (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OpenBackupMsgDatabase(void) = 0;

  /* nsIMsgDatabase getDBFolderInfoAndDB (out nsIDBFolderInfo folderInfo); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetDBFolderInfoAndDB(nsIDBFolderInfo **folderInfo, nsIMsgDatabase **_retval) = 0;

  /* nsIMsgDBHdr GetMessageHeader (in nsMsgKey msgKey); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetMessageHeader(nsMsgKey msgKey, nsIMsgDBHdr **_retval) = 0;

  /* readonly attribute boolean supportsOffline; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetSupportsOffline(bool *aSupportsOffline) = 0;

  /* boolean shouldStoreMsgOffline (in nsMsgKey msgKey); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ShouldStoreMsgOffline(nsMsgKey msgKey, bool *_retval) = 0;

  /* boolean hasMsgOffline (in nsMsgKey msgKey); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD HasMsgOffline(nsMsgKey msgKey, bool *_retval) = 0;

  /* void discardOfflineMsg (in nsMsgKey msgKey); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD DiscardOfflineMsg(nsMsgKey msgKey) = 0;

  /* nsIInputStream getMsgInputStream (in nsIMsgDBHdr aHdr); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetMsgInputStream(nsIMsgDBHdr *aHdr, nsIInputStream **_retval) = 0;

  /* nsIInputStream getLocalMsgStream (in nsIMsgDBHdr aHdr); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetLocalMsgStream(nsIMsgDBHdr *aHdr, nsIInputStream **_retval) = 0;

  /* void downloadMessagesForOffline (in Array<nsIMsgDBHdr> messages, in nsIMsgWindow window); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD DownloadMessagesForOffline(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsIMsgWindow *window) = 0;

  /* nsIMsgFolder getChildWithURI (in AUTF8String uri, in boolean deep, in boolean caseInsensitive); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetChildWithURI(const nsACString& uri, bool deep, bool caseInsensitive, nsIMsgFolder **_retval) = 0;

  /* void downloadAllForOffline (in nsIUrlListener listener, in nsIMsgWindow window); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD DownloadAllForOffline(nsIUrlListener *listener, nsIMsgWindow *window) = 0;

  enum {
    allMessageCountNotifications = 0U
  };

  /* void enableNotifications (in long notificationType, in boolean enable); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD EnableNotifications(int32_t notificationType, bool enable) = 0;

  /* boolean isCommandEnabled (in ACString command); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD IsCommandEnabled(const nsACString& command, bool *_retval) = 0;

  /* boolean matchOrChangeFilterDestination (in nsIMsgFolder folder, in boolean caseInsensitive); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD MatchOrChangeFilterDestination(nsIMsgFolder *folder, bool caseInsensitive, bool *_retval) = 0;

  /* boolean confirmFolderDeletionForFilter (in nsIMsgWindow msgWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ConfirmFolderDeletionForFilter(nsIMsgWindow *msgWindow, bool *_retval) = 0;

  /* void alertFilterChanged (in nsIMsgWindow msgWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD AlertFilterChanged(nsIMsgWindow *msgWindow) = 0;

  /* void throwAlertMsg (in string msgName, in nsIMsgWindow msgWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ThrowAlertMsg(const char * msgName, nsIMsgWindow *msgWindow) = 0;

  /* AString getStringWithFolderNameFromBundle (in string msgName); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetStringWithFolderNameFromBundle(const char * msgName, nsAString& _retval) = 0;

  /* void notifyAboutToCompact (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD NotifyAboutToCompact(void) = 0;

  /* void notifyCompactCompleted (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD NotifyCompactCompleted(void) = 0;

  /* attribute nsIMsgRetentionSettings retentionSettings; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings **aRetentionSettings) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings *aRetentionSettings) = 0;

  /* attribute nsIMsgDownloadSettings downloadSettings; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings **aDownloadSettings) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings *aDownloadSettings) = 0;

  /* boolean callFilterPlugins (in nsIMsgWindow aMsgWindow); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CallFilterPlugins(nsIMsgWindow *aMsgWindow, bool *_retval) = 0;

  /* attribute long sortOrder; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetSortOrder(int32_t *aSortOrder) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetSortOrder(int32_t aSortOrder) = 0;

  /* attribute unsigned long userSortOrder; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetUserSortOrder(uint32_t *aUserSortOrder) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetUserSortOrder(uint32_t aUserSortOrder) = 0;

  enum {
    NO_SORT_VALUE = 4294967295U
  };

  /* attribute nsIPropertyBag2 dBTransferInfo; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetDBTransferInfo(nsIPropertyBag2 **aDBTransferInfo) = 0;
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetDBTransferInfo(nsIPropertyBag2 *aDBTransferInfo) = 0;

  /* void setStringProperty (in string propertyName, in AUTF8String propertyValue); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetStringProperty(const char * propertyName, const nsACString& propertyValue) = 0;

  /* AUTF8String getStringProperty (in string propertyName); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetStringProperty(const char * propertyName, nsACString& _retval) = 0;

  /* readonly attribute Array<nsIMsgFolder> subFolders; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetSubFolders(nsTArray<RefPtr<nsIMsgFolder>>& aSubFolders) = 0;

  /* readonly attribute boolean hasSubFolders; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetHasSubFolders(bool *aHasSubFolders) = 0;

  /* readonly attribute unsigned long numSubFolders; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetNumSubFolders(uint32_t *aNumSubFolders) = 0;

  /* boolean isAncestorOf (in nsIMsgFolder folder); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD IsAncestorOf(nsIMsgFolder *folder, bool *_retval) = 0;

  /* boolean containsChildNamed (in AUTF8String name); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ContainsChildNamed(const nsACString& name, bool *_retval) = 0;

  /* nsIMsgFolder getChildNamed (in AUTF8String name); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetChildNamed(const nsACString& name, nsIMsgFolder **_retval) = 0;

  /* nsIMsgFolder findSubFolder (in ACString escapedSubFolderName); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD FindSubFolder(const nsACString& escapedSubFolderName, nsIMsgFolder **_retval) = 0;

  /* void AddFolderListener (in nsIFolderListener listener); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD AddFolderListener(nsIFolderListener *listener) = 0;

  /* void RemoveFolderListener (in nsIFolderListener listener); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD RemoveFolderListener(nsIFolderListener *listener) = 0;

  /* void NotifyPropertyChanged (in ACString property, in ACString oldValue, in ACString newValue); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD NotifyPropertyChanged(const nsACString& property, const nsACString& oldValue, const nsACString& newValue) = 0;

  /* void NotifyIntPropertyChanged (in ACString property, in long long oldValue, in long long newValue); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD NotifyIntPropertyChanged(const nsACString& property, int64_t oldValue, int64_t newValue) = 0;

  /* void NotifyBoolPropertyChanged (in ACString property, in boolean oldValue, in boolean newValue); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD NotifyBoolPropertyChanged(const nsACString& property, bool oldValue, bool newValue) = 0;

  /* void NotifyPropertyFlagChanged (in nsIMsgDBHdr item, in ACString property, in unsigned long oldValue, in unsigned long newValue); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD NotifyPropertyFlagChanged(nsIMsgDBHdr *item, const nsACString& property, uint32_t oldValue, uint32_t newValue) = 0;

  /* void notifyMessageAdded (in nsIMsgDBHdr msg); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD NotifyMessageAdded(nsIMsgDBHdr *msg) = 0;

  /* void notifyMessageRemoved (in nsIMsgDBHdr msg); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD NotifyMessageRemoved(nsIMsgDBHdr *msg) = 0;

  /* void notifyFolderAdded (in nsIMsgFolder child); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD NotifyFolderAdded(nsIMsgFolder *child) = 0;

  /* void notifyFolderRemoved (in nsIMsgFolder child); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD NotifyFolderRemoved(nsIMsgFolder *child) = 0;

  /* void NotifyFolderEvent (in ACString event); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD NotifyFolderEvent(const nsACString& event) = 0;

  /* readonly attribute Array<nsIMsgFolder> descendants; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetDescendants(nsTArray<RefPtr<nsIMsgFolder>>& aDescendants) = 0;

  /* void Shutdown (in boolean shutdownChildren); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD Shutdown(bool shutdownChildren) = 0;

  /* void copyDataToOutputStreamForAppend (in nsIInputStream aIStream, in long aLength, in nsIOutputStream outputStream); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CopyDataToOutputStreamForAppend(nsIInputStream *aIStream, int32_t aLength, nsIOutputStream *outputStream) = 0;

  /* void copyDataDone (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD CopyDataDone(void) = 0;

  /* void setJunkScoreForMessages (in Array<nsIMsgDBHdr> messages, in nsMsgJunkScore junkScore, in ACString junkScoreOrigin, in long junkPercent); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD SetJunkScoreForMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsMsgJunkScore junkScore, const nsACString& junkScoreOrigin, int32_t junkPercent) = 0;

  /* void performActionsOnJunkMsgs (in Array<nsIMsgDBHdr> messages, in boolean msgsAreJunk, [optional] in nsIMsgWindow msgWindow, [optional] in nsIUrlListener listener); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD PerformActionsOnJunkMsgs(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool msgsAreJunk, nsIMsgWindow *msgWindow, nsIUrlListener *listener) = 0;

  /* void applyRetentionSettings (); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ApplyRetentionSettings(void) = 0;

  /* boolean fetchMsgPreviewText (in Array<nsMsgKey> aKeysToFetch, in nsIUrlListener aUrlListener); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD FetchMsgPreviewText(const nsTArray<nsMsgKey >& aKeysToFetch, nsIUrlListener *aUrlListener, bool *_retval) = 0;

  /* void addKeywordsToMessages (in Array<nsIMsgDBHdr> aMessages, in ACString aKeywords); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD AddKeywordsToMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& aMessages, const nsACString& aKeywords) = 0;

  /* void removeKeywordsFromMessages (in Array<nsIMsgDBHdr> aMessages, in ACString aKeywords); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD RemoveKeywordsFromMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& aMessages, const nsACString& aKeywords) = 0;

  /* AUTF8String getMsgTextFromStream (in nsIInputStream aStream, in ACString aCharset, in unsigned long aBytesToRead, in unsigned long aMaxOutputLen, in boolean aCompressQuotes, in boolean aStripHTMLTags, out ACString aContentType); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetMsgTextFromStream(nsIInputStream *aStream, const nsACString& aCharset, uint32_t aBytesToRead, uint32_t aMaxOutputLen, bool aCompressQuotes, bool aStripHTMLTags, nsACString& aContentType, nsACString& _retval) = 0;

  /* AString convertMsgSnippetToPlainText (in AString aMessageText); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD ConvertMsgSnippetToPlainText(const nsAString& aMessageText, nsAString& _retval) = 0;

  /* readonly attribute nsIMsgIdentity customIdentity; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetCustomIdentity(nsIMsgIdentity **aCustomIdentity) = 0;

  /* unsigned long getProcessingFlags (in nsMsgKey msgKey); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetProcessingFlags(nsMsgKey msgKey, uint32_t *_retval) = 0;

  /* void orProcessingFlags (in nsMsgKey msgKey, in unsigned long mask); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OrProcessingFlags(nsMsgKey msgKey, uint32_t mask) = 0;

  /* void andProcessingFlags (in nsMsgKey msgKey, in unsigned long mask); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD AndProcessingFlags(nsMsgKey msgKey, uint32_t mask) = 0;

  /* AUTF8String getInheritedStringProperty (in string propertyName); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetInheritedStringProperty(const char * propertyName, nsACString& _retval) = 0;

  /* readonly attribute nsIMsgPluggableStore msgStore; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetMsgStore(nsIMsgPluggableStore **aMsgStore) = 0;

  /* readonly attribute ACString incomingServerType; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetIncomingServerType(nsACString& aIncomingServerType) = 0;

  /* void handleViewCommand (in nsMsgViewCommandTypeValue command, in Array<nsMsgKey> messageKeys, in nsIMsgWindow window, in nsIMsgCopyServiceListener listener); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD HandleViewCommand(nsMsgViewCommandTypeValue command, const nsTArray<nsMsgKey >& messageKeys, nsIMsgWindow *window, nsIMsgCopyServiceListener *listener) = 0;

  /* void updateTimestamps (in boolean userInitiated); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD UpdateTimestamps(bool userInitiated) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMSGFOLDER \
  NS_IMETHOD GetId(uint64_t *aId) override; \
  NS_IMETHOD GetPath(nsACString& aPath) override; \
  NS_IMETHOD GetURI(nsACString& aURI) override; \
  NS_IMETHOD GetName(nsACString& aName) override; \
  NS_IMETHOD SetName(const nsACString& aName) override; \
  NS_IMETHOD GetLocalizedName(nsAString& aLocalizedName) override; \
  NS_IMETHOD GetAbbreviatedName(nsAString& aAbbreviatedName) override; \
  NS_IMETHOD GetPrettyPath(nsACString& aPrettyPath) override; \
  NS_IMETHOD GetParent(nsIMsgFolder **aParent) override; \
  NS_IMETHOD SetParent(nsIMsgFolder *aParent) override; \
  NS_IMETHOD GetMessages(nsIMsgEnumerator **aMessages) override; \
  NS_IMETHOD Init(const nsACString& uri) override; \
  NS_IMETHOD InitWithFolderId(uint64_t folderId) override; \
  NS_IMETHOD StartFolderLoading(void) override; \
  NS_IMETHOD EndFolderLoading(void) override; \
  NS_IMETHOD FolderNamesReady(bool *aReady) override; \
  NS_IMETHOD UpdateFolder(nsIMsgWindow *aWindow) override; \
  NS_IMETHOD GetServer(nsIMsgIncomingServer **aServer) override; \
  NS_IMETHOD GetIsServer(bool *aIsServer) override; \
  NS_IMETHOD GetCanSubscribe(bool *aCanSubscribe) override; \
  NS_IMETHOD GetCanFileMessages(bool *aCanFileMessages) override; \
  NS_IMETHOD GetNoSelect(bool *aNoSelect) override; \
  NS_IMETHOD GetImapShared(bool *aImapShared) override; \
  NS_IMETHOD GetCanDeleteMessages(bool *aCanDeleteMessages) override; \
  NS_IMETHOD GetCanCreateSubfolders(bool *aCanCreateSubfolders) override; \
  NS_IMETHOD GetCanRename(bool *aCanRename) override; \
  NS_IMETHOD GetCanCompact(bool *aCanCompact) override; \
  NS_IMETHOD GetRootFolder(nsIMsgFolder **aRootFolder) override; \
  NS_IMETHOD GetFilterList(nsIMsgWindow *msgWindow, nsIMsgFilterList **_retval) override; \
  NS_IMETHOD SetFilterList(nsIMsgFilterList *filterList) override; \
  NS_IMETHOD GetEditableFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval) override; \
  NS_IMETHOD SetEditableFilterList(nsIMsgFilterList *aFilterList) override; \
  NS_IMETHOD CloseDatabase(void) override; \
  NS_IMETHOD ForceDBClosed(void) override; \
  NS_IMETHOD CloseAndBackupFolderDB(const nsACString& newName) override; \
  NS_IMETHOD DeleteStorage(void) override; \
  NS_IMETHOD DeleteSelf(nsIMsgWindow *msgWindow) override; \
  NS_IMETHOD PropagateDelete(nsIMsgFolder *folder, bool deleteStorage) override; \
  NS_IMETHOD RecursiveDelete(bool deleteStorage) override; \
  NS_IMETHOD CreateSubfolder(const nsACString& folderName, nsIMsgWindow *msgWindow) override; \
  NS_IMETHOD AddSubfolder(const nsACString& aFolderName, nsIMsgFolder **_retval) override; \
  NS_IMETHOD CreateStorageIfMissing(nsIUrlListener *urlListener) override; \
  NS_IMETHOD Compact(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) override; \
  NS_IMETHOD CompactAll(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) override; \
  NS_IMETHOD EmptyTrash(nsIUrlListener *aListener) override; \
  NS_IMETHOD Rename(const nsACString& name, nsIMsgWindow *msgWindow) override; \
  NS_IMETHOD RenameSubFolders(nsIMsgWindow *msgWindow, nsIMsgFolder *oldFolder) override; \
  NS_IMETHOD GenerateUniqueSubfolderName(const nsACString& prefix, nsIMsgFolder *otherFolder, nsACString& _retval) override; \
  NS_IMETHOD UpdateSummaryTotals(bool force) override; \
  NS_IMETHOD SummaryChanged(void) override; \
  NS_IMETHOD GetNumUnread(bool deep, int32_t *_retval) override; \
  NS_IMETHOD GetTotalMessages(bool deep, int32_t *_retval) override; \
  NS_IMETHOD GetNumPendingUnread(int32_t *aNumPendingUnread) override; \
  NS_IMETHOD GetNumPendingTotalMessages(int32_t *aNumPendingTotalMessages) override; \
  NS_IMETHOD ChangeNumPendingUnread(int32_t delta) override; \
  NS_IMETHOD ChangeNumPendingTotalMessages(int32_t delta) override; \
  NS_IMETHOD GetHasNewMessages(bool *aHasNewMessages) override; \
  NS_IMETHOD SetHasNewMessages(bool aHasNewMessages) override; \
  NS_IMETHOD GetHasFolderOrSubfolderNewMessages(bool *aHasFolderOrSubfolderNewMessages) override; \
  NS_IMETHOD GetFirstNewMessage(nsIMsgDBHdr **aFirstNewMessage) override; \
  NS_IMETHOD ClearNewMessages(void) override; \
  NS_IMETHOD GetExpungedBytes(int64_t *aExpungedBytes) override; \
  NS_IMETHOD GetDeletable(bool *aDeletable) override; \
  NS_IMETHOD GetRelativePathName(nsACString& aRelativePathName) override; \
  NS_IMETHOD GetSizeOnDisk(int64_t *aSizeOnDisk) override; \
  NS_IMETHOD SetSizeOnDisk(int64_t aSizeOnDisk) override; \
  NS_IMETHOD GetSizeOnDiskWithSubFolders(int64_t *aSizeOnDiskWithSubFolders) override; \
  NS_IMETHOD GetUsername(nsACString& aUsername) override; \
  NS_IMETHOD GetHostname(nsACString& aHostname) override; \
  NS_IMETHOD SetFlag(uint32_t flag) override; \
  NS_IMETHOD ClearFlag(uint32_t flag) override; \
  NS_IMETHOD GetFlag(uint32_t flag, bool *_retval) override; \
  NS_IMETHOD ToggleFlag(uint32_t flag) override; \
  NS_IMETHOD OnFlagChange(uint32_t flag) override; \
  NS_IMETHOD GetFlags(uint32_t *aFlags) override; \
  NS_IMETHOD SetFlags(uint32_t aFlags) override; \
  NS_IMETHOD GetFolderWithFlags(uint32_t flags, nsIMsgFolder **_retval) override; \
  NS_IMETHOD GetFoldersWithFlags(uint32_t flags, nsTArray<RefPtr<nsIMsgFolder>>& _retval) override; \
  NS_IMETHOD IsSpecialFolder(uint32_t flags, bool checkAncestors, bool *_retval) override; \
  NS_IMETHOD GetUriForMsg(nsIMsgDBHdr *msgHdr, nsACString& _retval) override; \
  NS_IMETHOD DeleteMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsIMsgWindow *msgWindow, bool deleteStorage, bool isMove, nsIMsgCopyServiceListener *listener, bool allowUndo) override; \
  NS_IMETHOD CopyMessages(nsIMsgFolder *srcFolder, const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool isMove, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener, bool isFolder, bool allowUndo) override; \
  NS_IMETHOD CopyFolder(nsIMsgFolder *srcFolder, bool isMoveFolder, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) override; \
  NS_IMETHOD CopyFileMessage(nsIFile *file, nsIMsgDBHdr *msgToReplace, bool isDraft, uint32_t newMsgFlags, const nsACString& aKeywords, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) override; \
  NS_IMETHOD AcquireSemaphore(nsISupports *semHolder, const nsACString& logText) override; \
  NS_IMETHOD ReleaseSemaphore(nsISupports *semHolder, const nsACString& logText) override; \
  NS_IMETHOD TestSemaphore(nsISupports *semHolder, bool *_retval) override; \
  NS_IMETHOD GetLocked(bool *aLocked) override; \
  NS_IMETHOD GetNewMessages(nsIMsgWindow *aWindow, nsIUrlListener *aListener) override; \
  NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache, bool deep) override; \
  NS_IMETHOD GetBiffState(uint32_t *aBiffState) override; \
  NS_IMETHOD SetBiffState(uint32_t aBiffState) override; \
  NS_IMETHOD GetNumNewMessages(bool deep, int32_t *_retval) override; \
  NS_IMETHOD SetNumNewMessages(int32_t numNewMessages) override; \
  NS_IMETHOD GetGettingNewMessages(bool *aGettingNewMessages) override; \
  NS_IMETHOD SetGettingNewMessages(bool aGettingNewMessages) override; \
  NS_IMETHOD GetFilePath(nsIFile **aFilePath) override; \
  NS_IMETHOD SetFilePath(nsIFile *aFilePath) override; \
  NS_IMETHOD GetSummaryFile(nsIFile **aSummaryFile) override; \
  NS_IMETHOD GetBaseMessageURI(nsACString& aBaseMessageURI) override; \
  NS_IMETHOD GenerateMessageURI(nsMsgKey msgKey, nsACString& _retval) override; \
  NS_IMETHOD AddMessageDispositionState(nsIMsgDBHdr *aMessage, nsMsgDispositionState aDispositionFlag) override; \
  NS_IMETHOD MarkMessagesRead(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool markRead) override; \
  NS_IMETHOD MarkAllMessagesRead(nsIMsgWindow *aMsgWindow) override; \
  NS_IMETHOD MarkMessagesFlagged(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool markFlagged) override; \
  NS_IMETHOD MarkThreadRead(nsIMsgThread *thread) override; \
  NS_IMETHOD GetMsgDatabase(nsIMsgDatabase **aMsgDatabase) override; \
  NS_IMETHOD SetMsgDatabase(nsIMsgDatabase *aMsgDatabase) override; \
  NS_IMETHOD GetDatabaseOpen(bool *aDatabaseOpen) override; \
  NS_IMETHOD GetBackupMsgDatabase(nsIMsgDatabase **_retval) override; \
  NS_IMETHOD RemoveBackupMsgDatabase(void) override; \
  NS_IMETHOD OpenBackupMsgDatabase(void) override; \
  NS_IMETHOD GetDBFolderInfoAndDB(nsIDBFolderInfo **folderInfo, nsIMsgDatabase **_retval) override; \
  NS_IMETHOD GetMessageHeader(nsMsgKey msgKey, nsIMsgDBHdr **_retval) override; \
  NS_IMETHOD GetSupportsOffline(bool *aSupportsOffline) override; \
  NS_IMETHOD ShouldStoreMsgOffline(nsMsgKey msgKey, bool *_retval) override; \
  NS_IMETHOD HasMsgOffline(nsMsgKey msgKey, bool *_retval) override; \
  NS_IMETHOD DiscardOfflineMsg(nsMsgKey msgKey) override; \
  NS_IMETHOD GetMsgInputStream(nsIMsgDBHdr *aHdr, nsIInputStream **_retval) override; \
  NS_IMETHOD GetLocalMsgStream(nsIMsgDBHdr *aHdr, nsIInputStream **_retval) override; \
  NS_IMETHOD DownloadMessagesForOffline(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsIMsgWindow *window) override; \
  NS_IMETHOD GetChildWithURI(const nsACString& uri, bool deep, bool caseInsensitive, nsIMsgFolder **_retval) override; \
  NS_IMETHOD DownloadAllForOffline(nsIUrlListener *listener, nsIMsgWindow *window) override; \
  NS_IMETHOD EnableNotifications(int32_t notificationType, bool enable) override; \
  NS_IMETHOD IsCommandEnabled(const nsACString& command, bool *_retval) override; \
  NS_IMETHOD MatchOrChangeFilterDestination(nsIMsgFolder *folder, bool caseInsensitive, bool *_retval) override; \
  NS_IMETHOD ConfirmFolderDeletionForFilter(nsIMsgWindow *msgWindow, bool *_retval) override; \
  NS_IMETHOD AlertFilterChanged(nsIMsgWindow *msgWindow) override; \
  NS_IMETHOD ThrowAlertMsg(const char * msgName, nsIMsgWindow *msgWindow) override; \
  NS_IMETHOD GetStringWithFolderNameFromBundle(const char * msgName, nsAString& _retval) override; \
  NS_IMETHOD NotifyAboutToCompact(void) override; \
  NS_IMETHOD NotifyCompactCompleted(void) override; \
  NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings **aRetentionSettings) override; \
  NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings *aRetentionSettings) override; \
  NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings **aDownloadSettings) override; \
  NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings *aDownloadSettings) override; \
  NS_IMETHOD CallFilterPlugins(nsIMsgWindow *aMsgWindow, bool *_retval) override; \
  NS_IMETHOD GetSortOrder(int32_t *aSortOrder) override; \
  NS_IMETHOD SetSortOrder(int32_t aSortOrder) override; \
  NS_IMETHOD GetUserSortOrder(uint32_t *aUserSortOrder) override; \
  NS_IMETHOD SetUserSortOrder(uint32_t aUserSortOrder) override; \
  NS_IMETHOD GetDBTransferInfo(nsIPropertyBag2 **aDBTransferInfo) override; \
  NS_IMETHOD SetDBTransferInfo(nsIPropertyBag2 *aDBTransferInfo) override; \
  NS_IMETHOD SetStringProperty(const char * propertyName, const nsACString& propertyValue) override; \
  NS_IMETHOD GetStringProperty(const char * propertyName, nsACString& _retval) override; \
  NS_IMETHOD GetSubFolders(nsTArray<RefPtr<nsIMsgFolder>>& aSubFolders) override; \
  NS_IMETHOD GetHasSubFolders(bool *aHasSubFolders) override; \
  NS_IMETHOD GetNumSubFolders(uint32_t *aNumSubFolders) override; \
  NS_IMETHOD IsAncestorOf(nsIMsgFolder *folder, bool *_retval) override; \
  NS_IMETHOD ContainsChildNamed(const nsACString& name, bool *_retval) override; \
  NS_IMETHOD GetChildNamed(const nsACString& name, nsIMsgFolder **_retval) override; \
  NS_IMETHOD FindSubFolder(const nsACString& escapedSubFolderName, nsIMsgFolder **_retval) override; \
  NS_IMETHOD AddFolderListener(nsIFolderListener *listener) override; \
  NS_IMETHOD RemoveFolderListener(nsIFolderListener *listener) override; \
  NS_IMETHOD NotifyPropertyChanged(const nsACString& property, const nsACString& oldValue, const nsACString& newValue) override; \
  NS_IMETHOD NotifyIntPropertyChanged(const nsACString& property, int64_t oldValue, int64_t newValue) override; \
  NS_IMETHOD NotifyBoolPropertyChanged(const nsACString& property, bool oldValue, bool newValue) override; \
  NS_IMETHOD NotifyPropertyFlagChanged(nsIMsgDBHdr *item, const nsACString& property, uint32_t oldValue, uint32_t newValue) override; \
  NS_IMETHOD NotifyMessageAdded(nsIMsgDBHdr *msg) override; \
  NS_IMETHOD NotifyMessageRemoved(nsIMsgDBHdr *msg) override; \
  NS_IMETHOD NotifyFolderAdded(nsIMsgFolder *child) override; \
  NS_IMETHOD NotifyFolderRemoved(nsIMsgFolder *child) override; \
  NS_IMETHOD NotifyFolderEvent(const nsACString& event) override; \
  NS_IMETHOD GetDescendants(nsTArray<RefPtr<nsIMsgFolder>>& aDescendants) override; \
  NS_IMETHOD Shutdown(bool shutdownChildren) override; \
  NS_IMETHOD CopyDataToOutputStreamForAppend(nsIInputStream *aIStream, int32_t aLength, nsIOutputStream *outputStream) override; \
  NS_IMETHOD CopyDataDone(void) override; \
  NS_IMETHOD SetJunkScoreForMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsMsgJunkScore junkScore, const nsACString& junkScoreOrigin, int32_t junkPercent) override; \
  NS_IMETHOD PerformActionsOnJunkMsgs(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool msgsAreJunk, nsIMsgWindow *msgWindow, nsIUrlListener *listener) override; \
  NS_IMETHOD ApplyRetentionSettings(void) override; \
  NS_IMETHOD FetchMsgPreviewText(const nsTArray<nsMsgKey >& aKeysToFetch, nsIUrlListener *aUrlListener, bool *_retval) override; \
  NS_IMETHOD AddKeywordsToMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& aMessages, const nsACString& aKeywords) override; \
  NS_IMETHOD RemoveKeywordsFromMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& aMessages, const nsACString& aKeywords) override; \
  NS_IMETHOD GetMsgTextFromStream(nsIInputStream *aStream, const nsACString& aCharset, uint32_t aBytesToRead, uint32_t aMaxOutputLen, bool aCompressQuotes, bool aStripHTMLTags, nsACString& aContentType, nsACString& _retval) override; \
  NS_IMETHOD ConvertMsgSnippetToPlainText(const nsAString& aMessageText, nsAString& _retval) override; \
  NS_IMETHOD GetCustomIdentity(nsIMsgIdentity **aCustomIdentity) override; \
  NS_IMETHOD GetProcessingFlags(nsMsgKey msgKey, uint32_t *_retval) override; \
  NS_IMETHOD OrProcessingFlags(nsMsgKey msgKey, uint32_t mask) override; \
  NS_IMETHOD AndProcessingFlags(nsMsgKey msgKey, uint32_t mask) override; \
  NS_IMETHOD GetInheritedStringProperty(const char * propertyName, nsACString& _retval) override; \
  NS_IMETHOD GetMsgStore(nsIMsgPluggableStore **aMsgStore) override; \
  NS_IMETHOD GetIncomingServerType(nsACString& aIncomingServerType) override; \
  NS_IMETHOD HandleViewCommand(nsMsgViewCommandTypeValue command, const nsTArray<nsMsgKey >& messageKeys, nsIMsgWindow *window, nsIMsgCopyServiceListener *listener) override; \
  NS_IMETHOD UpdateTimestamps(bool userInitiated) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIMSGFOLDER \
  nsresult GetId(uint64_t *aId); \
  nsresult GetPath(nsACString& aPath); \
  nsresult GetURI(nsACString& aURI); \
  nsresult GetName(nsACString& aName); \
  nsresult SetName(const nsACString& aName); \
  nsresult GetLocalizedName(nsAString& aLocalizedName); \
  nsresult GetAbbreviatedName(nsAString& aAbbreviatedName); \
  nsresult GetPrettyPath(nsACString& aPrettyPath); \
  nsresult GetParent(nsIMsgFolder **aParent); \
  nsresult SetParent(nsIMsgFolder *aParent); \
  nsresult GetMessages(nsIMsgEnumerator **aMessages); \
  nsresult Init(const nsACString& uri); \
  nsresult InitWithFolderId(uint64_t folderId); \
  nsresult StartFolderLoading(void); \
  nsresult EndFolderLoading(void); \
  nsresult FolderNamesReady(bool *aReady); \
  nsresult UpdateFolder(nsIMsgWindow *aWindow); \
  nsresult GetServer(nsIMsgIncomingServer **aServer); \
  nsresult GetIsServer(bool *aIsServer); \
  nsresult GetCanSubscribe(bool *aCanSubscribe); \
  nsresult GetCanFileMessages(bool *aCanFileMessages); \
  nsresult GetNoSelect(bool *aNoSelect); \
  nsresult GetImapShared(bool *aImapShared); \
  nsresult GetCanDeleteMessages(bool *aCanDeleteMessages); \
  nsresult GetCanCreateSubfolders(bool *aCanCreateSubfolders); \
  nsresult GetCanRename(bool *aCanRename); \
  nsresult GetCanCompact(bool *aCanCompact); \
  nsresult GetRootFolder(nsIMsgFolder **aRootFolder); \
  nsresult GetFilterList(nsIMsgWindow *msgWindow, nsIMsgFilterList **_retval); \
  nsresult SetFilterList(nsIMsgFilterList *filterList); \
  nsresult GetEditableFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval); \
  nsresult SetEditableFilterList(nsIMsgFilterList *aFilterList); \
  nsresult CloseDatabase(void); \
  nsresult ForceDBClosed(void); \
  nsresult CloseAndBackupFolderDB(const nsACString& newName); \
  nsresult DeleteStorage(void); \
  nsresult DeleteSelf(nsIMsgWindow *msgWindow); \
  nsresult PropagateDelete(nsIMsgFolder *folder, bool deleteStorage); \
  nsresult RecursiveDelete(bool deleteStorage); \
  nsresult CreateSubfolder(const nsACString& folderName, nsIMsgWindow *msgWindow); \
  nsresult AddSubfolder(const nsACString& aFolderName, nsIMsgFolder **_retval); \
  nsresult CreateStorageIfMissing(nsIUrlListener *urlListener); \
  nsresult Compact(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow); \
  nsresult CompactAll(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow); \
  nsresult EmptyTrash(nsIUrlListener *aListener); \
  nsresult Rename(const nsACString& name, nsIMsgWindow *msgWindow); \
  nsresult RenameSubFolders(nsIMsgWindow *msgWindow, nsIMsgFolder *oldFolder); \
  nsresult GenerateUniqueSubfolderName(const nsACString& prefix, nsIMsgFolder *otherFolder, nsACString& _retval); \
  nsresult UpdateSummaryTotals(bool force); \
  nsresult SummaryChanged(void); \
  nsresult GetNumUnread(bool deep, int32_t *_retval); \
  nsresult GetTotalMessages(bool deep, int32_t *_retval); \
  nsresult GetNumPendingUnread(int32_t *aNumPendingUnread); \
  nsresult GetNumPendingTotalMessages(int32_t *aNumPendingTotalMessages); \
  nsresult ChangeNumPendingUnread(int32_t delta); \
  nsresult ChangeNumPendingTotalMessages(int32_t delta); \
  nsresult GetHasNewMessages(bool *aHasNewMessages); \
  nsresult SetHasNewMessages(bool aHasNewMessages); \
  nsresult GetHasFolderOrSubfolderNewMessages(bool *aHasFolderOrSubfolderNewMessages); \
  nsresult GetFirstNewMessage(nsIMsgDBHdr **aFirstNewMessage); \
  nsresult ClearNewMessages(void); \
  nsresult GetExpungedBytes(int64_t *aExpungedBytes); \
  nsresult GetDeletable(bool *aDeletable); \
  nsresult GetRelativePathName(nsACString& aRelativePathName); \
  nsresult GetSizeOnDisk(int64_t *aSizeOnDisk); \
  nsresult SetSizeOnDisk(int64_t aSizeOnDisk); \
  nsresult GetSizeOnDiskWithSubFolders(int64_t *aSizeOnDiskWithSubFolders); \
  nsresult GetUsername(nsACString& aUsername); \
  nsresult GetHostname(nsACString& aHostname); \
  nsresult SetFlag(uint32_t flag); \
  nsresult ClearFlag(uint32_t flag); \
  nsresult GetFlag(uint32_t flag, bool *_retval); \
  nsresult ToggleFlag(uint32_t flag); \
  nsresult OnFlagChange(uint32_t flag); \
  nsresult GetFlags(uint32_t *aFlags); \
  nsresult SetFlags(uint32_t aFlags); \
  nsresult GetFolderWithFlags(uint32_t flags, nsIMsgFolder **_retval); \
  nsresult GetFoldersWithFlags(uint32_t flags, nsTArray<RefPtr<nsIMsgFolder>>& _retval); \
  nsresult IsSpecialFolder(uint32_t flags, bool checkAncestors, bool *_retval); \
  nsresult GetUriForMsg(nsIMsgDBHdr *msgHdr, nsACString& _retval); \
  nsresult DeleteMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsIMsgWindow *msgWindow, bool deleteStorage, bool isMove, nsIMsgCopyServiceListener *listener, bool allowUndo); \
  nsresult CopyMessages(nsIMsgFolder *srcFolder, const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool isMove, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener, bool isFolder, bool allowUndo); \
  nsresult CopyFolder(nsIMsgFolder *srcFolder, bool isMoveFolder, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener); \
  nsresult CopyFileMessage(nsIFile *file, nsIMsgDBHdr *msgToReplace, bool isDraft, uint32_t newMsgFlags, const nsACString& aKeywords, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener); \
  nsresult AcquireSemaphore(nsISupports *semHolder, const nsACString& logText); \
  nsresult ReleaseSemaphore(nsISupports *semHolder, const nsACString& logText); \
  nsresult TestSemaphore(nsISupports *semHolder, bool *_retval); \
  nsresult GetLocked(bool *aLocked); \
  nsresult GetNewMessages(nsIMsgWindow *aWindow, nsIUrlListener *aListener); \
  nsresult WriteToFolderCache(nsIMsgFolderCache *folderCache, bool deep); \
  nsresult GetBiffState(uint32_t *aBiffState); \
  nsresult SetBiffState(uint32_t aBiffState); \
  nsresult GetNumNewMessages(bool deep, int32_t *_retval); \
  nsresult SetNumNewMessages(int32_t numNewMessages); \
  nsresult GetGettingNewMessages(bool *aGettingNewMessages); \
  nsresult SetGettingNewMessages(bool aGettingNewMessages); \
  nsresult GetFilePath(nsIFile **aFilePath); \
  nsresult SetFilePath(nsIFile *aFilePath); \
  nsresult GetSummaryFile(nsIFile **aSummaryFile); \
  nsresult GetBaseMessageURI(nsACString& aBaseMessageURI); \
  nsresult GenerateMessageURI(nsMsgKey msgKey, nsACString& _retval); \
  nsresult AddMessageDispositionState(nsIMsgDBHdr *aMessage, nsMsgDispositionState aDispositionFlag); \
  nsresult MarkMessagesRead(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool markRead); \
  nsresult MarkAllMessagesRead(nsIMsgWindow *aMsgWindow); \
  nsresult MarkMessagesFlagged(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool markFlagged); \
  nsresult MarkThreadRead(nsIMsgThread *thread); \
  nsresult GetMsgDatabase(nsIMsgDatabase **aMsgDatabase); \
  nsresult SetMsgDatabase(nsIMsgDatabase *aMsgDatabase); \
  nsresult GetDatabaseOpen(bool *aDatabaseOpen); \
  nsresult GetBackupMsgDatabase(nsIMsgDatabase **_retval); \
  nsresult RemoveBackupMsgDatabase(void); \
  nsresult OpenBackupMsgDatabase(void); \
  nsresult GetDBFolderInfoAndDB(nsIDBFolderInfo **folderInfo, nsIMsgDatabase **_retval); \
  nsresult GetMessageHeader(nsMsgKey msgKey, nsIMsgDBHdr **_retval); \
  nsresult GetSupportsOffline(bool *aSupportsOffline); \
  nsresult ShouldStoreMsgOffline(nsMsgKey msgKey, bool *_retval); \
  nsresult HasMsgOffline(nsMsgKey msgKey, bool *_retval); \
  nsresult DiscardOfflineMsg(nsMsgKey msgKey); \
  nsresult GetMsgInputStream(nsIMsgDBHdr *aHdr, nsIInputStream **_retval); \
  nsresult GetLocalMsgStream(nsIMsgDBHdr *aHdr, nsIInputStream **_retval); \
  nsresult DownloadMessagesForOffline(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsIMsgWindow *window); \
  nsresult GetChildWithURI(const nsACString& uri, bool deep, bool caseInsensitive, nsIMsgFolder **_retval); \
  nsresult DownloadAllForOffline(nsIUrlListener *listener, nsIMsgWindow *window); \
  nsresult EnableNotifications(int32_t notificationType, bool enable); \
  nsresult IsCommandEnabled(const nsACString& command, bool *_retval); \
  nsresult MatchOrChangeFilterDestination(nsIMsgFolder *folder, bool caseInsensitive, bool *_retval); \
  nsresult ConfirmFolderDeletionForFilter(nsIMsgWindow *msgWindow, bool *_retval); \
  nsresult AlertFilterChanged(nsIMsgWindow *msgWindow); \
  nsresult ThrowAlertMsg(const char * msgName, nsIMsgWindow *msgWindow); \
  nsresult GetStringWithFolderNameFromBundle(const char * msgName, nsAString& _retval); \
  nsresult NotifyAboutToCompact(void); \
  nsresult NotifyCompactCompleted(void); \
  nsresult GetRetentionSettings(nsIMsgRetentionSettings **aRetentionSettings); \
  nsresult SetRetentionSettings(nsIMsgRetentionSettings *aRetentionSettings); \
  nsresult GetDownloadSettings(nsIMsgDownloadSettings **aDownloadSettings); \
  nsresult SetDownloadSettings(nsIMsgDownloadSettings *aDownloadSettings); \
  nsresult CallFilterPlugins(nsIMsgWindow *aMsgWindow, bool *_retval); \
  nsresult GetSortOrder(int32_t *aSortOrder); \
  nsresult SetSortOrder(int32_t aSortOrder); \
  nsresult GetUserSortOrder(uint32_t *aUserSortOrder); \
  nsresult SetUserSortOrder(uint32_t aUserSortOrder); \
  nsresult GetDBTransferInfo(nsIPropertyBag2 **aDBTransferInfo); \
  nsresult SetDBTransferInfo(nsIPropertyBag2 *aDBTransferInfo); \
  nsresult SetStringProperty(const char * propertyName, const nsACString& propertyValue); \
  nsresult GetStringProperty(const char * propertyName, nsACString& _retval); \
  nsresult GetSubFolders(nsTArray<RefPtr<nsIMsgFolder>>& aSubFolders); \
  nsresult GetHasSubFolders(bool *aHasSubFolders); \
  nsresult GetNumSubFolders(uint32_t *aNumSubFolders); \
  nsresult IsAncestorOf(nsIMsgFolder *folder, bool *_retval); \
  nsresult ContainsChildNamed(const nsACString& name, bool *_retval); \
  nsresult GetChildNamed(const nsACString& name, nsIMsgFolder **_retval); \
  nsresult FindSubFolder(const nsACString& escapedSubFolderName, nsIMsgFolder **_retval); \
  nsresult AddFolderListener(nsIFolderListener *listener); \
  nsresult RemoveFolderListener(nsIFolderListener *listener); \
  nsresult NotifyPropertyChanged(const nsACString& property, const nsACString& oldValue, const nsACString& newValue); \
  nsresult NotifyIntPropertyChanged(const nsACString& property, int64_t oldValue, int64_t newValue); \
  nsresult NotifyBoolPropertyChanged(const nsACString& property, bool oldValue, bool newValue); \
  nsresult NotifyPropertyFlagChanged(nsIMsgDBHdr *item, const nsACString& property, uint32_t oldValue, uint32_t newValue); \
  nsresult NotifyMessageAdded(nsIMsgDBHdr *msg); \
  nsresult NotifyMessageRemoved(nsIMsgDBHdr *msg); \
  nsresult NotifyFolderAdded(nsIMsgFolder *child); \
  nsresult NotifyFolderRemoved(nsIMsgFolder *child); \
  nsresult NotifyFolderEvent(const nsACString& event); \
  nsresult GetDescendants(nsTArray<RefPtr<nsIMsgFolder>>& aDescendants); \
  nsresult Shutdown(bool shutdownChildren); \
  nsresult CopyDataToOutputStreamForAppend(nsIInputStream *aIStream, int32_t aLength, nsIOutputStream *outputStream); \
  nsresult CopyDataDone(void); \
  nsresult SetJunkScoreForMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsMsgJunkScore junkScore, const nsACString& junkScoreOrigin, int32_t junkPercent); \
  nsresult PerformActionsOnJunkMsgs(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool msgsAreJunk, nsIMsgWindow *msgWindow, nsIUrlListener *listener); \
  nsresult ApplyRetentionSettings(void); \
  nsresult FetchMsgPreviewText(const nsTArray<nsMsgKey >& aKeysToFetch, nsIUrlListener *aUrlListener, bool *_retval); \
  nsresult AddKeywordsToMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& aMessages, const nsACString& aKeywords); \
  nsresult RemoveKeywordsFromMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& aMessages, const nsACString& aKeywords); \
  nsresult GetMsgTextFromStream(nsIInputStream *aStream, const nsACString& aCharset, uint32_t aBytesToRead, uint32_t aMaxOutputLen, bool aCompressQuotes, bool aStripHTMLTags, nsACString& aContentType, nsACString& _retval); \
  nsresult ConvertMsgSnippetToPlainText(const nsAString& aMessageText, nsAString& _retval); \
  nsresult GetCustomIdentity(nsIMsgIdentity **aCustomIdentity); \
  nsresult GetProcessingFlags(nsMsgKey msgKey, uint32_t *_retval); \
  nsresult OrProcessingFlags(nsMsgKey msgKey, uint32_t mask); \
  nsresult AndProcessingFlags(nsMsgKey msgKey, uint32_t mask); \
  nsresult GetInheritedStringProperty(const char * propertyName, nsACString& _retval); \
  nsresult GetMsgStore(nsIMsgPluggableStore **aMsgStore); \
  nsresult GetIncomingServerType(nsACString& aIncomingServerType); \
  nsresult HandleViewCommand(nsMsgViewCommandTypeValue command, const nsTArray<nsMsgKey >& messageKeys, nsIMsgWindow *window, nsIMsgCopyServiceListener *listener); \
  nsresult UpdateTimestamps(bool userInitiated); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMSGFOLDER(_to) \
  NS_IMETHOD GetId(uint64_t *aId) override { return _to GetId(aId); } \
  NS_IMETHOD GetPath(nsACString& aPath) override { return _to GetPath(aPath); } \
  NS_IMETHOD GetURI(nsACString& aURI) override { return _to GetURI(aURI); } \
  NS_IMETHOD GetName(nsACString& aName) override { return _to GetName(aName); } \
  NS_IMETHOD SetName(const nsACString& aName) override { return _to SetName(aName); } \
  NS_IMETHOD GetLocalizedName(nsAString& aLocalizedName) override { return _to GetLocalizedName(aLocalizedName); } \
  NS_IMETHOD GetAbbreviatedName(nsAString& aAbbreviatedName) override { return _to GetAbbreviatedName(aAbbreviatedName); } \
  NS_IMETHOD GetPrettyPath(nsACString& aPrettyPath) override { return _to GetPrettyPath(aPrettyPath); } \
  NS_IMETHOD GetParent(nsIMsgFolder **aParent) override { return _to GetParent(aParent); } \
  NS_IMETHOD SetParent(nsIMsgFolder *aParent) override { return _to SetParent(aParent); } \
  NS_IMETHOD GetMessages(nsIMsgEnumerator **aMessages) override { return _to GetMessages(aMessages); } \
  NS_IMETHOD Init(const nsACString& uri) override { return _to Init(uri); } \
  NS_IMETHOD InitWithFolderId(uint64_t folderId) override { return _to InitWithFolderId(folderId); } \
  NS_IMETHOD StartFolderLoading(void) override { return _to StartFolderLoading(); } \
  NS_IMETHOD EndFolderLoading(void) override { return _to EndFolderLoading(); } \
  NS_IMETHOD FolderNamesReady(bool *aReady) override { return _to FolderNamesReady(aReady); } \
  NS_IMETHOD UpdateFolder(nsIMsgWindow *aWindow) override { return _to UpdateFolder(aWindow); } \
  NS_IMETHOD GetServer(nsIMsgIncomingServer **aServer) override { return _to GetServer(aServer); } \
  NS_IMETHOD GetIsServer(bool *aIsServer) override { return _to GetIsServer(aIsServer); } \
  NS_IMETHOD GetCanSubscribe(bool *aCanSubscribe) override { return _to GetCanSubscribe(aCanSubscribe); } \
  NS_IMETHOD GetCanFileMessages(bool *aCanFileMessages) override { return _to GetCanFileMessages(aCanFileMessages); } \
  NS_IMETHOD GetNoSelect(bool *aNoSelect) override { return _to GetNoSelect(aNoSelect); } \
  NS_IMETHOD GetImapShared(bool *aImapShared) override { return _to GetImapShared(aImapShared); } \
  NS_IMETHOD GetCanDeleteMessages(bool *aCanDeleteMessages) override { return _to GetCanDeleteMessages(aCanDeleteMessages); } \
  NS_IMETHOD GetCanCreateSubfolders(bool *aCanCreateSubfolders) override { return _to GetCanCreateSubfolders(aCanCreateSubfolders); } \
  NS_IMETHOD GetCanRename(bool *aCanRename) override { return _to GetCanRename(aCanRename); } \
  NS_IMETHOD GetCanCompact(bool *aCanCompact) override { return _to GetCanCompact(aCanCompact); } \
  NS_IMETHOD GetRootFolder(nsIMsgFolder **aRootFolder) override { return _to GetRootFolder(aRootFolder); } \
  NS_IMETHOD GetFilterList(nsIMsgWindow *msgWindow, nsIMsgFilterList **_retval) override { return _to GetFilterList(msgWindow, _retval); } \
  NS_IMETHOD SetFilterList(nsIMsgFilterList *filterList) override { return _to SetFilterList(filterList); } \
  NS_IMETHOD GetEditableFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval) override { return _to GetEditableFilterList(aMsgWindow, _retval); } \
  NS_IMETHOD SetEditableFilterList(nsIMsgFilterList *aFilterList) override { return _to SetEditableFilterList(aFilterList); } \
  NS_IMETHOD CloseDatabase(void) override { return _to CloseDatabase(); } \
  NS_IMETHOD ForceDBClosed(void) override { return _to ForceDBClosed(); } \
  NS_IMETHOD CloseAndBackupFolderDB(const nsACString& newName) override { return _to CloseAndBackupFolderDB(newName); } \
  NS_IMETHOD DeleteStorage(void) override { return _to DeleteStorage(); } \
  NS_IMETHOD DeleteSelf(nsIMsgWindow *msgWindow) override { return _to DeleteSelf(msgWindow); } \
  NS_IMETHOD PropagateDelete(nsIMsgFolder *folder, bool deleteStorage) override { return _to PropagateDelete(folder, deleteStorage); } \
  NS_IMETHOD RecursiveDelete(bool deleteStorage) override { return _to RecursiveDelete(deleteStorage); } \
  NS_IMETHOD CreateSubfolder(const nsACString& folderName, nsIMsgWindow *msgWindow) override { return _to CreateSubfolder(folderName, msgWindow); } \
  NS_IMETHOD AddSubfolder(const nsACString& aFolderName, nsIMsgFolder **_retval) override { return _to AddSubfolder(aFolderName, _retval); } \
  NS_IMETHOD CreateStorageIfMissing(nsIUrlListener *urlListener) override { return _to CreateStorageIfMissing(urlListener); } \
  NS_IMETHOD Compact(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) override { return _to Compact(aListener, aMsgWindow); } \
  NS_IMETHOD CompactAll(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) override { return _to CompactAll(aListener, aMsgWindow); } \
  NS_IMETHOD EmptyTrash(nsIUrlListener *aListener) override { return _to EmptyTrash(aListener); } \
  NS_IMETHOD Rename(const nsACString& name, nsIMsgWindow *msgWindow) override { return _to Rename(name, msgWindow); } \
  NS_IMETHOD RenameSubFolders(nsIMsgWindow *msgWindow, nsIMsgFolder *oldFolder) override { return _to RenameSubFolders(msgWindow, oldFolder); } \
  NS_IMETHOD GenerateUniqueSubfolderName(const nsACString& prefix, nsIMsgFolder *otherFolder, nsACString& _retval) override { return _to GenerateUniqueSubfolderName(prefix, otherFolder, _retval); } \
  NS_IMETHOD UpdateSummaryTotals(bool force) override { return _to UpdateSummaryTotals(force); } \
  NS_IMETHOD SummaryChanged(void) override { return _to SummaryChanged(); } \
  NS_IMETHOD GetNumUnread(bool deep, int32_t *_retval) override { return _to GetNumUnread(deep, _retval); } \
  NS_IMETHOD GetTotalMessages(bool deep, int32_t *_retval) override { return _to GetTotalMessages(deep, _retval); } \
  NS_IMETHOD GetNumPendingUnread(int32_t *aNumPendingUnread) override { return _to GetNumPendingUnread(aNumPendingUnread); } \
  NS_IMETHOD GetNumPendingTotalMessages(int32_t *aNumPendingTotalMessages) override { return _to GetNumPendingTotalMessages(aNumPendingTotalMessages); } \
  NS_IMETHOD ChangeNumPendingUnread(int32_t delta) override { return _to ChangeNumPendingUnread(delta); } \
  NS_IMETHOD ChangeNumPendingTotalMessages(int32_t delta) override { return _to ChangeNumPendingTotalMessages(delta); } \
  NS_IMETHOD GetHasNewMessages(bool *aHasNewMessages) override { return _to GetHasNewMessages(aHasNewMessages); } \
  NS_IMETHOD SetHasNewMessages(bool aHasNewMessages) override { return _to SetHasNewMessages(aHasNewMessages); } \
  NS_IMETHOD GetHasFolderOrSubfolderNewMessages(bool *aHasFolderOrSubfolderNewMessages) override { return _to GetHasFolderOrSubfolderNewMessages(aHasFolderOrSubfolderNewMessages); } \
  NS_IMETHOD GetFirstNewMessage(nsIMsgDBHdr **aFirstNewMessage) override { return _to GetFirstNewMessage(aFirstNewMessage); } \
  NS_IMETHOD ClearNewMessages(void) override { return _to ClearNewMessages(); } \
  NS_IMETHOD GetExpungedBytes(int64_t *aExpungedBytes) override { return _to GetExpungedBytes(aExpungedBytes); } \
  NS_IMETHOD GetDeletable(bool *aDeletable) override { return _to GetDeletable(aDeletable); } \
  NS_IMETHOD GetRelativePathName(nsACString& aRelativePathName) override { return _to GetRelativePathName(aRelativePathName); } \
  NS_IMETHOD GetSizeOnDisk(int64_t *aSizeOnDisk) override { return _to GetSizeOnDisk(aSizeOnDisk); } \
  NS_IMETHOD SetSizeOnDisk(int64_t aSizeOnDisk) override { return _to SetSizeOnDisk(aSizeOnDisk); } \
  NS_IMETHOD GetSizeOnDiskWithSubFolders(int64_t *aSizeOnDiskWithSubFolders) override { return _to GetSizeOnDiskWithSubFolders(aSizeOnDiskWithSubFolders); } \
  NS_IMETHOD GetUsername(nsACString& aUsername) override { return _to GetUsername(aUsername); } \
  NS_IMETHOD GetHostname(nsACString& aHostname) override { return _to GetHostname(aHostname); } \
  NS_IMETHOD SetFlag(uint32_t flag) override { return _to SetFlag(flag); } \
  NS_IMETHOD ClearFlag(uint32_t flag) override { return _to ClearFlag(flag); } \
  NS_IMETHOD GetFlag(uint32_t flag, bool *_retval) override { return _to GetFlag(flag, _retval); } \
  NS_IMETHOD ToggleFlag(uint32_t flag) override { return _to ToggleFlag(flag); } \
  NS_IMETHOD OnFlagChange(uint32_t flag) override { return _to OnFlagChange(flag); } \
  NS_IMETHOD GetFlags(uint32_t *aFlags) override { return _to GetFlags(aFlags); } \
  NS_IMETHOD SetFlags(uint32_t aFlags) override { return _to SetFlags(aFlags); } \
  NS_IMETHOD GetFolderWithFlags(uint32_t flags, nsIMsgFolder **_retval) override { return _to GetFolderWithFlags(flags, _retval); } \
  NS_IMETHOD GetFoldersWithFlags(uint32_t flags, nsTArray<RefPtr<nsIMsgFolder>>& _retval) override { return _to GetFoldersWithFlags(flags, _retval); } \
  NS_IMETHOD IsSpecialFolder(uint32_t flags, bool checkAncestors, bool *_retval) override { return _to IsSpecialFolder(flags, checkAncestors, _retval); } \
  NS_IMETHOD GetUriForMsg(nsIMsgDBHdr *msgHdr, nsACString& _retval) override { return _to GetUriForMsg(msgHdr, _retval); } \
  NS_IMETHOD DeleteMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsIMsgWindow *msgWindow, bool deleteStorage, bool isMove, nsIMsgCopyServiceListener *listener, bool allowUndo) override { return _to DeleteMessages(messages, msgWindow, deleteStorage, isMove, listener, allowUndo); } \
  NS_IMETHOD CopyMessages(nsIMsgFolder *srcFolder, const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool isMove, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener, bool isFolder, bool allowUndo) override { return _to CopyMessages(srcFolder, messages, isMove, msgWindow, listener, isFolder, allowUndo); } \
  NS_IMETHOD CopyFolder(nsIMsgFolder *srcFolder, bool isMoveFolder, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) override { return _to CopyFolder(srcFolder, isMoveFolder, msgWindow, listener); } \
  NS_IMETHOD CopyFileMessage(nsIFile *file, nsIMsgDBHdr *msgToReplace, bool isDraft, uint32_t newMsgFlags, const nsACString& aKeywords, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) override { return _to CopyFileMessage(file, msgToReplace, isDraft, newMsgFlags, aKeywords, msgWindow, listener); } \
  NS_IMETHOD AcquireSemaphore(nsISupports *semHolder, const nsACString& logText) override { return _to AcquireSemaphore(semHolder, logText); } \
  NS_IMETHOD ReleaseSemaphore(nsISupports *semHolder, const nsACString& logText) override { return _to ReleaseSemaphore(semHolder, logText); } \
  NS_IMETHOD TestSemaphore(nsISupports *semHolder, bool *_retval) override { return _to TestSemaphore(semHolder, _retval); } \
  NS_IMETHOD GetLocked(bool *aLocked) override { return _to GetLocked(aLocked); } \
  NS_IMETHOD GetNewMessages(nsIMsgWindow *aWindow, nsIUrlListener *aListener) override { return _to GetNewMessages(aWindow, aListener); } \
  NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache, bool deep) override { return _to WriteToFolderCache(folderCache, deep); } \
  NS_IMETHOD GetBiffState(uint32_t *aBiffState) override { return _to GetBiffState(aBiffState); } \
  NS_IMETHOD SetBiffState(uint32_t aBiffState) override { return _to SetBiffState(aBiffState); } \
  NS_IMETHOD GetNumNewMessages(bool deep, int32_t *_retval) override { return _to GetNumNewMessages(deep, _retval); } \
  NS_IMETHOD SetNumNewMessages(int32_t numNewMessages) override { return _to SetNumNewMessages(numNewMessages); } \
  NS_IMETHOD GetGettingNewMessages(bool *aGettingNewMessages) override { return _to GetGettingNewMessages(aGettingNewMessages); } \
  NS_IMETHOD SetGettingNewMessages(bool aGettingNewMessages) override { return _to SetGettingNewMessages(aGettingNewMessages); } \
  NS_IMETHOD GetFilePath(nsIFile **aFilePath) override { return _to GetFilePath(aFilePath); } \
  NS_IMETHOD SetFilePath(nsIFile *aFilePath) override { return _to SetFilePath(aFilePath); } \
  NS_IMETHOD GetSummaryFile(nsIFile **aSummaryFile) override { return _to GetSummaryFile(aSummaryFile); } \
  NS_IMETHOD GetBaseMessageURI(nsACString& aBaseMessageURI) override { return _to GetBaseMessageURI(aBaseMessageURI); } \
  NS_IMETHOD GenerateMessageURI(nsMsgKey msgKey, nsACString& _retval) override { return _to GenerateMessageURI(msgKey, _retval); } \
  NS_IMETHOD AddMessageDispositionState(nsIMsgDBHdr *aMessage, nsMsgDispositionState aDispositionFlag) override { return _to AddMessageDispositionState(aMessage, aDispositionFlag); } \
  NS_IMETHOD MarkMessagesRead(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool markRead) override { return _to MarkMessagesRead(messages, markRead); } \
  NS_IMETHOD MarkAllMessagesRead(nsIMsgWindow *aMsgWindow) override { return _to MarkAllMessagesRead(aMsgWindow); } \
  NS_IMETHOD MarkMessagesFlagged(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool markFlagged) override { return _to MarkMessagesFlagged(messages, markFlagged); } \
  NS_IMETHOD MarkThreadRead(nsIMsgThread *thread) override { return _to MarkThreadRead(thread); } \
  NS_IMETHOD GetMsgDatabase(nsIMsgDatabase **aMsgDatabase) override { return _to GetMsgDatabase(aMsgDatabase); } \
  NS_IMETHOD SetMsgDatabase(nsIMsgDatabase *aMsgDatabase) override { return _to SetMsgDatabase(aMsgDatabase); } \
  NS_IMETHOD GetDatabaseOpen(bool *aDatabaseOpen) override { return _to GetDatabaseOpen(aDatabaseOpen); } \
  NS_IMETHOD GetBackupMsgDatabase(nsIMsgDatabase **_retval) override { return _to GetBackupMsgDatabase(_retval); } \
  NS_IMETHOD RemoveBackupMsgDatabase(void) override { return _to RemoveBackupMsgDatabase(); } \
  NS_IMETHOD OpenBackupMsgDatabase(void) override { return _to OpenBackupMsgDatabase(); } \
  NS_IMETHOD GetDBFolderInfoAndDB(nsIDBFolderInfo **folderInfo, nsIMsgDatabase **_retval) override { return _to GetDBFolderInfoAndDB(folderInfo, _retval); } \
  NS_IMETHOD GetMessageHeader(nsMsgKey msgKey, nsIMsgDBHdr **_retval) override { return _to GetMessageHeader(msgKey, _retval); } \
  NS_IMETHOD GetSupportsOffline(bool *aSupportsOffline) override { return _to GetSupportsOffline(aSupportsOffline); } \
  NS_IMETHOD ShouldStoreMsgOffline(nsMsgKey msgKey, bool *_retval) override { return _to ShouldStoreMsgOffline(msgKey, _retval); } \
  NS_IMETHOD HasMsgOffline(nsMsgKey msgKey, bool *_retval) override { return _to HasMsgOffline(msgKey, _retval); } \
  NS_IMETHOD DiscardOfflineMsg(nsMsgKey msgKey) override { return _to DiscardOfflineMsg(msgKey); } \
  NS_IMETHOD GetMsgInputStream(nsIMsgDBHdr *aHdr, nsIInputStream **_retval) override { return _to GetMsgInputStream(aHdr, _retval); } \
  NS_IMETHOD GetLocalMsgStream(nsIMsgDBHdr *aHdr, nsIInputStream **_retval) override { return _to GetLocalMsgStream(aHdr, _retval); } \
  NS_IMETHOD DownloadMessagesForOffline(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsIMsgWindow *window) override { return _to DownloadMessagesForOffline(messages, window); } \
  NS_IMETHOD GetChildWithURI(const nsACString& uri, bool deep, bool caseInsensitive, nsIMsgFolder **_retval) override { return _to GetChildWithURI(uri, deep, caseInsensitive, _retval); } \
  NS_IMETHOD DownloadAllForOffline(nsIUrlListener *listener, nsIMsgWindow *window) override { return _to DownloadAllForOffline(listener, window); } \
  NS_IMETHOD EnableNotifications(int32_t notificationType, bool enable) override { return _to EnableNotifications(notificationType, enable); } \
  NS_IMETHOD IsCommandEnabled(const nsACString& command, bool *_retval) override { return _to IsCommandEnabled(command, _retval); } \
  NS_IMETHOD MatchOrChangeFilterDestination(nsIMsgFolder *folder, bool caseInsensitive, bool *_retval) override { return _to MatchOrChangeFilterDestination(folder, caseInsensitive, _retval); } \
  NS_IMETHOD ConfirmFolderDeletionForFilter(nsIMsgWindow *msgWindow, bool *_retval) override { return _to ConfirmFolderDeletionForFilter(msgWindow, _retval); } \
  NS_IMETHOD AlertFilterChanged(nsIMsgWindow *msgWindow) override { return _to AlertFilterChanged(msgWindow); } \
  NS_IMETHOD ThrowAlertMsg(const char * msgName, nsIMsgWindow *msgWindow) override { return _to ThrowAlertMsg(msgName, msgWindow); } \
  NS_IMETHOD GetStringWithFolderNameFromBundle(const char * msgName, nsAString& _retval) override { return _to GetStringWithFolderNameFromBundle(msgName, _retval); } \
  NS_IMETHOD NotifyAboutToCompact(void) override { return _to NotifyAboutToCompact(); } \
  NS_IMETHOD NotifyCompactCompleted(void) override { return _to NotifyCompactCompleted(); } \
  NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings **aRetentionSettings) override { return _to GetRetentionSettings(aRetentionSettings); } \
  NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings *aRetentionSettings) override { return _to SetRetentionSettings(aRetentionSettings); } \
  NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings **aDownloadSettings) override { return _to GetDownloadSettings(aDownloadSettings); } \
  NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings *aDownloadSettings) override { return _to SetDownloadSettings(aDownloadSettings); } \
  NS_IMETHOD CallFilterPlugins(nsIMsgWindow *aMsgWindow, bool *_retval) override { return _to CallFilterPlugins(aMsgWindow, _retval); } \
  NS_IMETHOD GetSortOrder(int32_t *aSortOrder) override { return _to GetSortOrder(aSortOrder); } \
  NS_IMETHOD SetSortOrder(int32_t aSortOrder) override { return _to SetSortOrder(aSortOrder); } \
  NS_IMETHOD GetUserSortOrder(uint32_t *aUserSortOrder) override { return _to GetUserSortOrder(aUserSortOrder); } \
  NS_IMETHOD SetUserSortOrder(uint32_t aUserSortOrder) override { return _to SetUserSortOrder(aUserSortOrder); } \
  NS_IMETHOD GetDBTransferInfo(nsIPropertyBag2 **aDBTransferInfo) override { return _to GetDBTransferInfo(aDBTransferInfo); } \
  NS_IMETHOD SetDBTransferInfo(nsIPropertyBag2 *aDBTransferInfo) override { return _to SetDBTransferInfo(aDBTransferInfo); } \
  NS_IMETHOD SetStringProperty(const char * propertyName, const nsACString& propertyValue) override { return _to SetStringProperty(propertyName, propertyValue); } \
  NS_IMETHOD GetStringProperty(const char * propertyName, nsACString& _retval) override { return _to GetStringProperty(propertyName, _retval); } \
  NS_IMETHOD GetSubFolders(nsTArray<RefPtr<nsIMsgFolder>>& aSubFolders) override { return _to GetSubFolders(aSubFolders); } \
  NS_IMETHOD GetHasSubFolders(bool *aHasSubFolders) override { return _to GetHasSubFolders(aHasSubFolders); } \
  NS_IMETHOD GetNumSubFolders(uint32_t *aNumSubFolders) override { return _to GetNumSubFolders(aNumSubFolders); } \
  NS_IMETHOD IsAncestorOf(nsIMsgFolder *folder, bool *_retval) override { return _to IsAncestorOf(folder, _retval); } \
  NS_IMETHOD ContainsChildNamed(const nsACString& name, bool *_retval) override { return _to ContainsChildNamed(name, _retval); } \
  NS_IMETHOD GetChildNamed(const nsACString& name, nsIMsgFolder **_retval) override { return _to GetChildNamed(name, _retval); } \
  NS_IMETHOD FindSubFolder(const nsACString& escapedSubFolderName, nsIMsgFolder **_retval) override { return _to FindSubFolder(escapedSubFolderName, _retval); } \
  NS_IMETHOD AddFolderListener(nsIFolderListener *listener) override { return _to AddFolderListener(listener); } \
  NS_IMETHOD RemoveFolderListener(nsIFolderListener *listener) override { return _to RemoveFolderListener(listener); } \
  NS_IMETHOD NotifyPropertyChanged(const nsACString& property, const nsACString& oldValue, const nsACString& newValue) override { return _to NotifyPropertyChanged(property, oldValue, newValue); } \
  NS_IMETHOD NotifyIntPropertyChanged(const nsACString& property, int64_t oldValue, int64_t newValue) override { return _to NotifyIntPropertyChanged(property, oldValue, newValue); } \
  NS_IMETHOD NotifyBoolPropertyChanged(const nsACString& property, bool oldValue, bool newValue) override { return _to NotifyBoolPropertyChanged(property, oldValue, newValue); } \
  NS_IMETHOD NotifyPropertyFlagChanged(nsIMsgDBHdr *item, const nsACString& property, uint32_t oldValue, uint32_t newValue) override { return _to NotifyPropertyFlagChanged(item, property, oldValue, newValue); } \
  NS_IMETHOD NotifyMessageAdded(nsIMsgDBHdr *msg) override { return _to NotifyMessageAdded(msg); } \
  NS_IMETHOD NotifyMessageRemoved(nsIMsgDBHdr *msg) override { return _to NotifyMessageRemoved(msg); } \
  NS_IMETHOD NotifyFolderAdded(nsIMsgFolder *child) override { return _to NotifyFolderAdded(child); } \
  NS_IMETHOD NotifyFolderRemoved(nsIMsgFolder *child) override { return _to NotifyFolderRemoved(child); } \
  NS_IMETHOD NotifyFolderEvent(const nsACString& event) override { return _to NotifyFolderEvent(event); } \
  NS_IMETHOD GetDescendants(nsTArray<RefPtr<nsIMsgFolder>>& aDescendants) override { return _to GetDescendants(aDescendants); } \
  NS_IMETHOD Shutdown(bool shutdownChildren) override { return _to Shutdown(shutdownChildren); } \
  NS_IMETHOD CopyDataToOutputStreamForAppend(nsIInputStream *aIStream, int32_t aLength, nsIOutputStream *outputStream) override { return _to CopyDataToOutputStreamForAppend(aIStream, aLength, outputStream); } \
  NS_IMETHOD CopyDataDone(void) override { return _to CopyDataDone(); } \
  NS_IMETHOD SetJunkScoreForMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsMsgJunkScore junkScore, const nsACString& junkScoreOrigin, int32_t junkPercent) override { return _to SetJunkScoreForMessages(messages, junkScore, junkScoreOrigin, junkPercent); } \
  NS_IMETHOD PerformActionsOnJunkMsgs(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool msgsAreJunk, nsIMsgWindow *msgWindow, nsIUrlListener *listener) override { return _to PerformActionsOnJunkMsgs(messages, msgsAreJunk, msgWindow, listener); } \
  NS_IMETHOD ApplyRetentionSettings(void) override { return _to ApplyRetentionSettings(); } \
  NS_IMETHOD FetchMsgPreviewText(const nsTArray<nsMsgKey >& aKeysToFetch, nsIUrlListener *aUrlListener, bool *_retval) override { return _to FetchMsgPreviewText(aKeysToFetch, aUrlListener, _retval); } \
  NS_IMETHOD AddKeywordsToMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& aMessages, const nsACString& aKeywords) override { return _to AddKeywordsToMessages(aMessages, aKeywords); } \
  NS_IMETHOD RemoveKeywordsFromMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& aMessages, const nsACString& aKeywords) override { return _to RemoveKeywordsFromMessages(aMessages, aKeywords); } \
  NS_IMETHOD GetMsgTextFromStream(nsIInputStream *aStream, const nsACString& aCharset, uint32_t aBytesToRead, uint32_t aMaxOutputLen, bool aCompressQuotes, bool aStripHTMLTags, nsACString& aContentType, nsACString& _retval) override { return _to GetMsgTextFromStream(aStream, aCharset, aBytesToRead, aMaxOutputLen, aCompressQuotes, aStripHTMLTags, aContentType, _retval); } \
  NS_IMETHOD ConvertMsgSnippetToPlainText(const nsAString& aMessageText, nsAString& _retval) override { return _to ConvertMsgSnippetToPlainText(aMessageText, _retval); } \
  NS_IMETHOD GetCustomIdentity(nsIMsgIdentity **aCustomIdentity) override { return _to GetCustomIdentity(aCustomIdentity); } \
  NS_IMETHOD GetProcessingFlags(nsMsgKey msgKey, uint32_t *_retval) override { return _to GetProcessingFlags(msgKey, _retval); } \
  NS_IMETHOD OrProcessingFlags(nsMsgKey msgKey, uint32_t mask) override { return _to OrProcessingFlags(msgKey, mask); } \
  NS_IMETHOD AndProcessingFlags(nsMsgKey msgKey, uint32_t mask) override { return _to AndProcessingFlags(msgKey, mask); } \
  NS_IMETHOD GetInheritedStringProperty(const char * propertyName, nsACString& _retval) override { return _to GetInheritedStringProperty(propertyName, _retval); } \
  NS_IMETHOD GetMsgStore(nsIMsgPluggableStore **aMsgStore) override { return _to GetMsgStore(aMsgStore); } \
  NS_IMETHOD GetIncomingServerType(nsACString& aIncomingServerType) override { return _to GetIncomingServerType(aIncomingServerType); } \
  NS_IMETHOD HandleViewCommand(nsMsgViewCommandTypeValue command, const nsTArray<nsMsgKey >& messageKeys, nsIMsgWindow *window, nsIMsgCopyServiceListener *listener) override { return _to HandleViewCommand(command, messageKeys, window, listener); } \
  NS_IMETHOD UpdateTimestamps(bool userInitiated) override { return _to UpdateTimestamps(userInitiated); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMSGFOLDER(_to) \
  NS_IMETHOD GetId(uint64_t *aId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetId(aId); } \
  NS_IMETHOD GetPath(nsACString& aPath) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPath(aPath); } \
  NS_IMETHOD GetURI(nsACString& aURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetURI(aURI); } \
  NS_IMETHOD GetName(nsACString& aName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetName(aName); } \
  NS_IMETHOD SetName(const nsACString& aName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetName(aName); } \
  NS_IMETHOD GetLocalizedName(nsAString& aLocalizedName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLocalizedName(aLocalizedName); } \
  NS_IMETHOD GetAbbreviatedName(nsAString& aAbbreviatedName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAbbreviatedName(aAbbreviatedName); } \
  NS_IMETHOD GetPrettyPath(nsACString& aPrettyPath) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPrettyPath(aPrettyPath); } \
  NS_IMETHOD GetParent(nsIMsgFolder **aParent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetParent(aParent); } \
  NS_IMETHOD SetParent(nsIMsgFolder *aParent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetParent(aParent); } \
  NS_IMETHOD GetMessages(nsIMsgEnumerator **aMessages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMessages(aMessages); } \
  NS_IMETHOD Init(const nsACString& uri) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(uri); } \
  NS_IMETHOD InitWithFolderId(uint64_t folderId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->InitWithFolderId(folderId); } \
  NS_IMETHOD StartFolderLoading(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->StartFolderLoading(); } \
  NS_IMETHOD EndFolderLoading(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->EndFolderLoading(); } \
  NS_IMETHOD FolderNamesReady(bool *aReady) override { return !_to ? NS_ERROR_NULL_POINTER : _to->FolderNamesReady(aReady); } \
  NS_IMETHOD UpdateFolder(nsIMsgWindow *aWindow) override { return !_to ? NS_ERROR_NULL_POINTER : _to->UpdateFolder(aWindow); } \
  NS_IMETHOD GetServer(nsIMsgIncomingServer **aServer) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServer(aServer); } \
  NS_IMETHOD GetIsServer(bool *aIsServer) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIsServer(aIsServer); } \
  NS_IMETHOD GetCanSubscribe(bool *aCanSubscribe) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanSubscribe(aCanSubscribe); } \
  NS_IMETHOD GetCanFileMessages(bool *aCanFileMessages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanFileMessages(aCanFileMessages); } \
  NS_IMETHOD GetNoSelect(bool *aNoSelect) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNoSelect(aNoSelect); } \
  NS_IMETHOD GetImapShared(bool *aImapShared) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetImapShared(aImapShared); } \
  NS_IMETHOD GetCanDeleteMessages(bool *aCanDeleteMessages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanDeleteMessages(aCanDeleteMessages); } \
  NS_IMETHOD GetCanCreateSubfolders(bool *aCanCreateSubfolders) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanCreateSubfolders(aCanCreateSubfolders); } \
  NS_IMETHOD GetCanRename(bool *aCanRename) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanRename(aCanRename); } \
  NS_IMETHOD GetCanCompact(bool *aCanCompact) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCanCompact(aCanCompact); } \
  NS_IMETHOD GetRootFolder(nsIMsgFolder **aRootFolder) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRootFolder(aRootFolder); } \
  NS_IMETHOD GetFilterList(nsIMsgWindow *msgWindow, nsIMsgFilterList **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFilterList(msgWindow, _retval); } \
  NS_IMETHOD SetFilterList(nsIMsgFilterList *filterList) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFilterList(filterList); } \
  NS_IMETHOD GetEditableFilterList(nsIMsgWindow *aMsgWindow, nsIMsgFilterList **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetEditableFilterList(aMsgWindow, _retval); } \
  NS_IMETHOD SetEditableFilterList(nsIMsgFilterList *aFilterList) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetEditableFilterList(aFilterList); } \
  NS_IMETHOD CloseDatabase(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CloseDatabase(); } \
  NS_IMETHOD ForceDBClosed(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ForceDBClosed(); } \
  NS_IMETHOD CloseAndBackupFolderDB(const nsACString& newName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CloseAndBackupFolderDB(newName); } \
  NS_IMETHOD DeleteStorage(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteStorage(); } \
  NS_IMETHOD DeleteSelf(nsIMsgWindow *msgWindow) override { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteSelf(msgWindow); } \
  NS_IMETHOD PropagateDelete(nsIMsgFolder *folder, bool deleteStorage) override { return !_to ? NS_ERROR_NULL_POINTER : _to->PropagateDelete(folder, deleteStorage); } \
  NS_IMETHOD RecursiveDelete(bool deleteStorage) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RecursiveDelete(deleteStorage); } \
  NS_IMETHOD CreateSubfolder(const nsACString& folderName, nsIMsgWindow *msgWindow) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateSubfolder(folderName, msgWindow); } \
  NS_IMETHOD AddSubfolder(const nsACString& aFolderName, nsIMsgFolder **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AddSubfolder(aFolderName, _retval); } \
  NS_IMETHOD CreateStorageIfMissing(nsIUrlListener *urlListener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateStorageIfMissing(urlListener); } \
  NS_IMETHOD Compact(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Compact(aListener, aMsgWindow); } \
  NS_IMETHOD CompactAll(nsIUrlListener *aListener, nsIMsgWindow *aMsgWindow) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CompactAll(aListener, aMsgWindow); } \
  NS_IMETHOD EmptyTrash(nsIUrlListener *aListener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->EmptyTrash(aListener); } \
  NS_IMETHOD Rename(const nsACString& name, nsIMsgWindow *msgWindow) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Rename(name, msgWindow); } \
  NS_IMETHOD RenameSubFolders(nsIMsgWindow *msgWindow, nsIMsgFolder *oldFolder) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RenameSubFolders(msgWindow, oldFolder); } \
  NS_IMETHOD GenerateUniqueSubfolderName(const nsACString& prefix, nsIMsgFolder *otherFolder, nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GenerateUniqueSubfolderName(prefix, otherFolder, _retval); } \
  NS_IMETHOD UpdateSummaryTotals(bool force) override { return !_to ? NS_ERROR_NULL_POINTER : _to->UpdateSummaryTotals(force); } \
  NS_IMETHOD SummaryChanged(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SummaryChanged(); } \
  NS_IMETHOD GetNumUnread(bool deep, int32_t *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNumUnread(deep, _retval); } \
  NS_IMETHOD GetTotalMessages(bool deep, int32_t *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTotalMessages(deep, _retval); } \
  NS_IMETHOD GetNumPendingUnread(int32_t *aNumPendingUnread) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNumPendingUnread(aNumPendingUnread); } \
  NS_IMETHOD GetNumPendingTotalMessages(int32_t *aNumPendingTotalMessages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNumPendingTotalMessages(aNumPendingTotalMessages); } \
  NS_IMETHOD ChangeNumPendingUnread(int32_t delta) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ChangeNumPendingUnread(delta); } \
  NS_IMETHOD ChangeNumPendingTotalMessages(int32_t delta) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ChangeNumPendingTotalMessages(delta); } \
  NS_IMETHOD GetHasNewMessages(bool *aHasNewMessages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHasNewMessages(aHasNewMessages); } \
  NS_IMETHOD SetHasNewMessages(bool aHasNewMessages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetHasNewMessages(aHasNewMessages); } \
  NS_IMETHOD GetHasFolderOrSubfolderNewMessages(bool *aHasFolderOrSubfolderNewMessages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHasFolderOrSubfolderNewMessages(aHasFolderOrSubfolderNewMessages); } \
  NS_IMETHOD GetFirstNewMessage(nsIMsgDBHdr **aFirstNewMessage) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFirstNewMessage(aFirstNewMessage); } \
  NS_IMETHOD ClearNewMessages(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearNewMessages(); } \
  NS_IMETHOD GetExpungedBytes(int64_t *aExpungedBytes) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetExpungedBytes(aExpungedBytes); } \
  NS_IMETHOD GetDeletable(bool *aDeletable) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDeletable(aDeletable); } \
  NS_IMETHOD GetRelativePathName(nsACString& aRelativePathName) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRelativePathName(aRelativePathName); } \
  NS_IMETHOD GetSizeOnDisk(int64_t *aSizeOnDisk) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSizeOnDisk(aSizeOnDisk); } \
  NS_IMETHOD SetSizeOnDisk(int64_t aSizeOnDisk) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSizeOnDisk(aSizeOnDisk); } \
  NS_IMETHOD GetSizeOnDiskWithSubFolders(int64_t *aSizeOnDiskWithSubFolders) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSizeOnDiskWithSubFolders(aSizeOnDiskWithSubFolders); } \
  NS_IMETHOD GetUsername(nsACString& aUsername) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUsername(aUsername); } \
  NS_IMETHOD GetHostname(nsACString& aHostname) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHostname(aHostname); } \
  NS_IMETHOD SetFlag(uint32_t flag) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFlag(flag); } \
  NS_IMETHOD ClearFlag(uint32_t flag) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearFlag(flag); } \
  NS_IMETHOD GetFlag(uint32_t flag, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFlag(flag, _retval); } \
  NS_IMETHOD ToggleFlag(uint32_t flag) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ToggleFlag(flag); } \
  NS_IMETHOD OnFlagChange(uint32_t flag) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnFlagChange(flag); } \
  NS_IMETHOD GetFlags(uint32_t *aFlags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFlags(aFlags); } \
  NS_IMETHOD SetFlags(uint32_t aFlags) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFlags(aFlags); } \
  NS_IMETHOD GetFolderWithFlags(uint32_t flags, nsIMsgFolder **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFolderWithFlags(flags, _retval); } \
  NS_IMETHOD GetFoldersWithFlags(uint32_t flags, nsTArray<RefPtr<nsIMsgFolder>>& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFoldersWithFlags(flags, _retval); } \
  NS_IMETHOD IsSpecialFolder(uint32_t flags, bool checkAncestors, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->IsSpecialFolder(flags, checkAncestors, _retval); } \
  NS_IMETHOD GetUriForMsg(nsIMsgDBHdr *msgHdr, nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUriForMsg(msgHdr, _retval); } \
  NS_IMETHOD DeleteMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsIMsgWindow *msgWindow, bool deleteStorage, bool isMove, nsIMsgCopyServiceListener *listener, bool allowUndo) override { return !_to ? NS_ERROR_NULL_POINTER : _to->DeleteMessages(messages, msgWindow, deleteStorage, isMove, listener, allowUndo); } \
  NS_IMETHOD CopyMessages(nsIMsgFolder *srcFolder, const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool isMove, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener, bool isFolder, bool allowUndo) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyMessages(srcFolder, messages, isMove, msgWindow, listener, isFolder, allowUndo); } \
  NS_IMETHOD CopyFolder(nsIMsgFolder *srcFolder, bool isMoveFolder, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyFolder(srcFolder, isMoveFolder, msgWindow, listener); } \
  NS_IMETHOD CopyFileMessage(nsIFile *file, nsIMsgDBHdr *msgToReplace, bool isDraft, uint32_t newMsgFlags, const nsACString& aKeywords, nsIMsgWindow *msgWindow, nsIMsgCopyServiceListener *listener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyFileMessage(file, msgToReplace, isDraft, newMsgFlags, aKeywords, msgWindow, listener); } \
  NS_IMETHOD AcquireSemaphore(nsISupports *semHolder, const nsACString& logText) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AcquireSemaphore(semHolder, logText); } \
  NS_IMETHOD ReleaseSemaphore(nsISupports *semHolder, const nsACString& logText) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ReleaseSemaphore(semHolder, logText); } \
  NS_IMETHOD TestSemaphore(nsISupports *semHolder, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->TestSemaphore(semHolder, _retval); } \
  NS_IMETHOD GetLocked(bool *aLocked) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLocked(aLocked); } \
  NS_IMETHOD GetNewMessages(nsIMsgWindow *aWindow, nsIUrlListener *aListener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNewMessages(aWindow, aListener); } \
  NS_IMETHOD WriteToFolderCache(nsIMsgFolderCache *folderCache, bool deep) override { return !_to ? NS_ERROR_NULL_POINTER : _to->WriteToFolderCache(folderCache, deep); } \
  NS_IMETHOD GetBiffState(uint32_t *aBiffState) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBiffState(aBiffState); } \
  NS_IMETHOD SetBiffState(uint32_t aBiffState) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBiffState(aBiffState); } \
  NS_IMETHOD GetNumNewMessages(bool deep, int32_t *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNumNewMessages(deep, _retval); } \
  NS_IMETHOD SetNumNewMessages(int32_t numNewMessages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetNumNewMessages(numNewMessages); } \
  NS_IMETHOD GetGettingNewMessages(bool *aGettingNewMessages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetGettingNewMessages(aGettingNewMessages); } \
  NS_IMETHOD SetGettingNewMessages(bool aGettingNewMessages) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetGettingNewMessages(aGettingNewMessages); } \
  NS_IMETHOD GetFilePath(nsIFile **aFilePath) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFilePath(aFilePath); } \
  NS_IMETHOD SetFilePath(nsIFile *aFilePath) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFilePath(aFilePath); } \
  NS_IMETHOD GetSummaryFile(nsIFile **aSummaryFile) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSummaryFile(aSummaryFile); } \
  NS_IMETHOD GetBaseMessageURI(nsACString& aBaseMessageURI) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBaseMessageURI(aBaseMessageURI); } \
  NS_IMETHOD GenerateMessageURI(nsMsgKey msgKey, nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GenerateMessageURI(msgKey, _retval); } \
  NS_IMETHOD AddMessageDispositionState(nsIMsgDBHdr *aMessage, nsMsgDispositionState aDispositionFlag) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AddMessageDispositionState(aMessage, aDispositionFlag); } \
  NS_IMETHOD MarkMessagesRead(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool markRead) override { return !_to ? NS_ERROR_NULL_POINTER : _to->MarkMessagesRead(messages, markRead); } \
  NS_IMETHOD MarkAllMessagesRead(nsIMsgWindow *aMsgWindow) override { return !_to ? NS_ERROR_NULL_POINTER : _to->MarkAllMessagesRead(aMsgWindow); } \
  NS_IMETHOD MarkMessagesFlagged(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool markFlagged) override { return !_to ? NS_ERROR_NULL_POINTER : _to->MarkMessagesFlagged(messages, markFlagged); } \
  NS_IMETHOD MarkThreadRead(nsIMsgThread *thread) override { return !_to ? NS_ERROR_NULL_POINTER : _to->MarkThreadRead(thread); } \
  NS_IMETHOD GetMsgDatabase(nsIMsgDatabase **aMsgDatabase) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMsgDatabase(aMsgDatabase); } \
  NS_IMETHOD SetMsgDatabase(nsIMsgDatabase *aMsgDatabase) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetMsgDatabase(aMsgDatabase); } \
  NS_IMETHOD GetDatabaseOpen(bool *aDatabaseOpen) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDatabaseOpen(aDatabaseOpen); } \
  NS_IMETHOD GetBackupMsgDatabase(nsIMsgDatabase **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBackupMsgDatabase(_retval); } \
  NS_IMETHOD RemoveBackupMsgDatabase(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveBackupMsgDatabase(); } \
  NS_IMETHOD OpenBackupMsgDatabase(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenBackupMsgDatabase(); } \
  NS_IMETHOD GetDBFolderInfoAndDB(nsIDBFolderInfo **folderInfo, nsIMsgDatabase **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDBFolderInfoAndDB(folderInfo, _retval); } \
  NS_IMETHOD GetMessageHeader(nsMsgKey msgKey, nsIMsgDBHdr **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMessageHeader(msgKey, _retval); } \
  NS_IMETHOD GetSupportsOffline(bool *aSupportsOffline) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSupportsOffline(aSupportsOffline); } \
  NS_IMETHOD ShouldStoreMsgOffline(nsMsgKey msgKey, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ShouldStoreMsgOffline(msgKey, _retval); } \
  NS_IMETHOD HasMsgOffline(nsMsgKey msgKey, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->HasMsgOffline(msgKey, _retval); } \
  NS_IMETHOD DiscardOfflineMsg(nsMsgKey msgKey) override { return !_to ? NS_ERROR_NULL_POINTER : _to->DiscardOfflineMsg(msgKey); } \
  NS_IMETHOD GetMsgInputStream(nsIMsgDBHdr *aHdr, nsIInputStream **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMsgInputStream(aHdr, _retval); } \
  NS_IMETHOD GetLocalMsgStream(nsIMsgDBHdr *aHdr, nsIInputStream **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetLocalMsgStream(aHdr, _retval); } \
  NS_IMETHOD DownloadMessagesForOffline(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsIMsgWindow *window) override { return !_to ? NS_ERROR_NULL_POINTER : _to->DownloadMessagesForOffline(messages, window); } \
  NS_IMETHOD GetChildWithURI(const nsACString& uri, bool deep, bool caseInsensitive, nsIMsgFolder **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildWithURI(uri, deep, caseInsensitive, _retval); } \
  NS_IMETHOD DownloadAllForOffline(nsIUrlListener *listener, nsIMsgWindow *window) override { return !_to ? NS_ERROR_NULL_POINTER : _to->DownloadAllForOffline(listener, window); } \
  NS_IMETHOD EnableNotifications(int32_t notificationType, bool enable) override { return !_to ? NS_ERROR_NULL_POINTER : _to->EnableNotifications(notificationType, enable); } \
  NS_IMETHOD IsCommandEnabled(const nsACString& command, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->IsCommandEnabled(command, _retval); } \
  NS_IMETHOD MatchOrChangeFilterDestination(nsIMsgFolder *folder, bool caseInsensitive, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->MatchOrChangeFilterDestination(folder, caseInsensitive, _retval); } \
  NS_IMETHOD ConfirmFolderDeletionForFilter(nsIMsgWindow *msgWindow, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ConfirmFolderDeletionForFilter(msgWindow, _retval); } \
  NS_IMETHOD AlertFilterChanged(nsIMsgWindow *msgWindow) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AlertFilterChanged(msgWindow); } \
  NS_IMETHOD ThrowAlertMsg(const char * msgName, nsIMsgWindow *msgWindow) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ThrowAlertMsg(msgName, msgWindow); } \
  NS_IMETHOD GetStringWithFolderNameFromBundle(const char * msgName, nsAString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStringWithFolderNameFromBundle(msgName, _retval); } \
  NS_IMETHOD NotifyAboutToCompact(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyAboutToCompact(); } \
  NS_IMETHOD NotifyCompactCompleted(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyCompactCompleted(); } \
  NS_IMETHOD GetRetentionSettings(nsIMsgRetentionSettings **aRetentionSettings) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRetentionSettings(aRetentionSettings); } \
  NS_IMETHOD SetRetentionSettings(nsIMsgRetentionSettings *aRetentionSettings) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRetentionSettings(aRetentionSettings); } \
  NS_IMETHOD GetDownloadSettings(nsIMsgDownloadSettings **aDownloadSettings) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDownloadSettings(aDownloadSettings); } \
  NS_IMETHOD SetDownloadSettings(nsIMsgDownloadSettings *aDownloadSettings) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDownloadSettings(aDownloadSettings); } \
  NS_IMETHOD CallFilterPlugins(nsIMsgWindow *aMsgWindow, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CallFilterPlugins(aMsgWindow, _retval); } \
  NS_IMETHOD GetSortOrder(int32_t *aSortOrder) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSortOrder(aSortOrder); } \
  NS_IMETHOD SetSortOrder(int32_t aSortOrder) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSortOrder(aSortOrder); } \
  NS_IMETHOD GetUserSortOrder(uint32_t *aUserSortOrder) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUserSortOrder(aUserSortOrder); } \
  NS_IMETHOD SetUserSortOrder(uint32_t aUserSortOrder) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUserSortOrder(aUserSortOrder); } \
  NS_IMETHOD GetDBTransferInfo(nsIPropertyBag2 **aDBTransferInfo) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDBTransferInfo(aDBTransferInfo); } \
  NS_IMETHOD SetDBTransferInfo(nsIPropertyBag2 *aDBTransferInfo) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDBTransferInfo(aDBTransferInfo); } \
  NS_IMETHOD SetStringProperty(const char * propertyName, const nsACString& propertyValue) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetStringProperty(propertyName, propertyValue); } \
  NS_IMETHOD GetStringProperty(const char * propertyName, nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStringProperty(propertyName, _retval); } \
  NS_IMETHOD GetSubFolders(nsTArray<RefPtr<nsIMsgFolder>>& aSubFolders) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSubFolders(aSubFolders); } \
  NS_IMETHOD GetHasSubFolders(bool *aHasSubFolders) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHasSubFolders(aHasSubFolders); } \
  NS_IMETHOD GetNumSubFolders(uint32_t *aNumSubFolders) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNumSubFolders(aNumSubFolders); } \
  NS_IMETHOD IsAncestorOf(nsIMsgFolder *folder, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->IsAncestorOf(folder, _retval); } \
  NS_IMETHOD ContainsChildNamed(const nsACString& name, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ContainsChildNamed(name, _retval); } \
  NS_IMETHOD GetChildNamed(const nsACString& name, nsIMsgFolder **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetChildNamed(name, _retval); } \
  NS_IMETHOD FindSubFolder(const nsACString& escapedSubFolderName, nsIMsgFolder **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->FindSubFolder(escapedSubFolderName, _retval); } \
  NS_IMETHOD AddFolderListener(nsIFolderListener *listener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AddFolderListener(listener); } \
  NS_IMETHOD RemoveFolderListener(nsIFolderListener *listener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveFolderListener(listener); } \
  NS_IMETHOD NotifyPropertyChanged(const nsACString& property, const nsACString& oldValue, const nsACString& newValue) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyPropertyChanged(property, oldValue, newValue); } \
  NS_IMETHOD NotifyIntPropertyChanged(const nsACString& property, int64_t oldValue, int64_t newValue) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyIntPropertyChanged(property, oldValue, newValue); } \
  NS_IMETHOD NotifyBoolPropertyChanged(const nsACString& property, bool oldValue, bool newValue) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyBoolPropertyChanged(property, oldValue, newValue); } \
  NS_IMETHOD NotifyPropertyFlagChanged(nsIMsgDBHdr *item, const nsACString& property, uint32_t oldValue, uint32_t newValue) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyPropertyFlagChanged(item, property, oldValue, newValue); } \
  NS_IMETHOD NotifyMessageAdded(nsIMsgDBHdr *msg) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyMessageAdded(msg); } \
  NS_IMETHOD NotifyMessageRemoved(nsIMsgDBHdr *msg) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyMessageRemoved(msg); } \
  NS_IMETHOD NotifyFolderAdded(nsIMsgFolder *child) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyFolderAdded(child); } \
  NS_IMETHOD NotifyFolderRemoved(nsIMsgFolder *child) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyFolderRemoved(child); } \
  NS_IMETHOD NotifyFolderEvent(const nsACString& event) override { return !_to ? NS_ERROR_NULL_POINTER : _to->NotifyFolderEvent(event); } \
  NS_IMETHOD GetDescendants(nsTArray<RefPtr<nsIMsgFolder>>& aDescendants) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDescendants(aDescendants); } \
  NS_IMETHOD Shutdown(bool shutdownChildren) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Shutdown(shutdownChildren); } \
  NS_IMETHOD CopyDataToOutputStreamForAppend(nsIInputStream *aIStream, int32_t aLength, nsIOutputStream *outputStream) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyDataToOutputStreamForAppend(aIStream, aLength, outputStream); } \
  NS_IMETHOD CopyDataDone(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CopyDataDone(); } \
  NS_IMETHOD SetJunkScoreForMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, nsMsgJunkScore junkScore, const nsACString& junkScoreOrigin, int32_t junkPercent) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetJunkScoreForMessages(messages, junkScore, junkScoreOrigin, junkPercent); } \
  NS_IMETHOD PerformActionsOnJunkMsgs(const nsTArray<RefPtr<nsIMsgDBHdr>>& messages, bool msgsAreJunk, nsIMsgWindow *msgWindow, nsIUrlListener *listener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->PerformActionsOnJunkMsgs(messages, msgsAreJunk, msgWindow, listener); } \
  NS_IMETHOD ApplyRetentionSettings(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ApplyRetentionSettings(); } \
  NS_IMETHOD FetchMsgPreviewText(const nsTArray<nsMsgKey >& aKeysToFetch, nsIUrlListener *aUrlListener, bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->FetchMsgPreviewText(aKeysToFetch, aUrlListener, _retval); } \
  NS_IMETHOD AddKeywordsToMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& aMessages, const nsACString& aKeywords) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AddKeywordsToMessages(aMessages, aKeywords); } \
  NS_IMETHOD RemoveKeywordsFromMessages(const nsTArray<RefPtr<nsIMsgDBHdr>>& aMessages, const nsACString& aKeywords) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RemoveKeywordsFromMessages(aMessages, aKeywords); } \
  NS_IMETHOD GetMsgTextFromStream(nsIInputStream *aStream, const nsACString& aCharset, uint32_t aBytesToRead, uint32_t aMaxOutputLen, bool aCompressQuotes, bool aStripHTMLTags, nsACString& aContentType, nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMsgTextFromStream(aStream, aCharset, aBytesToRead, aMaxOutputLen, aCompressQuotes, aStripHTMLTags, aContentType, _retval); } \
  NS_IMETHOD ConvertMsgSnippetToPlainText(const nsAString& aMessageText, nsAString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ConvertMsgSnippetToPlainText(aMessageText, _retval); } \
  NS_IMETHOD GetCustomIdentity(nsIMsgIdentity **aCustomIdentity) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetCustomIdentity(aCustomIdentity); } \
  NS_IMETHOD GetProcessingFlags(nsMsgKey msgKey, uint32_t *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetProcessingFlags(msgKey, _retval); } \
  NS_IMETHOD OrProcessingFlags(nsMsgKey msgKey, uint32_t mask) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OrProcessingFlags(msgKey, mask); } \
  NS_IMETHOD AndProcessingFlags(nsMsgKey msgKey, uint32_t mask) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AndProcessingFlags(msgKey, mask); } \
  NS_IMETHOD GetInheritedStringProperty(const char * propertyName, nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInheritedStringProperty(propertyName, _retval); } \
  NS_IMETHOD GetMsgStore(nsIMsgPluggableStore **aMsgStore) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMsgStore(aMsgStore); } \
  NS_IMETHOD GetIncomingServerType(nsACString& aIncomingServerType) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIncomingServerType(aIncomingServerType); } \
  NS_IMETHOD HandleViewCommand(nsMsgViewCommandTypeValue command, const nsTArray<nsMsgKey >& messageKeys, nsIMsgWindow *window, nsIMsgCopyServiceListener *listener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->HandleViewCommand(command, messageKeys, window, listener); } \
  NS_IMETHOD UpdateTimestamps(bool userInitiated) override { return !_to ? NS_ERROR_NULL_POINTER : _to->UpdateTimestamps(userInitiated); } 


#endif /* __gen_nsIMsgFolder_h__ */
