﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/FeatureParameter.h>
#include <aws/sagemaker/model/FeatureType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {
class DescribeFeatureMetadataResult {
 public:
  AWS_SAGEMAKER_API DescribeFeatureMetadataResult() = default;
  AWS_SAGEMAKER_API DescribeFeatureMetadataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SAGEMAKER_API DescribeFeatureMetadataResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Number (ARN) of the feature group that contains the
   * feature.</p>
   */
  inline const Aws::String& GetFeatureGroupArn() const { return m_featureGroupArn; }
  template <typename FeatureGroupArnT = Aws::String>
  void SetFeatureGroupArn(FeatureGroupArnT&& value) {
    m_featureGroupArnHasBeenSet = true;
    m_featureGroupArn = std::forward<FeatureGroupArnT>(value);
  }
  template <typename FeatureGroupArnT = Aws::String>
  DescribeFeatureMetadataResult& WithFeatureGroupArn(FeatureGroupArnT&& value) {
    SetFeatureGroupArn(std::forward<FeatureGroupArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the feature group that you've specified.</p>
   */
  inline const Aws::String& GetFeatureGroupName() const { return m_featureGroupName; }
  template <typename FeatureGroupNameT = Aws::String>
  void SetFeatureGroupName(FeatureGroupNameT&& value) {
    m_featureGroupNameHasBeenSet = true;
    m_featureGroupName = std::forward<FeatureGroupNameT>(value);
  }
  template <typename FeatureGroupNameT = Aws::String>
  DescribeFeatureMetadataResult& WithFeatureGroupName(FeatureGroupNameT&& value) {
    SetFeatureGroupName(std::forward<FeatureGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the feature that you've specified.</p>
   */
  inline const Aws::String& GetFeatureName() const { return m_featureName; }
  template <typename FeatureNameT = Aws::String>
  void SetFeatureName(FeatureNameT&& value) {
    m_featureNameHasBeenSet = true;
    m_featureName = std::forward<FeatureNameT>(value);
  }
  template <typename FeatureNameT = Aws::String>
  DescribeFeatureMetadataResult& WithFeatureName(FeatureNameT&& value) {
    SetFeatureName(std::forward<FeatureNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data type of the feature.</p>
   */
  inline FeatureType GetFeatureType() const { return m_featureType; }
  inline void SetFeatureType(FeatureType value) {
    m_featureTypeHasBeenSet = true;
    m_featureType = value;
  }
  inline DescribeFeatureMetadataResult& WithFeatureType(FeatureType value) {
    SetFeatureType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A timestamp indicating when the feature was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  DescribeFeatureMetadataResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A timestamp indicating when the metadata for the feature group was modified.
   * For example, if you add a parameter describing the feature, the timestamp
   * changes to reflect the last time you </p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  DescribeFeatureMetadataResult& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description you added to describe the feature.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DescribeFeatureMetadataResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The key-value pairs that you added to describe the feature.</p>
   */
  inline const Aws::Vector<FeatureParameter>& GetParameters() const { return m_parameters; }
  template <typename ParametersT = Aws::Vector<FeatureParameter>>
  void SetParameters(ParametersT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters = std::forward<ParametersT>(value);
  }
  template <typename ParametersT = Aws::Vector<FeatureParameter>>
  DescribeFeatureMetadataResult& WithParameters(ParametersT&& value) {
    SetParameters(std::forward<ParametersT>(value));
    return *this;
  }
  template <typename ParametersT = FeatureParameter>
  DescribeFeatureMetadataResult& AddParameters(ParametersT&& value) {
    m_parametersHasBeenSet = true;
    m_parameters.emplace_back(std::forward<ParametersT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeFeatureMetadataResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_featureGroupArn;
  bool m_featureGroupArnHasBeenSet = false;

  Aws::String m_featureGroupName;
  bool m_featureGroupNameHasBeenSet = false;

  Aws::String m_featureName;
  bool m_featureNameHasBeenSet = false;

  FeatureType m_featureType{FeatureType::NOT_SET};
  bool m_featureTypeHasBeenSet = false;

  Aws::Utils::DateTime m_creationTime{};
  bool m_creationTimeHasBeenSet = false;

  Aws::Utils::DateTime m_lastModifiedTime{};
  bool m_lastModifiedTimeHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::Vector<FeatureParameter> m_parameters;
  bool m_parametersHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
