/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.common.DateHelper;

public class CombinedCalendar
extends ProjectCalendar {
    private final ProjectCalendar m_calendar1;
    private final ProjectCalendar m_calendar2;

    public CombinedCalendar(ProjectCalendar calendar1, ProjectCalendar calendar2) {
        super(calendar1.getParentFile());
        this.m_calendar1 = calendar1;
        this.m_calendar2 = calendar2;
    }

    @Override
    protected ProjectCalendarHours getRanges(Date date, Calendar cal, Day day) {
        ProjectCalendarHours result = new ProjectCalendarHours();
        ProjectCalendarHours hours1 = date == null ? this.m_calendar1.getHours(day) : this.m_calendar1.getHours(date);
        ProjectCalendarHours hours2 = date == null ? this.m_calendar2.getHours(day) : this.m_calendar2.getHours(date);
        for (DateRange range1 : hours1) {
            DateRange range2;
            Date range2Start;
            Date range1Start = DateHelper.getCanonicalTime(range1.getStart());
            Date range1End = DateHelper.getCanonicalEndTime(range1.getStart(), range1.getEnd());
            Iterator<DateRange> iterator = hours2.iterator();
            while (iterator.hasNext() && DateHelper.compare(range1End, range2Start = DateHelper.getCanonicalTime((range2 = iterator.next()).getStart())) > 0) {
                Date range2End = DateHelper.getCanonicalEndTime(range2.getStart(), range2.getEnd());
                if (DateHelper.compare(range1Start, range2End) >= 0) continue;
                Date start = DateHelper.max(range1Start, range2Start);
                Date end = DateHelper.min(range1End, range2End);
                result.add(new DateRange(start, end));
            }
        }
        return result;
    }
}

