/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import com.jgoodies.binding.beans.PropertyAdapter;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import net.sf.mpxj.explorer.FileChooserController;
import net.sf.mpxj.explorer.FileChooserModel;
import net.sf.mpxj.explorer.FileChooserView;
import net.sf.mpxj.explorer.MppFilePanel;

public class MppExplorer {
    protected JFrame m_frame;

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                MppExplorer window = new MppExplorer();
                window.m_frame.setVisible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public MppExplorer() {
        this.initialize();
    }

    private void initialize() {
        this.m_frame = new JFrame();
        this.m_frame.setBounds(100, 100, 900, 451);
        this.m_frame.setDefaultCloseOperation(3);
        this.m_frame.getContentPane().setLayout(new GridLayout(1, 0, 0, 0));
        FileChooserModel fileChooserModel = new FileChooserModel();
        FileChooserController fileChooserController = new FileChooserController(fileChooserModel);
        FileChooserView fileChooserView = new FileChooserView(this.m_frame, fileChooserModel);
        fileChooserModel.setExtensions("mpp");
        JMenuBar menuBar = new JMenuBar();
        this.m_frame.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        menuBar.add(mnFile);
        JMenuItem mntmOpen = new JMenuItem("Open");
        mnFile.add(mntmOpen);
        mntmOpen.addActionListener(e -> fileChooserController.openFileChooser());
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.m_frame.getContentPane().add(tabbedPane);
        PropertyAdapter<FileChooserModel> adapter = new PropertyAdapter<FileChooserModel>(fileChooserModel, "file", true);
        adapter.addValueChangeListener(evt -> {
            File file = fileChooserModel.getFile();
            tabbedPane.add(file.getName(), new MppFilePanel(file));
        });
    }
}

