/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.eula;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.eula.EULAConfirmationDialog;
import org.jkiss.dbeaver.ui.eula.EULAInfoDialog;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class EULAUtils {
    private static final Log log = Log.getLog(EULAUtils.class);
    public static final String DBEAVER_EULA = "DBeaver.eula";
    private static final String eulaVersion = "1.0";

    @NotNull
    public static String getEulaVersion() {
        return eulaVersion;
    }

    public static String getPackageEula() {
        try {
            Path installPath = RuntimeUtils.getLocalPathFromURL((URL)Platform.getInstallLocation().getURL());
            Path eulaPath = installPath.resolve("eula.txt");
            if (!Files.exists(eulaPath, new LinkOption[0]) && DBWorkbench.getPlatform().getApplication().isCommunity()) {
                eulaPath = installPath.resolve("licenses/dbeaver-community-license.txt");
            }
            if (Files.exists(eulaPath, new LinkOption[0])) {
                return Files.readString(eulaPath);
            }
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
        return "EULA";
    }

    public static void showEula(@NotNull Shell shell, boolean needsConfirmation) {
        String eula = EULAUtils.getPackageEula();
        if (needsConfirmation) {
            EULAUtils.showEulaConfirmationDialog(shell, eula);
        } else {
            EULAUtils.showEulaInfoDialog(shell, eula);
        }
    }

    private static void showEulaConfirmationDialog(@NotNull Shell shell, @Nullable String eula) {
        EULAConfirmationDialog eulaDialog = new EULAConfirmationDialog(shell, eula);
        eulaDialog.open();
    }

    private static void showEulaInfoDialog(@NotNull Shell shell, @Nullable String eula) {
        EULAInfoDialog eulaDialog = new EULAInfoDialog(shell, eula);
        eulaDialog.open();
    }
}

