#pragma once

#include <cstdint>

namespace esphome {
namespace seeed_mr24hpc1 {

static const uint8_t FRAME_BUF_MAX_SIZE = 128;
static const uint8_t PRODUCT_BUF_MAX_SIZE = 32;

static const uint8_t FRAME_CONTROL_WORD_INDEX = 2;
static const uint8_t FRAME_COMMAND_WORD_INDEX = 3;
static const uint8_t FRAME_DATA_INDEX = 6;

static const uint8_t FRAME_HEADER1_VALUE = 0x53;
static const uint8_t FRAME_HEADER2_VALUE = 0x59;
static const uint8_t FRAME_TAIL1_VALUE = 0x54;
static const uint8_t FRAME_TAIL2_VALUE = 0x43;

static const uint8_t CONTROL_MAIN = 0x01;
static const uint8_t CONTROL_PRODUCT_INFORMATION = 0x02;
static const uint8_t CONTROL_WORK = 0x05;
static const uint8_t CONTROL_UNDERLYING_FUNCTION = 0x08;
static const uint8_t CONTROL_HUMAN_INFORMATION = 0x80;

static const uint8_t COMMAND_HEARTBEAT = 0x01;
static const uint8_t COMMAND_RESTART = 0x02;

static const uint8_t COMMAND_PRODUCT_MODE = 0xA1;
static const uint8_t COMMAND_PRODUCT_ID = 0xA2;
static const uint8_t COMMAND_HARDWARE_MODEL = 0xA3;
static const uint8_t COMMAND_FIRMWARE_VERSION = 0xA4;

static const uint8_t GET_HEARTBEAT[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_MAIN, COMMAND_HEARTBEAT, 0x00, 0x01, 0x0F, 0xBE,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t SET_RESTART[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_MAIN, COMMAND_RESTART, 0x00, 0x01, 0x0F, 0xBF,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};

static const uint8_t GET_PRODUCT_MODE[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_PRODUCT_INFORMATION, COMMAND_PRODUCT_MODE, 0x00, 0x01, 0x0F, 0x5F,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_PRODUCT_ID[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_PRODUCT_INFORMATION, COMMAND_PRODUCT_ID, 0x00, 0x01, 0x0F, 0x60,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_HARDWARE_MODEL[] = {
    FRAME_HEADER1_VALUE,
    FRAME_HEADER2_VALUE,
    CONTROL_PRODUCT_INFORMATION,
    COMMAND_HARDWARE_MODEL,
    0x00,
    0x01,
    0x0F,
    0x61,
    FRAME_TAIL1_VALUE,
    FRAME_TAIL2_VALUE,
};
static const uint8_t GET_FIRMWARE_VERSION[] = {
    FRAME_HEADER1_VALUE,
    FRAME_HEADER2_VALUE,
    CONTROL_PRODUCT_INFORMATION,
    COMMAND_FIRMWARE_VERSION,
    0x00,
    0x01,
    0x0F,
    0x62,
    FRAME_TAIL1_VALUE,
    FRAME_TAIL2_VALUE,
};

static const uint8_t GET_SCENE_MODE[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_WORK, 0x87, 0x00, 0x01, 0x0F, 0x48,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_SENSITIVITY[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_WORK, 0x88, 0x00, 0x01, 0x0F, 0x49,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_CUSTOM_MODE[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_WORK, 0x89, 0x00, 0x01, 0x0F, 0x4A,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};

static const uint8_t UNDERLYING_SWITCH_ON[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x00, 0x00, 0x01, 0x01, 0xB6,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t UNDERLYING_SWITCH_OFF[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x00, 0x00, 0x01, 0x00, 0xB5,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};

static const uint8_t GET_RADAR_OUTPUT_INFORMATION_SWITCH[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x80, 0x00, 0x01, 0x0F, 0x44,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_SPATIAL_STATIC_VALUE[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x81, 0x00, 0x01, 0x0F, 0x45,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_SPATIAL_MOTION_VALUE[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x82, 0x00, 0x01, 0x0F, 0x46,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_DISTANCE_OF_STATIC_OBJECT[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x83, 0x00, 0x01, 0x0F, 0x47,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_DISTANCE_OF_MOVING_OBJECT[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x84, 0x00, 0x01, 0x0F, 0x48,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_TARGET_MOVEMENT_SPEED[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x85, 0x00, 0x01, 0x0F, 0x49,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_EXISTENCE_THRESHOLD[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x88, 0x00, 0x01, 0x0F, 0x4C,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_MOTION_THRESHOLD[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x89, 0x00, 0x01, 0x0F, 0x4D,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_EXISTENCE_BOUNDARY[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x8A, 0x00, 0x01, 0x0F, 0x4E,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_MOTION_BOUNDARY[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x8B, 0x00, 0x01, 0x0F, 0x4F,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_MOTION_TRIGGER_TIME[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x8C, 0x00, 0x01, 0x0F, 0x50,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_MOTION_TO_REST_TIME[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x8D, 0x00, 0x01, 0x0F, 0x51,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_CUSTOM_UNMAN_TIME[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_UNDERLYING_FUNCTION, 0x8E, 0x00, 0x01, 0x0F, 0x52,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};

static const uint8_t GET_HUMAN_STATUS[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_HUMAN_INFORMATION, 0x81, 0x00, 0x01, 0x0F, 0xBD,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_HUMAN_MOTION_INFORMATION[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_HUMAN_INFORMATION, 0x82, 0x00, 0x01, 0x0F, 0xBE,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_BODY_MOTION_PARAMETERS[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_HUMAN_INFORMATION, 0x83, 0x00, 0x01, 0x0F, 0xBF,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_UNMANNED_TIME[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_HUMAN_INFORMATION, 0x8A, 0x00, 0x01, 0x0F, 0xC6,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};
static const uint8_t GET_KEEP_AWAY[] = {
    FRAME_HEADER1_VALUE, FRAME_HEADER2_VALUE, CONTROL_HUMAN_INFORMATION, 0x8B, 0x00, 0x01, 0x0F, 0xC7,
    FRAME_TAIL1_VALUE,   FRAME_TAIL2_VALUE,
};

}  // namespace seeed_mr24hpc1
}  // namespace esphome
