---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token New Relic user API key'
---

## Description

The response body contains content that matches the pattern of a New Relic user API key was identified. User keys are used for querying data and managing configurations (Alerts, Synthetics, dashboards, etc.). A malicious actor with access to this key can execute API requests as the user who created it.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). For more information, please see [New Relic's documentation on rotating API keys](https://docs.newrelic.com/docs/apis/intro-apis/new-relic-api-keys/#rotate-keys).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.81 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
