/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.BytecodeCreatorImpl;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodCreatorImpl;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.MethodVisitor;

class FunctionCreatorImpl
implements FunctionCreator {
    static final String FIELD_NAME = "f";
    private final ResultHandle instance;
    private final ClassCreator classCreator;
    private final Map<ResultHandle, CapturedResultHandle> capturedResultHandles = new LinkedHashMap<ResultHandle, CapturedResultHandle>();
    private final BytecodeCreatorImpl owner;
    private final FunctionBytecodeCreator fbc;
    private int fieldCount;

    FunctionCreatorImpl(ResultHandle instance, ClassCreator classCreator, MethodCreatorImpl methodCreator, BytecodeCreatorImpl owner) {
        this.instance = instance;
        this.classCreator = classCreator;
        this.owner = owner;
        this.fbc = new FunctionBytecodeCreator(this, methodCreator);
    }

    @Override
    public ResultHandle getInstance() {
        return this.instance;
    }

    Set<ResultHandle> getCapturedResultHandles() {
        return this.capturedResultHandles.keySet();
    }

    @Override
    public BytecodeCreatorImpl getBytecode() {
        return this.fbc;
    }

    public void writeCreateInstance(MethodVisitor methodVisitor) {
        ResultHandle[] outerCtorArgs = new ResultHandle[this.capturedResultHandles.size()];
        CapturedResultHandle[] crh = new CapturedResultHandle[this.capturedResultHandles.size()];
        String[] types = new String[this.capturedResultHandles.size()];
        int count = 0;
        for (Map.Entry<ResultHandle, CapturedResultHandle> e : this.capturedResultHandles.entrySet()) {
            crh[count] = e.getValue();
            types[count] = e.getKey().getType();
            outerCtorArgs[count++] = e.getKey();
        }
        MethodCreator ctorCreator = this.classCreator.getMethodCreator("<init>", "V", types);
        ctorCreator.invokeSpecialMethod(MethodDescriptor.ofMethod(Object.class, "<init>", Void.TYPE, new Class[0]), ctorCreator.getThis(), new ResultHandle[0]);
        for (int i = 0; i < crh.length; ++i) {
            ctorCreator.writeInstanceField(crh[i].descriptor, ctorCreator.getThis(), ctorCreator.getMethodParam(i));
        }
        ctorCreator.returnValue(null);
        this.owner.createNewInstanceOp(this.instance, ctorCreator.getMethodDescriptor(), outerCtorArgs).doProcess(methodVisitor);
    }

    private static class FunctionBytecodeCreator
    extends BytecodeCreatorImpl {
        private final FunctionCreatorImpl functionCreator;
        private final MethodCreatorImpl method;

        FunctionBytecodeCreator(FunctionCreatorImpl functionCreator, MethodCreatorImpl method) {
            super(method);
            this.functionCreator = functionCreator;
            this.method = method;
        }

        @Override
        ResultHandle resolve(ResultHandle handle, BytecodeCreator invoker) {
            if (handle == null || handle.getResultType() == ResultHandle.ResultType.CONSTANT) {
                return handle;
            }
            BytecodeCreatorImpl ourOwner = this.method.getOwner();
            handle = ourOwner.resolve(handle);
            BytecodeCreatorImpl newOwner = handle.getOwner();
            if (newOwner.isScopedWithin(this.method)) {
                return handle;
            }
            if (newOwner.getMethod() == ourOwner.getMethod()) {
                CapturedResultHandle capture = this.functionCreator.capturedResultHandles.get(handle);
                if (capture != null) {
                    return capture.substitute;
                }
                String name = FunctionCreatorImpl.FIELD_NAME + this.functionCreator.fieldCount++;
                FieldCreator field = this.functionCreator.classCreator.getFieldCreator(name, handle.getType());
                field.setModifiers(18);
                ResultHandle sub = invoker.readInstanceField(field.getFieldDescriptor(), this.getMethod().getThis());
                capture = new CapturedResultHandle(sub, field.getFieldDescriptor());
                this.functionCreator.capturedResultHandles.put(handle, capture);
                return sub;
            }
            return handle;
        }

        @Override
        ResultHandle[] resolve(BytecodeCreator owner, ResultHandle ... handle) {
            ResultHandle[] ret = new ResultHandle[handle.length];
            for (int i = 0; i < handle.length; ++i) {
                ret[i] = this.resolve(handle[i], owner);
            }
            return ret;
        }

        @Override
        MethodCreatorImpl getMethod() {
            return this.method;
        }

        @Override
        public ResultHandle invokeSpecialMethod(MethodDescriptor descriptor, ResultHandle object, ResultHandle ... args) {
            ClassCreator ownersCreator = this.getMethod().getOwner().getMethod().getClassCreator();
            String superClass = ownersCreator.getSuperClass();
            if (descriptor.getDeclaringClass().equals(superClass)) {
                MethodDescriptor newMethod = ownersCreator.getSupertypeAccessor(descriptor, superClass, false);
                return super.invokeVirtualMethod(newMethod, object, args);
            }
            return super.invokeSpecialMethod(descriptor, object, args);
        }

        @Override
        public ResultHandle invokeSpecialInterfaceMethod(MethodDescriptor descriptor, ResultHandle object, ResultHandle ... args) {
            ClassCreator ownersCreator = this.getMethod().getOwner().getMethod().getClassCreator();
            for (String superInterface : ownersCreator.getInterfaces()) {
                if (!descriptor.getDeclaringClass().equals(superInterface)) continue;
                MethodDescriptor newMethod = ownersCreator.getSupertypeAccessor(descriptor, superInterface, true);
                return super.invokeVirtualMethod(newMethod, object, args);
            }
            return super.invokeSpecialInterfaceMethod(descriptor, object, args);
        }

        @Override
        public void continueScope(BytecodeCreator scope) {
            throw this.nonLocalReturn();
        }

        @Override
        public void breakScope(BytecodeCreator scope) {
            throw this.nonLocalReturn();
        }

        private UnsupportedOperationException nonLocalReturn() {
            return new UnsupportedOperationException("Non-local return is unsupported");
        }
    }

    private static final class CapturedResultHandle {
        final ResultHandle substitute;
        final FieldDescriptor descriptor;

        private CapturedResultHandle(ResultHandle substitute, FieldDescriptor descriptor) {
            this.substitute = substitute;
            this.descriptor = descriptor;
        }
    }
}

