/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine.qframe;

import java.util.Locale;
import org.apache.lucene.analysis.util.CSVUtil;
import org.opensearch.Version;
import org.opensearch.knn.index.engine.faiss.QFrameBitEncoder;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.quantization.enums.ScalarQuantizationType;

public class QuantizationConfigParser {
    public static final String SEPARATOR = "=";
    public static final String TYPE_NAME = "type";
    public static final String BINARY_TYPE = "binary";
    public static final String BIT_COUNT_NAME = "bits";
    public static final String RANDOM_ROTATION_NAME = "random_rotation";
    public static final String ADC_NAME = "enable_adc";

    public static String toCsv(QuantizationConfig quantizationConfig) {
        if (quantizationConfig == null || quantizationConfig == QuantizationConfig.EMPTY || quantizationConfig.getQuantizationType() == null) {
            return "";
        }
        String result = "type=binary,bits=" + quantizationConfig.getQuantizationType().getId();
        if (Version.CURRENT.onOrAfter(Version.V_3_2_0)) {
            result = result + ",random_rotation=" + quantizationConfig.isEnableRandomRotation() + ",enable_adc=" + quantizationConfig.isEnableADC();
        }
        return result;
    }

    public static QuantizationConfig fromCsv(String csv) {
        if (csv == null || csv.isEmpty()) {
            return QuantizationConfig.EMPTY;
        }
        String[] csvArray = CSVUtil.parse((String)csv);
        int csvArrayLength = csvArray.length;
        if (csvArrayLength != 2 && csvArrayLength != 4) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid csv for quantization config: \"%s\"", csv));
        }
        String typeValue = QuantizationConfigParser.getValueOrThrow(TYPE_NAME, csvArray[0]);
        if (!typeValue.equals(BINARY_TYPE)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unsupported quantization type: \"%s\"", typeValue));
        }
        String bitsValue = QuantizationConfigParser.getValueOrThrow(BIT_COUNT_NAME, csvArray[1]);
        int bitCount = Integer.parseInt(bitsValue);
        ScalarQuantizationType quantizationType = ScalarQuantizationType.fromId(bitCount);
        boolean isEnableRandomRotation = QFrameBitEncoder.DEFAULT_ENABLE_RANDOM_ROTATION;
        boolean isEnableADC = QFrameBitEncoder.DEFAULT_ENABLE_ADC;
        if (csvArrayLength == 4) {
            String isEnableRandomRotationValue = QuantizationConfigParser.getValueOrThrow(RANDOM_ROTATION_NAME, csvArray[2]);
            isEnableRandomRotation = Boolean.parseBoolean(isEnableRandomRotationValue);
            String isEnableADCValue = QuantizationConfigParser.getValueOrThrow(ADC_NAME, csvArray[3]);
            isEnableADC = Boolean.parseBoolean(isEnableADCValue);
        }
        return QuantizationConfig.builder().quantizationType(quantizationType).enableRandomRotation(isEnableRandomRotation).enableADC(isEnableADC).build();
    }

    private static String getValueOrThrow(String expectedKey, String keyValue) {
        String[] keyValueArr = keyValue.split(SEPARATOR);
        if (keyValueArr.length != 2) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid csv value for quantization config: \"%s\"", keyValue));
        }
        if (!keyValueArr[0].equals(expectedKey)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected: \"%s\" But got: \"%s\"", expectedKey, keyValue));
        }
        return keyValueArr[1];
    }
}

