/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class PyCreatePropertyQuickFix
extends PsiUpdateModCommandQuickFix {
    private final AccessDirection myAccessDirection;

    public PyCreatePropertyQuickFix(AccessDirection dir) {
        this.myAccessDirection = dir;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.create.property", new Object[0]);
        if (string == null) {
            PyCreatePropertyQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PyType type2;
        PyExpression qualifier;
        if (project == null) {
            PyCreatePropertyQuickFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PyCreatePropertyQuickFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            PyCreatePropertyQuickFix.$$$reportNull$$$0(3);
        }
        if (element instanceof PyQualifiedExpression && (qualifier = ((PyQualifiedExpression)element).getQualifier()) != null && (type2 = TypeEvalContext.codeAnalysis(element.getProject(), element.getContainingFile()).getType(qualifier)) instanceof PyClassType) {
            PyClass cls = ((PyClassType)type2).getPyClass();
            String propertyName = ((PyQualifiedExpression)element).getName();
            if (propertyName == null) {
                return;
            }
            String fieldName = "_" + propertyName;
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            PyFunction property = generator.createProperty(LanguageLevel.forElement(cls), propertyName, fieldName, this.myAccessDirection);
            PyStatementList statementsList = (PyStatementList)updater.getWritable((PsiElement)cls.getStatementList());
            PyPsiRefactoringUtil.addElementToStatementList(property, statementsList, this.myAccessDirection == AccessDirection.READ);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyCreatePropertyQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyCreatePropertyQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

