/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JListCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.JListCellBoundsQuery;
import org.assertj.swing.driver.JListCellCenterQuery;
import org.assertj.swing.driver.JListItemPreconditions;
import org.assertj.swing.driver.JListMatchingItemQuery;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.TextMatcher;

final class JListScrollToItemTask {
    static final Pair<Integer, Point> ITEM_NOT_FOUND = Pair.of(-1, null);

    @Nonnull
    @RunsInEDT
    static Point scrollToItem(@Nonnull JList<?> list, int index) {
        Point result = GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(list);
            JListItemPreconditions.checkIndexInBounds(list, index);
            return JListScrollToItemTask.scrollToItemWithIndex(list, index);
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    @RunsInEDT
    static Pair<Integer, Point> scrollToItem(final @Nonnull JList<?> list, final @Nonnull TextMatcher matcher, final @Nonnull JListCellReader cellReader) {
        Pair<Integer, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(list);
                int index = JListMatchingItemQuery.matchingItemIndex(list, matcher, cellReader);
                if (index < 0) {
                    return ITEM_NOT_FOUND;
                }
                return Pair.of(index, JListScrollToItemTask.scrollToItemWithIndex(list, index));
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @Nonnull
    @RunsInEDT
    static Pair<Integer, Point> scrollToItemIfNotSelectedYet(final @Nonnull JList<?> list, final @Nonnull TextMatcher matcher, final @Nonnull JListCellReader cellReader) {
        Pair<Integer, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(list);
                int index = JListMatchingItemQuery.matchingItemIndex(list, matcher, cellReader);
                if (index < 0) {
                    return ITEM_NOT_FOUND;
                }
                return Pair.of(index, JListScrollToItemTask.scrollToItemWithIndexIfNotSelectedYet(list, index));
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @Nullable
    @RunsInEDT
    static Point scrollToItemIfNotSelectedYet(@Nonnull JList<?> list, int index) {
        return GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(list);
            JListItemPreconditions.checkIndexInBounds(list, index);
            return JListScrollToItemTask.scrollToItemWithIndexIfNotSelectedYet(list, index);
        });
    }

    @Nullable
    @RunsInCurrentThread
    private static Point scrollToItemWithIndexIfNotSelectedYet(@Nonnull JList<?> list, int index) {
        if (list.getSelectedIndex() == index) {
            return null;
        }
        return JListScrollToItemTask.scrollToItemWithIndex(list, index);
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point scrollToItemWithIndex(@Nonnull JList<?> list, int index) {
        Rectangle cellBounds = (Rectangle)Preconditions.checkNotNull((Object)JListCellBoundsQuery.cellBounds(list, index));
        list.scrollRectToVisible(cellBounds);
        return JListCellCenterQuery.cellCenter(list, cellBounds);
    }

    private JListScrollToItemTask() {
    }
}

