// third_party/blink/public/mojom/shared_storage/shared_storage.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/shared_storage.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class SharedStorageUrlWithMetadataDataView;

class PrivateAggregationConfigDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SharedStorageUrlWithMetadataDataView> {
  using Data = ::blink::mojom::internal::SharedStorageUrlWithMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PrivateAggregationConfigDataView> {
  using Data = ::blink::mojom::internal::PrivateAggregationConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class SharedStorageGetStatus : int32_t {
  
  kSuccess = 0,
  
  kNotFound = 1,
  
  kError = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SharedStorageGetStatus value);
inline bool IsKnownEnumValue(SharedStorageGetStatus value) {
  return internal::SharedStorageGetStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SharedStorageWorkletCreationMethod : int32_t {
  
  kAddModule = 0,
  
  kCreateWorklet = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, SharedStorageWorkletCreationMethod value);
inline bool IsKnownEnumValue(SharedStorageWorkletCreationMethod value) {
  return internal::SharedStorageWorkletCreationMethod_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SharedStorageWorkletHostInterfaceBase {};

using SharedStorageWorkletHostPtrDataView =
    mojo::InterfacePtrDataView<SharedStorageWorkletHostInterfaceBase>;
using SharedStorageWorkletHostRequestDataView =
    mojo::InterfaceRequestDataView<SharedStorageWorkletHostInterfaceBase>;
using SharedStorageWorkletHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SharedStorageWorkletHostInterfaceBase>;
using SharedStorageWorkletHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SharedStorageWorkletHostInterfaceBase>;
class SharedStorageDocumentServiceInterfaceBase {};

using SharedStorageDocumentServicePtrDataView =
    mojo::InterfacePtrDataView<SharedStorageDocumentServiceInterfaceBase>;
using SharedStorageDocumentServiceRequestDataView =
    mojo::InterfaceRequestDataView<SharedStorageDocumentServiceInterfaceBase>;
using SharedStorageDocumentServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SharedStorageDocumentServiceInterfaceBase>;
using SharedStorageDocumentServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SharedStorageDocumentServiceInterfaceBase>;


class SharedStorageUrlWithMetadataDataView {
 public:
  SharedStorageUrlWithMetadataDataView() = default;

  SharedStorageUrlWithMetadataDataView(
      internal::SharedStorageUrlWithMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReportingMetadataDataView(
      mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingMetadata(UserType* output) {
    
    auto* pointer = data_->reporting_metadata.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SharedStorageUrlWithMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrivateAggregationConfigDataView {
 public:
  PrivateAggregationConfigDataView() = default;

  PrivateAggregationConfigDataView(
      internal::PrivateAggregationConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAggregationCoordinatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregationCoordinatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `aggregation_coordinator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAggregationCoordinatorOrigin` instead "
    "of `ReadAggregationCoordinatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->aggregation_coordinator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetContextIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContextId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `context_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContextId` instead "
    "of `ReadContextId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->context_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t filtering_id_max_bytes() const {
    return data_->filtering_id_max_bytes;
  }
  std::optional<uint16_t> max_contributions() const {

    return data_->max_contributions_$flag
        ? std::make_optional(data_->max_contributions_$value)
        : std::nullopt;
  }
 private:
  internal::PrivateAggregationConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::SharedStorageGetStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SharedStorageGetStatus> {};

template <>
struct hash<::blink::mojom::SharedStorageWorkletCreationMethod>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SharedStorageWorkletCreationMethod> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedStorageGetStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SharedStorageGetStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SharedStorageGetStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedStorageWorkletCreationMethod, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SharedStorageWorkletCreationMethod, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SharedStorageWorkletCreationMethod>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedStorageUrlWithMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SharedStorageUrlWithMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SharedStorageUrlWithMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in SharedStorageUrlWithMetadata struct");
    decltype(Traits::reporting_metadata(input)) in_reporting_metadata = Traits::reporting_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reporting_metadata)::BaseType>
        reporting_metadata_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& reporting_metadata_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>>(
        in_reporting_metadata, reporting_metadata_fragment, &reporting_metadata_validate_params);
    fragment->reporting_metadata.Set(
        reporting_metadata_fragment.is_null() ? nullptr : reporting_metadata_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->reporting_metadata.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reporting_metadata in SharedStorageUrlWithMetadata struct");
  }

  static bool Deserialize(::blink::mojom::internal::SharedStorageUrlWithMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SharedStorageUrlWithMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PrivateAggregationConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PrivateAggregationConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PrivateAggregationConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::aggregation_coordinator_origin(input)) in_aggregation_coordinator_origin = Traits::aggregation_coordinator_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aggregation_coordinator_origin)::BaseType> aggregation_coordinator_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_aggregation_coordinator_origin, aggregation_coordinator_origin_fragment);
    fragment->aggregation_coordinator_origin.Set(
        aggregation_coordinator_origin_fragment.is_null() ? nullptr : aggregation_coordinator_origin_fragment.data());
    decltype(Traits::context_id(input)) in_context_id = Traits::context_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->context_id)::BaseType> context_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_context_id, context_id_fragment);
    fragment->context_id.Set(
        context_id_fragment.is_null() ? nullptr : context_id_fragment.data());
    fragment->filtering_id_max_bytes = Traits::filtering_id_max_bytes(input);
    fragment->max_contributions_$flag = Traits::max_contributions(input).has_value();
    if (Traits::max_contributions(input).has_value()) {
      fragment->max_contributions_$value = Traits::max_contributions(input).value();
    }
  }

  static bool Deserialize(::blink::mojom::internal::PrivateAggregationConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PrivateAggregationConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void SharedStorageUrlWithMetadataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SharedStorageUrlWithMetadataDataView::GetReportingMetadataDataView(
    mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>* output) {
  auto pointer = data_->reporting_metadata.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>(pointer, message_);
}


inline void PrivateAggregationConfigDataView::GetAggregationCoordinatorOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->aggregation_coordinator_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void PrivateAggregationConfigDataView::GetContextIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->context_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SharedStorageGetStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SharedStorageGetStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SharedStorageWorkletCreationMethod> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SharedStorageWorkletCreationMethod value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_MOJOM_SHARED_H_