// ui/gfx/mojom/hdr_metadata.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_HDR_METADATA_MOJOM_BLINK_H_
#define UI_GFX_MOJOM_HDR_METADATA_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/hdr_metadata.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/hdr_metadata.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/hdr_metadata.mojom-blink-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolorspace_primaries.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gfx::mojom::blink {





class  HdrMetadataCta861_3 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HdrMetadataCta861_3, T>::value>;
  using DataView = HdrMetadataCta861_3DataView;
  using Data_ = internal::HdrMetadataCta861_3_Data;

  template <typename... Args>
  static HdrMetadataCta861_3Ptr New(Args&&... args) {
    return HdrMetadataCta861_3Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HdrMetadataCta861_3Ptr From(const U& u) {
    return mojo::TypeConverter<HdrMetadataCta861_3Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HdrMetadataCta861_3>::Convert(*this);
  }


  HdrMetadataCta861_3();

  HdrMetadataCta861_3(
      uint32_t max_content_light_level,
      uint32_t max_frame_average_light_level);


  ~HdrMetadataCta861_3();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HdrMetadataCta861_3Ptr>
  HdrMetadataCta861_3Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HdrMetadataCta861_3::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HdrMetadataCta861_3::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HdrMetadataCta861_3::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HdrMetadataCta861_3::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HdrMetadataCta861_3::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HdrMetadataCta861_3_UnserializedMessageContext<
            UserType, HdrMetadataCta861_3::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HdrMetadataCta861_3::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HdrMetadataCta861_3::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HdrMetadataCta861_3_UnserializedMessageContext<
            UserType, HdrMetadataCta861_3::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HdrMetadataCta861_3::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t max_content_light_level;
  
  uint32_t max_frame_average_light_level;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HdrMetadataCta861_3::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HdrMetadataCta861_3::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HdrMetadataCta861_3::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HdrMetadataCta861_3::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  HdrMetadataNdwl {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HdrMetadataNdwl, T>::value>;
  using DataView = HdrMetadataNdwlDataView;
  using Data_ = internal::HdrMetadataNdwl_Data;

  template <typename... Args>
  static HdrMetadataNdwlPtr New(Args&&... args) {
    return HdrMetadataNdwlPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HdrMetadataNdwlPtr From(const U& u) {
    return mojo::TypeConverter<HdrMetadataNdwlPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HdrMetadataNdwl>::Convert(*this);
  }


  HdrMetadataNdwl();

  explicit HdrMetadataNdwl(
      float nits);


  ~HdrMetadataNdwl();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HdrMetadataNdwlPtr>
  HdrMetadataNdwlPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HdrMetadataNdwl::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HdrMetadataNdwl::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HdrMetadataNdwl::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HdrMetadataNdwl::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HdrMetadataNdwl::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HdrMetadataNdwl_UnserializedMessageContext<
            UserType, HdrMetadataNdwl::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HdrMetadataNdwl::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HdrMetadataNdwl::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HdrMetadataNdwl_UnserializedMessageContext<
            UserType, HdrMetadataNdwl::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HdrMetadataNdwl::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float nits;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HdrMetadataNdwl::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HdrMetadataNdwl::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HdrMetadataNdwl::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HdrMetadataNdwl::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HdrMetadataExtendedRange {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HdrMetadataExtendedRange, T>::value>;
  using DataView = HdrMetadataExtendedRangeDataView;
  using Data_ = internal::HdrMetadataExtendedRange_Data;

  template <typename... Args>
  static HdrMetadataExtendedRangePtr New(Args&&... args) {
    return HdrMetadataExtendedRangePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HdrMetadataExtendedRangePtr From(const U& u) {
    return mojo::TypeConverter<HdrMetadataExtendedRangePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HdrMetadataExtendedRange>::Convert(*this);
  }


  HdrMetadataExtendedRange();

  HdrMetadataExtendedRange(
      float current_headroom,
      float desired_headroom);


  ~HdrMetadataExtendedRange();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HdrMetadataExtendedRangePtr>
  HdrMetadataExtendedRangePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HdrMetadataExtendedRange::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HdrMetadataExtendedRange::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HdrMetadataExtendedRange::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HdrMetadataExtendedRange::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HdrMetadataExtendedRange::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HdrMetadataExtendedRange_UnserializedMessageContext<
            UserType, HdrMetadataExtendedRange::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HdrMetadataExtendedRange::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HdrMetadataExtendedRange::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HdrMetadataExtendedRange_UnserializedMessageContext<
            UserType, HdrMetadataExtendedRange::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HdrMetadataExtendedRange::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float current_headroom;
  
  float desired_headroom;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HdrMetadataExtendedRange::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HdrMetadataExtendedRange::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HdrMetadataExtendedRange::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HdrMetadataExtendedRange::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  HdrMetadataSmpteSt2086 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HdrMetadataSmpteSt2086, T>::value>;
  using DataView = HdrMetadataSmpteSt2086DataView;
  using Data_ = internal::HdrMetadataSmpteSt2086_Data;

  template <typename... Args>
  static HdrMetadataSmpteSt2086Ptr New(Args&&... args) {
    return HdrMetadataSmpteSt2086Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HdrMetadataSmpteSt2086Ptr From(const U& u) {
    return mojo::TypeConverter<HdrMetadataSmpteSt2086Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HdrMetadataSmpteSt2086>::Convert(*this);
  }


  HdrMetadataSmpteSt2086();

  HdrMetadataSmpteSt2086(
      const ::SkColorSpacePrimaries& primaries,
      float luminance_max,
      float luminance_min);


  ~HdrMetadataSmpteSt2086();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HdrMetadataSmpteSt2086Ptr>
  HdrMetadataSmpteSt2086Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HdrMetadataSmpteSt2086::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HdrMetadataSmpteSt2086::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HdrMetadataSmpteSt2086::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HdrMetadataSmpteSt2086::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HdrMetadataSmpteSt2086::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HdrMetadataSmpteSt2086_UnserializedMessageContext<
            UserType, HdrMetadataSmpteSt2086::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HdrMetadataSmpteSt2086::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HdrMetadataSmpteSt2086::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HdrMetadataSmpteSt2086_UnserializedMessageContext<
            UserType, HdrMetadataSmpteSt2086::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HdrMetadataSmpteSt2086::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkColorSpacePrimaries primaries;
  
  float luminance_max;
  
  float luminance_min;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HdrMetadataSmpteSt2086::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HdrMetadataSmpteSt2086::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HdrMetadataSmpteSt2086::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HdrMetadataSmpteSt2086::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  HDRMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HDRMetadata, T>::value>;
  using DataView = HDRMetadataDataView;
  using Data_ = internal::HDRMetadata_Data;

  template <typename... Args>
  static HDRMetadataPtr New(Args&&... args) {
    return HDRMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HDRMetadataPtr From(const U& u) {
    return mojo::TypeConverter<HDRMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HDRMetadata>::Convert(*this);
  }


  HDRMetadata();

  HDRMetadata(
      HdrMetadataSmpteSt2086Ptr smpte_st_2086,
      HdrMetadataCta861_3Ptr cta_861_3,
      HdrMetadataNdwlPtr ndwl,
      HdrMetadataExtendedRangePtr extended_range);

HDRMetadata(const HDRMetadata&) = delete;
HDRMetadata& operator=(const HDRMetadata&) = delete;

  ~HDRMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HDRMetadataPtr>
  HDRMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HDRMetadata::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HDRMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HDRMetadata_UnserializedMessageContext<
            UserType, HDRMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HDRMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HDRMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HDRMetadata_UnserializedMessageContext<
            UserType, HDRMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HDRMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  HdrMetadataSmpteSt2086Ptr smpte_st_2086;
  
  HdrMetadataCta861_3Ptr cta_861_3;
  
  HdrMetadataNdwlPtr ndwl;
  
  HdrMetadataExtendedRangePtr extended_range;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HdrMetadataCta861_3Ptr HdrMetadataCta861_3::Clone() const {
  return New(
      mojo::Clone(max_content_light_level),
      mojo::Clone(max_frame_average_light_level)
  );
}

template <typename T, HdrMetadataCta861_3::EnableIfSame<T>*>
bool HdrMetadataCta861_3::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->max_content_light_level, other_struct.max_content_light_level))
    return false;
  if (!mojo::Equals(this->max_frame_average_light_level, other_struct.max_frame_average_light_level))
    return false;
  return true;
}

template <typename T, HdrMetadataCta861_3::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.max_content_light_level < rhs.max_content_light_level)
    return true;
  if (rhs.max_content_light_level < lhs.max_content_light_level)
    return false;
  if (lhs.max_frame_average_light_level < rhs.max_frame_average_light_level)
    return true;
  if (rhs.max_frame_average_light_level < lhs.max_frame_average_light_level)
    return false;
  return false;
}
template <typename StructPtrType>
HdrMetadataSmpteSt2086Ptr HdrMetadataSmpteSt2086::Clone() const {
  return New(
      mojo::Clone(primaries),
      mojo::Clone(luminance_max),
      mojo::Clone(luminance_min)
  );
}

template <typename T, HdrMetadataSmpteSt2086::EnableIfSame<T>*>
bool HdrMetadataSmpteSt2086::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primaries, other_struct.primaries))
    return false;
  if (!mojo::Equals(this->luminance_max, other_struct.luminance_max))
    return false;
  if (!mojo::Equals(this->luminance_min, other_struct.luminance_min))
    return false;
  return true;
}

template <typename T, HdrMetadataSmpteSt2086::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.primaries < rhs.primaries)
    return true;
  if (rhs.primaries < lhs.primaries)
    return false;
  if (lhs.luminance_max < rhs.luminance_max)
    return true;
  if (rhs.luminance_max < lhs.luminance_max)
    return false;
  if (lhs.luminance_min < rhs.luminance_min)
    return true;
  if (rhs.luminance_min < lhs.luminance_min)
    return false;
  return false;
}
template <typename StructPtrType>
HdrMetadataNdwlPtr HdrMetadataNdwl::Clone() const {
  return New(
      mojo::Clone(nits)
  );
}

template <typename T, HdrMetadataNdwl::EnableIfSame<T>*>
bool HdrMetadataNdwl::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->nits, other_struct.nits))
    return false;
  return true;
}

template <typename T, HdrMetadataNdwl::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.nits < rhs.nits)
    return true;
  if (rhs.nits < lhs.nits)
    return false;
  return false;
}
template <typename StructPtrType>
HdrMetadataExtendedRangePtr HdrMetadataExtendedRange::Clone() const {
  return New(
      mojo::Clone(current_headroom),
      mojo::Clone(desired_headroom)
  );
}

template <typename T, HdrMetadataExtendedRange::EnableIfSame<T>*>
bool HdrMetadataExtendedRange::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->current_headroom, other_struct.current_headroom))
    return false;
  if (!mojo::Equals(this->desired_headroom, other_struct.desired_headroom))
    return false;
  return true;
}

template <typename T, HdrMetadataExtendedRange::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.current_headroom < rhs.current_headroom)
    return true;
  if (rhs.current_headroom < lhs.current_headroom)
    return false;
  if (lhs.desired_headroom < rhs.desired_headroom)
    return true;
  if (rhs.desired_headroom < lhs.desired_headroom)
    return false;
  return false;
}
template <typename StructPtrType>
HDRMetadataPtr HDRMetadata::Clone() const {
  return New(
      mojo::Clone(smpte_st_2086),
      mojo::Clone(cta_861_3),
      mojo::Clone(ndwl),
      mojo::Clone(extended_range)
  );
}

template <typename T, HDRMetadata::EnableIfSame<T>*>
bool HDRMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->smpte_st_2086, other_struct.smpte_st_2086))
    return false;
  if (!mojo::Equals(this->cta_861_3, other_struct.cta_861_3))
    return false;
  if (!mojo::Equals(this->ndwl, other_struct.ndwl))
    return false;
  if (!mojo::Equals(this->extended_range, other_struct.extended_range))
    return false;
  return true;
}

template <typename T, HDRMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.smpte_st_2086 < rhs.smpte_st_2086)
    return true;
  if (rhs.smpte_st_2086 < lhs.smpte_st_2086)
    return false;
  if (lhs.cta_861_3 < rhs.cta_861_3)
    return true;
  if (rhs.cta_861_3 < lhs.cta_861_3)
    return false;
  if (lhs.ndwl < rhs.ndwl)
    return true;
  if (rhs.ndwl < lhs.ndwl)
    return false;
  if (lhs.extended_range < rhs.extended_range)
    return true;
  if (rhs.extended_range < lhs.extended_range)
    return false;
  return false;
}


}  // gfx::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::blink::HdrMetadataCta861_3::DataView,
                                         ::gfx::mojom::blink::HdrMetadataCta861_3Ptr> {
  static bool IsNull(const ::gfx::mojom::blink::HdrMetadataCta861_3Ptr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::HdrMetadataCta861_3Ptr* output) { output->reset(); }

  static decltype(::gfx::mojom::blink::HdrMetadataCta861_3::max_content_light_level) max_content_light_level(
      const ::gfx::mojom::blink::HdrMetadataCta861_3Ptr& input) {
    return input->max_content_light_level;
  }

  static decltype(::gfx::mojom::blink::HdrMetadataCta861_3::max_frame_average_light_level) max_frame_average_light_level(
      const ::gfx::mojom::blink::HdrMetadataCta861_3Ptr& input) {
    return input->max_frame_average_light_level;
  }

  static bool Read(::gfx::mojom::blink::HdrMetadataCta861_3::DataView input, ::gfx::mojom::blink::HdrMetadataCta861_3Ptr* output);
};


template <>
struct  StructTraits<::gfx::mojom::blink::HdrMetadataSmpteSt2086::DataView,
                                         ::gfx::mojom::blink::HdrMetadataSmpteSt2086Ptr> {
  static bool IsNull(const ::gfx::mojom::blink::HdrMetadataSmpteSt2086Ptr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::HdrMetadataSmpteSt2086Ptr* output) { output->reset(); }

  static const decltype(::gfx::mojom::blink::HdrMetadataSmpteSt2086::primaries)& primaries(
      const ::gfx::mojom::blink::HdrMetadataSmpteSt2086Ptr& input) {
    return input->primaries;
  }

  static decltype(::gfx::mojom::blink::HdrMetadataSmpteSt2086::luminance_max) luminance_max(
      const ::gfx::mojom::blink::HdrMetadataSmpteSt2086Ptr& input) {
    return input->luminance_max;
  }

  static decltype(::gfx::mojom::blink::HdrMetadataSmpteSt2086::luminance_min) luminance_min(
      const ::gfx::mojom::blink::HdrMetadataSmpteSt2086Ptr& input) {
    return input->luminance_min;
  }

  static bool Read(::gfx::mojom::blink::HdrMetadataSmpteSt2086::DataView input, ::gfx::mojom::blink::HdrMetadataSmpteSt2086Ptr* output);
};


template <>
struct  StructTraits<::gfx::mojom::blink::HdrMetadataNdwl::DataView,
                                         ::gfx::mojom::blink::HdrMetadataNdwlPtr> {
  static bool IsNull(const ::gfx::mojom::blink::HdrMetadataNdwlPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::HdrMetadataNdwlPtr* output) { output->reset(); }

  static decltype(::gfx::mojom::blink::HdrMetadataNdwl::nits) nits(
      const ::gfx::mojom::blink::HdrMetadataNdwlPtr& input) {
    return input->nits;
  }

  static bool Read(::gfx::mojom::blink::HdrMetadataNdwl::DataView input, ::gfx::mojom::blink::HdrMetadataNdwlPtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::blink::HdrMetadataExtendedRange::DataView,
                                         ::gfx::mojom::blink::HdrMetadataExtendedRangePtr> {
  static bool IsNull(const ::gfx::mojom::blink::HdrMetadataExtendedRangePtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::HdrMetadataExtendedRangePtr* output) { output->reset(); }

  static decltype(::gfx::mojom::blink::HdrMetadataExtendedRange::current_headroom) current_headroom(
      const ::gfx::mojom::blink::HdrMetadataExtendedRangePtr& input) {
    return input->current_headroom;
  }

  static decltype(::gfx::mojom::blink::HdrMetadataExtendedRange::desired_headroom) desired_headroom(
      const ::gfx::mojom::blink::HdrMetadataExtendedRangePtr& input) {
    return input->desired_headroom;
  }

  static bool Read(::gfx::mojom::blink::HdrMetadataExtendedRange::DataView input, ::gfx::mojom::blink::HdrMetadataExtendedRangePtr* output);
};


template <>
struct  StructTraits<::gfx::mojom::blink::HDRMetadata::DataView,
                                         ::gfx::mojom::blink::HDRMetadataPtr> {
  static bool IsNull(const ::gfx::mojom::blink::HDRMetadataPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::HDRMetadataPtr* output) { output->reset(); }

  static const decltype(::gfx::mojom::blink::HDRMetadata::smpte_st_2086)& smpte_st_2086(
      const ::gfx::mojom::blink::HDRMetadataPtr& input) {
    return input->smpte_st_2086;
  }

  static const decltype(::gfx::mojom::blink::HDRMetadata::cta_861_3)& cta_861_3(
      const ::gfx::mojom::blink::HDRMetadataPtr& input) {
    return input->cta_861_3;
  }

  static const decltype(::gfx::mojom::blink::HDRMetadata::ndwl)& ndwl(
      const ::gfx::mojom::blink::HDRMetadataPtr& input) {
    return input->ndwl;
  }

  static const decltype(::gfx::mojom::blink::HDRMetadata::extended_range)& extended_range(
      const ::gfx::mojom::blink::HDRMetadataPtr& input) {
    return input->extended_range;
  }

  static bool Read(::gfx::mojom::blink::HDRMetadata::DataView input, ::gfx::mojom::blink::HDRMetadataPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_HDR_METADATA_MOJOM_BLINK_H_