/* BluetoothObexManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BluetoothObexManager.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "statusapplet.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	OBEX_MANAGER_0_PROPERTY,
	OBEX_MANAGER_NUM_PROPERTIES
};
static GParamSpec* obex_manager_properties[OBEX_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ObexManagerCreateManagerData ObexManagerCreateManagerData;
typedef struct _Block14Data Block14Data;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	OBEX_MANAGER_TRANSFER_ADDED_SIGNAL,
	OBEX_MANAGER_TRANSFER_REMOVED_SIGNAL,
	OBEX_MANAGER_TRANSFER_ACTIVE_SIGNAL,
	OBEX_MANAGER_NUM_SIGNALS
};
static guint obex_manager_signals[OBEX_MANAGER_NUM_SIGNALS] = {0};

struct _ObexManagerPrivate {
	GDBusObjectManager* object_manager;
	GHashTable* active_transfers;
};

struct _Block11Data {
	int _ref_count_;
	ObexManager* self;
	GDBusObject* obj;
};

struct _Block12Data {
	int _ref_count_;
	ObexManager* self;
	GDBusObject* obj;
};

struct _Block13Data {
	int _ref_count_;
	ObexManager* self;
	GDBusObject* obj;
};

struct _ObexManagerCreateManagerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ObexManager* self;
	GDBusObjectManagerClient* _tmp0_;
	GDBusObjectManagerClient* _tmp1_;
	GDBusObjectManagerClient* _tmp2_;
	GDBusObjectManager* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GDBusObjectManager* _tmp6_;
	GDBusObjectManager* _tmp7_;
	GDBusObjectManager* _tmp8_;
	GDBusObjectManager* _tmp9_;
	GError* e;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _Block14Data {
	int _ref_count_;
	ObexManager* self;
	Session* session;
};

static gint ObexManager_private_offset;
static gpointer obex_manager_parent_class = NULL;
static GType obex_manager_type_id = 0;

static void obex_manager_create_manager_data_free (gpointer _data);
static void obex_manager_create_manager (ObexManager* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void obex_manager_create_manager_finish (ObexManager* self,
                                         GAsyncResult* _res_);
static gboolean obex_manager_create_manager_co (ObexManagerCreateManagerData* _data_);
static GType obex_manager_object_manager_proxy_get_type (ObexManager* self,
                                                  GDBusObjectManagerClient* manager,
                                                  const gchar* object_path,
                                                  const gchar* interface_name);
static GType _obex_manager_object_manager_proxy_get_type_gd_bus_proxy_type_func (GDBusObjectManagerClient* manager,
                                                                          const gchar* object_path,
                                                                          const gchar* interface_name,
                                                                          gpointer self);
static void obex_manager_create_manager_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void ___lambda12_ (ObexManager* self,
                   GDBusObject* obj);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda13_ (Block11Data* _data11_,
                  GDBusInterface* iface);
static void obex_manager_interface_added (ObexManager* self,
                                   GDBusObject* obj,
                                   GDBusInterface* iface);
static void ___lambda13__gfunc (gconstpointer data,
                         gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ____lambda12__gfunc (gconstpointer data,
                          gpointer self);
static void _obex_manager_interface_added_g_dbus_object_manager_interface_added (GDBusObjectManager* _sender,
                                                                          GDBusObject* object,
                                                                          GDBusInterface* interface_,
                                                                          gpointer self);
static void obex_manager_interface_removed (ObexManager* self,
                                     GDBusObject* obj,
                                     GDBusInterface* iface);
static void _obex_manager_interface_removed_g_dbus_object_manager_interface_removed (GDBusObjectManager* _sender,
                                                                              GDBusObject* object,
                                                                              GDBusInterface* interface_,
                                                                              gpointer self);
static void ___lambda15_ (ObexManager* self,
                   GDBusObject* obj);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda16_ (Block12Data* _data12_,
                  GDBusInterface* iface);
static void ___lambda16__gfunc (gconstpointer data,
                         gpointer self);
static void ____lambda15__g_dbus_object_manager_object_added (GDBusObjectManager* _sender,
                                                       GDBusObject* object,
                                                       gpointer self);
static void ___lambda17_ (ObexManager* self,
                   GDBusObject* obj);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void __lambda18_ (Block13Data* _data13_,
                  GDBusInterface* iface);
static void ___lambda18__gfunc (gconstpointer data,
                         gpointer self);
static void ____lambda17__g_dbus_object_manager_object_removed (GDBusObjectManager* _sender,
                                                         GDBusObject* object,
                                                         gpointer self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void ___lambda14_ (Block14Data* _data14_,
                   GVariant* changed,
                   gchar** invalid);
static void ____lambda14__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                      GVariant* changed_properties,
                                                      gchar** invalidated_properties,
                                                      gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * obex_manager_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void obex_manager_finalize (GObject * obj);

static inline gpointer
obex_manager_get_instance_private (ObexManager* self)
{
	return G_STRUCT_MEMBER_P (self, ObexManager_private_offset);
}

static void
obex_manager_create_manager_data_free (gpointer _data)
{
	ObexManagerCreateManagerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ObexManagerCreateManagerData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
obex_manager_create_manager (ObexManager* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	ObexManagerCreateManagerData* _data_;
	ObexManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ObexManagerCreateManagerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, obex_manager_create_manager_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	obex_manager_create_manager_co (_data_);
}

static void
obex_manager_create_manager_finish (ObexManager* self,
                                    GAsyncResult* _res_)
{
	ObexManagerCreateManagerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
 * Creates our Obex DBus object manager and connects to its signals.
 */
static GType
_obex_manager_object_manager_proxy_get_type_gd_bus_proxy_type_func (GDBusObjectManagerClient* manager,
                                                                    const gchar* object_path,
                                                                    const gchar* interface_name,
                                                                    gpointer self)
{
	GType result;
	result = obex_manager_object_manager_proxy_get_type ((ObexManager*) self, manager, object_path, interface_name);
	return result;
}

static void
obex_manager_create_manager_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	ObexManagerCreateManagerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	obex_manager_create_manager_co (_data_);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		ObexManager* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->obj);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda13_ (Block11Data* _data11_,
             GDBusInterface* iface)
{
	ObexManager* self;
	self = _data11_->self;
	g_return_if_fail (iface != NULL);
	obex_manager_interface_added (self, _data11_->obj, iface);
}

static void
___lambda13__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda13_ (self, (GDBusInterface*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
___lambda12_ (ObexManager* self,
              GDBusObject* obj)
{
	Block11Data* _data11_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (obj != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (obj);
	_g_object_unref0 (_data11_->obj);
	_data11_->obj = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data11_->obj);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda13__gfunc, _data11_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static void
____lambda12__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda12_ ((ObexManager*) self, (GDBusObject*) data);
}

static void
_obex_manager_interface_added_g_dbus_object_manager_interface_added (GDBusObjectManager* _sender,
                                                                     GDBusObject* object,
                                                                     GDBusInterface* interface_,
                                                                     gpointer self)
{
	obex_manager_interface_added ((ObexManager*) self, object, interface_);
}

static void
_obex_manager_interface_removed_g_dbus_object_manager_interface_removed (GDBusObjectManager* _sender,
                                                                         GDBusObject* object,
                                                                         GDBusInterface* interface_,
                                                                         gpointer self)
{
	obex_manager_interface_removed ((ObexManager*) self, object, interface_);
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		ObexManager* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->obj);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
__lambda16_ (Block12Data* _data12_,
             GDBusInterface* iface)
{
	ObexManager* self;
	self = _data12_->self;
	g_return_if_fail (iface != NULL);
	obex_manager_interface_added (self, _data12_->obj, iface);
}

static void
___lambda16__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda16_ (self, (GDBusInterface*) data);
}

static void
___lambda15_ (ObexManager* self,
              GDBusObject* obj)
{
	Block12Data* _data12_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (obj != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (obj);
	_g_object_unref0 (_data12_->obj);
	_data12_->obj = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data12_->obj);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda16__gfunc, _data12_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

static void
____lambda15__g_dbus_object_manager_object_added (GDBusObjectManager* _sender,
                                                  GDBusObject* object,
                                                  gpointer self)
{
	___lambda15_ ((ObexManager*) self, object);
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		ObexManager* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->obj);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
__lambda18_ (Block13Data* _data13_,
             GDBusInterface* iface)
{
	ObexManager* self;
	self = _data13_->self;
	g_return_if_fail (iface != NULL);
	obex_manager_interface_removed (self, _data13_->obj, iface);
}

static void
___lambda18__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda18_ (self, (GDBusInterface*) data);
}

static void
___lambda17_ (ObexManager* self,
              GDBusObject* obj)
{
	Block13Data* _data13_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (obj != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (obj);
	_g_object_unref0 (_data13_->obj);
	_data13_->obj = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data13_->obj);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda18__gfunc, _data13_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static void
____lambda17__g_dbus_object_manager_object_removed (GDBusObjectManager* _sender,
                                                    GDBusObject* object,
                                                    gpointer self)
{
	___lambda17_ ((ObexManager*) self, object);
}

static gboolean
obex_manager_create_manager_co (ObexManagerCreateManagerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_dbus_object_manager_client_new_for_bus (G_BUS_TYPE_SESSION, G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_NONE, "org.bluez.obex", "/", _obex_manager_object_manager_proxy_get_type_gd_bus_proxy_type_func, g_object_ref (_data_->self), g_object_unref, NULL, obex_manager_create_manager_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_dbus_object_manager_client_new_for_bus_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->object_manager);
		_data_->self->priv->object_manager = (GDBusObjectManager*) _data_->_tmp2_;
		_data_->_tmp3_ = _data_->self->priv->object_manager;
		_data_->_tmp4_ = g_dbus_object_manager_get_objects (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		g_list_foreach (_data_->_tmp5_, ____lambda12__gfunc, _data_->self);
		(_data_->_tmp5_ == NULL) ? NULL : (_data_->_tmp5_ = (_g_list_free__g_object_unref0_ (_data_->_tmp5_), NULL));
		_data_->_tmp6_ = _data_->self->priv->object_manager;
		g_signal_connect_object (_data_->_tmp6_, "interface-added", (GCallback) _obex_manager_interface_added_g_dbus_object_manager_interface_added, _data_->self, 0);
		_data_->_tmp7_ = _data_->self->priv->object_manager;
		g_signal_connect_object (_data_->_tmp7_, "interface-removed", (GCallback) _obex_manager_interface_removed_g_dbus_object_manager_interface_removed, _data_->self, 0);
		_data_->_tmp8_ = _data_->self->priv->object_manager;
		g_signal_connect_object (_data_->_tmp8_, "object-added", (GCallback) ____lambda15__g_dbus_object_manager_object_added, _data_->self, 0);
		_data_->_tmp9_ = _data_->self->priv->object_manager;
		g_signal_connect_object (_data_->_tmp9_, "object-removed", (GCallback) ____lambda17__g_dbus_object_manager_object_removed, _data_->self, 0);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->e;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_critical ("BluetoothObexManager.vala:58: Error getting DBus object manager for Ob" \
"ex: %s", _data_->_tmp11_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
 * Get the type for our object manager interfaces.
 */
static GType
obex_manager_object_manager_proxy_get_type (ObexManager* self,
                                            GDBusObjectManagerClient* manager,
                                            const gchar* object_path,
                                            const gchar* interface_name)
{
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	g_return_val_if_fail (manager != NULL, 0UL);
	g_return_val_if_fail (object_path != NULL, 0UL);
	if (interface_name == NULL) {
		result = g_dbus_object_proxy_get_type ();
		return result;
	}
	if (g_strcmp0 (interface_name, "org.bluez.obex.Transfer1") == 0) {
		result = transfer_proxy_get_type ();
		return result;
	}
	result = g_dbus_proxy_get_type ();
	return result;
}

/**
 * Handles when an interface has been added.
 */
static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		ObexManager* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->session);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
___lambda14_ (Block14Data* _data14_,
              GVariant* changed,
              gchar** invalid)
{
	ObexManager* self;
	Session* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = _data14_->self;
	g_return_if_fail (changed != NULL);
	_tmp0_ = _data14_->session;
	_tmp1_ = session_get_destination (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	g_signal_emit (self, obex_manager_signals[OBEX_MANAGER_TRANSFER_ACTIVE_SIGNAL], 0, _tmp3_);
	_g_free0 (_tmp3_);
}

static void
____lambda14__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                 GVariant* changed_properties,
                                                 gchar** invalidated_properties,
                                                 gpointer self)
{
	___lambda14_ (self, changed_properties, invalidated_properties);
}

static void
obex_manager_interface_added (ObexManager* self,
                              GDBusObject* obj,
                              GDBusInterface* iface)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (iface != NULL);
	if (IS_TRANSFER (iface)) {
		Block14Data* _data14_;
		Transfer* transfer = NULL;
		Session* _tmp10_;
		GHashTable* _tmp11_;
		Transfer* _tmp12_;
		Transfer* _tmp13_;
		Session* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		Transfer* _tmp17_;
		Session* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		Transfer* _tmp22_;
		_data14_ = g_slice_new0 (Block14Data);
		_data14_->_ref_count_ = 1;
		_data14_->self = g_object_ref (self);
		transfer = IS_TRANSFER (iface) ? ((Transfer*) iface) : NULL;
		_data14_->session = NULL;
		{
			Session* _tmp0_ = NULL;
			Transfer* _tmp1_;
			char* _tmp2_;
			char* _tmp3_;
			char* _tmp4_;
			Session* _tmp5_;
			Session* _tmp6_;
			Session* _tmp7_;
			_tmp1_ = transfer;
			_tmp2_ = transfer_get_session (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = _tmp3_;
			_tmp5_ = (Session*) g_initable_new (TYPE_SESSION_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", (const gchar*) _tmp4_, "g-interface-name", "org.bluez.obex.Session1", NULL);
			_tmp6_ = (Session*) _tmp5_;
			_g_free0 (_tmp4_);
			_tmp0_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (_data14_->session);
			_data14_->session = _tmp7_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_critical ("BluetoothObexManager.vala:91: Error getting Obex session proxy: %s", _tmp9_);
			_g_error_free0 (e);
			block14_data_unref (_data14_);
			_data14_ = NULL;
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block14_data_unref (_data14_);
			_data14_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp10_ = _data14_->session;
		if (_tmp10_ == NULL) {
			g_critical ("BluetoothObexManager.vala:97: Bluetooth Obex session is null after pro" \
"xy creation");
			block14_data_unref (_data14_);
			_data14_ = NULL;
			return;
		}
		_tmp11_ = self->priv->active_transfers;
		_tmp12_ = transfer;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_tmp14_ = _data14_->session;
		_tmp15_ = session_get_destination (_tmp14_);
		_tmp16_ = _tmp15_;
		g_hash_table_insert (_tmp11_, _tmp13_, _tmp16_);
		_tmp17_ = transfer;
		g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) ____lambda14__g_dbus_proxy_g_properties_changed, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
		_tmp18_ = _data14_->session;
		_tmp19_ = session_get_destination (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = transfer;
		g_signal_emit (self, obex_manager_signals[OBEX_MANAGER_TRANSFER_ADDED_SIGNAL], 0, _tmp21_, _tmp22_);
		_g_free0 (_tmp21_);
		block14_data_unref (_data14_);
		_data14_ = NULL;
	}
}

/**
 * Handles when an interface has been removed.
 */
static void
obex_manager_interface_removed (ObexManager* self,
                                GDBusObject* obj,
                                GDBusInterface* iface)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (iface != NULL);
	if (IS_TRANSFER (iface)) {
		Transfer* transfer = NULL;
		GHashTable* _tmp0_;
		Transfer* _tmp1_;
		Transfer* _tmp4_;
		transfer = G_TYPE_CHECK_INSTANCE_CAST (iface, TYPE_TRANSFER, Transfer);
		_tmp0_ = self->priv->active_transfers;
		_tmp1_ = transfer;
		if (g_hash_table_contains (_tmp0_, _tmp1_)) {
			GHashTable* _tmp2_;
			Transfer* _tmp3_;
			_tmp2_ = self->priv->active_transfers;
			_tmp3_ = transfer;
			g_hash_table_remove (_tmp2_, _tmp3_);
		}
		_tmp4_ = transfer;
		g_signal_emit (self, obex_manager_signals[OBEX_MANAGER_TRANSFER_REMOVED_SIGNAL], 0, _tmp4_);
	}
}

ObexManager*
obex_manager_construct (GType object_type)
{
	ObexManager * self = NULL;
	self = (ObexManager*) g_object_new (object_type, NULL);
	return self;
}

ObexManager*
obex_manager_new (void)
{
	return obex_manager_construct (TYPE_OBEX_MANAGER);
}

static void
g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GObject *
obex_manager_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ObexManager * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	parent_class = G_OBJECT_CLASS (obex_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OBEX_MANAGER, ObexManager);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->active_transfers);
	self->priv->active_transfers = _tmp2_;
	obex_manager_create_manager (self, NULL, NULL);
	return obj;
}

static void
obex_manager_class_init (ObexManagerClass * klass,
                         gpointer klass_data)
{
	obex_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ObexManager_private_offset);
	G_OBJECT_CLASS (klass)->constructor = obex_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = obex_manager_finalize;
	obex_manager_signals[OBEX_MANAGER_TRANSFER_ADDED_SIGNAL] = g_signal_new ("transfer-added", TYPE_OBEX_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_TRANSFER);
	obex_manager_signals[OBEX_MANAGER_TRANSFER_REMOVED_SIGNAL] = g_signal_new ("transfer-removed", TYPE_OBEX_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_TRANSFER);
	obex_manager_signals[OBEX_MANAGER_TRANSFER_ACTIVE_SIGNAL] = g_signal_new ("transfer-active", TYPE_OBEX_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
obex_manager_instance_init (ObexManager * self,
                            gpointer klass)
{
	self->priv = obex_manager_get_instance_private (self);
}

static void
obex_manager_finalize (GObject * obj)
{
	ObexManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OBEX_MANAGER, ObexManager);
	_g_object_unref0 (self->priv->object_manager);
	_g_hash_table_unref0 (self->priv->active_transfers);
	G_OBJECT_CLASS (obex_manager_parent_class)->finalize (obj);
}

GType
obex_manager_get_type (void)
{
	return obex_manager_type_id;
}

GType
obex_manager_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ObexManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) obex_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ObexManager), 0, (GInstanceInitFunc) obex_manager_instance_init, NULL };
	obex_manager_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ObexManager", &g_define_type_info, 0);
	ObexManager_private_offset = sizeof (ObexManagerPrivate);
	return obex_manager_type_id;
}

