/* application-attachment-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application-attachment-manager.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */
/*
 * Manages downloading and saving email attachment parts.
 */

#include "geary-client-46.0.h"
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	APPLICATION_ATTACHMENT_MANAGER_0_PROPERTY,
	APPLICATION_ATTACHMENT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* application_attachment_manager_properties[APPLICATION_ATTACHMENT_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ApplicationAttachmentManagerSaveAttachmentsData ApplicationAttachmentManagerSaveAttachmentsData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ApplicationAttachmentManagerSaveAttachmentData ApplicationAttachmentManagerSaveAttachmentData;
typedef struct _ApplicationAttachmentManagerSaveBufferData ApplicationAttachmentManagerSaveBufferData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ApplicationAttachmentManagerSaveAllData ApplicationAttachmentManagerSaveAllData;
typedef struct _Block1Data Block1Data;
typedef struct _ApplicationAttachmentManagerOpenBufferData ApplicationAttachmentManagerOpenBufferData;
typedef struct _ApplicationAttachmentManagerCheckAndWriteData ApplicationAttachmentManagerCheckAndWriteData;

#define TYPE_ALERT_DIALOG (alert_dialog_get_type ())
#define ALERT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALERT_DIALOG, AlertDialog))
#define ALERT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALERT_DIALOG, AlertDialogClass))
#define IS_ALERT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALERT_DIALOG))
#define IS_ALERT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALERT_DIALOG))
#define ALERT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALERT_DIALOG, AlertDialogClass))

typedef struct _AlertDialog AlertDialog;
typedef struct _AlertDialogClass AlertDialogClass;

#define TYPE_CONFIRMATION_DIALOG (confirmation_dialog_get_type ())
#define CONFIRMATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIRMATION_DIALOG, ConfirmationDialog))
#define CONFIRMATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIRMATION_DIALOG, ConfirmationDialogClass))
#define IS_CONFIRMATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIRMATION_DIALOG))
#define IS_CONFIRMATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIRMATION_DIALOG))
#define CONFIRMATION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIRMATION_DIALOG, ConfirmationDialogClass))

typedef struct _ConfirmationDialog ConfirmationDialog;
typedef struct _ConfirmationDialogClass ConfirmationDialogClass;
typedef struct _ApplicationAttachmentManagerCheckOverwriteData ApplicationAttachmentManagerCheckOverwriteData;
typedef struct _ApplicationAttachmentManagerWriteBufferToFileData ApplicationAttachmentManagerWriteBufferToFileData;

#define APPLICATION_TYPE_CONTROLLER (application_controller_get_type ())
#define APPLICATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_CONTROLLER, ApplicationController))
#define APPLICATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_CONTROLLER, ApplicationControllerClass))
#define APPLICATION_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_CONTROLLER))
#define APPLICATION_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_CONTROLLER))
#define APPLICATION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_CONTROLLER, ApplicationControllerClass))

typedef struct _ApplicationController ApplicationController;
typedef struct _ApplicationControllerClass ApplicationControllerClass;

#define COMPOSER_TYPE_APPLICATION_INTERFACE (composer_application_interface_get_type ())
#define COMPOSER_APPLICATION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterface))
#define COMPOSER_IS_APPLICATION_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COMPOSER_TYPE_APPLICATION_INTERFACE))
#define COMPOSER_APPLICATION_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterfaceIface))

typedef struct _ComposerApplicationInterface ComposerApplicationInterface;
typedef struct _ComposerApplicationInterfaceIface ComposerApplicationInterfaceIface;

#define APPLICATION_TYPE_ACCOUNT_INTERFACE (application_account_interface_get_type ())
#define APPLICATION_ACCOUNT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterface))
#define APPLICATION_IS_ACCOUNT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE))
#define APPLICATION_ACCOUNT_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), APPLICATION_TYPE_ACCOUNT_INTERFACE, ApplicationAccountInterfaceIface))

typedef struct _ApplicationAccountInterface ApplicationAccountInterface;
typedef struct _ApplicationAccountInterfaceIface ApplicationAccountInterfaceIface;

struct _ApplicationAttachmentManagerPrivate {
	ApplicationMainWindow* parent;
};

struct _ApplicationAttachmentManagerSaveAttachmentsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationAttachmentManager* self;
	GeeCollection* attachments;
	GCancellable* cancellable;
	gboolean result;
	gint _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_;
	GearyAttachment* _tmp3_;
	gboolean _tmp4_;
};

struct _ApplicationAttachmentManagerSaveAttachmentData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationAttachmentManager* self;
	GearyAttachment* attachment;
	gchar* alt_name;
	GCancellable* cancellable;
	gboolean result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* alt_display_name;
	gchar* _tmp2_;
	gchar* display_name;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GearyMemoryBuffer* content;
	GearyMemoryBuffer* _tmp5_;
	gboolean succeeded;
	GearyMemoryBuffer* _tmp6_;
	const gchar* _tmp7_;
	GearyMemoryBuffer* _tmp8_;
};

struct _ApplicationAttachmentManagerSaveBufferData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationAttachmentManager* self;
	gchar* display_name;
	GearyMemoryBuffer* buffer;
	GCancellable* cancellable;
	gboolean result;
	GtkFileChooserNative* dialog;
	GtkFileChooserNative* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	gchar* destination_uri;
	GtkFileChooserNative* _tmp2_;
	GtkFileChooserNative* _tmp3_;
	gchar* _tmp4_;
	GtkFileChooserNative* _tmp5_;
	gboolean succeeded;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
};

struct _ApplicationAttachmentManagerSaveAllData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationAttachmentManager* self;
	GeeCollection* attachments;
	GCancellable* cancellable;
	gboolean result;
	GtkFileChooserNative* dialog;
	GtkFileChooserNative* _tmp0_;
	gchar* destination_uri;
	GtkFileChooserNative* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	gchar* _tmp3_;
	GtkFileChooserNative* _tmp4_;
	gboolean succeeded;
	const gchar* _tmp5_;
	GFile* destination_dir;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GeeIterator* _attachment_it;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	GearyAttachment* attachment;
	GeeIterator* _tmp10_;
	gpointer _tmp11_;
	GFile* destination;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GearyAttachment* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	GError* err;
	GearyAttachment* _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GError* _tmp28_;
	GearyMemoryBuffer* content;
	GearyAttachment* _tmp29_;
	GearyMemoryBuffer* _tmp30_;
	gboolean _tmp31_;
	GearyMemoryBuffer* _tmp32_;
	GFile* _tmp33_;
	GearyMemoryBuffer* _tmp34_;
	GFile* _tmp35_;
	GError* _inner_error0_;
};

struct _Block1Data {
	int _ref_count_;
	ApplicationAttachmentManager* self;
	GearyMemoryFileBuffer* content;
	GearyAttachment* attachment;
	gpointer _async_data_;
};

struct _ApplicationAttachmentManagerOpenBufferData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationAttachmentManager* self;
	GearyAttachment* attachment;
	GCancellable* cancellable;
	GearyMemoryBuffer* result;
	Block1Data* _data1_;
	GearyNonblockingConcurrent* _tmp0_;
	GearyNonblockingConcurrent* _tmp1_;
	GError* err;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GearyMemoryBuffer* _tmp9_;
	GError* _inner_error0_;
};

struct _ApplicationAttachmentManagerCheckAndWriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationAttachmentManager* self;
	GearyMemoryBuffer* content;
	GFile* destination;
	GCancellable* cancellable;
	gboolean result;
	gboolean succeeded;
	gboolean _tmp0_;
	GError* err;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	GError* _inner_error0_;
};

struct _ApplicationAttachmentManagerCheckOverwriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationAttachmentManager* self;
	GFile* to_overwrite;
	GCancellable* cancellable;
	gboolean result;
	gchar* target_name;
	gchar* _tmp0_;
	gchar* parent_name;
	gchar* _tmp1_;
	GFileInfo* file_info;
	GFileInfo* _tmp2_;
	GFileInfo* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GFileInfo* parent_info;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFileInfo* _tmp8_;
	GFileInfo* _tmp9_;
	GFileInfo* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* primary;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* secondary;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	ConfirmationDialog* dialog;
	ApplicationMainWindow* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	ConfirmationDialog* _tmp20_;
	ConfirmationDialog* _tmp21_;
	GError* _inner_error0_;
};

struct _ApplicationAttachmentManagerWriteBufferToFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationAttachmentManager* self;
	GearyMemoryBuffer* buffer;
	GFile* destination;
	GCancellable* cancellable;
	GFileOutputStream* outs;
	GFileOutputStream* _tmp0_;
	GFileOutputStream* _tmp1_;
	GInputStream* _tmp2_;
	GInputStream* _tmp3_;
	GError* err;
	GError* _tmp4_;
	GError* _tmp5_;
	GError* _inner_error0_;
};

struct _ApplicationAccountInterfaceIface {
	GTypeInterface parent_iface;
	ApplicationAccountContext* (*get_context_for_account) (ApplicationAccountInterface* self, GearyAccountInformation* account);
	GeeCollection* (*get_account_contexts) (ApplicationAccountInterface* self);
};

struct _ComposerApplicationInterfaceIface {
	GTypeInterface parent_iface;
	void (*report_problem) (ComposerApplicationInterface* self, GearyProblemReport* report);
	void (*send_composed_email) (ComposerApplicationInterface* self, ComposerWidget* composer, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*send_composed_email_finish) (ComposerApplicationInterface* self, GAsyncResult* _res_);
	void (*save_composed_email) (ComposerApplicationInterface* self, ComposerWidget* composer, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*save_composed_email_finish) (ComposerApplicationInterface* self, GAsyncResult* _res_);
	void (*discard_composed_email) (ComposerApplicationInterface* self, ComposerWidget* composer, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*discard_composed_email_finish) (ComposerApplicationInterface* self, GAsyncResult* _res_);
};

static gint ApplicationAttachmentManager_private_offset;
static gpointer application_attachment_manager_parent_class = NULL;
gchar* application_attachment_manager_untitled_file_name = NULL;

static void application_attachment_manager_save_attachments_data_free (gpointer _data);
static gboolean application_attachment_manager_save_attachments_co (ApplicationAttachmentManagerSaveAttachmentsData* _data_);
static void application_attachment_manager_save_attachments_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void application_attachment_manager_save_all (ApplicationAttachmentManager* self,
                                              GeeCollection* attachments,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean application_attachment_manager_save_all_finish (ApplicationAttachmentManager* self,
                                                         GAsyncResult* _res_);
static void application_attachment_manager_save_attachment_data_free (gpointer _data);
static gboolean application_attachment_manager_save_attachment_co (ApplicationAttachmentManagerSaveAttachmentData* _data_);
static void application_attachment_manager_save_attachment_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void application_attachment_manager_open_buffer (ApplicationAttachmentManager* self,
                                                 GearyAttachment* attachment,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static GearyMemoryBuffer* application_attachment_manager_open_buffer_finish (ApplicationAttachmentManager* self,
                                                                      GAsyncResult* _res_);
static void application_attachment_manager_save_buffer_data_free (gpointer _data);
static gboolean application_attachment_manager_save_buffer_co (ApplicationAttachmentManagerSaveBufferData* _data_);
static inline GtkFileChooserNative* application_attachment_manager_new_save_chooser (ApplicationAttachmentManager* self,
                                                                       GtkFileChooserAction action);
static void application_attachment_manager_check_and_write (ApplicationAttachmentManager* self,
                                                     GearyMemoryBuffer* content,
                                                     GFile* destination,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean application_attachment_manager_check_and_write_finish (ApplicationAttachmentManager* self,
                                                                GAsyncResult* _res_);
static void application_attachment_manager_save_buffer_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void application_attachment_manager_save_all_data_free (gpointer _data);
static gboolean application_attachment_manager_save_all_co (ApplicationAttachmentManagerSaveAllData* _data_);
static void application_attachment_manager_save_all_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static inline void application_attachment_manager_handle_error (ApplicationAttachmentManager* self,
                                                  GError* _error_);
static void application_attachment_manager_open_buffer_data_free (gpointer _data);
static gboolean application_attachment_manager_open_buffer_co (ApplicationAttachmentManagerOpenBufferData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda101_ (Block1Data* _data1_,
                    GError** error);
static void ____lambda101__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                                      gpointer self,
                                                                      GError** error);
static void application_attachment_manager_open_buffer_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void application_attachment_manager_check_and_write_data_free (gpointer _data);
static gboolean application_attachment_manager_check_and_write_co (ApplicationAttachmentManagerCheckAndWriteData* _data_);
static void application_attachment_manager_check_overwrite (ApplicationAttachmentManager* self,
                                                     GFile* to_overwrite,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean application_attachment_manager_check_overwrite_finish (ApplicationAttachmentManager* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
static void application_attachment_manager_check_and_write_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void application_attachment_manager_write_buffer_to_file (ApplicationAttachmentManager* self,
                                                          GearyMemoryBuffer* buffer,
                                                          GFile* destination,
                                                          GCancellable* cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static void application_attachment_manager_write_buffer_to_file_finish (ApplicationAttachmentManager* self,
                                                                 GAsyncResult* _res_,
                                                                 GError** error);
static void application_attachment_manager_check_overwrite_data_free (gpointer _data);
static gboolean application_attachment_manager_check_overwrite_co (ApplicationAttachmentManagerCheckOverwriteData* _data_);
static void application_attachment_manager_check_overwrite_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
VALA_EXTERN GType alert_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType confirmation_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ConfirmationDialog* confirmation_dialog_new (GtkWindow* parent,
                                             const gchar* title,
                                             const gchar* description,
                                             const gchar* ok_button,
                                             const gchar* ok_action_type);
VALA_EXTERN ConfirmationDialog* confirmation_dialog_construct (GType object_type,
                                                   GtkWindow* parent,
                                                   const gchar* title,
                                                   const gchar* description,
                                                   const gchar* ok_button,
                                                   const gchar* ok_action_type);
VALA_EXTERN GtkResponseType alert_dialog_run (AlertDialog* self);
static void application_attachment_manager_write_buffer_to_file_data_free (gpointer _data);
static gboolean application_attachment_manager_write_buffer_to_file_co (ApplicationAttachmentManagerWriteBufferToFileData* _data_);
static void application_attachment_manager_write_buffer_to_file_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
VALA_EXTERN GType application_controller_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ApplicationController* application_client_get_controller (ApplicationClient* self);
VALA_EXTERN GType application_account_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType composer_application_interface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void composer_application_interface_report_problem (ComposerApplicationInterface* self,
                                                    GearyProblemReport* report);
static void application_attachment_manager_finalize (GObject * obj);
static GType application_attachment_manager_get_type_once (void);

static inline gpointer
application_attachment_manager_get_instance_private (ApplicationAttachmentManager* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationAttachmentManager_private_offset);
}

ApplicationAttachmentManager*
application_attachment_manager_construct (GType object_type,
                                          ApplicationMainWindow* parent)
{
	ApplicationAttachmentManager * self = NULL;
	g_return_val_if_fail (APPLICATION_IS_MAIN_WINDOW (parent), NULL);
	self = (ApplicationAttachmentManager*) g_object_new (object_type, NULL);
	self->priv->parent = parent;
	return self;
}

ApplicationAttachmentManager*
application_attachment_manager_new (ApplicationMainWindow* parent)
{
	return application_attachment_manager_construct (APPLICATION_TYPE_ATTACHMENT_MANAGER, parent);
}

static void
application_attachment_manager_save_attachments_data_free (gpointer _data)
{
	ApplicationAttachmentManagerSaveAttachmentsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->attachments);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationAttachmentManagerSaveAttachmentsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
application_attachment_manager_save_attachments (ApplicationAttachmentManager* self,
                                                 GeeCollection* attachments,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	ApplicationAttachmentManagerSaveAttachmentsData* _data_;
	ApplicationAttachmentManager* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (APPLICATION_IS_ATTACHMENT_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationAttachmentManagerSaveAttachmentsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_attachment_manager_save_attachments_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (attachments);
	_g_object_unref0 (_data_->attachments);
	_data_->attachments = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_attachment_manager_save_attachments_co (_data_);
}

gboolean
application_attachment_manager_save_attachments_finish (ApplicationAttachmentManager* self,
                                                        GAsyncResult* _res_)
{
	gboolean result;
	ApplicationAttachmentManagerSaveAttachmentsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
     * Saves multiple attachments to disk, prompting for destination.
     *
     * Prompt for both a location and for confirmation before
     * overwriting existing files. Files are written with their
     * existing names. Returns true if written to disk, else false.
     */
static void
application_attachment_manager_save_attachments_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	ApplicationAttachmentManagerSaveAttachmentsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_attachment_manager_save_attachments_co (_data_);
}

static gboolean
application_attachment_manager_save_attachments_co (ApplicationAttachmentManagerSaveAttachmentsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_collection_get_size (_data_->attachments);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (_data_->_tmp1_ == 1) {
		_data_->_tmp2_ = geary_collection_first (GEARY_TYPE_ATTACHMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->attachments);
		_data_->_tmp3_ = (GearyAttachment*) _data_->_tmp2_;
		_data_->_state_ = 1;
		application_attachment_manager_save_attachment (_data_->self, _data_->_tmp3_, NULL, _data_->cancellable, application_attachment_manager_save_attachments_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = application_attachment_manager_save_attachment_finish (_data_->self, _data_->_res_);
		_g_object_unref0 (_data_->_tmp3_);
		_data_->result = _data_->_tmp4_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_state_ = 2;
		application_attachment_manager_save_all (_data_->self, _data_->attachments, _data_->cancellable, application_attachment_manager_save_attachments_ready, _data_);
		return FALSE;
		_state_2:
		_data_->result = application_attachment_manager_save_all_finish (_data_->self, _data_->_res_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
application_attachment_manager_save_attachment_data_free (gpointer _data)
{
	ApplicationAttachmentManagerSaveAttachmentData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->attachment);
	_g_free0 (_data_->alt_name);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationAttachmentManagerSaveAttachmentData, _data_);
}

void
application_attachment_manager_save_attachment (ApplicationAttachmentManager* self,
                                                GearyAttachment* attachment,
                                                const gchar* alt_name,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	ApplicationAttachmentManagerSaveAttachmentData* _data_;
	ApplicationAttachmentManager* _tmp0_;
	GearyAttachment* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (APPLICATION_IS_ATTACHMENT_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachment, GEARY_TYPE_ATTACHMENT));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationAttachmentManagerSaveAttachmentData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_attachment_manager_save_attachment_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (attachment);
	_g_object_unref0 (_data_->attachment);
	_data_->attachment = _tmp1_;
	_tmp2_ = g_strdup (alt_name);
	_g_free0 (_data_->alt_name);
	_data_->alt_name = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	application_attachment_manager_save_attachment_co (_data_);
}

gboolean
application_attachment_manager_save_attachment_finish (ApplicationAttachmentManager* self,
                                                       GAsyncResult* _res_)
{
	gboolean result;
	ApplicationAttachmentManagerSaveAttachmentData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
     * Saves single attachment to disk, prompting for name and destination.
     *
     * Prompt for both a name and location and for confirmation before
     * overwriting existing files. Returns true if written to disk,
     * else false.
     */
static void
application_attachment_manager_save_attachment_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	ApplicationAttachmentManagerSaveAttachmentData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_attachment_manager_save_attachment_co (_data_);
}

static gboolean
application_attachment_manager_save_attachment_co (ApplicationAttachmentManagerSaveAttachmentData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (geary_string_is_empty_or_whitespace (_data_->alt_name)) {
		_data_->_tmp1_ = application_attachment_manager_untitled_file_name;
		_data_->_tmp0_ = _data_->_tmp1_;
	} else {
		_data_->_tmp0_ = _data_->alt_name;
	}
	_data_->_tmp2_ = g_strdup (_data_->_tmp0_);
	_data_->alt_display_name = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->alt_display_name;
	_data_->_state_ = 1;
	geary_attachment_get_safe_file_name (_data_->attachment, _data_->_tmp3_, application_attachment_manager_save_attachment_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = geary_attachment_get_safe_file_name_finish (_data_->attachment, _data_->_res_);
	_data_->display_name = _data_->_tmp4_;
	_data_->_state_ = 2;
	application_attachment_manager_open_buffer (_data_->self, _data_->attachment, _data_->cancellable, application_attachment_manager_save_attachment_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp5_ = application_attachment_manager_open_buffer_finish (_data_->self, _data_->_res_);
	_data_->content = _data_->_tmp5_;
	_data_->succeeded = FALSE;
	_data_->_tmp6_ = _data_->content;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->display_name;
		_data_->_tmp8_ = _data_->content;
		_data_->_state_ = 3;
		application_attachment_manager_save_buffer (_data_->self, _data_->_tmp7_, _data_->_tmp8_, _data_->cancellable, application_attachment_manager_save_attachment_ready, _data_);
		return FALSE;
		_state_3:
		_data_->succeeded = application_attachment_manager_save_buffer_finish (_data_->self, _data_->_res_);
	}
	_data_->result = _data_->succeeded;
	_g_object_unref0 (_data_->content);
	_g_free0 (_data_->display_name);
	_g_free0 (_data_->alt_display_name);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_attachment_manager_save_buffer_data_free (gpointer _data)
{
	ApplicationAttachmentManagerSaveBufferData* _data_;
	_data_ = _data;
	_g_free0 (_data_->display_name);
	_g_object_unref0 (_data_->buffer);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationAttachmentManagerSaveBufferData, _data_);
}

void
application_attachment_manager_save_buffer (ApplicationAttachmentManager* self,
                                            const gchar* display_name,
                                            GearyMemoryBuffer* buffer,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	ApplicationAttachmentManagerSaveBufferData* _data_;
	ApplicationAttachmentManager* _tmp0_;
	gchar* _tmp1_;
	GearyMemoryBuffer* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (APPLICATION_IS_ATTACHMENT_MANAGER (self));
	g_return_if_fail (display_name != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (buffer, GEARY_MEMORY_TYPE_BUFFER));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationAttachmentManagerSaveBufferData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_attachment_manager_save_buffer_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (display_name);
	_g_free0 (_data_->display_name);
	_data_->display_name = _tmp1_;
	_tmp2_ = _g_object_ref0 (buffer);
	_g_object_unref0 (_data_->buffer);
	_data_->buffer = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	application_attachment_manager_save_buffer_co (_data_);
}

gboolean
application_attachment_manager_save_buffer_finish (ApplicationAttachmentManager* self,
                                                   GAsyncResult* _res_)
{
	gboolean result;
	ApplicationAttachmentManagerSaveBufferData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
     * Saves a buffer to disk as if it was an attachment.
     *
     * Prompt for both a name and location and for confirmation before
     * overwriting existing files. Returns true if written to disk,
     * else false.
     */
static void
application_attachment_manager_save_buffer_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	ApplicationAttachmentManagerSaveBufferData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_attachment_manager_save_buffer_co (_data_);
}

static gboolean
application_attachment_manager_save_buffer_co (ApplicationAttachmentManagerSaveBufferData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = application_attachment_manager_new_save_chooser (_data_->self, GTK_FILE_CHOOSER_ACTION_SAVE);
	_data_->dialog = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dialog;
	gtk_file_chooser_set_current_name (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, gtk_file_chooser_get_type (), GtkFileChooser), _data_->display_name);
	_data_->destination_uri = NULL;
	_data_->_tmp2_ = _data_->dialog;
	if (gtk_native_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, gtk_native_dialog_get_type (), GtkNativeDialog)) == ((gint) GTK_RESPONSE_ACCEPT)) {
		_data_->_tmp3_ = _data_->dialog;
		_data_->_tmp4_ = gtk_file_chooser_get_uri (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, gtk_file_chooser_get_type (), GtkFileChooser));
		_g_free0 (_data_->destination_uri);
		_data_->destination_uri = _data_->_tmp4_;
	}
	_data_->_tmp5_ = _data_->dialog;
	gtk_native_dialog_destroy (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, gtk_native_dialog_get_type (), GtkNativeDialog));
	_data_->succeeded = FALSE;
	_data_->_tmp6_ = _data_->destination_uri;
	if (!geary_string_is_empty_or_whitespace (_data_->_tmp6_)) {
		_data_->_tmp7_ = _data_->destination_uri;
		_data_->_tmp8_ = g_file_new_for_uri (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_state_ = 1;
		application_attachment_manager_check_and_write (_data_->self, _data_->buffer, _data_->_tmp9_, _data_->cancellable, application_attachment_manager_save_buffer_ready, _data_);
		return FALSE;
		_state_1:
		_data_->succeeded = application_attachment_manager_check_and_write_finish (_data_->self, _data_->_res_);
		_g_object_unref0 (_data_->_tmp9_);
	}
	_data_->result = _data_->succeeded;
	_g_free0 (_data_->destination_uri);
	_g_object_unref0 (_data_->dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_attachment_manager_save_all_data_free (gpointer _data)
{
	ApplicationAttachmentManagerSaveAllData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->attachments);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationAttachmentManagerSaveAllData, _data_);
}

static void
application_attachment_manager_save_all (ApplicationAttachmentManager* self,
                                         GeeCollection* attachments,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	ApplicationAttachmentManagerSaveAllData* _data_;
	ApplicationAttachmentManager* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (APPLICATION_IS_ATTACHMENT_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationAttachmentManagerSaveAllData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_attachment_manager_save_all_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (attachments);
	_g_object_unref0 (_data_->attachments);
	_data_->attachments = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_attachment_manager_save_all_co (_data_);
}

static gboolean
application_attachment_manager_save_all_finish (ApplicationAttachmentManager* self,
                                                GAsyncResult* _res_)
{
	gboolean result;
	ApplicationAttachmentManagerSaveAllData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
application_attachment_manager_save_all_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	ApplicationAttachmentManagerSaveAllData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_attachment_manager_save_all_co (_data_);
}

static gboolean
application_attachment_manager_save_all_co (ApplicationAttachmentManagerSaveAllData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = application_attachment_manager_new_save_chooser (_data_->self, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	_data_->dialog = _data_->_tmp0_;
	_data_->destination_uri = NULL;
	_data_->_tmp1_ = _data_->dialog;
	if (gtk_native_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, gtk_native_dialog_get_type (), GtkNativeDialog)) == ((gint) GTK_RESPONSE_ACCEPT)) {
		_data_->_tmp2_ = _data_->dialog;
		_data_->_tmp3_ = gtk_file_chooser_get_uri (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, gtk_file_chooser_get_type (), GtkFileChooser));
		_g_free0 (_data_->destination_uri);
		_data_->destination_uri = _data_->_tmp3_;
	}
	_data_->_tmp4_ = _data_->dialog;
	gtk_native_dialog_destroy (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, gtk_native_dialog_get_type (), GtkNativeDialog));
	_data_->succeeded = FALSE;
	_data_->_tmp5_ = _data_->destination_uri;
	if (!geary_string_is_empty_or_whitespace (_data_->_tmp5_)) {
		_data_->_tmp6_ = _data_->destination_uri;
		_data_->_tmp7_ = g_file_new_for_uri (_data_->_tmp6_);
		_data_->destination_dir = _data_->_tmp7_;
		{
			_data_->_tmp8_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->attachments, GEE_TYPE_ITERABLE, GeeIterable));
			_data_->_attachment_it = _data_->_tmp8_;
			while (TRUE) {
				_data_->_tmp9_ = _data_->_attachment_it;
				if (!gee_iterator_next (_data_->_tmp9_)) {
					break;
				}
				_data_->_tmp10_ = _data_->_attachment_it;
				_data_->_tmp11_ = gee_iterator_get (_data_->_tmp10_);
				_data_->attachment = (GearyAttachment*) _data_->_tmp11_;
				_data_->destination = NULL;
				{
					_data_->_tmp13_ = _data_->destination_dir;
					_data_->_tmp14_ = _data_->attachment;
					_data_->_tmp15_ = application_attachment_manager_untitled_file_name;
					_data_->_state_ = 1;
					geary_attachment_get_safe_file_name (_data_->_tmp14_, _data_->_tmp15_, application_attachment_manager_save_all_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp16_ = geary_attachment_get_safe_file_name_finish (_data_->_tmp14_, _data_->_res_);
					_data_->_tmp17_ = _data_->_tmp16_;
					_data_->_tmp18_ = g_file_get_child_for_display_name (_data_->_tmp13_, _data_->_tmp17_, &_data_->_inner_error0_);
					_data_->_tmp19_ = _data_->_tmp18_;
					_g_free0 (_data_->_tmp17_);
					_data_->_tmp12_ = _data_->_tmp19_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
							goto __catch0_g_io_error_cancelled;
						}
						goto __catch0_g_error;
					}
					_data_->_tmp20_ = _data_->_tmp12_;
					_data_->_tmp12_ = NULL;
					_g_object_unref0 (_data_->destination);
					_data_->destination = _data_->_tmp20_;
					_g_object_unref0 (_data_->_tmp12_);
				}
				goto __finally0;
				__catch0_g_io_error_cancelled:
				{
					g_clear_error (&_data_->_inner_error0_);
					_data_->succeeded = FALSE;
					_g_object_unref0 (_data_->destination);
					_g_object_unref0 (_data_->attachment);
					break;
				}
				goto __finally0;
				__catch0_g_error:
				{
					_data_->err = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp21_ = _data_->attachment;
					_data_->_tmp22_ = geary_attachment_get_file (_data_->_tmp21_);
					_data_->_tmp23_ = _data_->_tmp22_;
					_data_->_tmp24_ = g_file_get_uri (_data_->_tmp23_);
					_data_->_tmp25_ = _data_->_tmp24_;
					_data_->_tmp26_ = _data_->err;
					_data_->_tmp27_ = _data_->_tmp26_->message;
					g_warning ("application-attachment-manager.vala:133: Error determining file system" \
" name for \"%s\": %s", _data_->_tmp25_, _data_->_tmp27_);
					_g_free0 (_data_->_tmp25_);
					_data_->_tmp28_ = _data_->err;
					application_attachment_manager_handle_error (_data_->self, _data_->_tmp28_);
					_g_error_free0 (_data_->err);
				}
				__finally0:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->destination);
					_g_object_unref0 (_data_->attachment);
					_g_object_unref0 (_data_->_attachment_it);
					_g_object_unref0 (_data_->destination_dir);
					_g_free0 (_data_->destination_uri);
					_g_object_unref0 (_data_->dialog);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp29_ = _data_->attachment;
				_data_->_state_ = 2;
				application_attachment_manager_open_buffer (_data_->self, _data_->_tmp29_, _data_->cancellable, application_attachment_manager_save_all_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp30_ = application_attachment_manager_open_buffer_finish (_data_->self, _data_->_res_);
				_data_->content = _data_->_tmp30_;
				_data_->_tmp32_ = _data_->content;
				if (_data_->_tmp32_ != NULL) {
					_data_->_tmp33_ = _data_->destination;
					_data_->_tmp31_ = _data_->_tmp33_ != NULL;
				} else {
					_data_->_tmp31_ = FALSE;
				}
				if (_data_->_tmp31_) {
					_data_->_tmp34_ = _data_->content;
					_data_->_tmp35_ = _data_->destination;
					_data_->_state_ = 3;
					application_attachment_manager_check_and_write (_data_->self, _data_->_tmp34_, _data_->_tmp35_, _data_->cancellable, application_attachment_manager_save_all_ready, _data_);
					return FALSE;
					_state_3:
					_data_->succeeded &= application_attachment_manager_check_and_write_finish (_data_->self, _data_->_res_);
				} else {
					_data_->succeeded = FALSE;
				}
				_g_object_unref0 (_data_->content);
				_g_object_unref0 (_data_->destination);
				_g_object_unref0 (_data_->attachment);
			}
			_g_object_unref0 (_data_->_attachment_it);
		}
		_g_object_unref0 (_data_->destination_dir);
	}
	_data_->result = _data_->succeeded;
	_g_free0 (_data_->destination_uri);
	_g_object_unref0 (_data_->dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_attachment_manager_open_buffer_data_free (gpointer _data)
{
	ApplicationAttachmentManagerOpenBufferData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationAttachmentManagerOpenBufferData, _data_);
}

static void
application_attachment_manager_open_buffer (ApplicationAttachmentManager* self,
                                            GearyAttachment* attachment,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	ApplicationAttachmentManagerOpenBufferData* _data_;
	ApplicationAttachmentManager* _tmp0_;
	GearyAttachment* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (APPLICATION_IS_ATTACHMENT_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachment, GEARY_TYPE_ATTACHMENT));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationAttachmentManagerOpenBufferData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_attachment_manager_open_buffer_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (attachment);
	_g_object_unref0 (_data_->attachment);
	_data_->attachment = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_attachment_manager_open_buffer_co (_data_);
}

static GearyMemoryBuffer*
application_attachment_manager_open_buffer_finish (ApplicationAttachmentManager* self,
                                                   GAsyncResult* _res_)
{
	GearyMemoryBuffer* result;
	ApplicationAttachmentManagerOpenBufferData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ApplicationAttachmentManager* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->content);
		_g_object_unref0 (_data1_->attachment);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda101_ (Block1Data* _data1_,
               GError** error)
{
	ApplicationAttachmentManager* self;
	GearyMemoryFileBuffer* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GearyMemoryFileBuffer* _tmp3_;
	GearyMemoryFileBuffer* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	_tmp1_ = geary_attachment_get_file (_data1_->attachment);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_memory_file_buffer_new (_tmp2_, TRUE, &_inner_error0_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (_data1_->content);
	_data1_->content = _tmp4_;
	_g_object_unref0 (_tmp0_);
}

static void
____lambda101__geary_nonblocking_concurrent_concurrent_callback (GCancellable* cancellable,
                                                                 gpointer self,
                                                                 GError** error)
{
	___lambda101_ (self, error);
}

static void
application_attachment_manager_open_buffer_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	ApplicationAttachmentManagerOpenBufferData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_attachment_manager_open_buffer_co (_data_);
}

static gboolean
application_attachment_manager_open_buffer_co (ApplicationAttachmentManagerOpenBufferData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data1_->attachment);
	_data_->_data1_->attachment = _data_->attachment;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_data1_->content = NULL;
	{
		_data_->_tmp0_ = geary_nonblocking_concurrent_get_global ();
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_state_ = 1;
		geary_nonblocking_concurrent_schedule_async (_data_->_tmp1_, ____lambda101__geary_nonblocking_concurrent_concurrent_callback, _data_->_data1_, _data_->cancellable, application_attachment_manager_open_buffer_ready, _data_);
		return FALSE;
		_state_1:
		geary_nonblocking_concurrent_schedule_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = geary_attachment_get_file (_data_->_data1_->attachment);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = g_file_get_uri (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = _data_->err;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("application-attachment-manager.vala:164: Error opening attachment file" \
" \"%s\": %s", _data_->_tmp5_, _data_->_tmp7_);
		_g_free0 (_data_->_tmp5_);
		_data_->_tmp8_ = _data_->err;
		application_attachment_manager_handle_error (_data_->self, _data_->_tmp8_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_data1_->content, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
	_data_->result = _data_->_tmp9_;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_attachment_manager_check_and_write_data_free (gpointer _data)
{
	ApplicationAttachmentManagerCheckAndWriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->content);
	_g_object_unref0 (_data_->destination);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationAttachmentManagerCheckAndWriteData, _data_);
}

static void
application_attachment_manager_check_and_write (ApplicationAttachmentManager* self,
                                                GearyMemoryBuffer* content,
                                                GFile* destination,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	ApplicationAttachmentManagerCheckAndWriteData* _data_;
	ApplicationAttachmentManager* _tmp0_;
	GearyMemoryBuffer* _tmp1_;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (APPLICATION_IS_ATTACHMENT_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (content, GEARY_MEMORY_TYPE_BUFFER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (destination, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationAttachmentManagerCheckAndWriteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_attachment_manager_check_and_write_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (content);
	_g_object_unref0 (_data_->content);
	_data_->content = _tmp1_;
	_tmp2_ = _g_object_ref0 (destination);
	_g_object_unref0 (_data_->destination);
	_data_->destination = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	application_attachment_manager_check_and_write_co (_data_);
}

static gboolean
application_attachment_manager_check_and_write_finish (ApplicationAttachmentManager* self,
                                                       GAsyncResult* _res_)
{
	gboolean result;
	ApplicationAttachmentManagerCheckAndWriteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
application_attachment_manager_check_and_write_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	ApplicationAttachmentManagerCheckAndWriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_attachment_manager_check_and_write_co (_data_);
}

static gboolean
application_attachment_manager_check_and_write_co (ApplicationAttachmentManagerCheckAndWriteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->succeeded = FALSE;
	{
		_data_->_state_ = 1;
		application_attachment_manager_check_overwrite (_data_->self, _data_->destination, _data_->cancellable, application_attachment_manager_check_and_write_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = application_attachment_manager_check_overwrite_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_data_->_tmp0_) {
			_data_->_state_ = 2;
			application_attachment_manager_write_buffer_to_file (_data_->self, _data_->content, _data_->destination, _data_->cancellable, application_attachment_manager_check_and_write_ready, _data_);
			return FALSE;
			_state_2:
			application_attachment_manager_write_buffer_to_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->succeeded = TRUE;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp1_ = g_file_get_uri (_data_->destination);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = _data_->err;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("application-attachment-manager.vala:183: Error saving attachment \"%s\"" \
": %s", _data_->_tmp2_, _data_->_tmp4_);
		_g_free0 (_data_->_tmp2_);
		_data_->_tmp5_ = _data_->err;
		application_attachment_manager_handle_error (_data_->self, _data_->_tmp5_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->succeeded;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_attachment_manager_check_overwrite_data_free (gpointer _data)
{
	ApplicationAttachmentManagerCheckOverwriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->to_overwrite);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationAttachmentManagerCheckOverwriteData, _data_);
}

static void
application_attachment_manager_check_overwrite (ApplicationAttachmentManager* self,
                                                GFile* to_overwrite,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	ApplicationAttachmentManagerCheckOverwriteData* _data_;
	ApplicationAttachmentManager* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (APPLICATION_IS_ATTACHMENT_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_overwrite, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationAttachmentManagerCheckOverwriteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_attachment_manager_check_overwrite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (to_overwrite);
	_g_object_unref0 (_data_->to_overwrite);
	_data_->to_overwrite = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	application_attachment_manager_check_overwrite_co (_data_);
}

static gboolean
application_attachment_manager_check_overwrite_finish (ApplicationAttachmentManager* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	gboolean result;
	ApplicationAttachmentManagerCheckOverwriteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
application_attachment_manager_check_overwrite_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	ApplicationAttachmentManagerCheckOverwriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_attachment_manager_check_overwrite_co (_data_);
}

static gboolean
application_attachment_manager_check_overwrite_co (ApplicationAttachmentManagerCheckOverwriteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("");
	_data_->target_name = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup ("");
	_data_->parent_name = _data_->_tmp1_;
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->to_overwrite, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->cancellable, application_attachment_manager_check_overwrite_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = g_file_query_info_finish (_data_->to_overwrite, _data_->_res_, &_data_->_inner_error0_);
		_data_->file_info = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch0_g_io_error_not_found;
			}
			goto __finally0;
		}
		_data_->_tmp3_ = _data_->file_info;
		_data_->_tmp4_ = g_file_info_get_display_name (_data_->_tmp3_);
		_data_->_tmp5_ = g_strdup (_data_->_tmp4_);
		_g_free0 (_data_->target_name);
		_data_->target_name = _data_->_tmp5_;
		_data_->_tmp6_ = g_file_get_parent (_data_->to_overwrite);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_state_ = 2;
		g_file_query_info_async (_data_->_tmp7_, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->cancellable, application_attachment_manager_check_overwrite_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = g_file_query_info_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_g_object_unref0 (_data_->_tmp7_);
		_data_->parent_info = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->file_info);
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				goto __catch0_g_io_error_not_found;
			}
			goto __finally0;
		}
		_data_->_tmp10_ = _data_->parent_info;
		_data_->_tmp11_ = g_file_info_get_display_name (_data_->_tmp10_);
		_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
		_g_free0 (_data_->parent_name);
		_data_->parent_name = _data_->_tmp12_;
		_g_object_unref0 (_data_->parent_info);
		_g_object_unref0 (_data_->file_info);
	}
	goto __finally0;
	__catch0_g_io_error_not_found:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = TRUE;
		_g_free0 (_data_->parent_name);
		_g_free0 (_data_->target_name);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->parent_name);
		_g_free0 (_data_->target_name);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->target_name;
	_data_->_tmp14_ = g_strdup_printf (_ ("A file named “%s” already exists.  Do you want to replace it?"), _data_->_tmp13_);
	_data_->primary = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->parent_name;
	_data_->_tmp16_ = g_strdup_printf (_ ("The file already exists in “%s”.  Replacing it will overwrite its cont" \
"ents."), _data_->_tmp15_);
	_data_->secondary = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->self->priv->parent;
	_data_->_tmp18_ = _data_->primary;
	_data_->_tmp19_ = _data_->secondary;
	_data_->_tmp20_ = confirmation_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, gtk_window_get_type (), GtkWindow), _data_->_tmp18_, _data_->_tmp19_, _ ("_Replace"), "destructive-action");
	_data_->dialog = _data_->_tmp20_;
	_data_->_tmp21_ = _data_->dialog;
	_data_->result = alert_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, TYPE_ALERT_DIALOG, AlertDialog)) == GTK_RESPONSE_OK;
	_g_object_unref0 (_data_->dialog);
	_g_free0 (_data_->secondary);
	_g_free0 (_data_->primary);
	_g_free0 (_data_->parent_name);
	_g_free0 (_data_->target_name);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_attachment_manager_write_buffer_to_file_data_free (gpointer _data)
{
	ApplicationAttachmentManagerWriteBufferToFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->buffer);
	_g_object_unref0 (_data_->destination);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationAttachmentManagerWriteBufferToFileData, _data_);
}

static void
application_attachment_manager_write_buffer_to_file (ApplicationAttachmentManager* self,
                                                     GearyMemoryBuffer* buffer,
                                                     GFile* destination,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	ApplicationAttachmentManagerWriteBufferToFileData* _data_;
	ApplicationAttachmentManager* _tmp0_;
	GearyMemoryBuffer* _tmp1_;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (APPLICATION_IS_ATTACHMENT_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (buffer, GEARY_MEMORY_TYPE_BUFFER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (destination, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationAttachmentManagerWriteBufferToFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_attachment_manager_write_buffer_to_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (buffer);
	_g_object_unref0 (_data_->buffer);
	_data_->buffer = _tmp1_;
	_tmp2_ = _g_object_ref0 (destination);
	_g_object_unref0 (_data_->destination);
	_data_->destination = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	application_attachment_manager_write_buffer_to_file_co (_data_);
}

static void
application_attachment_manager_write_buffer_to_file_finish (ApplicationAttachmentManager* self,
                                                            GAsyncResult* _res_,
                                                            GError** error)
{
	ApplicationAttachmentManagerWriteBufferToFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
application_attachment_manager_write_buffer_to_file_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	ApplicationAttachmentManagerWriteBufferToFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_attachment_manager_write_buffer_to_file_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
application_attachment_manager_write_buffer_to_file_co (ApplicationAttachmentManagerWriteBufferToFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = g_file_replace (_data_->destination, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, _data_->cancellable, &_data_->_inner_error0_);
		_data_->outs = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __finally0;
		}
		_data_->_tmp1_ = _data_->outs;
		_data_->_tmp2_ = geary_memory_buffer_get_input_stream (_data_->buffer);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_state_ = 1;
		g_output_stream_splice_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, g_output_stream_get_type (), GOutputStream), _data_->_tmp3_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, G_PRIORITY_DEFAULT, _data_->cancellable, application_attachment_manager_write_buffer_to_file_ready, _data_);
		return FALSE;
		_state_1:
		g_output_stream_splice_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, g_output_stream_get_type (), GOutputStream), _data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp3_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->outs);
			if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __finally0;
		}
		_g_object_unref0 (_data_->outs);
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		{
			_data_->_state_ = 2;
			g_file_delete_async (_data_->destination, G_PRIORITY_HIGH, NULL, application_attachment_manager_write_buffer_to_file_ready, _data_);
			return FALSE;
			_state_2:
			g_file_delete_finish (_data_->destination, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_error_free0 (_data_->err);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp4_ = _data_->err;
		_data_->_tmp5_ = _g_error_copy0 (_data_->_tmp4_);
		_data_->_inner_error0_ = _data_->_tmp5_;
		_g_error_free0 (_data_->err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static inline GtkFileChooserNative*
application_attachment_manager_new_save_chooser (ApplicationAttachmentManager* self,
                                                 GtkFileChooserAction action)
{
	GtkFileChooserNative* dialog = NULL;
	ApplicationMainWindow* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	gchar* download_dir = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkFileChooserNative* _tmp7_;
	GtkFileChooserNative* result;
	g_return_val_if_fail (APPLICATION_IS_ATTACHMENT_MANAGER (self), NULL);
	_tmp0_ = self->priv->parent;
	_tmp1_ = gtk_file_chooser_native_new (NULL, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), action, STOCK__SAVE, STOCK__CANCEL);
	dialog = _tmp1_;
	_tmp2_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
	_tmp3_ = g_strdup (_tmp2_);
	download_dir = _tmp3_;
	_tmp4_ = download_dir;
	if (!geary_string_is_empty_or_whitespace (_tmp4_)) {
		GtkFileChooserNative* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = dialog;
		_tmp6_ = download_dir;
		gtk_file_chooser_set_current_folder (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_file_chooser_get_type (), GtkFileChooser), _tmp6_);
	}
	_tmp7_ = dialog;
	gtk_file_chooser_set_local_only (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_file_chooser_get_type (), GtkFileChooser), FALSE);
	result = dialog;
	_g_free0 (download_dir);
	return result;
}

static inline void
application_attachment_manager_handle_error (ApplicationAttachmentManager* self,
                                             GError* _error_)
{
	ApplicationMainWindow* _tmp0_;
	ApplicationClient* _tmp1_;
	ApplicationClient* _tmp2_;
	ApplicationController* _tmp3_;
	ApplicationController* _tmp4_;
	GearyProblemReport* _tmp5_;
	GearyProblemReport* _tmp6_;
	g_return_if_fail (APPLICATION_IS_ATTACHMENT_MANAGER (self));
	g_return_if_fail (_error_ != NULL);
	_tmp0_ = self->priv->parent;
	_tmp1_ = application_main_window_get_application (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = application_client_get_controller (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_problem_report_new (_error_);
	_tmp6_ = _tmp5_;
	composer_application_interface_report_problem (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, COMPOSER_TYPE_APPLICATION_INTERFACE, ComposerApplicationInterface), _tmp6_);
	_g_object_unref0 (_tmp6_);
}

static void
application_attachment_manager_class_init (ApplicationAttachmentManagerClass * klass,
                                           gpointer klass_data)
{
	gchar* _tmp0_;
	application_attachment_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationAttachmentManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = application_attachment_manager_finalize;
	_tmp0_ = g_strdup (_ ("Untitled"));
	_g_free0 (application_attachment_manager_untitled_file_name);
	application_attachment_manager_untitled_file_name = _tmp0_;
}

static void
application_attachment_manager_instance_init (ApplicationAttachmentManager * self,
                                              gpointer klass)
{
	self->priv = application_attachment_manager_get_instance_private (self);
}

static void
application_attachment_manager_finalize (GObject * obj)
{
	ApplicationAttachmentManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_ATTACHMENT_MANAGER, ApplicationAttachmentManager);
	G_OBJECT_CLASS (application_attachment_manager_parent_class)->finalize (obj);
}

static GType
application_attachment_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationAttachmentManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_attachment_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationAttachmentManager), 0, (GInstanceInitFunc) application_attachment_manager_instance_init, NULL };
	GType application_attachment_manager_type_id;
	application_attachment_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ApplicationAttachmentManager", &g_define_type_info, 0);
	ApplicationAttachmentManager_private_offset = g_type_add_instance_private (application_attachment_manager_type_id, sizeof (ApplicationAttachmentManagerPrivate));
	return application_attachment_manager_type_id;
}

GType
application_attachment_manager_get_type (void)
{
	static volatile gsize application_attachment_manager_type_id__once = 0;
	if (g_once_init_enter (&application_attachment_manager_type_id__once)) {
		GType application_attachment_manager_type_id;
		application_attachment_manager_type_id = application_attachment_manager_get_type_once ();
		g_once_init_leave (&application_attachment_manager_type_id__once, application_attachment_manager_type_id);
	}
	return application_attachment_manager_type_id__once;
}

